/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5833")
public class AssertJContextBeforeAssertionCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofSubTypes("org.assertj.core.api.AbstractAssert").name(name -> "as".equals(name) || "describedAs".equals(name) || "withFailMessage".equals(name) || "overridingErrorMessage".equals(name) || "extracting".equals(name) || name.startsWith("using") || name.startsWith("filtered")).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (AssertJContextBeforeAssertionCheck.isLastCallInStatement(mit)) {
            this.reportIssue(ExpressionUtils.methodName(mit), "Add an assertion predicate after calling this method.");
        }
    }

    private static boolean isLastCallInStatement(MethodInvocationTree mit) {
        Tree parent = mit.parent();
        return parent != null && parent.is(Tree.Kind.EXPRESSION_STATEMENT);
    }
}

