/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jdt.core.dom.ASTUtils;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodTree;

final class JMethodSymbol
extends JSymbol
implements Symbol.MethodSymbol {
    private List<Type> parameterTypes;
    private Symbol.TypeSymbol returnType;
    private List<Type> thrownTypes;
    private List<Symbol.MethodSymbol> overriddenSymbols;
    private Symbol.MethodSymbol firstOverridenSymbol;
    private final String signature = this.methodBinding().getDeclaringClass().getBinaryName() + "#" + this.name() + ASTUtils.signature(this.methodBinding().getMethodDeclaration());

    JMethodSymbol(JSema sema, IMethodBinding methodBinding) {
        super(sema, methodBinding);
    }

    IMethodBinding methodBinding() {
        return (IMethodBinding)this.binding;
    }

    @Override
    public List<Type> parameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = this.sema.types(this.methodBinding().getParameterTypes());
        }
        return this.parameterTypes;
    }

    @Override
    public Symbol.TypeSymbol returnType() {
        if (this.returnType == null) {
            this.returnType = this.sema.typeSymbol(this.methodBinding().getReturnType());
        }
        return this.returnType;
    }

    @Override
    public List<Type> thrownTypes() {
        if (this.thrownTypes == null) {
            this.thrownTypes = this.sema.types(this.methodBinding().getExceptionTypes());
        }
        return this.thrownTypes;
    }

    @Override
    @Nullable
    public Symbol.MethodSymbol overriddenSymbol() {
        if (this.overriddenSymbols == null) {
            this.overriddenSymbols();
        }
        return this.firstOverridenSymbol;
    }

    @Override
    public List<Symbol.MethodSymbol> overriddenSymbols() {
        if (this.overriddenSymbols == null) {
            this.overriddenSymbols = this.findOverriddenSymbols();
            if (!this.overriddenSymbols.isEmpty()) {
                this.firstOverridenSymbol = this.overriddenSymbols.get(0);
            }
        }
        return this.overriddenSymbols;
    }

    private List<Symbol.MethodSymbol> findOverriddenSymbols() {
        LinkedHashSet<Symbol.MethodSymbol> results = new LinkedHashSet<Symbol.MethodSymbol>();
        IMethodBinding methodBinding = this.methodBinding();
        this.findOverridesInParentTypes(results, methodBinding::overrides, methodBinding.getDeclaringClass());
        return new ArrayList<Symbol.MethodSymbol>(results);
    }

    @VisibleForTesting
    void findOverridesInParentTypes(Collection<Symbol.MethodSymbol> accumulator, Predicate<IMethodBinding> overridesCondition, ITypeBinding type) {
        if (type.isInterface()) {
            this.findOverridesInTypes(accumulator, overridesCondition, this.sema.resolveType("java.lang.Object"));
        } else if (!"java.lang.Object".equals(type.getQualifiedName())) {
            this.findOverridesInTypes(accumulator, overridesCondition, type.getSuperclass());
        }
        this.findOverridesInTypes(accumulator, overridesCondition, type.getInterfaces());
    }

    private void findOverridesInTypes(Collection<Symbol.MethodSymbol> accumulator, Predicate<IMethodBinding> overridesCondition, ITypeBinding ... types) {
        for (ITypeBinding type : types) {
            if (type == null) continue;
            Stream.of(type.getDeclaredMethods()).filter(overridesCondition).findFirst().map(this.sema::methodSymbol).ifPresent(accumulator::add);
            this.findOverridesInParentTypes(accumulator, overridesCondition, type);
        }
    }

    @Override
    public String signature() {
        return this.signature;
    }

    @Override
    @Nullable
    public MethodTree declaration() {
        return (MethodTree)super.declaration();
    }
}

