/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.plugins.PluginType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PluginInfo
implements Writeable,
ToXContentObject {
    public static final String ES_PLUGIN_PROPERTIES = "plugin-descriptor.properties";
    public static final String ES_PLUGIN_POLICY = "plugin-security.policy";
    private static final Version LICENSED_PLUGINS_SUPPORT = Version.V_7_11_0;
    private final String name;
    private final String description;
    private final String version;
    private final Version elasticsearchVersion;
    private final String javaVersion;
    private final String classname;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;
    private final PluginType type;
    private final String javaOpts;
    private final boolean isLicensed;

    public PluginInfo(String name, String description, String version, Version elasticsearchVersion, String javaVersion, String classname, List<String> extendedPlugins, boolean hasNativeController, PluginType type, String javaOpts, boolean isLicensed) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.elasticsearchVersion = elasticsearchVersion;
        this.javaVersion = javaVersion;
        this.classname = classname;
        this.extendedPlugins = Collections.unmodifiableList(extendedPlugins);
        this.hasNativeController = hasNativeController;
        this.type = type;
        this.javaOpts = javaOpts;
        this.isLicensed = isLicensed;
    }

    public PluginInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.version = in.readString();
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.elasticsearchVersion = Version.readVersion(in);
            this.javaVersion = in.readString();
        } else {
            this.elasticsearchVersion = in.getVersion();
            this.javaVersion = "1.8";
        }
        this.classname = in.readString();
        this.extendedPlugins = in.getVersion().onOrAfter(Version.V_6_2_0) ? in.readStringList() : Collections.emptyList();
        this.hasNativeController = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_6_0_0_beta2) && in.getVersion().before(Version.V_6_3_0)) {
            in.readBoolean();
        }
        if (in.getVersion().onOrAfter(LICENSED_PLUGINS_SUPPORT)) {
            this.type = PluginType.valueOf(in.readString());
            this.javaOpts = in.readOptionalString();
            this.isLicensed = in.readBoolean();
        } else {
            this.type = PluginType.ISOLATED;
            this.javaOpts = null;
            this.isLicensed = false;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.version);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            Version.writeVersion(this.elasticsearchVersion, out);
            out.writeString(this.javaVersion);
        }
        out.writeString(this.classname);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeStringCollection(this.extendedPlugins);
        }
        out.writeBoolean(this.hasNativeController);
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta2) && out.getVersion().before(Version.V_6_3_0)) {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(LICENSED_PLUGINS_SUPPORT)) {
            out.writeString(this.type.name());
            out.writeOptionalString(this.javaOpts);
            out.writeBoolean(this.isLicensed);
        }
    }

    public static PluginInfo readFromProperties(Path path) throws IOException {
        Path descriptor = path.resolve(ES_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        String name = propsMap.remove("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("property [name] is missing in [" + descriptor + "]");
        }
        String description = propsMap.remove("description");
        if (description == null) {
            throw new IllegalArgumentException("property [description] is missing for plugin [" + name + "]");
        }
        String version = propsMap.remove("version");
        if (version == null) {
            throw new IllegalArgumentException("property [version] is missing for plugin [" + name + "]");
        }
        String esVersionString = propsMap.remove("elasticsearch.version");
        if (esVersionString == null) {
            throw new IllegalArgumentException("property [elasticsearch.version] is missing for plugin [" + name + "]");
        }
        Version esVersion = Version.fromString(esVersionString);
        String javaVersionString = propsMap.remove("java.version");
        if (javaVersionString == null) {
            throw new IllegalArgumentException("property [java.version] is missing for plugin [" + name + "]");
        }
        JarHell.checkVersionFormat((String)javaVersionString);
        String extendedString = propsMap.remove("extended.plugins");
        List<Object> extendedPlugins = extendedString == null ? Collections.emptyList() : Arrays.asList(Strings.delimitedListToStringArray(extendedString, ","));
        boolean hasNativeController = PluginInfo.parseBooleanValue(name, "has.native.controller", propsMap.remove("has.native.controller"));
        PluginType type = PluginInfo.getPluginType(name, propsMap.remove("type"));
        String classname = PluginInfo.getClassname(name, type, propsMap.remove("classname"));
        String javaOpts = propsMap.remove("java.opts");
        if (type != PluginType.BOOTSTRAP && !Strings.isNullOrEmpty(javaOpts)) {
            throw new IllegalArgumentException("[java.opts] can only have a value when [type] is set to [bootstrap] for plugin [" + name + "]");
        }
        if (esVersion.before(Version.V_6_3_0) && esVersion.onOrAfter(Version.V_6_0_0_beta2)) {
            propsMap.remove("requires.keystore");
        }
        boolean isLicensed = false;
        if (esVersion.onOrAfter(LICENSED_PLUGINS_SUPPORT)) {
            isLicensed = PluginInfo.parseBooleanValue(name, "licensed", propsMap.remove("licensed"));
        }
        if (!propsMap.isEmpty()) {
            throw new IllegalArgumentException("Unknown properties for plugin [" + name + "] in plugin descriptor: " + propsMap.keySet());
        }
        return new PluginInfo(name, description, version, esVersion, javaVersionString, classname, extendedPlugins, hasNativeController, type, javaOpts, isLicensed);
    }

    private static PluginType getPluginType(String name, String rawType) {
        if (Strings.isNullOrEmpty(rawType)) {
            return PluginType.ISOLATED;
        }
        try {
            return PluginType.valueOf(rawType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("[type] must be unspecified or one of [isolated, bootstrap] but found [" + rawType + "] for plugin [" + name + "]");
        }
    }

    private static String getClassname(String name, PluginType type, String classname) {
        if (type == PluginType.BOOTSTRAP) {
            if (!Strings.isNullOrEmpty(classname)) {
                throw new IllegalArgumentException("property [classname] can only have a value when [type] is set to [bootstrap] for plugin [" + name + "]");
            }
            return "";
        }
        if (classname == null) {
            throw new IllegalArgumentException("property [classname] is missing for plugin [" + name + "]");
        }
        return classname;
    }

    private static boolean parseBooleanValue(String pluginName, String name, String rawValue) {
        try {
            return Booleans.parseBoolean((String)rawValue, (boolean)false);
        }
        catch (IllegalArgumentException e) {
            String message = String.format(Locale.ROOT, "property [%s] must be [true], [false], or unspecified but was [%s] for plugin [%s]", name, rawValue, pluginName);
            throw new IllegalArgumentException(message);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassname() {
        return this.classname;
    }

    public List<String> getExtendedPlugins() {
        return this.extendedPlugins;
    }

    public String getVersion() {
        return this.version;
    }

    public Version getElasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public boolean hasNativeController() {
        return this.hasNativeController;
    }

    public PluginType getType() {
        return this.type;
    }

    public String getJavaOpts() {
        return this.javaOpts;
    }

    public boolean isLicensed() {
        return this.isLicensed;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("version", this.version);
        builder.field("elasticsearch_version", (ToXContent)this.elasticsearchVersion);
        builder.field("java_version", this.javaVersion);
        builder.field("description", this.description);
        builder.field("classname", this.classname);
        builder.field("extended_plugins", this.extendedPlugins);
        builder.field("has_native_controller", this.hasNativeController);
        builder.field("licensed", this.isLicensed);
        builder.field("type", (Enum)this.type);
        if (this.type == PluginType.BOOTSTRAP) {
            builder.field("java_opts", this.javaOpts);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder information = new StringBuilder().append(prefix).append("- Plugin information:\n").append(prefix).append("Name: ").append(this.name).append("\n").append(prefix).append("Description: ").append(this.description).append("\n").append(prefix).append("Version: ").append(this.version).append("\n").append(prefix).append("Elasticsearch Version: ").append(this.elasticsearchVersion).append("\n").append(prefix).append("Java Version: ").append(this.javaVersion).append("\n").append(prefix).append("Native Controller: ").append(this.hasNativeController).append("\n").append(prefix).append("Licensed: ").append(this.isLicensed).append("\n").append(prefix).append("Type: ").append((Object)this.type).append("\n");
        if (this.type == PluginType.BOOTSTRAP) {
            information.append(prefix).append("Java Opts: ").append(this.javaOpts).append("\n");
        }
        information.append(prefix).append("Extended Plugins: ").append(this.extendedPlugins).append("\n").append(prefix).append(" * Classname: ").append(this.classname);
        return information.toString();
    }
}

