/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.checks.api.CheckContext;
import org.sonarsource.slang.checks.api.InitContext;
import org.sonarsource.slang.checks.api.SlangCheck;
import org.sonarsource.slang.impl.TextRanges;

@Rule(key="S2757")
public class WrongAssignmentOperatorCheck
implements SlangCheck {
    private static final List<UnaryExpressionTree.Operator> SUSPICIOUS_UNARY_OPERATORS = Arrays.asList(UnaryExpressionTree.Operator.NEGATE, UnaryExpressionTree.Operator.PLUS, UnaryExpressionTree.Operator.MINUS);

    @Override
    public void initialize(InitContext init) {
        init.register(AssignmentExpressionTree.class, (ctx, assignment) -> {
            Token expressionFirstToken;
            Tree rightHandSide = assignment.statementOrExpression();
            if (assignment.operator() != AssignmentExpressionTree.Operator.EQUAL || !WrongAssignmentOperatorCheck.isSuspiciousUnaryExpression(rightHandSide)) {
                return;
            }
            List<Token> leftHandSideTokens = assignment.leftHandSide().metaData().tokens();
            Token variableLastToken = leftHandSideTokens.get(leftHandSideTokens.size() - 1);
            List<Token> allTokens = assignment.metaData().tokens();
            Token operatorToken = allTokens.get(allTokens.indexOf(variableLastToken) + 1);
            if (!WrongAssignmentOperatorCheck.hasSpacingBetween(operatorToken, expressionFirstToken = rightHandSide.metaData().tokens().get(0)) && WrongAssignmentOperatorCheck.hasSpacingBetween(variableLastToken, operatorToken)) {
                TextRange range = TextRanges.merge(Arrays.asList(operatorToken.textRange(), expressionFirstToken.textRange()));
                ctx.reportIssue(range, WrongAssignmentOperatorCheck.getMessage(expressionFirstToken, ctx));
            }
        });
    }

    private static String getMessage(Token expressionFirstToken, CheckContext aeTree) {
        if (WrongAssignmentOperatorCheck.isSingleNegationAssignment(expressionFirstToken, aeTree)) {
            return "Add a space between \"=\" and \"!\" to avoid confusion.";
        }
        return "Was \"" + expressionFirstToken.text() + "=\" meant instead?";
    }

    private static boolean isSingleNegationAssignment(Token firstToken, CheckContext aeTree) {
        return "!".equals(firstToken.text()) && !(aeTree.parent() instanceof AssignmentExpressionTree);
    }

    private static boolean hasSpacingBetween(Token firstToken, Token secondToken) {
        return firstToken.textRange().end().line() != secondToken.textRange().start().line() || firstToken.textRange().end().lineOffset() != secondToken.textRange().start().lineOffset();
    }

    private static boolean isSuspiciousUnaryExpression(Tree tree) {
        return tree instanceof UnaryExpressionTree && SUSPICIOUS_UNARY_OPERATORS.contains((Object)((UnaryExpressionTree)tree).operator());
    }
}

