/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.maven;

import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="S3420")
@DeprecatedRuleKey(repositoryKey="java", ruleKey="S3420")
public class ArtifactIdNamingConventionCheck
extends SimpleXPathBasedCheck {
    public static final String KEY = "S3420";
    private static final String DEFAULT_REGEX = "[a-z][a-z-0-9]+";
    @RuleProperty(key="regex", description="The regular expression the \"artifactId\" should match", defaultValue="[a-z][a-z-0-9]+")
    public String regex = "[a-z][a-z-0-9]+";
    private XPathExpression artifactIdExpression = this.getXPathExpression("project/artifactId");
    private Pattern pattern = null;

    @Override
    public void scanFile(XmlFile file) {
        if (!"pom.xml".equalsIgnoreCase(file.getInputFile().filename())) {
            return;
        }
        NodeList artifactIds = this.evaluate(this.artifactIdExpression, file.getNamespaceUnawareDocument());
        if (artifactIds == null || artifactIds.getLength() != 1) {
            return;
        }
        Node artifactId = artifactIds.item(0);
        if (!this.getPattern().matcher(artifactId.getTextContent()).matches()) {
            this.reportIssue(artifactId, "Update this \"artifactId\" to match the provided regular expression: '" + this.regex + "'");
        }
    }

    private Pattern getPattern() {
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(this.regex, 32);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[S3420] Unable to compile the regular expression: " + this.regex, e);
            }
        }
        return this.pattern;
    }
}

