/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.xml;

import org.sonarsource.analyzer.commons.xml.XmlFilePosition;

public class XmlTextRange {
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;

    public XmlTextRange(int startLine, int startColumn, int endLine, int endColumn) {
        if (startLine > endLine) {
            throw new IllegalArgumentException("Cannot have a start line after end line");
        }
        if (startLine == endLine && startColumn > endColumn) {
            throw new IllegalArgumentException("Cannot have a start column after end column when on same line");
        }
        if (startLine == endLine && startColumn == endColumn) {
            throw new IllegalArgumentException("Cannot have an empty range");
        }
        if (startLine < 1 || endLine < 1) {
            throw new IllegalArgumentException("Cannot have a line less than 1");
        }
        if (startColumn < 0 || endColumn < 0) {
            throw new IllegalArgumentException("Cannot have a line less than 1");
        }
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    XmlTextRange(XmlFilePosition start, XmlFilePosition end, XmlFilePosition xmlStart) {
        this(start.computeSqLine(xmlStart), start.computeSqColumn(xmlStart), end.computeSqLine(xmlStart), end.computeSqColumn(xmlStart));
    }

    XmlTextRange(XmlTextRange start, XmlFilePosition end, XmlFilePosition xmlStart) {
        this(start.startLine, start.startColumn, end.computeSqLine(xmlStart), end.computeSqColumn(xmlStart));
    }

    public XmlTextRange(XmlTextRange start, XmlTextRange end) {
        this(start.startLine, start.startColumn, end.endLine, end.endColumn);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String toString() {
        return "{" + this.startLine + ":" + this.startColumn + " - " + this.endLine + ":" + this.endColumn + "}";
    }
}

