/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class PythonVersionUtils {
    private static final Map<String, Version> STRING_VERSION_MAP = new HashMap<String, Version>();
    private static final Version MIN_SUPPORTED_VERSION;
    private static final Version MAX_SUPPORTED_VERSION;
    private static final Logger LOG;
    public static final String PYTHON_VERSION_KEY = "sonar.python.version";

    private PythonVersionUtils() {
    }

    public static Set<Version> fromString(String propertyValue) {
        String[] versions = propertyValue.split(",");
        if (versions.length == 0) {
            return PythonVersionUtils.allVersions();
        }
        EnumSet<Version> pythonVersions = EnumSet.noneOf(Version.class);
        for (String versionValue : versions) {
            Version version = STRING_VERSION_MAP.get(versionValue = versionValue.trim());
            if (version != null) {
                pythonVersions.add(version);
                continue;
            }
            boolean isGuessSuccessful = PythonVersionUtils.guessPythonVersion(pythonVersions, versionValue);
            if (isGuessSuccessful) continue;
            return PythonVersionUtils.allVersions();
        }
        return pythonVersions;
    }

    public static Set<Version> allVersions() {
        return EnumSet.allOf(Version.class);
    }

    private static boolean guessPythonVersion(Set<Version> pythonVersions, String versionValue) {
        block5: {
            String[] version = versionValue.split("\\.");
            try {
                int major = Integer.parseInt(version[0]);
                int minor = version.length > 1 ? Integer.parseInt(version[1]) : 0;
                Version guessedVersion = STRING_VERSION_MAP.get(major + "." + minor);
                if (guessedVersion != null) {
                    pythonVersions.add(guessedVersion);
                    PythonVersionUtils.logWarningGuessVersion(versionValue, guessedVersion);
                    return true;
                }
                if (MIN_SUPPORTED_VERSION.compare(major, minor) > 0) {
                    pythonVersions.add(MIN_SUPPORTED_VERSION);
                    PythonVersionUtils.logWarningGuessVersion(versionValue, MIN_SUPPORTED_VERSION);
                    break block5;
                }
                if (MAX_SUPPORTED_VERSION.compare(major, minor) < 0) {
                    pythonVersions.add(MAX_SUPPORTED_VERSION);
                    PythonVersionUtils.logWarningGuessVersion(versionValue, MAX_SUPPORTED_VERSION);
                    break block5;
                }
                PythonVersionUtils.logErrorMessage(versionValue);
                return false;
            }
            catch (NumberFormatException nfe) {
                PythonVersionUtils.logErrorMessage(versionValue);
                return false;
            }
        }
        return true;
    }

    private static void logErrorMessage(String propertyValue) {
        String prefix = "Error while parsing value of parameter '%s' (%s). Versions must be specified as MAJOR_VERSION.MIN.VERSION (e.g. \"3.7, 3.8\")";
        LOG.warn(String.format(Locale.ROOT, prefix, PYTHON_VERSION_KEY, propertyValue));
    }

    private static void logWarningGuessVersion(String propertyValue, Version guessedVersion) {
        String prefix = "No explicit support for version %s. Python version has been set to %s.";
        LOG.warn(String.format(Locale.ROOT, prefix, new Object[]{propertyValue, guessedVersion}));
    }

    static {
        STRING_VERSION_MAP.put("2", Version.V_27);
        STRING_VERSION_MAP.put("2.7", Version.V_27);
        STRING_VERSION_MAP.put("3", Version.V_35);
        STRING_VERSION_MAP.put("3.0", Version.V_35);
        STRING_VERSION_MAP.put("3.1", Version.V_35);
        STRING_VERSION_MAP.put("3.2", Version.V_35);
        STRING_VERSION_MAP.put("3.3", Version.V_35);
        STRING_VERSION_MAP.put("3.4", Version.V_35);
        STRING_VERSION_MAP.put("3.5", Version.V_35);
        STRING_VERSION_MAP.put("3.6", Version.V_36);
        STRING_VERSION_MAP.put("3.7", Version.V_37);
        STRING_VERSION_MAP.put("3.8", Version.V_38);
        STRING_VERSION_MAP.put("3.9", Version.V_39);
        STRING_VERSION_MAP.put("3.10", Version.V_310);
        MIN_SUPPORTED_VERSION = Version.V_27;
        MAX_SUPPORTED_VERSION = Version.V_310;
        LOG = Loggers.get(PythonVersionUtils.class);
    }

    public static enum Version {
        V_27(2, 7, "27"),
        V_35(3, 5, "35"),
        V_36(3, 6, "36"),
        V_37(3, 7, "37"),
        V_38(3, 8, "38"),
        V_39(3, 9, "39"),
        V_310(3, 10, "310");

        private final int major;
        private final int minor;
        private final String serializedValue;

        private Version(int major, int minor, String serializedValue) {
            this.major = major;
            this.minor = minor;
            this.serializedValue = serializedValue;
        }

        public int major() {
            return this.major;
        }

        public int minor() {
            return this.minor;
        }

        public String serializedValue() {
            return this.serializedValue;
        }

        public int compare(int major, int minor) {
            if (this.major() == major) {
                return Integer.compare(this.minor(), minor);
            }
            return Integer.compare(this.major(), major);
        }

        public String toString() {
            return this.major + "." + this.minor;
        }
    }
}

