/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.python.tree.PyTree;

public class YieldExpressionImpl
extends PyTree
implements YieldExpression {
    private final Token yieldKeyword;
    private final Token fromKeyword;
    private final List<Expression> expressionTrees;

    public YieldExpressionImpl(Token yieldKeyword, @Nullable Token fromKeyword, List<Expression> expressionTrees) {
        this.yieldKeyword = yieldKeyword;
        this.fromKeyword = fromKeyword;
        this.expressionTrees = expressionTrees;
    }

    @Override
    public Token yieldKeyword() {
        return this.yieldKeyword;
    }

    @Override
    @CheckForNull
    public Token fromKeyword() {
        return this.fromKeyword;
    }

    @Override
    public List<Expression> expressions() {
        return this.expressionTrees;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.YIELD_EXPR;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitYieldExpression(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(Arrays.asList(this.yieldKeyword, this.fromKeyword), this.expressionTrees).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

