/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ClassTraversalCache;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.container.SetterInfo;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u0014\u0010\u0010\u001a\u00020\u00112\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\u0013"}, d2={"collectInterfacesRecursive", "", "type", "Ljava/lang/reflect/Type;", "result", "", "getConstructorInfo", "Lorg/jetbrains/kotlin/container/ConstructorInfo;", "c", "Ljava/lang/Class;", "getDefaultImplementation", "klass", "getRegistrations", "", "getSetterInfos", "Lorg/jetbrains/kotlin/container/SetterInfo;", "traverseClass", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getInfo", "container"})
public final class CacheKt {
    @NotNull
    public static final ClassInfo getInfo(@NotNull Class<?> $this$getInfo) {
        Intrinsics.checkNotNullParameter($this$getInfo, "<this>");
        return ClassTraversalCache.INSTANCE.getClassInfo($this$getInfo);
    }

    private static final ClassInfo traverseClass(Class<?> c) {
        return new ClassInfo(CacheKt.getConstructorInfo(c), CacheKt.getSetterInfos(c), CacheKt.getRegistrations(c), CacheKt.getDefaultImplementation(c));
    }

    private static final List<SetterInfo> getSetterInfos(Class<?> c) {
        ArrayList<SetterInfo> setterInfos = new ArrayList<SetterInfo>();
        Method[] methodArray = c.getMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "c.methods");
        for (Method method : methodArray) {
            Annotation[] annotationArray;
            Intrinsics.checkNotNullExpressionValue(method.getDeclaredAnnotations(), "method.declaredAnnotations");
            for (Annotation annotation2 : annotationArray) {
                String string2 = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation2)).getName();
                Intrinsics.checkNotNullExpressionValue(string2, "annotation.annotationClass.java.name");
                if (!StringsKt.endsWith$default(string2, ".Inject", false, 2, null)) continue;
                Intrinsics.checkNotNullExpressionValue(method, "method");
                Type[] typeArray = method.getGenericParameterTypes();
                Intrinsics.checkNotNullExpressionValue(typeArray, "method.genericParameterTypes");
                setterInfos.add(new SetterInfo(method, ArraysKt.toList((Object[])typeArray)));
            }
        }
        return setterInfos;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConstructorInfo getConstructorInfo(Class<?> c) {
        List<Object> list2;
        void $this$filterTo$iv$iv;
        if (Modifier.isAbstract(c.getModifiers()) || c.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructorArray = c.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, "c.constructors");
        Object[] $this$filter$iv = constructorArray;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Constructor it = (Constructor)element$iv$iv;
            boolean bl = false;
            if (!(Modifier.isPublic(it.getModifiers()) && !it.isSynthetic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List publicConstructors = (List)destination$iv$iv;
        if (publicConstructors.size() != 1) {
            return null;
        }
        Constructor constructor = (Constructor)CollectionsKt.single(publicConstructors);
        if (c.getDeclaringClass() != null && !Modifier.isStatic(c.getModifiers())) {
            object = new SpreadBuilder(2);
            ((SpreadBuilder)object).add(c.getDeclaringClass());
            Type[] typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.genericParameterTypes");
            ((SpreadBuilder)object).addSpread(typeArray);
            list2 = CollectionsKt.listOf(((SpreadBuilder)object).toArray(new Type[((SpreadBuilder)object).size()]));
        } else {
            Type[] typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "constructor.genericParameterTypes");
            list2 = ArraysKt.toList((Object[])typeArray);
        }
        List<Object> parameterTypes = list2;
        Intrinsics.checkNotNullExpressionValue(constructor, "constructor");
        return new ConstructorInfo(constructor, parameterTypes);
    }

    private static final void collectInterfacesRecursive(Type type2, Set<Type> result2) {
        block1: {
            Type[] klass;
            Type type3;
            Type type4 = type2;
            Object object = type4 instanceof Class ? (Type[])type2 : (type4 instanceof ParameterizedType ? ((type3 = ((ParameterizedType)type2).getRawType()) instanceof Class ? (Class)type3 : null) : null);
            Type[] typeArray = klass = object;
            if (klass == null || (typeArray = typeArray.getGenericInterfaces()) == null) break block1;
            Type[] $this$forEach$iv = typeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Type element$iv;
                Type it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (!result2.add(it)) continue;
                CacheKt.collectInterfacesRecursive(it, result2);
            }
        }
    }

    private static final Class<?> getDefaultImplementation(Class<?> klass) {
        DefaultImplementation defaultImplementation = klass.getAnnotation(DefaultImplementation.class);
        return defaultImplementation != null ? defaultImplementation.impl() : null;
    }

    private static final List<Type> getRegistrations(Class<?> klass) {
        ArrayList registrations = new ArrayList();
        Sequence<Class<?>> superClasses2 = SequencesKt.generateSequence(klass, (Function1)getRegistrations.superClasses.1.INSTANCE);
        CollectionsKt.addAll((Collection)registrations, superClasses2);
        LinkedHashSet interfaces = new LinkedHashSet();
        Sequence<Class<?>> $this$forEach$iv = superClasses2;
        boolean $i$f$forEach = false;
        Iterator<Class<?>> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Class<?> element$iv = iterator2.next();
            Type it = element$iv;
            boolean bl = false;
            CacheKt.collectInterfacesRecursive(it, interfaces);
        }
        registrations.addAll(interfaces);
        registrations.remove(Object.class);
        return registrations;
    }

    public static final /* synthetic */ ClassInfo access$traverseClass(Class c) {
        return CacheKt.traverseClass(c);
    }
}

