/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0007J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/PackagePartClassUtils;", "", "()V", "PART_CLASS_NAME_SUFFIX", "", "decapitalizeAsJavaClassName", "str", "getDefaultPartFqName", "Lorg/jetbrains/kotlin/name/FqName;", "facadeClassFqName", "file", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getFileNameByFacadeName", "facadeClassName", "getFilePartShortName", "fileName", "getFilesWithCallables", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "files", "", "getPackagePartFqName", "packageFqName", "getPathHashCode", "", "frontend.java"})
public final class PackagePartClassUtils {
    @NotNull
    public static final PackagePartClassUtils INSTANCE = new PackagePartClassUtils();
    @NotNull
    private static final String PART_CLASS_NAME_SUFFIX = "Kt";

    private PackagePartClassUtils() {
    }

    @JvmStatic
    public static final int getPathHashCode(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        String string2 = file2.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "file.path");
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string3.hashCode();
    }

    @JvmStatic
    private static final String decapitalizeAsJavaClassName(String str) {
        String string2;
        if (Character.isJavaIdentifierStart(str.charAt(0))) {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = str.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            StringBuilder stringBuilder2 = stringBuilder.append(string4);
            String string5 = str.substring(1);
            Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder2.append(string5).toString();
        } else if (str.charAt(0) == '_') {
            String string6 = str.substring(1);
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue(string6, "this as java.lang.String).substring(startIndex)");
        } else {
            string2 = str;
        }
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final FqName getDefaultPartFqName(@NotNull FqName facadeClassFqName, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter(facadeClassFqName, "facadeClassFqName");
        Intrinsics.checkNotNullParameter(file2, "file");
        FqName fqName2 = facadeClassFqName.parent();
        Intrinsics.checkNotNullExpressionValue(fqName2, "facadeClassFqName.parent()");
        String string2 = file2.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "file.name");
        return PackagePartClassUtils.getPackagePartFqName(fqName2, string2);
    }

    @JvmStatic
    @NotNull
    public static final FqName getPackagePartFqName(@NotNull FqName packageFqName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        String partClassName = PackagePartClassUtils.getFilePartShortName(fileName);
        FqName fqName2 = packageFqName.child(Name.identifier(partClassName));
        Intrinsics.checkNotNullExpressionValue(fqName2, "packageFqName.child(Name\u2026dentifier(partClassName))");
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<KtFile> getFilesWithCallables(@NotNull Collection<? extends KtFile> files2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files2, "files");
        Iterable $this$filter$iv = files2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!it.hasTopLevelCallables()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final String getFilePartShortName(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = FileUtil.getNameWithoutExtension(fileName);
        Intrinsics.checkNotNullExpressionValue(string2, "getNameWithoutExtension(fileName)");
        return stringBuilder.append(NameUtils.getPackagePartClassNamePrefix(string2)).append(PART_CLASS_NAME_SUFFIX).toString();
    }

    @JvmStatic
    @Nullable
    public static final String getFileNameByFacadeName(@NotNull String facadeClassName) {
        Intrinsics.checkNotNullParameter(facadeClassName, "facadeClassName");
        if (!StringsKt.endsWith$default(facadeClassName, PART_CLASS_NAME_SUFFIX, false, 2, null)) {
            return null;
        }
        String string2 = facadeClassName.substring(0, facadeClassName.length() - PART_CLASS_NAME_SUFFIX.length());
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String baseName = string2;
        if (Intrinsics.areEqual(baseName, "_")) {
            return null;
        }
        return PackagePartClassUtils.decapitalizeAsJavaClassName(baseName) + ".kt";
    }
}

