/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.pubkey;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class AuthorizedKeyEntriesPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    public static final AttributeRepository.AttributeKey<AuthorizedKeyEntry> AUTHORIZED_KEY = new AttributeRepository.AttributeKey();
    private Map<AuthorizedKeyEntry, PublicKey> resolvedKeys;
    private Object id;

    public AuthorizedKeyEntriesPublickeyAuthenticator(Object id, ServerSession session, Collection<? extends AuthorizedKeyEntry> entries, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        this.id = id;
        int numEntries = GenericUtils.size(entries);
        if (numEntries <= 0) {
            this.resolvedKeys = Collections.emptyMap();
        } else {
            this.resolvedKeys = new HashMap<AuthorizedKeyEntry, PublicKey>(numEntries);
            for (AuthorizedKeyEntry authorizedKeyEntry : entries) {
                Map<String, String> headers;
                PublicKey k = authorizedKeyEntry.resolvePublicKey(session, headers = authorizedKeyEntry.getLoginOptions(), fallbackResolver);
                if (k == null) continue;
                this.resolvedKeys.put(authorizedKeyEntry, k);
            }
        }
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        if (MapEntryUtils.isEmpty(this.resolvedKeys)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + username + ")[" + session + "] no entries");
            }
            return false;
        }
        for (Map.Entry<AuthorizedKeyEntry, PublicKey> e : this.resolvedKeys.entrySet()) {
            if (!KeyUtils.compareKeys(key, e.getValue())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + username + ")[" + session + "] match found");
            }
            if (session != null) {
                session.setAttribute(AUTHORIZED_KEY, e.getKey());
            }
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate(" + username + ")[" + session + "] match not found");
        }
        return false;
    }

    public String toString() {
        return Objects.toString(this.getId());
    }
}

