/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.config.keys;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import org.apache.sshd.common.auth.UsernameHolder;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.server.config.keys.AuthorizedKeysAuthenticator;
import org.apache.sshd.server.session.ServerSession;

public class DefaultAuthorizedKeysAuthenticator
extends AuthorizedKeysAuthenticator
implements UsernameHolder {
    public static final DefaultAuthorizedKeysAuthenticator INSTANCE = new DefaultAuthorizedKeysAuthenticator(true);
    private final boolean strict;
    private final String user;

    public DefaultAuthorizedKeysAuthenticator(boolean strict) {
        this(OsUtils.getCurrentUser(), strict);
    }

    public DefaultAuthorizedKeysAuthenticator(String user, boolean strict) {
        this(user, DefaultAuthorizedKeysAuthenticator.getDefaultAuthorizedKeysFile(), strict, new LinkOption[0]);
    }

    public DefaultAuthorizedKeysAuthenticator(Path path, boolean strict, LinkOption ... options) {
        this(OsUtils.getCurrentUser(), path, strict, options);
    }

    public DefaultAuthorizedKeysAuthenticator(String user, Path path, boolean strict, LinkOption ... options) {
        super(path, options);
        this.user = ValidateUtils.checkNotNullAndNotEmpty(user, "No username provided");
        this.strict = strict;
    }

    @Override
    public final String getUsername() {
        return this.user;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    @Override
    protected boolean isValidUsername(String username, ServerSession session) {
        if (!super.isValidUsername(username, session)) {
            return false;
        }
        String expected = this.getUsername();
        return username.equals(expected);
    }

    @Override
    protected Collection<AuthorizedKeyEntry> reloadAuthorizedKeys(Path path, String username, ServerSession session) throws IOException, GeneralSecurityException {
        if (this.isStrict()) {
            AbstractMap.SimpleImmutableEntry<String, Object> violation;
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadAuthorizedKeys({})[{}] check permissions of {}", username, session, path);
            }
            if ((violation = KeyUtils.validateStrictKeyFilePermissions(path, new LinkOption[0])) != null) {
                this.log.warn("reloadAuthorizedKeys({})[{}] invalid file={} permissions: {}", username, session, path, violation.getKey());
                this.updateReloadAttributes();
                return Collections.emptyList();
            }
        }
        return super.reloadAuthorizedKeys(path, username, session);
    }

    protected Path validateFilePath(Path path, Collection<PosixFilePermission> perms, Collection<PosixFilePermission> excluded) throws IOException {
        PosixFilePermission p = IoUtils.validateExcludedPermissions(perms, excluded);
        if (p != null) {
            String filePath = path.toString();
            throw new FileSystemException(filePath, filePath, "File not allowed to have " + (Object)((Object)p) + " permission: " + filePath);
        }
        return path;
    }
}

