/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.staxmate.out;

import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.out.SMNamespace;
import org.codehaus.staxmate.out.SMOutputContainer;
import org.codehaus.staxmate.out.SMOutputContext;
import org.codehaus.staxmate.out.SMOutputtable;

public class SMOutputElement
extends SMOutputContainer {
    protected static final int OUTPUT_NONE = 0;
    protected static final int OUTPUT_ATTRS = 1;
    protected static final int OUTPUT_CHILDREN = 2;
    protected static final int OUTPUT_CLOSED = 3;
    protected final String _localName;
    protected final SMNamespace _namespace;
    protected int _outputState = 0;
    protected SMNamespace _parentDefaultNs;
    protected int _parentNsCount;

    protected SMOutputElement(SMOutputContext ctxt, String localName, SMNamespace ns) {
        super(ctxt);
        this._parent = null;
        this._localName = localName;
        this._namespace = ns;
    }

    public void linkParent(SMOutputContainer parent, boolean blocked) throws XMLStreamException {
        if (this._parent != null) {
            this._throwRelinking();
        }
        this._parent = parent;
        if (!blocked) {
            this.doWriteStartElement();
        }
    }

    public String getLocalName() {
        return this._localName;
    }

    public SMNamespace getNamespace() {
        return this._namespace;
    }

    public void addAttribute(SMNamespace ns, String localName, String value) throws XMLStreamException {
        ns = this._verifyNamespaceArg(ns);
        switch (this._outputState) {
            case 0: {
                this._linkNewChild(this._context.createAttribute(ns, localName, value));
                break;
            }
            case 1: {
                this._context.writeAttribute(ns, localName, value);
                break;
            }
            default: {
                this._throwClosedForAttrs();
            }
        }
    }

    public final void addAttribute(String localName, String value) throws XMLStreamException {
        this.addAttribute(null, localName, value);
    }

    public void addAttribute(SMNamespace ns, String localName, boolean value) throws XMLStreamException {
        this.addAttribute(ns, localName, value ? "true" : "false");
    }

    public void addAttribute(SMNamespace ns, String localName, int value) throws XMLStreamException {
        this.addAttribute(ns, localName, String.valueOf(value));
    }

    public void addAttribute(SMNamespace ns, String localName, long value) throws XMLStreamException {
        this.addAttribute(ns, localName, String.valueOf(value));
    }

    public SMOutputElement addAttribute(SMNamespace ns, String localName, byte[] value) throws XMLStreamException {
        ns = this._verifyNamespaceArg(ns);
        switch (this._outputState) {
            case 0: {
                this._linkNewChild(this._context.createAttribute(ns, localName, value));
                break;
            }
            case 1: {
                this._context.writeAttribute(ns, localName, value);
                break;
            }
            default: {
                this._throwClosedForAttrs();
            }
        }
        return this;
    }

    public SMOutputElement addAttribute(String localName, byte[] value) throws XMLStreamException {
        return this.addAttribute(null, localName, value);
    }

    public void predeclareNamespace(SMNamespace ns) throws XMLStreamException {
        ns = this._verifyNamespaceArg(ns);
        switch (this._outputState) {
            case 0: {
                this._linkNewChild(this._context.createNamespace(ns, this._parentDefaultNs, this._parentNsCount));
                break;
            }
            case 1: {
                this._context.predeclareNamespace(ns, this._parentDefaultNs, this._parentNsCount);
                break;
            }
            default: {
                this._throwClosedForNsDecls();
            }
        }
    }

    @Override
    protected void _childReleased(SMOutputtable child) throws XMLStreamException {
        if (child == this._firstChild) {
            switch (this._outputState) {
                case 0: {
                    return;
                }
                case 3: {
                    this._throwClosed();
                }
                case 1: {
                    throw new IllegalStateException("Internal error: illegal state (OUTPUT_ATTRS) on receiving 'childReleased' notification");
                }
            }
            this._parent._childReleased(this);
        }
    }

    @Override
    protected boolean _output(SMOutputContext ctxt, boolean canClose) throws XMLStreamException {
        switch (this._outputState) {
            case 0: {
                this.doWriteStartElement();
                break;
            }
            case 3: {
                this._throwClosed();
            }
            case 1: {
                this._outputState = 2;
            }
        }
        if (this._firstChild != null) {
            if (canClose) {
                this._closeAndOutputChildren();
            } else {
                this._closeAllButLastChild();
            }
        }
        if (!canClose || this._firstChild != null) {
            return false;
        }
        this.doWriteEndElement();
        return true;
    }

    @Override
    protected void _forceOutput(SMOutputContext ctxt) throws XMLStreamException {
        if (!this._output(this._context, true)) {
            this._forceChildOutput();
            this.doWriteEndElement();
        }
    }

    @Override
    public boolean _canOutputNewChild() throws XMLStreamException {
        switch (this._outputState) {
            case 0: {
                return false;
            }
            case 3: {
                this._throwClosed();
            }
            case 1: {
                this._outputState = 2;
            }
        }
        if (this._firstChild == null) {
            return true;
        }
        return this._closeAndOutputChildren();
    }

    @Override
    public void getPath(StringBuilder sb) {
        if (this._parent != null) {
            this._parent.getPath(sb);
        }
        sb.append('/');
        String uri = this._namespace.getURI();
        if (uri != null && uri.length() > 0 && !this._context.isDefaultNs(this._namespace)) {
            String prefix = this._namespace.getBoundPrefix();
            if (prefix == null) {
                prefix = "{unknown-prefix}";
            } else if (prefix.length() == 0) {
                prefix = null;
            }
            if (prefix != null) {
                sb.append(prefix);
                sb.append(':');
            }
        }
        sb.append(this._localName);
    }

    protected void doWriteStartElement() throws XMLStreamException {
        this._outputState = 1;
        SMOutputContext ctxt = this._context;
        this._parentNsCount = ctxt.getNamespaceCount();
        this._parentDefaultNs = ctxt.writeStartElement(this._namespace, this._localName);
    }

    protected void doWriteEndElement() throws XMLStreamException {
        this._outputState = 3;
        this._context.writeEndElement(this._parentNsCount, this._parentDefaultNs);
    }

    protected void _throwClosedForAttrs() {
        String desc = this._outputState == 3 ? "ELEMENT-CLOSED" : "CHILDREN-ADDED";
        throw new IllegalStateException("Can't add attributes for an element (path = '" + this.getPath() + "'), element state '" + desc + "'");
    }

    protected void _throwClosedForNsDecls() {
        String desc = this._outputState == 3 ? "ELEMENT-CLOSED" : "CHILDREN-ADDED";
        throw new IllegalStateException("Can't add namespace declaration for an element (path = '" + this.getPath() + "'), element state '" + desc + "'");
    }
}

