/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.LogOutput;
import org.sonar.batch.bootstrapper.LoggingConfiguration;
import org.sonar.batch.bootstrapper.LoggingConfigurator;
import org.sonar.scanner.bootstrap.SpringGlobalContainer;

public final class Batch {
    private LoggingConfiguration loggingConfig;
    private List<Object> components;
    private Map<String, String> globalProperties = new HashMap<String, String>();

    private Batch(Builder builder) {
        this.components = new ArrayList<Object>();
        this.components.addAll(builder.components);
        if (builder.environment != null) {
            this.components.add(builder.environment);
        }
        if (builder.globalProperties != null) {
            this.globalProperties.putAll(builder.globalProperties);
        }
        if (builder.isEnableLoggingConfiguration()) {
            this.loggingConfig = new LoggingConfiguration(builder.environment).setProperties(this.globalProperties);
            if (builder.logOutput != null) {
                this.loggingConfig.setLogOutput(builder.logOutput);
            }
        }
    }

    public LoggingConfiguration getLoggingConfiguration() {
        return this.loggingConfig;
    }

    public synchronized Batch execute() {
        return this.doExecute(this.globalProperties, this.components);
    }

    public synchronized Batch doExecute(Map<String, String> scannerProperties, List<Object> components) {
        this.configureLogging();
        try {
            SpringGlobalContainer.create(scannerProperties, components).execute();
        }
        catch (RuntimeException e) {
            throw this.handleException(e);
        }
        return this;
    }

    @Deprecated
    public synchronized Batch start() {
        return this;
    }

    @Deprecated
    public Batch executeTask(Map<String, String> analysisProperties, Object ... components) {
        HashMap<String, String> mergedProps = new HashMap<String, String>(this.globalProperties);
        mergedProps.putAll(analysisProperties);
        ArrayList<Object> mergedComponents = new ArrayList<Object>(this.components);
        mergedComponents.addAll(Arrays.asList(components));
        return this.doExecute(mergedProps, mergedComponents);
    }

    private RuntimeException handleException(RuntimeException t) {
        if (this.loggingConfig.isVerbose()) {
            return t;
        }
        Throwable y = t;
        do {
            if (!(y instanceof MessageException)) continue;
            return (MessageException)y;
        } while ((y = y.getCause()) != null);
        return t;
    }

    @Deprecated
    public synchronized void stop() {
    }

    private void configureLogging() {
        if (this.loggingConfig != null) {
            this.loggingConfig.setProperties(this.globalProperties);
            LoggingConfigurator.apply(this.loggingConfig);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, String> globalProperties;
        private EnvironmentInformation environment;
        private List<Object> components = new ArrayList<Object>();
        private boolean enableLoggingConfiguration = true;
        private LogOutput logOutput;

        private Builder() {
        }

        public Builder setEnvironment(EnvironmentInformation env) {
            this.environment = env;
            return this;
        }

        public Builder setComponents(List<Object> l) {
            this.components = l;
            return this;
        }

        public Builder setLogOutput(@Nullable LogOutput logOutput) {
            this.logOutput = logOutput;
            return this;
        }

        public Builder setGlobalProperties(Map<String, String> globalProperties) {
            this.globalProperties = globalProperties;
            return this;
        }

        @Deprecated
        public Builder setBootstrapProperties(Map<String, String> bootstrapProperties) {
            this.globalProperties = bootstrapProperties;
            return this;
        }

        public Builder addComponents(Object ... components) {
            Collections.addAll(this.components, components);
            return this;
        }

        public Builder addComponent(Object component) {
            this.components.add(component);
            return this;
        }

        public boolean isEnableLoggingConfiguration() {
            return this.enableLoggingConfiguration;
        }

        public Builder setEnableLoggingConfiguration(boolean b) {
            this.enableLoggingConfiguration = b;
            return this;
        }

        public Batch build() {
            if (this.components == null) {
                throw new IllegalStateException("Batch components are not set");
            }
            return new Batch(this);
        }
    }
}

