/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci.vendors;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiConfigurationImpl;
import org.sonar.scanner.ci.CiVendor;

public class CodeMagic
implements CiVendor {
    private static final Logger LOG = Loggers.get(CodeMagic.class);
    private final System2 system;

    public CodeMagic(System2 system) {
        this.system = system;
    }

    @Override
    public String getName() {
        return "CodeMagic";
    }

    @Override
    public boolean isDetected() {
        return !StringUtils.isEmpty(this.system.envVariable("FCI_BUILD_ID"));
    }

    @Override
    public CiConfiguration loadConfiguration() {
        String revision = this.system.envVariable("FCI_COMMIT");
        if (StringUtils.isEmpty(revision)) {
            LOG.warn("Missing environment variable FCI_COMMIT");
        }
        return new CiConfigurationImpl(revision, this.getName());
    }
}

