/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.mediumtest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.scanner.fs.InputProject;
import org.sonar.core.util.CloseableIterator;
import org.sonar.scanner.mediumtest.AnalysisObserver;
import org.sonar.scanner.protocol.output.FileStructure;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.protocol.output.ScannerReportReader;
import org.sonar.scanner.report.ScannerReportUtils;
import org.sonar.scanner.scan.SpringProjectScanContainer;
import org.sonar.scanner.scan.filesystem.InputComponentStore;

public class AnalysisResult
implements AnalysisObserver {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisResult.class);
    private Map<String, InputFile> inputFilesByKeys = new HashMap<String, InputFile>();
    private InputProject project;
    private ScannerReportReader reader;

    @Override
    public void analysisCompleted(SpringProjectScanContainer container) {
        LOG.info("Store analysis results in memory for later assertions in medium test");
        FileStructure fileStructure = container.getComponentByType(FileStructure.class);
        this.reader = new ScannerReportReader(fileStructure);
        this.project = container.getComponentByType(InputProject.class);
        this.storeFs(container);
    }

    public ScannerReportReader getReportReader() {
        return this.reader;
    }

    private void storeFs(SpringProjectScanContainer container) {
        InputComponentStore inputFileCache = container.getComponentByType(InputComponentStore.class);
        for (InputFile inputPath : inputFileCache.inputFiles()) {
            this.inputFilesByKeys.put(((DefaultInputFile)inputPath).getProjectRelativePath(), inputPath);
        }
    }

    public ScannerReport.Component getReportComponent(InputComponent inputComponent) {
        return this.getReportReader().readComponent(((DefaultInputComponent)inputComponent).scannerId());
    }

    public ScannerReport.Component getReportComponent(int scannerId) {
        return this.getReportReader().readComponent(scannerId);
    }

    public List<ScannerReport.Issue> issuesFor(InputComponent inputComponent) {
        return this.issuesFor(((DefaultInputComponent)inputComponent).scannerId());
    }

    public List<ScannerReport.ExternalIssue> externalIssuesFor(InputComponent inputComponent) {
        return this.externalIssuesFor(((DefaultInputComponent)inputComponent).scannerId());
    }

    public List<ScannerReport.Issue> issuesFor(ScannerReport.Component reportComponent) {
        int ref = reportComponent.getRef();
        return this.issuesFor(ref);
    }

    private List<ScannerReport.Issue> issuesFor(int ref) {
        ArrayList<ScannerReport.Issue> result = new ArrayList<ScannerReport.Issue>();
        try (CloseableIterator<ScannerReport.Issue> it = this.reader.readComponentIssues(ref);){
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        return result;
    }

    private List<ScannerReport.ExternalIssue> externalIssuesFor(int ref) {
        ArrayList<ScannerReport.ExternalIssue> result = new ArrayList<ScannerReport.ExternalIssue>();
        try (CloseableIterator<ScannerReport.ExternalIssue> it = this.reader.readComponentExternalIssues(ref);){
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        return result;
    }

    public InputProject project() {
        return this.project;
    }

    public Collection<InputFile> inputFiles() {
        return this.inputFilesByKeys.values();
    }

    @CheckForNull
    public InputFile inputFile(String relativePath) {
        return this.inputFilesByKeys.get(relativePath);
    }

    public Map<String, List<ScannerReport.Measure>> allMeasures() {
        HashMap<String, List<ScannerReport.Measure>> result = new HashMap<String, List<ScannerReport.Measure>>();
        ArrayList<ScannerReport.Measure> projectMeasures = new ArrayList<ScannerReport.Measure>();
        try (CloseableIterator<ScannerReport.Measure> it = this.reader.readComponentMeasures(((DefaultInputComponent)((Object)this.project)).scannerId());){
            while (it.hasNext()) {
                projectMeasures.add(it.next());
            }
        }
        result.put(this.project.key(), projectMeasures);
        for (InputFile inputFile : this.inputFilesByKeys.values()) {
            ArrayList<ScannerReport.Measure> measures = new ArrayList<ScannerReport.Measure>();
            try (CloseableIterator<ScannerReport.Measure> it = this.reader.readComponentMeasures(((DefaultInputComponent)((Object)inputFile)).scannerId());){
                while (it.hasNext()) {
                    measures.add(it.next());
                }
            }
            result.put(inputFile.key(), measures);
        }
        return result;
    }

    public List<TypeOfText> highlightingTypeFor(InputFile file, int line, int lineOffset) {
        int ref = ((DefaultInputComponent)((Object)file)).scannerId();
        if (!this.reader.hasSyntaxHighlighting(ref)) {
            return Collections.emptyList();
        }
        TextPointer pointer = file.newPointer(line, lineOffset);
        ArrayList<TypeOfText> result = new ArrayList<TypeOfText>();
        try (CloseableIterator<ScannerReport.SyntaxHighlightingRule> it = this.reader.readComponentSyntaxHighlighting(ref);){
            while (it.hasNext()) {
                ScannerReport.SyntaxHighlightingRule rule = it.next();
                TextRange ruleRange = AnalysisResult.toRange(file, rule.getRange());
                if (ruleRange.start().compareTo(pointer) > 0 || ruleRange.end().compareTo(pointer) <= 0) continue;
                result.add(ScannerReportUtils.toBatchType(rule.getType()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read syntax highlighting for " + file, e);
        }
        return result;
    }

    private static TextRange toRange(InputFile file, ScannerReport.TextRange reportRange) {
        return file.newRange(file.newPointer(reportRange.getStartLine(), reportRange.getStartOffset()), file.newPointer(reportRange.getEndLine(), reportRange.getEndOffset()));
    }

    @CheckForNull
    public List<ScannerReport.TextRange> symbolReferencesFor(InputFile file, int symbolStartLine, int symbolStartLineOffset) {
        int ref = ((DefaultInputComponent)((Object)file)).scannerId();
        try (CloseableIterator<ScannerReport.Symbol> symbols = this.getReportReader().readComponentSymbols(ref);){
            while (symbols.hasNext()) {
                ScannerReport.Symbol symbol = symbols.next();
                if (symbol.getDeclaration().getStartLine() != symbolStartLine || symbol.getDeclaration().getStartOffset() != symbolStartLineOffset) continue;
                List<ScannerReport.TextRange> list = symbol.getReferenceList();
                return list;
            }
        }
        return Collections.emptyList();
    }

    public List<ScannerReport.Duplication> duplicationsFor(InputFile file) {
        ArrayList<ScannerReport.Duplication> result = new ArrayList<ScannerReport.Duplication>();
        int ref = ((DefaultInputComponent)((Object)file)).scannerId();
        try (CloseableIterator<ScannerReport.Duplication> it = this.getReportReader().readComponentDuplications(ref);){
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public List<ScannerReport.CpdTextBlock> duplicationBlocksFor(InputFile file) {
        ArrayList<ScannerReport.CpdTextBlock> result = new ArrayList<ScannerReport.CpdTextBlock>();
        int ref = ((DefaultInputComponent)((Object)file)).scannerId();
        try (CloseableIterator<ScannerReport.CpdTextBlock> it = this.getReportReader().readCpdTextBlocks(ref);){
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public ScannerReport.LineCoverage coverageFor(InputFile file, int line) {
        int ref = ((DefaultInputComponent)((Object)file)).scannerId();
        try (CloseableIterator<ScannerReport.LineCoverage> it = this.getReportReader().readComponentCoverage(ref);){
            ScannerReport.LineCoverage coverage;
            do {
                if (!it.hasNext()) return null;
            } while ((coverage = it.next()).getLine() != line);
            ScannerReport.LineCoverage lineCoverage = coverage;
            return lineCoverage;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public List<ScannerReport.AdHocRule> adHocRules() {
        ArrayList<ScannerReport.AdHocRule> result = new ArrayList<ScannerReport.AdHocRule>();
        try (CloseableIterator<ScannerReport.AdHocRule> it = this.getReportReader().readAdHocRules();){
            while (it.hasNext()) {
                result.add(it.next());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }
}

