/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.Date;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;

public class DAVMergeHandler
extends BasicDAVHandler {
    private ISVNWorkspaceMediator myMediator;
    private Map myPathsMap;
    private static final DAVElement RESPONSE = DAVElement.getElement("DAV:", "response");
    private static final DAVElement POST_COMMIT_ERROR = DAVElement.getElement("svn:", "post-commit-err");
    private String myAuthor;
    private Date myCommitDate;
    private long myRevision;
    private String myRepositoryPath;
    private String myVersionPath;
    private DAVElement myResourceType;
    private SVNCommitInfo myCommitInfo;
    private SVNErrorMessage myPostCommitError;

    public static StringBuffer generateMergeRequest(StringBuffer xmlBuffer, String path, String activityURL, Map locks) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("D", "merge", DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "source", 1, null, xmlBuffer);
        SVNXMLUtil.openCDataTag("D", "href", activityURL, xmlBuffer);
        SVNXMLUtil.closeXMLTag("D", "source", xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "no-auto-merge", 4, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "no-checkout", 4, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "prop", 1, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "checked-in", 4, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "version-name", 4, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "resourcetype", 4, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "creationdate", 4, null, xmlBuffer);
        SVNXMLUtil.openXMLTag("D", "creator-displayname", 4, null, xmlBuffer);
        SVNXMLUtil.closeXMLTag("D", "prop", xmlBuffer);
        if (locks != null && !locks.isEmpty()) {
            xmlBuffer = DAVMergeHandler.generateLockDataRequest(xmlBuffer, path, null, locks);
        }
        SVNXMLUtil.addXMLFooter("D", "merge", xmlBuffer);
        return xmlBuffer;
    }

    public static StringBuffer generateLockDataRequest(StringBuffer target, String root, String path, Map locks) {
        target = target == null ? new StringBuffer() : target;
        SVNXMLUtil.openNamespaceDeclarationTag("S", "lock-token-list", SVN_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, target);
        for (String lockPath : locks.keySet()) {
            if (path != null && SVNPathUtil.getPathAsChild(path, lockPath) == null) continue;
            String relativePath = SVNPathUtil.getRelativePath(root, lockPath);
            String token = (String)locks.get(lockPath);
            SVNXMLUtil.openXMLTag("S", "lock", 1, null, target);
            SVNXMLUtil.openCDataTag("S", "lock-path", SVNEncodingUtil.uriDecode(relativePath), target);
            SVNXMLUtil.openCDataTag("S", "lock-token", token, target);
            SVNXMLUtil.closeXMLTag("S", "lock", target);
        }
        SVNXMLUtil.closeXMLTag("S", "lock-token-list", target);
        return target;
    }

    public static boolean hasChildPaths(String path, Map locks) {
        for (String lockPath : locks.keySet()) {
            if (SVNPathUtil.getPathAsChild(path, lockPath) == null) continue;
            return true;
        }
        return false;
    }

    public DAVMergeHandler(ISVNWorkspaceMediator mediator, Map pathsMap) {
        this.myMediator = mediator;
        this.myPathsMap = pathsMap;
        this.init();
    }

    public SVNCommitInfo getCommitInfo() {
        return this.myCommitInfo;
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == RESPONSE) {
            this.myResourceType = null;
            this.myRepositoryPath = null;
            this.myVersionPath = null;
            this.myAuthor = null;
            this.myCommitDate = null;
            this.myRevision = -1L;
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == POST_COMMIT_ERROR) {
            this.myPostCommitError = SVNErrorMessage.create(SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED, cdata.toString(), 1);
        } else if (element == DAVElement.HREF) {
            if (parent == RESPONSE) {
                this.myRepositoryPath = cdata.toString();
                this.myRepositoryPath = SVNEncodingUtil.uriDecode(this.myRepositoryPath);
                this.myRepositoryPath = SVNPathUtil.canonicalizePath(this.myRepositoryPath);
            } else if (parent == DAVElement.CHECKED_IN) {
                this.myVersionPath = cdata.toString();
                this.myVersionPath = SVNPathUtil.canonicalizePath(this.myVersionPath);
            }
        } else if (parent == DAVElement.RESOURCE_TYPE && element == DAVElement.BASELINE) {
            this.myResourceType = element;
        } else if (parent == DAVElement.RESOURCE_TYPE && element == DAVElement.COLLECTION) {
            this.myResourceType = element;
        } else if (element == RESPONSE) {
            if (this.myResourceType == DAVElement.BASELINE) {
                this.myCommitInfo = new SVNCommitInfo(this.myRevision, this.myAuthor, this.myCommitDate, this.myPostCommitError);
            } else {
                String reposPath = SVNEncodingUtil.uriEncode(this.myRepositoryPath);
                String path = (String)this.myPathsMap.get(reposPath);
                if (path != null && this.myMediator != null) {
                    String versionURLPropName = "svn:wc:ra_dav:version-url";
                    SVNPropertyValue urlPropertyValue = DAVUtil.isUseDAVWCURL() ? SVNPropertyValue.create(this.myVersionPath) : null;
                    this.myMediator.setWorkspaceProperty(SVNEncodingUtil.uriDecode(path), versionURLPropName, urlPropertyValue);
                }
            }
        } else if (element == DAVElement.CREATION_DATE) {
            this.myCommitDate = SVNDate.parseDate(cdata.toString());
        } else if (element == DAVElement.CREATOR_DISPLAY_NAME) {
            this.myAuthor = cdata.toString();
        } else if (element == DAVElement.VERSION_NAME) {
            try {
                this.myRevision = Long.parseLong(cdata.toString());
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, nfe), SVNLogType.NETWORK);
            }
        } else if (parent != DAVElement.PROPSTAT || element == DAVElement.STATUS) {
            // empty if block
        }
    }
}

