/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc2.AbstractSvnUpdate;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnUpdate
extends AbstractSvnUpdate<long[]> {
    private boolean depthIsSticky;
    private boolean makeParents;
    private boolean treatAddsAsModifications;

    protected SvnUpdate(SvnOperationFactory factory2) {
        super(factory2);
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        for (SvnTarget target : this.getTargets()) {
            if (!target.isURL()) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)target.getURL());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (this.getDepth() == null) {
            this.setDepth(SVNDepth.UNKNOWN);
        }
        if (this.getDepth() == SVNDepth.UNKNOWN) {
            this.setDepthIsSticky(false);
        }
        super.ensureArgumentsAreValid();
    }

    public boolean isDepthIsSticky() {
        return this.depthIsSticky;
    }

    public void setDepthIsSticky(boolean depthIsSticky) {
        this.depthIsSticky = depthIsSticky;
    }

    public boolean isMakeParents() {
        return this.makeParents;
    }

    public void setMakeParents(boolean makeParents) {
        this.makeParents = makeParents;
    }

    public boolean isTreatAddsAsModifications() {
        return this.treatAddsAsModifications;
    }

    public void setTreatAddsAsModifications(boolean treatAddsAsModifications) {
        this.treatAddsAsModifications = treatAddsAsModifications;
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }
}

