/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import com.carrotsearch.hppc.LongObjectHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.index.seqno.CountedBitSet;
import org.elasticsearch.index.seqno.SeqNoStats;

public class LocalCheckpointTracker {
    static final short BIT_SET_SIZE = 1024;
    final LongObjectHashMap<CountedBitSet> processedSeqNo = new LongObjectHashMap();
    final LongObjectHashMap<CountedBitSet> persistedSeqNo = new LongObjectHashMap();
    final AtomicLong processedCheckpoint = new AtomicLong();
    final AtomicLong persistedCheckpoint = new AtomicLong();
    final AtomicLong nextSeqNo = new AtomicLong();

    public LocalCheckpointTracker(long maxSeqNo, long localCheckpoint) {
        if (localCheckpoint < 0L && localCheckpoint != -1L) {
            throw new IllegalArgumentException("local checkpoint must be non-negative or [-1] but was [" + localCheckpoint + "]");
        }
        if (maxSeqNo < 0L && maxSeqNo != -1L) {
            throw new IllegalArgumentException("max seq. no. must be non-negative or [-1] but was [" + maxSeqNo + "]");
        }
        this.nextSeqNo.set(maxSeqNo + 1L);
        this.processedCheckpoint.set(localCheckpoint);
        this.persistedCheckpoint.set(localCheckpoint);
    }

    public long generateSeqNo() {
        return this.nextSeqNo.getAndIncrement();
    }

    public void advanceMaxSeqNo(long seqNo) {
        this.nextSeqNo.accumulateAndGet(seqNo + 1L, Math::max);
    }

    public synchronized void markSeqNoAsProcessed(long seqNo) {
        this.markSeqNo(seqNo, this.processedCheckpoint, this.processedSeqNo);
    }

    public synchronized void markSeqNoAsPersisted(long seqNo) {
        this.markSeqNo(seqNo, this.persistedCheckpoint, this.persistedSeqNo);
    }

    private void markSeqNo(long seqNo, AtomicLong checkPoint, LongObjectHashMap<CountedBitSet> bitSetMap) {
        assert (Thread.holdsLock(this));
        this.advanceMaxSeqNo(seqNo);
        if (seqNo <= checkPoint.get()) {
            return;
        }
        CountedBitSet bitSet = this.getBitSetForSeqNo(bitSetMap, seqNo);
        int offset = LocalCheckpointTracker.seqNoToBitSetOffset(seqNo);
        bitSet.set(offset);
        if (seqNo == checkPoint.get() + 1L) {
            this.updateCheckpoint(checkPoint, bitSetMap);
        }
    }

    public long getProcessedCheckpoint() {
        return this.processedCheckpoint.get();
    }

    public long getPersistedCheckpoint() {
        return this.persistedCheckpoint.get();
    }

    public long getMaxSeqNo() {
        return this.nextSeqNo.get() - 1L;
    }

    public synchronized SeqNoStats getStats(long globalCheckpoint) {
        return new SeqNoStats(this.getMaxSeqNo(), this.getPersistedCheckpoint(), globalCheckpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProcessed(long seqNo) {
        assert (seqNo >= 0L) : "invalid seq_no=" + seqNo;
        if (seqNo >= this.nextSeqNo.get()) {
            return false;
        }
        if (seqNo <= this.processedCheckpoint.get()) {
            return true;
        }
        long bitSetKey = LocalCheckpointTracker.getBitSetKey(seqNo);
        int bitSetOffset = LocalCheckpointTracker.seqNoToBitSetOffset(seqNo);
        LocalCheckpointTracker localCheckpointTracker = this;
        synchronized (localCheckpointTracker) {
            if (seqNo <= this.processedCheckpoint.get()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl15 : MonitorExitStatement: MONITOREXIT : var6_4
            CountedBitSet bitSet = (CountedBitSet)this.processedSeqNo.get(bitSetKey);
            return bitSet != null && bitSet.get(bitSetOffset);
        }
    }

    private void updateCheckpoint(AtomicLong checkPoint, LongObjectHashMap<CountedBitSet> bitSetMap) {
        assert (Thread.holdsLock(this));
        assert (this.getBitSetForSeqNo(bitSetMap, checkPoint.get() + 1L).get(LocalCheckpointTracker.seqNoToBitSetOffset(checkPoint.get() + 1L))) : "updateCheckpoint is called but the bit following the checkpoint is not set";
        long bitSetKey = LocalCheckpointTracker.getBitSetKey(checkPoint.get());
        CountedBitSet current = (CountedBitSet)bitSetMap.get(bitSetKey);
        if (current == null) {
            assert (checkPoint.get() % 1024L == 1023L);
            current = (CountedBitSet)bitSetMap.get(++bitSetKey);
        }
        do {
            checkPoint.incrementAndGet();
            if (checkPoint.get() != LocalCheckpointTracker.lastSeqNoInBitSet(bitSetKey)) continue;
            assert (current != null);
            CountedBitSet removed = (CountedBitSet)bitSetMap.remove(bitSetKey);
            assert (removed == current);
            current = (CountedBitSet)bitSetMap.get(++bitSetKey);
        } while (current != null && current.get(LocalCheckpointTracker.seqNoToBitSetOffset(checkPoint.get() + 1L)));
    }

    private static long lastSeqNoInBitSet(long bitSetKey) {
        return (1L + bitSetKey) * 1024L - 1L;
    }

    private static long getBitSetKey(long seqNo) {
        return seqNo / 1024L;
    }

    private CountedBitSet getBitSetForSeqNo(LongObjectHashMap<CountedBitSet> bitSetMap, long seqNo) {
        CountedBitSet bitSet;
        assert (Thread.holdsLock(this));
        long bitSetKey = LocalCheckpointTracker.getBitSetKey(seqNo);
        int index = bitSetMap.indexOf(bitSetKey);
        if (bitSetMap.indexExists(index)) {
            bitSet = (CountedBitSet)bitSetMap.indexGet(index);
        } else {
            bitSet = new CountedBitSet(1024);
            bitSetMap.indexInsert(index, bitSetKey, (Object)bitSet);
        }
        return bitSet;
    }

    private static int seqNoToBitSetOffset(long seqNo) {
        return Math.toIntExact(seqNo % 1024L);
    }
}

