## TFSA-2020-017: Abort due to invalid splits in RaggedCountSparseOutput

### CVE Number
CVE-2020-15199

### Impact
The `RaggedCountSparseOutput` does not validate that the input arguments form a
valid ragged tensor. In particular, there is no validation that the `splits`
tensor has the minimum required number of elements. Code uses this quantity to
[initialize a different data
structure](https://github.com/tensorflow/tensorflow/blob/0e68f4d3295eb0281a517c3662f6698992b7b2cf/tensorflow/core/kernels/count_ops.cc#L241-L244):
```cc
    int num_batches = splits.NumElements() - 1;
    auto per_batch_counts = BatchedMap<W>(num_batches);
```

Since `BatchedMap` is equivalent to a vector, it needs to have at least one
element to not be `nullptr`. If user passes a `splits` tensor that is empty or
has exactly one element, we get a `SIGABRT` signal raised by the operating
system.

### Vulnerable Versions
TensorFlow 2.3.0.

### Patches
We have patched the issue in
[3cbb917b4714766030b28eba9fb41bb97ce9ee02](https://github.com/tensorflow/tensorflow/commit/3cbb917b4714766030b28eba9fb41bb97ce9ee02)
and will release a patch release.

We recommend users to upgrade to TensorFlow 2.3.1.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been discovered through a variant analysis of [a
vulnerability reported by members of the Aivul Team from Qihoo
360](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/security/advisory/tfsa-2020-015.md).
