
/* To compile:
   aarch64-linux-gnu-gcc -Wall -g -O0 -o integer none/tests/arm64/integer.c \
      -DTEST_BFM=1  # (or 0)
   The ubfm/sbfm/bfm tests are huge and take ages to compile and run.
   Set TEST_BFM to 0 to skip them.
*/
#ifndef TEST_BFM
# define TEST_BFM 1
#endif

#include <stdio.h>
#include <malloc.h>  // memalign
#include <string.h>  // memset
#include <assert.h>

typedef  unsigned char           UChar;
typedef  unsigned short int      UShort;
typedef  unsigned int            UInt;
typedef  signed int              Int;
typedef  unsigned char           UChar;
typedef  signed long long int    Long;
typedef  unsigned long long int  ULong;

typedef  unsigned char           Bool;
#define False ((Bool)0)
#define True  ((Bool)1)


static inline UChar randUChar ( void )
{
   static UInt seed = 80021;
   seed = 1103515245 * seed + 12345;
   return (seed >> 17) & 0xFF;
}


#define TESTINST1(instruction, RD, carryin) \
{ \
   ULong out; \
   ULong nzcv_out; \
   ULong nzcv_in = (carryin ? (1<<29) : 0); \
   __asm__ __volatile__( \
      "msr nzcv,%2;" \
      instruction ";" \
      "mov %0," #RD ";" \
      "mrs %1,nzcv;" \
      : "=&r" (out), "=&r" (nzcv_out) \
      : "r" (nzcv_in) \
      : #RD, "cc", "memory" \
   ); \
   printf("%s :: rd %016llx " \
          "cin %d, nzcv %08llx %c%c%c%c\n",       \
      instruction, out, \
      carryin ? 1 : 0, \
      nzcv_out & 0xffff0000, \
      ((1<<31) & nzcv_out) ? 'N' : ' ', \
      ((1<<30) & nzcv_out) ? 'Z' : ' ', \
      ((1<<29) & nzcv_out) ? 'C' : ' ', \
      ((1<<28) & nzcv_out) ? 'V' : ' ' \
      ); \
}

#define TESTINST2(instruction, RNval, RD, RN, carryin) \
{ \
   ULong out; \
   ULong nzcv_out; \
   ULong nzcv_in = (carryin ? (1<<29) : 0); \
   __asm__ __volatile__( \
      "msr nzcv,%3;" \
      "mov " #RN ",%2;" \
      instruction ";" \
      "mov %0," #RD ";" \
      "mrs %1,nzcv;" \
      : "=&r" (out), "=&r" (nzcv_out) \
      : "r" (RNval), "r" (nzcv_in) \
      : #RD, #RN, "cc", "memory" \
   ); \
   printf("%s :: rd %016llx rn %016llx, " \
          "cin %d, nzcv %08llx %c%c%c%c\n",       \
      instruction, out, ((ULong)RNval), \
      carryin ? 1 : 0, \
      nzcv_out & 0xffff0000, \
      ((1<<31) & nzcv_out) ? 'N' : ' ', \
      ((1<<30) & nzcv_out) ? 'Z' : ' ', \
      ((1<<29) & nzcv_out) ? 'C' : ' ', \
      ((1<<28) & nzcv_out) ? 'V' : ' ' \
      ); \
}

#define TESTINST3(instruction, RMval, RNval, RD, RM, RN, carryin) \
{ \
   ULong out; \
   ULong nzcv_out; \
   ULong nzcv_in = (carryin ? (1<<29) : 0); \
   __asm__ __volatile__( \
      "msr nzcv,%4;" \
      "mov " #RM ",%2;" \
      "mov " #RN ",%3;" \
      instruction ";" \
      "mov %0," #RD ";" \
      "mrs %1,nzcv;" \
      : "=&r" (out), "=&r" (nzcv_out) \
      : "r" (RMval), "r" (RNval), "r" (nzcv_in) \
      : #RD, #RM, #RN, "cc", "memory" \
   ); \
   printf("%s :: rd %016llx rm %016llx, rn %016llx, " \
          "cin %d, nzcv %08llx %c%c%c%c\n",       \
      instruction, out, ((ULong)RMval), ((ULong)RNval), \
      carryin ? 1 : 0, \
      nzcv_out & 0xffff0000, \
      ((1<<31) & nzcv_out) ? 'N' : ' ', \
      ((1<<30) & nzcv_out) ? 'Z' : ' ', \
      ((1<<29) & nzcv_out) ? 'C' : ' ', \
      ((1<<28) & nzcv_out) ? 'V' : ' ' \
      ); \
}

#define TESTINST4(instruction, RMval, RNval, RAval, RD, RM, RN, RA, carryin) \
{ \
   ULong out; \
   ULong nzcv_out; \
   ULong nzcv_in = (carryin ? (1<<29) : 0); \
   __asm__ __volatile__( \
      "msr nzcv,%5;" \
      "mov " #RM ",%2;" \
      "mov " #RN ",%3;" \
      "mov " #RA ",%4;" \
      instruction ";" \
      "mov %0," #RD ";" \
      "mrs %1,nzcv;" \
      : "=&r" (out), "=&r" (nzcv_out) \
      : "r" (RMval), "r" (RNval), "r" (RAval), "r" (nzcv_in) \
      : #RD, #RM, #RN, #RA, "cc", "memory" \
   ); \
   printf("%s :: rd %016llx rm %016llx, rn %016llx, ra %016llx, " \
          "cin %d, nzcv %08llx %c%c%c%c\n",       \
      instruction, out, ((ULong)RMval), ((ULong)RNval), ((ULong)RAval), \
      carryin ? 1 : 0, \
      nzcv_out & 0xffff0000, \
      ((1<<31) & nzcv_out) ? 'N' : ' ', \
      ((1<<30) & nzcv_out) ? 'Z' : ' ', \
      ((1<<29) & nzcv_out) ? 'C' : ' ', \
      ((1<<28) & nzcv_out) ? 'V' : ' ' \
      ); \
}

#define ALL5s 0x5555555555555555ULL
#define ALLas 0xAAAAAAAAAAAAAAAAULL
#define ALLfs 0xFFFFFFFFFFFFFFFFULL

////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

static __attribute__((noinline)) void test_arith ( void )
{
printf("misc ad-hoc tests\n");

TESTINST3("add x3, x4, x5", 12345, 6789, x3, x4, x5, 0);
TESTINST3("add w3, w4, w5", 12345, 6789, x3, x4, x5, 0);


TESTINST3("adc x3, x4, x5", 12345, 6789,                          x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 12345, 6789,                          x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);
TESTINST3("adc x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("adc x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);

TESTINST3("adc w3, w4, w5", 12345, 6789,            x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 12345, 6789,            x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 1);
TESTINST3("adc w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("adc w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 1);


TESTINST3("adcs x3, x4, x5", 12345, 6789,                          x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 12345, 6789,                          x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);
TESTINST3("adcs x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("adcs x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);

TESTINST3("adcs w3, w4, w5", 12345, 6789,            x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 12345, 6789,            x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 1);
TESTINST3("adcs w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("adcs w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 1);


TESTINST3("sbc x3, x4, x5", 12345, 6789,                          x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 12345, 6789,                          x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbc x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbc x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);

TESTINST3("sbc w3, w4, w5", 12345, 6789,            x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 12345, 6789,            x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 1);
TESTINST3("sbc w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("sbc w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 1);


TESTINST3("sbcs x3, x4, x5", 12345, 6789,                          x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 12345, 6789,                          x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0, 0xffffffffffffffffULL,             x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0x31415927ULL<<32, 0x27181728ULL<<32, x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0x00000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0x00000001ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0x00000000ULL<<32, 0x00000001ULL<<32, x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0x80000000ULL<<32, 0x00000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0x00000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);
TESTINST3("sbcs x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,0);
TESTINST3("sbcs x3, x4, x5", 0x80000000ULL<<32, 0x80000000ULL<<32, x3,x4,x5,1);

TESTINST3("sbcs w3, w4, w5", 12345, 6789,            x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 12345, 6789,            x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0, 0xffffffffULL,       x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0x31415927, 0x27181728, x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0x00000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0x00000001, 0x00000000, x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0x00000000, 0x00000001, x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0x80000000, 0x00000000, x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0x00000000, 0x80000000, x3,x4,x5, 1);
TESTINST3("sbcs w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 0);
TESTINST3("sbcs w3, w4, w5", 0x80000000, 0x80000000, x3,x4,x5, 1);


TESTINST2("bfm x2, x4, #0, #63", 0x5555555555555555, x2, x4, 0);
TESTINST2("bfm x2, x4, #0, #63", 0xaaaaaaaaaaaaaaaa, x2, x4, 0);

TESTINST3("cmp x4, x5 ; cset x3, ne", 12345, 6789, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; cset x3, eq", 12345, 6789, x3, x4, x5, 0);
  
TESTINST3("cmp w4, w5 ; cset x3, ne",
          0xAB12345678, 0xCD12345678, x3, x4, x5, 0);

TESTINST3("cmp w4, w5 ; cset x3, eq",
          0xCD12345678, 0xCD12345670, x3, x4, x5, 0);
  
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x33566e6515990527, 0x3d7e7390195d82e2, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xe57b3a514f5207f4, 0x8ef7bac0f0ac903a, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x9d4a481b12743bf8, 0x9f014e8d2644ee47, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xefdd33d64e6d6a8b, 0x44e875422d202c19, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x5c6c9b2a7f109f5b, 0x568ee275e665f075, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x9b14b0a4fbbd2c11, 0x6b5bac44aaa93980, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x2e01dd24f43ab651, 0xe7d992b63e93eed4, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xf51464d0135fb75c, 0xcb60e536ad0b94e9, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0xca38ffb7de3bd6b0, 0xeef048dd9ed9490c, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x54ec6fe1530c7d86, 0xe7aa4d6f69edb5d0, x3, x4, x5, 0);
TESTINST3("cmp x4, x5 ; mrs x3, nzcv", 0x401b30e3b8b5d629, 0x635a5c613cdb7919, x3, x4, x5, 0);

TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x33566e6515990527, 0x3d7e7390195d82e2, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xe57b3a514f5207f4, 0x8ef7bac0f0ac903a, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x9d4a481b12743bf8, 0x9f014e8d2644ee47, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xefdd33d64e6d6a8b, 0x44e875422d202c19, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x5c6c9b2a7f109f5b, 0x568ee275e665f075, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x9b14b0a4fbbd2c11, 0x6b5bac44aaa93980, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x2e01dd24f43ab651, 0xe7d992b63e93eed4, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xf51464d0135fb75c, 0xcb60e536ad0b94e9, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0xca38ffb7de3bd6b0, 0xeef048dd9ed9490c, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x54ec6fe1530c7d86, 0xe7aa4d6f69edb5d0, x3, x4, x5, 0);
TESTINST3("cmp w4, w5 ; mrs x3, nzcv", 0x401b30e3b8b5d629, 0x635a5c613cdb7919, x3, x4, x5, 0);


////////////////////////////////////////////////////////////////
printf("ADD imm12\n");
TESTINST2("add x3, x4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("add x3, x4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("add x3, x4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("add x3, x4, #0x876, lsl #12", ALLfs, x3, x4, 0);
TESTINST2("add w3, w4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("add w3, w4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("add w3, w4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("add w3, w4, #0x876, lsl #12", ALLfs, x3, x4, 0);
TESTINST2("adds x3, x4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("adds x3, x4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("adds x3, x4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("adds x3, x4, #0x876, lsl #12", ALLfs, x3, x4, 0);
TESTINST2("adds w3, w4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("adds w3, w4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("adds w3, w4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("adds w3, w4, #0x876, lsl #12", ALLfs, x3, x4, 0);

TESTINST2("adds x3, x4, #0xD87, lsl #0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0xefdd33d64e6d6a8b, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x8b0a4c8f910c1a9a, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x5c6c9b2a7f109f5b, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x1f699b1d954a5abd, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x9b14b0a4fbbd2c11, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0xd55d1c942f951f5e, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x31d5b14395d5a53a, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x2e01dd24f43ab651, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0xf44e040002467809, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("adds x3, x4, #0xD87, lsl #0", 0x64d24626922b486c, x3, x4, 0);

TESTINST2("adds w3, w4, #0xD87, lsl #0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0xefdd33d64e6d6a8b, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x8b0a4c8f910c1a9a, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x5c6c9b2a7f109f5b, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x1f699b1d954a5abd, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x9b14b0a4fbbd2c11, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0xd55d1c942f951f5e, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x31d5b14395d5a53a, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x2e01dd24f43ab651, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0xf44e040002467809, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("adds w3, w4, #0xD87, lsl #0", 0x64d24626922b486c, x3, x4, 0);

////////////////////////////////////////////////////////////////
printf("SUB imm12\n");
TESTINST2("sub w3, w4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("sub w3, w4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("sub w3, w4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("sub w3, w4, #0x876, lsl #12", ALLfs, x3, x4, 0);
TESTINST2("sub w3, w4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("sub w3, w4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("sub w3, w4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("sub w3, w4, #0x876, lsl #12", ALLfs, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #12", ALLfs, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #0", ALL5s, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #0", ALLfs, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #12", ALL5s, x3, x4, 0);
TESTINST2("subs w3, w4, #0x876, lsl #12", ALLfs, x3, x4, 0);

TESTINST2("subs x3, x4, #0xD87, lsl #0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0xefdd33d64e6d6a8b, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x8b0a4c8f910c1a9a, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x5c6c9b2a7f109f5b, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x1f699b1d954a5abd, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x9b14b0a4fbbd2c11, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0xd55d1c942f951f5e, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x31d5b14395d5a53a, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x2e01dd24f43ab651, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0xf44e040002467809, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x64d24626922b486c, x3, x4, 0);

TESTINST2("subs w3, w4, #0xD87, lsl #0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0xefdd33d64e6d6a8b, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x8b0a4c8f910c1a9a, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x5c6c9b2a7f109f5b, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x1f699b1d954a5abd, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x9b14b0a4fbbd2c11, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0xd55d1c942f951f5e, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x31d5b14395d5a53a, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x2e01dd24f43ab651, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0xf44e040002467809, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x64d24626922b486c, x3, x4, 0);

TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x64d2462600000d86, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x64d2462600000d87, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x64d2462600000d88, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x64d2462680000d86, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x64d2462680000d87, x3, x4, 0);
TESTINST2("subs w3, w4, #0xD87, lsl #0", 0x64d2462680000d88, x3, x4, 0);

TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x0000000000000d86, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x0000000000000d87, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x0000000000000d88, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x8000000000000d86, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x8000000000000d87, x3, x4, 0);
TESTINST2("subs x3, x4, #0xD87, lsl #0", 0x8000000000000d88, x3, x4, 0);

////////////////////////////////////////////////////////////////
printf("ADR/ADRP MISSING (results are PC dependant)\n");
//TESTINST1("adrp x27, #0x987", x27, 0);

////////////////////////////////////////////////////////////////
printf("AND(imm)\n");
TESTINST2("and  x3,x4, #0xF", ALL5s, x3, x4, 0);
TESTINST2("and  x3,x4, #0x8080808080808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("and  x3,x4, #0xC0C0C0C0C0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("ands x3,x4, #0x8080808080808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("ands x3,x4, #0xC0C0C0C0C0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("ands x3,x4, #0x8080808080808080", 0x143fdf810277796e, x3, x4, 0);
TESTINST2("ands x3,x4, #0xC0C0C0C0C0C0C0C0", 0xA5446fe48c610b28, x3, x4, 0);
TESTINST2("ands x3,x4, #0x8080808080808080", 0x7070707070707070, x3, x4, 0);
TESTINST2("ands x3,x4, #0x8080808080808080", 0xF070707070707070, x3, x4, 0);

TESTINST2("and  w3,w4, #0xF", ALL5s, x3, x4, 0);
TESTINST2("and  w3,w4, #0x80808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("and  w3,w4, #0xC0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("ands w3,w4, #0x80808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("ands w3,w4, #0xC0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);
TESTINST2("ands w3,w4, #0x80808080", 0x143fdf810277796e, x3, x4, 0);
TESTINST2("ands w3,w4, #0xC0C0C0C0", 0xA5446fe48c610b28, x3, x4, 0);
TESTINST2("ands w3,w4, #0x80808080", 0x7070707070707070, x3, x4, 0);
TESTINST2("ands w3,w4, #0x80808080", 0x70707070F0707070, x3, x4, 0);

////////////////////////////////////////////////////////////////
printf("ORR(imm)\n");
TESTINST2("orr  x3,x4, #0xF", ALL5s, x3, x4, 0);
TESTINST2("orr  x3,x4, #0x8080808080808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("orr  x3,x4, #0xC0C0C0C0C0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);

TESTINST2("orr  w3,w4, #0xF", ALL5s, x3, x4, 0);
TESTINST2("orr  w3,w4, #0x80808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("orr  w3,w4, #0xC0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);

////////////////////////////////////////////////////////////////
printf("EOR(imm)\n");
TESTINST2("eor  x3,x4, #0xF", ALL5s, x3, x4, 0);
TESTINST2("eor  x3,x4, #0x8080808080808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("eor  x3,x4, #0xC0C0C0C0C0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);

TESTINST2("eor  w3,w4, #0xF", ALL5s, x3, x4, 0);
TESTINST2("eor  w3,w4, #0x80808080", 0x843fdf810277796e, x3, x4, 0);
TESTINST2("eor  w3,w4, #0xC0C0C0C0", 0xc5446fe48c610b28, x3, x4, 0);

////////////////////////////////////////////////////////////////
printf("MOVZ\n");
TESTINST1("movz x27, #0x987", x27, 0);
TESTINST1("movz x27, #0x987, lsl #16", x27, 0);
TESTINST1("movz x27, #0x987, lsl #32", x27, 0);
TESTINST1("movz x27, #0x987, lsl #48", x27, 0);

////////////////////////////////////////////////////////////////
printf("MOVN\n");
TESTINST1("movn x27, #0x987", x27, 0);
TESTINST1("movn x27, #0x987, lsl #16", x27, 0);
TESTINST1("movn x27, #0x987, lsl #32", x27, 0);
TESTINST1("movn x27, #0x987, lsl #48", x27, 0);

////////////////////////////////////////////////////////////////
printf("MOVK\n");
TESTINST1("movn x27, #0xdef, lsl #48 ; movk x27, #0x987, lsl #0 ; "
          "movk x27, #0xabc, lsl #32 ; movk x27, #0x5123, lsl #16 ", x27, 0);

////////////////////////////////////////////////////////////////

#if TEST_BFM

printf("UBFM(64)\n");
printf("SBFM(64)\n");
printf("BFM(64)\n");

TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x643c986966334873, 0x6b8b4567327b23c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x2ae8944a625558ec, 0x74b0dc5119495cff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x3d1b58ba507ed7ab, 0x238e1f2946e87ccd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x79e2a9e37545e146, 0x2eb141f241b71efb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x122008544db127f8, 0x515f007c5bd062c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x1190cde766ef438d, 0x0216231b1f16e9e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x109cf92e0ded7263, 0x140e0f763352255a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x41a7c4c96b68079a, 0x7fdcc2331befd79f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x519b500d431bd7b7, 0x4e6afb6625e45d32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x257130a362bbd95a, 0x3f2dba317c83e458, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x333ab105721da317, 0x436c6125628c895d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x6763845e75a2a8d4, 0x2443a8582d1d5ae9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x4353d0cd0b03e0c6, 0x08edbdab79838cb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x71f324542ca88611, 0x189a769b54e49eb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x3a95f87408138641, 0x0836c40e02901d82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x737b8ddc6ceaf087, 0x1e7ff5217c3dbd3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x3006c83e614fd4a1, 0x22221a704516dde9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x440badfc05072367, 0x419ac2415577f8e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x7724c67e5c482a97, 0x3804823e77465f01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x51ead36b2d517796, 0x2463b9ea5e884adc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x3855585c70a64e2a, 0x580bd78f153ea438, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x1d4ed43b725a06fb, 0x6a2342ec2a487cb0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x7a6d8d3c4b588f54, 0x2cd89a3257e4ccaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x38437fdb7644a45c, 0x542289ec6de91b18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x579478fe749abb43, 0x32fff902684a481a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x79a1deaa75c6c33a, 0x3dc240fb1ba026fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x520eedd1374a3fe6, 0x12e685fb70c6a529, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #0", 0x649bb77c275ac794, 0x4f4ef00523f9c13c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #0", 0x180115be235ba861, 0x393865751cf10fd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #0", 0x15b5af5c741226bb, 0x47398c89354fe9f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x3f6ab60f61574095, 0x0d34b6a810233c99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x579be4f1310c50b3, 0x7e0c57b177ae35eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x25a70bf71dbabf00, 0x5ff87e052f305def, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x1381823a5db70ae5, 0x4ad084e91f48eaa1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x15014acb5f5e7fd0, 0x100f8fca6590700b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x06b9476442c296bd, 0x098a3148799d0247, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x661e3f1e5dc79ea8, 0x168e121f1eba5d23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x51d9c564613efdc5, 0x540a471c7bd3ee7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x42963e5a0a0382c5, 0x0bf72b1411447b73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x3b0fd37968eb2f63, 0x08f2b15e1a32234b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x06a5ee6414330624, 0x4962813b60b6df70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x71ea1109100f59dc, 0x7fffca111a27709e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x6f6dd9ac094211f2, 0x7fb7e0aa06eb5bd4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x4c04a8af1716703b, 0x00885e1b76272110, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x74de0ee368ebc550, 0x14e17e333222e7cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x4a2ac31539ee015c, 0x2df6d64846b7d447, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x43f1842260ef0119, 0x57fc4fbb0cc1016f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x49da307d7055a5f5, 0x26f324ba7f01579b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x0488ac1a5fb8011c, 0x5fb8370b50801ee1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x6fc75af86a5f7029, 0x6aa78f7f7672bd23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x73a1821b7de67713, 0x7d5e18f85f3534a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x14fce74e6a3dd3e8, 0x555c55b53fa62aca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x532999381fbfe8e0, 0x71c9129809daf632, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x59adea3d288f1a34, 0x5092ca791d545c4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x097e1b4e51088277, 0x2a155dbc1d9f6e5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x415e286c7c58fd05, 0x1ca0c5fa53584bcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x5c10fe210e7ffa2b, 0x23d86aac45e6d486, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #1", 0x78df6a5539b7aaa2, 0x3c5991aa4bd8591a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #1", 0x379e21b50069e373, 0x2b0d8dbe6c80ec70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #1", 0x6aa7b75c1df029d3, 0x2c27173b4c9b0904, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x3db012b32708c9af, 0x5675ff363dd15094, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x4f97e3e4053b0a9e, 0x5b25ace2175dfcf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x56438d15519e3149, 0x34fd6b4f5915ff32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x4df72e4e5046b5a9, 0x2c6e4afd17a1b582, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x5ec6afd419e21bb2, 0x5d888a082a082c70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x5399c65420ee1348, 0x75e0858a57a61a29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x2157f6bc704e1dd5, 0x4427069a0b37e80a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x0e3e47a82e48f044, 0x57d2f10e0bffae18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x5551b9f324f6ab8e, 0x49d0feac4bee5a5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x2a31b62d1849c29b, 0x634c574c24e99dd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x69e7f3e52a6de806, 0x7dff9d0900754342, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x7ab49daf759f82cd, 0x1816f8c437df2233, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x0f819e7f57c7d42d, 0x61e74ea3597b4d84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x78b5e77675486e47, 0x312167ad631b64d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x65968c1c46263dec, 0x6e534cde1a0dde32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x746f2e306fde8af6, 0x260d8c4a73d4d3c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x14d53685230f856c, 0x3fc32e2049c0e823, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x3b5948076caa2304, 0x6eaa85fb3f06ecb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x17180b0b579328b9, 0x3f7c2ff425413bec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x4d32ab863f07acc3, 0x5d205e2011cca8ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x16cf80f11c695dec, 0x6b47f63e5cb44a05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x11b1cc332e22fbb7, 0x3fcfaed90f856867, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x744939a34fa0d2e3, 0x2993469977485850, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x3f7f5dd92ae05a34, 0x6b1d2c1468b867d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x4defdfa02123d5f2, 0x32794ff75454945e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x0dcdf8f652d7b105, 0x135b8110094927a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x2a6ad9be0baac1b4, 0x2e8a639424e60401, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #2", 0x4ab26e7821faa2fa, 0x36b2acbc779d8544, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #2", 0x3e6400e614217e23, 0x5451cf496181ef69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #2", 0x424479da1a9a9e69, 0x710757d05015cd1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x6a3b714c327b517e, 0x475e256a368db37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x5d5babb351bf6b48, 0x1f461b5129bacf25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x72e3413a116ae494, 0x7e0f63842b4b8b53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x64429599631f1690, 0x3494b2fb00b13a31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x6ec9d8445c49eaee, 0x25973e320ead6f57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x7e448de95a9cc3e5, 0x064af49b397c46bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x6ebe42080c058df5, 0x1afe36253ca88ecf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x26a02c5e541c8153, 0x0cbe5be93102bbe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x0697d2d206d68ab2, 0x67906f6010db9daa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x5895f5fa38a5d054, 0x3a966cd063f37e85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x4a10b4e843d3bcd4, 0x0f3f09d84b793735, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x26f2d36471c1af98, 0x4c2a71662e534a82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x4e0b9a87434bae75, 0x3d00b9d915bcaba8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x1de8725a6a37288a, 0x4f38f2654c502870, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x763cb68015b71329, 0x08f8b73f0ca6b462, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x69d3947c2539dfa5, 0x3da970441cdce2de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x2c106a57684eed59, 0x2db88089706b674e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x20f4bdad639defac, 0x545ee5d304a66051, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x2771ac801c4a08ec, 0x501f97866b057295, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x0e0bb885565976f1, 0x1958bd174e647fe4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x19a52566335a1df1, 0x64212b8c5c17530c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x1d91467c316032bb, 0x28677b7c378d97c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x471745e401ddbc66, 0x44344c2213cdfcfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x27179c0b5e636063, 0x30aadfda30eada61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x46b24dbc75b52783, 0x215641af53280662, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x5953172f27edfe3a, 0x57ce66b467a70b69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x443807276c053b16, 0x52ac7dff00c4c3af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #3", 0x425eb207334a6f1f, 0x4f2943935243bfac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #3", 0x66a48d1156c28e34, 0x2e5b12b85c03d76d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #3", 0x0822c0ef57c5bb4f, 0x13916f2d0435d38d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x59a377b648aeb063, 0x1803d0894f3a06d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x271210c7217b22e4, 0x0024e13500bb13c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x17304a672bb180d8, 0x53e31a246dc45e83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x539f7f122817e7ec, 0x556b69ed70836196, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x141d2302407168d8, 0x7148254517d78639, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x73bbd7f81876589d, 0x6a1b45e5567bd50a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x6f38e6d146111ba5, 0x327fac775a606509, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x1dd6d6f4769a091f, 0x5e963896775ba7c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x3f48b98246ba8fca, 0x4695ae95777a4eaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x6835b2ae4c187c90, 0x7835626c665aca49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x77c9fd68298a92ba, 0x541f28cd7f65fd16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x51a27aa6613183f2, 0x6fe95eac4b697c7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x21a2ecca4d5c4899, 0x634102b465bf9da8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x65d2a1376ebb1f2a, 0x3c3b72b2155ec4c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x34cc3acf4e556261, 0x6fbf29cb550b8808, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x44ef6b8012fcde5e, 0x4c672fc952a311c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x59b76e284252c2da, 0x4a1d606e04382503, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x0e6b3f6a3eb21819, 0x6a92ef4c41ed20d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x683caad3313c7c99, 0x41531ded06353cd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x126e008b34dfbc00, 0x519eb94c39df2579, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x023c049a5bda35d4, 0x1f9ec3223410ed56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x4a9554fe392edbe4, 0x496fb218680ea5d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x07843e4509815da3, 0x3d1a2dd97f618fcd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x1c7e3c011c2201ff, 0x5204a1914c73a9c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x5e74c4d93b3ebe15, 0x50abcec97635aa2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x79f0d62f7975e8ee, 0x3822cb016ce00443, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x2ab2658744b3fa61, 0x73154115622d8102, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #16", 0x7993b6623bab699e, 0x1c0ca67c3d206613, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #16", 0x17859f723aa10581, 0x713153697bcfbafc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #16", 0x73cfe16520f88ea6, 0x63de60cd621af471, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x2a79ec49338125cf, 0x617c843e7b541fab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x4fa327ce1873983a, 0x47c7c97146f8284b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x53b2564f75509d76, 0x3d2dd2752e17eca7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x6ec686640e0d31ff, 0x1af7f0ea4da32c7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x52c12c614bdd53fd, 0x2fd0ad811978ebeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x0788bd9b47caa567, 0x569951fe4c54e2c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x026baae92c02fe8c, 0x48249dbf1f0e5d0d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x4cfb8d3262a5d5bd, 0x0129517e763b8c4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x1626fb8c3957756a, 0x718fabf97775797c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x51cb0da47b9b743c, 0x3e6da1c765ca235b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x70ec11b22eda00ed, 0x13e21002257d63f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x3ce732ec22f13df3, 0x732090725fb29816, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x6ece91f04fc4d600, 0x792b84010fa85f4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x178f7b672421dfcf, 0x5bfd421076574f8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x5024de5b168efe17, 0x1565ac9919fb2650, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x7934d3d401c65e98, 0x1036b29f1d206b8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x3b1dd403530386d1, 0x1495e50a0f5bcf61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x4e9efb0d090802be, 0x7525f2bc0ce8e1a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x37e203ab2586d60e, 0x3266459b3f8b0cbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x48781401186928d6, 0x1f3da4d574c93698, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x682dfed6606ed7f6, 0x047195e53746a5f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x0490b7c54303a216, 0x2d9df57d7fbd7a3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x5992a02e29ef532d, 0x19b8a08e54b59621, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x2bb5b1c6066be6b9, 0x71d601af52c77402, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x596f6d8a5749361f, 0x6223436366d385c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x605138de2622ad0c, 0x73bc6770280e6897, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x4ba9831a06d71a2b, 0x6799755618333c89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #29", 0x1f404301116e0907, 0x0cfc73211421971b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #29", 0x71dce0fd7906328b, 0x4b683d0d076e41d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #29", 0x3c09d4a120e45ca4, 0x072bbc16766d98c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x4ad3afd23cf93092, 0x4b232ee3159c74cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x4365174b4a872c35, 0x6863e8d276896198, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x21d0625551194ed1, 0x5d5ce7611cd484d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x773bfbdd2c7c62c2, 0x44e2ed6c02219b33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x33537ced27514ade, 0x1a54d7bc42e57ef7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x38bf53e5226f5320, 0x570716135293bfef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x1b7585ab612dbddd, 0x5a0201c72a9c34e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x02121a816c2cfc88, 0x2109cda4577f5a4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x29262d1a557fb7ee, 0x6d1bcf1c4ce5ca53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x2006e42420cc134c, 0x436f2beb6c8b4466, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x71e5621e4e42b6a8, 0x095fc93b41d74679, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x7abf196a5e4db968, 0x43f8e1ac69215dfb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x059f0446030df306, 0x2c06dcf32e129658, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x257d46265aa8580e, 0x00a656473e5e582b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x3bd615eb0a045ab2, 0x68fa8d0d40f2cbd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x7631573a058df53b, 0x1872261f3de8306c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x5b0dad2a4e3d26ab, 0x0acdfac01f578454, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x6f0939f8154291f6, 0x0be2c8ba7b14914e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x6385489e00e4b973, 0x3cebd7c760ee9c16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x5f3272db7616d704, 0x4a0ffa115e446208, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x7924ca0a0cfd4ea7, 0x0c56f86064d17722, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x67a5a6b50c2a5c5b, 0x232fcf4d1ea21031, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x162eb70d78070222, 0x5f94dc03237bbca0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x7d94f75d6c31e7cd, 0x6163ed0d0c600e47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x3a6f0e78379a5b56, 0x2bb7929b58a2a487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x4cdced4c10a30d9c, 0x53b735d529784870, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x1187c70f5476de98, 0x0a66e486306235ea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #42", 0x4a8db59c1afd9053, 0x0ea697f270ba39eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #42", 0x27fadefa78bb805a, 0x558bb10d43b27fa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #42", 0x04e5dcb541e96bdb, 0x62548fd80fa085b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x39f06dfd14802f5d, 0x331c42501b1493c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x00b2172a532c34a5, 0x2774a2093785655a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x0ac68ffb63df3fb7, 0x102809e23b2125a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x74824d546f00529a, 0x64996e1357a37d47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x4377313216ac4b23, 0x0805b331060a1463, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x31a9db764c4fff5b, 0x76c44e4e0e04e6ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x450b7fb6340bf64d, 0x51b7667559a4ba71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x75f562281c618271, 0x6945402149f15c6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x30e1b1cf0c7a9237, 0x6505f02e2fe5d025, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x5fa6c6dc77933f62, 0x676b35803193c8f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x5b727f19514e5cb0, 0x6cb4ee9c6a6d56d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x404eaf4a4a16874f, 0x4210d41e4ff4cc6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x60c2d2734cc32f1f, 0x55fee0d103c5e07c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x19132e7b63822dc0, 0x11cac74a126cade9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x178e240d5556a87b, 0x6c11685a5e1eae31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x71b82aed0d15faca, 0x28100a9c0d838636, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x19908d0224d48bdb, 0x3d69565b2299dcbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x1c67cb3d40e29452, 0x542da5b5793753de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x1230f10225b57ed4, 0x63a4aab677da4a57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x6fcc06241dcdf795, 0x47cf16c4527fa04c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x6a9126b568104812, 0x564580c8508ed897, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x4b9275d24f0ceedb, 0x62fb868003a45530, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x2463975609d30dfd, 0x61c30361632099e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x16e908c82e0d7671, 0x70a42016161bc243, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x52e2024d0ce344b5, 0x38b59eff307995ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x4dc5d9070d55945e, 0x29b0e9a86f49cd8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x330b13332ef32ea6, 0x672417e15ff6ca09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #55", 0x4cc1263b08bbeb1d, 0x32766a5522d71957, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #55", 0x70cc332f5661786e, 0x7365f1ee37524cf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #55", 0x256e67491cb9a581, 0x3af6a2203c5ea902, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x268cb37f102362f8, 0x1f7f42e249d1fea0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x3e30d96918a35fe3, 0x5fedc0e33d75bc47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x2586a49817a03bb9, 0x6def52111112dbb6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x24f5d0186780c122, 0x005ca941734c7d9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x1673efc805b9b1fd, 0x534347a85800e34b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x0e759d1a6e3dee90, 0x7ad7fca263351604, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x449f66fe557e0515, 0x1a8762f47f41d049, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x7237aa965b1fbc2d, 0x3ba0794b6a0dce48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x6b431f2513cd8dcb, 0x33dfcce818c45e15, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x2c70edae44296c6d, 0x563a1a5c2973f88f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x5bc9a8273ae37d86, 0x3a86d44551f79246, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x22643ea91887578d, 0x45440fe500bf783f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x1e41098a5398582c, 0x58c05b8a38d82e71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x41d646bc3694a76a, 0x1c0d44752cb6a6a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x0c12ac7f6798f039, 0x2bf876ee0675adba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x42b8ac67246348ea, 0x70837c027e4a5715, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x3830d6b66d48cf87, 0x170eb52b2dfbcb8c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x31723bf511f69861, 0x576fc41b64a1c464, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x4cda15e77bdd6690, 0x369956ab0d3be41c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x1464be1e66bbb7e5, 0x0dfb5c5b6f3e5490, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x3a5410114423c777, 0x2816830232a5c7a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x7ab86ee10b54e53b, 0x5f5c6e4d7c2a56cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x72edd5747323808a, 0x02a0048706cb1b60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x1786c9741c2427a1, 0x0515727635a681db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x096cf7283b121183, 0x63a24d684fb7a02a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x4d08a9e46af2bb3a, 0x3459648f3adf331d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x66d021ca56167394, 0x481b173919e2bfcc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #60", 0x3cd22b793137975e, 0x0921145c7b34dfe8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #60", 0x755b5ed60d3715de, 0x2ddaa79177263b8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #60", 0x188bfb1975f096df, 0x735092577013cdb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x691417697bf45b8e, 0x76dee9180b79d08d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x1818832f24c29fd1, 0x41205269009ae0dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x5fd4b15404abe597, 0x5052810821857a57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x6f9ea0d1247fc4ae, 0x5c64ad752cdd5b39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x7a9638434fe12f61, 0x46c01b05566ec29b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x0118c6c07f7e4a15, 0x51a3a284376863bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x0cb55ff321df319e, 0x2e8e9f4776742596, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x17cfc87d5d66dc65, 0x6687f34d25415b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x595b37f371db7e02, 0x30bb2b9900e3dfe6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x169e1dd351d141cc, 0x017ec0c47173bb22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x567d27636f5de2ef, 0x12f9357a7672cf28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x13dda79d6a104566, 0x23502a61461bc834, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x39f174c76e2e2d53, 0x1c8a8acf0e73dfe0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x6dac7768746ae2e4, 0x45dc439d3b0a3b87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x164a14821806546b, 0x317e611d7a61d75b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x756d30d0505e5e01, 0x1fa332672e19dd00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x4239dc03307c7daa, 0x2efdbce64ec868c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x024dbf7653355960, 0x403c23e658d7f9d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x42933c4f729af360, 0x4f4ac8ff58cae6d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x5cab38c63b7139dd, 0x1ee6af0d5670e3ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x299f67302ac1076a, 0x64e4c3cd169cad8d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x1f2bea4e03254a32, 0x51a6e915174bde99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x1b2b9e9d3150e85c, 0x11adb5f43575fed1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x01af465d128d98b7, 0x638fdbd11098cf6e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x430a16621f9d5c18, 0x5f61383243e92260, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x72d2b5796c0be536, 0x1cc11c374557d5d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x5ea6d8963d096bbf, 0x1e22bcb23565f1c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #61", 0x787aa59c70bb9983, 0x0bd6d5b53b52115c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #61", 0x1b7ca0ed2395a7ff, 0x51eebeea221a0ccd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #61", 0x26baf2314b13a15a, 0x3965eb663aa88b3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x7c6489b653ae65de, 0x701e8a0d41e690cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x663bfe9531e0986f, 0x527f603d7e13d013, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x517df4875ebe0eab, 0x41fcf274294614f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x4ac9f3e20cc0a782, 0x6e9dead04450aa00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x49ca1341058d717e, 0x79b69bc92970cc78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x76490b0136b19cbf, 0x64c2ddd54244b8de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x5a4744be1dc4b111, 0x645ec5ab11c5abef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x68d8526b3c8cc138, 0x4c6e372b010236ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x103b2716156827fb, 0x42e8c7be653cdc22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x4748c06a254d9ea9, 0x6350ac35767725ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x040bad550e5b2573, 0x1fbd3aa318c6b4f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x1b1bccf556cdfabb, 0x5d175ef24ed5a137, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x5c5b6c3a5d094b84, 0x78466daf64e5e036, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x13bae8430b895ebf, 0x272a991452a4773b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x294e0fd030d85a55, 0x646a232a6e022d01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x6d651b8d31ed2baf, 0x6f0463f11226623c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x475553ab5ab3ea93, 0x77633e5e7da042a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x0001893d13d4a2f2, 0x7417684f0e9e1415, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x222fc865047c27fa, 0x2764c907040d3692, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x5b4a22b54b294578, 0x52e2d7c93d4b955a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x283290fd495c0ea5, 0x2231759037a58eef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x54e56d646eb42955, 0x0a4a062b3bed7940, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x1f8c83ab18f40a33, 0x29efa6427e337d35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x4ae135e207bd1dcf, 0x1059df710cf19f38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x627108627ea94a2b, 0x0a91e1dc1236898d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x127ded1d483966aa, 0x20d49da36272919f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x4cb58ea439629ffa, 0x667fc83134adb582, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #62", 0x048be573142ac06c, 0x71f94adc27ffb15a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #62", 0x5d86cf1169ef4674, 0x5fa540492cbe7670, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #62", 0x58a36fca129b95f2, 0x68abefb0326c3c76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x2b8fa02540f9991c, 0x309fb9ab782ff375, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x48b6b6eb0fb37489, 0x052192ad7670d608, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x0e5cbeb4297bfd38, 0x08a75f952b27bf4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x71b563e3741a191e, 0x0d9a50ed20daabd1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x2d7cb9194781ac2f, 0x558861533e6af287, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x5bac6c9c460fe42b, 0x666aa3e132089e8c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x2fff2a9f477304ac, 0x5ec714fc39333bad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x5a0e9a9f1c3f31ce, 0x6b9f782308a29a69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x5d38caea05f4208c, 0x00d28dde059e3ac4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x15a7951504b67062, 0x7c0f10cc25ef81d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x2e326d9a5eb19210, 0x51174123240453ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x52cbab2e1a6760ef, 0x44deff9b1fe7d17d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x61e90d1e44bd67e6, 0x5e52c40500486447, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x0acd4c11111817cf, 0x325102d33d9579ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x588b1c7c62682d8b, 0x76c8b5683acc76b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x7ea75f5a44419ef9, 0x436f111a3299b71b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x4a35bf85344702ac, 0x3837f1df5be02a44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x38fd730e52e6ed3d, 0x01cfac1a5fdd549a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x31987f4d48c0a800, 0x03e1a864672fe0a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x632808ef656a762b, 0x0717b22604642a7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x2a27de1136fd9196, 0x04ac8ec34511160d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x4815a966796f4530, 0x02a68fc834f52a23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x5bd772bb3330b1ee, 0x6fc1a0d420a0c5e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x777250e70b726edc, 0x533a7cfd5a7ed215, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x3fb97188382ea874, 0x365efc5a41a8106c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x0b1595b125670d6b, 0x2185650778b6e496, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x6e27b56b66fe7765, 0x5fe6c53f3cae14fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #0, #63", 0x4c68ed9045bece3c, 0x41123f79514fbe5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #0, #63", 0x7cbc5fd319076430, 0x1660d4687690cba1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #0, #63", 0x1276a9601b479698, 0x2b85f5c444d20939, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x4e78488738ad4c18, 0x6572cf1b6e4e1c1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x441fbaf47f2bea8b, 0x48ccee3145ea996e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x375a92ff29180ee2, 0x0792a9db03d92c7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x4e7f1c4d5c76d652, 0x7c901113427028b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x43754db740307d27, 0x7f1e3dae3ca6d1b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x05ef4b642457647b, 0x0df690130fde3b47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x3d5ec8ab31f4fcad, 0x066f06e902abab37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x4d3c93462cf0838b, 0x477db4704fd5720b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x659dcfa306f07c58, 0x3e238e271bb4dbcd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x061c66e369321f16, 0x619f753b29bd8a97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x124a2df82a26c828, 0x2d96b7143d76f9e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x069d9e7a7f056040, 0x7fe7229260c94a46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x3f35dd672b66ac12, 0x1d701bff4a12ec32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x4fbe108e60602e62, 0x59f12779452528cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x12552b100f4e8872, 0x47d0d4020d1cd939, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x3c3f0bfd1b15d96c, 0x5cf24b455f91be56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x220655c45ce60f5e, 0x7b469a2321dcdba0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x46182e7579311d4c, 0x4b9a66382822bca7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x2357e5746580d91b, 0x6599b68958625c6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x6486395b569bc2b2, 0x392ba6b329f583ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x02026ec54df9979a, 0x7408702123bc16c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x2e59c5fd30b21390, 0x68e13f8e51c07f53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x40009c033bcfa3d1, 0x5edd588c40aef10d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x56e57d3d1b874986, 0x2040af637c3fa800, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x786d58e469b6e9d9, 0x1e1c83a178ebd301, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x62e8072506a84631, 0x210e8fa83e858759, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x6c291f4c50138a7a, 0x16e7e3c7063fec9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #0", 0x26af4d2d243de0aa, 0x3035708950af58a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #0", 0x723778445d4caef8, 0x746b6f6a28b1bbf2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #0", 0x0dfec288594f93d1, 0x7a723b4520913e41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x151f37a30180deb1, 0x61402f4e4dff5e8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x1d082837685b8a2d, 0x4a3f068c6c04b4e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x5212740605ff178a, 0x64f087e21575811c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x0ca75dbc6ae2ec3c, 0x53fb087534fa7b2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x3af676b76b6fd84e, 0x3b3a67c578d07d08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x0fadb8f83deb451a, 0x497fd5b061a5c3e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x1b37f41204c9bb1b, 0x0a577fd601e5313d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x5e194eec03b69ecd, 0x22766f7e2936b69a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x05377d7e41751bb2, 0x773615267338868f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x29d0a5df442dc352, 0x5f3d3b70223fa5b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x4a2cdadc0bb02f47, 0x37b526d27be319e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x76931b846c17fcd6, 0x30dd951056d43898, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x5787d52419248b51, 0x4fa4b5a13189923b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x570fd06b1d86d5f5, 0x132f561f67358e1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x225091100b912ed8, 0x691abf5a7247c47d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x0f47cda512b4903d, 0x1b7e7b170069dffc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x5429abef52dfa1fc, 0x73a2668c147f4b24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x170d654e6e7417ac, 0x36bef0da7dfa51ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x7a2446f32abb00c4, 0x79dd6bb3613a402a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x16d2fd9a07b32e64, 0x380e78c370b76277, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x20d7b9b535704ad1, 0x2240f4b26e5ad2be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x52f720c63eab2035, 0x559060db77e78a20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x4a3c4f0e05adc9b4, 0x6a2f4e9d7547b1d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x186259f26953f85f, 0x75b191d359841cb3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x3c339a5b24c258b1, 0x6e0367d76c8c05e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x1336705d6463c363, 0x6a8657b05340ffa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x0f1ec4276c89b896, 0x347b3fd30d5ab751, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #1", 0x743ce6fa20530e7b, 0x7e1219c825f1c1c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #1", 0x55c3594c69dcf55b, 0x144c94801514a0af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #1", 0x28881591772b796c, 0x0cfc2acf28ba7a13, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x7cd9432113b3bdbc, 0x1e022be972c4649f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x7d07b61b3a4be92a, 0x4c488152153b9d13, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x5f0e41db6c4dfaa4, 0x01c7a2f4393b5076, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x50b1be0840f78ff3, 0x0c7c501f7244b239, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x2d8148897db18352, 0x7f9f698a5fd0822f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x1e0491cd1a0ed871, 0x05c243f121be2f84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x03ebcdcc43cefb03, 0x36d2d03373c7eb1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x3afa746f3a849116, 0x1c82652d2c73e35d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x4e384ed36b80c94f, 0x1f3847fc37d3b790, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x25ccb2794ed6f798, 0x4d0f54a34b4004ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x3b24f23c10f7a584, 0x047b556504daf454, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x51ef357776bf1017, 0x771fa68d0bd6b044, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x7470936a71697665, 0x6ba732747f707e01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x0b784ed658017db8, 0x212ead8512752537, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x1bd078bb22bf757e, 0x063d10510f641ca2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x5d4406955b1047fc, 0x3bd8000056caed2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x4691114b5badf95f, 0x0e9ea4bb2b7c5568, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x2a84f0f77b37afbb, 0x76bc5a566c5dc3c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x0c2f554068585ea6, 0x7138b81965a9e333, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x5f176ebe5d27c5ec, 0x718093785e1e8ab7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x4e913c517ebdb63d, 0x5d8f08b853880228, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x56bf33f66c3a37b1, 0x65fd275f5a098b27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x0ef9ad2f2545a7c9, 0x696da7c9728facb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x0055efc657f93e98, 0x495a99dc6c3db3c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x33a737f70e766383, 0x17ba092c46e70111, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x09ae133e247d7cef, 0x3344c4d65e2c28ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x0cd5db9535569f99, 0x43d60c2115dd687e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #2", 0x127e6585518afbee, 0x73fbf3366bed4a53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #2", 0x5048b22c257273db, 0x3f754c7b610fa1d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #2", 0x11acab8c2486d4c7, 0x3b192cfd2707e622, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x49cc7c9062f22cb0, 0x199792d320a658bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x3aeb6b48249e15ac, 0x0ce40c804a226c56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x3314792f444e323e, 0x11096d686e92a33f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x68cbaf2d1094d84e, 0x4cbecc2d3cc28c6e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x45eb77e8469be822, 0x529ff4ec75a18ac2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x1826e41121042191, 0x618ed5165869dd6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x4676956c7492ac41, 0x39797f44686f963d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x19198108290f0f32, 0x0f777c5f582340f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x0c013be205ada634, 0x78c999b462e5fd99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x2a4bbbe03e11d757, 0x2d0869ef46eca72a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x02600995023e1696, 0x357f4a695d603510, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x12d2eee56cc2b66a, 0x1a22c17e6b2bb8c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x335e9e8d425c189b, 0x60cd438558be66cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x63603a2c6aa1c37e, 0x3128443a4b85829e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x5f346fc0436c953a, 0x33f518db29d6cf99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x6c7ba46c7ac3aa45, 0x01fa1091784df0c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x00715079083c5851, 0x5b33ee61787ce04f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x464e2fa874e8d1e3, 0x3f6987792abd0c5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x7726e879224002e8, 0x081d416a48ae393e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x0f02b95214a73585, 0x33d9f20009f9d75e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x57034e2013e08266, 0x62b83e2b426157df, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x7e8245e441dbf358, 0x0de6da7d3a63884d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x0548889266346877, 0x643a57e65db6b5a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x60f812bd313894ce, 0x5604a66d71c42cff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x3974ed1f29aa94c7, 0x6a410d4e61696336, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x1e9366aa1443b0fa, 0x0c266f907fc31cc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x3683b3e27c4b4806, 0x4871560615ba4f24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #3", 0x10f27d8c026c64ae, 0x1fb4268245866d35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #3", 0x164ce71415ce9f92, 0x07e7c51467f5cbac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #3", 0x57aa92ea0693abdf, 0x225953f914cf2cf8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x6cc81457488a890a, 0x7285e29d5cf31b7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x79c31dd838f855ca, 0x4eb7487c4dc02714, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x62a2ea913b4ff9db, 0x2f298a4a33380af8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x4f93aad57b6c7dc6, 0x32fb27c00136513c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x77b7c5cc36a4c6e2, 0x16f0a06006175eb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x39112b9053859101, 0x4b9dcbed08aa4358, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x6954309312f962fe, 0x70a00f054f5e12a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x198d0ede56b3223a, 0x642d3f9d40fec37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x1f3dab446ca92777, 0x1df1defb06552335, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x25a17d41033ed493, 0x54154a491900c91c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x3e8ece6e7f33fbd4, 0x4c38d414084467d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x7aa0799a206b596e, 0x097ab90e0e227944, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x571020515fd7a3e9, 0x1439d7fc72583f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x335d34ea6ba291c4, 0x7b0282bf10214be1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x7e9bf4c343ac9e23, 0x5f7f5e861cb1657e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x1a5fc05d7ba207f7, 0x5db028fc182903a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x684b2f6e7293711f, 0x1e7e26d6399d6ba1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x75d245b21ed708d2, 0x529e34bd0decacaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x1e0b04a61fabcd90, 0x1631148134611421, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x401726fe56bd6561, 0x42838d6518ab7e41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x3695094a06064067, 0x0b03bda81727474f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x71a8d22c06c7f1b7, 0x2748933169f23e34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x4a748fda6453ccae, 0x06a3a3b27044c6ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x5ff5d4a526ebf166, 0x086dca9064d45037, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x197f6285710ff095, 0x1e71bbd848410413, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x0fe6f9676c5ec544, 0x562db0c20f51a837, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x0c0a92d4063649bd, 0x43b2bc582df1fe0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #16", 0x5cf3af1e51a139f7, 0x469d7c4f4c21b9d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #16", 0x57a77a5e0a919453, 0x634901221388b868, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #16", 0x1159860a041e9a4f, 0x7d7af69d49504c8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x687266fe4202de09, 0x399513795bce15e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x68eecf6f5f1421f3, 0x40a2661b48683ba3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x5024128866d6f079, 0x10a93fb7026e31f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x5335b5bd55729684, 0x11bfda2c600b0bf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x5ba8e042549a864d, 0x0dfd09fe5f404891, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x263bc0440eab0386, 0x2b620264389c8f60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x193c97d949a03e66, 0x4c2547c97de33aa2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x4dbed8b500c89aa6, 0x4733872d2a961de3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x42cb78b0470699e2, 0x066433c736313fb3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x261abbd50f42bb0e, 0x7e997b572bba481f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x7619ab873fe85440, 0x2e287a14763ece5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x155aeac46446e44b, 0x5649da4d494f6145, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x38e16a9853f1ac3a, 0x288fa9d67103cb06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x629cafc075c5a230, 0x29a05a675f1d2adc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x3f65e0962433ecac, 0x5d00657f7bd94799, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x24fc87522cd39943, 0x266f657c0d24b94b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x73da332541ef7456, 0x4355f8ff67c80002, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x51322f6441aac236, 0x1382482219f4eefa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x01931676667d97a5, 0x1033bd58474bdaeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x4ac47bf1392ae607, 0x109b3c3016ee013a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x0d1c9241319226a8, 0x07f1cc4103a5e689, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x2757c8d83fc376e5, 0x62c311666fb94202, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x63f763911201ef18, 0x6b92899b66bda96e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x3ed5885b37385bb8, 0x73e262b908f3eae3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x7927d00e043e3308, 0x70bbeae632afbb81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x45e8f53e5cd867d3, 0x4ca4aa7b4a59ff72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x4355ff792241168e, 0x11a5da5e477c0bb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #29", 0x5b6bfc95665bd92f, 0x5e6a0cee0e1a7b6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #29", 0x17edffd774837359, 0x11c061f368888ed7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #29", 0x3446ea3e43d45a74, 0x5841d0d93f45c8af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x55d6498c19e5d4d7, 0x2603721d183e4dcf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x511e308f11ee2399, 0x213238b314abd1e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x162c56a1140037e4, 0x475b8d694a46009e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x70d89fb82645da6e, 0x14a000105c154bdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x4886f0fd01fb6481, 0x23915793342e9f31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x68573db154097c8e, 0x42491a9b23f2ed92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x488cefe864bd4d42, 0x0c7b7c6900453d88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x2891a7b7658e7855, 0x3f8b06387cd3da26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x7f744d2c364460a9, 0x151227f67e67f143, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x483284425a6f5094, 0x1313c32b50927dbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x6e6f88792f787e6a, 0x1ad87e5a5e5edae3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x55be58d95e057e55, 0x3a7426c25f482831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x6000e2d655bfe1fd, 0x1376c7621e4549d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x29c95e8b4eb3b3d2, 0x4238376848582087, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x3371011408286448, 0x489d5e1072564e73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x6db6dc9d043c5090, 0x6f2a289a5c02a8cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x3a80b1396d7e5d3a, 0x5a6a9a0f6d2b29ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x47edadcf589625e0, 0x3dbda78602b3357b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x080ea44a1b863720, 0x6112105e365d3648, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x798bb575291c25db, 0x15a55e795dccfd23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x7edc07d83e4a7e62, 0x7c1246f9598c984b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x0cfe32346a8216e3, 0x21e4b8d328a56663, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x72aa7b2b0a25dd71, 0x1afbb4d7406f3348, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x0e622e0176dc7623, 0x1c71dc14606157c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x645ad35d0b4a2918, 0x4d8c819248e2df3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x63e04ef82ca82513, 0x4b9614b52c48812c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x482e5c33784b15ed, 0x62a5b7746beef343, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #42", 0x21673bc845ce3760, 0x49bbf06641ba11a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #42", 0x0418b5c23d2b62c6, 0x1b46a9f3204343a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #42", 0x27ad79a963e45edb, 0x48e8aa041116e7f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x6e0a3c4c6df7f752, 0x51861b3e1a57f4d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x64d46d754845ce2f, 0x7ab94c9d7c6c6a4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x538ff74810e55e3c, 0x454f4987492f40d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x3d8d834f581d7974, 0x7577c1ff37704640, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x50688f616d1b29ea, 0x235f398305bbdf82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x32e9614a62bc9b1d, 0x4775f12a71cfcb2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x1fe7fde45afbb8ce, 0x12130eca3702170c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x3ee017a9199f1a40, 0x4818ff024795778d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x079711935ca6b8ff, 0x61ed6c622cea53f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x24ec872e6ea607c9, 0x2956be426c6b7f08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x7f8b66052b1281db, 0x359abfdb787c7e76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x032ffb4f534bfe3a, 0x2fecc4b73d18e954, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x406728240a4aba00, 0x42d4c8d653988ab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x6d07551e577b64a5, 0x456855da7350896e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x32771d73726b9f7c, 0x2a52a07a0cef5302, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x0c0ab9bd367236f1, 0x5484ca8f7157351d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x1318eff047984755, 0x1e41891213a1cb50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x363e4f1e35a80a34, 0x000d4a583805771f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x60ba8c0f606eba4c, 0x3081f59535c9b524, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x33bab88735b7674f, 0x72e29e7863ea875e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x4002214f7ceb67e9, 0x3783120e7421e0ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x5466cc8e11c50a94, 0x67726a1a2d09766d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x0430aa110e7d93ff, 0x39f8c96f06ddea01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x44efcaf01676a831, 0x78351f1e103b63ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x5e0eef8623ea7976, 0x23dd2f1e5808bae1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x599283aa40902795, 0x100e3200144d3ea4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x20fee1e23cf99241, 0x4a16f3c83a4d0fb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #55", 0x72b0f99055baa926, 0x1e37971754b99a69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #55", 0x52a6110f304de52e, 0x48db7b1432b31adf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #55", 0x4212efc319b55abc, 0x5fbc914d270cdd9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x2832eebb261fe6bd, 0x2deac79e464399d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x3c968eee7a5c2cc0, 0x567efda26d22b9ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x1e46a6365539a68d, 0x452b748d1aa57e74, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x15c9ce227909b0e1, 0x2ef2bd1877d929e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x36034322505dd0b2, 0x3226399a36c8b004, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x261879d8545dc582, 0x0b824a6d28b43cb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x04abaab03b23e8de, 0x5b67579178be8ae7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x54d9439b4db63022, 0x1fcb688446be9a73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x73d616df638131e9, 0x0d0234477d0c3256, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x5ddd5ea92f5a608f, 0x6a2eec02306ca5cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x0494071c7a04e15a, 0x4b1224417c2404e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x730e923b2623685b, 0x73fd2ec11a5dd53f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x7681390d5ca8cfb1, 0x512685432911d55d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x310695332d2d69a0, 0x51c6120f1c99b2e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x6851527f3523a650, 0x15583dcc35b23fe3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x02d9d67309730e9e, 0x7c70da573d2a961a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x6cf440882465b473, 0x3a36c87076afed52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x53c01502722eb761, 0x271c93204ad19f31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x6c3398bb3af2d2d2, 0x46f5a41158541c1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x61163b2e43d876a1, 0x72b1f15e5f422af6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x208146525a1a1262, 0x085400535797743b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x07477c03098964ed, 0x743127215187db85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x3ead0b3e03aaf5c0, 0x073a1b696f98ce82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x0d1e045e66fa2d0c, 0x2cc3649c4186e1b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x0b5fe17f5f536223, 0x3836cf037a1244e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x518219850bd98829, 0x44e3e4185f1ff682, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x46cc5afc2a2603ff, 0x377412a13db5b240, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #60", 0x6dfe7aa0254bdd8a, 0x1cf7dd3727e2962a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #60", 0x7f65efed73ab3186, 0x7f7a0a650e7fc0f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #60", 0x7d3496746741b7e1, 0x60079c7806ad6bf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x6aecada123099f0e, 0x76463a723be1a1b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x0a03cc1a359f5266, 0x7d688363780ab200, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x14f2b48a3700dafe, 0x721cf6e61563ad9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x42da63282bf7b6bd, 0x7483a41c6674ce0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x561dbabc41225d86, 0x242a804f09a6be24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x666e3b1131035eb3, 0x3189544e441c355c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x24ae903a32a392c8, 0x529bf64f65d42afe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x19e54aa962c7d160, 0x6c8196ee21e326ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x05d1706e5b2d4bc3, 0x5dc4c86004d1f84b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x10cc9e296ef9a131, 0x7cdcaa4b0fd53c88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x25fa7c3019bc8e3e, 0x2538ea2225bf52b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x45b444fb305ea112, 0x0c3420c268d4df58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x7180fe982404f1ca, 0x727b9d7c1bd1ffb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x5508507d328a2b63, 0x5fee351457ef39a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x652dbe2b2a44fb95, 0x3dc364a779b6e0b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x0d0cccf5795ecfc5, 0x1b9a07657f1308d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x548c1b8800c1ab6b, 0x03e5012012de3d63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x6fbb4c9c47ec640e, 0x22b379ec6558b9b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x61a8f24d174c2d28, 0x0b180c6515b5c8cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x47aace3a710645a0, 0x7e8aa824275d3748, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x150b376a231d6c14, 0x432f3700392bccd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x55a797774ede6b23, 0x111b067c6a1387e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x792366b97f647005, 0x63ca689f3ad555a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x78c33fca3dcd5f98, 0x39e85e78063033ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x3e8f0b033bc1eafe, 0x190e71124d4f5b53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x03ae4f0c3dc0216a, 0x32a815052e4a579f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x550c4e92428ac890, 0x4400206c65574159, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #61", 0x33910e314fe3afa2, 0x0cb478a21cb71ccc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #61", 0x73011bb666fdf01b, 0x55e2e99f489c459b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #61", 0x35dc5b3e167a3623, 0x32afcd8348a8b32d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x15dea6283d666748, 0x037e08d02effc1f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x7b33c6e04e3e66b8, 0x352ff5a60ea1e5f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x0a0051b60e99564a, 0x5bf1414539c2d1e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x4c5977b52c0d49ef, 0x680d29830daea0c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x6e98127f7fba5abe, 0x7305e21c2165c647, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x4f9e0a6013ffccb3, 0x3e1ce314222920b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x7afdbcce1d7533cf, 0x6ac5664c429f2616, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x33ef69f20ec5e214, 0x0b47d94330da180c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x4c2c495c1509cfaa, 0x5fd9da0449ce101a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x6348366234613752, 0x586ff60d4760103d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x42fa8d9d69300ba3, 0x0122e2206d488818, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x153d55926dfd0af6, 0x7af728da0f540552, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x6db765b46ed6aead, 0x30b9cb9903d56812, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x02d67b6010c3ef0e, 0x25fe88c23d557014, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x2e3922de0b3c6f6e, 0x7ff4962a7dd4382e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x1a0251820e882a3f, 0x2eae503b62288cd0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x2391f9e9046692f8, 0x2bf69ceb662e9ade, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x38c7ca4a2eb18d3c, 0x2d8eab1b06da304b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x17e198df6f19e13d, 0x7422b8637bc257e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x5d16ec343bd028d3, 0x0b165d392d1eee72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x2aa6d78056f2df46, 0x30f456844ace51e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x67b6ce5508185827, 0x0823c1fd2d7d52e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x1354c79559ffdb4a, 0x2b518b0f15eff133, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x68880589240f1aee, 0x78187e032d571917, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x2875ade641145f11, 0x1385b3f60c19ff72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x6fc5ec4d0716e820, 0x12f42fbd613d7831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x7630c95e68162d52, 0x5cffd01807a7852d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #62", 0x23e6562565baca23, 0x34c6739f5347b592, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #62", 0x3cada9692639c977, 0x1e16077a4e8d2da5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #62", 0x2e52219f275c0b96, 0x7c0a8086246477be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x015be6e0326ce6f5, 0x3a5468f141a6e934, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x567c01e30283b642, 0x6efe024c69e3ec6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x4398155308f21b9a, 0x75fdebdc7ef1afca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x100903ba3d2ef813, 0x602f27fb335e01a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x254525656fcbfa6d, 0x3b0586ce0639cd18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x5586c49077978a25, 0x598182aa492b7b8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x1dd1539c13c329b6, 0x17b8a93012346df9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x3b1f354c70ed4ea9, 0x3698e5b84c23753b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x235a359e7cc860bc, 0x0dca5e703c7b1c2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x7f4c16fe1c5cf473, 0x265f089779d63782, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x254f100d58f70f47, 0x78c7e74c42e42c51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x1626075a3147b4c0, 0x76422df2355813c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x2113af2d1513638b, 0x3b91e0e03b6b2cc0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x0caaedb01c4f517a, 0x0496a84a769a73bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x30127b313f67c76f, 0x08cee1b72a7c414c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x30551618046a14f8, 0x769fb6886b31b07d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x013275b44e0bd541, 0x27acccaa53af4bb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x6a68c9b5464d6a85, 0x4d858339007e8cb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x1f4479cc39a4e6f6, 0x4362b9030fb7d9c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x6aec9bb600a1ce6b, 0x450fed8a356a8126, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x15b531f6756c5631, 0x70d5ade60c004ae4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x11bba7ab0b69a058, 0x029abea122601fa6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x4ad167c7437c177a, 0x4cdc60f241ce22dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x47e62c7254aca004, 0x2cffd35a7b267de0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x22b875461c5b4cd0, 0x4ed5c9974918a226, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x62a8b7550cf9e7dc, 0x49972ed80d213efb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x469eced261e90648, 0x1cd918bd01ed3121, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #1, #63", 0x628ad4b3282d602e, 0x3757b247318b6a88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #1, #63", 0x1d99b65f4026740e, 0x3d8bb56c784006a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #1, #63", 0x4b901466677c8741, 0x1aa0264f2f555e0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x2af89ebc1e235441, 0x712380e716617c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x72cff445605dc3a5, 0x1187fa0e72decb2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x7cb91075058e9c2d, 0x3bf76d551588698b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x128884093f82c144, 0x22a9a8865f61c7ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x216bc78c18a6ab32, 0x614ef8eb592752db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x40d40b60483e72d0, 0x0ab2bd6403f69c3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x0864e6de16d6c937, 0x7c36a2e85e6dc1bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x7e5350787ee6a0b1, 0x0dc31fca53f4fb45, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x1d09f4f27bde7181, 0x6a567773294bef34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x5c3c3526582227b8, 0x1c2aba630fd9e937, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x5db0c3e5480bfb49, 0x256252c358f5459b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x078ebc8d19a60650, 0x38570d65703947ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x324cb1825413582e, 0x49609aca28fa8419, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x1c51caff2927c340, 0x2cf120587320bce3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x3ffe8c775f519e6c, 0x518e7ea224b6b1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x5e383f1d63022495, 0x78abad223e51dcf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x5ee0961603c88687, 0x679dcc247b42340f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x5beaae3f307e700a, 0x0b1c1d473b1ccb3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x788a6b534c691e3c, 0x141210d7399b7225, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x660f248c733554de, 0x29d4ba14001927e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x4748ad0d5604cc53, 0x2913abfa185bd60f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x7f2c8f935d0b1194, 0x0b7c92f2639a780c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x3c5cb00100fcd70c, 0x085129e93f2b1c0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x63fefba1651ac51f, 0x7d7cf8fb1a94ef1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x68e34ba720f34075, 0x15d7232e42df91b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x5171b07f120e6dcc, 0x7dfc5cf444cdf9e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x5e778c08283e261f, 0x7e696c0b49fc1bd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #0", 0x1b737afe7328efae, 0x4a1543b34486b095, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #0", 0x492dbc01685f1996, 0x5ce286a462bc280b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #0", 0x456a2b2a4ea7ca00, 0x4656a017485a4b94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x4fa4a10c0502609a, 0x0785679f01c6db2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x6a1d25ba3232ed78, 0x1c5bca4a33a39cae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x53262ded747f8b5a, 0x76832e6653007161, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x068df9261637d753, 0x17ce6b472497de6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x3e75fd7238a93df2, 0x6e93fa3e6505852f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x2bd22da0066ebc68, 0x298c35c459e97870, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x6ecdd5fe02fc4092, 0x3ca5a07b74ffe9a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x51a40a9344df9cd5, 0x3d5a353534380128, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x49e1fd6f525aa69e, 0x35fedc542148ab9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x048d94164b6f76b3, 0x54ec484d33ff2329, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x3fef020e1ecdffd2, 0x06ff948a57b3c203, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x3505d7256adf9aad, 0x7c4ba06f467cfb34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x2388d89f550eb627, 0x2b828063737bd497, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x5b7d728f0a0aed83, 0x4d654d084f5b063f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x0d072e1601b52516, 0x445aefe04a4b488d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x4694c1eb3482260a, 0x7e8349b65eab38a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x06dccca854e02c96, 0x7ff3e4481076bf5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x204fa3494b75770e, 0x4475e2840b6a60be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x6a4376e05f69c330, 0x631e22c1603ea557, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x4a495ddd523e20ef, 0x26bba08c1f494e05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x274cd717602a6fa5, 0x12c5229d6dd2367d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x6a355d2801882c9d, 0x3d2d3cbc02ca49a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x033d51b34b98dbea, 0x4d159234773c8b3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x001b01f455dba830, 0x55e7c3e749d2139e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x2abbd4c61ebeb57c, 0x5a48d2f806f7ce9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x6a342c8b7580521b, 0x12622f5a4b0b780f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x54ea154b5205bdf3, 0x2b4a1d675477a36b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #1", 0x2443dee20686140e, 0x73c0f1711f337328, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #1", 0x66b083b34a32e662, 0x0d05a9a54b90b5f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #1", 0x4bbb12ff1b7091d4, 0x4e5affa050e5e0db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x67096dbe1e0a3001, 0x48226c1a4ef864b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x73e5d83173134b48, 0x18ca785067246fb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x11d200c5007e6da8, 0x6e1c3e4e1ea1acf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x75febfc314f7426e, 0x69ad25077c062d50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x66fd0061443ec22c, 0x507dd0bb4ae8d50e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x4ac4d63a7721f1dc, 0x6a1c48360b40df43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x4154d83e252c94dd, 0x56d1953d317559ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x409d26b14a7da6e3, 0x025b3ac90d0feb3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x6887d6e474d2c83f, 0x5c084fef27a6946f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x67e613877ce7426f, 0x0ecb04215c6daf16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x7d65b01764bc8114, 0x7b0f5c0d79b8144c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x79b3c382463c1258, 0x75be419c73646fda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x0a7ad48428698d1e, 0x3e4d44e860b0c3e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x1f8b7efa42c33864, 0x6bf1a327553faabf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x67efcd4109103f75, 0x06b504ac60e05738, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x538de65849f89264, 0x6df04275288cf3f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x3ecb5aa35efe8c82, 0x503388613c15bd3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x5be5cef11392c860, 0x18836c5326b16e2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x784f49751627c414, 0x20698277594b7f08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x5c63d66c0afd33ca, 0x4cafeee272030cf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x3366c0e83ea57402, 0x52b3d0db66deaaf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x0168ac6642d35a5c, 0x3c1e55af52f23fe3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x4be399d121c2d991, 0x33d2971b695879a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x6bbb6bf56218f5fa, 0x11e56d991f71802a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x4117827c740aa9ba, 0x5b873d672a86c699, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x079d721a71a1b73b, 0x513834c41cfd516d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x07c97b4f42f8bf57, 0x7648d0757fecbb8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #2", 0x4df5f32144a39962, 0x71efc887642d51bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #2", 0x03490d64072a525b, 0x4b0bfcac015cb409, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #2", 0x49fdacb708218b08, 0x544ef3ec04b1b9ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x29e464997fefa10a, 0x6e0a337115e14689, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x6208970410da041a, 0x3552c6b3159fd08e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x04e4add4115ecbeb, 0x4026972723201980, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x0300832736663b62, 0x401d6aed0c821fee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x795efab97e5ea405, 0x0c6edb7e0ac9fe76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x43023d673a034cde, 0x6ef750324754edda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x412d9f391d0095d0, 0x48b1a1e3464b4acb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x252220d839073806, 0x4afd04950b2b4bf1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x38f6d910565f592d, 0x210c927a4f068571, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x67395d4724cced27, 0x64a655ff1aff7014, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x362bb9127e3cf481, 0x3e1f89946c1e0b1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x34a32fe3050f0687, 0x78a02b09392c3c39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x036daa8c32ed8ae2, 0x43f63ab02e022a9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x6cf0d7c03e08ba59, 0x75571876466fe7f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x5b09502957b83753, 0x0cbb32be2e1e76f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x10bf6f595a565564, 0x3949c2ea002b7101, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x30b5ae9133d84c72, 0x4f31f67249b64869, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x58a5399922d54211, 0x64b5b87d17ef0bd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x211236927cad41fd, 0x040d16f30ed0f2ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x01bc48840bf36995, 0x47fd2ee555b56675, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x3ee0f477790ea987, 0x03b791110529f311, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x371763e158550dc3, 0x4b99db042bd1cc37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x300d4516133a061b, 0x59f043301220b40a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x6d905b7f617e1b7e, 0x124c250c40ccb470, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x155667f06f38b557, 0x0a82fcd91e460a11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x120df7683a422cdd, 0x363515e96dfba189, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x36ef6eda44c9c31a, 0x7ccc943533202dfb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #3", 0x50bd2caf0c8d2582, 0x08d5947038abb75e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #3", 0x059bcf09096f8574, 0x3dd5aa6f0f9e2126, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #3", 0x61c493371560308d, 0x3b6fed5d3cb332ea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x289a36a861200c01, 0x4ed3e6f511d1d84d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x429e277f5d218997, 0x529e8cbd162a9228, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x4c5a3eee6aa5b222, 0x34709c3957f48f70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x24e7deff42bcc52e, 0x45f030f95e683656, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x078688481a5df8c2, 0x118864515bd74dd9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x26eb1e445258afa7, 0x148305385843b4f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x5bc8351b2351c37a, 0x67e1d61d2c86ed4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x38b1f408380e072d, 0x693a20383d8cc852, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x192e132e21fd2d5d, 0x4f5ea0a0614c2ab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x7f1eb6f42be75911, 0x7776bcd85bcc3aad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x168d0b3479b0fb17, 0x33c0ca1d4b78f5e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x3c6dc0453b69908a, 0x29e12c393b74ea33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x55c7894c2bcf3d45, 0x174c380d43f4488e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x7e27ecec0419d3a3, 0x1c37fd857cb2a790, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x276b971d1273b516, 0x293994de59f02208, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x4a81bc4366db8afa, 0x177cea5a601d8b25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x08d8b85838e072ae, 0x4169b5d663afcf71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x64c7cbc0733cd43c, 0x3f7c0a1e07f76f4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x6cedcf537d519168, 0x5370652f7b54d6f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x38bb21f24e15f934, 0x36c9c127295b8f98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x79e536790987d5ac, 0x6d4fd8260e82ab3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x0da1a94f346ee7ad, 0x0b3552cf780d2366, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x46e29cc3697a2fc8, 0x51fd456e350d406c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x5055bac356948168, 0x152acb9211645906, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x0f74f41634903296, 0x75142877592e731b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x27cd06d234964796, 0x6125e267743cbfd6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x31e7d8fe265b57f2, 0x6f9196ca14bad625, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #16", 0x747151262b663de4, 0x3e1665bd6aa2faf1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #16", 0x34ee1390045af8ff, 0x7925a6306e5687a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #16", 0x38c9e0ad3860f074, 0x6663ab06428fbcdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x21db203c0cc7c8dd, 0x779cfd4b7fac7d70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x635c4a450624feee, 0x1110d6777230daff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x3ab531842c853082, 0x4b5f4e1a72d13e5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x611b7818569f94fd, 0x670dfe3262823856, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x7cfaecef35537439, 0x773d0e7b13035117, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x60b9b21d76cbf238, 0x7da64c08716c3e15, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x7b26eb37462670bb, 0x5fc2c5b515a7c5ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x7e87612f4fd47fd7, 0x5837828c33f0cbe4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x5c9c48b544ae1fcc, 0x339d49552062816c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x4ad31eba5df2aa86, 0x12935c6b3ff892fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x0a77db0819d7cf89, 0x32c9d1560588503f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x707764865f479711, 0x680a88956b935320, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x149b0b4a7c3cf03f, 0x7e96a4376d725175, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x7308e2773ea15540, 0x5ede8f8a7554bd67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x04c7c5fb633405a0, 0x0afc83146e2fcdaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x3308857755bde2e8, 0x22209993034f272b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x1a6c02b436450502, 0x23b1a8970fa4ce2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x1437af880267327d, 0x4f9d6127653f216f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x1c3f020652d1fa43, 0x6ac771ae1eaf8a90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x3219915408d981e8, 0x0a42ddb10cb6668c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x051672285907478c, 0x7a28b80146b49c9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x17a89ccc4705dd19, 0x3c095a05781f549f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x2a39e2b9086fbbe2, 0x664f224e1c7062c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x5e2d9eca43713289, 0x1fbf89f25d426831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x79b6378c3c849784, 0x6ce7365d7899a17f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x3eebca0248a0349c, 0x5dd8c2ee0dede714, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x1b722edf36e04f56, 0x2c9d71a55b2acc08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #29", 0x3fb9d13e6209ea96, 0x67e132954d8bc034, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #29", 0x3b1132225049b6d8, 0x14405cd244d04366, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #29", 0x174f93f1233eba54, 0x3cef980652b9ceee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x2bae76360ee9bba8, 0x6f2a31b6418976ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x525aee320bb31539, 0x1ecbdedc09dc1501, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x4837acbe604e796e, 0x0275b6804c1125be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x28eeae0a069c7e77, 0x59ff0cd2072376c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x3d7ccdcd4a2f755d, 0x624e42c84460dce9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x2c395ff4262cf9f0, 0x11ec9d1d7d369f0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x7676b0c87ef67a78, 0x4206e272674a9216, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x223534cd292e92bb, 0x3a0461050dc644b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x38184e636e1b9a40, 0x4f4fbb644de3ab03, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x79ceaf7a5a357684, 0x57bfc0040a733c95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x3a83eff230836f26, 0x5684625342065c38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x371fed9d2b7815c0, 0x4929d2f863729dfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x75a78b1e39c01803, 0x27d37ae6749cbb6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x5fed11f333da3ce9, 0x71d35a7721e0eb12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x32d0b762432fde2d, 0x092b7d285663c2bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x6c5e70e83379c2d9, 0x642a07755505ec2f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x21955d1a7aa95737, 0x22e997322476bf4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x54decdbb056e5e35, 0x2ee9fbe11b640c94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x35f1cd5b26943bc4, 0x5d6a68cc0f62bdae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x520c51841aa8d690, 0x72d55baa6d11baf8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x5468ee945381d0da, 0x61ae766347b3dca2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x075c0dc472c044dd, 0x6994c7b434560087, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x35f0230a6ee3cab8, 0x0ab9c3433a2cc526, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x225d8d91321c4887, 0x0f32b155224e93f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x2cc59fbe75af4f20, 0x46c5533f43f2eaab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x7b1dad553cc1600b, 0x5f56f73f01a46d7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x63559bcf03dc86d2, 0x11072b28310f7ab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #42", 0x1e855d637fcfac0c, 0x1e2135a93561ed54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #42", 0x53517ce766aa91ab, 0x7d15c9f672ee4bf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #42", 0x596ad68831fe0fc1, 0x27444c7e5aad8aab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x20e1da79240d0126, 0x14da4fd10f5af992, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x562949ad786ee0c4, 0x31a98d85433f680b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x6e1e2fe5668949f6, 0x073252b602eee96c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x234aaa01159a820e, 0x049356e6693bdd3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x197708e0386c8d94, 0x1a4b57eb06a045d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x383c39a03917fd1b, 0x3c02332537fc6643, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x1fc28ec6522efeb9, 0x2aeab23a0b8db687, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x042d0e7a7b159103, 0x663b4132792d654e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x1f2292293a31ec66, 0x08885ee1250ee8f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x32a0cd2b6f80a3b5, 0x684e50ff754bdbd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x5609edab7cce1c29, 0x783ac54320befd10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x12689e3724463235, 0x09fada4a795497ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x5cb2bfc93bf710a3, 0x7ff4dd7e2bdfa717, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x750f0dbe0ec6bf95, 0x63dc0d5b14eef96a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x60f5be4e06b7f124, 0x207caff114d19c85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x01cd8227168760b4, 0x0dff01d36522ccc9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x50b94d1b728006bc, 0x0a31b5bd20f01451, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x6200aa710e76b56b, 0x163bf028035a1a46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x0b44d1942e13f1a0, 0x24191756380a981d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x525a23d631540d48, 0x315f2fca1dad6fcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x6d4b1deb2d69243d, 0x498d16e22f0ce39f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x3c2fe3d364788cfb, 0x43fbdd09625a2ba9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x6b307e1f052aca02, 0x772bc82e1d25a221, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x1bb22ab60c7a24a7, 0x02486eea6cfe0046, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x7efa2b63242a04bf, 0x0dee14976c6b77d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x32a0ba2a13dea96d, 0x6fc5921760fad5d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x41f29b0e4a649dbc, 0x19056df23de58bbe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #55", 0x7bb8ab042520126c, 0x5b92fb89144cbee4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #55", 0x528936a907557f8d, 0x4359a2836903c8ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #55", 0x6bce0c884289bcc7, 0x4b5df4980eb91a7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x47b486c92e272b88, 0x2bdebc9e56fe8aa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x3aa1503051ea9f85, 0x43fc8aed6366b17f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x7614a4443f97bb68, 0x4fd22951399b7b93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x537664d6339bbf5a, 0x1a96516828b55e6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x7e005d16422de5b7, 0x669aea2d1568ffe4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x674df8236d0f614b, 0x29b5bec879b9081a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x7464e0d82e1ac5a2, 0x62bcd10939d72ecc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x70a48269746f05e7, 0x489049496032ed60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x2296316f7b2e02f5, 0x3731780738590932, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x4d18a27a6b91e402, 0x1bbfbab15d37819f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x2b299f6b31694e9b, 0x16d2fd33432d46be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x65050df6527d8f5b, 0x6be2a52d7ea00441, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x14ab75123dbec2ed, 0x1409042563056b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x2ace24383f7b4430, 0x5cbe73277bf96d35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x6d9609d27e60e54a, 0x35d09c011f330511, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x72cfeb3136976a79, 0x7f65f2715e3a8c3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x31c56d6e3253501f, 0x1693956d15661ca1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x1de5342109709b73, 0x729d9e407ede0fe8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x3ad9ea0f2dedfbd4, 0x420b56a6490ed38c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x006b8b2f5bb7dbf2, 0x47aed7cd1fdef805, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x19769edf5fa2d638, 0x02e4631115170041, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x1f1e1a6946e10977, 0x11106d764444c318, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x4541eec262ddba9a, 0x6377c8290cb4243b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x19752513018245e4, 0x6aeeb0773811d9f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x33d59603401594d5, 0x4d77f6944b3a9281, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x498630480c23f910, 0x4a18a26951baca25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x3a11f4e46278757f, 0x1ac99db104601a57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #60", 0x3e3051712723756e, 0x243f125c3a7d8013, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #60", 0x06c64ba660a4edca, 0x4f94805457a6f051, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #60", 0x2785f7417f637b92, 0x1bebb36925e4660f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x6241362c1d873ac2, 0x32988a4b6cc7e603, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x1f0980a67251b68b, 0x24d9bff77bb65b40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x32674b601109902b, 0x46f0edc152df16aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x1d2d893b3f637e80, 0x2499e0cf7bed7ba9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x21dbf3ff248ca85d, 0x004d9600573f7e1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x4bb01dcb61517e86, 0x11bcfe32600c4571, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x41f66c50539ee92b, 0x37b335c252766971, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x530264bd2af359cc, 0x785acf81697c6391, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x487a948e7b1e098c, 0x5644499535439ae9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x6d6fc01777eae3eb, 0x30f9f62967841534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x08f474165efd0cad, 0x3a632bde1fd70b78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x1e608b2e1c121d21, 0x1bc487212621fd51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x409ec57e0f1e79a2, 0x7d617b70403c7f2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x706ff82857fbfa60, 0x2048c49e0c4ee349, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x2b9ae38b57201c3c, 0x5ec54cbb32666478, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x021376087227119e, 0x1be2c8097e9d4848, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x6d451b2a64dad95b, 0x33e0e3324a8e0a96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x5cc5bd466c754ba9, 0x32121fca5ab4db42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x4b72585616506ddb, 0x7a8be6ba65ba315c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x32628afc093daa1d, 0x0bdc2ead69d2e384, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x185c23bf4a582750, 0x2a0f62b27301507b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x225421b15e15807f, 0x7f5033c408cc1be7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x35359cbb57154869, 0x3b32805f4def053c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x493c5a07006d30b7, 0x4c8c4d85374912c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x65480a1233e93d24, 0x01d71d5936817532, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x205e88cd0bc2372e, 0x11365074420dc759, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x2212a50933a42763, 0x27c7f8b56bd0e123, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #61", 0x3ce1d1807fb3275a, 0x55a3c4a854753005, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #61", 0x4a0b4eaa46c6b445, 0x47768080553df540, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #61", 0x24dc34c4193c9187, 0x5e0a11276c5f705b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x7051d9f006dac31d, 0x3a4e75985a11d180, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x0747f3d41332019d, 0x115ae443398e33f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x471b3ec10145f99d, 0x700fa9296c8ffde6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x0d0830cb5665bdf5, 0x2e9dc53f6779c78e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x0a09e55828ee6d59, 0x534aa8b12f1ad5d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x28a194b34b06865a, 0x039005da46ebb6d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x11cd3a9f7a33bd40, 0x1c29ac1872ace35e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x13704ec7195ac951, 0x5f0c53b936a96f64, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x20358c6e22162527, 0x10bb40e403c228b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x354826c42d6005d8, 0x3d505cae277d8042, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x2ea5ff7542ab4368, 0x140d7e297c636585, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x1911015d3727d5c5, 0x63dd2d133bae3041, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x6016431e6e590bef, 0x6ac90615231ae6b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x395f924a063049a6, 0x6a069d8e08b7d7d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x006406e65a710ee9, 0x7b64bb304b2ccce9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x73cbd83b12917d31, 0x01d63c4d13d455ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x34a7a25954e6db13, 0x17967e64140164a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x0246e0eb4f8c6315, 0x3b7ee4ec69efc91d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x1237a67d4a305bb6, 0x66532ea330ece060, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x0158317b576416b7, 0x6c9b10a12b48a7db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x45bd22a6386a2c1e, 0x4e638e90616e749a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x3e9a75c5658b079c, 0x6a264c6c7f1cb4f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x3ffc16854c1fbe27, 0x4a4981da3efe7cab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x5eb13b596a6950bd, 0x52d2d25933c7eec0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x3f502bd003483856, 0x47c9536a1358ddb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x52d49b6b639bd572, 0x7d48a6cf41970cbb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x2dcc31295f1efdbd, 0x7283ed1c650c41e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #62", 0x368314745eb87854, 0x1054e9c32f2462a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #62", 0x1722a4727ab923aa, 0x1092d73e7c40371b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #62", 0x60442b4645a66de5, 0x7b5cec0b55bd1a37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x11c62c0d678e693c, 0x14bb96e3204041cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x51f7b9f91bd183f6, 0x5408308c70776766, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x1f19bc4c0118ebe7, 0x03d045181147e5ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x64b4c15a4562dfa1, 0x52def28571ee57b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x2481dd5f674f8363, 0x56fa99a01280f283, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x4607fbb752382c66, 0x41a555275b04f1d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x4cf1501052a214fa, 0x574528ee5d2aa02a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x184882df47a35144, 0x32e7ba612d357b57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x2f31ba80217dedaf, 0x4d75bd232a0eaeec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x3d4f71a61e565b6a, 0x1a8616520129747a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x1f6f475265504cc9, 0x12715a445c692df2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x2ab32c6b25521f4a, 0x4e5785aa042408ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x0ca1a2ad584a5056, 0x16a4fb2f4f3509ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x2a827cbc017f248c, 0x2a39fb9d52a99e65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x5421398662bbf8f0, 0x2fd43e8f7773cccd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x2a5f4a35721f0547, 0x24a948246c69bc65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x139cf2f630fe81a4, 0x16786b52599104b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x4f54dd0f6d2bd373, 0x5aba792f50ec649c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x527c203d7bad1839, 0x2d55928f6ec42461, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x20ff3783098d283c, 0x72e82d0d7d2f4ca8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x61d77892769e520f, 0x4c6456722da0da30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x781d769b301eb724, 0x004a78950c59f54f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x12dab01528770a40, 0x03cdc21c4c3eb021, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x1a960f874f20d7d9, 0x38a86c873d39fa4a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x001f597d7185782f, 0x16cafeff2e33027d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x5eb14ba22c74f9a9, 0x7f1f671a4f74368c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x282211e2312087fa, 0x3e385aed312d6bdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #2, #63", 0x3aadb0367ac10ef9, 0x2e5cb88749214965, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #2, #63", 0x715f6109770c9c2b, 0x76c223951c8528c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #2, #63", 0x272b534f2cace034, 0x28df1e18697cd7a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x5523ea746e63f44d, 0x35bb87c63a060364, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x3d84cc260e0afcae, 0x773ffdae6fb9f9fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x7f9074dd1d0c6392, 0x1decfc783da425a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x49815d3b4b50b71d, 0x0d185c305e41c07f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x7c713f183dcbe4e6, 0x0f6f2c5f71a36f1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x388cf3e03186dc18, 0x3ac4b882371eef4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x289378437c83362f, 0x53a4181729ec54e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x293016634924b453, 0x13692c8d4fbecb92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x3788a8a00104cca5, 0x09c4cef77e5400d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x0f0fc9530bfaf74b, 0x6e0dfad2750d74c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x29075add3fc9f69a, 0x32b19a6a0ea03e30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x0b1aadb77c512b0f, 0x6ce1feb07288b819, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x3a1d0ff51ef0dfb9, 0x642c2736078beccf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x5077bbd1124ef435, 0x3eaadc1e72aa03d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x0ed22a652fff854c, 0x1c9658be790b3414, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x7924399f528ece9d, 0x48c9ffa6380240c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x53939b4324643c72, 0x365641a030ace240, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x305f33bd586bf170, 0x25ba570662a36496, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x1835e80a5e25a177, 0x7143a2c759668e9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x5a76cc86301b6dea, 0x4bef46b4235095c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x4f0c4da369875eaf, 0x2adc82911493dc7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x7bd652e523d4390f, 0x073de0511f840974, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x53d3be5b61593d2f, 0x188f3d880aa87d4a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x33e80bcc7900ffb2, 0x42aabe124cf7f7fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x1d653c25235f3141, 0x7da4da3b077ba70f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x7bcb22b25b62ae6d, 0x6a1f0ba64dc46fe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x39884fe4731a4531, 0x272afe7d14010abc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #0", 0x2335b31c622e2310, 0x3751a07e13ff1c6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #0", 0x4bb581bf2fd0d936, 0x2892f8e5724200bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #0", 0x53a512462a5547bc, 0x11c60a34478bd4a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x0bae84eb14df1001, 0x523451ee2778d0a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x0de00fb37215a2d7, 0x7470c89c3f9690b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x1574d4193131436d, 0x471237c72b454bd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x0c93f1da2034ba38, 0x7909bbbb113ff6cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x134eff6a5c92a206, 0x25410187461c41be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x3ec0c51602ae570e, 0x5a1b5e283684b286, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x327f30443a8cbd79, 0x28c6b3450a7646d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x64e2053624366d68, 0x52021b7a0624428a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x39157d69220ddbc8, 0x2d9d132c70908a21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x14237ea0773952a1, 0x30271ad946f58d1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x286a960e6b4494b0, 0x723ad8f5299852b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x0b794ee960194b0b, 0x3ad8498434fe87e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x3cabed11553627d0, 0x7b1ac9a71ec84e53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x57e47ede7e13b41e, 0x554d00d97b6cb227, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x38a0719857e51477, 0x05e2f8fd0a63af22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x7c1b81df3e2504d9, 0x1087f1ad1d8276ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x6032e0a13e3a1bc9, 0x0e1300ef3530ff49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x35736e6a6e61655b, 0x7c268c6674565f41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x59a5fa0c58c6fb7e, 0x1deeb1fa5dde0478, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x38e0468a0df75609, 0x12dc8c61651f48f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x632d7dd959349821, 0x03e79748758c339b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x57484c3f76dbdec0, 0x70f8e5c33b11fcb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x4ec0f33755fd9d86, 0x4575abd90fe8bdd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x1422a25f3b7e3595, 0x2d6b34a54adc7516, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x79b8515e7c3400c5, 0x000d745f74558301, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x6a956621069a943d, 0x68abe2422f2bbfc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x5f618fbb1fe650a2, 0x0d09c440443b602d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #1", 0x2ddda6ab2d42406a, 0x295aa9221841d645, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #1", 0x0676d88b7ec6efa4, 0x0dce09e1110b2484, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #1", 0x75a2ce641192cd14, 0x4c1d213b5dbf24ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x67906a9b1b131747, 0x6da7e2a24463c19b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x56914cdc0f4dab11, 0x0f4036b17bb30cfa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x0b81abd658b4723e, 0x70088ffb50499e3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x5f4f067b0c7f2243, 0x7f755e02761711f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x2c6572e563ad1b46, 0x3a5272243eb09636, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x10ef5bb064c0765d, 0x56f26c7c5a431990, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x63876601376b5f4f, 0x6b4e3e141766343b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x48fe2c6362cd3ba8, 0x75255906592a3465, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x7de052ef2cce2cb1, 0x1d8df600308e96fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x3c1bd7c21c4a33f4, 0x2c41a3f954719fcc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x74fea63224309c09, 0x24bb3e06479d8399, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x30afbe4c780707b5, 0x3db49590544dacad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x5bb422fb69f0af60, 0x12fe42e45d153131, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x4eb125bd22a688d5, 0x37584ac16ca37eac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x5a11e824792f0bed, 0x0409b2e732388bbe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x5bfc479528f0b623, 0x0b62c02323101487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x55bee2d47fe04f7f, 0x539eab8659dc9a85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x1c2a837353097857, 0x2e4e3a5111daba97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x773a1460172cd3c0, 0x59783e30112929a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x0f33db7578751937, 0x6576d65327e9d2ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x6265c8973c574e9e, 0x04ff03dd6ae7fe71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x5efdd7735b953004, 0x578b7d1d3116ee54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x54c43bf26eb23a35, 0x634f7a12390fbf97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x17a2f0582fbe7fa5, 0x5c1fd41f30c08387, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x2f9ecf2438eb585d, 0x0a9d1e0c6d61d32d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x0bf4d0b558b4cbf4, 0x7f3c8dc44bc95297, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x6fe19fb442695291, 0x5cf27c3d032ee515, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #2", 0x3ade6bc83017bb9f, 0x2b18b7c27f157b2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #2", 0x6c6f0a3e4188f6b8, 0x69fd799b1d443460, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #2", 0x1d1e26bc31aa9cc7, 0x4e5b22b44b6ce1b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x205cd6fc609c7568, 0x047ca14971e262ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x105af50d2d400442, 0x22a2e63637ffc755, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x662b5ca0249e2846, 0x25619a823ff9c431, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x7d52f43a68b59306, 0x0bc316c872202d55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x2b1ee5972067ca2c, 0x754f126a6d3493ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x507f85cc564788b3, 0x6c4a0f1865fd515f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x17d07f6b519ca874, 0x034185bf3cee900a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x0347453b0cd81304, 0x085b71bb34eea628, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x6d74886c4973ef0c, 0x26d108d623a41c37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x76b3f34f01057e0e, 0x5ba3e38c7dcf7d79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x25a3a654498c5873, 0x3dc941aa5cdf4fef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x3241eb79444e8fae, 0x4eff7d4422f69a8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x64b659db7c753d95, 0x102b2e7d5d60d110, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x52bcc649469fa82f, 0x435e226f3535dfa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x183c50a37a7fe16c, 0x72246fb16a8d45b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x0757f471464cf4b3, 0x1f7bebdc1b8395de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x0fc0e3bf1acb95a2, 0x3f27b21574cc7cdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x1bd113b030653c01, 0x729bfa570674d70e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x79f194743253a441, 0x635426fd4174ba05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x76a233f074968310, 0x646b54932c337fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x710bc0a64cf2736d, 0x099450fd5b588dcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x13921b9c02b2dd23, 0x108e6d7243c886ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x7d32be8f4dd1b880, 0x2e55cca32bce6c3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x141ead330679b432, 0x4752021d048ab300, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x214549d46bf32a35, 0x79572fde23df90f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x1c5866360da88efe, 0x2a5468013d165d85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x3ffc334062f66c1d, 0x7e8b178a1649faab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #3", 0x578cef2e4c11cb96, 0x427d7a98369e6730, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #3", 0x19043f032285626d, 0x11f6f4fb4898afd4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #3", 0x25383f903ab70366, 0x0c6136c32c965a9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x0888bbe61fb6c8fb, 0x5864c6de226afe1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x26307d2d204ce0fe, 0x26f5b1201ca76919, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x0c400b336adb620d, 0x4086fa0c4775c702, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x7883f10b03173c11, 0x048c248728987169, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x660da82e015fe6ad, 0x3ee26c143880244b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x4d71b24301158076, 0x6f1e8b7b3d9a975c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x239ae2e312947df3, 0x063347306675f146, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x4d4b815a6b7112c3, 0x130c4be548d32273, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x0b27dbbe1233d1b3, 0x6b3e209355d43d40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x3280b2b13302a066, 0x727ba65a315858eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x1dde02737d5a4474, 0x78ce1fed3ec0bde4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x00718085263b9b62, 0x67592f4d1661f37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x279b820f3e00a345, 0x4ee217ca667f28b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x3f1623bc2a4d0741, 0x2419c010750d3452, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x3ce185346e8f717d, 0x5b83259862b1069f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x5a00844016c249a6, 0x2b8429130a2d068e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x28f61b59527cea29, 0x600143cf65285ffe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x057f8a8f0f4ed8d7, 0x1680b8e95b76ce0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x0ca91d4b0190bb3b, 0x1a378bee235d8d02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x27cc569d08a1984a, 0x39bf80800d1a9dd1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x46a23b9017b38695, 0x7399c6854f67d8ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x42008dd61ff83296, 0x44750cfe05b85f4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x0e87a41313ed8efe, 0x686965eb7ee2130b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x2aafd8a469105d68, 0x090f199968882853, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x3b8d47916431413b, 0x4db0885153a5f3fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x73801a1249544df5, 0x2f1cc207410cd220, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x4ae509311e29dfa3, 0x646a5f220029375d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #16", 0x26cb77ed00dd9bb3, 0x0d43d52e72b15fce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #16", 0x18912249068e4579, 0x4219387b6d6db37d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #16", 0x268678105b8f78b5, 0x732612c95a91b01f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x6f7d07b36282dcc4, 0x5973c32a350e1c23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x4b933a2c6b46ccc8, 0x1d9644771a2ce058, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x4f780e031cef965d, 0x6dd2d455072081be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x6643e4522c97b301, 0x482d53de42f82815, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x4ac192a4506534a1, 0x43215f733128ed83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x5142d05565f385cd, 0x23da4d52718d0a91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x6c81cb465220d0d8, 0x5efabe0f69d3f29e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x2db0498d1dd965e8, 0x4465a2bd13084356, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x005c42ac65aca3f1, 0x48165f7a1d2d5141, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x50f370b9252d05ee, 0x375a31994bef7cd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x421c9c4b1b3d5275, 0x530ffe96206b7ebd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x47d5057626850645, 0x6363a6d22860809e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x76ea3ae77d63bb73, 0x59896e211296981a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x63574140631e60ba, 0x0423a2ab482d0b3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x353f31937666a097, 0x3200fdda4fd90c87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x1440067f2af7af57, 0x62e14fdd62ef7b20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x10a453483776fdfa, 0x001ccc61149c492b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x5ca403e9339bc49a, 0x608bc6046197c402, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x4ed9170f6566e991, 0x020342bf1ec0a034, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x0bebefd720aa8ef4, 0x472120d216ae1c85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x1e0e4a672d68574b, 0x2944b49f02d62abe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x1086b8057d0433d4, 0x4b0335fa01658ba8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x736ad46b341fe80c, 0x513e982f45c5e998, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x5f17976428d2311a, 0x28b564b907aadaeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x60492f157cd2ea1a, 0x1c4724166fbbeaac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x306eaeb55356f16d, 0x5153aeae3ced32fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x38bddaff22cef405, 0x5badd3327f47c5c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #29", 0x437982f93f3a96e9, 0x15f5e24a44a9cad6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #29", 0x6ca2ee3412832b8e, 0x477ff5946187cd60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #29", 0x0f875f62342bf137, 0x62ed59087d29a63a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x684bd9446ba4f48b, 0x42ef8fd202f233cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x147725a626e432cf, 0x0a9d0eb8476370a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x23b71ce908730a03, 0x371f5b5474c054bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x5bc9fb700d5b5aeb, 0x31ad87b95425cb9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x302a4ef0696373ad, 0x536d91631487d66f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x289e0a9620b196d9, 0x5931a14573a3d1e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x3334c2673818f852, 0x552b9f4a1540f8cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x6c44e98a555a2ed7, 0x126a9f0542bc21c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x40ff2363504b644f, 0x45ae55975490c2ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x772f971e53138eca, 0x1bf4337655764909, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x5b8698cd7be4257d, 0x4a369dc41ae6b408, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x093f8068427a1109, 0x6f0c7fa63750943e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x2bdd84b6250a0bf3, 0x4bd86aad3969cf59, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x45bba2cc0239408c, 0x2d0da142547b8f4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x3a5238df7c27271d, 0x69bc881878f06534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x518155f4015adc94, 0x3bac86fd26972269, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x51a640e4171c18ad, 0x7b27e53712807957, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x6a2fa777322d6024, 0x67f6c26048d5d802, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x2e1185a152c90bb1, 0x63bc8c0a45b64045, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x15431cba48df3f30, 0x7d06d4833751060a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x6de94b231dc876a5, 0x70bad5634120a171, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x2001b7327f58b8d6, 0x159c30be33a4edf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x7b7fdff36841da21, 0x2c9553245a53f011, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x699cb6b67c12f7b1, 0x00eb127a4d0135e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x132f105e4778719f, 0x5f81af3f3b42f79a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x79a5d1c467d55ba7, 0x0418cf9c7d5eb7d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x3a9e6758401bcc9d, 0x4314f81a27b75765, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #42", 0x08fb0bce4fc332d2, 0x5f085d6f4fe18412, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #42", 0x6d8ba978269e5641, 0x1102258376e456f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #42", 0x25f70f17571e9805, 0x2a8944e10d8d60aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x3f60722768cc6335, 0x67e150bb2176ef0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x64df5ae64df9d431, 0x6e7824f228fd28dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x157245d06858f013, 0x64402077780e6b44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x502e4bba38821b34, 0x756d23190f181794, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x789de7d115d7cc69, 0x36cf6efa0accb312, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x659aff3c6bb05ca8, 0x5aae37250198f39f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x124eb2ea23068f72, 0x787d4a915326a8b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x7a25277848955a19, 0x60b4095e3845c201, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x3161bd4e4834d5fe, 0x59bcb10c3985999f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x162eaa2f46c2e2f3, 0x6282c27c16411834, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x2f1bd30603bca691, 0x0e4f83782ba0efff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x3c3ec1c57188768e, 0x3ab907947f4a1ec1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x076042f764c508f8, 0x0a16d1d334dca997, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x507565a12ef2e7c7, 0x36759d366cfb4233, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x51f9773a20d5f445, 0x4021eae762c4188b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x696b4e5e74c68b98, 0x1b09da8c4c1e9eb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x3cfb61966826facd, 0x05a438511acd0bac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x2ee9ddc03f5da758, 0x310e23e0532a0bc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x431a4dea39840359, 0x7ecafbc55e05b0c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x2b0c79e76766a15b, 0x5d4fcf877f590faf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x4c2baa536aab567d, 0x3435b946326cbcde, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x199e3e445f89e9f9, 0x1f67ff121ca10ff4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x005fde3f1a6f030c, 0x7f65287f6b97b57e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x0f358ea43d5a8c81, 0x37b6543069cb2c9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x2581874e35a65c2a, 0x0498384a4c30f03b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x750403831e25f7c5, 0x1f5afc00546b650e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x57a9fb1e0fc0e55c, 0x327115d5381e516d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #55", 0x772786b76bad1a63, 0x3777611c02b67505, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #55", 0x565870e0548b30f6, 0x352331e44353310b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #55", 0x34151aef5f59697f, 0x5ff440ff6ff6af24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x79c86c8b1344b8d3, 0x5b8e64a33474f92e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x509f455522d85e16, 0x1e4025cc08fdfb2f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x587eba407489e76b, 0x552eeb6a7620cca3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x12afdf307cfd4787, 0x4a8c31b24d82bdc3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x0cbe2ce33d18704d, 0x05a10f306a59da4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x28c58ab022338138, 0x6d104f5403e5b39b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x76beb22e272d25a5, 0x4738e4a67f1dfb90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x06868f244aa30f57, 0x6f14aab42ad3cd1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x5de7c82b7d88ec18, 0x5f48c64c004efbaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x20614a2e5e7be249, 0x094cf6df2e870d80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x5305c9b46f340bd5, 0x24a7da2378e0046f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x6c31535c4c03d163, 0x4662c23265b5a8e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x091c41b03d1fd288, 0x500f833478ef8040, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x5f5353c1440e1881, 0x7cd533db31e1cc60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x6b3b3e26201472a4, 0x30ffc7f0561205ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x6ab781fc602e995a, 0x00e5d30d71c1cd4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x5db785727b5dbfd9, 0x7210c8fa489f4a27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x59d9a2231bce31ca, 0x772657a77e18cfa1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x0b023da03d5b9642, 0x76f8d4102cdf6bd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x095f67a562a497f0, 0x129514bc773390fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x1fc46a796cf84517, 0x7023113c127ba955, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x31065d98755d3da5, 0x445d75b57f17be3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x1571b04a560f9737, 0x5529c4291c419bbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x363e309100143204, 0x0e03690a00293246, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x7b71f1de3feed414, 0x48c87c6d13f5b603, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x5bbd05de090759b4, 0x120e85a4554b9401, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x4662eff714c01495, 0x022affd866bf437e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #60", 0x7764ac854e15e5b7, 0x5df2d47b4fc2579c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #60", 0x3b0e2acf269b76a7, 0x623e00f2172916fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #60", 0x1bf8b44d6b6a9962, 0x1640d5386c148867, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x417a309916598d30, 0x08562426316a6497, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x166dbf357a5c134a, 0x319396dd77b8612a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x3a4ae75e1dbc9cd2, 0x0bae172d11dfb113, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x26c3f686695644ec, 0x672b45141607ed3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x7e1659815aba0536, 0x7cc730bb6d26e67d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x28cfeaed1f273f0c, 0x3ce93e1a757b0607, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x45c2b5b322e4f23e, 0x0ca41d0563de15bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x0e4f8ba05848c24a, 0x4ff29e2461bb6a00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x6ea24f7b44b96574, 0x1325ce974fc9bc39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x3f1578be53303490, 0x47821d6305100eb0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x70ecd1627e1b04d7, 0x16efbfc37960601c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x677149c30c2f7e14, 0x0f684d5917b0c7e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x66e9834a41c0ec80, 0x04d7ae666587a345, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x60e82b8c67a6c651, 0x5b02a94c0fb96e37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x0a8bb88f438a2218, 0x739783f426aae140, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x1bd2e4621b8c19d8, 0x08664b4018db442f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x60457f4c30271dcb, 0x68a500680a7533dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x0357525c26750250, 0x0f85428d1f5af80b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x249007272823a580, 0x18bb5827744423be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x3453239410cc9a0e, 0x0bf4eba70c0150eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x528d868e4c8b9d7c, 0x7188f4301b3ca6de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x343263cd1e8d990a, 0x2af615163375b21b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x6217bb226286de9b, 0x5a20935b3ebe1c5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x7e12f873403e60f5, 0x5799608c7dea9f84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x70657ec017e515ef, 0x085fd3625e5877c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x3e5a1840166ec7f2, 0x7db36fcb73bcd11c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x3e926d7373f5e082, 0x6800f4db62ea1f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #61", 0x04c27a9060746482, 0x6eeb705272e59107, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #61", 0x2d0001fe39184cfc, 0x0e2237e65750011f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #61", 0x57a5e60664e64695, 0x0ac5b33a613265cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x476d25307789e2b5, 0x1ff0822939bda128, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x37c843aa4008140e, 0x37a840ac45801da4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x57ed29fe218c052f, 0x23d89564282dc26b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x37facd2103eb8862, 0x1bea93871647423e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x77e168e5681cd1f8, 0x793161a5768d3a94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x4891367a77950382, 0x6972cb9c7ca3e375, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x30ad507e5eb997ce, 0x53f3e49475913879, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x439fde6376b4206e, 0x56c39e4508533684, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x6e3e032379b91858, 0x4210d7ac0b0d0394, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x39c12c677465b69c, 0x508d2138260646ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x15f1bbcb6a1e9cc0, 0x4e34093911ae5665, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x6e0a25232126fa48, 0x27f598a34dec88ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x0943cc402dec8f1d, 0x4479c38165eb8e08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x2581929f36835612, 0x628f717d51d502bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x153cede01e29d979, 0x47663b34562ee31d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x14ddf9e72092f14d, 0x5e8219a158dccc44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x1a4c09a53476f110, 0x63e9cfd8031bfd0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x28dca7ac77564d11, 0x292243d8540d360c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x6174e9d20db12514, 0x65bb8c713ece6377, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x2ed81f5d5134afe4, 0x0cbaec634f7f0ef5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x7f213f0117fa0e7a, 0x356a9cfd381beb9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x4e7d648c5157298c, 0x09f0ee5824a2d1a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x6f8103055953ce5e, 0x7ad1b4bd63ba526d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x79e6bfab2080ee89, 0x3c971eb1045efcec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x54f7df99309d3dcf, 0x077af9f71432c951, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x27f38ae14dfb8bcf, 0x683fff5d7dd48745, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x5bacb0e3495dd71f, 0x3ca2eabc096874b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #62", 0x1a9287040e5220a5, 0x58e783a80a84d040, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #62", 0x264c2f1f4c91aa36, 0x42a0bbde19b3c605, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #62", 0x1de8d3c339284c63, 0x3e5697a674c993ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x127c1ac2151b04ca, 0x5883e6190d69d6c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x359bf3531943cdac, 0x11c8d3b50c62da6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x49e10b7b08d5a31c, 0x2095a3be0a93d2ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x56d12eeb450b44ed, 0x08685a3171d4965c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x0e691c0c54248eb7, 0x7b3d0b0f327ddfce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x6276af5c7fa36bed, 0x3d02b00f28fba310, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x4c351623010600bc, 0x42af691608c2de7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x3a2e4d1f56105841, 0x7d8c72286a1de9e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x6b2b5d0b09509464, 0x7787c0af4caa67e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x2294621079a2e60d, 0x590d424f20c7505e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x0278892933c37d7b, 0x2b5b234a6c756d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x78cec26859870ef7, 0x5e4a03e85949b814, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x2dab9daf48ca47f2, 0x0bc797e30737de74, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x486db3df72e2ea9b, 0x3033818510224d0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x73e8eb5716719daf, 0x18e52b8714a2ca02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x6c81f5f076487498, 0x7ec0b3e92e173876, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x7f9908fc53cee2a7, 0x7ac1a05857ad52fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x4d71c8b423cfc6a3, 0x7874a359222d6b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x5793441e6cecdc7f, 0x0ea2d8974fea51de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x4673eb7734fba1d5, 0x293409f250620686, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x7dc5e9c707cd6680, 0x5799e4fb741f8926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x7ab0511b1d2701b9, 0x0441d63146339da6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x33989f6859971b92, 0x5ad667a96e993c72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x4fdf902a17721540, 0x1cb074e8201a9559, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x6b40f7e7703c8bae, 0x77c7e8544f789926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x140c52510048dcc9, 0x71a6043238b2c09c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x6d35b94931d11c6c, 0x089d127a6b9f9670, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #3, #63", 0x66ccbe42139b81f1, 0x3c019cf633a9a4c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #3, #63", 0x1b68e8712c0b0417, 0x27c92de66492a809, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #3, #63", 0x493205d0059cad59, 0x2ac645b01619398c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x5f33c8eb2162eae7, 0x04b275fe7ccaa539, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x38d5002714ad22e6, 0x1ce53a922f135915, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x04e9ae947031f66d, 0x7e8bf23b2415f80f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x707ad3366565cb25, 0x5cc8b8ab18f600e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x1736e7914097344c, 0x049597565db08c7f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x5432b63e39235f25, 0x115a313f7e03a5d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x652e633d0d5c938d, 0x62964ddd6f9b9eaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x12f940e60a674e3a, 0x05b4d83c2e60690d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x2bca3921481048d8, 0x2b2b0e46722d09d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x5cbd6bbf1fcc5521, 0x214062e6649f3949, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x0ffe4b8e657dea03, 0x08b5315861a71a53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x4ae3b5287f32b28f, 0x7a9d1b3900791ec4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x3fc9e6dc6f83dc83, 0x5e29ab44621a9cb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x28a73ba942b4906a, 0x601e428d13fc9d1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x501123f7094d1405, 0x03983bc90dd59ee6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x13b462406761163a, 0x3c3607f3630a64dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x2f715f127677d194, 0x55376eae3f7e9b61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x164426b52cd30602, 0x241dd4aa0c2ecad1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x1250f0056873005e, 0x6dd5e52526427243, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x67a5b2ee04e53c4b, 0x26bb91075d34a52d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x746918cf1f6d8474, 0x3f4f41e7276f99ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x622214de3f0472ad, 0x3b6c36e41d105478, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x485186b3671bfb51, 0x2ae5f35e323338d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x4e7d118b6a750c60, 0x153d9db25c05e8f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x60ecddf43fa258ff, 0x1b8484547dee709e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x6c755f0177f32094, 0x0a1d3b6f773104a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x606620f3442f07f3, 0x1d7376ec7ec64f07, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #0", 0x4914443f1b4a361b, 0x5bfaf434480bd3e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #0", 0x3ab7ba8f2ae7a48f, 0x6f7b6dab3d7d5d0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #0", 0x69ec173c0573a4e4, 0x5a8db1861cd9cf6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x6c8fa035644aa5f4, 0x4f0d0842323d9def, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x4ebfb25429c80b37, 0x0e4386e23b0cb1c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x696a643643185dce, 0x38fb225f2fac9048, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x3b0b7e6344510bdd, 0x26dd94f155dfc337, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x088013d130a10673, 0x54a6123e1b719f56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x4beb3c8e52f8e0e2, 0x637d733751945810, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x7de08571699f66a4, 0x0f11b51e06a2f71e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x6f130b887289cece, 0x237cc68b67cc9cad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x56d474c2284dc17f, 0x1a0a3a9d5ba2abbd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x5215ccb64faa7fdd, 0x16af5d7e25942717, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x12c2ddac7c1e4c51, 0x5540b75f3b8030ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x406f582e66060662, 0x115ff4244dce5c0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x16a70cd54cbd6e9c, 0x693ffb6548ef6bff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x1fb64f7e2995792d, 0x1a83c40f62924964, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x1334dfd10cb2070d, 0x693540821d96d4ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x7f3bd5db1f6dac39, 0x0563719c0247eb59, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x47bb6db97499f495, 0x5dea971756104a9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x4444747350e52914, 0x7ba471b519d13a6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x4d03756566b15f80, 0x55516b5c5707521f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x4cb765e20e15a993, 0x24d5ae2e0d72cd94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x5ad3182f70e5fda3, 0x56623993635e72b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x1a7b76d02f25fc9e, 0x45f0bc1c7a8967ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x3bd803ab1d83ae38, 0x18203c9c2db056a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x3cf15a720de2d912, 0x2ff841fb3b13d987, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x027ccda80cc895da, 0x1124242504acc82b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x5dadbeee73cf6df6, 0x1e7e029a46c1421b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x5a80cd76429e4268, 0x1dc8943a2ab13454, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #1", 0x50b3ebfb0e863b7b, 0x382401e827383359, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #1", 0x7f6c391e5087622d, 0x0a96a6112b87042a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #1", 0x7fad5ecb3e30a873, 0x26106bd719e7afef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x5bb456ab7790488c, 0x479806913b856276, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x0573219f07bd6022, 0x76993bfd18a5b11d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x1485f5fc3bd07be3, 0x1d52794807efef47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x2f9fe9d96c79c59c, 0x4eb131627233b4eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x2f1808045508eb27, 0x1ce4e93f0a20b750, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x638f26a23bef90ba, 0x3158eaa97fcbf3ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x0c76f2e751636400, 0x2b52f82962fb5fc1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x0f940c73447b1641, 0x7ce30fb00c2451b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x3c0b5ecd3e42f026, 0x47a9b4286b48631e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x4600504821408d84, 0x03ee143c417e806c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x5d110967181fa115, 0x496e6fb35a864645, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x049966b1699ee46f, 0x4cb9fb300cb0f341, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x3ea7cf96482a953a, 0x16d1aa9133b16eb5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x041a25f45ed05add, 0x337d62b42236f638, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x3033bedd021565a9, 0x053255f9109118db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x46907bea645f1eb5, 0x1cb56a8d3fc7cb50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x22a20edb2efe42ab, 0x2b102e6f029bdab8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x503ed02f0d88cad8, 0x441a5b2468a25f24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x25a86bed0fe2a099, 0x4328a5692d4fd997, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x7981850850d27769, 0x3a00ccd82a41d29f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x18fd0ca31170a409, 0x5df341543829549e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x7040fee65f92a0d0, 0x5a604ad61d173297, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x61a806794a5db5ff, 0x2da84b722074bdc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x2ebcd4b40b4cb783, 0x603c891428388264, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x3a4afa2e6eeeb840, 0x2ad45d1c515ee390, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x7c7783187d29e81d, 0x3a0142b40a89ca5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x0d0c88b671da70cd, 0x37d9a3f5221fef06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #2", 0x42ace8362a5502f9, 0x4c61c1a5068e0dbe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #2", 0x3bc5a7021917ad32, 0x3eb7625c5ba9f4d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #2", 0x78aa4e02266972e2, 0x78c127702c06a5e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x70c728e12cb7ecc1, 0x4c7b63ad5a52547c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x3804a4452d5f33fc, 0x028ad6e01f83fd95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x1c4dec3c2ae423d9, 0x70e2e125724f9e73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x280e0bf634b30cc6, 0x7cd968d118c56f55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x268d7d9307472000, 0x3ae55e5b351a94ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x319c22f97a6004c6, 0x3ba8a26a693a65c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x1377b1f93da58212, 0x44e45aa26d61c9fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x640ef4f465e3d392, 0x19686fe50c21fffb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x129bc05368ff2b57, 0x6674547754d61dd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x165e5f53653cfc90, 0x745a1b6b4aa06498, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x1021206a39c96bdd, 0x3cf0030c32ac4b90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x6e7c78a406571940, 0x4b71bae5382f2c60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x0d9e394028f26377, 0x6d49c10d1509f637, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x2352683e4328b6a3, 0x7e445c013f3a5c39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x00ce38b64604961a, 0x2c9c263536ca1a37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x2be869ac29606eaa, 0x42ec1a3264dd2daa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x125f9a012e0d66eb, 0x39b34b803e842a00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x134a637b461491a4, 0x09248e9828bdf955, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x7fddfd8226dbffca, 0x5b6a44e5236b83e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x2d33190a48e47153, 0x5b9ab0466e5a7626, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x71d6d4ca01a8c85e, 0x03646c5d3ad1524a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x44d17f0226a7d4b9, 0x7a0bae8315293d08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x6cac6ad30edf7172, 0x4bf3573f459fb7b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x383fe01c643030e2, 0x2a7ce5621894d480, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x123d97cd603d8d18, 0x5718fe804a9f7a1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x26521ebd4ec7b857, 0x735d73722587fb49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x75a3b821248e2f74, 0x48f37f2e26301c3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #3", 0x6d72a0c717eefec2, 0x148a926522d6d12b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #3", 0x1997c72157b3d1f9, 0x5da823755f497592, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #3", 0x7e5ba6b2406609da, 0x7472b29a5e694623, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x4f457b4c4e85e33d, 0x2408fddb6b081185, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x32b614205ab5e485, 0x039ce60507855b68, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x3af3719e458248f8, 0x5224d58544f3abed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x144a014f336f2665, 0x6a7ba7366145905b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x57fd55d91c003eff, 0x0775ac9a09edb971, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x33ef3dc10a6cae12, 0x2cc48a9c456ff6a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x6220800b192c1ecd, 0x24b96c334d8704e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x599228a74ff948e0, 0x2bf04b05607c26bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x1e7f2c1e4f211e48, 0x4b84384228d7a3f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x29d702cd0281d4e1, 0x305cff5b5135403e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x48041dd900a49362, 0x1628ec2b64ca746b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x3413b9c74d85b160, 0x461004c65c4e1f28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x6985f05f13006336, 0x663bd8990c110fa0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x1d6d1148763a7274, 0x518106411d752e21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x0f66914216ec7e09, 0x6afc33037f8d9153, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x66e5c6e92b8df052, 0x6009b81068f8b9e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x7aaf0e9a422d5d38, 0x11d05ddd0564f307, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x44af32196cc31f71, 0x569a334524861168, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x6d67b2d34f608a9a, 0x095085d30cb34ff2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x1ce63bfa4f3d47b4, 0x69016f1b217b6c9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x623daaea7f0d827c, 0x2d8c7c3a066c2c5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x7547f4f00edd8d7e, 0x23e15a7b7faabc32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x25ca0b875f420595, 0x7f384d8504ae8632, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x0acff5e87f779df9, 0x6da7401c0cafd271, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x41a4fb3168aef8be, 0x1214c578057f0482, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x5572182f33559bbe, 0x2a0515ea06542d4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x02b626587c08ec58, 0x13077d3d42d9cb02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #16", 0x4b46340d11e1b3d6, 0x6455379c1f9c6252, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #16", 0x10ef365249e9e927, 0x26088eac2d83def7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #16", 0x58c776a62c66e8af, 0x2d2e9b2a06372b43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x0ba8ee45788cf191, 0x0ae5b1757e91822d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x78048f8a1d561a17, 0x0b41549e1678e42d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x060512d545fcfe9a, 0x1bf7e8af39a98abc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x79529a5853053544, 0x3ffdb8075b772b04, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x4f0e219d02a62da2, 0x1e50f6067c08c0b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x1487e17841adb1af, 0x1ba523021a5455aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x0b979ad67506cfcb, 0x47d834a1257717cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x216db87b3693f483, 0x2bae430e645f117c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x2f20e6156e31e848, 0x62f093aa2d16a6c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x0b88025f5f87739c, 0x438f8aed2725759f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x2584723620ccb862, 0x60cf005b118d1534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x73d1eda70b55363e, 0x6d0440381ed70c8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x0dfb63e03684f041, 0x1adfcd3e42e00f44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x7832a1f0250c998f, 0x5d3464ee22834559, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x1a13695b73a8a032, 0x47fa5d2403ca3cc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x2a3c94b54b19e1ed, 0x68294e433b8121d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x394bca352c275383, 0x6897c896595d7aca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x0baec71f6151f0c5, 0x0082f06a44d3cc95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x021ea92843652202, 0x5660e1c931333956, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x4eba58406aea1323, 0x500a45e475f096cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x216f036416050b01, 0x38d0a6135cb5bc21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x3b11a49047335e9e, 0x7f39017a19a1a554, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x3adbfed00595305d, 0x1d6be21a55250deb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x50af124a793df857, 0x10a62fc165189385, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x25654bda3ef8feba, 0x3e760e5009fadc80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x204aef7f252f8ade, 0x4ecea915311412fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x6894ace032519234, 0x62474c50226998a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #29", 0x1d3ba557512ad589, 0x185a2f76374f0521, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #29", 0x672fe08a133dc2bc, 0x1404c1423eaaa8bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #29", 0x5a71215a75b8302a, 0x584c4e0f2241851b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x7b4d6087080cc2c8, 0x77669306154d202a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x014abb1f38dbc1ff, 0x7a65b3af4bfc72d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x77d4c0b924c5f867, 0x55f74f5226b006fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x49f583453a0b6644, 0x57c419f4181fb039, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x6c5cf87852e37857, 0x3a8948e0328a3026, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x240e4de07dddf689, 0x69d9354709989dd0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x111bb945208f949b, 0x4843468b0b3e2e6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x1647c4c524e6468c, 0x2d7fb3866b8cda9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x2cf309547b3fae78, 0x00d9fac91195254c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x341b70783388e770, 0x5d91981e2e3dc474, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x584edfd72cb1e562, 0x54edcb6e2bf03131, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x66bd4ba67e992a4b, 0x440fe16a2244631d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x517ca2a23ea7c88a, 0x54ce9343531a441e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x3c85bf1324f6287a, 0x5cb2e1ee758af082, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x4585bd152e48d273, 0x00c91eed4da17858, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x532f19003a084dc0, 0x392e52f75bcd81da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x3547fc384af43f45, 0x6d62a72600222254, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x7e7d26b5034db236, 0x2e5fe6c869636cb0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x2fff979859637f4c, 0x15539de256cc068d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x57fca9974ddefced, 0x791069aa16bce33e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x0c86c577468a094b, 0x69d7275d29794c39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x6b8031c51fcd5ba9, 0x1f043cbc490c848a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x4e162e1d4fdc4fd9, 0x16adfce23105eeda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x09e49d997a3617db, 0x0cd370b42145471d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x452a57204fc7503a, 0x216769713f2c99d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x531502703de3a464, 0x2890068243a77dd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x174723b01383ee0c, 0x1a73846203149a09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #42", 0x6162eaf903a8a4a4, 0x19d17d476f43cd48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #42", 0x4a32adf037c1563d, 0x18bd19816de9b070, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #42", 0x578eb1e74da431dc, 0x36f634fa35b2dfb5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x1d8081b5738c3f44, 0x66b8ce9025a4e004, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x6dc2571f68519092, 0x46ea272127651f4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x3818e0cc0f21bfa2, 0x6691b92032ecae3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x4d0564061107b077, 0x76942c150b2de33d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x248b9e842813fa8d, 0x0e427d46644c87b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x2bbc9f326c4d6e80, 0x539054fe05ee897d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x240ec4bd2ace6ee8, 0x73d839ee75ef4d22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x7872a0c5125afb67, 0x2ba22cd77b9d76a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x05e73aac682c7dc9, 0x214256a815f3227a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x507e0e5c23e9fae9, 0x3d5841c973a991cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x330bba8b1d2a6c20, 0x2696400b0896ef28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x2e321c9722074fab, 0x13c4d26500111e91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x4a1b4a3937edfb46, 0x645da64752bdbb1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x243b69c64c847e87, 0x58ac449975d7e96b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x7752ed6f17696364, 0x6bc7368d484a2e83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x29c45ecc6529fbd0, 0x43e7a5286fc58e34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x4d56799a4310f278, 0x05b8b0af2fab9978, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x66faed6149eb6b4e, 0x23552b431dd487f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x6715d76e3a304984, 0x266b771e1a06a7ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x5c37992f7e756cc4, 0x1a17c67d1547f406, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x3663680a40b1f3ba, 0x6805af212652e368, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x0d36724107f20360, 0x1c2accd35a9ed1d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x1f5b66c566d0a57c, 0x22e9005404895fb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x4bfaa14c7a079e94, 0x744eede5491fc591, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x3d18910c1c208a4c, 0x78cb5f0919511ae6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x660bf59b5d9119fb, 0x3725a2dc24137e6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x17c1637f5831ecd6, 0x3e1a26594d21cd09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #55", 0x56a7599b4a6f7031, 0x6269c10f73f8fcae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #55", 0x0b2163eb3676acea, 0x1a4be0170d0ac1a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #55", 0x3e68b04b0a9293ca, 0x67a993761857d62d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x71633946113023c3, 0x1ce135de5dc41710, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x0b37c2581faf3baa, 0x26e3dca13d5dda92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x3bcfc5f60dd49855, 0x56aef57948505364, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x6b65b2502a7df82b, 0x6c63d1d221dbbb91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x02afe502516749aa, 0x6efd889b032715cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x1bd6b9db116bf295, 0x7720127e59573e9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x47e29f7f4e0b93b8, 0x6662004226f81dc7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x589e27825c3129d2, 0x3f4ff3f4064b4fca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x6d614d950af3437b, 0x640f66da4a0160c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x2aa27f255e0e30d4, 0x075f3b5b78990fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x6be2c9292d4d3524, 0x40e963526672451c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x57cb2d4f774b8948, 0x084e00ad57487b7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x48b2d2f3518fa3c7, 0x5a6f91495a7b1251, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x62fb965c1a345131, 0x33d250ee64898cce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x683fe4e94ad19e89, 0x0b81aa952ade35dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x2702c85b1538ec81, 0x312985a640de0c6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x202c2ffc123ea88f, 0x0adf6d34146415f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x704cd9634de68930, 0x0cfd25de4aceaf22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x7b33be54398ef4eb, 0x3140f43e5c2fa28d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x30da7e340de7af50, 0x33781e0752feeba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x5f775318614c4ee4, 0x2d79fdf5798d5127, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x7b80a0156998888b, 0x5e16ddf54272e974, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x346a27141e7aa4f7, 0x6d511f5063c084fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x33b391782f7dfe9f, 0x249e916a5b6cef70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x41bca72e7cce2b3f, 0x6fd1056153dfc174, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x4ab4b4704fef64d4, 0x1eae709632098092, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x097e59c041b14126, 0x0e39231f45e872c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #60", 0x4f98f07646615c5e, 0x18e75e683a58d7f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #60", 0x27adab4211fd0710, 0x33e6291b2f10438e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #60", 0x7b958f9b5ed44c53, 0x71832d03232e4b57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x7d4ef14a2b8d61c0, 0x06eed0552fffb6b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x5b0b605f7b3dab81, 0x0b6ca620310282c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x780bd6c02390b4cd, 0x04e244371cc8078d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x738019a25d0aab3e, 0x4ed1881f42c08b30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x1ebbec6421905c5d, 0x08a8fdf57cfe7362, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x67f1b8bb6b3d7471, 0x37574b566e54dcdb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x7d3a7b810ee84d6c, 0x1d6520690f9f63fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x6dbc99c039bc7faa, 0x32cdaf5478d00b1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x6549e16a343c67ed, 0x28cfc1cd6b0b8b0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x2f7a136e20f05204, 0x1c0e0dcd405541c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x448106d12beed176, 0x5d1d49562785ea2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x08f97cb472ef7354, 0x6a46755f38012073, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x147fcfb16c56df2b, 0x34ff93d527b56919, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x5794539c336f665d, 0x160a45f47c71886d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x4257b3ca3ede9bbf, 0x0c10ec6a54cecf1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x789b1b69766e9c08, 0x4d9eda3b30144d8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x2aab03f5372de661, 0x1b1fd8945de4fcd3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x581e38657b5787f2, 0x1e3a3e9c5a251763, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x274659686bf176f0, 0x01ab01911c9f3f37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x5ee0ea44099ff380, 0x54a05faa303fd61d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x75f6d2ab6dff852a, 0x57f53f367360b9f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x216eeb877be32ecd, 0x6fd242634d8b2648, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x3ac1ca8c6ff8cfa1, 0x2259f56663c69f51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x66676ba92efac570, 0x13daecdb335ce5f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x6628abd12f7c2164, 0x1141e2c811126f9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x2ad3a9576ce28892, 0x6b3787013e46e437, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x58d3ff832f868318, 0x5ae6236e521a02bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #61", 0x392676985a4f1812, 0x0259d8dc37b4e9c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #61", 0x484e9d3c1ae7e620, 0x2b15a3bd2f1d4944, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #61", 0x16cb14ee1f0264f2, 0x7ca86f8c69bd88c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x0efb3493615f14f1, 0x4d842815518cdf7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x1059da61162ba838, 0x04e9c5707562a03c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x45a7c99d71ac96db, 0x06750fda76828632, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x5e8f1f6d0faf8dd7, 0x34c96a69707b72f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x3f3610f044ef4e90, 0x429575b337631ef0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x1f3e66a21a2dac75, 0x6f1808b8785c8788, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x3515929624224058, 0x2779d0cc678d03df, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x4324a54a1eceb4b8, 0x514a8ca34be0a784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x002dc9a922574c6e, 0x1d6d86fe521fd9dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x3882f4a74df789f3, 0x47827a191087a40a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x3fa420ce3bd394a6, 0x070a2a3d7e2abe44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x4b83227e313ba6eb, 0x6ea631381e33403c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x762af57b44ae67e4, 0x55965f2c0ab9336e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x5edc145a2a8f8bc3, 0x0315baf615695c1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x4eb1cc1b4e40eca0, 0x7cf65ffd13f1a6f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x6d0fa1587d3fd572, 0x5fd24e7411d67166, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x1f9721e12b78c55d, 0x63f64b436d3d6b02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x79704f5004cf3949, 0x7dc50f0c581a1688, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x40a2cdf044eb0604, 0x5644d4cc3914701f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x7626acef2cde0f87, 0x5747b05b0c25f06e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x718c776c19f4ded2, 0x16df23dc6c51a26b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x44846a957eb15e86, 0x01bafe8950688bc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x4cf24b26442c812a, 0x645a32b6133636b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x416c569c0902f35a, 0x250ca8173a01ec7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x347bb8b72504668d, 0x273f57806103787d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x29d39fd60f6263d1, 0x391d8f052dec0808, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x544d69d53e482882, 0x670078276a766dc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #62", 0x6b2638090d7b8210, 0x769c5e344a7416c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #62", 0x277060e33880b7b9, 0x36c5b9305cb2af75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #62", 0x3732163f11756df1, 0x2d1b3b3b6bf4cb78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x55a1ef1b2437aa40, 0x7f2b022904246165, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x2d3a9d9b6565a564, 0x3e264de3170e45b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x0a6a0bf1312f4d3b, 0x7811be3561b65652, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x4091b10c76a2d681, 0x0fa25e5a343dabc7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x34eaff03155077c2, 0x1eb4198e14df1ae2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x22cbf9d31618ead7, 0x5f5331a72011370d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x4e99a29029df21be, 0x7cc3e6824a3c5ab6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x3b548faf355c2858, 0x3631262e05cbb8cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x5993d29848166817, 0x09f01a3410f67ecb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x2d7c0d7b201682b8, 0x2804c48306ce7033, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x5145cff3782724e0, 0x6884c68637e6196c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x6ec9fb620ad7dec2, 0x6c23c53411d78100, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x202856840609cd89, 0x26b69be223b4fa65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x1c22b860408a17f5, 0x43c6317242f45057, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x6a6939b34361d13c, 0x0d30ab0d6abc5af0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x78bdf9947a782df3, 0x708813bf25bdc962, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x428e960a5eb90cb0, 0x36b4482d5251cc2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x7ecf8f6941a502e6, 0x59203c60700aa386, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x39cc27c614148226, 0x27f0bcf250155f5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x1eec60e808a37c3e, 0x61ece05c28962328, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x0ead49c710114f00, 0x4c4b1d8e3f14b76d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x509b66f50f39b2d2, 0x020907c42ad00227, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x529b840e061470d6, 0x158c5d173b04a0a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x008c9ec91776b238, 0x60c26a0b4b597da2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x762fbee976cb862e, 0x1dab49ce431b34d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x387089145b16954c, 0x3325d85a74ff4e52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x6f2b177327018e0b, 0x4514adae723cb0db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #16, #63", 0x2fa50a49671df191, 0x1ad2d4030e17785b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #16, #63", 0x772f40924f35378d, 0x4d2c2fc83e525411, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #16, #63", 0x5e6eea5f7eaeb350, 0x6922563847caa787, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x04c324266391b23b, 0x02cf4830310a6e6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x7b0864731a0f35dd, 0x7c63ec0f054fc2f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x10dabc0c7b90d01e, 0x486af7c47138235c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x56a7656a2b4c1f5d, 0x663771ae494b4520, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x524dad68565ac9ff, 0x3b87f5fb45d27cdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x3d78bb9021162501, 0x53e9f53901f2b7b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x704b5c8e296761fb, 0x40450bc234a7fc22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x2816154b7f41ebda, 0x7c72a3aa4eba46ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x62d39e157c28a169, 0x7fc4b55a2cd93971, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x1637d7477a93f425, 0x3228fc615ddc0288, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x7624c443354b9793, 0x4f1425e527129353, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x6097b6f02be5ce6f, 0x705dd8734ccc29ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x0240986e66889bc4, 0x129ea68b32e56458, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x079ec0c6751d27cc, 0x34d81c0a3fb953fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x1e8489c770d3f3cb, 0x7461502177ea1d54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x7015dfa54669199c, 0x46a46442469a9f12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x4291bb06259cd4e5, 0x7373d88452e97dba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x2030c90b7fd9a627, 0x30c5804258c9924d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x35253dbb7039fe13, 0x7fdc25a016558d4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x1c1fcc8275c05d88, 0x6321b6fc15bcf4ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x5c48f94c7d7a750e, 0x48a259041e6064f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x72979cda527b0910, 0x5e19b8ef63e7ba12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x434efcdb22763ba9, 0x5bd1d767111c26a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x68df55454b2a9e38, 0x57b6c5b43364dc80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x70c7731e3713da7c, 0x064e5a3a2b71104b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x36ed80a40416c838, 0x043aa29810f83c29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x7450c64c0a6f8074, 0x274dc9776c12be5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #0", 0x002fddfc4a720c0e, 0x01cfb30a107092ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #0", 0x47ec811c0ceab0ae, 0x2ed0f7bf5c78d748, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #0", 0x5f65b9be1c3268c2, 0x4060915b3a841df7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x3ea8a46b23570a4d, 0x4ba0449922b4b699, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x6e81a8865c67ed53, 0x561993192787f9b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x137bc7cf5733ac94, 0x52f909fc5f491ba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x5b4a74cd178f2144, 0x704157cd4a694873, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x21fea1b8384bb9dd, 0x367c06d24f9b3b19, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x02bdc5eb0edcc5a6, 0x600bcde7222e7fb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x1bc776543f07e858, 0x7ea756fd4aaa4708, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x5b3a511a50cea998, 0x052e64ff7b2d3012, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x7425b3e573fb79c4, 0x1de1e6ab19e2f585, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x506367171463f931, 0x416aef3562a75c6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x6b97a5c63231cfdc, 0x41f0780f63df2ee7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x49c0f12164c47e2d, 0x2e48775a46e21a93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x1d10380a76892393, 0x167d55ac6bbf92d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x0565e93a0c95698b, 0x0dee128e1fcdfdf5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x4b9d51e36fa6a9fc, 0x6a7844fd212d5f8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x407553943a3c764c, 0x1c5a8fa126d7a2fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x2e37f011022587b7, 0x40ba9882349b077a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x168980e95932dbf5, 0x174263e57e9b5728, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x0b64abd110c2fd6a, 0x627a860f022126af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x75877b975f8096ee, 0x4903414255259cf2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x5609ba814ed3425a, 0x40e52fcc1297b3a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x5b68abe51cddf694, 0x3265b1965b6fa3bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x0c84a09018f792eb, 0x7c9d034a2705fdc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x533409370e983947, 0x4ddda0c54cf9f425, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x10bdc0fe18d75f84, 0x0194fb9f016bf948, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x720a3b796281d680, 0x00075071274741e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x7344d3ea726ba9d8, 0x296868967d6ee74b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #1", 0x51ec40c61379b409, 0x5294843d68cc4f81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #1", 0x624cf6632dc9b4b9, 0x7b64032227f5fb48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #1", 0x4aa7ab4d0002a24d, 0x03659f033db5a248, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x18fa3538329940d5, 0x64bba010572c4bdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x41317a1c25bb3ba1, 0x242640026c2e3e70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x3e929b266da18829, 0x6d9a37b851ef3b1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x50235eaa229ee599, 0x79367d02309cd69f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x150a8f7100a04228, 0x2e0bbdea43683294, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x1419f63127988538, 0x2c34821666f6d038, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x556239f112526a83, 0x0eeccb807666ec95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x12550cd118d82eee, 0x341c8edd2009e53e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x4b716fc31b5c711e, 0x7736311c2b4f4209, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x4117acc00517b832, 0x177d80790ca2e9e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x72b9405b57c8a1fd, 0x5e9224fb7faa47e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x7a6787965e52dc70, 0x30471e8542dc9f05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x5ef31e98327953b0, 0x0644d19a0f721708, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x5a11d8e80555b2c0, 0x7668e740730d14c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x17a81d431d90903c, 0x6974015e2f7412da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x3668bf2a46b42934, 0x4f7df81829fd2a14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x62109a536cc9ec97, 0x554c6c1e01da2eed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x71e1a4c96d0f3dc8, 0x0e7d18cd23284713, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x44d7dfc65319ad7e, 0x22d28ef9649ae525, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x316c89ee2dbc55c4, 0x2777842a3f3f675c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x6035a974451a65a4, 0x4eb17e64105fa886, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x4a7018646ce0beae, 0x036cbd503a47825d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x0a714eea39398d4f, 0x69bb9537621835a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x7fedb6846161cbda, 0x0c155fbc40da0e14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x4e2bb872513155cf, 0x42b43d0261fe50d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x3e40939827f926e3, 0x052697ea400d5d3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x7b12d4614c1fc68b, 0x24a842600318735e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #2", 0x79dc1c4f1109591f, 0x4257daba2c7f5e50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #2", 0x5623bec3404bc426, 0x3cdf06d65a11c5c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #2", 0x2d2c82d57e14dd58, 0x145948212093d728, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x374e6aa70ec16c8c, 0x02ac0cd0379dd1bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x702338673b2c1cd6, 0x7877dfd4373c212b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x0c5d72a51e6109ec, 0x193a72023e4ef0d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x465a30cf23049075, 0x7e5c4e144a9e063d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x6f245700100e5456, 0x4db6799b416d0531, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x2117ad752acb6a57, 0x6dec63816900734f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x6b172e7e576b8134, 0x43123913773b6c38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x55805e8c1a7b5030, 0x17cf43601843b153, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x293cbcbd485962e6, 0x4fe183120ccec934, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x03857fbc5d455c62, 0x440aea5f195ff524, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x7ba6664e560b3411, 0x57aee5fd0fe2f262, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x790fc4862837723b, 0x5a80f89f4200971e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x3845c6917159ffd0, 0x036d9c4f68341b86, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x1c256a271446c7e9, 0x51348ed6595d7406, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x6bb2491e6868239f, 0x5098e03e073c98a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x02e373cf6f61cd0b, 0x1f8049f84132a7aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x37bb2ff1120c5b3e, 0x4e0170de2c20308c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x6f51b7a01d2f0bad, 0x458025b03b40afae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x733a3fbf25a49aaf, 0x4b23a2106af81dee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x4ddc0cea3066515b, 0x2cf8b50c6c4a0445, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x21c0512b25b2aea2, 0x547e1fcc0621d37b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x39f9768b301827c0, 0x5f7f47813de5bb53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x18804b5f64a29df1, 0x452253f825abbfa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x54046afc34dfd832, 0x66de67541b63bf2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x46ec33700d04156b, 0x4783efbb0bbf9aed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x2a3321191223ecab, 0x47004a9b363deb10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x37c8875b4e2ebe0b, 0x213608ff1d6d60d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #3", 0x7e950f675e3584e9, 0x09b7651d05a49445, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #3", 0x03e8338b6b45af42, 0x0bc667c120556092, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #3", 0x1b5dd702235d6fde, 0x5e3b1be53de1aa17, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x08000dcf4a6bd114, 0x638d69c033de2261, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x7f4ba94716c5d14b, 0x4f41e1905c0478cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x23c9e6b62ec45e54, 0x67c413b84637dcb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x40e84aff1dabd0c7, 0x7c75c7c84dfd07cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x6bda8ed27521cdc5, 0x6b6a68a778b0d25a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x535752ae0a1bce61, 0x7e5566a06a6f9e39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x75617da369001ab1, 0x0ac4fecc573f863a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x0c5d8a8f78ae9a11, 0x1521305110bf54a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x431a6b2613df5897, 0x449d7707145d985e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x2aa529e2582624e2, 0x706211294266146d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x06ea83360513b8ec, 0x089df1244e6f1099, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x22bf89b307d68110, 0x1c6c186847d2ce35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x7cf84ed53ed90730, 0x4083a0900e9a1886, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x48f4d59103ceb58b, 0x7909b6bf504fa183, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x6cced03d3cb0580e, 0x278f27bd3e565334, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x355ef22013b31ee2, 0x4f15a7da792c5acc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x279277797dec0454, 0x0d89f32b78795d46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x56122936437d62d7, 0x3adf71b35237a15c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x48911bc43d12ca5d, 0x20a6b1f55cfcac6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x44e94b6d65531b32, 0x24cf7aa26b50a577, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x242c226272f474bd, 0x79eabdfd41e19a42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x76c32a4839c06383, 0x12313bc66d20f7f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x7670bb927a8cf302, 0x2b774b276391fa85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x0e4011e46a48487d, 0x5cbe55522bcfadb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x68344cd15f287cab, 0x24490af835d2895d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x22a5df8228b0dcae, 0x080a2ab93e467608, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x65c3a70c40129d16, 0x1b4322746b36fb46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #16", 0x2565b84850725ebb, 0x5687a0be2aacf279, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #16", 0x4366d3787ebfc882, 0x6c8e8cbc4991daaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #16", 0x38802c05622a1dc5, 0x36b2d29d3a29fdc1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x5cb710c77a7a4d98, 0x1dbbf8462ef0e797, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x64c296157f09a041, 0x5ac095496af722ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x5e321cec28d3d6c2, 0x20c9ac084cf6e2e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x5184b37026807b63, 0x0b3d58ef00d7fc6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x6693187a42969873, 0x6c0ef7b537485a7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x1308f72f4e83d9b2, 0x61f54cf60bf8d0c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x4d43a2340c3d7e0a, 0x558aab6d566fcaa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x6e679bcf2e55c0af, 0x1099c86805c3ce39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x28d00e470f754b1a, 0x34b4b5d14b1eac96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x0e7eeb5c56df7b4a, 0x3615cf410d92a45d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x7fb3520c65c6e033, 0x5a8987446cb10848, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x0c475b965997fc6d, 0x6d8904b75138057c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x1c2e94e06a75acef, 0x08805ff972da7410, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x38f986a1545df040, 0x7ed344d32f378c0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x609b6e4a16411f1f, 0x05a756b7063d28d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x4496dfce40b5acdf, 0x0c00f70e4f030a1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x502af7fa503785f2, 0x1a21b6b06d66ee16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x2717013c558319b7, 0x7af992735ea9e356, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x3b49f9ea38e3f056, 0x4b5aeb9e26ca5348, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x127becc30082b8bd, 0x780258c447915580, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x6af865ac393f0e64, 0x3a6bc9912eaa81a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x0d9cfea46389646a, 0x5de20db323f1ec4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x79ca838936300c31, 0x2a2f15226e386cee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x76e5b910575d2db9, 0x3d3b77083e616358, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x2794b3ab26c1e3e1, 0x2bc8516e4710b10a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x7c44fd9871157fff, 0x25ba94604eabb4e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x29f970556d7860f3, 0x7576082f378ef782, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #29", 0x6dfb19b1398c1693, 0x7f204d023c755d18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #29", 0x72cb24f74901ec6e, 0x6b1fdebb58f37f5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #29", 0x2c8b50d8271480cd, 0x7ce56bab0068239b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x5d448cfe2bdc0792, 0x6ea0908a2655d462, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x0339354b107f8928, 0x64b737ba542a460f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x37416d0940f58b7a, 0x1b3af7192acde8f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x320b0b796eefa60c, 0x79799ddd33866aa1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x5c6807006a35af25, 0x6b1562235c047bce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x23c1c5b90399b7a1, 0x1879d8e64a6320b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x4c9ba410203c0bb9, 0x2356a00e168ceab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x47508c8705959ed6, 0x16f50e4c7926f4e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x3171a66804340104, 0x1f7cc94a24951985, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x14b38a2c13fa56ae, 0x78bf5f9434aadbb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x54efe22858f26288, 0x5f78c4aa4bf4f735, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x47e208946a90c3f9, 0x7f7b61d606faeda1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x54c6731f7b794255, 0x62ff696f244a0f94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x7f12f9f61203d054, 0x6ead3045788838d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x323fdc0d260a31d4, 0x0f1523884bae9e06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x2b9fd0aa64525c39, 0x44d592ef79906894, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x68865d3e16e4e1ae, 0x1e25821a5d117713, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x2adf385c71351771, 0x11bc52c77d39e76a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x4a2779f948aa4076, 0x492edea07fcf1a84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x333b047069c97194, 0x06ca08251209828e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x6542b3e92500c268, 0x365392220801778f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x370492bc0f9ed3ef, 0x0089b0676455ade0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x35a905c474d9ded5, 0x30044be669446ec9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x592c3b0f00fa5978, 0x62d4d75e6148d66e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x17df3b265016a048, 0x3e5a4d8141b2984d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x414bb7ba081b5e57, 0x3eec7fb742be7383, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x50c59ece4957962d, 0x428d8e070b7331b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #42", 0x332107c153d04664, 0x1d7cb4410400a33e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #42", 0x78d108cc0c8bcb34, 0x0c021acd1863bbab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #42", 0x1c2a9f232cbdb571, 0x7cb9698b2fd59b88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x219794477beee1af, 0x191a0a5151d3a4e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x7ce93b277176c8d7, 0x331c7b567ac3cf56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x418d69207b62e75a, 0x3c7667a314c8764e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x037e45b21a1477d8, 0x5786e9d102d920da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x636c0e052bc906cf, 0x0e4c528d5443e480, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x7f994d336446a28b, 0x584487be168d15c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x70d26dbf2baa3afd, 0x2ef0d172786a55ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x5867f06e4159fbd8, 0x283ff1870cfd0ce2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x3d48dd8811ed2d20, 0x5ed0b1ca79ff84b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x0363f5f73139bbae, 0x74c3540b3a3218af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x2c9ca309268178ce, 0x4efa8efd44f15f17, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x4095f0a75616d27f, 0x47ca7ff1301ae8bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x01dfd94e5ca354f9, 0x045ecd3b2401feac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x40e9f784697fe5e5, 0x3a8f147301792681, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x152a20e222236e07, 0x79e37c8031bc6543, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x637d69df1d8a23ef, 0x3eb972256d921151, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x2f77510f5c54ea12, 0x6791960620c64767, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x0d8ea5c029f2ef14, 0x5af8601732db4707, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x507467e33f972610, 0x77cca61e3a2b48c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x15adf88f6ea4febf, 0x6a463184110a588a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x4b4853b86f9b6baa, 0x350c5736178dd1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x591b518f12ea74de, 0x1906f85e0c324b3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x350de2e57ca822a5, 0x3deeb07f6e457272, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x1a324694436919c9, 0x5bd783c3188b4cc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x1fbe03db1449f443, 0x3951942c49a997a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x3e3ce357745184c9, 0x7c84deab2d4ca99c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x33e8aad951be23ea, 0x6777f2650eb14b3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #55", 0x406322a954c7fafb, 0x1fbba3c44996a368, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #55", 0x446366a57a2b6da3, 0x612475450bab7662, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #55", 0x0d15e28155cc721e, 0x17ddc19e1d7eb834, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x527494c3679bae69, 0x0bc42aa64223c566, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x2b04c8331400a657, 0x5aaf122b6ca6db57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x284a9a9a32d551a6, 0x365072fb4ac2cc0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x2726d6705f876810, 0x780f75aa66877df1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x31458bfa14f46cf0, 0x7538c92c5b0f8149, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x69bc67eb05ca99f7, 0x24a624b271a8aea3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x7ff6079b1531e6a4, 0x7d5425052e1fce90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x6afe58c25762b16b, 0x4b9e86c50d0bea1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x3efe5fd529dec1ae, 0x4f2faf833d72ed85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x3ddf6805606a3bd8, 0x2a19c8dc6a032808, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x133f8d7e2cd569c1, 0x34c5f416662a029f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x0c5cd1d141ea49bc, 0x4cb180903a6663ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x56deb6ad3a1c09ea, 0x1575e5383da25dcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x3fe6a3e12c9f3174, 0x2f4b0c6e409b1e98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x41d118183a5973ee, 0x6ebaed293fdcab7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x11bc25591c18451c, 0x4ce895992ccf70da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x45f706ca145c273b, 0x6a425e5f50ba852e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x74c663136f83a14d, 0x3abdad3603d66ecf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x1c590b0e36b1f1fe, 0x6a00716e0805f092, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x789c3bbb57e239b8, 0x426c548028b5dcdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x11fe43a215a34718, 0x66583aaa4f7af268, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x4242788c7ed0fe29, 0x1016110051e4e784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x392a72175eaa2899, 0x11c19300041390a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x7ac26db51b255fdd, 0x30e3017e4ae69771, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x2f818719565ec9d6, 0x1ba11c9f40b9747f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x45e26b232e9054bc, 0x448fe34e2447ea2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x654246bb6eba2f3f, 0x2c4ddabe623b7631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #60", 0x469c68f771498dba, 0x0af153105dde8276, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #60", 0x06ecd4d23d6f85de, 0x2d5974de589aac9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #60", 0x3c4084083c41271e, 0x2a7f941e492f4d5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x1aeb4fb87e25df82, 0x4d42de03756af61f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x194b3f5f5bf2aa30, 0x40518d9015adbd6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x325174061af7153b, 0x566731ed48ccc678, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x498769f819628b63, 0x6d14b0a57833df29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x081cbaa26560a86a, 0x5a6f555a2ec9b0b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x56aa36243a01a807, 0x0ca833294eb9239a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x77712de551d36452, 0x2753d0345d970af6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x0e148b7074093659, 0x26c6585533b1b1ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x722f15db696e359d, 0x291ca80d28ffdb28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x4560dfcd1514ca83, 0x3ead98960b7a553a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x300bdfbe415bcc58, 0x54471bb377b253d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x5abe57bb4a558856, 0x6fe632fc799349b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x2fb630c035052d92, 0x285cfa6962db125e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x6f06d59958e8062c, 0x319435f8066066e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x2abb6a7e0abdca30, 0x63f771db6678037f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x7ec7008943465d79, 0x1a29b56c38cff5ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x2cb49317207d69ad, 0x61cfd11770f61664, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x3592343050b78752, 0x7c706b9f721572e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x121353aa59adf9b4, 0x69c7c6b8659e13ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x2403820b078e580e, 0x5f315da56cd1ab65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x3c9385a10140f3bb, 0x4facbdc353b9b2cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x5a28f9e73e118b8b, 0x5a1a19b02b9a5b3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x48cf55bb2c3c1426, 0x12125eb904e46465, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x6f82719f1f842b6b, 0x3db45a5447965645, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x4001951834fcd848, 0x388c6ca91c3704b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x05b45f9a78143e53, 0x0e4c779b7593c948, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x51c238073a633adb, 0x5b31dd3617c7b344, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #61", 0x41f192ea54461c6d, 0x04995eaa75c5ba12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #61", 0x558710292399868e, 0x497f6cde7e85188b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #61", 0x61ab12193c31d27f, 0x2a1f73c52fb00a10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x686de6a57248c8ca, 0x34946e762a7a67d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x11ccf4352a9d2ac3, 0x7210be1957f05844, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x5f9a030b0273d496, 0x74275cfb51ce894d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x7a8812e922942fcb, 0x47625295654e62a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x5cf76aa701af7494, 0x7d1615ea4c4a4af0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x55f591020b8f71e1, 0x421005031ee8fd91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x2f28f86f478d89e1, 0x1d6e161c2b7ca12b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x03bf5c600fc119b1, 0x5b2cab3b10d40a88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x0209e27b2d5f3076, 0x3b4e725c6c2d4305, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x57fc5b393844f845, 0x441d9b4a13d6d6b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x3ab8ccdb2d07b292, 0x65a55ffd37965e44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x4f9be25e19fad6d5, 0x1ce4c0ea3540dfc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x1baa4b69439b2fb7, 0x018b2ab42c934d05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x4f2aa19868ea60b2, 0x4b7c4a96719fdc6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x3077ea93784928d2, 0x1d1c7d967e539a07, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x080a42834a7616ec, 0x0f27a48f343746f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x77d5476264822543, 0x206489f90a1424ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x1cc71d8803905bad, 0x1deafbaf4fd1a29b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x30980e3f244cc1ca, 0x076800df577fea63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x3e47989f0e4bf4dc, 0x0cc0ca270033f09d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x51e7249378438838, 0x2cc73da259f1e408, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x612de8ea68ae3e0a, 0x4b91c0742111c62c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x60f766dc2e8d04c3, 0x1f65603311a5d37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x79031baf6641a46b, 0x45dd1a726901a960, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x4ac3c9af1100ca0e, 0x7315ce5f70d86311, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x149125bb4812068b, 0x40aa05ac678ae737, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x6c5ec8554bcb9bc2, 0x3f0ad19b452933fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #62", 0x5a17909e7224623b, 0x455d24982aa660f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #62", 0x6a67ea73502a0571, 0x049844fd2bfeb532, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #62", 0x38d8437b6c75db91, 0x4d107b5e4b95d35e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x1b02e0542318c14e, 0x5d3ba6dc19cfaa58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x095a65b975e72217, 0x02d153b81405fc03, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x06e7ec25458864c0, 0x04de5f14541e2f68, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x0d9a6b4c7ab3e83b, 0x3ba916a01b7911e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x467f83fd25ff6a74, 0x60a245dc79f933a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x1823ccaf2937d993, 0x249f94962097149c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x7961df0419a6452c, 0x4c95c9ce028bb723, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x061c20bd2b5d315d, 0x4e218a81323a227f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x4e75f2ab4edb208f, 0x4c09ccd7211f0112, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x44c242a63a035c2a, 0x3524fd1557d05864, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x7f8bc0ea67979e6d, 0x2bee87cd4baa2ecc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x624b86a847c58689, 0x672340ad0d262c36, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x6dc4f0fd2bbef46e, 0x071f5fd828cb0aa5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x54f6ce0115f7e90f, 0x49621f4105e8bdad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x2f9e2e3b5695ff51, 0x087474d04e58ad05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x01f330ae4c9c9c5c, 0x0092cf8435ba4ef9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x1b77bceb0bfe4d20, 0x56d9500b50692359, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x4601a94a5428038a, 0x28397bbd6039ff92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x3bbfa1f713076f0b, 0x2be42e5e458d6a35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x5accf59459d2f643, 0x52b3966b1e0b289f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x0591eab110385286, 0x46d633454891e691, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x26303b9656ef190e, 0x4e7aa43e5a88b8b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x2d85185f2974353c, 0x28e165b755ce69d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x7610d198626208d5, 0x0b88b8ca2f78490d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x6e6055f6281ae824, 0x7fe16c6611888e83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x7c42ebae1da6bc73, 0x71c28e153461ff40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x30ae2b7e4ca2ffe1, 0x79ef697538028da6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #29, #63", 0x2675f6241ce3e98a, 0x560db6450b7b2112, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #29, #63", 0x2d1c3c112287abe2, 0x540d07a42c07e0d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #29, #63", 0x7976c4f12f71ff40, 0x06909988534c77a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x58e6347c34a39a43, 0x291ae17826fbdd50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x1705a318565592c4, 0x5674265e4ef70614, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x7e707ae8524222ad, 0x607f94970565f90e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x6fe8df2033b761c4, 0x39c7f84f7ab36697, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x005a61a508c3aa82, 0x32b5f43d20970a9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x25a7940d001f3355, 0x2c122bb126d057ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x22a6df385968d228, 0x52d838a052c3d01e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x08dad1684f2b293d, 0x261047c51c1da429, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x03cec380198da7d7, 0x4319817961c105e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x6fe33a9c1137a090, 0x30b80bf81ad46699, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x6379c33d5a0257f6, 0x203a5fa76e53b584, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x0db9b9bb1bbd1058, 0x69071c1b5362a25d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x2480badb200bd8ae, 0x73f9acfc0e141b60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x202b0c0307bcabca, 0x34e4732a4a284ee8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x61257df342fc66cb, 0x1cec1f0642d1eb3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x12279008220910de, 0x5eef8f646a004f5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x3b96b8b57c796138, 0x4bc1554015f65389, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x0db101c8510519c9, 0x30caba222b79f351, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x2b0771c002d4c4f1, 0x19cda8d6712ac505, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x1e91d54a3887145f, 0x448d676338c12b7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x5892ed0d7bb9ba06, 0x46d546db43129025, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x037665d02a26fe13, 0x0d3adf0d78bdf911, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x6d2364de1a7f73b1, 0x3b8fe44c649be3c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x3c88848f1a5d885f, 0x4e9c331f7f4af4e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x16d6e997460c0291, 0x1541486f781f3d44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x17111c5b3d66d96c, 0x239930962487eb60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x403b9e5d5a4017c8, 0x15b2b06542188e1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #0", 0x12c72c2841af0071, 0x7ad9b9965ecd73a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #0", 0x3d68ba772f1ae2d9, 0x21e003cc6b5a1935, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #0", 0x5941e0ec1fa7f693, 0x6418124640df2048, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x3a276a447417372a, 0x257b040b466545ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x0e74bf895af18320, 0x45b03ab176afeed3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x20fd85b212685cad, 0x6ecf2c17254ba921, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x4fcf36195f8644e6, 0x49d39481380ea20d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x39c65caf7500e9be, 0x7a273028100ad477, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x36afea2f10b84beb, 0x6ed8481e4c8d88d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x3fd32ec41bffb453, 0x37e7a20c7418a4a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x3ba7aae65a72c8fa, 0x34f7c4ef19150fb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x4e8a0025252a902c, 0x5f7a557b75cf152a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x001c134d5b4e3014, 0x6c7f03fd5cfebfae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x6db68cc24c1dfd50, 0x024a68cf211998ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x2ba44237534f6b34, 0x59283b0c3d85c2db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x485054f23c68df71, 0x4d909752656a9ee6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x4d212b5c69dfc9c9, 0x31f827bd7f003f21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x05df7e1c2810a8b7, 0x7318e3c80cf45a20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x028371b20583bf4d, 0x260969d141872902, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x2aae4f7923d54229, 0x37563e2c510d71d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x7f23723e30569a55, 0x2e0c31852aca62c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x7c7497a5250c36d1, 0x4be3fbc56cd9ff00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x785ba20577f0592e, 0x2a5fc1db2818d9dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x3459389f3f7ba07f, 0x0d8378c240abf6f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x295b6a4932c519e1, 0x3fac3619017a63fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x5ad5c299347827ed, 0x0e6ebe1b2f3ae865, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x39fbe73a28184f94, 0x70c211685d59344b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x4bed91be5c72d7a7, 0x2e66a62264aa36b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x0cc971fc5b58953f, 0x0f74997a4b1103fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x0064cc11624ac4d7, 0x37eb02fc093e09a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #1", 0x5a3b1e053eda5c41, 0x3156e37e78c06e16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #1", 0x7e55fcc079189b27, 0x396c650e0e9456a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #1", 0x2bddb5081e7d78bb, 0x100eba9f27b16709, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x52f5a0a847ae60d7, 0x56ec4f6f06b377a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x6fc6b06b1273520e, 0x640cabec0cf187e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x6ee629b60110580f, 0x719bbe953bb44229, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x5c68ed4f3eb04921, 0x06c546257baf9bb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x20fb0df9364488d3, 0x04eda5545ccdb960, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x751ee5140efa8c84, 0x558e27767b362bfe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x081327ab19d93d42, 0x09ca82a37374e1d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x3856b5fd7212984d, 0x1b2648de33f0dcb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x39c0f9241eb10042, 0x3aa454550b4c56a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x3124525009d99d1d, 0x183dde872987a98f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x0ae9f52c6c0131de, 0x653bebb9200a7c06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x2ab17b0020a7bd0d, 0x1bba17b96752e27b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x56ec45e019aec352, 0x44209bdb4bac88f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x28a94fd650ad379a, 0x46e2b4f74c0b2af4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x6a8674dd5aa655a7, 0x3f800cc930bc7782, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x4cb8edf41f51a88b, 0x64ad543622dd2ada, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x3e02a8cd46676007, 0x2e2981800679e718, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x5040fd24153d7c60, 0x300190a76f26fb1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x013eae3f2aeb8edd, 0x0f3177245b2af251, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x4b934beb069e70a8, 0x427dd4cc2bf0293f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x204d33fa3e7f672f, 0x779cb238227f91cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x0f2c9eca2e0ac989, 0x6e8abcc048f683d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x08b11f305e604f88, 0x79b2fb5279b313a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x7db1f8144ab9c001, 0x1c903e81556a0d24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x112120090be584e3, 0x5be3f43c3bb4a0e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x212301443a0d1324, 0x2adb9bff61621d2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x64f8a2017f0ae44b, 0x3c8d0f7e2261af83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #2", 0x05a954f345ee8afa, 0x4e51d8c2308bedec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #2", 0x046df22941963c78, 0x530b7fb825f688ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #2", 0x6fa1060168a00810, 0x6eed0cbd139a90f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x4700579829dde31c, 0x0d4da49a78522531, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x7497a31d29a02691, 0x4dbc325544b24fac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x3585ab742b428c8d, 0x0066f08e05b8c326, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x654f9fb123a7efd2, 0x671ae05456a8acb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x22b2d41d475c34fd, 0x790a5c3b4a4841b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x0d4abff74ddfaf57, 0x7ad42f9f285c2910, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x0f75ebcf3d3fbebb, 0x4e52b1fd11b8b221, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x25dfc6cb32a0e7af, 0x255343147f16f1d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x5c7ecacb45254956, 0x776917016ce01e63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x6ec56fe731f95e9e, 0x31926e1051166de8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x5d3beb2b3dea1163, 0x56cf310f244b1b5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x6192013573fe2450, 0x7af3c814428b8add, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x3b5a594d07a7fc2f, 0x0cd3cc900444d553, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x5587ab877af3b061, 0x2ca0fe6348a51945, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x38336f1c7fb10e7a, 0x5a5dcb6664fd9756, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x3251f6295b7da028, 0x641489275e1335e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x20a2e97f7c85c25a, 0x4af3544a0ed0c0f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x2e7f20f836b65fec, 0x5fe72edd0f685966, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x74a0714f2ea73cd7, 0x33b374c20bbb0c24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x22a561275b1a6391, 0x4e46970156327284, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x62c25fc00718463b, 0x5a7747d75dffba74, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x020bf69c01029f1f, 0x26a4d3b9384a0b47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x00b3ad9a015c2bc5, 0x1d47a29e3a3f65b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x5cd9cbed6345efe9, 0x18529b9f3305a3c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x5fcbb24421bd9395, 0x41d664b87d7cb56c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x5873f38140988395, 0x0ce50ed30e4ad33c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x6f3fc06c684c7661, 0x1a05df604d1464d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #3", 0x4366d9f27dbe1f2c, 0x2346d75411e52193, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #3", 0x04d665671689afc1, 0x6fe4dc08262939b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #3", 0x178c4ee17bbae798, 0x5e7344fa06e25c03, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x7d17135d59745d5a, 0x4121c1bb183ffc7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x3cba4d430d1c04f6, 0x4b45a03e59f0df4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x2ed9988b6452a38a, 0x576d94b71c85ff87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x24eb272044d6b224, 0x2ad0d2c4074d8c0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x2d23288677a8c831, 0x5461f0dc142ae78c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x7566e75d15f4e528, 0x26100920708a0278, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x2c7e94e975268126, 0x16b33c2b7a3d4cc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x70e168be42416a82, 0x011fa8c7440ae3ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x1bb5c7dc27908084, 0x5c4ae0456df87c1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x34ac857a1f56f01e, 0x47e95b675870151f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x03a993a91fc6e76b, 0x74f614a763861e06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x649d998f3f359aef, 0x6ad3aa122894bac9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x36de632062cfab75, 0x3cbfa25511c0c215, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x78c4909d18fe00b9, 0x024ac48e2c454a7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x0e2481df27a24008, 0x2682974125432587, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x69e3aa8a4598e997, 0x694e09517f05ea9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x6d296a1b34e7c221, 0x6cfe66ba05997266, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x543eb23f52ff9c2c, 0x5e09878521d5ef95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x72c68397702fb7ae, 0x055c0d9b57e845e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x2f65529d3d3ca307, 0x007d00b157641d27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x200c4e7c6b6fa3ca, 0x6924df3c6643b5bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x046da484390b977b, 0x1289003a18d0df1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x60add78327620df2, 0x3e1404a112922663, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x6cfaf7897e9677bb, 0x119811014a91820d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x337e39dc2e347bf8, 0x502af4735a2461a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x0134182501565ed5, 0x7bfa513a07bcec1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x71861683602232b6, 0x5fa5320473fa9bbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #16", 0x1d5ed5bd34839820, 0x4b5eb8e320eb6920, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #16", 0x1ff33bea19b81f17, 0x072f1edd3d6b2439, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #16", 0x52c3b692145007f4, 0x563c03532460e06e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x3bb215e7488b17d3, 0x36f306d233718e15, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x47218f8f4e2e0495, 0x7e03102228ad0d70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x7c62808e7ecbc04f, 0x02d16f157a9fc96b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x00221f246201e78c, 0x025cb5877d9698b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x42241a423cefed53, 0x7191346f71a835a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x7173857319c2bda6, 0x12939ec85f82efff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x337adcbd732a178c, 0x1cee14381166c15d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x077a1f806cbaa89e, 0x35c7a1cc063e9350, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x3545c07137b33188, 0x39b02165432c3567, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x05e1361d6eaab1ed, 0x6bd942d87c675000, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x6d76723c7963cef3, 0x7707196c0243b6ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x5b65b67f716b83ce, 0x7fda4f5e6d989160, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x2e5b712171d465d1, 0x5f40c7081d89d0c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x0b97237719fad4f9, 0x7d0cc0c01fcef694, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x0d24ec8566fd59bd, 0x3135b7f13f120034, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x53b8025b7f00b4ea, 0x45509384149f0c05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x36b3e67243a48445, 0x57cb416d08fdc2cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x324f36327c6c2c39, 0x056512cd3c951c8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x75cffb2d3eb32299, 0x3ed8d33b1fc5a86e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x301ea6676c9f00d7, 0x0d5e39ce5135b1ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x5e7366a86bcc432e, 0x6ebf826e5e7a1788, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x05c718272f7ec60e, 0x7e490e1c6a0a8a1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x167c1fcb6e6d1dd8, 0x291c8a5312ec04ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x6d6dd2c27f56521f, 0x278b10b26a342227, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x42fad6647896f7c1, 0x7331e4f42421b934, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x750323fb1f8fa8fe, 0x60b6d5c3754a0c96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x5e42cb98226deed2, 0x150fb5046ad31f28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #29", 0x0f0cefa92ac85342, 0x3c08d0d40e6171ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #29", 0x169496716b2497a4, 0x6cdb89886d805651, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #29", 0x1aa35db200a76ac4, 0x578ae0701c5bae98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x6f14889c56d2c3f7, 0x2f47b345311f7d7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x562916160e858499, 0x1b539fa55c825b5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x071c7c5a615aea55, 0x00a414921923ec7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x00ea9354237dae14, 0x0e6df9107c1fa055, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x45eb9ce622fb9052, 0x66f2bf7d5f2d5eec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x4dc3e3945a6a5a73, 0x6d8ed0eb54f88c90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x458ef2181a03c352, 0x4278e2e164587a05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x1aab2e162ffbdbe3, 0x00b4289e60324fca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x06ce9fda2ca56ced, 0x1151cd4809bfb6b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x3b2af18666e626a2, 0x664212105cf7b5f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x484110f704899b7a, 0x761ba26a42476de1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x2807498e2559cdb4, 0x3e670e36492ba44b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x48555e0615e7d423, 0x285903376df2e674, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x70522e96056455e6, 0x42eb73041619419a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x1f6819387b25e43e, 0x7a71bba035e120ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x2b21c02127653dc1, 0x161370793a13474e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x540aaaaf2a151010, 0x43d2fe0031f05ffb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x10fb36b20503b855, 0x0ee815eb0f359c35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x098d53cf0fe4184d, 0x517d0a16593c47a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x353de6014ac0ef2c, 0x2267ebf531949d5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x60a8c34f6272f6d6, 0x1f8783d17d934407, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x67d74cbc0e1e4141, 0x13ac85a150faf1e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x0944257f1cef830d, 0x06dc1294073f65f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x4454c0cf0525ab42, 0x4152ad423465e5a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x2f3abb52753e5b86, 0x6656459b185f6b7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x7a4213db791211ca, 0x279507b34035f204, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x08f62a173bda25a2, 0x197239ad03cf67aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #42", 0x069b14cf54eb88d9, 0x356405073e341018, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #42", 0x375e7faf4f73d9c0, 0x3bc7541f6743d81e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #42", 0x5d921b023f1adc99, 0x383eca041f35cc6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x5c0a5fa667c7dfa1, 0x2675325f66d64081, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x6ced8ae301926bbd, 0x1b3c2622205f2075, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x76d0c744605393a7, 0x38be8bf31c284635, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x5965a57175d071e6, 0x5c5e38397112db1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x31aa97892a4647d1, 0x74e242ca625bcf88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x7f31d0aa5c5733bf, 0x208fdfa03845ac58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x2bcb0d7f57c84e7b, 0x1f89847636905059, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x16e32b147c3b4f23, 0x55c61cc4095d2881, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x64032ec40b6f8f25, 0x7033690372ed8aba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x0d01fae24c0b3723, 0x134cab3050f0b9a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x2c5ecaca49773815, 0x6d18ffdc03d2c226, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x3f47a9fc69c7e010, 0x74e59d4605c4703b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x140e27e108b01f63, 0x68203fc370f24185, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x6507532248c17253, 0x2937eddd133ff88c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x2089c0ce1f9665aa, 0x49d048e510d260a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x1bd1b4cd0a62f226, 0x1a2f8923376cebe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x15d2814b3da721cd, 0x2a5a769d7fd4e392, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x09b258f03dde9d16, 0x50c59d3922d47c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x0755d52b1b8cdb9a, 0x26a73e54361123bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x0554bbaa23f5d3ba, 0x3bd593f6469d7f27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x2ca5f31d60c7ae89, 0x378fc0ac1962e38c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x298920dd767324fd, 0x2ca2dc1811ad4640, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x16098aa73caf3005, 0x227fa6e24a12e1ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x4712222c2bda442b, 0x017fcd8e31db3f75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x698165f80275c040, 0x31b023075ce4a377, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x40545d5626605dfa, 0x7fb91fa57333bee8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x41ed3994651a769a, 0x2944e2a347aa3282, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #55", 0x09104a5445d77256, 0x0e47b1a94741f53f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #55", 0x269f20df0d47b4e3, 0x60a4d8cb35b63d71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #55", 0x03bad9e069e32a93, 0x476383b1502841bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x26925a991bbaf0f6, 0x1a3b236819c46488, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x479535217d4fc704, 0x4b9fa3fd6da47cc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x7fc587444a423fe2, 0x4a89203c31169b19, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x70a29ddc4d8f3ca5, 0x244a5a014019e49b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x32a9b33f160bc8c6, 0x07c4171d328fd770, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x5be33b1c5a76a57a, 0x79d1ccaf3bb9fd93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x67be5a5d38d3beb6, 0x71703b0402825bfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x22b6e9496ce5c120, 0x52aa9db86b79343e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x08a0b21650dd3cc3, 0x053d98c6494943e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x4e2d03c70176e0e4, 0x36edc0a75035e737, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x4bb920c62596dc52, 0x014c82504df28b0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x732618f715d086c3, 0x0e0c6fa63c5bbea2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x2bdc4f8a68bd62c2, 0x6eeb961225cfcc36, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x4334083c52fa04cd, 0x6189c9c907bf8aa6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x0bcdc3835cec845b, 0x0a41e6a22af2629a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x49d2457b1ba92f9e, 0x166b96d82e84accd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x6c866c612ebbb157, 0x77cdf0af5272f792, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x3032923b23f5611a, 0x22a8dec93ab37028, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x498c3d6c16b26ada, 0x08a5fb337bebb301, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x2c82f19d273307b5, 0x384771a33cb25663, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x0ff06a77440bec62, 0x62822299585f4127, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x1705f12f6a60b270, 0x601ecbce532472b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x474d36cb14826c26, 0x7e16d54e22d3b4b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x302b9bc44926522f, 0x51586180111f7c47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x77e20386063b52a2, 0x639273d91cb20825, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x2a30b3bc600b7380, 0x5765784d281495c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x76bdde5a5c47ba65, 0x240048c273bcf128, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #60", 0x037ac21b12f16a24, 0x306f478b2340cff8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #60", 0x56fd56865bbedced, 0x7ba0111f136b2c92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #60", 0x461f8f5e64a67494, 0x668f9f466e0347b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x7928e0ba622f5de9, 0x10d6fc690d6cc629, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x2b55b018021eb649, 0x1e8c427029547c7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x085a08ec1d6bfcf0, 0x460684a32337b39f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x7d7770716f4c9223, 0x4b4c4960328abca8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x4b944c8856b6f55c, 0x2647add174354ecb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x69a85f8113162fe3, 0x17761ec34f0f0ea3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x6ed50cd04909da7c, 0x627a3b3640a5b607, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x2db04f113f7ffa26, 0x2ea8fdbd34f49c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x21af580f60eda4c8, 0x4261625826d92fcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x630c5b12163430ed, 0x502dac4a4d050828, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x33a02dde3b890527, 0x703cbbc76b6663fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x2ad5974a4438ce77, 0x1df120a631179e4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x1aefc3d43cc30bde, 0x254ced1a7669e3d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x4fd93bc127f32dac, 0x4578f27604982355, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x70fd082973e6d71a, 0x453dd95c3eae4891, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x3366d14036044718, 0x73a2e4c01ead573a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x16f1ebe015b4334f, 0x4586870555162950, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x2be8643d1257ed3f, 0x221b317879fe46f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x4de0f2660355cb97, 0x6564aaf05f88921b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x478e9a0e35ed1d84, 0x10a0306a78b689b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x72b0296234995ffa, 0x6f206d84627e5de2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x5c8c8da72c545a94, 0x6716813742896523, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x203b31ae74da9275, 0x0137adb54d8995d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x2aded98d31bd740f, 0x6c36ed0a53a202ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x4771a75f4ad35db6, 0x28b82c3e41d0c56d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x5d2b4af52133b750, 0x3bcf0c60735a0b9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x248982e76382ce21, 0x52e29db72b0c3d5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #61", 0x196feba512e33491, 0x23c2c70d6c181cf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #61", 0x477c948b35acfc10, 0x4e967ad80c201508, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #61", 0x620156a44fe127e0, 0x4ea97a2b24092232, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x44bbba555dc9a50c, 0x7192b802023c8852, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x0f87191c7e96b77f, 0x55de8b406f9a93e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x496a15356d3a65b0, 0x316b595056f8c07b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x0e6e1d001d3569ce, 0x4a52cc172695602b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x00b837ef75646494, 0x51a19d8732f79fe8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x084799256da637b6, 0x1f0fbcde1a282394, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x235333c674f1b2c8, 0x2648389c4fc42db0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x44d2daa8656007e5, 0x73cd4fe305548a6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x4329acf25d6f9dfd, 0x079112bc098e94fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x5c06557c2a948230, 0x792928e052b0c60e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x17cee7e073fc52a0, 0x29a9868925706ab1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x1131bc6e1da76863, 0x4c05cadc263d04e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x130bccf7784461a7, 0x5934a4c911e9f45d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x65ea995d525a508e, 0x2c1217f11b53661c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x474c03565ee4e3b0, 0x6b1793cd093dcd24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x4444eb9516236a4b, 0x0e92578e0c1eddfe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x739308480ed69bdd, 0x15ad72fc076e9887, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x396b1e0d03c8e51e, 0x5a1f5e954f995dc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x77c537be410f9352, 0x7509c875513a05ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x5eb6fbb550abaf98, 0x77770acf08f6f42c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x48f0113f46f3007b, 0x1ae0e88971c2c8ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x194d5109782dc296, 0x0d162ec92edaaa9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x5712a64646aacf4f, 0x381877c06099545f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x5cce399a0265a55a, 0x6cb8325d1b5791dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x113c41377ce588f9, 0x22c62a63506141e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x00ae6e171504681b, 0x1ffa9fa64aa75f44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x5613fb6d13587001, 0x1be165327873a5d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #62", 0x64041f991c4b828c, 0x016a9a0234caf723, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #62", 0x633e830733a3ee99, 0x268dbfd02cf430d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #62", 0x2bd1b13013e75335, 0x5bcedb757c8bd410, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x5a92228449dd5acc, 0x5d25286f02e45776, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x4c430026410213b6, 0x1e3be95237605c1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x3de79caf27bc3da6, 0x07c19e005d7f415d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x3cc0a5c2440805d4, 0x2826a0a23e960ac6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x576075d638744a9f, 0x3709b09c12d4a12f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x54bfcd2b6e2d5822, 0x479f98523b64956f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x21d146bc4427a1bd, 0x6858c64837fe5032, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x580ef4f211af4cb1, 0x348a24424da2f7ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x5b8ca77d6ec338b5, 0x50874f6232a11777, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x2fc54c6b71c31196, 0x6a01739527cfa7a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x197f4f3c2d7589a3, 0x054ee9016dace91a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x717d8f78634ca47d, 0x2c42f3e0563ff4fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x1bc0ef1c30b42e80, 0x6914962e48de054e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x1ee186a36c9b6105, 0x04429abd7080bc47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x30c302c25d0930bb, 0x287f0c7940b2cd5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x6eb87d6c5edd14ad, 0x0e55c54b08d1f7b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x4da04d62257482c1, 0x3b730f2c4a4524e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x173794577763b58f, 0x7214cc8d7d6599cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x24d93f32175576c8, 0x6b1282e730b6e394, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x7aa21b45700b6ec0, 0x06f6d8921656ceaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x20bf9d4163776eb6, 0x5f34d3f816630a61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x5012cfbb2f62d321, 0x06e3c6a83fa123e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x0c6c03dc0ea9b68e, 0x0053f14300d5d27e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x6d86cb3b451ad95f, 0x09a7ca337b248148, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x6a8f5c20377e72bf, 0x4569a6313b27189e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x2ee2284e239f3553, 0x388cb26b01c6f078, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x3af4ac1b3974ac9e, 0x327dd40c53bb6780, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #42, #63", 0x29801b5f49470a23, 0x6a12362b3596c760, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #42, #63", 0x2cbe78d952dd9869, 0x4bf9d1c14a3fb8a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #42, #63", 0x02406b8a0a34cdc7, 0x09e0dc847cd14895, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x18de8455074ee546, 0x7da71b130eac6f66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x4c69bea54f3a96df, 0x09d0f0ae06654f90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x06b9099e7a191a9a, 0x418c682e36f91ac5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x1db84fed6b3ddf49, 0x38c00b3d359b31ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x24b28be87368cf98, 0x0956996d58acfc08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x3cafd9bb5a3d9529, 0x0e43c3684e32a747, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x2d1b2d9222533c6b, 0x18725fe7696e5295, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x2c880a3263e6b63d, 0x663f9b2a2f5b991c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x6b359b8347d8f930, 0x3e08088245668e87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x1713900f0d584646, 0x4bcbde17379f5a28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x077160e02758802b, 0x6e9874ed1dcc99ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x12965f745cbe6507, 0x5367cb9a2529b0cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x5027349f0c1a703d, 0x7dd6acd53748eb5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x665805661dedf28a, 0x057b92a30cd70e5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x40412ef55c84fc1a, 0x764560f0137332f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x406bb25700d6d496, 0x42cecc146cc93927, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x48afcdc67dfba5c6, 0x322fc7ae2ba14dda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x0b53ec0c51d91cef, 0x6340a8025fc35dd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x79319d1a50f7c31e, 0x7d8ff78312c54cec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x2db6282535c5aa8e, 0x37eefdb90bc7fc8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x41e01acb488c7a8f, 0x4310e7eb7ddd5cc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x667a6d1900f9cc10, 0x0ab46b2028382031, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x5d7ec82a7e7a1f3d, 0x3bab532926bb9c0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x7f50f3d345b49ce5, 0x1384d5361dea7a81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x43b042ab2ccc705d, 0x498bc85b4800c199, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x7ea58d4c255416f2, 0x27c41f6e4f042eb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x764bda1019b8795c, 0x61c97ba377d72a67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #0", 0x4f7e23ea46b00ee1, 0x039f26f624020235, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #0", 0x0f3c89702c93ca1a, 0x21df5efa115e3eb5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #0", 0x2d8d962a7541b20f, 0x39965ee675b6f68a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x73bbd14c2ff767cf, 0x1c7292990b0c5e54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x75ac04b47282a130, 0x28f6d8d5730cc51f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x1f4f118d62d1a626, 0x3b0d86b8395c475f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x0825bd186a29f1b9, 0x086076161df49eda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x03e26b15196af037, 0x15cbc9417e719728, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x601aff184452f858, 0x2273995e53608eff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x70e6c2731e552c9a, 0x64becdb46f578889, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x1396dea9018111ac, 0x650e7f131e74589d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x3178797b52778fc7, 0x2980b6f20752aff5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x44fa30f8356cfbcc, 0x7a5f751427247e30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x183ea1f368e13ba6, 0x6080c58f64494285, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x530b2d5f1809aaa0, 0x023de15f20645f0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x31749ad741498f92, 0x1ed5f63456ed9875, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x059c87ea0f0cf529, 0x2a4e2774118f99f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x2d6221c365f5a18c, 0x00e7227976834a5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x6776b3383e7859ed, 0x14f7a2fb40f9006d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x10efe9b442ab2577, 0x484bb06218ef2cb3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x7818214320947073, 0x4013aae355ea1aac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x0975ac193c713e91, 0x3a335d321056c336, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x547ae9324f911876, 0x30bb22425c80d978, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x10daa8085dbc9962, 0x336e71ed05ef8409, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x6cc98e8b18664072, 0x177f1df916772ff2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x7e5be1fe21f21d4b, 0x0cfa7a501a2bb04e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x606a77382370611e, 0x5b24b0bb65d29536, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x661b86953ed56ccd, 0x7ec1c1ea715a60ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x5f69dd400177d8cb, 0x47447b995e33a7d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x3de9175c1f458d51, 0x6e8a6b0f68df8959, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #1", 0x6ed6a5c778ced4bf, 0x456062d21264008e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #1", 0x568b6e212fd2a291, 0x185384987fb14dcf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #1", 0x4838e3042322f811, 0x16287dc14354fcac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x4515155c38a55db6, 0x5d80acfb4694c502, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x5c15bed42b291c23, 0x2c675a39257f8c94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x69fe88f05e1e691a, 0x16d9ed8142314569, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x5f9641e50eef5851, 0x2064ed4249686631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x2e34e5a277a8525c, 0x3247ef8a1d7f5941, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x7077271c4836de68, 0x2fe359d01d0b8b69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x780980f932e556f9, 0x1cbcd9384702953d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x56084f0b67d83ee5, 0x0a5791ea404263fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x207d9c9b333e8339, 0x06d729001b1d6467, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x5e679f5c5776de7d, 0x409cf0fc7c935b70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x359547975f298e1b, 0x3ec4a0d94866284c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x6e18e66c44167e08, 0x11ce8e7d152b897c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x3bbed064628e3c8d, 0x32aae2bd1c4dcc0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x2ac51af5561630af, 0x395957772c35f780, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x08fb87a97d901ea8, 0x73388cbe22ce9bef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x65685d8d69e828ec, 0x6310ffec5f03d6b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x1d26ac253abe2c17, 0x7a213b1b05e5fa28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x12350a94413df672, 0x027955987b8e4b81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x2067848d55c3024b, 0x43f473ce47ca522b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x19d980530fa0be65, 0x5cf5dba70e806afa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x722efaf264278e80, 0x2ace3708559850b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x3a3dbf2f7506d4f6, 0x01ce48381cf415e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x7296f39e22d3b1c3, 0x3fc2b1d7433946d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x0cbbdab01c5e58a8, 0x223d1d8c57ff512b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x571c84bf605ea0ec, 0x5de54b5429e286d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x219c975e69654625, 0x2570d25769518f54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x3f2848700e11bd27, 0x311be17f42041bec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #2", 0x1db27b8c7b52bdee, 0x508486e65901c8c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #2", 0x5f7a4c6e306861b4, 0x2e9a197c0fe1767e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #2", 0x256f36ab6c983e3d, 0x2cd58c6619b80b9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x0f6bf0017f2e7003, 0x5cf1527618062a49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x1b8cc8ab4deac6c9, 0x70057b751c27cab1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x2e4967b56b7b23dd, 0x460a518672a94d6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x54e06a020d16be3e, 0x5bfadcbe4fe5ff14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x1b287b65626ea1e6, 0x11ea1b001408b273, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x5dc15fd41ba494b3, 0x6d0a7b3738daf6f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x4c0cf6677591f9d6, 0x48bc6d6f3d3bac43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x622a381333e50a57, 0x56f3b7e1717c2d12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x33137a5a7987d2d1, 0x0982575c71962814, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x4772999a53c8444c, 0x0dbdf2c54ea04305, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x3f4368291d446d2e, 0x4149907075bc014f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x2a5b2b6c578c1b63, 0x45a200631423d22c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x39fabd491536ffd6, 0x282c849f4583a6d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x30db9489471b0b32, 0x7e5e9dc217bc1d1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x3cad05082beb8142, 0x54f7c9617ce88af0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x5fd08b9977e70f5f, 0x6e64b8031ed73d1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x716ee2301e2b57f5, 0x106d653012e405f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x71f39c4122cdd969, 0x618448f938e17bca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x40124698743f7d7d, 0x2e9d7d193137046b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x4bcb98e06d875b36, 0x455ad6976a6d7204, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x02be5b0c2e4fb698, 0x2ff118d605c6562a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x756ac1ca727a3ca9, 0x1d8273483399ef95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x1e65bdeb1ee73288, 0x30827a853217c6d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x16ce41e7615c691e, 0x50ef03ee7e364984, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x7f87c113729e9872, 0x111a4f78083d2417, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x156c71db6fbc1cfb, 0x411e9fe1717b5d55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x63fb9a78680d3857, 0x22b261c0557eb873, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #3", 0x5594938d6fdd434e, 0x3fec2a782fc73358, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #3", 0x1e2cf9e6530ffcca, 0x358d89825852ee99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #3", 0x458a39733c6f58b3, 0x0becde2e1397bbb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x5b568b3c169e8671, 0x45af828363eff75e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x77faef8f7340905b, 0x622640e37224cd23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x65df28cd3b80911c, 0x7a61f13b7782b0a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x2b3cae170bb06fb8, 0x68fe0df87b4b9aa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x73bda80f10b67d94, 0x50ca531c0f38488f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x0093c0e2748d056a, 0x3eff7be849523b9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x479d02352d920863, 0x21a52a351ec0bac9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x6a0161167807f8fd, 0x3258767a0d273ba8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x0ea67f6f533d73ea, 0x711733074557ec52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x467e044531deaab1, 0x377cb97606a16efe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x6d5f3bcd67222d99, 0x7e241fa12c5d2d13, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x72d29d5178731ad8, 0x27a8c7bc189be9e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x0929986d66d3ae5c, 0x27d4327466904560, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x5b60b3c75187ab31, 0x2fe280fc09bd594f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x7f19b3945ad68a92, 0x287e141822fdb5fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x52de8390213c24ab, 0x3024f1a4691b14ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x7479989565efba73, 0x2e7300fd618502ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x17ce6524664a919f, 0x682671fd3af79cdb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x4d6cbf380efd91aa, 0x6754c9ee052da0f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x0770ac82459dbd4b, 0x1dc98ad7403f5c8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x2c716ba856b222e7, 0x26cfa1ea109a44ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x2839ce1842d5b257, 0x1a579e3f07d21f6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x1dac3cea5af4c70f, 0x2acfd56b275381ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x7c30ebbb3ee19755, 0x106e9658708ac07a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x24d151c93a363576, 0x520fc37970aa8450, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x2080c71512f6eb19, 0x2ba2212b3c9fb6ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x21f47cc35f96e2b6, 0x41cd57df6ded864e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #16", 0x2534a00254fc84c2, 0x2e2ce2d829652946, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #16", 0x2baea7a954570c74, 0x39ff6e3551a60baa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #16", 0x172cbecc04480084, 0x59782b1953e875c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x5f3cc7930baa8dc7, 0x7b3bf76f34d8fbb6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x4a8c251c77737fa9, 0x2563bc305b6db34e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x31a9b51f77ba58ca, 0x4c18379f6f5d76e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x0ab143e46dca85b2, 0x2bfd2dd3522a7c35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x4d6168696e44e55b, 0x401802832ca5c0a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x43416a1d100a5823, 0x560ae9ed7296086b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x646164971db43f2e, 0x443c14156ef011c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x21fc3fb23e147ef8, 0x42d887897b8e2363, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x49bf0cbf55cadb49, 0x30671f1901390745, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x4d3e5af228bef233, 0x5ca6ba94144b31db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x20794afd2fa5d694, 0x03a8a8c17ee81012, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x1d705c46112a8eca, 0x51128c472b2a8ee1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x7f6f74252ddb3976, 0x57d04f896ad1c4af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x3de5919921a3e12f, 0x5d67cd1a42b0de42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x3f58205d74797792, 0x31a0f0092246f631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x328df68a4e3c38ae, 0x1dd519946154600f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x240713f73f3421e9, 0x628d67557c4d0349, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x67f3141c1440dde6, 0x1098352571456eea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x43e6b47a41400b43, 0x702d7efc086c5f19, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x526a9a0d0b673d84, 0x3396edfb615710c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x394276fa2990a28a, 0x4c28d57051da0e32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x4b3483ba462bdc7e, 0x148aec7477280894, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x3aa5541037441859, 0x196efec50a8ca417, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x058051074e6e6b7c, 0x6be104276d334a9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x0da28d657a188309, 0x69804de4298764ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x0e5960ef0afa52e5, 0x1accd3e97595a181, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x4c3a5e283198ee95, 0x7e02009a52401569, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #29", 0x3d002c197fbffb9a, 0x3397262a1ea4f835, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #29", 0x29509e240509f2db, 0x707f06677642a314, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #29", 0x4b35cf5906d9aa6d, 0x6d6aaba8748521de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x3e1dc2c66af2ca1d, 0x7f11c5f605db236a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x396135995c8ebbe9, 0x730e6e05439e13ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x56a73ef307f24cb6, 0x6d2578cd4703c2fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x12ec9f9b3a9b6519, 0x3c99647f65009fe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x6c3453af6ad7db76, 0x3740b54c5f26fdc3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x6a97d7106e4afc5f, 0x7dcbf5f829347fc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x7354ef3a0ce1ce84, 0x1f7722dc13e87534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x13bb78f1077f5d09, 0x086d97133e8abe94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x7272272637745003, 0x4465e1fe51d93bb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x14030bec029cc853, 0x15774f862bd35cbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x0a8f15092f70843c, 0x72d71fbd6aaa4adf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x6a0be95506eba00e, 0x4faaeac21d7bb4a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x71c37b847a6ea85f, 0x7ca2b26756403d04, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x68b9a4be1eebdfa9, 0x7f74bccd5c5b5294, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x2bcdae2e78b15edb, 0x7043c7c85c0e93f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x0030bbe45eff348a, 0x1a99528c3f89271f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x1673848d26d9b25d, 0x116262d772a2e30a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x29767ab0114d5f86, 0x1e763fc92a76907a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x40bde3c264cbc61b, 0x1520db5934058fb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x6bb766294e23f6c4, 0x5181445d2ac9cd18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x48929f23007ec6e9, 0x010a0a1c5d7ae1ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x1f6aa6932a19fc0a, 0x39d63441314c43e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x22cb5ae527f42a66, 0x0d5ad7da4b3854c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x06f35ef11c23deb8, 0x0ac17be022fc16ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x42fd91153415399e, 0x159ef9d41d66e37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x456299245cfe4f52, 0x47dd73f86c740bc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x41ca156d71fadfdd, 0x20799b7f06207ce7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #42", 0x401ed6a131f4541b, 0x30ea49ff2d817b97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #42", 0x32731b0544d29186, 0x0afc5d4408b175c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #42", 0x6eec8d9047589180, 0x39fdb9a651ddc198, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x6f4cbbe727d79239, 0x1d16165911b7e875, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x43fb70f14a52f914, 0x34b3ff3f76401ad8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x7e6832b25b84724f, 0x13a6fe5606f90207, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x3882c1a113e6a94c, 0x736d0dcd43cacbd6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x05e189297ad592bc, 0x49eb48bd7a4cd70e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x2cc9e6d832caafea, 0x27ce52a546005fcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x779d417008af8f36, 0x4eb1d5905f3d01dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x500820b74e30d9ce, 0x311ac3756689cf00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x76086c072cf5b6b5, 0x7841b7753f54dc9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x7748afc9493bf5cc, 0x3594f7763a03dcf9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x24c0681b3469eccd, 0x40fcdf0075b0e27b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x485096190366f70f, 0x397bae515d4329bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x7e3c89cb7f5e5370, 0x579000cb4e321f43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x3229035a62e4549e, 0x14327f0e2b0670a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x6b93e3d43b5e35f5, 0x0a43728029c644ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x098f0fc30891cb40, 0x105013ca3b9c048b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x358781f53085d89f, 0x7af0e1297f977bcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x79c1ce6c7a9837c4, 0x399b58c42cd031be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x2f0224915bfcc28a, 0x228114391e823687, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x5f63b9995355610f, 0x7bc560447752baaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x52b3b47f59b758fb, 0x4584d9ed5da04365, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x3c9bad9912ea2689, 0x08a6b40804dcb7da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x4e485c7e3ef3106f, 0x2ea2fca4282f916e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x4784dbaf5ebc7723, 0x63cb95f957d76c42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x0f424fc2110a40d1, 0x576ee80d7d0c5da4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x0ba278954c5da39b, 0x29dc8f6209041e2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x285a6625234bb4fa, 0x278654b63aa49d26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #55", 0x76a11609777c31be, 0x31f757d007be1fbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #55", 0x51338ab96e05172c, 0x655e63244954ca88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #55", 0x00ef3db57cd47f07, 0x4e3182620dcf3853, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x3bc78f7619ca5fba, 0x35fec9c14f379a34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x7886d6dd7e7dee83, 0x270f0676034c6b25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x0f882f542a35582b, 0x0058c8c907c926a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x7692fbc638539984, 0x10cd44ce1b2aa7e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x5b9f4e7e07c69cdf, 0x55cf450f1eed61eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x7f42ce9d0c09e4ce, 0x26ab81aa52406487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x7a0efbfb69c6b172, 0x1b952f1050765957, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x669b307914445b6b, 0x5e4591aa7afe39b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x2e0ebb257144da5a, 0x4a35d3e42262bfef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x6fc2c8dd2607f3dd, 0x25af2b1426959203, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x503d4c083f2bfd71, 0x2e5eb8a37f4af831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x777f96f67044e529, 0x1a75a01a46d047ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x780b82090c692b64, 0x65bda9ba531ee574, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x1873103340f4790c, 0x255f49fc774e50a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x2abb2a7e260a3ba7, 0x47c4a9fd12820c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x3a4e971257b619c3, 0x0d8045de11565af8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x48faf41d596845fc, 0x33b91ae7685d5238, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x7f7039d93d519cde, 0x0ef2e43b38bdbcfb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x7c7d9a4f527e5547, 0x3808b52c4fad85e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x42c33a707c3b776a, 0x167dcdb073fd3145, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x08a4a2cf6c7b60b6, 0x471c16ba3acebc79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x2d6fd9c279e1b71d, 0x321d0d202117b302, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x1febf2c5411a050e, 0x3399bf30582b0440, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x18d01ed11d3a7a20, 0x69815f385a3a89d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x76a2c01c518ac04a, 0x4297dc0f61cb12ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x0edc5d2852918516, 0x1a88cfea7612f9f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x250fda5d5c3e4d88, 0x45c07fd70b59f778, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #60", 0x5879c4f246733f77, 0x7f5728bd67d314ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #60", 0x32eea02d54bede67, 0x22a1d147611e67c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #60", 0x4ea0958535cfd9f3, 0x02361ac3605e79ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x76e9df02220add68, 0x38897e306e8c884a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x3f4557880b5eee31, 0x48c712210fb9fdd3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x5ce9ae7b0c0de0ac, 0x718510c235e817a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x5e9f65c371bb9171, 0x2bfb119a6bc60ba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x4df9def976772bd9, 0x7720031c03af4020, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x3cea6b510e242636, 0x6b8254ee2673a3ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x62e3049d09c82671, 0x07920bad6fd90b7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x3f98006408c1039e, 0x5037856e31839a22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x2acbe10668d7348e, 0x2010226c3681df66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x743622bf37c0edfc, 0x463bdd3a6a11388f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x43cecea94bf461cd, 0x1ff95033511fd13a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x3daff33f3405dffa, 0x3ce5dcde226e346c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x2a7d0bd4119fc97b, 0x261d748c0ba9d238, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x1fc3efb139af81d2, 0x321d762467677725, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x4377a84327780811, 0x574082a302a6f44e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x30390baf543ab0dd, 0x342a8e71030fa8a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x3d11e56b7fcd6548, 0x3991880e5b04ecb6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x378e5344650f7578, 0x451625453148082a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x3103d7463f4db643, 0x0267d9657b5d21ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x7353963e43e8cae6, 0x1dcb56596eb3ca85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x558894612c7b12e2, 0x7a5d9cbd1dd0a212, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x662a94b45c789bda, 0x05381937754c8412, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x03f0a3ec2c1e06d1, 0x77f3786029a23cf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x0058b7af66436dac, 0x2cb1e59e3429af9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x6610d2f45444c196, 0x0f2e9c513d6a9d1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x3954370f711a7eaa, 0x6eb2a5451d9f2639, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x306834ed36c79e80, 0x18fc48266a580e55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #61", 0x7ab0696653697597, 0x590bd8da23bbcb2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #61", 0x7fe4887946c48674, 0x418c6d3d5038fdc7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #61", 0x233d224f3d78fa39, 0x458581d9660f1d2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x6997010b3c633fc3, 0x0fb15a24272dc63b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x22a6ad6f6a861228, 0x5b5775d669efb8ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x3ecad3be160cfb19, 0x275a55d408b78064, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x072779c33f52eec3, 0x2656a69d781f0acd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x761a8d433b82f1fc, 0x62771922378faeb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x0eec67941cd7e71a, 0x5b4b79dc70caf6a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x639c6d8e06897649, 0x4103f4700ed0f00d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x440270830491675f, 0x74e00d3b06d98fdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x40f4a722095ecbef, 0x2e0756182d99718e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x73e4de173ee3801c, 0x17892a48639b5492, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x54f07b3612a97b93, 0x6c52d4f632afb1d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x51fc6a560d45d5c5, 0x2acebca35c17f4f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x48c8c7c26ef31d87, 0x13a7a3aa4816f79a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x0bcb04a179e5e2b4, 0x38e1ee4357b52f56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x006f58fd5b662c9e, 0x66861f636f67722f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x5ff793fe24485825, 0x7641020d4471c980, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x2da7241409946556, 0x720b3b0e20ec3b20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x4877e57370da64a8, 0x04878fb2218c022b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x0383e03b7f0a70a4, 0x543bb4011d6860a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x0c5046690d27f94d, 0x798055a255804a92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x7c1b16d45679306f, 0x1d97422c55190e2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x505f132313545ce5, 0x2cce3d8107e61b75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x6eba89836d8e8fb1, 0x774d8da450ce6c21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x11d6e7d7074b70b0, 0x154035a14eb21d81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x10dfd6067425e854, 0x6f9e58a23f7e0beb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x65004cfd3545c218, 0x610a0e175957bb79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x345032bc704071c5, 0x76c01c2268842d38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #62", 0x7d686b125b9bb9f6, 0x3e0477ca40a07925, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #62", 0x3214ea664287c4d2, 0x15b98751798381e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #62", 0x55dc21b778b72aff, 0x01699d5b0273fd89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x6645bab168829f4c, 0x534269aa4496ab3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x6fce0ffc02e7215e, 0x1348c8bc781ca288, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x770d09b318a4bc8a, 0x379aae7300ade602, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x4dea7ea250c5bd9e, 0x5a05a17c5c0d56b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x41062f630295fbb3, 0x449183e8023ab15e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x5e31b5a95894b1d5, 0x42db2a843e6e9a75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x1b1c76a7395bb9b6, 0x37f21c5b1046a00f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x3212e4b665fd0743, 0x12ba9d9970f8985f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x4e7fa68f48d80c56, 0x358f439a18589f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x4bbf2db5480ff062, 0x107541ef3e4db68b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x60b4aced19013e0a, 0x3efb9c8e42cc3768, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x69c6fba8636b1200, 0x1ed98e182e9f2b8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x66010db373b50772, 0x30d9dcee2acd2b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x4c49b947212de1dd, 0x693bc5814432c35d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x5a899b9367340105, 0x5479636c67662fee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x4d3108490dee0be7, 0x585ec84d0c9c8049, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x56c6183e356a619f, 0x24f51fb01bb0aed8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x7d7a520218fa01f2, 0x59fe6564228545f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x31fb3ffc042b0b73, 0x65517d5b5e2efeef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x67961d733da8076c, 0x0cce2a7e1bc23ba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x315d0ede2fcb2c32, 0x468f66b04d972b27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x50f90e0f664351f0, 0x11c9ee847da6c825, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x4d7752f63d6bc061, 0x650cf8142b82a9a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x4b59cc495d14499c, 0x381f29ec1aa85b3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x127eab3c10576f7b, 0x36590a17221fe487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x2951716d29f6a7d5, 0x44a52a7a0ff8fd3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x2e21b3487af626ab, 0x6e27fc2d5b4cb169, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #55, #63", 0x389e2e183d9e53be, 0x770eed0e15b7d0bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #55, #63", 0x6d697ff07518ea66, 0x634efbe269fb3cf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #55, #63", 0x5b5c3c574caefd30, 0x67a2051c3e628dff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x0a1abd912204618e, 0x69e537a228d38f4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x7f18ab2a79d4f4a3, 0x437bea8c557489da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x0a2c641f3c3998db, 0x77946e6111975666, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x663040b00fb84fd1, 0x219053a4337dd58c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x0aae767d05d97404, 0x0eca86f61451f3f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x4377c7c20d58c096, 0x2a09c4b4434ca495, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x0271aafd14e9e6a7, 0x2d47e18b30e147b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x6198e3d759290d54, 0x6f43d5b25dcde754, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x7b2d6ee24a1d612d, 0x06a176a16bb3a169, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x43f255d038bc99a5, 0x41282b437a461a0d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x74f632802d6dc418, 0x0bdd70734e1eb9ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x3d2613e910671672, 0x019c8f7c5b267331, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x16408a7619822bdd, 0x6f78672947d48a66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x26daec7438691087, 0x0b212efb59b85238, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x4d52f72e79dd6f9e, 0x0a9999eb294c9771, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x53067cf20dbbf566, 0x071a7ec52eebdb06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x57d956935bc7a7b2, 0x1a9f7c6f4e33ebd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x1484415754577655, 0x487a05e21bcbac63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x01c53a6d6b86f5cf, 0x69ea6653097a73d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x7bee0c4154194e32, 0x64a0e7093eeb4e57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x6d9b7a1011e107b9, 0x06bfd8bd122e96b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x4a4a1840768082db, 0x6be6e8ef14766684, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x705df27944dd7cba, 0x3dc2fdf5179d0f6e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x52997220612866e3, 0x4688ea7443646f6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x3cf00e965a126122, 0x11985b402a72c8b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x2e69d7783028db69, 0x463e751651744fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x1bafd1383f8faace, 0x5aeec3c5302f11e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #0", 0x13a8f90175da38fa, 0x6f1a603c179ddd79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #0", 0x07bb40b315b35d20, 0x29cc743001447311, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #0", 0x0c33dffb537dd78a, 0x15bad995520558f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x185b5444302b52d6, 0x69a268617c91d274, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x1153b9b9518e9d20, 0x3ff641df6af4c664, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x2ba0fe425ba6042d, 0x15678f174e43c84f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x0bcedf977aa6dc02, 0x1fb8183d5a0ad5ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x3a3686d1795447dc, 0x0a39e7a0277eb0cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x6f2e80d668e90279, 0x3f1c8e494ddf7fd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x7e9c5f9964decc78, 0x4f23f2e376e9c189, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x385ca402329182de, 0x48ef1a7c0ad03f94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x62bcd5b4475853e8, 0x0762120850b7f846, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x18e6f10851144dc1, 0x3bacbeaa74108f6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x2cba51ee620c6ffa, 0x425457bd4487ef4a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x5cb34bfc28ccaca5, 0x1e92c50538893185, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x2220f4811f24709e, 0x6007e25516e9d2cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x080d731733ed4582, 0x64c9529f114f7558, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x18cc11fa5128515e, 0x083936e106a9d2b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x03b9d43c18dc244e, 0x117a12455128b5fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x603478365d8d6cec, 0x21e0ae426676a9f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x2ea1baad1cdb911a, 0x5a87395d791b693e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x7ee801145c361d8d, 0x3da358885b5c0c9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x0502ca3273ed2076, 0x13e53e215b9b4d11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x13119114574e727e, 0x72851fde2723beb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x0b3bb80040ac6aed, 0x3873340c1b1f042c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x11d4bc4b3342e922, 0x21c8d6dd2407c9fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x4c1f0d7017112e3a, 0x75307ff7158e9087, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x749e9b26568c73d5, 0x7c053a772c5385a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x736804ef6312476d, 0x256eeee4234055d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x3f4864fa1281a091, 0x7e9c627072500604, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #1", 0x066ec108407072f3, 0x4deb5315444b2f2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #1", 0x17bee57123e221ed, 0x6b6eede11980521c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #1", 0x648e8cda56682d25, 0x349f564822fa9d72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x09ab16483c32e764, 0x4702676d76634926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x5344159e07f71425, 0x0bf1d9ad55ca23b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x5e8387fa278c9843, 0x021da95f47e2b0c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x0a9edfb069bf6909, 0x6b23069951eb8ce9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x7c41099a1226e602, 0x443b92ed49e744ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x529758f679a161b9, 0x0e3273d802afcaa2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x1d8383a650cf7307, 0x1c301cbf6a563e67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x2737a02d54534346, 0x0d50dbd902121080, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x10862aab04673354, 0x787559a630e2b675, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x0c5e477908ca838c, 0x06acda2d63ca4049, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x30571bd016cff7a7, 0x2bacf10e6ae1cf73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x008f60b00108ef4a, 0x3ccd5c5c3af5fb80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x132fd54c130fb403, 0x04dd402b7cd06a4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x0cb115bc1bb051ac, 0x7f8034ed65c72e42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x6c7fc4b45d6e4883, 0x501d6caa2a349962, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x31c18bca24bc0389, 0x2c46a9e313b764e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x292336dd4b46f583, 0x449a1b564247b675, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x5411791051bee7cd, 0x2611f6be35817e56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x688edf745d30aa26, 0x20634dc9046894e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x5e399970443bd08c, 0x3f5e9060691e4025, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x574b848f656edf5d, 0x65eeaa7071696ebc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x011f310a274e09a9, 0x57309cff63fc9a4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x04bc522c3a77dd91, 0x0e3133ae6d9ef5be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x5f33e11b45f075f5, 0x01565a9f367dddf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x11376b781ed78b2a, 0x78c5946b085717f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x709672f75e3be418, 0x3dd8964f6548e488, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x3b6c8e3e291009c9, 0x69b179685925526b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #2", 0x6d4bda5528323d00, 0x4243929019a627ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #2", 0x0da11c5e6240336a, 0x0b0f966b44975ee4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #2", 0x098e3d1336c52cdf, 0x2893f9300ec04d68, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x713d0a707db59dc5, 0x7c5f43260e4a8f3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x43a613ba3d8e01a1, 0x44c86d365070eb8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x5c658ccb16a099d3, 0x58c8038454dd7f32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x74dc7deb23d7dd23, 0x3a2663bb4cfbffc2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x4ce7e6ec6864e4be, 0x2621522e30490c2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x109721bf54feca43, 0x49ef33d83a33c141, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x373efdad275f1956, 0x7ecb20261e383e1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x5e2446352957ceab, 0x2cf88b8540cd3ac0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x270d6c7013e03736, 0x4f17ca004f6150a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x516e38d7789a3fb5, 0x1fd23c316ab3802a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x0f3ad98879b76317, 0x3f90ff5c2dd3c5a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x1d8f403b20f11793, 0x7acfc56504175774, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x0955fc527e4f9776, 0x3460639e6a772727, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x534e61ba2376088f, 0x24aae86919ed1e11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x4ad521e5651de7b3, 0x38255c2e0a8d5f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x0e75b65e1a726428, 0x4b5a9a2828f9681b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x2e529b5e182cf4f2, 0x785ab8c1358322ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x10c734a85fc7a254, 0x2036a2f87fc0d435, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x597f056c28645f3e, 0x2d9499d820020e30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x495576d15879c942, 0x241965a4770e45a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x56c960b906305537, 0x61856cce52ab7323, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x29a65dc624bded62, 0x6c9891342a17c273, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x09dbd5157fffbc02, 0x34a521da747b7fac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x1a72202a15cfa088, 0x1d74e7c718518b73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x2dfc957a6e0b5139, 0x4dd4ae4148c4bb88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x4dd2f38e761a2996, 0x48858fbe3ec3ca22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x1e7e88d402df3df7, 0x5ec5d8532751f8fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #3", 0x5b59073a7fe5ab6f, 0x1e603ea167d3ffa6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #3", 0x061600a7271803fe, 0x3a7f72c9322267f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #3", 0x4bd5f16010df4c40, 0x5c3a2a662fbc5e6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x10df084341acc5e0, 0x2437de1955b1c676, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x577c66683bd8002b, 0x6e0351e92b51286d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x29e351643c9b73b4, 0x7415e3f60578fbe3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x32b59d4a23029e58, 0x443cc60577b644f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x25e1dc503d687c8d, 0x1f083dec5134261f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x3d4e27fd7387988e, 0x390825c5013ae38a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x1a9f9c8c0f9775e3, 0x335d4b7d436428a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x2076c2231758652b, 0x7320871166758ded, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x59052b0b2a2aa64c, 0x3c2754633155ca66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x6602a67750bcd6ca, 0x5ca6f2d430819174, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x0d584a7e7a37535c, 0x35fa8d570fe5f7dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x1d39f1b526a47abb, 0x079c3cce400de7c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x640cf7484a4a33ac, 0x11420de7431bce05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x3dd1cc3b77b3fd0c, 0x4456b18f215b1f45, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x074b72ef57dfcefb, 0x64bf47e9587168c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x6f3834267b0e4b17, 0x3ee6f6b427c23512, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x2538f16435bef24d, 0x5917ff79483d5f31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x067bc9172eb97dfc, 0x78bef0a50b3b97db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x28f0d15922bdcc86, 0x1b218fb713d41395, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x4962474165240945, 0x53e1fb5d462ac30e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x2f6e3cf14d9d42a2, 0x094691132d6f3e89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x45513fae3389a5b8, 0x4eca5dcf6d40092c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x0b6974b3049868a8, 0x45b171f44c9cb29d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x7fa6b3c04d76e728, 0x745ee7af7aa1a8d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x0335d9753b9df8b0, 0x42df080b24dfa524, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x6a5776ad4b3cccb7, 0x301b3cff09b1a28c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x6dfa993d7167b17f, 0x1d85b62113484806, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #16", 0x568bbac462b99c27, 0x59730b14375ce07e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #16", 0x3056dec933967cd6, 0x64cc1f0705f9f7b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #16", 0x6720228f38eb72d6, 0x733a00e275a81e77, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x3d83db7e36a3b8c3, 0x4244d11472899742, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x041a9fec300a4827, 0x6d2b401c3d2a8f3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x6ba840d712257162, 0x620a346207507961, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x5d623e192e87d20f, 0x11021bee55ffb784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x1fef838e42bb0a9e, 0x6947ff8a4b5cd756, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x2574a6c56785d6db, 0x02b9b7d4767b3e52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x1b1c53b26faf36ea, 0x7c75360855cb858e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x289aa9c00db87519, 0x4b73a405023c7641, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x445c2ddd61f14d9f, 0x74c60d83661e853e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x11fb95c6055348df, 0x2349147d4876cdc9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x1778ba4160c96318, 0x4fc7472a7da3d69e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x0f5135283ceb8dad, 0x53a38e2274daf85a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x7fa6984b42f18784, 0x4037cfb02f40b8b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x2a775e6022312d11, 0x25bbf709251b3f11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x11e063fb465a68a5, 0x7ae6c49f4593b212, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x5412ddbe3c9635d6, 0x47d028533a7b0dbb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x1e87837643e2a776, 0x209992f9186f0b9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x4935f05630ad208f, 0x60e5d9643083193c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x117683a701ca7dfd, 0x2e26efda60aeaa97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x3eb60baa15c172a2, 0x5589a2f220c7b8cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x58b2fa2775c4688f, 0x500871863e5ca3f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x17f595a05e5ea7a6, 0x6377e306032a5887, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x24b9104b108e32ec, 0x48be0a9929d5f99b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x4d2468c204ea9a4f, 0x6451075678cbee09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x48cd41c67220d309, 0x113af9a56babec38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x22cdf3984a55f54f, 0x1c2f05751203321c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x4c20734c483b7fa5, 0x72b1dcb334447740, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #29", 0x5dfcf2482514a195, 0x550c300f0ad67ef6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #29", 0x1ad90a242cab05f2, 0x493322ec36afec6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #29", 0x0b09ad9802984f8f, 0x39da44f632ce9fc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x1326827b40f5a0b5, 0x5ca4995f2fc2bde3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x45e03b0539c9a592, 0x288eabed604aeb3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x2bea789b6825dceb, 0x4bf6d7760ead7ccb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x327bd23a13628b9a, 0x20b0aee74eb86c34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x5b9e0b4058091383, 0x02fce3747e9c4587, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x7d1db51952a5e769, 0x0972c47d399afd88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x7f50ed5c2a252eed, 0x704ae9f717f6bf3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x2cbd7e7c2769f861, 0x4ac55f020a5a9af4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x685f991762ac04c5, 0x3a1d58d83fe400f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x1c75aa576c25c3aa, 0x202eec342e3fd41c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x544ba0955d9dffce, 0x3ced50e7486022f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x71008b681a15729a, 0x17188f2606c772d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x721e861e0ed67cd4, 0x0563b8574c9e96a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x617c643e76847e27, 0x063994306f3c3b37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x20a9ad1451f85976, 0x0732fa7460cd519a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x796251d825454566, 0x6b27ec8e4d672b90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x07f14a2b2d7a18bc, 0x0d4b2c8761c1eaef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x199fdc664cef0ff2, 0x1001bf0b2466f482, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x2a8d0fc003dfa69b, 0x6cc717756deb7cfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x1df519367a16a823, 0x74b2efcc1b8d9b28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x08ed24f76e65c601, 0x682c31d110139f54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x64ea44290682d4ff, 0x7f4fda8b6a698935, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x587b2e76365ec75e, 0x4b36dacf0593f13d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x5ba40cc460464955, 0x52fb1cce51dd804e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x0dc0621143a12a48, 0x339f6b3d639556f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x10903a3a74c362e7, 0x07fc4b7227603e78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x78a3098309feab40, 0x154bbb743b1d49fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #42", 0x041553633ed716f3, 0x56aae522169822b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #42", 0x2d3cdcf525fb9c98, 0x26abc20d0d02785a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #42", 0x2c7e719742a2dc5f, 0x776c01901227211e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x7901a3bd6ab62f29, 0x17bb125b04f9a00d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x4afc787f0a768b98, 0x56d7205b54a5b082, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x4e17b5e0403752e4, 0x383b077258bcda90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x34fab5cc1568d47c, 0x001d19085ea7f01a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x1f677fbc70701f37, 0x19c53a142d9dbf4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x2f47362a6ae1a415, 0x4435e208237cd31f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x10dd40ad27eb4d0a, 0x307f4b7a5c84131f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x6a8e296906664699, 0x6eab343d3d5bb244, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x711c75c2192c72ad, 0x42555252638fcd27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x23a2fe467070851b, 0x38357da93c18ee41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x30a7d7ff14f2e1da, 0x14d5c8d271bab426, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x2a5bb6576a27de55, 0x5062a44165a28dcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x5a97fd8c57762f22, 0x13404d1a49c33613, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x4257d3371dbf54ad, 0x6d40093309df33b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x45aaa1b7550e7b14, 0x666346d6533513e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x5b74c1ad52e6187b, 0x1090c6293038cb20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x6c128b284bfe15f0, 0x13c898474c91376f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x3c6e9b0b1d7fee83, 0x08aa25b10fb5896e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x3272d05d51d2e1d6, 0x01703d956d16730b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x3bfac02b65f94df1, 0x52b900d65cce86b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x3d6f7d1313d1c5fb, 0x2691bcc81692bdb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x31911aa806d53845, 0x2071f16f7fc7504b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x5be3b359638d2a58, 0x52fc642f773bbc5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x367342d33b3d1fc7, 0x2774877f37587506, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x073b35b70c93d227, 0x03e9ac762285cdfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x2a13c0aa33ab94ff, 0x323b576a43a9d0c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x057e76d5037944a4, 0x30c043ce5c869107, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #55", 0x697292955fe6d484, 0x395517bc41793701, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #55", 0x73b89a7f787de628, 0x580bf4b926e20fa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #55", 0x7f531e6d79a5c423, 0x26a95ff42549b527, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x5d32ee7c43f9f905, 0x1c8571865b36d1c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x7f3718cc1678f343, 0x128f46cd13a6314f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x230cc56a686756b6, 0x362bff4b06724e84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x1c12ebb57adc6315, 0x4a1c1f474d208614, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x7e55a7b962fc2ed8, 0x29a7171c2191628b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x42e3035c3b168e45, 0x630a998c67c83a4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x3394746d3553a9ec, 0x0eaa49f8369b9ddb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x2ef96e0f786ac488, 0x5be5530232e792da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x3c64bd8d20adab6f, 0x0e1e64a10c2c5c8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x37269eb255fe8d26, 0x1fd28ddb3b9bd65a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x3e65e3dc0c2a4425, 0x420e24de5a33641d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x0706a73a50fb014d, 0x2753ea315a78cf92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x33f730255f14cba9, 0x7c0a321d055c4ef3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x1a2b59ee7bced33a, 0x6d24894276da3381, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x31227d26095b245e, 0x2d75d15c4dbfce5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x01c5e8e60ec5c5d7, 0x00a76135601beb36, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x2f7371460c1ad59c, 0x6c4847c13e2aa674, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x621962c33bd4a1ac, 0x79c67cce669a0ff8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x47fee5d168215e47, 0x40cd7415207f469f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x391c5f947702484e, 0x7af816314f058d0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x561713f741866541, 0x5461dbfe6d138fba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x3d55387b11639498, 0x63edc33b70426de5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x1abeb8f63ea99d76, 0x3e023c406e77b5a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x4d6f634d3adbe899, 0x4e93a0d81c84a1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x46f6be365475c51f, 0x5aaf48517ce2d493, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x104a66cb244a58a1, 0x637ce48b291020f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x0c6bb6e844877dca, 0x498f679858494c9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #60", 0x3b89c6187bb0b5a5, 0x274ed9a74588167c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #60", 0x3d371ae616896972, 0x329ba63611a0da10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #60", 0x27ecfe0a3fe58436, 0x01e347f57a8c5362, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x7e8f21ac3797a9dc, 0x6904090442abb700, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x7273927539dfa12e, 0x5f3058dd4bfe84f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x0e55664d2c5e3e17, 0x48e1598c396a50ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x50a896b82c09d93d, 0x627a71a41e9fcd18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x709157071e37f35b, 0x76e919b45d144da0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x19e8a90155380a53, 0x229c641d2c1b1d1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x6bc173c53f9f3f25, 0x3dbbf72f571fc3e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x7f84c35b3ab0204d, 0x51ac174913ae71cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x7247ca29358a81ad, 0x565a28d07e13e507, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x6f6a22dc12f3c38c, 0x4a126a0064bb5c9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x3f5201a300a01eef, 0x1e25ad4a7dbf8929, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x2ca9f82c13486ff6, 0x1c5f56420ffa985c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x318063520fab4a19, 0x6d0ee5fc1d3b4f33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x64e3546d07126382, 0x49566c524b690c53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x46b1a2a77434e784, 0x2288d03a50a4c832, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x2ee507d13aad62d2, 0x64533a0246366602, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x7037e47f0e5cb509, 0x444a4b09212cd1fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x21507895240ddbe4, 0x05e82e9a5fa2075b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x24adfad379c0e6c7, 0x5d61908560a27a38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x0d0956bd5dabf891, 0x709d12945157f2ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x6d5742aa37e9ae85, 0x6e9342323e89ba0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x3efc12072c7b969d, 0x09f2c662523a9717, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x20b07e210732994c, 0x22df5f4a05adb4ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x41dffc1e102e65b9, 0x4be41ab04f9585f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x1e8b1ac276aa8687, 0x70c257ed3217e09d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x1ab8626c6f1b787e, 0x11b9e7f93fdb9357, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x68dc5f45111b2024, 0x207e0d8f3f665d3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #61", 0x6ec718b57f519271, 0x10be503f75e5b602, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #61", 0x373b40f63e623674, 0x346f70125c1e5b5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #61", 0x6addcd11513851c1, 0x2e58f277763752fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x586aeb0d47c9225b, 0x7be507ab0b8e4b32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x57f788144be62912, 0x5b23d1251a4ae72b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x4290af9a5e1cafc1, 0x4c62c7c87682a2d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x4d38283f56dc43bd, 0x365e362d5d491206, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x67f763e12d6dbf84, 0x1caf6f4536148784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x2cbf51f66069ad99, 0x2bfa3d8756be7c96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x1ecbe40d6135ca6c, 0x32dcd7f563fa92ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x326e1c2d5616ed95, 0x5a31e5ea09a9b11f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x1de00ff1705bcd76, 0x1537fc510ad9073a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x3c41f6897186b62e, 0x2523ee6575d79805, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x4fa365ef22b87109, 0x6c5a3adc7ed2a623, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x7994b4c678cb276e, 0x5c1bb8291cdb8e2f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x2638e6f37eea533a, 0x52f015b3618c18a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x5f5400d36b276d33, 0x384a953d52f838e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x4c5d379f1124b1bf, 0x36f2cbd57e1fe4e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x673b9f551d019251, 0x07c996007ecb53cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x0d5d5fc82ec8496d, 0x09a45b07051baf46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x204eff9b674d8227, 0x7af3474b499f5651, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x0a05f331248db49d, 0x4871fc746ff2658a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x1d58dc0b5fbe096d, 0x0ccdf3b9039aa7f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x5ea85ca71d7155dc, 0x6526c09f4391c2fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x0898c30f4d7cc7bd, 0x1689fbe73dfc5d7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x5ea1797c43e5d85c, 0x3c1c425c54f5faaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x60e76aad5d65a983, 0x53c14e7c45dd18d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x0c2df2f045ec0f63, 0x4af8c8176e44ca75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x2d39918a00561d3a, 0x37e420c62c7cf28b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x24e3d1d7293d4bcf, 0x1c6f5816373f84bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #62", 0x08fb553c2000ed52, 0x3ada2cb3423cade3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #62", 0x3d72432e1c586cc9, 0x05ce70e167a3b1e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #62", 0x69d5348661bc51bb, 0x25a00f5f460b063e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x25a22a176ec24f69, 0x1b0100ed4876ae02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x4c27f8ec594c8eeb, 0x0e53c6d4068994c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x1f389e4e2cb28000, 0x74ce5f3a5855ebdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x2d089d3b2142367e, 0x04d2de684c722fd9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x4a7f824e3e8be147, 0x03b1b49451ec6f12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x5e8cce9919f78dd7, 0x14291cf5537ad78a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x364ffaa060be98cd, 0x3b1e896e1bff11c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x427aea887d0b18f3, 0x620a180620252f26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x6bcd685c76efa3fc, 0x689bdd28681d149f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x503c32e86375089e, 0x6ea6a96437f56148, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x1027889e151e2b8e, 0x104b4d256f74d136, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x3660620c3f98b5a4, 0x3be7010f3d3025d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x7e2496eb2345b1e1, 0x0f1c94ec00dfe45a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x3d3d3fb80f794553, 0x545abbe55cb16585, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x7037de215aba8f53, 0x78b0774d738d3a58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x57c5a8467c4e46a7, 0x13b2697e32b2c8a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x733deaa3097686ad, 0x1acfdd49439310a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x6ceb8f4b0bd3bf10, 0x7b8871ea437a1d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x20f1ea9e6ed5efd1, 0x32eeeec27d1317e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x2e6ea575495fd2af, 0x3a433dc357524caa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x6ca584902c8cecea, 0x583231052c933c61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x3c06323d01f51933, 0x0944a1e629e2c449, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x5cafa88631226820, 0x1d6ffea12c3e105e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x2d70aec779c0b651, 0x5ef0d908347550cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x03373cfe7390d358, 0x7808616e20ae996a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x7f6492681717a5b8, 0x6428b6f67022cc49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x05ed9589277921f5, 0x6d35e43220567d06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #60, #63", 0x70d8f4a44fdafab6, 0x77a8c9b1345c3aff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #60, #63", 0x7c67e7a06a341946, 0x60ef77605d7e7935, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #60, #63", 0x6c29327924d13c1f, 0x07613d7e386e19dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x55f3a43f439d0344, 0x64ac2a3c48d8daff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x3d5db99575568d39, 0x7d4e2bcb03645306, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x68e76091083ba367, 0x2412ec714094f693, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x1f53491f1deda70e, 0x30b7c2dc684bf2fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x4566c904004b39b1, 0x08a270002540dea8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x502634673a8c9107, 0x599d19a7363fbda8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x24c0aa4d1b1f745b, 0x13be36dd4c8e1c07, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x3ff0b07b69a86021, 0x04fc35e510e9dcc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x2d4563655710e390, 0x59c2b7c515e454ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x4c6770c93d5b9432, 0x1948a7c16aa31cfa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x459737995befd669, 0x2b38138d354ed15b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x79dd7d77263d3455, 0x1d9ac45564ea80b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x26886e0763c87908, 0x0a2b5f603f44467b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x1e550a0f09423b01, 0x7584042476aea26e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x2461af5d4838f45b, 0x433cbe764315b45d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x31e1547c2dc248e9, 0x53ff912364525fd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x04d32c79137f5c53, 0x7a36b4925f26b7e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x50daf0857501e868, 0x49c9d4db513a9d43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x50f1bed1242432f3, 0x06896e9e1672281e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x4a61674805880837, 0x7b5ca8d64acf3c48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x6950813f7f9786e8, 0x0a1382c470e9d54f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x08d9c1e92ad53634, 0x679877be07a58b4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x730e2a8f1ebad0cf, 0x4abb3fab2d3b7146, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x4c7d19b80bc485b1, 0x118dd11e24ef7f0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x1f43e2044de00bc7, 0x041636ec51504631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x42e1f42f29145212, 0x228ae374701ed28a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x4d38850501eda37f, 0x0690faa813d3b300, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #0", 0x0775abb668b6720c, 0x5ea2ef481799ec4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #0", 0x684df8f4701c395b, 0x0883c19d70c62cf5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #0", 0x1af16f8f4326f7ef, 0x786bb8437127bade, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x61e1c8be2ff0fd43, 0x1e632c240dff9a1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x3bb582f437055015, 0x32ef19292e5ee276, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x04e55bdc223a0c1c, 0x7faf28a75af964f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x4b4e5e2e51a9322b, 0x4b18378247c7500b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x5396d5aa3a3df254, 0x5b9b030b1886e334, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x22f4646038a4911f, 0x3020cf825b0c8160, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x28c0ca7b443e6698, 0x4bd2ae550b425d55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x07655e871acd4457, 0x7c6a183343b23a0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x4abe419a04a0ed52, 0x51b1d42969472745, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x3ba63d6817553263, 0x17a609bb0673c48e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x398f3e7f2c856109, 0x616d2987408b9944, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x7e2e933463edec5b, 0x0852e95004dd9cad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x1e2bdeaf4d854f63, 0x1d647fe151c568de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x0629e08378a49893, 0x2cd1ea3e41204310, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x3ce2ff2c48ccb898, 0x4c62a0652eeaaafe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x6399fcef444eb931, 0x729ce50844485db3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x48efa68445358eb4, 0x2d8f84f92e583e8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x5c8ac11716392c9f, 0x34cc03180495e3ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x42be8da94d746680, 0x45217d301619ff96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x316252dc385c1c25, 0x1af79c4440ed20dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x05e16b893f8473fa, 0x12b289bc4f8e318b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x38290c8e5d111500, 0x10ae749b0c0b4c0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x25ddcd982d92dc12, 0x3af5f70a750c0bba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x71e1954466e3ee66, 0x3954696d0977ca88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x2c197d1b6c9c0c2a, 0x37d009123ad13bc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x02d538ca04889ce4, 0x3f671fb408a43e32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x51fd036539b5da0d, 0x1ebe3dc94593c673, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #1", 0x7211f6321933710c, 0x0680e750035f5641, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #1", 0x58b7e507639bfc68, 0x52ed87cc77f361bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #1", 0x40ad11683ef4a4d1, 0x03feadc710e0f195, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x6c8780e43f4166bc, 0x05ecfd4f668adf01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x2625552327d2b29b, 0x7002a9895e691628, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x146ebec558a171a4, 0x193a51f0523ed23e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x5d2a0e8879a14e39, 0x5ae310701743f78f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x335728466358a553, 0x5cd7be022f2711ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x7c8c165f0573effb, 0x3286682e25691e79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x690fec63215b2dfc, 0x1d5c80345543fb66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x604fd2cd6c11ea4a, 0x6624ecfb29bcfdcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x2b535107004a8655, 0x1047dccc4cd753b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x281d38f0447abbc9, 0x2b4069d95178a62a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x1d1c2d6d7e9a88d8, 0x23b778683c8bf7b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x783bd71230a7ad48, 0x53cfef457a463bf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x1400529b5bf3b612, 0x296d4de32b92ff58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x6167a60d6e589e06, 0x50fc1dd1108c68fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x0fb3cc024bf5515c, 0x65d064614a779270, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x38073ba7047c6d08, 0x7434903b70039ecf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x04c6f35d681b5c5a, 0x3cdaf281635a8cae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x2c961824588aab40, 0x34d332d82ce42c4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x572534183d401349, 0x6970240449b24591, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x6de7c0916d65cf6b, 0x43f881874f610b2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x4959857d4bf02854, 0x7af40a8301e8132c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x3a48c65a7844e088, 0x12747c272ac12b8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x443a31e4696d4e35, 0x7538bdfa49fc925c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x6de9bb3d76db23ad, 0x3a00312c7c416d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x5ef68007146f2d11, 0x5f9bfa3972b0ae9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x6cf9d8510904feed, 0x1f94dae90b8c982b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x4645123619375f44, 0x553eddbd441f0c6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #2", 0x069d2eaf0e742217, 0x13801794342cd2c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #2", 0x5a644a6c4889621b, 0x3614e5f44ff6b42c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #2", 0x40ce42a36ff09db0, 0x7ab7dfb614ad10c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x595debe618a9d44f, 0x5ea9a32305087488, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x0f84f7fc60e5dc4d, 0x0149e2134747a723, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x7555095e598d30a7, 0x39f855be6e7b7803, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x62922f944f46edec, 0x7a08102f624ee1b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x687e4d3039ee05ae, 0x266dee1a28d741cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x486227c61318fa87, 0x5d0414936f1b7be0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x5ba25ca339ca0fc3, 0x3f12300c22c67232, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x29baad73161d261b, 0x377382f81c709f46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x2ec6fa6a22c2f5e2, 0x217913ce03189959, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x03a8d22f0458963b, 0x4a60407d3e4bf266, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x5de5c6e326cf7a99, 0x2cc76a6a78fddb8d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x7616688501baab57, 0x5b4cbd3d4077f677, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x3ba8b10646534cd5, 0x694f38425e94b5b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x596c475d0cc261a2, 0x4db03195040ad8cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x468c71655e44cdf6, 0x26d14afe350ea400, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x7461f41272f85715, 0x517f434670471ed8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x15bb4cf73dbff8af, 0x735fb8322328ee7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x42188eea0e3c4b4d, 0x6174e0e319641f26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x350bc5e66daeb7f1, 0x1261fab31ffe55cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x6f69634849c58487, 0x60764c452b222e6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x1018d15d576715b6, 0x09b6e4202b12144e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x6429775855ee3818, 0x2f1ced1a698518ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x3433060f70130000, 0x1e93bcba2ab5e8bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x630b57150e5cbfc7, 0x1afd07952894fa21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x4c1cb8762d32c980, 0x4bbde89d78c6a40c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x3b6f14cd248cbde6, 0x122ac3320e354761, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x123b75d70ea9e973, 0x2e339d2e707adab3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #3", 0x586f6dfb2553ed3f, 0x1b9d091e01a4d91f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #3", 0x7cbb02f55bd3da88, 0x2cb6ed6e68883f58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #3", 0x31c212a170a114cc, 0x520d581260e47a4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x60b414cc26976a9f, 0x0b9a630a65f518b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x34f42a675a47fb6e, 0x0e8a12d143bf6be2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x077ac4ef4eb0d321, 0x3c860fee0110e2dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x733d91073d79c76d, 0x0f462a3e42e9d9bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x4c23b0e04f01bd8e, 0x3364b470057906de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x7455aacd33d4cd6b, 0x071ddffd24931edb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x0fa8a7f45f28b645, 0x0d1b5e337110adc2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x4fc9cb115d8f8b19, 0x51f5280f416aba95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x0426f5b935e9e616, 0x275fd345307ddfde, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x1031e18430c35bae, 0x743d4bc0391b2020, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x7f742ecf49722d3c, 0x3a2c02fd17aca673, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x06ebf4a90dfb34a0, 0x5a96803072b1bfd6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x5cfcf22e7f48a6b2, 0x782ac6b4530fa589, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x331d741d04be2298, 0x77a2c46551529cfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x63e6d8de145872ce, 0x42634abe42c61c11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x71e7fde72b90a9eb, 0x0430d6a633b0a3ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x617a9001586bcf8d, 0x642e83cd760ef3a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x092f2b3c695616be, 0x2f2a13c071ac7186, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x32c843fa63ef9829, 0x095917f908a35a0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x71eaccc9737fe096, 0x7b5519e239b438a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x72c887480466a291, 0x0cc3de2c4ee7bef8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x0924c52a629da6b2, 0x203a5bf425e5fb66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x76f619806cdcee1e, 0x68ac17776d0b9e08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x186d980904eac5c5, 0x20bc41f768de1768, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x5d5695520e171ec9, 0x5eed0b0879e8280b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x776d358774edb18a, 0x6b9499916685c08e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x58dd49b46a7e347c, 0x6f291a9a2a357981, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #16", 0x5dfe151270ad9050, 0x63e9b2244ac8167d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #16", 0x751432e239ea3169, 0x19afd57550c69c5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #16", 0x1c87d81c5f58af38, 0x76ac97c17e38f80c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x4c359d560c00d80b, 0x6b449614137df19c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x10eb9dd05b49140d, 0x7c5c090464a33560, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x696032d64a1ff6fc, 0x5e8b5d6b6e423323, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x3f0da88643f10e4b, 0x54c7f3b160cd685d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x2e6f42c76eec9402, 0x0b02e1de17eaf23a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x5f9a24527c62de2d, 0x62b308b80c6d57da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x364d0f9753e08bf6, 0x5d33f43554ae5734, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x33393b2e3e2be554, 0x52e74f4052d4e7b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x4a2cbd6062aee254, 0x6652d94f7f6ed885, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x3df7f661429d6b50, 0x64120de55b185b30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x0cbd624c1e228205, 0x495a8e5327582937, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x6213905013287372, 0x082591944bcb0ad2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x02150774466905c5, 0x63b5fd0d1082d318, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x42cbe3f27a241f27, 0x1cf02af261af2bc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x4e04ab1d0944d23b, 0x365d82fb7918f389, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x4770b7903240b48c, 0x4beddb3c013de64b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x14ef96e064beccb5, 0x00acbed0119d74f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x275c380536105e74, 0x6cb5d02052e78d41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x5432e0790265480c, 0x7a3fb67834199a51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x158dbb7e639aa231, 0x7fe4a524364670c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x2a03a7f663b96ed3, 0x46c943e117a2c2f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x5ddd8dfa2faf71b3, 0x7951eeb86ccf8be8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x38f443ef31d65aae, 0x65e87f722be23917, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x64170f3a2dccde33, 0x2d201f630064fb7f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x128baae97eb8408f, 0x1202706f7906a61a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x34c89f03462de9d3, 0x4bee335b39e7e2ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x489331df6de62264, 0x6e017d4008fb7f7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #29", 0x5180c495060b3427, 0x3f41f0465e20ed5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #29", 0x69c4a2fb6f159f08, 0x75c3b04f7b846c8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #29", 0x1ec510bb4e3c77e5, 0x6853f87347a230f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x0012d29420a48970, 0x73846a0d57b954aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x4e7167a36a20c098, 0x581e50296429e1ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x68d90128291ebb44, 0x5d3087e960fd128c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x6f4ca51808e672bb, 0x1ae4f57b1da1a02b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x76cc951f65df0fee, 0x269d1fa837dfd6f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x6bea44150bc474a4, 0x1600c455484d59b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x7ada13ac2c25beb2, 0x43d1c63f55aee710, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x7a62369810d58213, 0x1d511806199f2468, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x317a0b834976c93c, 0x715879127a75092c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x339789d43bcf72e3, 0x5e9eeafa7feb7326, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x64ee2e287bcd7b2e, 0x60e885b31c708afc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x04b3ede960af4ad0, 0x3a122b28543ad340, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x468e5abe221b6e8c, 0x0c1aaa377b808308, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x2ddfe331079fa2fb, 0x43cddcbc32789ed3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x33c561ad25789dea, 0x082785e428b9f6dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x364e1ffd33b19458, 0x42591b452e279845, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x7d285d94073b8c6c, 0x289ca17167c82b80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x430aff4f489c2459, 0x67b39ea630bfe768, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x44699f8707429d8d, 0x4d30726527f92d77, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x67f1e85d084eaaef, 0x7c3400b7491d8d70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x2a6a197b086bed34, 0x449e10782e80431b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x100b902f692067d2, 0x60f8e1ee5849fcac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x0e9905bc435d0ecf, 0x0103f38a43d0f1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x770ea3271a952b94, 0x71f88a2244e725b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x21d0b8001462efe0, 0x2caf5139743700bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x5cff143972275a89, 0x24f6e82464dbb74f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x7969f8160908e57e, 0x0cd4e4c72168b3c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #42", 0x1157906d2f2451aa, 0x6a864131615be073, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #42", 0x37903ede70d5057c, 0x0fdc238e3bc1a9e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #42", 0x59f56d4f150f9a1f, 0x140ba695479bcf0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x586ca8ef7d654b0d, 0x0b6cc0eb688e730b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x17fa76a15a24e9fe, 0x2d7598c54f7b4c16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x6e87d9de68a934f6, 0x43b24cd239cb2ea1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x5ad08f7f2b7bcab8, 0x1ea6e5f14b86ee18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x3484b0365775e30a, 0x6cefa1d9543a8795, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x069a34b445728b96, 0x3596680845dc40a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x3647911215a99122, 0x019dea8d3e2a7393, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x2ab92b421133038c, 0x05c642a1103cfe61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x0e984e9926410a32, 0x78cb716d0325d431, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x0065f43016536d19, 0x52a120472692c53b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x7efca20f7f04d9cd, 0x605df3dc6eedce0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x2a80a48527645e00, 0x3a74bc2759cd318e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x7eda410a639e212b, 0x2e07b9235f0554bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x2910acc1267f7fed, 0x24e19560057475bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x3c29110f49652bf3, 0x439ee9525f583dd4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x5a982f7f6860ada2, 0x6f953c3566e23c51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x0ea1b7d43ca930ca, 0x6a08108269307e18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x52fc9de370213730, 0x0fc343530f07ac05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x6f2610fd386a363b, 0x7df57a1451f93ff3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x5fce943b59ce2aa5, 0x2bc6718119a6b583, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x3d6c4bd01d8d9f9f, 0x78ac0a3f5ea8d545, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x440d1f8c27bc3456, 0x641d4b04667cf892, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x71216049356a729b, 0x45d536660036309b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x1dcb203e51207d6f, 0x67186ced4bb98fc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x0dc9ae3944ad5134, 0x34ea0de12c6cd812, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x34ce88643969fe2b, 0x3b74841760c64c1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x71d434665e85fd91, 0x32bf8c1023f49962, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #55", 0x3854283636475924, 0x3d9b4ee551a2c8a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #55", 0x53d4f8c31468e8eb, 0x304b9de775c07407, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #55", 0x3c251d422212a2ff, 0x5c3d6c9917e2184f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x577d159a7f30b5d7, 0x181848ea2d467d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x505133472dea1b35, 0x79000d54754835d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x72976c695d299202, 0x21b50deb5e1ae180, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x1693902e71a0b9ad, 0x3ee12d9d2765f4ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x5026b73f08f5dd15, 0x4b5a8e300867c494, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x3f3d36390a562b1d, 0x5a0a8d36087adf75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x1ebf14085a78c015, 0x7e3b537c13122efc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x7c8b6314430c9035, 0x2af4474b5ae4314a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x423d460d012abc2a, 0x082aaed6540878af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x2f14d75f6b05bc72, 0x4950ae87128e7954, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x482f4e752f8a8872, 0x70a95ad421ac43c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x212b421f146cc6c6, 0x491238965ec2dea3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x1d62a3db4135306d, 0x672aa3377151f95e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x4b8b5b8a78082c50, 0x79ccd8d45c9fda14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x5280ec661aa6505b, 0x6fb209106a4a6f93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x5db2e0914d594fb3, 0x452ea0dd4f0c4f7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x4e840bdd6c6576b1, 0x2314c8291ff0269e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x576b33232327fac6, 0x327e9ff27d98e33c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x52b2833868575f9b, 0x1f4527051f9a8198, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x7cc4266265880373, 0x7e5d603b73ddc558, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x26bd33e05efc978a, 0x652fbeb61a26ca3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x5704c3db6678ad62, 0x76c6a45272488f6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x011efdbe21c19fdb, 0x5c92fefe2985b041, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x6f1aef8f1ba6c7e5, 0x7891ffbb5ed1de4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x080c3e963140a4df, 0x7ec204ed3d9efb6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x54689fa55a7d05ae, 0x3b37dea95f7771b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x42d465497d6f538d, 0x7f11f352271b22de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #60", 0x62f757000028a6ec, 0x1af8e8363f988bab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #60", 0x5f253e775085fa3b, 0x59bf55e909b48ae1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #60", 0x36fea79d5890194a, 0x7bfd1a4c362a0252, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x7a51b9255841b24e, 0x5fafb293381da55b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x73e87a3315b18897, 0x16ef83aa696ca8b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x46f22d76624382ca, 0x270ba4217bf4b8c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x3cc088785a7e1dd5, 0x5b6c2a831b5acd1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x57ed71625d6ed830, 0x4275effa7f94edc1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x5d977f1c18eccf56, 0x3f2d796d3ae4c863, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x6972c99140966d90, 0x449953443cbcbd93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x192686da52967278, 0x72e6bfe52071712e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x2ad824c76f7e9a34, 0x588f168a13783fff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x053022cc23f08cd5, 0x7ce4e8b41ec09efa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x06340f9f76218247, 0x1ab557c44c225042, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x509fa01c29f30d58, 0x677d1d5e42f49817, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x0761e58801b6ff45, 0x428985d8288d117e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x1aa3ce9b280b2d25, 0x6371d9e164f964a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x68a19ab5149ce21e, 0x21b622380416982c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x673354967d171fe5, 0x2488095b01c8218f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x6c95ba1912254a43, 0x1540618f120b795d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x3615d7184b81701c, 0x30cc185871c5dce5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x41a2f26325654a86, 0x3de82d283c49e6b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x4f5857df41c804a6, 0x7f3e7ece1242927f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x437f03ec1e417ddf, 0x3acfa3fd56ba3d67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x464cab045d69c445, 0x3bb3a20c5e22d287, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x7206a66306c1740f, 0x62396ab42eee45ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x03d893f445f6c8d8, 0x30b667495939faf9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x581c131b1c118caf, 0x6b457457706e4e0d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x6792fccb201c581b, 0x62342af30e31ea33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x4581a2a149ba4fb8, 0x4a7bd0ea2935ef2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #61", 0x0b82545f764825aa, 0x3b7881ad14d9fa80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #61", 0x1489a3892747d9f4, 0x6b9437e84f01584b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #61", 0x04b19e390f5d9586, 0x2d242ad25ad64e8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x161f09953a7afb91, 0x09c4944876b8449c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x0071c46a3b37b3ed, 0x4ff23f9619f79d89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x5749409c6c9a168a, 0x0a65eb97588dd785, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x0cb66ea5313b92a3, 0x66bfc1b93edc3d67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x7af5e25c238aae42, 0x68122c9552381146, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x19d2d3ec52a643af, 0x67120bc7067836bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x79ee1da3029db9d8, 0x55798f062e5c7776, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x11fb4f5f12f75a4c, 0x0932c6047e9fbbdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x4d7255dd454a400f, 0x75580079281a58f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x0081f3fc4c77e215, 0x4211f67e4de41a47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x3911f89f0d31b386, 0x2671f1cd57cb3498, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x3e6d46297eb99e94, 0x16a771ff45c86744, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x22444cd67f128451, 0x1800788a39632885, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x51b8c8001554ee46, 0x3fdb5f403c1720c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x17f2a81f73a65e3d, 0x6a7398394ba6e5a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x069db8893f9ea1fa, 0x4a46a18129edf77e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x04e8e20a141a46f0, 0x5208507254100e66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x6092290548661a7b, 0x21f428ae056ad606, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x5597ce0173dd7c9e, 0x5d360a9f19a421a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x72971b33776d0173, 0x5f6c88e81405142a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x767f85c40d439bf0, 0x4d683cb014db6809, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x22988a373b662105, 0x50f288cc48384dc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x2f0c7f425e25d4ea, 0x13df33693a8b3256, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x1dc476e436817a46, 0x647929d435aa37cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x4a9bc1372bae6ee0, 0x09ba463222ad58ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x7414895b054e3994, 0x28182ef52b2dea3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x792bb632243e94c9, 0x44d20be149ac575c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #62", 0x1bab963c2b19a836, 0x5db16b866bc2d165, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #62", 0x385d44275190c23b, 0x009e396f122b1c01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #62", 0x0cf6e3416e429d2f, 0x5a6369c65af5ce5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x4c68721979fa2a88, 0x158100b43c036283, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x307ba4ce7b67e081, 0x71ad9a4f6a2ce8fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x27164f6134f270e1, 0x0cda41ec7b176605, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x3a40aa756b175c23, 0x264550421b2ad8bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x0f55f0ec42889b9e, 0x64d73018336c60a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x6da243d51fcd6b7c, 0x1f2f320d2b018729, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x715e2db717900cf0, 0x3d2ca32a25ff87fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x05d2aa1f1676570e, 0x00f5565a7e5510f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x107081962c060dcb, 0x3a58737c523b1c38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x276dee4c49424721, 0x3c68053540ec2664, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x7e34b8026248dcac, 0x3c038c6a4e843dad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x4d6038cf4e864681, 0x69af166938756277, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x110ee21f0b10f52c, 0x6be1c31f5cb629bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x2ade60a844e4540e, 0x07b7b0e47eb125f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x5c7460fe25a6044a, 0x24b0adf01c3c8e5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x3c1c5b5854ea12d4, 0x1a919f5862470b1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x00f0209f70ea2c8b, 0x348227554c8cdcee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x3a2c73ac497c8fbd, 0x0d790353285e0eeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x2bc56c6960916301, 0x76e24c9838612baf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x2f17a9825cb85145, 0x70d68e267925a538, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x67c946715d937fd8, 0x55dbcef340268ba1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x2277d3e663885f86, 0x3ed7b19612a7a719, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x092e63d14975d4d1, 0x2ee435797eec34e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x1e5fe7a515b56758, 0x61334002454abf29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x069f93e31f509f6b, 0x11d79c181f500844, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x68cd2f283e9063c7, 0x47ae172f40cc078f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x1f21c6c86a03c165, 0x792d333e14929b91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #61, #63", 0x46bc12aa63940fbc, 0x0db840c94e39704a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #61, #63", 0x41278f944d37ad81, 0x0e5ffbeb2e85591c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #61, #63", 0x30c00d08701135ae, 0x412d0035639f637b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x39870a7f43bed862, 0x628b986039ee70d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x59743fba1110cc1a, 0x7f39300257e6f224, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x30616b853ee51197, 0x7736fa686013d39d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x7d75755e1a0d0e6b, 0x20dfdb2d192e9aad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x0410cfd03b797707, 0x2dc1363e1c973c26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x1f0d86c47930a85c, 0x6ad0ac704acce27b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x466855dd3a7f3bcc, 0x79523b9760351658, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x2a90717b26601233, 0x43d479d3772862e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x6a1eea96305003c1, 0x3116d3be64177bfa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x4160cfdb33356887, 0x3bfe6e1f43932a50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x721a7a1f4486d91b, 0x23a6fdee71c23b61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x5e93e78638b20c4d, 0x0af0d60e6f8fef7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x742b835476f7d814, 0x0c272ba462a4b757, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x7028807026c3d569, 0x2d7199d213390a18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x6143113537429a44, 0x736e20713690d64e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x5da2ac785ed00cf2, 0x2db939330bd382b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x0f2010b32be96cca, 0x6feafeab47c1970e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x5f1ed5512efbbf4c, 0x0b54c15e5080e08e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x738298674d33f1fe, 0x42431bef51394f70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x05e5fe4b4cf06a92, 0x40c93eee52167fee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x43e842a6622cd117, 0x34bb37457a11819f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x08f0a68000b8ac29, 0x0d4a8bb83410c317, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x37fb466d185ad298, 0x6aa199656a33b7b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x772adf8a65f23911, 0x76073a66159df2e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x11dba5db68b44b52, 0x5d5f89f3064af03d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x17b00a9e190eecbb, 0x56cbd0cc70fa7b2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x6642deb902fd098b, 0x4233ca9d0b32a306, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #0", 0x4fed741d12045a39, 0x5d4922f46c28dd04, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #0", 0x74312b507384ea5c, 0x663a5ea413d5b6c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #0", 0x743d96853288133f, 0x47e679da7d21d1d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x4ae2e5d85d5cc3eb, 0x675589852c38dcf2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x434efcfc1f3659cb, 0x41d6cfd8420dc562, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x07eaa51d1f24866c, 0x4858b5a0552aa2d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x383373270858e8a1, 0x46251e041f9aafbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x0b55f22c081675b6, 0x2acd52c21e7651e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x1a1acfef70d98d89, 0x0a9f2ee55b436649, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x645e77e536ff96e7, 0x6f191d0c0e4bfb3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x6987aa2672c35694, 0x0b6dcd0f589c0e6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x50201a8046abbb35, 0x04d4eb5d346a8ffe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x65e215003ed10b01, 0x76785561136f177c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x5df5916d2ebed858, 0x6899ba546dccba1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x3717c0f93834bc9c, 0x0d6769da16290494, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x404b32523f3e855b, 0x349f5675426db325, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x301812e40cca367a, 0x1db1196e5a660241, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x43c9cd61741fca8f, 0x68b1fd8014768aca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x66e3212371e78491, 0x6d1299342d517788, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x38933fc658345ce7, 0x61bc078637033ba3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x170567e8330c0d74, 0x4a7253201e7554c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x61cae5cc19a978bf, 0x0c420ee574faf955, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x51de355b3fc3545f, 0x0b23fdea18e2a6c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x7f01d9ba79017358, 0x5b5059ea122967ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x05cba9d25541676e, 0x6c8f69ee2f19ec9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x496131fd30a3109d, 0x4390776949957734, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x228a952f58a2f642, 0x76e6eebc30445320, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x30d7532a31b9e1e4, 0x67478ec45b1dd4f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x64c5ef5805d538a1, 0x799329bc47dcbb12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x1f7eb16047fbb252, 0x3cd7b4684690d524, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #1", 0x07bf06b13ac3d5d3, 0x5f737be9715ce6bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #1", 0x33c5492b7015b856, 0x03864e6806c0e06c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #1", 0x45571fc4796b4474, 0x35dacd0b3990f2fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x2a0e55117a0d58ed, 0x03266a310eb851c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x52b04f30264433a6, 0x3efca4e24c98ea40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x57fe158a2149e8f2, 0x27b6bf360387a25a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x271f2194083c11d4, 0x4b645d6c3cc404e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x5037c42662c855ef, 0x0354da06469dd2f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x1d8c2bc23b810818, 0x37fab9b057f6cad8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x2b96c06f1492784f, 0x5eb7ab44515174ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x0dfdbcc30e08d21c, 0x0ae267ea70ede033, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x08162b093ea2d6d7, 0x7fa631f5380c11d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x64e70a7d2c5bbb4b, 0x04a4fc155ac67a39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x4da5a43d29b27a00, 0x5e4e1c933ce52007, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x31ee8bd47cfdfeef, 0x79a924e974c4c5d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x5fc654de735d5276, 0x3b6298c602264ffb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x2ede5a8e38d4c617, 0x5a1d1ad37d5280a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x4d673e6659865d77, 0x4ea3f58d5a751afd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x678f2f934b092d26, 0x4b62fb315b64fb29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x09ac03fd18160912, 0x13710cfd6fa55a9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x4471c45d28b9f16a, 0x4a6bd4d66e930e7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x526c6b6a2521536a, 0x2b782e811217689b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x221f5259423ec732, 0x06dc2e6c045af73e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x359c19a8609e620c, 0x0681473901e5a737, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x197328234ddc1d64, 0x7f3827d7647a7437, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x27627adb0a528a65, 0x3eef8f3466da6689, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x555bb78b55b06eb0, 0x423f61b20ef1aa6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x6dc677c24902d9e2, 0x7e97050c5f07bb88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x71bccb4c7912f883, 0x4d9aca0232383c20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x1e344bed4b2bd327, 0x444fa4bb442936b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #2", 0x0d6a9a5a4f05752e, 0x48842df540539e46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #2", 0x2fa3d73b41716d54, 0x4239457d4306b402, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #2", 0x0f4d8ab86670b76e, 0x278128394916ff5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x70c341d37230c79a, 0x2ff165e836b00594, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x47e1364a4438b50f, 0x45a1b003461ef95f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x0d3b8ef172c17eea, 0x2526b4e735a7ae0d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x6bd4776d2c2f8ee8, 0x67dfea2d7ef85a3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x775b620f0ba5bee9, 0x432190f40a08c35b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x5aab34180c95a71f, 0x4a5c61a104c5fc69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x4e0714736f4dd8a5, 0x47ccb06c0a4f0b53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x55be901303577099, 0x53660ab15d549f2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x7588383459a654c3, 0x1404a4c04681d1e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x1ddf09d231c7802d, 0x0ca0cb463d696e7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x2488ff175af106b8, 0x73111c8b2b1a98c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x072095a06d3483f6, 0x2a12f301105d7685, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x78da42df64c29b81, 0x1a6639e07e7bf7b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x715842a04b0ea485, 0x0341f419538576f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x3a5c7d2b313a8cfc, 0x5dd4824a3f5f5714, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x3491fd9530b89b00, 0x1cb3f640101b0d3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x0a5eefc3633daa6b, 0x569cdf252a1a35c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x15052a995a94c0d3, 0x6783a448283df995, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x3585c78c7d6b855a, 0x53589258398e29b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x6aa009506451da15, 0x49eba0353ca65d2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x491475973e6448f6, 0x3b2254dc637a4c2f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x0972ed7b14d44571, 0x36ffc3273a6cb837, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x460ed26d1680058b, 0x79cc0f4b43cf6aa6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x4738a08b2a87570a, 0x53ea77e57aa0d003, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x0dc501760c3eaa14, 0x24bb05cc5197904e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x66d36ae84d2e1c3c, 0x79d589e322ca2c0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x4a99a1962643f5f5, 0x5c5855bf1c593274, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #3", 0x0a95d00a1421e47d, 0x58ff8fa03539aae6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #3", 0x52862d734fb3ba3c, 0x18b3f71553aa45a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #3", 0x6487ffae07e30d24, 0x0e16fdd95bf91aee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x1e6312b073b2fd7a, 0x1fc885952a96d21b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x1e3a548449f2a7eb, 0x2537a21e659bb33b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x563151ff3108cd6d, 0x3733438a2bff55fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x7e36e9a92b21d7c9, 0x4ec982093d04bce7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x5165cdbe325d7efc, 0x595def5b48d08b3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x467f637916be2d3b, 0x7e0a36255bfb9dc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x6671e7773dbce143, 0x2fa5e36a190590ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x459fee6714c7316f, 0x74feabda4af9e725, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x087a2ee91ac85b5f, 0x7590b94164030117, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x64bb034a00d1f7dd, 0x499eb45326b4836e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x31dac54a217d5b72, 0x52b3d9683aec554a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x4c9f333b514f018d, 0x77f112313011aef4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x03ac808976ec7059, 0x78e23a331e0500f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x0daa9d9429a6822b, 0x7a009ec14a2be402, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x6763636e583020c8, 0x633174ee741c850b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x6cf7523834a72572, 0x3f166c312d0351d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x4f6f80d15aa50740, 0x110652ed75718121, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x5b76ff1d6ed9ddf8, 0x1c26048f342a841c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x1057396a6707eb97, 0x6f16d9660d51c468, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x3856ed243645ad8f, 0x3d63735c5cf66ca5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x2d321de874fc0c5f, 0x7afb6d9e3c036dad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x1ea28e8b6960c69d, 0x062f51af3adcbb7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x4190e7666e0facb9, 0x2ef940880605f1f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x22b6d22b440f96bd, 0x330943cf2e88399e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x1eb49dfd401fbf4f, 0x23f9babf722652fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x2ef99d471567b07e, 0x2650d7187a2b9d1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x7c6f9c1644e0d4df, 0x077d61833f50d6b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #16", 0x7b26826e1742b0f4, 0x1c47435634c6893a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #16", 0x0c3ebd5376f94897, 0x70c9f6e82858a057, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #16", 0x605a0f35122e9c5b, 0x63355bd32ae14bde, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x003e491463f081a7, 0x30e73dd821eaf69b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x28001864746ceaf8, 0x5073303922f51b3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x348caa473b6c4554, 0x151b6e3c46b4b662, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x50d3f5d3485db500, 0x40e0537d6386478e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x0d3e89df3f1e6195, 0x22d71e3f4d4391e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x5661128972d4120b, 0x020a1b2308650c4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x69cd5aa313f30878, 0x30bdaca4629fcfdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x2621a4d33e685993, 0x0d811bbb4a2769d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x2258db3b3c8590ac, 0x6c126073265fede8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x30f27ba45e707763, 0x495509274a58f39f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x19dcbcb851edfd7e, 0x110daa01657f25ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x1a4bb27e6bdc8bba, 0x49056d7a6ab0b28b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x2afaed4f39fe5f97, 0x37f44474278a3c5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x2cd271a360acf54f, 0x2fef48ab015bffd9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x749ffdc7717ceb71, 0x63fbcfb6169fcc46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x2fe545054cd99691, 0x60c7361e1ac1a29b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x095f273d0a7699aa, 0x41219083523e2040, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x68e7110e2da4bde1, 0x1c9713df3a51a2e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x7f92bb5f68d63648, 0x1fd0c8cd02c3cdc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x54b2c2022568c4c5, 0x6d74805119de6dde, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x5f67245c7157f2e6, 0x4168aa3b7fadaf51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x5204e83665057ee0, 0x0109af2a0c3995ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x56826a5203a09863, 0x22d9624546a4e5fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x507a2ef42288191b, 0x616688980667af57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x2cfeb2c6753ce376, 0x58a5cf9759d95631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x22e1a15733fbc1e0, 0x142af91315e5c3d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x1cd1f828061e11eb, 0x18a9919a22745cb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #29", 0x2b86d6b07dbb74d0, 0x3c52ca957184ba2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #29", 0x6f1367b7723c18a6, 0x7132697c0aedfb0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #29", 0x574197873a00f351, 0x1727910c41184fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x3da18bb56923be83, 0x07bd35ea2dc401d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x0babd79e0cd180c7, 0x342bb1300e1bbaa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x020e643d7c2009ee, 0x67f510db38aa8a64, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x301bcbce6739dfd2, 0x4e904e3824f00595, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x6d57f1bd03b72ce1, 0x4764624c4cedc3f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x0172a1b12fa4e79d, 0x3e727e2118dec86d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x21e100443af45486, 0x23ccc37a70860968, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x74f547d7395b8f40, 0x319e5955792297cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x227f4dc35b124ad4, 0x26e699a43296d38c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x67e3cb9b28a79f11, 0x40b28e362e2b2561, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x24c7a8ff3565fdfe, 0x66d5afc669f22fd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x1c9fddd1564697b9, 0x0ee2356d54e374cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x59fdc49a6043b6e6, 0x21d138c409f7cf8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x0fe89e8346a35b76, 0x22d697fc5b70664c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x0197affc7d94c90a, 0x4bf66fb431c99ec7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x36f0584a51d2d036, 0x2aec3692768cf7d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x2ce51b0a69d65996, 0x2923cb60596fa60d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x127df8a76e707b34, 0x079acb6e14c8e6a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x23d679330d9d4beb, 0x7ebb167e3745a1a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x63e3e3a52dfa4f38, 0x0c29167340765704, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x0e3e061e6d44be8e, 0x4a6e26923de1a83f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x33e81a0465487e40, 0x19520e8b1e26a4a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x62dd474a7adc79fb, 0x4ff04369357fca00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x4caf4a3255308d34, 0x2c0cc1d419cd9f94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x3f06e6ca7ad8110f, 0x733d45a17994653c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x69488c440d186260, 0x0e5d4be25184df71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x1ab5ae4b14f3978a, 0x08ca81170d1f0577, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #42", 0x42ede6c21803830d, 0x4d955c7b7e9991f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #42", 0x0548419c55cd48bb, 0x3c7b3a30512bece0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #42", 0x3b15c6fb3f42d4eb, 0x6f52918239305ba0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x3a1f4ee61abce775, 0x6eb025a11df30e45, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x6fed74a92afdf37a, 0x37c0add906ce9918, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x25d6048a0ec04a37, 0x0062fe552ef45b73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x1bd8ac970943bbfb, 0x00793ae40f1e90ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x1e37538569d2f2c0, 0x1c3d9645368e5ae2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x01d675cd71a32703, 0x3527ecd361253a48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x47706fbe21a3b8aa, 0x32512728071eb769, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x60e68d952eff38ab, 0x404f130a028636ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x49bc20205839f2d9, 0x207944ff1b05dc7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x0337e653223773e9, 0x21d4759439a994c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x30f7be2069172b20, 0x689df03c290deadd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x725ae71b546a11f0, 0x382c7bab4cd06ab7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x3e3d04b03886b26d, 0x035ec59a10923aa0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x2a29d97024089c11, 0x71b774e840137a7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x45ac54bb078144f1, 0x473231e7719a492e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x36807d9c1499c4e8, 0x74207fe82692e251, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x6cd3b7c1636d3461, 0x4198becd003c9dbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x05a4a84b228422c1, 0x39e63285700b9e14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x0b9b4de15146049d, 0x191988f2369c666b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x25b0168e06cb96bd, 0x036cd1237df634fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x3f52492a003fe485, 0x0e886f9d63ed1b3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x244880966b32c7a4, 0x240095bc697c229a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x72b40c954f36ebb1, 0x5b166bc869f4d552, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x63d0b09952207670, 0x1087b7a329348a32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x358daad163575a74, 0x297127ee50a4685a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x05db7d3559c98f60, 0x40b0066e3b32531c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x2b0f93fe753b8aab, 0x71ceb9881176cb17, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #55", 0x7c0721681df56fb0, 0x0f6d001350bfaa8c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #55", 0x1e35543658ad5b87, 0x34acc5ca3b596a92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #55", 0x43e0232b7febf8f4, 0x24d58d2c427dd4cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x4f22e4a53cfa61c1, 0x2c72aa1e36942fc0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x0f1ad8310939e1e1, 0x5fc8b9f232f3953e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x6c913c5544480407, 0x0397fd9844a88303, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x1e11936771a98fa7, 0x7fdad61f726cb98a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x66e51a52135084b5, 0x03e384a149212765, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x3145f4654e8d97bc, 0x19e0d1f162ec3bba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x273af343431b3378, 0x1e45a64c4f7b489b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x43072c6d3e6bc786, 0x11f91d686b1b166e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x7b66294801780021, 0x21af462e122a1112, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x0ab1e20248b5a3e9, 0x451da6510a810179, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x0cfda7f04f045a9c, 0x4f29847c77431e57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x40adea436d935c83, 0x69afd7e12b0f3b58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x00e3e1380e1134af, 0x743062bd27930496, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x5c9ecc6b28c4e69d, 0x0a7f40503229d59d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x6be01a15139e3ba1, 0x01a51e3903d9bfae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x520a032710a41c4a, 0x6ef4d61c2ee74682, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x121c1c6b062efde6, 0x411157954d702c6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x4ee4a1cf271ab265, 0x57f12de91ccdfe6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x761f0d017dc0f4a6, 0x14111cc45be249c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x6b5451297b21e7d5, 0x06f1851836ccf745, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x09331c8468df3c2b, 0x5e5ffbdb6c383261, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x11a422c820072637, 0x1e6207fe65d1e8ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x33a561d858a07eb9, 0x69aba89d7d843cde, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x69449b046d7cdaf5, 0x2c6b836005af6500, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x73abd8db2b10bf58, 0x531f916f7b60b76f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x522b71be2c3fd2a1, 0x182eb5dd42907aab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x2a00c74725644983, 0x1e72c46b484a7ebf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #60", 0x208631585d7771df, 0x7f17760415551870, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #60", 0x4656ae0b1fef52d0, 0x018d4ad129b94ddd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #60", 0x3ff679077936df6a, 0x0f8b36cc57fad0d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x51d75e2301ea9112, 0x557f0db1739bdae0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x6f676c074c6ad14f, 0x794b3fe03b1bf927, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x777b90a84eab6674, 0x367cb097631344e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x7aeb3915441683f9, 0x25a3bf8e49a70266, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x697acd7c1108f72a, 0x11f1812524ec005d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x6e8069093bce639f, 0x3a4118cd0a00fed4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x5bbdb66f4345837e, 0x33ba4cb134d71714, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x3c7c62e86250f599, 0x0cd1e7e81bb42f76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x643b86ab089b4a36, 0x0f500a560e53c10b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x55061b867fec6aca, 0x496fba3353a2f2b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x4e97d13e5c59f724, 0x36b637964c81ac2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x20707b1d281a2fb9, 0x1628ae9449830a53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x392326e328b0237e, 0x6e6f0ab009eb4899, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x647e871d47a6941f, 0x13ec476d27a38fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x0aec179d694c8ee9, 0x5c7aa701403c3d8c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x4b9d84836b407759, 0x5bf06d0247687a85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x73dbc18f1f2bf5c3, 0x55bc3b902fd90b2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x1f18608d3a323577, 0x037bfde148e1dd15, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x168c2c9b2b8c37d7, 0x156389436db031cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x53a6679125a246cf, 0x37333c1f36fca7b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x4e526a4d54d437bf, 0x40e7f0510cc98e74, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x1c7acbde10e7c563, 0x346d1e6132d0f16a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x7a34544c4efd9bf9, 0x730d2ef62766e37b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x3a3e1352448b9990, 0x6ecf5e0045d1d8cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x63b78f547926e1df, 0x75aae3fe2e19d4e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x335917570c5f3b3a, 0x76fbb1f702cfefe1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x37eb731227b35dcc, 0x708021ad49e543f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #61", 0x4d55a49b41c9dbfc, 0x00e1ebab0b91daa3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #61", 0x169e13bb4cc88779, 0x185b69171ba80ee9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #61", 0x5db04cdc41862f4a, 0x4e7900533318df99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x1083cb43494f2114, 0x5a7fc31457e4a128, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x0ddabaa513615df6, 0x1db679f84ac1de95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x0c883fd56fd7656d, 0x78dbb376719249f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x7c36a0a864e25b87, 0x746239da3fe1572c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x0c95b9530aa886ca, 0x09c69b1f342213ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x4c7262c6580f5774, 0x3fb3ee5d59eb5def, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x24d7deed440c6d2b, 0x75936cd863107682, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x05929c7570a91930, 0x1629561b02882bc9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x39f83a44782346ea, 0x5a6cccf2161667b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x0b84a4e059b3f9c4, 0x60d8464d47d2f4e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x498b5f312dc778bd, 0x39653ee2180ce4b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x12a9d44461b4d701, 0x57ee3be245c1ffd9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x6c5d5dcb399801f0, 0x79e413931f3f8d98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x11a759656ebe585f, 0x792aeb8738cfc091, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x32cac58a32098d2f, 0x1be03713367f3852, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x22b2a65f1374310e, 0x3907641c385d6200, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x0b9777f82f4c1006, 0x4e73c9b85caae0a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x090009ca5de3146f, 0x247dd58d171c1cd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x0baa8d2c07173d6f, 0x2f29018d528b68fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x68cc147012317c68, 0x184d68d51e546171, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x4bc97e5936beda90, 0x3d93ef095529723b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x257d32ef29d969e0, 0x0df932cd5d70d7be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x5be2f70f4cf7742c, 0x13f010105847f879, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x606ba53a5f192432, 0x10a55a797e959d6e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x0e6534387fbe539f, 0x5b407e126c031d32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x5da1680e32483b98, 0x031f3a0a17653e02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x395f7907023e0fd2, 0x69f0a6fd694bf53b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #62", 0x146f8c3b453445b5, 0x07a056ac222b8d78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #62", 0x7bf32045054e3280, 0x7754ffb360390a94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #62", 0x2f279c615199f262, 0x3da9e25221705334, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x1e91668f0a5da627, 0x79b84bad0b0a9370, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x6976ca5964e0aef1, 0x09a030df7efd0bc9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x649f02906e1f6306, 0x6b0028fc77dbfe91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x20679e9e7931e390, 0x0f413c9342406a9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x7b6ff363332cb685, 0x2b8c5fd959c717a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x7860fc3a7347a4d1, 0x7bf2a51e0fdf7f9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x7895d7522dc26c84, 0x70188a3274541c7f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x7f5c5ee60f7cbb61, 0x15c46fb327bd73b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x19da61883c683802, 0x32c807231dedc575, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x2148e6f307eafa3b, 0x1cead13f03512be1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x760a5d410a6e6705, 0x7b2d2a7205e7e983, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x03a04a9573b4b3fb, 0x482854221671fbe0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x26e16a816c2bb8a4, 0x703913867f103df8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x5f735d757f0847c8, 0x0eefbd961f4266bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x2ccab44c295af2ee, 0x1396833b580934c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x38d7ae4f328eaf9e, 0x7fc6a87a2c271333, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x6ef6e7a066ffa9e7, 0x4a14d8a852b20fd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x6eeaa4225130662a, 0x56033bb8103fce94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x5b9ecd2f5e500c39, 0x1627b81764f50164, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x5204c0356ba010ca, 0x7b66fd445f3f17c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x57cbc96e6d3f1354, 0x5e4f55bd78e62ab6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x6c475b1c2bbf14ac, 0x18289171373f26e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x551a079b0f0f0425, 0x0f485bab19120f69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x419db3c30f4dfb44, 0x4539229c0df1b5ea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x764da52c36a7017a, 0x60a3c5c230949b64, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x07d767a556fc220f, 0x40d469f86538494e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x354c2e49459447f6, 0x4a2d4ab2637634d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #62, #63", 0x313458c02104a257, 0x42b54c990750ee7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #62, #63", 0x0e43b5ab185faaa5, 0x003719340900222e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #62, #63", 0x441ebf524f87a4bd, 0x403f49127a8b10c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x5e96a8e258d642cc, 0x139d20301938c6ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x68243e1107ce4299, 0x272a7cd720345ca6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x3e754414119d6202, 0x50c8f80a5e71e33d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x689984110dd7773e, 0x43aa2c8b464cabb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x536bbf346c782d27, 0x29c2e08d1de5b25a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x0d7ccf7e256dba0c, 0x2536a0d804a017f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x3dcd64b24ddf8335, 0x0da03a231bc08529, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x1d6727f229e8b621, 0x164b95f001ec2404, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x02bef8ed424f67c8, 0x1b24eaf17bfdd0d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x4a1daa626cfb2585, 0x1c322d7b6ae336fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x7e9887870cff46c7, 0x49551a3b0892ee76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x1ad6be0578a27abc, 0x4edf9a2f67320b98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x651aa7e32a4e5ecb, 0x0517bdf36e427d39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x4fbc18d80082cf52, 0x72e2952e72977761, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x4e62528724a3927b, 0x0e57fc8a0d897d8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x4e8c489c2a9a8c7f, 0x0f75a18e6bc97a7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x6ce9f44703f978ca, 0x67c74b4f514b4189, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x70f49e4f058392c3, 0x3c2e788837079ea9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x1282d98a0e7a274e, 0x3f9a8d1f6f8d25d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x071ca20b5bd6ef61, 0x56bf316e2d59978f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x06254e2d0e7ea9f7, 0x1b9c14c96c3749ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x0f0179496d26bdda, 0x5ecec15055e16705, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x11ca505572e0861d, 0x636ae48f5d63cbd1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x1d7b129c30f4919a, 0x492d464b605698f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x34ee0a646dd05303, 0x31a1da7b0a6506e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x7353e5c6010732ac, 0x416ca58d25e2a8b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x0f8159fb6c2efff7, 0x156fce8905d6bf51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #0", 0x4805ef594ecc6ba9, 0x333056e0169dfc06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #0", 0x5d4b15a161a40744, 0x02d545f44e2b3d86, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #0", 0x4ecac51f0777891a, 0x240ca48b6c4c8eea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x7a580f3712dda106, 0x49b05abb60951574, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x43d232a0728d88e1, 0x40ebae6617d321d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x605ddbe463a4ce43, 0x223828b678c03d04, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x64ac00f03412b440, 0x1ea2e5b753b1c1aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x2041b4380cb8d7dc, 0x598880fb742d5aeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x5b8543850da09ce5, 0x0acb56f16847a391, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x6f44a42a5a7f85a2, 0x3672e11738d05926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x61f70ebc6ecd42cc, 0x251ce8113e0f6949, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x01aae3d35f902d23, 0x1ea47ebd5c4f1df3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x521db604165a687c, 0x74223fc6457d1673, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x79ff36c05ce0392f, 0x3e3d5378327b91e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x10f2ed705fb5d48e, 0x062d53935eab37b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x6c6eac6a5da3e98c, 0x52d8929b3134a1a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x6b4486714fef2650, 0x197c453947f3eff0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x2a6eabf225e13127, 0x00c449165a892a9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x14ae73f4373d12a2, 0x189893e40c65baae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x16cd3fc55cd71867, 0x68b4d8a1165957c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x733180e31a13c1b2, 0x5bd66e3a68eaf5ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x76f3fae22193db45, 0x1b6687b26d30b7a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x0149afd41eb481ee, 0x4bdbef5307e6e852, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x7c586b7a5297cf33, 0x391b89fa6db85c3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x2286f58336709545, 0x35ac4c2e679cf1ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x5c51c66c5abeb06c, 0x42261c874cf5a175, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x11fbc30e421034c4, 0x595b5c2371003a60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x1ee74d2b63300062, 0x0759922728c902d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x7d43c2142d1a8050, 0x11b3f89d1218ce0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x4eae5b954b257505, 0x7f4985b27437bcf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #1", 0x69d9f6f4353a2f42, 0x7c1ea5484ff80b69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #1", 0x07d1fe75735cb3d6, 0x3db067a86632626e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #1", 0x29cd491b0ff570e2, 0x4dcf545a2a58f3f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x6ab4214e50a9f190, 0x774e956d061f0f88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x12ba26547e78dc10, 0x771f49e87cafe45c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x61a8dc72372cdfcd, 0x2578e72f31a1737f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x6447601d4303c740, 0x43ba418e5eec9e86, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x0e293c454f4300c5, 0x53245b7d32f5bbb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x047d3008409e2ec4, 0x02edc71c78033339, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x33fae29a2c04ea02, 0x5e3595a80c4f2e7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x3bfa5ae42df6b7e3, 0x36a822765dc82bb6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x7ea0a9745b068526, 0x63e73b3e26ae7c32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x597f613648d747be, 0x235e608e115acfc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x0004278b06b684d6, 0x42fc43483b283da8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x49ba4c166d3937ac, 0x1a14dc2f644b87a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x3c7c38711a2f0a76, 0x1741435a57e3885b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x5acd393a2e1c513d, 0x4fe6bb9540f96879, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x5a213b3f03f0b96d, 0x4d4896f70ec81bd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x31e77150507782c9, 0x6c90478b161b9624, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x2b7e07ef602872e5, 0x3cca125630881ac4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x28ffbaa304df2dd5, 0x41e2ea8d04fd6926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x0b95b2ab5a3a82fd, 0x4025a6ce2903e22e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x4773baa92490ad30, 0x0d4f69d6554ffec1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x3ebfb7a77d1a42b1, 0x2d33871c03eff31b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x2b3693ee1231f28b, 0x44e95b94198cf0e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x1622abf814e55441, 0x28550cb60557cf2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x655cd70a583d77a8, 0x1b736552480a1d49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x3865ea8d3a75229a, 0x7892380d10dadefa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x3f54506f55fdeeee, 0x15d848206165a530, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x303871ec17b8f134, 0x0a69875e4aea031a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #2", 0x3c499e654d6d88f8, 0x203a01db77ac2c95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #2", 0x4a87cba940857b45, 0x7b9c1fb07b09560c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #2", 0x52b76dd03ceb53a4, 0x149646ed75be5f98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x51d0a7e516899418, 0x7b162ec668da19c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x6ec70bc029766f1f, 0x30e43712372d7ef0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x63eb91ba5de0a60a, 0x48085dea272cf64e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x33de94f812fc22dd, 0x08929b7e233fe229, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x2ab514110e63e71f, 0x6e29e544641706e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x5bd17017575f532a, 0x5bc3337a66feb276, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x17e4ce6f769e4f70, 0x6208088226593bc1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x3389a314172dca1f, 0x1c179b596a9c3c40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x2db75e37045a8d1b, 0x53765609055a4af9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x2dd0fc3a049027d3, 0x3c87c9e91c7e69f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x6270cddd4c3dfbc4, 0x43ab604511bc8df4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x5f3a1ea123265562, 0x34fc701e164f62d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x318a3c8156299d34, 0x7a6669ba09ef32b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x2d88f05f52f5edab, 0x70ede5290d5bac99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x49943d1b4fcc83b3, 0x33b4e85a456dbece, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x66fa4dd203805117, 0x3009fb0e7d1de02f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x07dade323efff512, 0x02782b2914b1ac09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x43901ce674db7646, 0x3130160035abda6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x4119720a7c64d87f, 0x476868612600eac3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x1f8b2de136b6b754, 0x3c504d99205390ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x0ce054881b30a886, 0x2a42c35d51156a63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x6e2696321225ff56, 0x5e7116fc3a6944e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x61f283092fe0fec4, 0x7fd703b637bad34d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x33614fdc3750dea6, 0x34d8b37d48ecd0db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x7650d3b80ece92e4, 0x5d9e7ce43b3c2e0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x03aa092a385070dd, 0x70e8087b39e0f09e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x34b5495c1c3228fb, 0x5fe1db6244c37b34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #3", 0x52e8e04f0f59cf3d, 0x65170bdf5440773e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #3", 0x2a8a77c303c6f89d, 0x2555e1a15fc934d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #3", 0x15ecf7f31a097d75, 0x1a3279bf18b10df5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x49ea7c3a054494c0, 0x506be14377df7afc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x3c9573661e6ac8bb, 0x40cc4bd77d4bcc16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x2d395b9f297002a0, 0x3887fa2432e6471e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x61c0737d4ca9131f, 0x6cc737bd30e364ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x68db3c1a5abdebde, 0x75a6dffe1675bcd9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x6a17bb1b100c15b8, 0x6ab634173bc41c6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x13d30e5535bfcb01, 0x1b8d514214a232de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x4fc948777dbf2217, 0x2d5340d429c00648, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x0303b6d7626bcd1b, 0x219f814419b3c4b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x00d695d64f878aeb, 0x16ff90c73f992a3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x78f78d8b5f46a918, 0x727f715b2e0ff176, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x2befbc37549a363e, 0x5ef356405ab80108, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x2f58221c5be3f1f9, 0x712dbde214caf852, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x6bf007b26c1c65fe, 0x508f14bc196fdd37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x21dc30ff5b6550ea, 0x2e1210167fc31607, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x592473014b229d94, 0x29831c5071a57976, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x2d8e6ab02258ceee, 0x0b593e275c2829d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x71e059da0e40c570, 0x1bc154152e650086, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x6d876e893b68483c, 0x5c74f1fc6ad7e765, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x10027e7b36bda650, 0x458fe86e19772ac0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x12a198497ed137ce, 0x2e4223123f5aa097, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x6aed9dcc06dc8de5, 0x58ca7dcf7e919ffb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x6241decf27d7d253, 0x7e54b6030cc9cecc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x72fa6fe709c8866a, 0x7e6f48423b6651d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x2c215558334fcfbd, 0x178e7ba82088da97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x4190952d2b62cd1a, 0x4eeddb1e1e01af32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x66cb15574e697f06, 0x08d996982f1803b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #16", 0x0527255676d15189, 0x488f2e7776cd93d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #16", 0x75a289580ef2b238, 0x3628346917c8bd9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #16", 0x15cf401d14af139e, 0x165a5d9b60902724, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x3c86e5f16bc93e33, 0x6d59f5f078111eec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x7591c49d4b05ec64, 0x337770bc2f8155d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x7e55bc211ef80b8e, 0x500a307021b319f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x4a5ad8a8488e5fc0, 0x3fb4c9283fe6514f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x16f7dec6378d837c, 0x6efe55053125edff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x2e5ed5065e1bb63b, 0x27f381d11c1f041c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x6d0e68734a421f56, 0x33e7c1bb24015e5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x5ef132f471eb7b73, 0x0491858202dda891, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x5db4b9a62e66383a, 0x7aeec77d1b7818e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x796c249e1b039f2e, 0x4af96ebe53467e43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x39fbaabc34ae6160, 0x74f9983877c1e0c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x7d3cc12026a68714, 0x37a8320f04568364, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x5e340a915d6ff335, 0x357c716414349fe6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x3b8ba970643b65be, 0x3053a4020c92df97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x2e7d85143525c377, 0x30943df5289a11e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x27113eea266681f2, 0x2b77ba750d6eb809, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x54ccba2c73e03fac, 0x28e6d0ee04c5f890, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x0ee3deda4d060f0c, 0x580c76d34e38decb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x01b4706c7da2f19a, 0x45fabf8b48df8996, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x244978ae02b27e5f, 0x4d360cfb7ef1318d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x6022719443797576, 0x1325d173027d833f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x27b4db343fa4a0cb, 0x0f1062d61bae1b05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x74ca64436fbfe75e, 0x44482ce956326048, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x162669500c87e940, 0x63a118511bdba32d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x006828ec78ae1291, 0x20a19bbe6af3237d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x45b4219d7f26c1d3, 0x392c02480f4c07c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x7cc9b36d25619e58, 0x582b915d4768920a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #29", 0x28141cb7597f950a, 0x4659c39721132c1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #29", 0x1cf90a8032a11231, 0x2390af5b08368e4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #29", 0x7245b2fd682cd63a, 0x23e4a95144ade5b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x57ecbd987e815e4e, 0x1ae045fd67101740, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x0b09478e238d562b, 0x02ebba6d6e1326e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x1c3b68bd12324cad, 0x59064a650b71707b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x11590e8072e9099f, 0x1abd784261ef8a5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x184aa7f86fb1dffb, 0x29581c640e22c1ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x4931750652c69d64, 0x2f35ee09405ec4af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x0567af956c79fc4c, 0x489552fb662a7f86, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x54a6d28645b8ab38, 0x2ad8653b77ad6292, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x443a098661a93440, 0x5ebd79d22c93901e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x05368a6b73ad016c, 0x1aa6b7074f435115, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x05df4e1a757239d2, 0x5ab4c1902171f328, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x685b43712cb999e7, 0x03617d8317385c9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x1c6b79e354910c91, 0x255b1e8800a5eb69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x2757a9f5099a0314, 0x4104b019659ceee9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x7613ff61769fd3aa, 0x4bc76e6f2cbf598a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x3c587ee2032a35ef, 0x246cbc1d4abad1e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x64d36a2f11f5190d, 0x774e620600928869, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x05a21a792a8a9b0e, 0x4fd5d97e6a09f49b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x1ffcd4e00edd6546, 0x0b7be7c30b816893, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x3b96ff2e4814e3b6, 0x22b9c52e08581851, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x1ca5f0474a02b3d4, 0x08fe03bb58027911, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x539cb6e80966d669, 0x3d9f67fa43fd9a3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x0006aa141529afe3, 0x70bcf3c649b0b649, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x1853e5d30bb9ea37, 0x146b88313c5f28f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x1daf03440cc78add, 0x3cf1b15f7d275002, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x375225eb72ad2c61, 0x6731449d23511dbd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x018a91a7518c4b7f, 0x2ed28651574efacb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #42", 0x19a12f3568a516d8, 0x5fa7131d3d2190d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #42", 0x32a7caac52c371e0, 0x152409e636471f7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #42", 0x5c2a484a6b01ad7e, 0x7a44b9b806448194, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x002b5d626460c00f, 0x4ff537de5c30f25e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x701aaa465581ccb4, 0x18901b54187f4335, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x624957917cd7d7d5, 0x15a693370dc9ad8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x6f8504365fed5198, 0x311acb47199b7d7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x31799d1750918b65, 0x70ea7848710f95dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x3936a23d43553099, 0x2e3126b34b1acc4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x1618a27a7ba6a580, 0x0161ebc86bde6ce9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x66a852ff4218265c, 0x7222ee7e7242eac4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x2678e66b6703f876, 0x4e73dd2266d3b061, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x3c85c52a14f986cd, 0x7f52f396169390b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x11d15ea255780982, 0x245d3e3b1ecf1cbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x35655b1b29551281, 0x386a9a39015662d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x79e69de720971f69, 0x7265f8b666def832, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x63ec5002335bb047, 0x31f9c47f331d4024, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x2f0255c8111e9b8c, 0x1efbad0e7a04f27c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x5336c1e83abbba62, 0x6c47dd4015aaa8c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x21bfb2d97bd14cbe, 0x7c7e592879afa853, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x10cad38b34a0773f, 0x104339045e457803, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x0a1880c1357f2ef8, 0x7d1494bf229c322e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x5ed4417a16588dbc, 0x23f295063f7ddbdc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x36efad255856988e, 0x265cd40f58badf61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x0bb248d52ad3cc93, 0x0bd81f851adbfd28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x3bf2681f0128cce5, 0x14e0efa43ab49e9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x3be487474cdda08c, 0x505f47640f292a07, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x48aeed4a191c0b5e, 0x08d8d25a5da43a20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x4dbc829d38fe46e3, 0x3be9b2245979c0d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x6e7d75dc2008880a, 0x7c15f30457d5035f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #55", 0x366115c73dafb34a, 0x1752df3b4d51b756, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #55", 0x16064bd831e4b63c, 0x260c96b76d50c2ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #55", 0x5cb882d01d0dafb9, 0x082cc01421b894ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x1e367c9e2ccc7ab0, 0x5c6d334b18aaeaef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x79aa1b3c30ace751, 0x27d414f75a1b03e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x49c8f2b073a8f02a, 0x37bf3e0642590887, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x2ca7370d17e8bc61, 0x1bd2c95d1785754d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x37f1446b06ad57e8, 0x6f5a78ac1b24ace9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x445d0b320e82faf6, 0x6876643f6e525a32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x4067b13363cfdd33, 0x5ba31d1f5a63570b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x00dd8cec58891f04, 0x7c1bebb91d203403, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x055599b45d9f33e9, 0x35cb1ef21f14098a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x0e4c1b3b30ee4b76, 0x792f0d707effb4f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x24973ba05d2b86d5, 0x4158bd7858150deb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x751443365ef4fbe5, 0x6f9a8338513e72ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x65a253cd54d983d6, 0x6c631f972d0587a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x635c7ecd76fafef3, 0x1b57e1d429ff5eff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x5acadc26007ea1c3, 0x0462b60a23c43000, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x5907c0c876af82f5, 0x40e464035ba86913, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x544eb6df73eb800d, 0x7abc729d5e5d5a7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x24d9cb831eb5cce5, 0x5d5d0f6d629ad21a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x7be153ba2a4a633d, 0x3aafe00549710723, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x093f5f2207129968, 0x1aaf79d170f596f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x5bec1d3e39530066, 0x1dfb1e926ee1b2ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x304dff591d43c7f9, 0x18e111ef3f489c0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x1dc269bd23f1300e, 0x630ccc0b0b18db7f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x1aa0b304617db730, 0x66c1449276ca2a85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x5569373d3284946f, 0x552785016eef69e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x513a61540c3a1c02, 0x518a3bfd7a4302c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x36847f3f5e6383b5, 0x43b409e44d1bb50f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #60", 0x65761d1d5c0c6a91, 0x3e114bff3fc3de62, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #60", 0x155f6af74786a340, 0x2ea5915141623a5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #60", 0x64ca6b3a63b7a273, 0x00aad66745ad6a50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x07a8d28137878a62, 0x50c645d0028cd4f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x190541924e7e847d, 0x7956ff7c22498585, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x010318ec62c32b65, 0x1138ef686e6e78d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x6efd47672c658575, 0x68b17b91523d7a41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x0ac9092b5d6a7b4f, 0x1f592f502581c6a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x3976e5e113eb365a, 0x6545a509703f2648, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x5b71d99b324c370c, 0x31a160a44ed650d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x1603d97f654a00f9, 0x1483bb29403c44d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x1cd18b5b3c201948, 0x42c919cc1dacac00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x0a9e9dc5512f20ee, 0x3ff6318635d6ccee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x33f24c540cf6c14f, 0x244545be0ba1b6b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x395c46c47d386043, 0x5ddf30f322ef93bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x5aa2db922db6ff6b, 0x48715a6244254fef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x41a235c66605d6dc, 0x346476381419c173, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x18520de87773cd75, 0x62f0124c1d140f61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x5cbdce6e20196e02, 0x5d5054362e55e767, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x5c39874a0bf8c4ee, 0x4c029368798f59c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x5d27e5dc53ab6c75, 0x2f6626b766d8250f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x60a22dc450590cb4, 0x7279dbc1111a3230, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x4d916cf77c7b204e, 0x3409c5ec19fe7489, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x2a321fba12883ab0, 0x5e23c4782834488a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x788e118d1f3e1c49, 0x3c4e09fd6bd45580, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x16b1e9be6638b917, 0x08e864e110e01f75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x065227190b389a45, 0x3f3606dd736fb82c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x17315f331c6538ad, 0x6cff11f6628bae63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x7010a5233bddaf34, 0x4963d3727459450f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x0c36bbe8397d3d2c, 0x0573774050b2d2e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #61", 0x35f85d7a48d50be9, 0x6ab1477059c828e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #61", 0x5b5d46993e4a7b67, 0x01fc716a602a7d34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #61", 0x5d8897b154e73795, 0x4bfed2b453eb5826, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x3b1ff0ac24017e79, 0x64cb779c743a816f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x2f3a18be54a94b92, 0x67aa399c417217c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x710e843f6d61999b, 0x23fdc628466b77f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x293f48cf40383440, 0x3ac4bd00611f2962, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x79b5716c1c8343ba, 0x31d1fc4a357604b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x65584fa3113a9f01, 0x0f3e2d972fadcee7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x4f851a695bd71ed0, 0x0fd84c1b40b5963d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x30be5665796c65ff, 0x14a0ee632d0db21a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x1d6de47808f26d25, 0x214833896bde4712, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x5d9bb8b7514e2500, 0x2d505ed74ca7fd36, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x3eafbe9b4dd83228, 0x131375274eaa3cf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x0e106668619b62a3, 0x2fc9665967ef076a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x7e1ea65e2ca339b9, 0x1d650c2107c5d7d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x3dddd8ba474bf2d7, 0x3773a6bc6376f601, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x232311a738cd7aa2, 0x242c8c3e0d62f323, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x3239e0a15bb8d8c7, 0x3a70a53d53e1680d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x64ab45ec6d100df6, 0x3fbfaf1f4fa7c51a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x3e5e32f62f633778, 0x1c4fc2504246fea4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x7d3b69a040baa1f4, 0x10f13b9b7d0df191, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x225604980262051d, 0x64fcf8fb0b4bd008, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x2f053ed64a854e99, 0x1311a7dd2074aaf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x11d1417128182d36, 0x03eba0f76ce31790, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x60e5a7d834b6aff1, 0x7a460ab434f45318, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x106f88b848956a44, 0x08d5bb25131f8879, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x35a5783b7f170fe4, 0x62c74d93751acea5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x2e7a475c485308e4, 0x3761cd497403ab31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x090daad8560e95be, 0x71119cc32bb5b0fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #62", 0x58709adb4a1328e2, 0x370181042b63af70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #62", 0x1498777b4fc3fb5e, 0x4bd85a660775d9b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #62", 0x77dc28946e9efbf6, 0x7458f1422669b8ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x2355abe76433c72a, 0x5b5e0c0558c1d06c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x2cc9316f4ea8a679, 0x6be158e533c534a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x4dbfb65d6041d08e, 0x28e00345626ea9aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x2894d9724783f19e, 0x567254db7c39fdb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x1d92875d5ef12fb9, 0x27efaeb531a2844a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x2904589b28de8e21, 0x5d0633bb76032238, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x78a2897f71d1ed2c, 0x7d78fbea3d9cd017, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x6070e9223f649508, 0x64068903707eb213, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x23985c333521db65, 0x4940827f03c69509, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x03ca81de606bccee, 0x378bc9a950618da2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x40ad9d7c09428c27, 0x32d0374c518a383b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x50c67dc675b3e4a9, 0x4dc435f4694276ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x54a5146277eb2ef4, 0x1ae4fb396e590523, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x20c9bd1561d52345, 0x645c275b7da96cfe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x53a710711f4cc618, 0x3b463d15196c4695, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x5eb15b21532b7b28, 0x09eaf8a83417f993, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x084d568d6f6a5846, 0x37de8e9d0249b754, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x4fd62535057b7c42, 0x52ab44f60c17d86b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x0ebe08692b66469a, 0x5da210a61083c2b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x211a2b4314ab34d9, 0x79c639a05f84862f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x0c9663cd3239b2ae, 0x4ddd8b5275bf3fa5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x140ed5f32eaee9b8, 0x7368aca32d6020e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x4dfbafd150b76020, 0x46cc677767b5e665, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x23e2db4853ac6e95, 0x1bcddff82cad0af2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x4316c6dc01a2073c, 0x2ef6c2462c3031d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x071d837e15ea1ae6, 0x38480a4012ecec11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x415061801d36e862, 0x2370aec215db8be7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm x3, x4, #63, #63", 0x31e21d3b433d9d69, 0x75601217626a8cc3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm x3, x4, #63, #63", 0x757750174b92790c, 0x5829cc683e788108, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm x3, x4, #63, #63", 0x7a4162c432a50962, 0x6bd8a1eb0986260b, x3, x4, x5, 0);


////////////////////////////////////////////////////////////////
printf("UBFM(32)\n");
printf("SBFM(32)\n");
printf("BFM(32)\n");

TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x643c986966334873, 0x6b8b4567327b23c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x2ae8944a625558ec, 0x74b0dc5119495cff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x3d1b58ba507ed7ab, 0x238e1f2946e87ccd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x79e2a9e37545e146, 0x2eb141f241b71efb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x122008544db127f8, 0x515f007c5bd062c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x1190cde766ef438d, 0x0216231b1f16e9e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x109cf92e0ded7263, 0x140e0f763352255a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x41a7c4c96b68079a, 0x7fdcc2331befd79f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x519b500d431bd7b7, 0x4e6afb6625e45d32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x257130a362bbd95a, 0x3f2dba317c83e458, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x333ab105721da317, 0x436c6125628c895d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x6763845e75a2a8d4, 0x2443a8582d1d5ae9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x4353d0cd0b03e0c6, 0x08edbdab79838cb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x71f324542ca88611, 0x189a769b54e49eb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x3a95f87408138641, 0x0836c40e02901d82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x737b8ddc6ceaf087, 0x1e7ff5217c3dbd3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x3006c83e614fd4a1, 0x22221a704516dde9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x440badfc05072367, 0x419ac2415577f8e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x7724c67e5c482a97, 0x3804823e77465f01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x51ead36b2d517796, 0x2463b9ea5e884adc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x3855585c70a64e2a, 0x580bd78f153ea438, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x1d4ed43b725a06fb, 0x6a2342ec2a487cb0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x7a6d8d3c4b588f54, 0x2cd89a3257e4ccaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x38437fdb7644a45c, 0x542289ec6de91b18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x579478fe749abb43, 0x32fff902684a481a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x79a1deaa75c6c33a, 0x3dc240fb1ba026fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x520eedd1374a3fe6, 0x12e685fb70c6a529, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #0", 0x649bb77c275ac794, 0x4f4ef00523f9c13c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #0", 0x180115be235ba861, 0x393865751cf10fd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #0", 0x15b5af5c741226bb, 0x47398c89354fe9f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x3f6ab60f61574095, 0x0d34b6a810233c99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x579be4f1310c50b3, 0x7e0c57b177ae35eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x25a70bf71dbabf00, 0x5ff87e052f305def, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x1381823a5db70ae5, 0x4ad084e91f48eaa1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x15014acb5f5e7fd0, 0x100f8fca6590700b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x06b9476442c296bd, 0x098a3148799d0247, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x661e3f1e5dc79ea8, 0x168e121f1eba5d23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x51d9c564613efdc5, 0x540a471c7bd3ee7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x42963e5a0a0382c5, 0x0bf72b1411447b73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x3b0fd37968eb2f63, 0x08f2b15e1a32234b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x06a5ee6414330624, 0x4962813b60b6df70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x71ea1109100f59dc, 0x7fffca111a27709e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x6f6dd9ac094211f2, 0x7fb7e0aa06eb5bd4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x4c04a8af1716703b, 0x00885e1b76272110, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x74de0ee368ebc550, 0x14e17e333222e7cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x4a2ac31539ee015c, 0x2df6d64846b7d447, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x43f1842260ef0119, 0x57fc4fbb0cc1016f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x49da307d7055a5f5, 0x26f324ba7f01579b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x0488ac1a5fb8011c, 0x5fb8370b50801ee1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x6fc75af86a5f7029, 0x6aa78f7f7672bd23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x73a1821b7de67713, 0x7d5e18f85f3534a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x14fce74e6a3dd3e8, 0x555c55b53fa62aca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x532999381fbfe8e0, 0x71c9129809daf632, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x59adea3d288f1a34, 0x5092ca791d545c4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x097e1b4e51088277, 0x2a155dbc1d9f6e5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x415e286c7c58fd05, 0x1ca0c5fa53584bcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x5c10fe210e7ffa2b, 0x23d86aac45e6d486, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #1", 0x78df6a5539b7aaa2, 0x3c5991aa4bd8591a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #1", 0x379e21b50069e373, 0x2b0d8dbe6c80ec70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #1", 0x6aa7b75c1df029d3, 0x2c27173b4c9b0904, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x3db012b32708c9af, 0x5675ff363dd15094, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x4f97e3e4053b0a9e, 0x5b25ace2175dfcf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x56438d15519e3149, 0x34fd6b4f5915ff32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x4df72e4e5046b5a9, 0x2c6e4afd17a1b582, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x5ec6afd419e21bb2, 0x5d888a082a082c70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x5399c65420ee1348, 0x75e0858a57a61a29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x2157f6bc704e1dd5, 0x4427069a0b37e80a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x0e3e47a82e48f044, 0x57d2f10e0bffae18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x5551b9f324f6ab8e, 0x49d0feac4bee5a5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x2a31b62d1849c29b, 0x634c574c24e99dd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x69e7f3e52a6de806, 0x7dff9d0900754342, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x7ab49daf759f82cd, 0x1816f8c437df2233, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x0f819e7f57c7d42d, 0x61e74ea3597b4d84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x78b5e77675486e47, 0x312167ad631b64d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x65968c1c46263dec, 0x6e534cde1a0dde32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x746f2e306fde8af6, 0x260d8c4a73d4d3c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x14d53685230f856c, 0x3fc32e2049c0e823, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x3b5948076caa2304, 0x6eaa85fb3f06ecb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x17180b0b579328b9, 0x3f7c2ff425413bec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x4d32ab863f07acc3, 0x5d205e2011cca8ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x16cf80f11c695dec, 0x6b47f63e5cb44a05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x11b1cc332e22fbb7, 0x3fcfaed90f856867, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x744939a34fa0d2e3, 0x2993469977485850, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x3f7f5dd92ae05a34, 0x6b1d2c1468b867d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x4defdfa02123d5f2, 0x32794ff75454945e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x0dcdf8f652d7b105, 0x135b8110094927a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x2a6ad9be0baac1b4, 0x2e8a639424e60401, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #2", 0x4ab26e7821faa2fa, 0x36b2acbc779d8544, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #2", 0x3e6400e614217e23, 0x5451cf496181ef69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #2", 0x424479da1a9a9e69, 0x710757d05015cd1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x6a3b714c327b517e, 0x475e256a368db37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x5d5babb351bf6b48, 0x1f461b5129bacf25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x72e3413a116ae494, 0x7e0f63842b4b8b53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x64429599631f1690, 0x3494b2fb00b13a31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x6ec9d8445c49eaee, 0x25973e320ead6f57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x7e448de95a9cc3e5, 0x064af49b397c46bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x6ebe42080c058df5, 0x1afe36253ca88ecf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x26a02c5e541c8153, 0x0cbe5be93102bbe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x0697d2d206d68ab2, 0x67906f6010db9daa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x5895f5fa38a5d054, 0x3a966cd063f37e85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x4a10b4e843d3bcd4, 0x0f3f09d84b793735, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x26f2d36471c1af98, 0x4c2a71662e534a82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x4e0b9a87434bae75, 0x3d00b9d915bcaba8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x1de8725a6a37288a, 0x4f38f2654c502870, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x763cb68015b71329, 0x08f8b73f0ca6b462, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x69d3947c2539dfa5, 0x3da970441cdce2de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x2c106a57684eed59, 0x2db88089706b674e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x20f4bdad639defac, 0x545ee5d304a66051, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x2771ac801c4a08ec, 0x501f97866b057295, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x0e0bb885565976f1, 0x1958bd174e647fe4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x19a52566335a1df1, 0x64212b8c5c17530c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x1d91467c316032bb, 0x28677b7c378d97c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x471745e401ddbc66, 0x44344c2213cdfcfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x27179c0b5e636063, 0x30aadfda30eada61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x46b24dbc75b52783, 0x215641af53280662, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x5953172f27edfe3a, 0x57ce66b467a70b69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x443807276c053b16, 0x52ac7dff00c4c3af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #3", 0x425eb207334a6f1f, 0x4f2943935243bfac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #3", 0x66a48d1156c28e34, 0x2e5b12b85c03d76d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #3", 0x0822c0ef57c5bb4f, 0x13916f2d0435d38d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x59a377b648aeb063, 0x1803d0894f3a06d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x271210c7217b22e4, 0x0024e13500bb13c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x17304a672bb180d8, 0x53e31a246dc45e83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x539f7f122817e7ec, 0x556b69ed70836196, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x141d2302407168d8, 0x7148254517d78639, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x73bbd7f81876589d, 0x6a1b45e5567bd50a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x6f38e6d146111ba5, 0x327fac775a606509, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x1dd6d6f4769a091f, 0x5e963896775ba7c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x3f48b98246ba8fca, 0x4695ae95777a4eaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x6835b2ae4c187c90, 0x7835626c665aca49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x77c9fd68298a92ba, 0x541f28cd7f65fd16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x51a27aa6613183f2, 0x6fe95eac4b697c7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x21a2ecca4d5c4899, 0x634102b465bf9da8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x65d2a1376ebb1f2a, 0x3c3b72b2155ec4c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x34cc3acf4e556261, 0x6fbf29cb550b8808, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x44ef6b8012fcde5e, 0x4c672fc952a311c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x59b76e284252c2da, 0x4a1d606e04382503, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x0e6b3f6a3eb21819, 0x6a92ef4c41ed20d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x683caad3313c7c99, 0x41531ded06353cd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x126e008b34dfbc00, 0x519eb94c39df2579, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x023c049a5bda35d4, 0x1f9ec3223410ed56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x4a9554fe392edbe4, 0x496fb218680ea5d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x07843e4509815da3, 0x3d1a2dd97f618fcd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x1c7e3c011c2201ff, 0x5204a1914c73a9c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x5e74c4d93b3ebe15, 0x50abcec97635aa2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x79f0d62f7975e8ee, 0x3822cb016ce00443, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x2ab2658744b3fa61, 0x73154115622d8102, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #10", 0x7993b6623bab699e, 0x1c0ca67c3d206613, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #10", 0x17859f723aa10581, 0x713153697bcfbafc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #10", 0x73cfe16520f88ea6, 0x63de60cd621af471, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x2a79ec49338125cf, 0x617c843e7b541fab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x4fa327ce1873983a, 0x47c7c97146f8284b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x53b2564f75509d76, 0x3d2dd2752e17eca7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x6ec686640e0d31ff, 0x1af7f0ea4da32c7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x52c12c614bdd53fd, 0x2fd0ad811978ebeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x0788bd9b47caa567, 0x569951fe4c54e2c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x026baae92c02fe8c, 0x48249dbf1f0e5d0d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x4cfb8d3262a5d5bd, 0x0129517e763b8c4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x1626fb8c3957756a, 0x718fabf97775797c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x51cb0da47b9b743c, 0x3e6da1c765ca235b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x70ec11b22eda00ed, 0x13e21002257d63f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x3ce732ec22f13df3, 0x732090725fb29816, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x6ece91f04fc4d600, 0x792b84010fa85f4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x178f7b672421dfcf, 0x5bfd421076574f8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x5024de5b168efe17, 0x1565ac9919fb2650, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x7934d3d401c65e98, 0x1036b29f1d206b8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x3b1dd403530386d1, 0x1495e50a0f5bcf61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x4e9efb0d090802be, 0x7525f2bc0ce8e1a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x37e203ab2586d60e, 0x3266459b3f8b0cbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x48781401186928d6, 0x1f3da4d574c93698, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x682dfed6606ed7f6, 0x047195e53746a5f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x0490b7c54303a216, 0x2d9df57d7fbd7a3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x5992a02e29ef532d, 0x19b8a08e54b59621, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x2bb5b1c6066be6b9, 0x71d601af52c77402, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x596f6d8a5749361f, 0x6223436366d385c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x605138de2622ad0c, 0x73bc6770280e6897, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x4ba9831a06d71a2b, 0x6799755618333c89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #17", 0x1f404301116e0907, 0x0cfc73211421971b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #17", 0x71dce0fd7906328b, 0x4b683d0d076e41d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #17", 0x3c09d4a120e45ca4, 0x072bbc16766d98c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x4ad3afd23cf93092, 0x4b232ee3159c74cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x4365174b4a872c35, 0x6863e8d276896198, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x21d0625551194ed1, 0x5d5ce7611cd484d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x773bfbdd2c7c62c2, 0x44e2ed6c02219b33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x33537ced27514ade, 0x1a54d7bc42e57ef7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x38bf53e5226f5320, 0x570716135293bfef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x1b7585ab612dbddd, 0x5a0201c72a9c34e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x02121a816c2cfc88, 0x2109cda4577f5a4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x29262d1a557fb7ee, 0x6d1bcf1c4ce5ca53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x2006e42420cc134c, 0x436f2beb6c8b4466, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x71e5621e4e42b6a8, 0x095fc93b41d74679, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x7abf196a5e4db968, 0x43f8e1ac69215dfb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x059f0446030df306, 0x2c06dcf32e129658, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x257d46265aa8580e, 0x00a656473e5e582b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x3bd615eb0a045ab2, 0x68fa8d0d40f2cbd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x7631573a058df53b, 0x1872261f3de8306c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x5b0dad2a4e3d26ab, 0x0acdfac01f578454, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x6f0939f8154291f6, 0x0be2c8ba7b14914e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x6385489e00e4b973, 0x3cebd7c760ee9c16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x5f3272db7616d704, 0x4a0ffa115e446208, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x7924ca0a0cfd4ea7, 0x0c56f86064d17722, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x67a5a6b50c2a5c5b, 0x232fcf4d1ea21031, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x162eb70d78070222, 0x5f94dc03237bbca0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x7d94f75d6c31e7cd, 0x6163ed0d0c600e47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x3a6f0e78379a5b56, 0x2bb7929b58a2a487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x4cdced4c10a30d9c, 0x53b735d529784870, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x1187c70f5476de98, 0x0a66e486306235ea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #24", 0x4a8db59c1afd9053, 0x0ea697f270ba39eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #24", 0x27fadefa78bb805a, 0x558bb10d43b27fa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #24", 0x04e5dcb541e96bdb, 0x62548fd80fa085b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x39f06dfd14802f5d, 0x331c42501b1493c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x00b2172a532c34a5, 0x2774a2093785655a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x0ac68ffb63df3fb7, 0x102809e23b2125a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x74824d546f00529a, 0x64996e1357a37d47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x4377313216ac4b23, 0x0805b331060a1463, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x31a9db764c4fff5b, 0x76c44e4e0e04e6ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x450b7fb6340bf64d, 0x51b7667559a4ba71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x75f562281c618271, 0x6945402149f15c6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x30e1b1cf0c7a9237, 0x6505f02e2fe5d025, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x5fa6c6dc77933f62, 0x676b35803193c8f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x5b727f19514e5cb0, 0x6cb4ee9c6a6d56d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x404eaf4a4a16874f, 0x4210d41e4ff4cc6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x60c2d2734cc32f1f, 0x55fee0d103c5e07c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x19132e7b63822dc0, 0x11cac74a126cade9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x178e240d5556a87b, 0x6c11685a5e1eae31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x71b82aed0d15faca, 0x28100a9c0d838636, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x19908d0224d48bdb, 0x3d69565b2299dcbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x1c67cb3d40e29452, 0x542da5b5793753de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x1230f10225b57ed4, 0x63a4aab677da4a57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x6fcc06241dcdf795, 0x47cf16c4527fa04c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x6a9126b568104812, 0x564580c8508ed897, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x4b9275d24f0ceedb, 0x62fb868003a45530, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x2463975609d30dfd, 0x61c30361632099e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x16e908c82e0d7671, 0x70a42016161bc243, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x52e2024d0ce344b5, 0x38b59eff307995ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x4dc5d9070d55945e, 0x29b0e9a86f49cd8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x330b13332ef32ea6, 0x672417e15ff6ca09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #28", 0x4cc1263b08bbeb1d, 0x32766a5522d71957, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #28", 0x70cc332f5661786e, 0x7365f1ee37524cf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #28", 0x256e67491cb9a581, 0x3af6a2203c5ea902, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x268cb37f102362f8, 0x1f7f42e249d1fea0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x3e30d96918a35fe3, 0x5fedc0e33d75bc47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x2586a49817a03bb9, 0x6def52111112dbb6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x24f5d0186780c122, 0x005ca941734c7d9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x1673efc805b9b1fd, 0x534347a85800e34b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x0e759d1a6e3dee90, 0x7ad7fca263351604, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x449f66fe557e0515, 0x1a8762f47f41d049, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x7237aa965b1fbc2d, 0x3ba0794b6a0dce48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x6b431f2513cd8dcb, 0x33dfcce818c45e15, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x2c70edae44296c6d, 0x563a1a5c2973f88f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x5bc9a8273ae37d86, 0x3a86d44551f79246, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x22643ea91887578d, 0x45440fe500bf783f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x1e41098a5398582c, 0x58c05b8a38d82e71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x41d646bc3694a76a, 0x1c0d44752cb6a6a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x0c12ac7f6798f039, 0x2bf876ee0675adba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x42b8ac67246348ea, 0x70837c027e4a5715, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x3830d6b66d48cf87, 0x170eb52b2dfbcb8c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x31723bf511f69861, 0x576fc41b64a1c464, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x4cda15e77bdd6690, 0x369956ab0d3be41c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x1464be1e66bbb7e5, 0x0dfb5c5b6f3e5490, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x3a5410114423c777, 0x2816830232a5c7a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x7ab86ee10b54e53b, 0x5f5c6e4d7c2a56cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x72edd5747323808a, 0x02a0048706cb1b60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x1786c9741c2427a1, 0x0515727635a681db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x096cf7283b121183, 0x63a24d684fb7a02a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x4d08a9e46af2bb3a, 0x3459648f3adf331d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x66d021ca56167394, 0x481b173919e2bfcc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #29", 0x3cd22b793137975e, 0x0921145c7b34dfe8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #29", 0x755b5ed60d3715de, 0x2ddaa79177263b8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #29", 0x188bfb1975f096df, 0x735092577013cdb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x691417697bf45b8e, 0x76dee9180b79d08d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x1818832f24c29fd1, 0x41205269009ae0dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x5fd4b15404abe597, 0x5052810821857a57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x6f9ea0d1247fc4ae, 0x5c64ad752cdd5b39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x7a9638434fe12f61, 0x46c01b05566ec29b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x0118c6c07f7e4a15, 0x51a3a284376863bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x0cb55ff321df319e, 0x2e8e9f4776742596, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x17cfc87d5d66dc65, 0x6687f34d25415b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x595b37f371db7e02, 0x30bb2b9900e3dfe6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x169e1dd351d141cc, 0x017ec0c47173bb22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x567d27636f5de2ef, 0x12f9357a7672cf28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x13dda79d6a104566, 0x23502a61461bc834, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x39f174c76e2e2d53, 0x1c8a8acf0e73dfe0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x6dac7768746ae2e4, 0x45dc439d3b0a3b87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x164a14821806546b, 0x317e611d7a61d75b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x756d30d0505e5e01, 0x1fa332672e19dd00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x4239dc03307c7daa, 0x2efdbce64ec868c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x024dbf7653355960, 0x403c23e658d7f9d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x42933c4f729af360, 0x4f4ac8ff58cae6d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x5cab38c63b7139dd, 0x1ee6af0d5670e3ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x299f67302ac1076a, 0x64e4c3cd169cad8d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x1f2bea4e03254a32, 0x51a6e915174bde99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x1b2b9e9d3150e85c, 0x11adb5f43575fed1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x01af465d128d98b7, 0x638fdbd11098cf6e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x430a16621f9d5c18, 0x5f61383243e92260, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x72d2b5796c0be536, 0x1cc11c374557d5d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x5ea6d8963d096bbf, 0x1e22bcb23565f1c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #30", 0x787aa59c70bb9983, 0x0bd6d5b53b52115c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #30", 0x1b7ca0ed2395a7ff, 0x51eebeea221a0ccd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #30", 0x26baf2314b13a15a, 0x3965eb663aa88b3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x7c6489b653ae65de, 0x701e8a0d41e690cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x663bfe9531e0986f, 0x527f603d7e13d013, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x517df4875ebe0eab, 0x41fcf274294614f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x4ac9f3e20cc0a782, 0x6e9dead04450aa00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x49ca1341058d717e, 0x79b69bc92970cc78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x76490b0136b19cbf, 0x64c2ddd54244b8de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x5a4744be1dc4b111, 0x645ec5ab11c5abef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x68d8526b3c8cc138, 0x4c6e372b010236ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x103b2716156827fb, 0x42e8c7be653cdc22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x4748c06a254d9ea9, 0x6350ac35767725ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x040bad550e5b2573, 0x1fbd3aa318c6b4f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x1b1bccf556cdfabb, 0x5d175ef24ed5a137, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x5c5b6c3a5d094b84, 0x78466daf64e5e036, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x13bae8430b895ebf, 0x272a991452a4773b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x294e0fd030d85a55, 0x646a232a6e022d01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x6d651b8d31ed2baf, 0x6f0463f11226623c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x475553ab5ab3ea93, 0x77633e5e7da042a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x0001893d13d4a2f2, 0x7417684f0e9e1415, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x222fc865047c27fa, 0x2764c907040d3692, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x5b4a22b54b294578, 0x52e2d7c93d4b955a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x283290fd495c0ea5, 0x2231759037a58eef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x54e56d646eb42955, 0x0a4a062b3bed7940, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x1f8c83ab18f40a33, 0x29efa6427e337d35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x4ae135e207bd1dcf, 0x1059df710cf19f38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x627108627ea94a2b, 0x0a91e1dc1236898d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x127ded1d483966aa, 0x20d49da36272919f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x4cb58ea439629ffa, 0x667fc83134adb582, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #0, #31", 0x048be573142ac06c, 0x71f94adc27ffb15a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #0, #31", 0x5d86cf1169ef4674, 0x5fa540492cbe7670, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #0, #31", 0x58a36fca129b95f2, 0x68abefb0326c3c76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x2b8fa02540f9991c, 0x309fb9ab782ff375, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x48b6b6eb0fb37489, 0x052192ad7670d608, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x0e5cbeb4297bfd38, 0x08a75f952b27bf4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x71b563e3741a191e, 0x0d9a50ed20daabd1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x2d7cb9194781ac2f, 0x558861533e6af287, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x5bac6c9c460fe42b, 0x666aa3e132089e8c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x2fff2a9f477304ac, 0x5ec714fc39333bad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x5a0e9a9f1c3f31ce, 0x6b9f782308a29a69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x5d38caea05f4208c, 0x00d28dde059e3ac4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x15a7951504b67062, 0x7c0f10cc25ef81d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x2e326d9a5eb19210, 0x51174123240453ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x52cbab2e1a6760ef, 0x44deff9b1fe7d17d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x61e90d1e44bd67e6, 0x5e52c40500486447, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x0acd4c11111817cf, 0x325102d33d9579ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x588b1c7c62682d8b, 0x76c8b5683acc76b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x7ea75f5a44419ef9, 0x436f111a3299b71b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x4a35bf85344702ac, 0x3837f1df5be02a44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x38fd730e52e6ed3d, 0x01cfac1a5fdd549a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x31987f4d48c0a800, 0x03e1a864672fe0a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x632808ef656a762b, 0x0717b22604642a7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x2a27de1136fd9196, 0x04ac8ec34511160d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x4815a966796f4530, 0x02a68fc834f52a23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x5bd772bb3330b1ee, 0x6fc1a0d420a0c5e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x777250e70b726edc, 0x533a7cfd5a7ed215, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x3fb97188382ea874, 0x365efc5a41a8106c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x0b1595b125670d6b, 0x2185650778b6e496, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x6e27b56b66fe7765, 0x5fe6c53f3cae14fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #0", 0x4c68ed9045bece3c, 0x41123f79514fbe5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #0", 0x7cbc5fd319076430, 0x1660d4687690cba1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #0", 0x1276a9601b479698, 0x2b85f5c444d20939, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x4e78488738ad4c18, 0x6572cf1b6e4e1c1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x441fbaf47f2bea8b, 0x48ccee3145ea996e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x375a92ff29180ee2, 0x0792a9db03d92c7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x4e7f1c4d5c76d652, 0x7c901113427028b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x43754db740307d27, 0x7f1e3dae3ca6d1b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x05ef4b642457647b, 0x0df690130fde3b47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x3d5ec8ab31f4fcad, 0x066f06e902abab37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x4d3c93462cf0838b, 0x477db4704fd5720b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x659dcfa306f07c58, 0x3e238e271bb4dbcd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x061c66e369321f16, 0x619f753b29bd8a97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x124a2df82a26c828, 0x2d96b7143d76f9e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x069d9e7a7f056040, 0x7fe7229260c94a46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x3f35dd672b66ac12, 0x1d701bff4a12ec32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x4fbe108e60602e62, 0x59f12779452528cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x12552b100f4e8872, 0x47d0d4020d1cd939, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x3c3f0bfd1b15d96c, 0x5cf24b455f91be56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x220655c45ce60f5e, 0x7b469a2321dcdba0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x46182e7579311d4c, 0x4b9a66382822bca7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x2357e5746580d91b, 0x6599b68958625c6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x6486395b569bc2b2, 0x392ba6b329f583ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x02026ec54df9979a, 0x7408702123bc16c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x2e59c5fd30b21390, 0x68e13f8e51c07f53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x40009c033bcfa3d1, 0x5edd588c40aef10d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x56e57d3d1b874986, 0x2040af637c3fa800, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x786d58e469b6e9d9, 0x1e1c83a178ebd301, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x62e8072506a84631, 0x210e8fa83e858759, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x6c291f4c50138a7a, 0x16e7e3c7063fec9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #1", 0x26af4d2d243de0aa, 0x3035708950af58a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #1", 0x723778445d4caef8, 0x746b6f6a28b1bbf2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #1", 0x0dfec288594f93d1, 0x7a723b4520913e41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x151f37a30180deb1, 0x61402f4e4dff5e8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x1d082837685b8a2d, 0x4a3f068c6c04b4e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x5212740605ff178a, 0x64f087e21575811c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x0ca75dbc6ae2ec3c, 0x53fb087534fa7b2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x3af676b76b6fd84e, 0x3b3a67c578d07d08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x0fadb8f83deb451a, 0x497fd5b061a5c3e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x1b37f41204c9bb1b, 0x0a577fd601e5313d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x5e194eec03b69ecd, 0x22766f7e2936b69a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x05377d7e41751bb2, 0x773615267338868f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x29d0a5df442dc352, 0x5f3d3b70223fa5b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x4a2cdadc0bb02f47, 0x37b526d27be319e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x76931b846c17fcd6, 0x30dd951056d43898, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x5787d52419248b51, 0x4fa4b5a13189923b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x570fd06b1d86d5f5, 0x132f561f67358e1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x225091100b912ed8, 0x691abf5a7247c47d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x0f47cda512b4903d, 0x1b7e7b170069dffc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x5429abef52dfa1fc, 0x73a2668c147f4b24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x170d654e6e7417ac, 0x36bef0da7dfa51ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x7a2446f32abb00c4, 0x79dd6bb3613a402a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x16d2fd9a07b32e64, 0x380e78c370b76277, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x20d7b9b535704ad1, 0x2240f4b26e5ad2be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x52f720c63eab2035, 0x559060db77e78a20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x4a3c4f0e05adc9b4, 0x6a2f4e9d7547b1d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x186259f26953f85f, 0x75b191d359841cb3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x3c339a5b24c258b1, 0x6e0367d76c8c05e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x1336705d6463c363, 0x6a8657b05340ffa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x0f1ec4276c89b896, 0x347b3fd30d5ab751, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #2", 0x743ce6fa20530e7b, 0x7e1219c825f1c1c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #2", 0x55c3594c69dcf55b, 0x144c94801514a0af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #2", 0x28881591772b796c, 0x0cfc2acf28ba7a13, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x7cd9432113b3bdbc, 0x1e022be972c4649f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x7d07b61b3a4be92a, 0x4c488152153b9d13, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x5f0e41db6c4dfaa4, 0x01c7a2f4393b5076, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x50b1be0840f78ff3, 0x0c7c501f7244b239, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x2d8148897db18352, 0x7f9f698a5fd0822f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x1e0491cd1a0ed871, 0x05c243f121be2f84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x03ebcdcc43cefb03, 0x36d2d03373c7eb1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x3afa746f3a849116, 0x1c82652d2c73e35d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x4e384ed36b80c94f, 0x1f3847fc37d3b790, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x25ccb2794ed6f798, 0x4d0f54a34b4004ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x3b24f23c10f7a584, 0x047b556504daf454, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x51ef357776bf1017, 0x771fa68d0bd6b044, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x7470936a71697665, 0x6ba732747f707e01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x0b784ed658017db8, 0x212ead8512752537, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x1bd078bb22bf757e, 0x063d10510f641ca2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x5d4406955b1047fc, 0x3bd8000056caed2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x4691114b5badf95f, 0x0e9ea4bb2b7c5568, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x2a84f0f77b37afbb, 0x76bc5a566c5dc3c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x0c2f554068585ea6, 0x7138b81965a9e333, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x5f176ebe5d27c5ec, 0x718093785e1e8ab7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x4e913c517ebdb63d, 0x5d8f08b853880228, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x56bf33f66c3a37b1, 0x65fd275f5a098b27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x0ef9ad2f2545a7c9, 0x696da7c9728facb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x0055efc657f93e98, 0x495a99dc6c3db3c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x33a737f70e766383, 0x17ba092c46e70111, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x09ae133e247d7cef, 0x3344c4d65e2c28ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x0cd5db9535569f99, 0x43d60c2115dd687e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #3", 0x127e6585518afbee, 0x73fbf3366bed4a53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #3", 0x5048b22c257273db, 0x3f754c7b610fa1d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #3", 0x11acab8c2486d4c7, 0x3b192cfd2707e622, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x49cc7c9062f22cb0, 0x199792d320a658bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x3aeb6b48249e15ac, 0x0ce40c804a226c56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x3314792f444e323e, 0x11096d686e92a33f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x68cbaf2d1094d84e, 0x4cbecc2d3cc28c6e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x45eb77e8469be822, 0x529ff4ec75a18ac2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x1826e41121042191, 0x618ed5165869dd6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x4676956c7492ac41, 0x39797f44686f963d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x19198108290f0f32, 0x0f777c5f582340f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x0c013be205ada634, 0x78c999b462e5fd99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x2a4bbbe03e11d757, 0x2d0869ef46eca72a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x02600995023e1696, 0x357f4a695d603510, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x12d2eee56cc2b66a, 0x1a22c17e6b2bb8c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x335e9e8d425c189b, 0x60cd438558be66cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x63603a2c6aa1c37e, 0x3128443a4b85829e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x5f346fc0436c953a, 0x33f518db29d6cf99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x6c7ba46c7ac3aa45, 0x01fa1091784df0c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x00715079083c5851, 0x5b33ee61787ce04f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x464e2fa874e8d1e3, 0x3f6987792abd0c5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x7726e879224002e8, 0x081d416a48ae393e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x0f02b95214a73585, 0x33d9f20009f9d75e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x57034e2013e08266, 0x62b83e2b426157df, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x7e8245e441dbf358, 0x0de6da7d3a63884d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x0548889266346877, 0x643a57e65db6b5a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x60f812bd313894ce, 0x5604a66d71c42cff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x3974ed1f29aa94c7, 0x6a410d4e61696336, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x1e9366aa1443b0fa, 0x0c266f907fc31cc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x3683b3e27c4b4806, 0x4871560615ba4f24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #10", 0x10f27d8c026c64ae, 0x1fb4268245866d35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #10", 0x164ce71415ce9f92, 0x07e7c51467f5cbac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #10", 0x57aa92ea0693abdf, 0x225953f914cf2cf8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x6cc81457488a890a, 0x7285e29d5cf31b7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x79c31dd838f855ca, 0x4eb7487c4dc02714, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x62a2ea913b4ff9db, 0x2f298a4a33380af8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x4f93aad57b6c7dc6, 0x32fb27c00136513c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x77b7c5cc36a4c6e2, 0x16f0a06006175eb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x39112b9053859101, 0x4b9dcbed08aa4358, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x6954309312f962fe, 0x70a00f054f5e12a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x198d0ede56b3223a, 0x642d3f9d40fec37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x1f3dab446ca92777, 0x1df1defb06552335, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x25a17d41033ed493, 0x54154a491900c91c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x3e8ece6e7f33fbd4, 0x4c38d414084467d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x7aa0799a206b596e, 0x097ab90e0e227944, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x571020515fd7a3e9, 0x1439d7fc72583f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x335d34ea6ba291c4, 0x7b0282bf10214be1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x7e9bf4c343ac9e23, 0x5f7f5e861cb1657e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x1a5fc05d7ba207f7, 0x5db028fc182903a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x684b2f6e7293711f, 0x1e7e26d6399d6ba1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x75d245b21ed708d2, 0x529e34bd0decacaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x1e0b04a61fabcd90, 0x1631148134611421, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x401726fe56bd6561, 0x42838d6518ab7e41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x3695094a06064067, 0x0b03bda81727474f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x71a8d22c06c7f1b7, 0x2748933169f23e34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x4a748fda6453ccae, 0x06a3a3b27044c6ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x5ff5d4a526ebf166, 0x086dca9064d45037, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x197f6285710ff095, 0x1e71bbd848410413, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x0fe6f9676c5ec544, 0x562db0c20f51a837, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x0c0a92d4063649bd, 0x43b2bc582df1fe0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #17", 0x5cf3af1e51a139f7, 0x469d7c4f4c21b9d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #17", 0x57a77a5e0a919453, 0x634901221388b868, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #17", 0x1159860a041e9a4f, 0x7d7af69d49504c8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x687266fe4202de09, 0x399513795bce15e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x68eecf6f5f1421f3, 0x40a2661b48683ba3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x5024128866d6f079, 0x10a93fb7026e31f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x5335b5bd55729684, 0x11bfda2c600b0bf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x5ba8e042549a864d, 0x0dfd09fe5f404891, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x263bc0440eab0386, 0x2b620264389c8f60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x193c97d949a03e66, 0x4c2547c97de33aa2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x4dbed8b500c89aa6, 0x4733872d2a961de3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x42cb78b0470699e2, 0x066433c736313fb3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x261abbd50f42bb0e, 0x7e997b572bba481f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x7619ab873fe85440, 0x2e287a14763ece5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x155aeac46446e44b, 0x5649da4d494f6145, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x38e16a9853f1ac3a, 0x288fa9d67103cb06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x629cafc075c5a230, 0x29a05a675f1d2adc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x3f65e0962433ecac, 0x5d00657f7bd94799, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x24fc87522cd39943, 0x266f657c0d24b94b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x73da332541ef7456, 0x4355f8ff67c80002, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x51322f6441aac236, 0x1382482219f4eefa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x01931676667d97a5, 0x1033bd58474bdaeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x4ac47bf1392ae607, 0x109b3c3016ee013a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x0d1c9241319226a8, 0x07f1cc4103a5e689, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x2757c8d83fc376e5, 0x62c311666fb94202, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x63f763911201ef18, 0x6b92899b66bda96e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x3ed5885b37385bb8, 0x73e262b908f3eae3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x7927d00e043e3308, 0x70bbeae632afbb81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x45e8f53e5cd867d3, 0x4ca4aa7b4a59ff72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x4355ff792241168e, 0x11a5da5e477c0bb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #24", 0x5b6bfc95665bd92f, 0x5e6a0cee0e1a7b6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #24", 0x17edffd774837359, 0x11c061f368888ed7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #24", 0x3446ea3e43d45a74, 0x5841d0d93f45c8af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x55d6498c19e5d4d7, 0x2603721d183e4dcf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x511e308f11ee2399, 0x213238b314abd1e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x162c56a1140037e4, 0x475b8d694a46009e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x70d89fb82645da6e, 0x14a000105c154bdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x4886f0fd01fb6481, 0x23915793342e9f31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x68573db154097c8e, 0x42491a9b23f2ed92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x488cefe864bd4d42, 0x0c7b7c6900453d88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x2891a7b7658e7855, 0x3f8b06387cd3da26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x7f744d2c364460a9, 0x151227f67e67f143, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x483284425a6f5094, 0x1313c32b50927dbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x6e6f88792f787e6a, 0x1ad87e5a5e5edae3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x55be58d95e057e55, 0x3a7426c25f482831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x6000e2d655bfe1fd, 0x1376c7621e4549d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x29c95e8b4eb3b3d2, 0x4238376848582087, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x3371011408286448, 0x489d5e1072564e73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x6db6dc9d043c5090, 0x6f2a289a5c02a8cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x3a80b1396d7e5d3a, 0x5a6a9a0f6d2b29ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x47edadcf589625e0, 0x3dbda78602b3357b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x080ea44a1b863720, 0x6112105e365d3648, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x798bb575291c25db, 0x15a55e795dccfd23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x7edc07d83e4a7e62, 0x7c1246f9598c984b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x0cfe32346a8216e3, 0x21e4b8d328a56663, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x72aa7b2b0a25dd71, 0x1afbb4d7406f3348, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x0e622e0176dc7623, 0x1c71dc14606157c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x645ad35d0b4a2918, 0x4d8c819248e2df3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x63e04ef82ca82513, 0x4b9614b52c48812c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x482e5c33784b15ed, 0x62a5b7746beef343, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #28", 0x21673bc845ce3760, 0x49bbf06641ba11a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #28", 0x0418b5c23d2b62c6, 0x1b46a9f3204343a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #28", 0x27ad79a963e45edb, 0x48e8aa041116e7f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x6e0a3c4c6df7f752, 0x51861b3e1a57f4d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x64d46d754845ce2f, 0x7ab94c9d7c6c6a4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x538ff74810e55e3c, 0x454f4987492f40d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x3d8d834f581d7974, 0x7577c1ff37704640, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x50688f616d1b29ea, 0x235f398305bbdf82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x32e9614a62bc9b1d, 0x4775f12a71cfcb2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x1fe7fde45afbb8ce, 0x12130eca3702170c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x3ee017a9199f1a40, 0x4818ff024795778d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x079711935ca6b8ff, 0x61ed6c622cea53f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x24ec872e6ea607c9, 0x2956be426c6b7f08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x7f8b66052b1281db, 0x359abfdb787c7e76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x032ffb4f534bfe3a, 0x2fecc4b73d18e954, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x406728240a4aba00, 0x42d4c8d653988ab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x6d07551e577b64a5, 0x456855da7350896e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x32771d73726b9f7c, 0x2a52a07a0cef5302, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x0c0ab9bd367236f1, 0x5484ca8f7157351d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x1318eff047984755, 0x1e41891213a1cb50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x363e4f1e35a80a34, 0x000d4a583805771f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x60ba8c0f606eba4c, 0x3081f59535c9b524, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x33bab88735b7674f, 0x72e29e7863ea875e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x4002214f7ceb67e9, 0x3783120e7421e0ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x5466cc8e11c50a94, 0x67726a1a2d09766d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x0430aa110e7d93ff, 0x39f8c96f06ddea01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x44efcaf01676a831, 0x78351f1e103b63ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x5e0eef8623ea7976, 0x23dd2f1e5808bae1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x599283aa40902795, 0x100e3200144d3ea4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x20fee1e23cf99241, 0x4a16f3c83a4d0fb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #29", 0x72b0f99055baa926, 0x1e37971754b99a69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #29", 0x52a6110f304de52e, 0x48db7b1432b31adf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #29", 0x4212efc319b55abc, 0x5fbc914d270cdd9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x2832eebb261fe6bd, 0x2deac79e464399d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x3c968eee7a5c2cc0, 0x567efda26d22b9ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x1e46a6365539a68d, 0x452b748d1aa57e74, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x15c9ce227909b0e1, 0x2ef2bd1877d929e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x36034322505dd0b2, 0x3226399a36c8b004, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x261879d8545dc582, 0x0b824a6d28b43cb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x04abaab03b23e8de, 0x5b67579178be8ae7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x54d9439b4db63022, 0x1fcb688446be9a73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x73d616df638131e9, 0x0d0234477d0c3256, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x5ddd5ea92f5a608f, 0x6a2eec02306ca5cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x0494071c7a04e15a, 0x4b1224417c2404e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x730e923b2623685b, 0x73fd2ec11a5dd53f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x7681390d5ca8cfb1, 0x512685432911d55d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x310695332d2d69a0, 0x51c6120f1c99b2e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x6851527f3523a650, 0x15583dcc35b23fe3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x02d9d67309730e9e, 0x7c70da573d2a961a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x6cf440882465b473, 0x3a36c87076afed52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x53c01502722eb761, 0x271c93204ad19f31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x6c3398bb3af2d2d2, 0x46f5a41158541c1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x61163b2e43d876a1, 0x72b1f15e5f422af6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x208146525a1a1262, 0x085400535797743b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x07477c03098964ed, 0x743127215187db85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x3ead0b3e03aaf5c0, 0x073a1b696f98ce82, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x0d1e045e66fa2d0c, 0x2cc3649c4186e1b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x0b5fe17f5f536223, 0x3836cf037a1244e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x518219850bd98829, 0x44e3e4185f1ff682, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x46cc5afc2a2603ff, 0x377412a13db5b240, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #30", 0x6dfe7aa0254bdd8a, 0x1cf7dd3727e2962a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #30", 0x7f65efed73ab3186, 0x7f7a0a650e7fc0f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #30", 0x7d3496746741b7e1, 0x60079c7806ad6bf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x6aecada123099f0e, 0x76463a723be1a1b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x0a03cc1a359f5266, 0x7d688363780ab200, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x14f2b48a3700dafe, 0x721cf6e61563ad9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x42da63282bf7b6bd, 0x7483a41c6674ce0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x561dbabc41225d86, 0x242a804f09a6be24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x666e3b1131035eb3, 0x3189544e441c355c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x24ae903a32a392c8, 0x529bf64f65d42afe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x19e54aa962c7d160, 0x6c8196ee21e326ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x05d1706e5b2d4bc3, 0x5dc4c86004d1f84b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x10cc9e296ef9a131, 0x7cdcaa4b0fd53c88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x25fa7c3019bc8e3e, 0x2538ea2225bf52b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x45b444fb305ea112, 0x0c3420c268d4df58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x7180fe982404f1ca, 0x727b9d7c1bd1ffb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x5508507d328a2b63, 0x5fee351457ef39a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x652dbe2b2a44fb95, 0x3dc364a779b6e0b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x0d0cccf5795ecfc5, 0x1b9a07657f1308d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x548c1b8800c1ab6b, 0x03e5012012de3d63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x6fbb4c9c47ec640e, 0x22b379ec6558b9b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x61a8f24d174c2d28, 0x0b180c6515b5c8cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x47aace3a710645a0, 0x7e8aa824275d3748, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x150b376a231d6c14, 0x432f3700392bccd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x55a797774ede6b23, 0x111b067c6a1387e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x792366b97f647005, 0x63ca689f3ad555a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x78c33fca3dcd5f98, 0x39e85e78063033ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x3e8f0b033bc1eafe, 0x190e71124d4f5b53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x03ae4f0c3dc0216a, 0x32a815052e4a579f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x550c4e92428ac890, 0x4400206c65574159, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #1, #31", 0x33910e314fe3afa2, 0x0cb478a21cb71ccc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #1, #31", 0x73011bb666fdf01b, 0x55e2e99f489c459b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #1, #31", 0x35dc5b3e167a3623, 0x32afcd8348a8b32d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x15dea6283d666748, 0x037e08d02effc1f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x7b33c6e04e3e66b8, 0x352ff5a60ea1e5f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x0a0051b60e99564a, 0x5bf1414539c2d1e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x4c5977b52c0d49ef, 0x680d29830daea0c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x6e98127f7fba5abe, 0x7305e21c2165c647, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x4f9e0a6013ffccb3, 0x3e1ce314222920b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x7afdbcce1d7533cf, 0x6ac5664c429f2616, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x33ef69f20ec5e214, 0x0b47d94330da180c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x4c2c495c1509cfaa, 0x5fd9da0449ce101a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x6348366234613752, 0x586ff60d4760103d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x42fa8d9d69300ba3, 0x0122e2206d488818, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x153d55926dfd0af6, 0x7af728da0f540552, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x6db765b46ed6aead, 0x30b9cb9903d56812, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x02d67b6010c3ef0e, 0x25fe88c23d557014, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x2e3922de0b3c6f6e, 0x7ff4962a7dd4382e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x1a0251820e882a3f, 0x2eae503b62288cd0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x2391f9e9046692f8, 0x2bf69ceb662e9ade, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x38c7ca4a2eb18d3c, 0x2d8eab1b06da304b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x17e198df6f19e13d, 0x7422b8637bc257e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x5d16ec343bd028d3, 0x0b165d392d1eee72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x2aa6d78056f2df46, 0x30f456844ace51e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x67b6ce5508185827, 0x0823c1fd2d7d52e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x1354c79559ffdb4a, 0x2b518b0f15eff133, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x68880589240f1aee, 0x78187e032d571917, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x2875ade641145f11, 0x1385b3f60c19ff72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x6fc5ec4d0716e820, 0x12f42fbd613d7831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x7630c95e68162d52, 0x5cffd01807a7852d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #0", 0x23e6562565baca23, 0x34c6739f5347b592, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #0", 0x3cada9692639c977, 0x1e16077a4e8d2da5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #0", 0x2e52219f275c0b96, 0x7c0a8086246477be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x015be6e0326ce6f5, 0x3a5468f141a6e934, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x567c01e30283b642, 0x6efe024c69e3ec6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x4398155308f21b9a, 0x75fdebdc7ef1afca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x100903ba3d2ef813, 0x602f27fb335e01a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x254525656fcbfa6d, 0x3b0586ce0639cd18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x5586c49077978a25, 0x598182aa492b7b8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x1dd1539c13c329b6, 0x17b8a93012346df9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x3b1f354c70ed4ea9, 0x3698e5b84c23753b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x235a359e7cc860bc, 0x0dca5e703c7b1c2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x7f4c16fe1c5cf473, 0x265f089779d63782, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x254f100d58f70f47, 0x78c7e74c42e42c51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x1626075a3147b4c0, 0x76422df2355813c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x2113af2d1513638b, 0x3b91e0e03b6b2cc0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x0caaedb01c4f517a, 0x0496a84a769a73bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x30127b313f67c76f, 0x08cee1b72a7c414c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x30551618046a14f8, 0x769fb6886b31b07d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x013275b44e0bd541, 0x27acccaa53af4bb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x6a68c9b5464d6a85, 0x4d858339007e8cb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x1f4479cc39a4e6f6, 0x4362b9030fb7d9c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x6aec9bb600a1ce6b, 0x450fed8a356a8126, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x15b531f6756c5631, 0x70d5ade60c004ae4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x11bba7ab0b69a058, 0x029abea122601fa6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x4ad167c7437c177a, 0x4cdc60f241ce22dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x47e62c7254aca004, 0x2cffd35a7b267de0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x22b875461c5b4cd0, 0x4ed5c9974918a226, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x62a8b7550cf9e7dc, 0x49972ed80d213efb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x469eced261e90648, 0x1cd918bd01ed3121, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #1", 0x628ad4b3282d602e, 0x3757b247318b6a88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #1", 0x1d99b65f4026740e, 0x3d8bb56c784006a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #1", 0x4b901466677c8741, 0x1aa0264f2f555e0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x2af89ebc1e235441, 0x712380e716617c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x72cff445605dc3a5, 0x1187fa0e72decb2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x7cb91075058e9c2d, 0x3bf76d551588698b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x128884093f82c144, 0x22a9a8865f61c7ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x216bc78c18a6ab32, 0x614ef8eb592752db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x40d40b60483e72d0, 0x0ab2bd6403f69c3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x0864e6de16d6c937, 0x7c36a2e85e6dc1bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x7e5350787ee6a0b1, 0x0dc31fca53f4fb45, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x1d09f4f27bde7181, 0x6a567773294bef34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x5c3c3526582227b8, 0x1c2aba630fd9e937, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x5db0c3e5480bfb49, 0x256252c358f5459b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x078ebc8d19a60650, 0x38570d65703947ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x324cb1825413582e, 0x49609aca28fa8419, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x1c51caff2927c340, 0x2cf120587320bce3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x3ffe8c775f519e6c, 0x518e7ea224b6b1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x5e383f1d63022495, 0x78abad223e51dcf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x5ee0961603c88687, 0x679dcc247b42340f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x5beaae3f307e700a, 0x0b1c1d473b1ccb3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x788a6b534c691e3c, 0x141210d7399b7225, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x660f248c733554de, 0x29d4ba14001927e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x4748ad0d5604cc53, 0x2913abfa185bd60f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x7f2c8f935d0b1194, 0x0b7c92f2639a780c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x3c5cb00100fcd70c, 0x085129e93f2b1c0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x63fefba1651ac51f, 0x7d7cf8fb1a94ef1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x68e34ba720f34075, 0x15d7232e42df91b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x5171b07f120e6dcc, 0x7dfc5cf444cdf9e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x5e778c08283e261f, 0x7e696c0b49fc1bd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #2", 0x1b737afe7328efae, 0x4a1543b34486b095, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #2", 0x492dbc01685f1996, 0x5ce286a462bc280b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #2", 0x456a2b2a4ea7ca00, 0x4656a017485a4b94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x4fa4a10c0502609a, 0x0785679f01c6db2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x6a1d25ba3232ed78, 0x1c5bca4a33a39cae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x53262ded747f8b5a, 0x76832e6653007161, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x068df9261637d753, 0x17ce6b472497de6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x3e75fd7238a93df2, 0x6e93fa3e6505852f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x2bd22da0066ebc68, 0x298c35c459e97870, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x6ecdd5fe02fc4092, 0x3ca5a07b74ffe9a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x51a40a9344df9cd5, 0x3d5a353534380128, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x49e1fd6f525aa69e, 0x35fedc542148ab9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x048d94164b6f76b3, 0x54ec484d33ff2329, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x3fef020e1ecdffd2, 0x06ff948a57b3c203, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x3505d7256adf9aad, 0x7c4ba06f467cfb34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x2388d89f550eb627, 0x2b828063737bd497, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x5b7d728f0a0aed83, 0x4d654d084f5b063f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x0d072e1601b52516, 0x445aefe04a4b488d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x4694c1eb3482260a, 0x7e8349b65eab38a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x06dccca854e02c96, 0x7ff3e4481076bf5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x204fa3494b75770e, 0x4475e2840b6a60be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x6a4376e05f69c330, 0x631e22c1603ea557, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x4a495ddd523e20ef, 0x26bba08c1f494e05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x274cd717602a6fa5, 0x12c5229d6dd2367d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x6a355d2801882c9d, 0x3d2d3cbc02ca49a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x033d51b34b98dbea, 0x4d159234773c8b3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x001b01f455dba830, 0x55e7c3e749d2139e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x2abbd4c61ebeb57c, 0x5a48d2f806f7ce9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x6a342c8b7580521b, 0x12622f5a4b0b780f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x54ea154b5205bdf3, 0x2b4a1d675477a36b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #3", 0x2443dee20686140e, 0x73c0f1711f337328, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #3", 0x66b083b34a32e662, 0x0d05a9a54b90b5f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #3", 0x4bbb12ff1b7091d4, 0x4e5affa050e5e0db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x67096dbe1e0a3001, 0x48226c1a4ef864b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x73e5d83173134b48, 0x18ca785067246fb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x11d200c5007e6da8, 0x6e1c3e4e1ea1acf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x75febfc314f7426e, 0x69ad25077c062d50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x66fd0061443ec22c, 0x507dd0bb4ae8d50e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x4ac4d63a7721f1dc, 0x6a1c48360b40df43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x4154d83e252c94dd, 0x56d1953d317559ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x409d26b14a7da6e3, 0x025b3ac90d0feb3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x6887d6e474d2c83f, 0x5c084fef27a6946f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x67e613877ce7426f, 0x0ecb04215c6daf16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x7d65b01764bc8114, 0x7b0f5c0d79b8144c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x79b3c382463c1258, 0x75be419c73646fda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x0a7ad48428698d1e, 0x3e4d44e860b0c3e3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x1f8b7efa42c33864, 0x6bf1a327553faabf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x67efcd4109103f75, 0x06b504ac60e05738, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x538de65849f89264, 0x6df04275288cf3f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x3ecb5aa35efe8c82, 0x503388613c15bd3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x5be5cef11392c860, 0x18836c5326b16e2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x784f49751627c414, 0x20698277594b7f08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x5c63d66c0afd33ca, 0x4cafeee272030cf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x3366c0e83ea57402, 0x52b3d0db66deaaf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x0168ac6642d35a5c, 0x3c1e55af52f23fe3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x4be399d121c2d991, 0x33d2971b695879a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x6bbb6bf56218f5fa, 0x11e56d991f71802a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x4117827c740aa9ba, 0x5b873d672a86c699, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x079d721a71a1b73b, 0x513834c41cfd516d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x07c97b4f42f8bf57, 0x7648d0757fecbb8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #10", 0x4df5f32144a39962, 0x71efc887642d51bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #10", 0x03490d64072a525b, 0x4b0bfcac015cb409, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #10", 0x49fdacb708218b08, 0x544ef3ec04b1b9ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x29e464997fefa10a, 0x6e0a337115e14689, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x6208970410da041a, 0x3552c6b3159fd08e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x04e4add4115ecbeb, 0x4026972723201980, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x0300832736663b62, 0x401d6aed0c821fee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x795efab97e5ea405, 0x0c6edb7e0ac9fe76, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x43023d673a034cde, 0x6ef750324754edda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x412d9f391d0095d0, 0x48b1a1e3464b4acb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x252220d839073806, 0x4afd04950b2b4bf1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x38f6d910565f592d, 0x210c927a4f068571, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x67395d4724cced27, 0x64a655ff1aff7014, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x362bb9127e3cf481, 0x3e1f89946c1e0b1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x34a32fe3050f0687, 0x78a02b09392c3c39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x036daa8c32ed8ae2, 0x43f63ab02e022a9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x6cf0d7c03e08ba59, 0x75571876466fe7f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x5b09502957b83753, 0x0cbb32be2e1e76f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x10bf6f595a565564, 0x3949c2ea002b7101, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x30b5ae9133d84c72, 0x4f31f67249b64869, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x58a5399922d54211, 0x64b5b87d17ef0bd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x211236927cad41fd, 0x040d16f30ed0f2ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x01bc48840bf36995, 0x47fd2ee555b56675, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x3ee0f477790ea987, 0x03b791110529f311, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x371763e158550dc3, 0x4b99db042bd1cc37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x300d4516133a061b, 0x59f043301220b40a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x6d905b7f617e1b7e, 0x124c250c40ccb470, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x155667f06f38b557, 0x0a82fcd91e460a11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x120df7683a422cdd, 0x363515e96dfba189, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x36ef6eda44c9c31a, 0x7ccc943533202dfb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #17", 0x50bd2caf0c8d2582, 0x08d5947038abb75e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #17", 0x059bcf09096f8574, 0x3dd5aa6f0f9e2126, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #17", 0x61c493371560308d, 0x3b6fed5d3cb332ea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x289a36a861200c01, 0x4ed3e6f511d1d84d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x429e277f5d218997, 0x529e8cbd162a9228, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x4c5a3eee6aa5b222, 0x34709c3957f48f70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x24e7deff42bcc52e, 0x45f030f95e683656, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x078688481a5df8c2, 0x118864515bd74dd9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x26eb1e445258afa7, 0x148305385843b4f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x5bc8351b2351c37a, 0x67e1d61d2c86ed4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x38b1f408380e072d, 0x693a20383d8cc852, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x192e132e21fd2d5d, 0x4f5ea0a0614c2ab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x7f1eb6f42be75911, 0x7776bcd85bcc3aad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x168d0b3479b0fb17, 0x33c0ca1d4b78f5e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x3c6dc0453b69908a, 0x29e12c393b74ea33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x55c7894c2bcf3d45, 0x174c380d43f4488e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x7e27ecec0419d3a3, 0x1c37fd857cb2a790, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x276b971d1273b516, 0x293994de59f02208, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x4a81bc4366db8afa, 0x177cea5a601d8b25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x08d8b85838e072ae, 0x4169b5d663afcf71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x64c7cbc0733cd43c, 0x3f7c0a1e07f76f4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x6cedcf537d519168, 0x5370652f7b54d6f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x38bb21f24e15f934, 0x36c9c127295b8f98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x79e536790987d5ac, 0x6d4fd8260e82ab3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x0da1a94f346ee7ad, 0x0b3552cf780d2366, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x46e29cc3697a2fc8, 0x51fd456e350d406c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x5055bac356948168, 0x152acb9211645906, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x0f74f41634903296, 0x75142877592e731b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x27cd06d234964796, 0x6125e267743cbfd6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x31e7d8fe265b57f2, 0x6f9196ca14bad625, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #24", 0x747151262b663de4, 0x3e1665bd6aa2faf1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #24", 0x34ee1390045af8ff, 0x7925a6306e5687a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #24", 0x38c9e0ad3860f074, 0x6663ab06428fbcdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x21db203c0cc7c8dd, 0x779cfd4b7fac7d70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x635c4a450624feee, 0x1110d6777230daff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x3ab531842c853082, 0x4b5f4e1a72d13e5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x611b7818569f94fd, 0x670dfe3262823856, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x7cfaecef35537439, 0x773d0e7b13035117, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x60b9b21d76cbf238, 0x7da64c08716c3e15, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x7b26eb37462670bb, 0x5fc2c5b515a7c5ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x7e87612f4fd47fd7, 0x5837828c33f0cbe4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x5c9c48b544ae1fcc, 0x339d49552062816c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x4ad31eba5df2aa86, 0x12935c6b3ff892fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x0a77db0819d7cf89, 0x32c9d1560588503f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x707764865f479711, 0x680a88956b935320, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x149b0b4a7c3cf03f, 0x7e96a4376d725175, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x7308e2773ea15540, 0x5ede8f8a7554bd67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x04c7c5fb633405a0, 0x0afc83146e2fcdaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x3308857755bde2e8, 0x22209993034f272b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x1a6c02b436450502, 0x23b1a8970fa4ce2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x1437af880267327d, 0x4f9d6127653f216f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x1c3f020652d1fa43, 0x6ac771ae1eaf8a90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x3219915408d981e8, 0x0a42ddb10cb6668c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x051672285907478c, 0x7a28b80146b49c9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x17a89ccc4705dd19, 0x3c095a05781f549f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x2a39e2b9086fbbe2, 0x664f224e1c7062c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x5e2d9eca43713289, 0x1fbf89f25d426831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x79b6378c3c849784, 0x6ce7365d7899a17f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x3eebca0248a0349c, 0x5dd8c2ee0dede714, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x1b722edf36e04f56, 0x2c9d71a55b2acc08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #28", 0x3fb9d13e6209ea96, 0x67e132954d8bc034, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #28", 0x3b1132225049b6d8, 0x14405cd244d04366, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #28", 0x174f93f1233eba54, 0x3cef980652b9ceee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x2bae76360ee9bba8, 0x6f2a31b6418976ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x525aee320bb31539, 0x1ecbdedc09dc1501, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x4837acbe604e796e, 0x0275b6804c1125be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x28eeae0a069c7e77, 0x59ff0cd2072376c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x3d7ccdcd4a2f755d, 0x624e42c84460dce9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x2c395ff4262cf9f0, 0x11ec9d1d7d369f0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x7676b0c87ef67a78, 0x4206e272674a9216, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x223534cd292e92bb, 0x3a0461050dc644b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x38184e636e1b9a40, 0x4f4fbb644de3ab03, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x79ceaf7a5a357684, 0x57bfc0040a733c95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x3a83eff230836f26, 0x5684625342065c38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x371fed9d2b7815c0, 0x4929d2f863729dfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x75a78b1e39c01803, 0x27d37ae6749cbb6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x5fed11f333da3ce9, 0x71d35a7721e0eb12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x32d0b762432fde2d, 0x092b7d285663c2bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x6c5e70e83379c2d9, 0x642a07755505ec2f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x21955d1a7aa95737, 0x22e997322476bf4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x54decdbb056e5e35, 0x2ee9fbe11b640c94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x35f1cd5b26943bc4, 0x5d6a68cc0f62bdae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x520c51841aa8d690, 0x72d55baa6d11baf8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x5468ee945381d0da, 0x61ae766347b3dca2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x075c0dc472c044dd, 0x6994c7b434560087, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x35f0230a6ee3cab8, 0x0ab9c3433a2cc526, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x225d8d91321c4887, 0x0f32b155224e93f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x2cc59fbe75af4f20, 0x46c5533f43f2eaab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x7b1dad553cc1600b, 0x5f56f73f01a46d7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x63559bcf03dc86d2, 0x11072b28310f7ab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #29", 0x1e855d637fcfac0c, 0x1e2135a93561ed54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #29", 0x53517ce766aa91ab, 0x7d15c9f672ee4bf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #29", 0x596ad68831fe0fc1, 0x27444c7e5aad8aab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x20e1da79240d0126, 0x14da4fd10f5af992, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x562949ad786ee0c4, 0x31a98d85433f680b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x6e1e2fe5668949f6, 0x073252b602eee96c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x234aaa01159a820e, 0x049356e6693bdd3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x197708e0386c8d94, 0x1a4b57eb06a045d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x383c39a03917fd1b, 0x3c02332537fc6643, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x1fc28ec6522efeb9, 0x2aeab23a0b8db687, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x042d0e7a7b159103, 0x663b4132792d654e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x1f2292293a31ec66, 0x08885ee1250ee8f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x32a0cd2b6f80a3b5, 0x684e50ff754bdbd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x5609edab7cce1c29, 0x783ac54320befd10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x12689e3724463235, 0x09fada4a795497ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x5cb2bfc93bf710a3, 0x7ff4dd7e2bdfa717, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x750f0dbe0ec6bf95, 0x63dc0d5b14eef96a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x60f5be4e06b7f124, 0x207caff114d19c85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x01cd8227168760b4, 0x0dff01d36522ccc9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x50b94d1b728006bc, 0x0a31b5bd20f01451, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x6200aa710e76b56b, 0x163bf028035a1a46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x0b44d1942e13f1a0, 0x24191756380a981d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x525a23d631540d48, 0x315f2fca1dad6fcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x6d4b1deb2d69243d, 0x498d16e22f0ce39f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x3c2fe3d364788cfb, 0x43fbdd09625a2ba9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x6b307e1f052aca02, 0x772bc82e1d25a221, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x1bb22ab60c7a24a7, 0x02486eea6cfe0046, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x7efa2b63242a04bf, 0x0dee14976c6b77d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x32a0ba2a13dea96d, 0x6fc5921760fad5d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x41f29b0e4a649dbc, 0x19056df23de58bbe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #30", 0x7bb8ab042520126c, 0x5b92fb89144cbee4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #30", 0x528936a907557f8d, 0x4359a2836903c8ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #30", 0x6bce0c884289bcc7, 0x4b5df4980eb91a7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x47b486c92e272b88, 0x2bdebc9e56fe8aa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x3aa1503051ea9f85, 0x43fc8aed6366b17f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x7614a4443f97bb68, 0x4fd22951399b7b93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x537664d6339bbf5a, 0x1a96516828b55e6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x7e005d16422de5b7, 0x669aea2d1568ffe4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x674df8236d0f614b, 0x29b5bec879b9081a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x7464e0d82e1ac5a2, 0x62bcd10939d72ecc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x70a48269746f05e7, 0x489049496032ed60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x2296316f7b2e02f5, 0x3731780738590932, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x4d18a27a6b91e402, 0x1bbfbab15d37819f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x2b299f6b31694e9b, 0x16d2fd33432d46be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x65050df6527d8f5b, 0x6be2a52d7ea00441, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x14ab75123dbec2ed, 0x1409042563056b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x2ace24383f7b4430, 0x5cbe73277bf96d35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x6d9609d27e60e54a, 0x35d09c011f330511, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x72cfeb3136976a79, 0x7f65f2715e3a8c3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x31c56d6e3253501f, 0x1693956d15661ca1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x1de5342109709b73, 0x729d9e407ede0fe8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x3ad9ea0f2dedfbd4, 0x420b56a6490ed38c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x006b8b2f5bb7dbf2, 0x47aed7cd1fdef805, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x19769edf5fa2d638, 0x02e4631115170041, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x1f1e1a6946e10977, 0x11106d764444c318, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x4541eec262ddba9a, 0x6377c8290cb4243b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x19752513018245e4, 0x6aeeb0773811d9f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x33d59603401594d5, 0x4d77f6944b3a9281, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x498630480c23f910, 0x4a18a26951baca25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x3a11f4e46278757f, 0x1ac99db104601a57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #2, #31", 0x3e3051712723756e, 0x243f125c3a7d8013, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #2, #31", 0x06c64ba660a4edca, 0x4f94805457a6f051, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #2, #31", 0x2785f7417f637b92, 0x1bebb36925e4660f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x6241362c1d873ac2, 0x32988a4b6cc7e603, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x1f0980a67251b68b, 0x24d9bff77bb65b40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x32674b601109902b, 0x46f0edc152df16aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x1d2d893b3f637e80, 0x2499e0cf7bed7ba9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x21dbf3ff248ca85d, 0x004d9600573f7e1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x4bb01dcb61517e86, 0x11bcfe32600c4571, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x41f66c50539ee92b, 0x37b335c252766971, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x530264bd2af359cc, 0x785acf81697c6391, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x487a948e7b1e098c, 0x5644499535439ae9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x6d6fc01777eae3eb, 0x30f9f62967841534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x08f474165efd0cad, 0x3a632bde1fd70b78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x1e608b2e1c121d21, 0x1bc487212621fd51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x409ec57e0f1e79a2, 0x7d617b70403c7f2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x706ff82857fbfa60, 0x2048c49e0c4ee349, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x2b9ae38b57201c3c, 0x5ec54cbb32666478, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x021376087227119e, 0x1be2c8097e9d4848, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x6d451b2a64dad95b, 0x33e0e3324a8e0a96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x5cc5bd466c754ba9, 0x32121fca5ab4db42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x4b72585616506ddb, 0x7a8be6ba65ba315c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x32628afc093daa1d, 0x0bdc2ead69d2e384, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x185c23bf4a582750, 0x2a0f62b27301507b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x225421b15e15807f, 0x7f5033c408cc1be7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x35359cbb57154869, 0x3b32805f4def053c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x493c5a07006d30b7, 0x4c8c4d85374912c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x65480a1233e93d24, 0x01d71d5936817532, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x205e88cd0bc2372e, 0x11365074420dc759, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x2212a50933a42763, 0x27c7f8b56bd0e123, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #0", 0x3ce1d1807fb3275a, 0x55a3c4a854753005, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #0", 0x4a0b4eaa46c6b445, 0x47768080553df540, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #0", 0x24dc34c4193c9187, 0x5e0a11276c5f705b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x7051d9f006dac31d, 0x3a4e75985a11d180, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x0747f3d41332019d, 0x115ae443398e33f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x471b3ec10145f99d, 0x700fa9296c8ffde6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x0d0830cb5665bdf5, 0x2e9dc53f6779c78e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x0a09e55828ee6d59, 0x534aa8b12f1ad5d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x28a194b34b06865a, 0x039005da46ebb6d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x11cd3a9f7a33bd40, 0x1c29ac1872ace35e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x13704ec7195ac951, 0x5f0c53b936a96f64, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x20358c6e22162527, 0x10bb40e403c228b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x354826c42d6005d8, 0x3d505cae277d8042, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x2ea5ff7542ab4368, 0x140d7e297c636585, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x1911015d3727d5c5, 0x63dd2d133bae3041, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x6016431e6e590bef, 0x6ac90615231ae6b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x395f924a063049a6, 0x6a069d8e08b7d7d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x006406e65a710ee9, 0x7b64bb304b2ccce9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x73cbd83b12917d31, 0x01d63c4d13d455ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x34a7a25954e6db13, 0x17967e64140164a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x0246e0eb4f8c6315, 0x3b7ee4ec69efc91d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x1237a67d4a305bb6, 0x66532ea330ece060, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x0158317b576416b7, 0x6c9b10a12b48a7db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x45bd22a6386a2c1e, 0x4e638e90616e749a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x3e9a75c5658b079c, 0x6a264c6c7f1cb4f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x3ffc16854c1fbe27, 0x4a4981da3efe7cab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x5eb13b596a6950bd, 0x52d2d25933c7eec0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x3f502bd003483856, 0x47c9536a1358ddb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x52d49b6b639bd572, 0x7d48a6cf41970cbb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x2dcc31295f1efdbd, 0x7283ed1c650c41e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #1", 0x368314745eb87854, 0x1054e9c32f2462a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #1", 0x1722a4727ab923aa, 0x1092d73e7c40371b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #1", 0x60442b4645a66de5, 0x7b5cec0b55bd1a37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x11c62c0d678e693c, 0x14bb96e3204041cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x51f7b9f91bd183f6, 0x5408308c70776766, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x1f19bc4c0118ebe7, 0x03d045181147e5ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x64b4c15a4562dfa1, 0x52def28571ee57b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x2481dd5f674f8363, 0x56fa99a01280f283, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x4607fbb752382c66, 0x41a555275b04f1d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x4cf1501052a214fa, 0x574528ee5d2aa02a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x184882df47a35144, 0x32e7ba612d357b57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x2f31ba80217dedaf, 0x4d75bd232a0eaeec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x3d4f71a61e565b6a, 0x1a8616520129747a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x1f6f475265504cc9, 0x12715a445c692df2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x2ab32c6b25521f4a, 0x4e5785aa042408ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x0ca1a2ad584a5056, 0x16a4fb2f4f3509ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x2a827cbc017f248c, 0x2a39fb9d52a99e65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x5421398662bbf8f0, 0x2fd43e8f7773cccd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x2a5f4a35721f0547, 0x24a948246c69bc65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x139cf2f630fe81a4, 0x16786b52599104b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x4f54dd0f6d2bd373, 0x5aba792f50ec649c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x527c203d7bad1839, 0x2d55928f6ec42461, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x20ff3783098d283c, 0x72e82d0d7d2f4ca8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x61d77892769e520f, 0x4c6456722da0da30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x781d769b301eb724, 0x004a78950c59f54f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x12dab01528770a40, 0x03cdc21c4c3eb021, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x1a960f874f20d7d9, 0x38a86c873d39fa4a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x001f597d7185782f, 0x16cafeff2e33027d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x5eb14ba22c74f9a9, 0x7f1f671a4f74368c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x282211e2312087fa, 0x3e385aed312d6bdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #2", 0x3aadb0367ac10ef9, 0x2e5cb88749214965, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #2", 0x715f6109770c9c2b, 0x76c223951c8528c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #2", 0x272b534f2cace034, 0x28df1e18697cd7a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x5523ea746e63f44d, 0x35bb87c63a060364, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x3d84cc260e0afcae, 0x773ffdae6fb9f9fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x7f9074dd1d0c6392, 0x1decfc783da425a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x49815d3b4b50b71d, 0x0d185c305e41c07f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x7c713f183dcbe4e6, 0x0f6f2c5f71a36f1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x388cf3e03186dc18, 0x3ac4b882371eef4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x289378437c83362f, 0x53a4181729ec54e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x293016634924b453, 0x13692c8d4fbecb92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x3788a8a00104cca5, 0x09c4cef77e5400d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x0f0fc9530bfaf74b, 0x6e0dfad2750d74c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x29075add3fc9f69a, 0x32b19a6a0ea03e30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x0b1aadb77c512b0f, 0x6ce1feb07288b819, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x3a1d0ff51ef0dfb9, 0x642c2736078beccf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x5077bbd1124ef435, 0x3eaadc1e72aa03d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x0ed22a652fff854c, 0x1c9658be790b3414, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x7924399f528ece9d, 0x48c9ffa6380240c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x53939b4324643c72, 0x365641a030ace240, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x305f33bd586bf170, 0x25ba570662a36496, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x1835e80a5e25a177, 0x7143a2c759668e9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x5a76cc86301b6dea, 0x4bef46b4235095c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x4f0c4da369875eaf, 0x2adc82911493dc7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x7bd652e523d4390f, 0x073de0511f840974, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x53d3be5b61593d2f, 0x188f3d880aa87d4a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x33e80bcc7900ffb2, 0x42aabe124cf7f7fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x1d653c25235f3141, 0x7da4da3b077ba70f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x7bcb22b25b62ae6d, 0x6a1f0ba64dc46fe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x39884fe4731a4531, 0x272afe7d14010abc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #3", 0x2335b31c622e2310, 0x3751a07e13ff1c6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #3", 0x4bb581bf2fd0d936, 0x2892f8e5724200bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #3", 0x53a512462a5547bc, 0x11c60a34478bd4a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x0bae84eb14df1001, 0x523451ee2778d0a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x0de00fb37215a2d7, 0x7470c89c3f9690b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x1574d4193131436d, 0x471237c72b454bd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x0c93f1da2034ba38, 0x7909bbbb113ff6cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x134eff6a5c92a206, 0x25410187461c41be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x3ec0c51602ae570e, 0x5a1b5e283684b286, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x327f30443a8cbd79, 0x28c6b3450a7646d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x64e2053624366d68, 0x52021b7a0624428a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x39157d69220ddbc8, 0x2d9d132c70908a21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x14237ea0773952a1, 0x30271ad946f58d1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x286a960e6b4494b0, 0x723ad8f5299852b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x0b794ee960194b0b, 0x3ad8498434fe87e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x3cabed11553627d0, 0x7b1ac9a71ec84e53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x57e47ede7e13b41e, 0x554d00d97b6cb227, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x38a0719857e51477, 0x05e2f8fd0a63af22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x7c1b81df3e2504d9, 0x1087f1ad1d8276ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x6032e0a13e3a1bc9, 0x0e1300ef3530ff49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x35736e6a6e61655b, 0x7c268c6674565f41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x59a5fa0c58c6fb7e, 0x1deeb1fa5dde0478, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x38e0468a0df75609, 0x12dc8c61651f48f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x632d7dd959349821, 0x03e79748758c339b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x57484c3f76dbdec0, 0x70f8e5c33b11fcb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x4ec0f33755fd9d86, 0x4575abd90fe8bdd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x1422a25f3b7e3595, 0x2d6b34a54adc7516, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x79b8515e7c3400c5, 0x000d745f74558301, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x6a956621069a943d, 0x68abe2422f2bbfc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x5f618fbb1fe650a2, 0x0d09c440443b602d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #10", 0x2ddda6ab2d42406a, 0x295aa9221841d645, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #10", 0x0676d88b7ec6efa4, 0x0dce09e1110b2484, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #10", 0x75a2ce641192cd14, 0x4c1d213b5dbf24ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x67906a9b1b131747, 0x6da7e2a24463c19b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x56914cdc0f4dab11, 0x0f4036b17bb30cfa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x0b81abd658b4723e, 0x70088ffb50499e3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x5f4f067b0c7f2243, 0x7f755e02761711f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x2c6572e563ad1b46, 0x3a5272243eb09636, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x10ef5bb064c0765d, 0x56f26c7c5a431990, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x63876601376b5f4f, 0x6b4e3e141766343b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x48fe2c6362cd3ba8, 0x75255906592a3465, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x7de052ef2cce2cb1, 0x1d8df600308e96fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x3c1bd7c21c4a33f4, 0x2c41a3f954719fcc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x74fea63224309c09, 0x24bb3e06479d8399, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x30afbe4c780707b5, 0x3db49590544dacad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x5bb422fb69f0af60, 0x12fe42e45d153131, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x4eb125bd22a688d5, 0x37584ac16ca37eac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x5a11e824792f0bed, 0x0409b2e732388bbe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x5bfc479528f0b623, 0x0b62c02323101487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x55bee2d47fe04f7f, 0x539eab8659dc9a85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x1c2a837353097857, 0x2e4e3a5111daba97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x773a1460172cd3c0, 0x59783e30112929a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x0f33db7578751937, 0x6576d65327e9d2ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x6265c8973c574e9e, 0x04ff03dd6ae7fe71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x5efdd7735b953004, 0x578b7d1d3116ee54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x54c43bf26eb23a35, 0x634f7a12390fbf97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x17a2f0582fbe7fa5, 0x5c1fd41f30c08387, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x2f9ecf2438eb585d, 0x0a9d1e0c6d61d32d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x0bf4d0b558b4cbf4, 0x7f3c8dc44bc95297, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x6fe19fb442695291, 0x5cf27c3d032ee515, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #17", 0x3ade6bc83017bb9f, 0x2b18b7c27f157b2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #17", 0x6c6f0a3e4188f6b8, 0x69fd799b1d443460, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #17", 0x1d1e26bc31aa9cc7, 0x4e5b22b44b6ce1b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x205cd6fc609c7568, 0x047ca14971e262ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x105af50d2d400442, 0x22a2e63637ffc755, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x662b5ca0249e2846, 0x25619a823ff9c431, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x7d52f43a68b59306, 0x0bc316c872202d55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x2b1ee5972067ca2c, 0x754f126a6d3493ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x507f85cc564788b3, 0x6c4a0f1865fd515f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x17d07f6b519ca874, 0x034185bf3cee900a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x0347453b0cd81304, 0x085b71bb34eea628, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x6d74886c4973ef0c, 0x26d108d623a41c37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x76b3f34f01057e0e, 0x5ba3e38c7dcf7d79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x25a3a654498c5873, 0x3dc941aa5cdf4fef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x3241eb79444e8fae, 0x4eff7d4422f69a8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x64b659db7c753d95, 0x102b2e7d5d60d110, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x52bcc649469fa82f, 0x435e226f3535dfa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x183c50a37a7fe16c, 0x72246fb16a8d45b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x0757f471464cf4b3, 0x1f7bebdc1b8395de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x0fc0e3bf1acb95a2, 0x3f27b21574cc7cdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x1bd113b030653c01, 0x729bfa570674d70e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x79f194743253a441, 0x635426fd4174ba05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x76a233f074968310, 0x646b54932c337fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x710bc0a64cf2736d, 0x099450fd5b588dcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x13921b9c02b2dd23, 0x108e6d7243c886ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x7d32be8f4dd1b880, 0x2e55cca32bce6c3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x141ead330679b432, 0x4752021d048ab300, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x214549d46bf32a35, 0x79572fde23df90f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x1c5866360da88efe, 0x2a5468013d165d85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x3ffc334062f66c1d, 0x7e8b178a1649faab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #24", 0x578cef2e4c11cb96, 0x427d7a98369e6730, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #24", 0x19043f032285626d, 0x11f6f4fb4898afd4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #24", 0x25383f903ab70366, 0x0c6136c32c965a9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x0888bbe61fb6c8fb, 0x5864c6de226afe1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x26307d2d204ce0fe, 0x26f5b1201ca76919, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x0c400b336adb620d, 0x4086fa0c4775c702, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x7883f10b03173c11, 0x048c248728987169, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x660da82e015fe6ad, 0x3ee26c143880244b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x4d71b24301158076, 0x6f1e8b7b3d9a975c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x239ae2e312947df3, 0x063347306675f146, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x4d4b815a6b7112c3, 0x130c4be548d32273, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x0b27dbbe1233d1b3, 0x6b3e209355d43d40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x3280b2b13302a066, 0x727ba65a315858eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x1dde02737d5a4474, 0x78ce1fed3ec0bde4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x00718085263b9b62, 0x67592f4d1661f37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x279b820f3e00a345, 0x4ee217ca667f28b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x3f1623bc2a4d0741, 0x2419c010750d3452, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x3ce185346e8f717d, 0x5b83259862b1069f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x5a00844016c249a6, 0x2b8429130a2d068e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x28f61b59527cea29, 0x600143cf65285ffe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x057f8a8f0f4ed8d7, 0x1680b8e95b76ce0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x0ca91d4b0190bb3b, 0x1a378bee235d8d02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x27cc569d08a1984a, 0x39bf80800d1a9dd1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x46a23b9017b38695, 0x7399c6854f67d8ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x42008dd61ff83296, 0x44750cfe05b85f4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x0e87a41313ed8efe, 0x686965eb7ee2130b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x2aafd8a469105d68, 0x090f199968882853, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x3b8d47916431413b, 0x4db0885153a5f3fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x73801a1249544df5, 0x2f1cc207410cd220, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x4ae509311e29dfa3, 0x646a5f220029375d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #28", 0x26cb77ed00dd9bb3, 0x0d43d52e72b15fce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #28", 0x18912249068e4579, 0x4219387b6d6db37d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #28", 0x268678105b8f78b5, 0x732612c95a91b01f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x6f7d07b36282dcc4, 0x5973c32a350e1c23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x4b933a2c6b46ccc8, 0x1d9644771a2ce058, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x4f780e031cef965d, 0x6dd2d455072081be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x6643e4522c97b301, 0x482d53de42f82815, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x4ac192a4506534a1, 0x43215f733128ed83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x5142d05565f385cd, 0x23da4d52718d0a91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x6c81cb465220d0d8, 0x5efabe0f69d3f29e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x2db0498d1dd965e8, 0x4465a2bd13084356, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x005c42ac65aca3f1, 0x48165f7a1d2d5141, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x50f370b9252d05ee, 0x375a31994bef7cd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x421c9c4b1b3d5275, 0x530ffe96206b7ebd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x47d5057626850645, 0x6363a6d22860809e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x76ea3ae77d63bb73, 0x59896e211296981a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x63574140631e60ba, 0x0423a2ab482d0b3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x353f31937666a097, 0x3200fdda4fd90c87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x1440067f2af7af57, 0x62e14fdd62ef7b20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x10a453483776fdfa, 0x001ccc61149c492b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x5ca403e9339bc49a, 0x608bc6046197c402, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x4ed9170f6566e991, 0x020342bf1ec0a034, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x0bebefd720aa8ef4, 0x472120d216ae1c85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x1e0e4a672d68574b, 0x2944b49f02d62abe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x1086b8057d0433d4, 0x4b0335fa01658ba8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x736ad46b341fe80c, 0x513e982f45c5e998, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x5f17976428d2311a, 0x28b564b907aadaeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x60492f157cd2ea1a, 0x1c4724166fbbeaac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x306eaeb55356f16d, 0x5153aeae3ced32fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x38bddaff22cef405, 0x5badd3327f47c5c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #29", 0x437982f93f3a96e9, 0x15f5e24a44a9cad6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #29", 0x6ca2ee3412832b8e, 0x477ff5946187cd60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #29", 0x0f875f62342bf137, 0x62ed59087d29a63a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x684bd9446ba4f48b, 0x42ef8fd202f233cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x147725a626e432cf, 0x0a9d0eb8476370a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x23b71ce908730a03, 0x371f5b5474c054bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x5bc9fb700d5b5aeb, 0x31ad87b95425cb9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x302a4ef0696373ad, 0x536d91631487d66f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x289e0a9620b196d9, 0x5931a14573a3d1e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x3334c2673818f852, 0x552b9f4a1540f8cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x6c44e98a555a2ed7, 0x126a9f0542bc21c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x40ff2363504b644f, 0x45ae55975490c2ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x772f971e53138eca, 0x1bf4337655764909, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x5b8698cd7be4257d, 0x4a369dc41ae6b408, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x093f8068427a1109, 0x6f0c7fa63750943e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x2bdd84b6250a0bf3, 0x4bd86aad3969cf59, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x45bba2cc0239408c, 0x2d0da142547b8f4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x3a5238df7c27271d, 0x69bc881878f06534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x518155f4015adc94, 0x3bac86fd26972269, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x51a640e4171c18ad, 0x7b27e53712807957, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x6a2fa777322d6024, 0x67f6c26048d5d802, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x2e1185a152c90bb1, 0x63bc8c0a45b64045, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x15431cba48df3f30, 0x7d06d4833751060a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x6de94b231dc876a5, 0x70bad5634120a171, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x2001b7327f58b8d6, 0x159c30be33a4edf0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x7b7fdff36841da21, 0x2c9553245a53f011, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x699cb6b67c12f7b1, 0x00eb127a4d0135e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x132f105e4778719f, 0x5f81af3f3b42f79a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x79a5d1c467d55ba7, 0x0418cf9c7d5eb7d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x3a9e6758401bcc9d, 0x4314f81a27b75765, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #30", 0x08fb0bce4fc332d2, 0x5f085d6f4fe18412, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #30", 0x6d8ba978269e5641, 0x1102258376e456f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #30", 0x25f70f17571e9805, 0x2a8944e10d8d60aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x3f60722768cc6335, 0x67e150bb2176ef0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x64df5ae64df9d431, 0x6e7824f228fd28dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x157245d06858f013, 0x64402077780e6b44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x502e4bba38821b34, 0x756d23190f181794, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x789de7d115d7cc69, 0x36cf6efa0accb312, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x659aff3c6bb05ca8, 0x5aae37250198f39f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x124eb2ea23068f72, 0x787d4a915326a8b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x7a25277848955a19, 0x60b4095e3845c201, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x3161bd4e4834d5fe, 0x59bcb10c3985999f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x162eaa2f46c2e2f3, 0x6282c27c16411834, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x2f1bd30603bca691, 0x0e4f83782ba0efff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x3c3ec1c57188768e, 0x3ab907947f4a1ec1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x076042f764c508f8, 0x0a16d1d334dca997, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x507565a12ef2e7c7, 0x36759d366cfb4233, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x51f9773a20d5f445, 0x4021eae762c4188b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x696b4e5e74c68b98, 0x1b09da8c4c1e9eb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x3cfb61966826facd, 0x05a438511acd0bac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x2ee9ddc03f5da758, 0x310e23e0532a0bc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x431a4dea39840359, 0x7ecafbc55e05b0c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x2b0c79e76766a15b, 0x5d4fcf877f590faf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x4c2baa536aab567d, 0x3435b946326cbcde, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x199e3e445f89e9f9, 0x1f67ff121ca10ff4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x005fde3f1a6f030c, 0x7f65287f6b97b57e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x0f358ea43d5a8c81, 0x37b6543069cb2c9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x2581874e35a65c2a, 0x0498384a4c30f03b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x750403831e25f7c5, 0x1f5afc00546b650e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x57a9fb1e0fc0e55c, 0x327115d5381e516d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #3, #31", 0x772786b76bad1a63, 0x3777611c02b67505, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #3, #31", 0x565870e0548b30f6, 0x352331e44353310b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #3, #31", 0x34151aef5f59697f, 0x5ff440ff6ff6af24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x79c86c8b1344b8d3, 0x5b8e64a33474f92e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x509f455522d85e16, 0x1e4025cc08fdfb2f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x587eba407489e76b, 0x552eeb6a7620cca3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x12afdf307cfd4787, 0x4a8c31b24d82bdc3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x0cbe2ce33d18704d, 0x05a10f306a59da4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x28c58ab022338138, 0x6d104f5403e5b39b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x76beb22e272d25a5, 0x4738e4a67f1dfb90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x06868f244aa30f57, 0x6f14aab42ad3cd1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x5de7c82b7d88ec18, 0x5f48c64c004efbaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x20614a2e5e7be249, 0x094cf6df2e870d80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x5305c9b46f340bd5, 0x24a7da2378e0046f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x6c31535c4c03d163, 0x4662c23265b5a8e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x091c41b03d1fd288, 0x500f833478ef8040, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x5f5353c1440e1881, 0x7cd533db31e1cc60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x6b3b3e26201472a4, 0x30ffc7f0561205ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x6ab781fc602e995a, 0x00e5d30d71c1cd4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x5db785727b5dbfd9, 0x7210c8fa489f4a27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x59d9a2231bce31ca, 0x772657a77e18cfa1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x0b023da03d5b9642, 0x76f8d4102cdf6bd7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x095f67a562a497f0, 0x129514bc773390fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x1fc46a796cf84517, 0x7023113c127ba955, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x31065d98755d3da5, 0x445d75b57f17be3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x1571b04a560f9737, 0x5529c4291c419bbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x363e309100143204, 0x0e03690a00293246, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x7b71f1de3feed414, 0x48c87c6d13f5b603, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x5bbd05de090759b4, 0x120e85a4554b9401, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x4662eff714c01495, 0x022affd866bf437e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #0", 0x7764ac854e15e5b7, 0x5df2d47b4fc2579c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #0", 0x3b0e2acf269b76a7, 0x623e00f2172916fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #0", 0x1bf8b44d6b6a9962, 0x1640d5386c148867, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x417a309916598d30, 0x08562426316a6497, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x166dbf357a5c134a, 0x319396dd77b8612a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x3a4ae75e1dbc9cd2, 0x0bae172d11dfb113, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x26c3f686695644ec, 0x672b45141607ed3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x7e1659815aba0536, 0x7cc730bb6d26e67d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x28cfeaed1f273f0c, 0x3ce93e1a757b0607, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x45c2b5b322e4f23e, 0x0ca41d0563de15bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x0e4f8ba05848c24a, 0x4ff29e2461bb6a00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x6ea24f7b44b96574, 0x1325ce974fc9bc39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x3f1578be53303490, 0x47821d6305100eb0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x70ecd1627e1b04d7, 0x16efbfc37960601c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x677149c30c2f7e14, 0x0f684d5917b0c7e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x66e9834a41c0ec80, 0x04d7ae666587a345, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x60e82b8c67a6c651, 0x5b02a94c0fb96e37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x0a8bb88f438a2218, 0x739783f426aae140, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x1bd2e4621b8c19d8, 0x08664b4018db442f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x60457f4c30271dcb, 0x68a500680a7533dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x0357525c26750250, 0x0f85428d1f5af80b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x249007272823a580, 0x18bb5827744423be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x3453239410cc9a0e, 0x0bf4eba70c0150eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x528d868e4c8b9d7c, 0x7188f4301b3ca6de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x343263cd1e8d990a, 0x2af615163375b21b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x6217bb226286de9b, 0x5a20935b3ebe1c5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x7e12f873403e60f5, 0x5799608c7dea9f84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x70657ec017e515ef, 0x085fd3625e5877c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x3e5a1840166ec7f2, 0x7db36fcb73bcd11c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x3e926d7373f5e082, 0x6800f4db62ea1f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #1", 0x04c27a9060746482, 0x6eeb705272e59107, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #1", 0x2d0001fe39184cfc, 0x0e2237e65750011f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #1", 0x57a5e60664e64695, 0x0ac5b33a613265cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x476d25307789e2b5, 0x1ff0822939bda128, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x37c843aa4008140e, 0x37a840ac45801da4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x57ed29fe218c052f, 0x23d89564282dc26b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x37facd2103eb8862, 0x1bea93871647423e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x77e168e5681cd1f8, 0x793161a5768d3a94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x4891367a77950382, 0x6972cb9c7ca3e375, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x30ad507e5eb997ce, 0x53f3e49475913879, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x439fde6376b4206e, 0x56c39e4508533684, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x6e3e032379b91858, 0x4210d7ac0b0d0394, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x39c12c677465b69c, 0x508d2138260646ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x15f1bbcb6a1e9cc0, 0x4e34093911ae5665, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x6e0a25232126fa48, 0x27f598a34dec88ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x0943cc402dec8f1d, 0x4479c38165eb8e08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x2581929f36835612, 0x628f717d51d502bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x153cede01e29d979, 0x47663b34562ee31d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x14ddf9e72092f14d, 0x5e8219a158dccc44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x1a4c09a53476f110, 0x63e9cfd8031bfd0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x28dca7ac77564d11, 0x292243d8540d360c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x6174e9d20db12514, 0x65bb8c713ece6377, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x2ed81f5d5134afe4, 0x0cbaec634f7f0ef5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x7f213f0117fa0e7a, 0x356a9cfd381beb9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x4e7d648c5157298c, 0x09f0ee5824a2d1a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x6f8103055953ce5e, 0x7ad1b4bd63ba526d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x79e6bfab2080ee89, 0x3c971eb1045efcec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x54f7df99309d3dcf, 0x077af9f71432c951, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x27f38ae14dfb8bcf, 0x683fff5d7dd48745, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x5bacb0e3495dd71f, 0x3ca2eabc096874b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #2", 0x1a9287040e5220a5, 0x58e783a80a84d040, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #2", 0x264c2f1f4c91aa36, 0x42a0bbde19b3c605, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #2", 0x1de8d3c339284c63, 0x3e5697a674c993ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x127c1ac2151b04ca, 0x5883e6190d69d6c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x359bf3531943cdac, 0x11c8d3b50c62da6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x49e10b7b08d5a31c, 0x2095a3be0a93d2ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x56d12eeb450b44ed, 0x08685a3171d4965c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x0e691c0c54248eb7, 0x7b3d0b0f327ddfce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x6276af5c7fa36bed, 0x3d02b00f28fba310, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x4c351623010600bc, 0x42af691608c2de7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x3a2e4d1f56105841, 0x7d8c72286a1de9e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x6b2b5d0b09509464, 0x7787c0af4caa67e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x2294621079a2e60d, 0x590d424f20c7505e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x0278892933c37d7b, 0x2b5b234a6c756d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x78cec26859870ef7, 0x5e4a03e85949b814, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x2dab9daf48ca47f2, 0x0bc797e30737de74, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x486db3df72e2ea9b, 0x3033818510224d0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x73e8eb5716719daf, 0x18e52b8714a2ca02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x6c81f5f076487498, 0x7ec0b3e92e173876, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x7f9908fc53cee2a7, 0x7ac1a05857ad52fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x4d71c8b423cfc6a3, 0x7874a359222d6b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x5793441e6cecdc7f, 0x0ea2d8974fea51de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x4673eb7734fba1d5, 0x293409f250620686, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x7dc5e9c707cd6680, 0x5799e4fb741f8926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x7ab0511b1d2701b9, 0x0441d63146339da6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x33989f6859971b92, 0x5ad667a96e993c72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x4fdf902a17721540, 0x1cb074e8201a9559, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x6b40f7e7703c8bae, 0x77c7e8544f789926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x140c52510048dcc9, 0x71a6043238b2c09c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x6d35b94931d11c6c, 0x089d127a6b9f9670, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #3", 0x66ccbe42139b81f1, 0x3c019cf633a9a4c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #3", 0x1b68e8712c0b0417, 0x27c92de66492a809, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #3", 0x493205d0059cad59, 0x2ac645b01619398c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x5f33c8eb2162eae7, 0x04b275fe7ccaa539, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x38d5002714ad22e6, 0x1ce53a922f135915, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x04e9ae947031f66d, 0x7e8bf23b2415f80f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x707ad3366565cb25, 0x5cc8b8ab18f600e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x1736e7914097344c, 0x049597565db08c7f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x5432b63e39235f25, 0x115a313f7e03a5d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x652e633d0d5c938d, 0x62964ddd6f9b9eaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x12f940e60a674e3a, 0x05b4d83c2e60690d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x2bca3921481048d8, 0x2b2b0e46722d09d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x5cbd6bbf1fcc5521, 0x214062e6649f3949, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x0ffe4b8e657dea03, 0x08b5315861a71a53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x4ae3b5287f32b28f, 0x7a9d1b3900791ec4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x3fc9e6dc6f83dc83, 0x5e29ab44621a9cb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x28a73ba942b4906a, 0x601e428d13fc9d1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x501123f7094d1405, 0x03983bc90dd59ee6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x13b462406761163a, 0x3c3607f3630a64dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x2f715f127677d194, 0x55376eae3f7e9b61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x164426b52cd30602, 0x241dd4aa0c2ecad1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x1250f0056873005e, 0x6dd5e52526427243, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x67a5b2ee04e53c4b, 0x26bb91075d34a52d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x746918cf1f6d8474, 0x3f4f41e7276f99ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x622214de3f0472ad, 0x3b6c36e41d105478, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x485186b3671bfb51, 0x2ae5f35e323338d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x4e7d118b6a750c60, 0x153d9db25c05e8f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x60ecddf43fa258ff, 0x1b8484547dee709e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x6c755f0177f32094, 0x0a1d3b6f773104a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x606620f3442f07f3, 0x1d7376ec7ec64f07, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #10", 0x4914443f1b4a361b, 0x5bfaf434480bd3e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #10", 0x3ab7ba8f2ae7a48f, 0x6f7b6dab3d7d5d0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #10", 0x69ec173c0573a4e4, 0x5a8db1861cd9cf6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x6c8fa035644aa5f4, 0x4f0d0842323d9def, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x4ebfb25429c80b37, 0x0e4386e23b0cb1c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x696a643643185dce, 0x38fb225f2fac9048, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x3b0b7e6344510bdd, 0x26dd94f155dfc337, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x088013d130a10673, 0x54a6123e1b719f56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x4beb3c8e52f8e0e2, 0x637d733751945810, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x7de08571699f66a4, 0x0f11b51e06a2f71e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x6f130b887289cece, 0x237cc68b67cc9cad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x56d474c2284dc17f, 0x1a0a3a9d5ba2abbd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x5215ccb64faa7fdd, 0x16af5d7e25942717, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x12c2ddac7c1e4c51, 0x5540b75f3b8030ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x406f582e66060662, 0x115ff4244dce5c0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x16a70cd54cbd6e9c, 0x693ffb6548ef6bff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x1fb64f7e2995792d, 0x1a83c40f62924964, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x1334dfd10cb2070d, 0x693540821d96d4ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x7f3bd5db1f6dac39, 0x0563719c0247eb59, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x47bb6db97499f495, 0x5dea971756104a9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x4444747350e52914, 0x7ba471b519d13a6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x4d03756566b15f80, 0x55516b5c5707521f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x4cb765e20e15a993, 0x24d5ae2e0d72cd94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x5ad3182f70e5fda3, 0x56623993635e72b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x1a7b76d02f25fc9e, 0x45f0bc1c7a8967ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x3bd803ab1d83ae38, 0x18203c9c2db056a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x3cf15a720de2d912, 0x2ff841fb3b13d987, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x027ccda80cc895da, 0x1124242504acc82b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x5dadbeee73cf6df6, 0x1e7e029a46c1421b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x5a80cd76429e4268, 0x1dc8943a2ab13454, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #17", 0x50b3ebfb0e863b7b, 0x382401e827383359, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #17", 0x7f6c391e5087622d, 0x0a96a6112b87042a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #17", 0x7fad5ecb3e30a873, 0x26106bd719e7afef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x5bb456ab7790488c, 0x479806913b856276, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x0573219f07bd6022, 0x76993bfd18a5b11d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x1485f5fc3bd07be3, 0x1d52794807efef47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x2f9fe9d96c79c59c, 0x4eb131627233b4eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x2f1808045508eb27, 0x1ce4e93f0a20b750, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x638f26a23bef90ba, 0x3158eaa97fcbf3ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x0c76f2e751636400, 0x2b52f82962fb5fc1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x0f940c73447b1641, 0x7ce30fb00c2451b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x3c0b5ecd3e42f026, 0x47a9b4286b48631e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x4600504821408d84, 0x03ee143c417e806c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x5d110967181fa115, 0x496e6fb35a864645, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x049966b1699ee46f, 0x4cb9fb300cb0f341, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x3ea7cf96482a953a, 0x16d1aa9133b16eb5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x041a25f45ed05add, 0x337d62b42236f638, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x3033bedd021565a9, 0x053255f9109118db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x46907bea645f1eb5, 0x1cb56a8d3fc7cb50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x22a20edb2efe42ab, 0x2b102e6f029bdab8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x503ed02f0d88cad8, 0x441a5b2468a25f24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x25a86bed0fe2a099, 0x4328a5692d4fd997, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x7981850850d27769, 0x3a00ccd82a41d29f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x18fd0ca31170a409, 0x5df341543829549e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x7040fee65f92a0d0, 0x5a604ad61d173297, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x61a806794a5db5ff, 0x2da84b722074bdc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x2ebcd4b40b4cb783, 0x603c891428388264, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x3a4afa2e6eeeb840, 0x2ad45d1c515ee390, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x7c7783187d29e81d, 0x3a0142b40a89ca5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x0d0c88b671da70cd, 0x37d9a3f5221fef06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #24", 0x42ace8362a5502f9, 0x4c61c1a5068e0dbe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #24", 0x3bc5a7021917ad32, 0x3eb7625c5ba9f4d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #24", 0x78aa4e02266972e2, 0x78c127702c06a5e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x70c728e12cb7ecc1, 0x4c7b63ad5a52547c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x3804a4452d5f33fc, 0x028ad6e01f83fd95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x1c4dec3c2ae423d9, 0x70e2e125724f9e73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x280e0bf634b30cc6, 0x7cd968d118c56f55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x268d7d9307472000, 0x3ae55e5b351a94ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x319c22f97a6004c6, 0x3ba8a26a693a65c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x1377b1f93da58212, 0x44e45aa26d61c9fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x640ef4f465e3d392, 0x19686fe50c21fffb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x129bc05368ff2b57, 0x6674547754d61dd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x165e5f53653cfc90, 0x745a1b6b4aa06498, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x1021206a39c96bdd, 0x3cf0030c32ac4b90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x6e7c78a406571940, 0x4b71bae5382f2c60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x0d9e394028f26377, 0x6d49c10d1509f637, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x2352683e4328b6a3, 0x7e445c013f3a5c39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x00ce38b64604961a, 0x2c9c263536ca1a37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x2be869ac29606eaa, 0x42ec1a3264dd2daa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x125f9a012e0d66eb, 0x39b34b803e842a00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x134a637b461491a4, 0x09248e9828bdf955, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x7fddfd8226dbffca, 0x5b6a44e5236b83e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x2d33190a48e47153, 0x5b9ab0466e5a7626, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x71d6d4ca01a8c85e, 0x03646c5d3ad1524a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x44d17f0226a7d4b9, 0x7a0bae8315293d08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x6cac6ad30edf7172, 0x4bf3573f459fb7b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x383fe01c643030e2, 0x2a7ce5621894d480, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x123d97cd603d8d18, 0x5718fe804a9f7a1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x26521ebd4ec7b857, 0x735d73722587fb49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x75a3b821248e2f74, 0x48f37f2e26301c3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #28", 0x6d72a0c717eefec2, 0x148a926522d6d12b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #28", 0x1997c72157b3d1f9, 0x5da823755f497592, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #28", 0x7e5ba6b2406609da, 0x7472b29a5e694623, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x4f457b4c4e85e33d, 0x2408fddb6b081185, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x32b614205ab5e485, 0x039ce60507855b68, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x3af3719e458248f8, 0x5224d58544f3abed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x144a014f336f2665, 0x6a7ba7366145905b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x57fd55d91c003eff, 0x0775ac9a09edb971, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x33ef3dc10a6cae12, 0x2cc48a9c456ff6a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x6220800b192c1ecd, 0x24b96c334d8704e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x599228a74ff948e0, 0x2bf04b05607c26bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x1e7f2c1e4f211e48, 0x4b84384228d7a3f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x29d702cd0281d4e1, 0x305cff5b5135403e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x48041dd900a49362, 0x1628ec2b64ca746b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x3413b9c74d85b160, 0x461004c65c4e1f28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x6985f05f13006336, 0x663bd8990c110fa0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x1d6d1148763a7274, 0x518106411d752e21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x0f66914216ec7e09, 0x6afc33037f8d9153, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x66e5c6e92b8df052, 0x6009b81068f8b9e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x7aaf0e9a422d5d38, 0x11d05ddd0564f307, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x44af32196cc31f71, 0x569a334524861168, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x6d67b2d34f608a9a, 0x095085d30cb34ff2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x1ce63bfa4f3d47b4, 0x69016f1b217b6c9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x623daaea7f0d827c, 0x2d8c7c3a066c2c5a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x7547f4f00edd8d7e, 0x23e15a7b7faabc32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x25ca0b875f420595, 0x7f384d8504ae8632, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x0acff5e87f779df9, 0x6da7401c0cafd271, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x41a4fb3168aef8be, 0x1214c578057f0482, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x5572182f33559bbe, 0x2a0515ea06542d4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x02b626587c08ec58, 0x13077d3d42d9cb02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #29", 0x4b46340d11e1b3d6, 0x6455379c1f9c6252, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #29", 0x10ef365249e9e927, 0x26088eac2d83def7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #29", 0x58c776a62c66e8af, 0x2d2e9b2a06372b43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x0ba8ee45788cf191, 0x0ae5b1757e91822d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x78048f8a1d561a17, 0x0b41549e1678e42d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x060512d545fcfe9a, 0x1bf7e8af39a98abc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x79529a5853053544, 0x3ffdb8075b772b04, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x4f0e219d02a62da2, 0x1e50f6067c08c0b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x1487e17841adb1af, 0x1ba523021a5455aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x0b979ad67506cfcb, 0x47d834a1257717cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x216db87b3693f483, 0x2bae430e645f117c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x2f20e6156e31e848, 0x62f093aa2d16a6c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x0b88025f5f87739c, 0x438f8aed2725759f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x2584723620ccb862, 0x60cf005b118d1534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x73d1eda70b55363e, 0x6d0440381ed70c8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x0dfb63e03684f041, 0x1adfcd3e42e00f44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x7832a1f0250c998f, 0x5d3464ee22834559, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x1a13695b73a8a032, 0x47fa5d2403ca3cc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x2a3c94b54b19e1ed, 0x68294e433b8121d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x394bca352c275383, 0x6897c896595d7aca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x0baec71f6151f0c5, 0x0082f06a44d3cc95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x021ea92843652202, 0x5660e1c931333956, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x4eba58406aea1323, 0x500a45e475f096cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x216f036416050b01, 0x38d0a6135cb5bc21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x3b11a49047335e9e, 0x7f39017a19a1a554, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x3adbfed00595305d, 0x1d6be21a55250deb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x50af124a793df857, 0x10a62fc165189385, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x25654bda3ef8feba, 0x3e760e5009fadc80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x204aef7f252f8ade, 0x4ecea915311412fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x6894ace032519234, 0x62474c50226998a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #30", 0x1d3ba557512ad589, 0x185a2f76374f0521, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #30", 0x672fe08a133dc2bc, 0x1404c1423eaaa8bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #30", 0x5a71215a75b8302a, 0x584c4e0f2241851b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x7b4d6087080cc2c8, 0x77669306154d202a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x014abb1f38dbc1ff, 0x7a65b3af4bfc72d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x77d4c0b924c5f867, 0x55f74f5226b006fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x49f583453a0b6644, 0x57c419f4181fb039, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x6c5cf87852e37857, 0x3a8948e0328a3026, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x240e4de07dddf689, 0x69d9354709989dd0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x111bb945208f949b, 0x4843468b0b3e2e6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x1647c4c524e6468c, 0x2d7fb3866b8cda9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x2cf309547b3fae78, 0x00d9fac91195254c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x341b70783388e770, 0x5d91981e2e3dc474, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x584edfd72cb1e562, 0x54edcb6e2bf03131, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x66bd4ba67e992a4b, 0x440fe16a2244631d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x517ca2a23ea7c88a, 0x54ce9343531a441e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x3c85bf1324f6287a, 0x5cb2e1ee758af082, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x4585bd152e48d273, 0x00c91eed4da17858, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x532f19003a084dc0, 0x392e52f75bcd81da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x3547fc384af43f45, 0x6d62a72600222254, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x7e7d26b5034db236, 0x2e5fe6c869636cb0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x2fff979859637f4c, 0x15539de256cc068d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x57fca9974ddefced, 0x791069aa16bce33e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x0c86c577468a094b, 0x69d7275d29794c39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x6b8031c51fcd5ba9, 0x1f043cbc490c848a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x4e162e1d4fdc4fd9, 0x16adfce23105eeda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x09e49d997a3617db, 0x0cd370b42145471d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x452a57204fc7503a, 0x216769713f2c99d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x531502703de3a464, 0x2890068243a77dd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x174723b01383ee0c, 0x1a73846203149a09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #10, #31", 0x6162eaf903a8a4a4, 0x19d17d476f43cd48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #10, #31", 0x4a32adf037c1563d, 0x18bd19816de9b070, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #10, #31", 0x578eb1e74da431dc, 0x36f634fa35b2dfb5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x1d8081b5738c3f44, 0x66b8ce9025a4e004, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x6dc2571f68519092, 0x46ea272127651f4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x3818e0cc0f21bfa2, 0x6691b92032ecae3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x4d0564061107b077, 0x76942c150b2de33d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x248b9e842813fa8d, 0x0e427d46644c87b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x2bbc9f326c4d6e80, 0x539054fe05ee897d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x240ec4bd2ace6ee8, 0x73d839ee75ef4d22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x7872a0c5125afb67, 0x2ba22cd77b9d76a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x05e73aac682c7dc9, 0x214256a815f3227a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x507e0e5c23e9fae9, 0x3d5841c973a991cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x330bba8b1d2a6c20, 0x2696400b0896ef28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x2e321c9722074fab, 0x13c4d26500111e91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x4a1b4a3937edfb46, 0x645da64752bdbb1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x243b69c64c847e87, 0x58ac449975d7e96b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x7752ed6f17696364, 0x6bc7368d484a2e83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x29c45ecc6529fbd0, 0x43e7a5286fc58e34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x4d56799a4310f278, 0x05b8b0af2fab9978, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x66faed6149eb6b4e, 0x23552b431dd487f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x6715d76e3a304984, 0x266b771e1a06a7ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x5c37992f7e756cc4, 0x1a17c67d1547f406, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x3663680a40b1f3ba, 0x6805af212652e368, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x0d36724107f20360, 0x1c2accd35a9ed1d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x1f5b66c566d0a57c, 0x22e9005404895fb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x4bfaa14c7a079e94, 0x744eede5491fc591, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x3d18910c1c208a4c, 0x78cb5f0919511ae6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x660bf59b5d9119fb, 0x3725a2dc24137e6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x17c1637f5831ecd6, 0x3e1a26594d21cd09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #0", 0x56a7599b4a6f7031, 0x6269c10f73f8fcae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #0", 0x0b2163eb3676acea, 0x1a4be0170d0ac1a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #0", 0x3e68b04b0a9293ca, 0x67a993761857d62d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x71633946113023c3, 0x1ce135de5dc41710, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x0b37c2581faf3baa, 0x26e3dca13d5dda92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x3bcfc5f60dd49855, 0x56aef57948505364, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x6b65b2502a7df82b, 0x6c63d1d221dbbb91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x02afe502516749aa, 0x6efd889b032715cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x1bd6b9db116bf295, 0x7720127e59573e9d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x47e29f7f4e0b93b8, 0x6662004226f81dc7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x589e27825c3129d2, 0x3f4ff3f4064b4fca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x6d614d950af3437b, 0x640f66da4a0160c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x2aa27f255e0e30d4, 0x075f3b5b78990fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x6be2c9292d4d3524, 0x40e963526672451c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x57cb2d4f774b8948, 0x084e00ad57487b7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x48b2d2f3518fa3c7, 0x5a6f91495a7b1251, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x62fb965c1a345131, 0x33d250ee64898cce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x683fe4e94ad19e89, 0x0b81aa952ade35dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x2702c85b1538ec81, 0x312985a640de0c6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x202c2ffc123ea88f, 0x0adf6d34146415f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x704cd9634de68930, 0x0cfd25de4aceaf22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x7b33be54398ef4eb, 0x3140f43e5c2fa28d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x30da7e340de7af50, 0x33781e0752feeba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x5f775318614c4ee4, 0x2d79fdf5798d5127, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x7b80a0156998888b, 0x5e16ddf54272e974, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x346a27141e7aa4f7, 0x6d511f5063c084fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x33b391782f7dfe9f, 0x249e916a5b6cef70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x41bca72e7cce2b3f, 0x6fd1056153dfc174, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x4ab4b4704fef64d4, 0x1eae709632098092, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x097e59c041b14126, 0x0e39231f45e872c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #1", 0x4f98f07646615c5e, 0x18e75e683a58d7f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #1", 0x27adab4211fd0710, 0x33e6291b2f10438e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #1", 0x7b958f9b5ed44c53, 0x71832d03232e4b57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x7d4ef14a2b8d61c0, 0x06eed0552fffb6b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x5b0b605f7b3dab81, 0x0b6ca620310282c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x780bd6c02390b4cd, 0x04e244371cc8078d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x738019a25d0aab3e, 0x4ed1881f42c08b30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x1ebbec6421905c5d, 0x08a8fdf57cfe7362, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x67f1b8bb6b3d7471, 0x37574b566e54dcdb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x7d3a7b810ee84d6c, 0x1d6520690f9f63fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x6dbc99c039bc7faa, 0x32cdaf5478d00b1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x6549e16a343c67ed, 0x28cfc1cd6b0b8b0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x2f7a136e20f05204, 0x1c0e0dcd405541c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x448106d12beed176, 0x5d1d49562785ea2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x08f97cb472ef7354, 0x6a46755f38012073, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x147fcfb16c56df2b, 0x34ff93d527b56919, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x5794539c336f665d, 0x160a45f47c71886d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x4257b3ca3ede9bbf, 0x0c10ec6a54cecf1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x789b1b69766e9c08, 0x4d9eda3b30144d8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x2aab03f5372de661, 0x1b1fd8945de4fcd3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x581e38657b5787f2, 0x1e3a3e9c5a251763, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x274659686bf176f0, 0x01ab01911c9f3f37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x5ee0ea44099ff380, 0x54a05faa303fd61d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x75f6d2ab6dff852a, 0x57f53f367360b9f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x216eeb877be32ecd, 0x6fd242634d8b2648, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x3ac1ca8c6ff8cfa1, 0x2259f56663c69f51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x66676ba92efac570, 0x13daecdb335ce5f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x6628abd12f7c2164, 0x1141e2c811126f9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x2ad3a9576ce28892, 0x6b3787013e46e437, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x58d3ff832f868318, 0x5ae6236e521a02bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #2", 0x392676985a4f1812, 0x0259d8dc37b4e9c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #2", 0x484e9d3c1ae7e620, 0x2b15a3bd2f1d4944, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #2", 0x16cb14ee1f0264f2, 0x7ca86f8c69bd88c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x0efb3493615f14f1, 0x4d842815518cdf7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x1059da61162ba838, 0x04e9c5707562a03c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x45a7c99d71ac96db, 0x06750fda76828632, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x5e8f1f6d0faf8dd7, 0x34c96a69707b72f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x3f3610f044ef4e90, 0x429575b337631ef0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x1f3e66a21a2dac75, 0x6f1808b8785c8788, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x3515929624224058, 0x2779d0cc678d03df, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x4324a54a1eceb4b8, 0x514a8ca34be0a784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x002dc9a922574c6e, 0x1d6d86fe521fd9dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x3882f4a74df789f3, 0x47827a191087a40a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x3fa420ce3bd394a6, 0x070a2a3d7e2abe44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x4b83227e313ba6eb, 0x6ea631381e33403c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x762af57b44ae67e4, 0x55965f2c0ab9336e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x5edc145a2a8f8bc3, 0x0315baf615695c1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x4eb1cc1b4e40eca0, 0x7cf65ffd13f1a6f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x6d0fa1587d3fd572, 0x5fd24e7411d67166, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x1f9721e12b78c55d, 0x63f64b436d3d6b02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x79704f5004cf3949, 0x7dc50f0c581a1688, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x40a2cdf044eb0604, 0x5644d4cc3914701f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x7626acef2cde0f87, 0x5747b05b0c25f06e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x718c776c19f4ded2, 0x16df23dc6c51a26b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x44846a957eb15e86, 0x01bafe8950688bc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x4cf24b26442c812a, 0x645a32b6133636b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x416c569c0902f35a, 0x250ca8173a01ec7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x347bb8b72504668d, 0x273f57806103787d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x29d39fd60f6263d1, 0x391d8f052dec0808, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x544d69d53e482882, 0x670078276a766dc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #3", 0x6b2638090d7b8210, 0x769c5e344a7416c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #3", 0x277060e33880b7b9, 0x36c5b9305cb2af75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #3", 0x3732163f11756df1, 0x2d1b3b3b6bf4cb78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x55a1ef1b2437aa40, 0x7f2b022904246165, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x2d3a9d9b6565a564, 0x3e264de3170e45b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x0a6a0bf1312f4d3b, 0x7811be3561b65652, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x4091b10c76a2d681, 0x0fa25e5a343dabc7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x34eaff03155077c2, 0x1eb4198e14df1ae2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x22cbf9d31618ead7, 0x5f5331a72011370d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x4e99a29029df21be, 0x7cc3e6824a3c5ab6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x3b548faf355c2858, 0x3631262e05cbb8cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x5993d29848166817, 0x09f01a3410f67ecb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x2d7c0d7b201682b8, 0x2804c48306ce7033, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x5145cff3782724e0, 0x6884c68637e6196c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x6ec9fb620ad7dec2, 0x6c23c53411d78100, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x202856840609cd89, 0x26b69be223b4fa65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x1c22b860408a17f5, 0x43c6317242f45057, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x6a6939b34361d13c, 0x0d30ab0d6abc5af0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x78bdf9947a782df3, 0x708813bf25bdc962, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x428e960a5eb90cb0, 0x36b4482d5251cc2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x7ecf8f6941a502e6, 0x59203c60700aa386, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x39cc27c614148226, 0x27f0bcf250155f5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x1eec60e808a37c3e, 0x61ece05c28962328, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x0ead49c710114f00, 0x4c4b1d8e3f14b76d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x509b66f50f39b2d2, 0x020907c42ad00227, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x529b840e061470d6, 0x158c5d173b04a0a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x008c9ec91776b238, 0x60c26a0b4b597da2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x762fbee976cb862e, 0x1dab49ce431b34d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x387089145b16954c, 0x3325d85a74ff4e52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x6f2b177327018e0b, 0x4514adae723cb0db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #10", 0x2fa50a49671df191, 0x1ad2d4030e17785b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #10", 0x772f40924f35378d, 0x4d2c2fc83e525411, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #10", 0x5e6eea5f7eaeb350, 0x6922563847caa787, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x04c324266391b23b, 0x02cf4830310a6e6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x7b0864731a0f35dd, 0x7c63ec0f054fc2f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x10dabc0c7b90d01e, 0x486af7c47138235c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x56a7656a2b4c1f5d, 0x663771ae494b4520, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x524dad68565ac9ff, 0x3b87f5fb45d27cdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x3d78bb9021162501, 0x53e9f53901f2b7b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x704b5c8e296761fb, 0x40450bc234a7fc22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x2816154b7f41ebda, 0x7c72a3aa4eba46ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x62d39e157c28a169, 0x7fc4b55a2cd93971, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x1637d7477a93f425, 0x3228fc615ddc0288, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x7624c443354b9793, 0x4f1425e527129353, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x6097b6f02be5ce6f, 0x705dd8734ccc29ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x0240986e66889bc4, 0x129ea68b32e56458, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x079ec0c6751d27cc, 0x34d81c0a3fb953fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x1e8489c770d3f3cb, 0x7461502177ea1d54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x7015dfa54669199c, 0x46a46442469a9f12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x4291bb06259cd4e5, 0x7373d88452e97dba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x2030c90b7fd9a627, 0x30c5804258c9924d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x35253dbb7039fe13, 0x7fdc25a016558d4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x1c1fcc8275c05d88, 0x6321b6fc15bcf4ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x5c48f94c7d7a750e, 0x48a259041e6064f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x72979cda527b0910, 0x5e19b8ef63e7ba12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x434efcdb22763ba9, 0x5bd1d767111c26a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x68df55454b2a9e38, 0x57b6c5b43364dc80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x70c7731e3713da7c, 0x064e5a3a2b71104b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x36ed80a40416c838, 0x043aa29810f83c29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x7450c64c0a6f8074, 0x274dc9776c12be5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #17", 0x002fddfc4a720c0e, 0x01cfb30a107092ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #17", 0x47ec811c0ceab0ae, 0x2ed0f7bf5c78d748, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #17", 0x5f65b9be1c3268c2, 0x4060915b3a841df7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x3ea8a46b23570a4d, 0x4ba0449922b4b699, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x6e81a8865c67ed53, 0x561993192787f9b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x137bc7cf5733ac94, 0x52f909fc5f491ba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x5b4a74cd178f2144, 0x704157cd4a694873, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x21fea1b8384bb9dd, 0x367c06d24f9b3b19, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x02bdc5eb0edcc5a6, 0x600bcde7222e7fb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x1bc776543f07e858, 0x7ea756fd4aaa4708, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x5b3a511a50cea998, 0x052e64ff7b2d3012, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x7425b3e573fb79c4, 0x1de1e6ab19e2f585, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x506367171463f931, 0x416aef3562a75c6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x6b97a5c63231cfdc, 0x41f0780f63df2ee7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x49c0f12164c47e2d, 0x2e48775a46e21a93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x1d10380a76892393, 0x167d55ac6bbf92d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x0565e93a0c95698b, 0x0dee128e1fcdfdf5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x4b9d51e36fa6a9fc, 0x6a7844fd212d5f8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x407553943a3c764c, 0x1c5a8fa126d7a2fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x2e37f011022587b7, 0x40ba9882349b077a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x168980e95932dbf5, 0x174263e57e9b5728, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x0b64abd110c2fd6a, 0x627a860f022126af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x75877b975f8096ee, 0x4903414255259cf2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x5609ba814ed3425a, 0x40e52fcc1297b3a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x5b68abe51cddf694, 0x3265b1965b6fa3bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x0c84a09018f792eb, 0x7c9d034a2705fdc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x533409370e983947, 0x4ddda0c54cf9f425, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x10bdc0fe18d75f84, 0x0194fb9f016bf948, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x720a3b796281d680, 0x00075071274741e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x7344d3ea726ba9d8, 0x296868967d6ee74b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #24", 0x51ec40c61379b409, 0x5294843d68cc4f81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #24", 0x624cf6632dc9b4b9, 0x7b64032227f5fb48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #24", 0x4aa7ab4d0002a24d, 0x03659f033db5a248, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x18fa3538329940d5, 0x64bba010572c4bdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x41317a1c25bb3ba1, 0x242640026c2e3e70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x3e929b266da18829, 0x6d9a37b851ef3b1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x50235eaa229ee599, 0x79367d02309cd69f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x150a8f7100a04228, 0x2e0bbdea43683294, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x1419f63127988538, 0x2c34821666f6d038, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x556239f112526a83, 0x0eeccb807666ec95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x12550cd118d82eee, 0x341c8edd2009e53e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x4b716fc31b5c711e, 0x7736311c2b4f4209, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x4117acc00517b832, 0x177d80790ca2e9e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x72b9405b57c8a1fd, 0x5e9224fb7faa47e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x7a6787965e52dc70, 0x30471e8542dc9f05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x5ef31e98327953b0, 0x0644d19a0f721708, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x5a11d8e80555b2c0, 0x7668e740730d14c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x17a81d431d90903c, 0x6974015e2f7412da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x3668bf2a46b42934, 0x4f7df81829fd2a14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x62109a536cc9ec97, 0x554c6c1e01da2eed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x71e1a4c96d0f3dc8, 0x0e7d18cd23284713, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x44d7dfc65319ad7e, 0x22d28ef9649ae525, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x316c89ee2dbc55c4, 0x2777842a3f3f675c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x6035a974451a65a4, 0x4eb17e64105fa886, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x4a7018646ce0beae, 0x036cbd503a47825d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x0a714eea39398d4f, 0x69bb9537621835a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x7fedb6846161cbda, 0x0c155fbc40da0e14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x4e2bb872513155cf, 0x42b43d0261fe50d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x3e40939827f926e3, 0x052697ea400d5d3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x7b12d4614c1fc68b, 0x24a842600318735e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #28", 0x79dc1c4f1109591f, 0x4257daba2c7f5e50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #28", 0x5623bec3404bc426, 0x3cdf06d65a11c5c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #28", 0x2d2c82d57e14dd58, 0x145948212093d728, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x374e6aa70ec16c8c, 0x02ac0cd0379dd1bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x702338673b2c1cd6, 0x7877dfd4373c212b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x0c5d72a51e6109ec, 0x193a72023e4ef0d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x465a30cf23049075, 0x7e5c4e144a9e063d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x6f245700100e5456, 0x4db6799b416d0531, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x2117ad752acb6a57, 0x6dec63816900734f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x6b172e7e576b8134, 0x43123913773b6c38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x55805e8c1a7b5030, 0x17cf43601843b153, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x293cbcbd485962e6, 0x4fe183120ccec934, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x03857fbc5d455c62, 0x440aea5f195ff524, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x7ba6664e560b3411, 0x57aee5fd0fe2f262, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x790fc4862837723b, 0x5a80f89f4200971e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x3845c6917159ffd0, 0x036d9c4f68341b86, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x1c256a271446c7e9, 0x51348ed6595d7406, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x6bb2491e6868239f, 0x5098e03e073c98a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x02e373cf6f61cd0b, 0x1f8049f84132a7aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x37bb2ff1120c5b3e, 0x4e0170de2c20308c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x6f51b7a01d2f0bad, 0x458025b03b40afae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x733a3fbf25a49aaf, 0x4b23a2106af81dee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x4ddc0cea3066515b, 0x2cf8b50c6c4a0445, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x21c0512b25b2aea2, 0x547e1fcc0621d37b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x39f9768b301827c0, 0x5f7f47813de5bb53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x18804b5f64a29df1, 0x452253f825abbfa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x54046afc34dfd832, 0x66de67541b63bf2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x46ec33700d04156b, 0x4783efbb0bbf9aed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x2a3321191223ecab, 0x47004a9b363deb10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x37c8875b4e2ebe0b, 0x213608ff1d6d60d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #29", 0x7e950f675e3584e9, 0x09b7651d05a49445, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #29", 0x03e8338b6b45af42, 0x0bc667c120556092, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #29", 0x1b5dd702235d6fde, 0x5e3b1be53de1aa17, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x08000dcf4a6bd114, 0x638d69c033de2261, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x7f4ba94716c5d14b, 0x4f41e1905c0478cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x23c9e6b62ec45e54, 0x67c413b84637dcb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x40e84aff1dabd0c7, 0x7c75c7c84dfd07cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x6bda8ed27521cdc5, 0x6b6a68a778b0d25a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x535752ae0a1bce61, 0x7e5566a06a6f9e39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x75617da369001ab1, 0x0ac4fecc573f863a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x0c5d8a8f78ae9a11, 0x1521305110bf54a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x431a6b2613df5897, 0x449d7707145d985e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x2aa529e2582624e2, 0x706211294266146d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x06ea83360513b8ec, 0x089df1244e6f1099, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x22bf89b307d68110, 0x1c6c186847d2ce35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x7cf84ed53ed90730, 0x4083a0900e9a1886, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x48f4d59103ceb58b, 0x7909b6bf504fa183, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x6cced03d3cb0580e, 0x278f27bd3e565334, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x355ef22013b31ee2, 0x4f15a7da792c5acc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x279277797dec0454, 0x0d89f32b78795d46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x56122936437d62d7, 0x3adf71b35237a15c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x48911bc43d12ca5d, 0x20a6b1f55cfcac6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x44e94b6d65531b32, 0x24cf7aa26b50a577, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x242c226272f474bd, 0x79eabdfd41e19a42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x76c32a4839c06383, 0x12313bc66d20f7f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x7670bb927a8cf302, 0x2b774b276391fa85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x0e4011e46a48487d, 0x5cbe55522bcfadb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x68344cd15f287cab, 0x24490af835d2895d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x22a5df8228b0dcae, 0x080a2ab93e467608, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x65c3a70c40129d16, 0x1b4322746b36fb46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #30", 0x2565b84850725ebb, 0x5687a0be2aacf279, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #30", 0x4366d3787ebfc882, 0x6c8e8cbc4991daaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #30", 0x38802c05622a1dc5, 0x36b2d29d3a29fdc1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x5cb710c77a7a4d98, 0x1dbbf8462ef0e797, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x64c296157f09a041, 0x5ac095496af722ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x5e321cec28d3d6c2, 0x20c9ac084cf6e2e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x5184b37026807b63, 0x0b3d58ef00d7fc6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x6693187a42969873, 0x6c0ef7b537485a7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x1308f72f4e83d9b2, 0x61f54cf60bf8d0c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x4d43a2340c3d7e0a, 0x558aab6d566fcaa7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x6e679bcf2e55c0af, 0x1099c86805c3ce39, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x28d00e470f754b1a, 0x34b4b5d14b1eac96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x0e7eeb5c56df7b4a, 0x3615cf410d92a45d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x7fb3520c65c6e033, 0x5a8987446cb10848, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x0c475b965997fc6d, 0x6d8904b75138057c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x1c2e94e06a75acef, 0x08805ff972da7410, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x38f986a1545df040, 0x7ed344d32f378c0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x609b6e4a16411f1f, 0x05a756b7063d28d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x4496dfce40b5acdf, 0x0c00f70e4f030a1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x502af7fa503785f2, 0x1a21b6b06d66ee16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x2717013c558319b7, 0x7af992735ea9e356, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x3b49f9ea38e3f056, 0x4b5aeb9e26ca5348, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x127becc30082b8bd, 0x780258c447915580, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x6af865ac393f0e64, 0x3a6bc9912eaa81a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x0d9cfea46389646a, 0x5de20db323f1ec4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x79ca838936300c31, 0x2a2f15226e386cee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x76e5b910575d2db9, 0x3d3b77083e616358, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x2794b3ab26c1e3e1, 0x2bc8516e4710b10a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x7c44fd9871157fff, 0x25ba94604eabb4e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x29f970556d7860f3, 0x7576082f378ef782, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #17, #31", 0x6dfb19b1398c1693, 0x7f204d023c755d18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #17, #31", 0x72cb24f74901ec6e, 0x6b1fdebb58f37f5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #17, #31", 0x2c8b50d8271480cd, 0x7ce56bab0068239b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x5d448cfe2bdc0792, 0x6ea0908a2655d462, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x0339354b107f8928, 0x64b737ba542a460f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x37416d0940f58b7a, 0x1b3af7192acde8f6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x320b0b796eefa60c, 0x79799ddd33866aa1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x5c6807006a35af25, 0x6b1562235c047bce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x23c1c5b90399b7a1, 0x1879d8e64a6320b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x4c9ba410203c0bb9, 0x2356a00e168ceab0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x47508c8705959ed6, 0x16f50e4c7926f4e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x3171a66804340104, 0x1f7cc94a24951985, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x14b38a2c13fa56ae, 0x78bf5f9434aadbb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x54efe22858f26288, 0x5f78c4aa4bf4f735, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x47e208946a90c3f9, 0x7f7b61d606faeda1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x54c6731f7b794255, 0x62ff696f244a0f94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x7f12f9f61203d054, 0x6ead3045788838d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x323fdc0d260a31d4, 0x0f1523884bae9e06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x2b9fd0aa64525c39, 0x44d592ef79906894, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x68865d3e16e4e1ae, 0x1e25821a5d117713, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x2adf385c71351771, 0x11bc52c77d39e76a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x4a2779f948aa4076, 0x492edea07fcf1a84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x333b047069c97194, 0x06ca08251209828e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x6542b3e92500c268, 0x365392220801778f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x370492bc0f9ed3ef, 0x0089b0676455ade0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x35a905c474d9ded5, 0x30044be669446ec9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x592c3b0f00fa5978, 0x62d4d75e6148d66e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x17df3b265016a048, 0x3e5a4d8141b2984d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x414bb7ba081b5e57, 0x3eec7fb742be7383, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x50c59ece4957962d, 0x428d8e070b7331b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #0", 0x332107c153d04664, 0x1d7cb4410400a33e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #0", 0x78d108cc0c8bcb34, 0x0c021acd1863bbab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #0", 0x1c2a9f232cbdb571, 0x7cb9698b2fd59b88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x219794477beee1af, 0x191a0a5151d3a4e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x7ce93b277176c8d7, 0x331c7b567ac3cf56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x418d69207b62e75a, 0x3c7667a314c8764e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x037e45b21a1477d8, 0x5786e9d102d920da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x636c0e052bc906cf, 0x0e4c528d5443e480, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x7f994d336446a28b, 0x584487be168d15c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x70d26dbf2baa3afd, 0x2ef0d172786a55ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x5867f06e4159fbd8, 0x283ff1870cfd0ce2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x3d48dd8811ed2d20, 0x5ed0b1ca79ff84b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x0363f5f73139bbae, 0x74c3540b3a3218af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x2c9ca309268178ce, 0x4efa8efd44f15f17, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x4095f0a75616d27f, 0x47ca7ff1301ae8bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x01dfd94e5ca354f9, 0x045ecd3b2401feac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x40e9f784697fe5e5, 0x3a8f147301792681, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x152a20e222236e07, 0x79e37c8031bc6543, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x637d69df1d8a23ef, 0x3eb972256d921151, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x2f77510f5c54ea12, 0x6791960620c64767, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x0d8ea5c029f2ef14, 0x5af8601732db4707, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x507467e33f972610, 0x77cca61e3a2b48c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x15adf88f6ea4febf, 0x6a463184110a588a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x4b4853b86f9b6baa, 0x350c5736178dd1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x591b518f12ea74de, 0x1906f85e0c324b3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x350de2e57ca822a5, 0x3deeb07f6e457272, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x1a324694436919c9, 0x5bd783c3188b4cc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x1fbe03db1449f443, 0x3951942c49a997a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x3e3ce357745184c9, 0x7c84deab2d4ca99c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x33e8aad951be23ea, 0x6777f2650eb14b3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #1", 0x406322a954c7fafb, 0x1fbba3c44996a368, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #1", 0x446366a57a2b6da3, 0x612475450bab7662, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #1", 0x0d15e28155cc721e, 0x17ddc19e1d7eb834, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x527494c3679bae69, 0x0bc42aa64223c566, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x2b04c8331400a657, 0x5aaf122b6ca6db57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x284a9a9a32d551a6, 0x365072fb4ac2cc0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x2726d6705f876810, 0x780f75aa66877df1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x31458bfa14f46cf0, 0x7538c92c5b0f8149, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x69bc67eb05ca99f7, 0x24a624b271a8aea3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x7ff6079b1531e6a4, 0x7d5425052e1fce90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x6afe58c25762b16b, 0x4b9e86c50d0bea1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x3efe5fd529dec1ae, 0x4f2faf833d72ed85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x3ddf6805606a3bd8, 0x2a19c8dc6a032808, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x133f8d7e2cd569c1, 0x34c5f416662a029f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x0c5cd1d141ea49bc, 0x4cb180903a6663ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x56deb6ad3a1c09ea, 0x1575e5383da25dcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x3fe6a3e12c9f3174, 0x2f4b0c6e409b1e98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x41d118183a5973ee, 0x6ebaed293fdcab7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x11bc25591c18451c, 0x4ce895992ccf70da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x45f706ca145c273b, 0x6a425e5f50ba852e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x74c663136f83a14d, 0x3abdad3603d66ecf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x1c590b0e36b1f1fe, 0x6a00716e0805f092, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x789c3bbb57e239b8, 0x426c548028b5dcdf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x11fe43a215a34718, 0x66583aaa4f7af268, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x4242788c7ed0fe29, 0x1016110051e4e784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x392a72175eaa2899, 0x11c19300041390a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x7ac26db51b255fdd, 0x30e3017e4ae69771, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x2f818719565ec9d6, 0x1ba11c9f40b9747f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x45e26b232e9054bc, 0x448fe34e2447ea2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x654246bb6eba2f3f, 0x2c4ddabe623b7631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #2", 0x469c68f771498dba, 0x0af153105dde8276, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #2", 0x06ecd4d23d6f85de, 0x2d5974de589aac9a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #2", 0x3c4084083c41271e, 0x2a7f941e492f4d5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x1aeb4fb87e25df82, 0x4d42de03756af61f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x194b3f5f5bf2aa30, 0x40518d9015adbd6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x325174061af7153b, 0x566731ed48ccc678, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x498769f819628b63, 0x6d14b0a57833df29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x081cbaa26560a86a, 0x5a6f555a2ec9b0b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x56aa36243a01a807, 0x0ca833294eb9239a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x77712de551d36452, 0x2753d0345d970af6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x0e148b7074093659, 0x26c6585533b1b1ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x722f15db696e359d, 0x291ca80d28ffdb28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x4560dfcd1514ca83, 0x3ead98960b7a553a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x300bdfbe415bcc58, 0x54471bb377b253d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x5abe57bb4a558856, 0x6fe632fc799349b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x2fb630c035052d92, 0x285cfa6962db125e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x6f06d59958e8062c, 0x319435f8066066e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x2abb6a7e0abdca30, 0x63f771db6678037f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x7ec7008943465d79, 0x1a29b56c38cff5ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x2cb49317207d69ad, 0x61cfd11770f61664, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x3592343050b78752, 0x7c706b9f721572e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x121353aa59adf9b4, 0x69c7c6b8659e13ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x2403820b078e580e, 0x5f315da56cd1ab65, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x3c9385a10140f3bb, 0x4facbdc353b9b2cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x5a28f9e73e118b8b, 0x5a1a19b02b9a5b3a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x48cf55bb2c3c1426, 0x12125eb904e46465, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x6f82719f1f842b6b, 0x3db45a5447965645, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x4001951834fcd848, 0x388c6ca91c3704b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x05b45f9a78143e53, 0x0e4c779b7593c948, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x51c238073a633adb, 0x5b31dd3617c7b344, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #3", 0x41f192ea54461c6d, 0x04995eaa75c5ba12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #3", 0x558710292399868e, 0x497f6cde7e85188b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #3", 0x61ab12193c31d27f, 0x2a1f73c52fb00a10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x686de6a57248c8ca, 0x34946e762a7a67d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x11ccf4352a9d2ac3, 0x7210be1957f05844, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x5f9a030b0273d496, 0x74275cfb51ce894d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x7a8812e922942fcb, 0x47625295654e62a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x5cf76aa701af7494, 0x7d1615ea4c4a4af0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x55f591020b8f71e1, 0x421005031ee8fd91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x2f28f86f478d89e1, 0x1d6e161c2b7ca12b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x03bf5c600fc119b1, 0x5b2cab3b10d40a88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x0209e27b2d5f3076, 0x3b4e725c6c2d4305, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x57fc5b393844f845, 0x441d9b4a13d6d6b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x3ab8ccdb2d07b292, 0x65a55ffd37965e44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x4f9be25e19fad6d5, 0x1ce4c0ea3540dfc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x1baa4b69439b2fb7, 0x018b2ab42c934d05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x4f2aa19868ea60b2, 0x4b7c4a96719fdc6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x3077ea93784928d2, 0x1d1c7d967e539a07, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x080a42834a7616ec, 0x0f27a48f343746f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x77d5476264822543, 0x206489f90a1424ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x1cc71d8803905bad, 0x1deafbaf4fd1a29b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x30980e3f244cc1ca, 0x076800df577fea63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x3e47989f0e4bf4dc, 0x0cc0ca270033f09d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x51e7249378438838, 0x2cc73da259f1e408, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x612de8ea68ae3e0a, 0x4b91c0742111c62c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x60f766dc2e8d04c3, 0x1f65603311a5d37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x79031baf6641a46b, 0x45dd1a726901a960, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x4ac3c9af1100ca0e, 0x7315ce5f70d86311, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x149125bb4812068b, 0x40aa05ac678ae737, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x6c5ec8554bcb9bc2, 0x3f0ad19b452933fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #10", 0x5a17909e7224623b, 0x455d24982aa660f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #10", 0x6a67ea73502a0571, 0x049844fd2bfeb532, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #10", 0x38d8437b6c75db91, 0x4d107b5e4b95d35e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x1b02e0542318c14e, 0x5d3ba6dc19cfaa58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x095a65b975e72217, 0x02d153b81405fc03, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x06e7ec25458864c0, 0x04de5f14541e2f68, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x0d9a6b4c7ab3e83b, 0x3ba916a01b7911e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x467f83fd25ff6a74, 0x60a245dc79f933a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x1823ccaf2937d993, 0x249f94962097149c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x7961df0419a6452c, 0x4c95c9ce028bb723, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x061c20bd2b5d315d, 0x4e218a81323a227f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x4e75f2ab4edb208f, 0x4c09ccd7211f0112, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x44c242a63a035c2a, 0x3524fd1557d05864, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x7f8bc0ea67979e6d, 0x2bee87cd4baa2ecc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x624b86a847c58689, 0x672340ad0d262c36, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x6dc4f0fd2bbef46e, 0x071f5fd828cb0aa5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x54f6ce0115f7e90f, 0x49621f4105e8bdad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x2f9e2e3b5695ff51, 0x087474d04e58ad05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x01f330ae4c9c9c5c, 0x0092cf8435ba4ef9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x1b77bceb0bfe4d20, 0x56d9500b50692359, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x4601a94a5428038a, 0x28397bbd6039ff92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x3bbfa1f713076f0b, 0x2be42e5e458d6a35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x5accf59459d2f643, 0x52b3966b1e0b289f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x0591eab110385286, 0x46d633454891e691, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x26303b9656ef190e, 0x4e7aa43e5a88b8b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x2d85185f2974353c, 0x28e165b755ce69d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x7610d198626208d5, 0x0b88b8ca2f78490d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x6e6055f6281ae824, 0x7fe16c6611888e83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x7c42ebae1da6bc73, 0x71c28e153461ff40, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x30ae2b7e4ca2ffe1, 0x79ef697538028da6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #17", 0x2675f6241ce3e98a, 0x560db6450b7b2112, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #17", 0x2d1c3c112287abe2, 0x540d07a42c07e0d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #17", 0x7976c4f12f71ff40, 0x06909988534c77a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x58e6347c34a39a43, 0x291ae17826fbdd50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x1705a318565592c4, 0x5674265e4ef70614, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x7e707ae8524222ad, 0x607f94970565f90e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x6fe8df2033b761c4, 0x39c7f84f7ab36697, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x005a61a508c3aa82, 0x32b5f43d20970a9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x25a7940d001f3355, 0x2c122bb126d057ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x22a6df385968d228, 0x52d838a052c3d01e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x08dad1684f2b293d, 0x261047c51c1da429, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x03cec380198da7d7, 0x4319817961c105e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x6fe33a9c1137a090, 0x30b80bf81ad46699, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x6379c33d5a0257f6, 0x203a5fa76e53b584, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x0db9b9bb1bbd1058, 0x69071c1b5362a25d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x2480badb200bd8ae, 0x73f9acfc0e141b60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x202b0c0307bcabca, 0x34e4732a4a284ee8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x61257df342fc66cb, 0x1cec1f0642d1eb3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x12279008220910de, 0x5eef8f646a004f5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x3b96b8b57c796138, 0x4bc1554015f65389, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x0db101c8510519c9, 0x30caba222b79f351, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x2b0771c002d4c4f1, 0x19cda8d6712ac505, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x1e91d54a3887145f, 0x448d676338c12b7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x5892ed0d7bb9ba06, 0x46d546db43129025, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x037665d02a26fe13, 0x0d3adf0d78bdf911, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x6d2364de1a7f73b1, 0x3b8fe44c649be3c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x3c88848f1a5d885f, 0x4e9c331f7f4af4e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x16d6e997460c0291, 0x1541486f781f3d44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x17111c5b3d66d96c, 0x239930962487eb60, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x403b9e5d5a4017c8, 0x15b2b06542188e1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #24", 0x12c72c2841af0071, 0x7ad9b9965ecd73a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #24", 0x3d68ba772f1ae2d9, 0x21e003cc6b5a1935, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #24", 0x5941e0ec1fa7f693, 0x6418124640df2048, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x3a276a447417372a, 0x257b040b466545ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x0e74bf895af18320, 0x45b03ab176afeed3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x20fd85b212685cad, 0x6ecf2c17254ba921, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x4fcf36195f8644e6, 0x49d39481380ea20d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x39c65caf7500e9be, 0x7a273028100ad477, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x36afea2f10b84beb, 0x6ed8481e4c8d88d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x3fd32ec41bffb453, 0x37e7a20c7418a4a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x3ba7aae65a72c8fa, 0x34f7c4ef19150fb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x4e8a0025252a902c, 0x5f7a557b75cf152a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x001c134d5b4e3014, 0x6c7f03fd5cfebfae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x6db68cc24c1dfd50, 0x024a68cf211998ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x2ba44237534f6b34, 0x59283b0c3d85c2db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x485054f23c68df71, 0x4d909752656a9ee6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x4d212b5c69dfc9c9, 0x31f827bd7f003f21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x05df7e1c2810a8b7, 0x7318e3c80cf45a20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x028371b20583bf4d, 0x260969d141872902, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x2aae4f7923d54229, 0x37563e2c510d71d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x7f23723e30569a55, 0x2e0c31852aca62c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x7c7497a5250c36d1, 0x4be3fbc56cd9ff00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x785ba20577f0592e, 0x2a5fc1db2818d9dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x3459389f3f7ba07f, 0x0d8378c240abf6f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x295b6a4932c519e1, 0x3fac3619017a63fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x5ad5c299347827ed, 0x0e6ebe1b2f3ae865, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x39fbe73a28184f94, 0x70c211685d59344b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x4bed91be5c72d7a7, 0x2e66a62264aa36b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x0cc971fc5b58953f, 0x0f74997a4b1103fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x0064cc11624ac4d7, 0x37eb02fc093e09a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #28", 0x5a3b1e053eda5c41, 0x3156e37e78c06e16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #28", 0x7e55fcc079189b27, 0x396c650e0e9456a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #28", 0x2bddb5081e7d78bb, 0x100eba9f27b16709, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x52f5a0a847ae60d7, 0x56ec4f6f06b377a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x6fc6b06b1273520e, 0x640cabec0cf187e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x6ee629b60110580f, 0x719bbe953bb44229, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x5c68ed4f3eb04921, 0x06c546257baf9bb2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x20fb0df9364488d3, 0x04eda5545ccdb960, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x751ee5140efa8c84, 0x558e27767b362bfe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x081327ab19d93d42, 0x09ca82a37374e1d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x3856b5fd7212984d, 0x1b2648de33f0dcb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x39c0f9241eb10042, 0x3aa454550b4c56a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x3124525009d99d1d, 0x183dde872987a98f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x0ae9f52c6c0131de, 0x653bebb9200a7c06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x2ab17b0020a7bd0d, 0x1bba17b96752e27b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x56ec45e019aec352, 0x44209bdb4bac88f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x28a94fd650ad379a, 0x46e2b4f74c0b2af4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x6a8674dd5aa655a7, 0x3f800cc930bc7782, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x4cb8edf41f51a88b, 0x64ad543622dd2ada, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x3e02a8cd46676007, 0x2e2981800679e718, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x5040fd24153d7c60, 0x300190a76f26fb1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x013eae3f2aeb8edd, 0x0f3177245b2af251, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x4b934beb069e70a8, 0x427dd4cc2bf0293f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x204d33fa3e7f672f, 0x779cb238227f91cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x0f2c9eca2e0ac989, 0x6e8abcc048f683d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x08b11f305e604f88, 0x79b2fb5279b313a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x7db1f8144ab9c001, 0x1c903e81556a0d24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x112120090be584e3, 0x5be3f43c3bb4a0e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x212301443a0d1324, 0x2adb9bff61621d2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x64f8a2017f0ae44b, 0x3c8d0f7e2261af83, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #29", 0x05a954f345ee8afa, 0x4e51d8c2308bedec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #29", 0x046df22941963c78, 0x530b7fb825f688ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #29", 0x6fa1060168a00810, 0x6eed0cbd139a90f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x4700579829dde31c, 0x0d4da49a78522531, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x7497a31d29a02691, 0x4dbc325544b24fac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x3585ab742b428c8d, 0x0066f08e05b8c326, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x654f9fb123a7efd2, 0x671ae05456a8acb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x22b2d41d475c34fd, 0x790a5c3b4a4841b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x0d4abff74ddfaf57, 0x7ad42f9f285c2910, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x0f75ebcf3d3fbebb, 0x4e52b1fd11b8b221, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x25dfc6cb32a0e7af, 0x255343147f16f1d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x5c7ecacb45254956, 0x776917016ce01e63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x6ec56fe731f95e9e, 0x31926e1051166de8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x5d3beb2b3dea1163, 0x56cf310f244b1b5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x6192013573fe2450, 0x7af3c814428b8add, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x3b5a594d07a7fc2f, 0x0cd3cc900444d553, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x5587ab877af3b061, 0x2ca0fe6348a51945, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x38336f1c7fb10e7a, 0x5a5dcb6664fd9756, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x3251f6295b7da028, 0x641489275e1335e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x20a2e97f7c85c25a, 0x4af3544a0ed0c0f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x2e7f20f836b65fec, 0x5fe72edd0f685966, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x74a0714f2ea73cd7, 0x33b374c20bbb0c24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x22a561275b1a6391, 0x4e46970156327284, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x62c25fc00718463b, 0x5a7747d75dffba74, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x020bf69c01029f1f, 0x26a4d3b9384a0b47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x00b3ad9a015c2bc5, 0x1d47a29e3a3f65b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x5cd9cbed6345efe9, 0x18529b9f3305a3c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x5fcbb24421bd9395, 0x41d664b87d7cb56c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x5873f38140988395, 0x0ce50ed30e4ad33c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x6f3fc06c684c7661, 0x1a05df604d1464d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #30", 0x4366d9f27dbe1f2c, 0x2346d75411e52193, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #30", 0x04d665671689afc1, 0x6fe4dc08262939b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #30", 0x178c4ee17bbae798, 0x5e7344fa06e25c03, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x7d17135d59745d5a, 0x4121c1bb183ffc7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x3cba4d430d1c04f6, 0x4b45a03e59f0df4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x2ed9988b6452a38a, 0x576d94b71c85ff87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x24eb272044d6b224, 0x2ad0d2c4074d8c0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x2d23288677a8c831, 0x5461f0dc142ae78c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x7566e75d15f4e528, 0x26100920708a0278, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x2c7e94e975268126, 0x16b33c2b7a3d4cc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x70e168be42416a82, 0x011fa8c7440ae3ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x1bb5c7dc27908084, 0x5c4ae0456df87c1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x34ac857a1f56f01e, 0x47e95b675870151f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x03a993a91fc6e76b, 0x74f614a763861e06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x649d998f3f359aef, 0x6ad3aa122894bac9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x36de632062cfab75, 0x3cbfa25511c0c215, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x78c4909d18fe00b9, 0x024ac48e2c454a7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x0e2481df27a24008, 0x2682974125432587, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x69e3aa8a4598e997, 0x694e09517f05ea9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x6d296a1b34e7c221, 0x6cfe66ba05997266, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x543eb23f52ff9c2c, 0x5e09878521d5ef95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x72c68397702fb7ae, 0x055c0d9b57e845e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x2f65529d3d3ca307, 0x007d00b157641d27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x200c4e7c6b6fa3ca, 0x6924df3c6643b5bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x046da484390b977b, 0x1289003a18d0df1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x60add78327620df2, 0x3e1404a112922663, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x6cfaf7897e9677bb, 0x119811014a91820d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x337e39dc2e347bf8, 0x502af4735a2461a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x0134182501565ed5, 0x7bfa513a07bcec1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x71861683602232b6, 0x5fa5320473fa9bbc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #24, #31", 0x1d5ed5bd34839820, 0x4b5eb8e320eb6920, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #24, #31", 0x1ff33bea19b81f17, 0x072f1edd3d6b2439, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #24, #31", 0x52c3b692145007f4, 0x563c03532460e06e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x3bb215e7488b17d3, 0x36f306d233718e15, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x47218f8f4e2e0495, 0x7e03102228ad0d70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x7c62808e7ecbc04f, 0x02d16f157a9fc96b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x00221f246201e78c, 0x025cb5877d9698b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x42241a423cefed53, 0x7191346f71a835a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x7173857319c2bda6, 0x12939ec85f82efff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x337adcbd732a178c, 0x1cee14381166c15d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x077a1f806cbaa89e, 0x35c7a1cc063e9350, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x3545c07137b33188, 0x39b02165432c3567, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x05e1361d6eaab1ed, 0x6bd942d87c675000, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x6d76723c7963cef3, 0x7707196c0243b6ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x5b65b67f716b83ce, 0x7fda4f5e6d989160, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x2e5b712171d465d1, 0x5f40c7081d89d0c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x0b97237719fad4f9, 0x7d0cc0c01fcef694, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x0d24ec8566fd59bd, 0x3135b7f13f120034, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x53b8025b7f00b4ea, 0x45509384149f0c05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x36b3e67243a48445, 0x57cb416d08fdc2cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x324f36327c6c2c39, 0x056512cd3c951c8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x75cffb2d3eb32299, 0x3ed8d33b1fc5a86e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x301ea6676c9f00d7, 0x0d5e39ce5135b1ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x5e7366a86bcc432e, 0x6ebf826e5e7a1788, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x05c718272f7ec60e, 0x7e490e1c6a0a8a1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x167c1fcb6e6d1dd8, 0x291c8a5312ec04ac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x6d6dd2c27f56521f, 0x278b10b26a342227, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x42fad6647896f7c1, 0x7331e4f42421b934, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x750323fb1f8fa8fe, 0x60b6d5c3754a0c96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x5e42cb98226deed2, 0x150fb5046ad31f28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #0", 0x0f0cefa92ac85342, 0x3c08d0d40e6171ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #0", 0x169496716b2497a4, 0x6cdb89886d805651, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #0", 0x1aa35db200a76ac4, 0x578ae0701c5bae98, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x6f14889c56d2c3f7, 0x2f47b345311f7d7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x562916160e858499, 0x1b539fa55c825b5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x071c7c5a615aea55, 0x00a414921923ec7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x00ea9354237dae14, 0x0e6df9107c1fa055, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x45eb9ce622fb9052, 0x66f2bf7d5f2d5eec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x4dc3e3945a6a5a73, 0x6d8ed0eb54f88c90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x458ef2181a03c352, 0x4278e2e164587a05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x1aab2e162ffbdbe3, 0x00b4289e60324fca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x06ce9fda2ca56ced, 0x1151cd4809bfb6b2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x3b2af18666e626a2, 0x664212105cf7b5f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x484110f704899b7a, 0x761ba26a42476de1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x2807498e2559cdb4, 0x3e670e36492ba44b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x48555e0615e7d423, 0x285903376df2e674, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x70522e96056455e6, 0x42eb73041619419a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x1f6819387b25e43e, 0x7a71bba035e120ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x2b21c02127653dc1, 0x161370793a13474e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x540aaaaf2a151010, 0x43d2fe0031f05ffb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x10fb36b20503b855, 0x0ee815eb0f359c35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x098d53cf0fe4184d, 0x517d0a16593c47a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x353de6014ac0ef2c, 0x2267ebf531949d5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x60a8c34f6272f6d6, 0x1f8783d17d934407, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x67d74cbc0e1e4141, 0x13ac85a150faf1e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x0944257f1cef830d, 0x06dc1294073f65f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x4454c0cf0525ab42, 0x4152ad423465e5a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x2f3abb52753e5b86, 0x6656459b185f6b7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x7a4213db791211ca, 0x279507b34035f204, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x08f62a173bda25a2, 0x197239ad03cf67aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #1", 0x069b14cf54eb88d9, 0x356405073e341018, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #1", 0x375e7faf4f73d9c0, 0x3bc7541f6743d81e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #1", 0x5d921b023f1adc99, 0x383eca041f35cc6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x5c0a5fa667c7dfa1, 0x2675325f66d64081, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x6ced8ae301926bbd, 0x1b3c2622205f2075, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x76d0c744605393a7, 0x38be8bf31c284635, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x5965a57175d071e6, 0x5c5e38397112db1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x31aa97892a4647d1, 0x74e242ca625bcf88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x7f31d0aa5c5733bf, 0x208fdfa03845ac58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x2bcb0d7f57c84e7b, 0x1f89847636905059, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x16e32b147c3b4f23, 0x55c61cc4095d2881, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x64032ec40b6f8f25, 0x7033690372ed8aba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x0d01fae24c0b3723, 0x134cab3050f0b9a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x2c5ecaca49773815, 0x6d18ffdc03d2c226, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x3f47a9fc69c7e010, 0x74e59d4605c4703b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x140e27e108b01f63, 0x68203fc370f24185, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x6507532248c17253, 0x2937eddd133ff88c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x2089c0ce1f9665aa, 0x49d048e510d260a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x1bd1b4cd0a62f226, 0x1a2f8923376cebe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x15d2814b3da721cd, 0x2a5a769d7fd4e392, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x09b258f03dde9d16, 0x50c59d3922d47c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x0755d52b1b8cdb9a, 0x26a73e54361123bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x0554bbaa23f5d3ba, 0x3bd593f6469d7f27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x2ca5f31d60c7ae89, 0x378fc0ac1962e38c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x298920dd767324fd, 0x2ca2dc1811ad4640, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x16098aa73caf3005, 0x227fa6e24a12e1ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x4712222c2bda442b, 0x017fcd8e31db3f75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x698165f80275c040, 0x31b023075ce4a377, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x40545d5626605dfa, 0x7fb91fa57333bee8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x41ed3994651a769a, 0x2944e2a347aa3282, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #2", 0x09104a5445d77256, 0x0e47b1a94741f53f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #2", 0x269f20df0d47b4e3, 0x60a4d8cb35b63d71, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #2", 0x03bad9e069e32a93, 0x476383b1502841bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x26925a991bbaf0f6, 0x1a3b236819c46488, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x479535217d4fc704, 0x4b9fa3fd6da47cc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x7fc587444a423fe2, 0x4a89203c31169b19, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x70a29ddc4d8f3ca5, 0x244a5a014019e49b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x32a9b33f160bc8c6, 0x07c4171d328fd770, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x5be33b1c5a76a57a, 0x79d1ccaf3bb9fd93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x67be5a5d38d3beb6, 0x71703b0402825bfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x22b6e9496ce5c120, 0x52aa9db86b79343e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x08a0b21650dd3cc3, 0x053d98c6494943e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x4e2d03c70176e0e4, 0x36edc0a75035e737, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x4bb920c62596dc52, 0x014c82504df28b0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x732618f715d086c3, 0x0e0c6fa63c5bbea2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x2bdc4f8a68bd62c2, 0x6eeb961225cfcc36, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x4334083c52fa04cd, 0x6189c9c907bf8aa6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x0bcdc3835cec845b, 0x0a41e6a22af2629a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x49d2457b1ba92f9e, 0x166b96d82e84accd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x6c866c612ebbb157, 0x77cdf0af5272f792, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x3032923b23f5611a, 0x22a8dec93ab37028, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x498c3d6c16b26ada, 0x08a5fb337bebb301, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x2c82f19d273307b5, 0x384771a33cb25663, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x0ff06a77440bec62, 0x62822299585f4127, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x1705f12f6a60b270, 0x601ecbce532472b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x474d36cb14826c26, 0x7e16d54e22d3b4b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x302b9bc44926522f, 0x51586180111f7c47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x77e20386063b52a2, 0x639273d91cb20825, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x2a30b3bc600b7380, 0x5765784d281495c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x76bdde5a5c47ba65, 0x240048c273bcf128, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #3", 0x037ac21b12f16a24, 0x306f478b2340cff8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #3", 0x56fd56865bbedced, 0x7ba0111f136b2c92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #3", 0x461f8f5e64a67494, 0x668f9f466e0347b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x7928e0ba622f5de9, 0x10d6fc690d6cc629, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x2b55b018021eb649, 0x1e8c427029547c7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x085a08ec1d6bfcf0, 0x460684a32337b39f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x7d7770716f4c9223, 0x4b4c4960328abca8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x4b944c8856b6f55c, 0x2647add174354ecb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x69a85f8113162fe3, 0x17761ec34f0f0ea3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x6ed50cd04909da7c, 0x627a3b3640a5b607, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x2db04f113f7ffa26, 0x2ea8fdbd34f49c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x21af580f60eda4c8, 0x4261625826d92fcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x630c5b12163430ed, 0x502dac4a4d050828, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x33a02dde3b890527, 0x703cbbc76b6663fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x2ad5974a4438ce77, 0x1df120a631179e4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x1aefc3d43cc30bde, 0x254ced1a7669e3d3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x4fd93bc127f32dac, 0x4578f27604982355, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x70fd082973e6d71a, 0x453dd95c3eae4891, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x3366d14036044718, 0x73a2e4c01ead573a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x16f1ebe015b4334f, 0x4586870555162950, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x2be8643d1257ed3f, 0x221b317879fe46f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x4de0f2660355cb97, 0x6564aaf05f88921b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x478e9a0e35ed1d84, 0x10a0306a78b689b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x72b0296234995ffa, 0x6f206d84627e5de2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x5c8c8da72c545a94, 0x6716813742896523, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x203b31ae74da9275, 0x0137adb54d8995d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x2aded98d31bd740f, 0x6c36ed0a53a202ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x4771a75f4ad35db6, 0x28b82c3e41d0c56d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x5d2b4af52133b750, 0x3bcf0c60735a0b9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x248982e76382ce21, 0x52e29db72b0c3d5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #10", 0x196feba512e33491, 0x23c2c70d6c181cf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #10", 0x477c948b35acfc10, 0x4e967ad80c201508, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #10", 0x620156a44fe127e0, 0x4ea97a2b24092232, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x44bbba555dc9a50c, 0x7192b802023c8852, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x0f87191c7e96b77f, 0x55de8b406f9a93e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x496a15356d3a65b0, 0x316b595056f8c07b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x0e6e1d001d3569ce, 0x4a52cc172695602b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x00b837ef75646494, 0x51a19d8732f79fe8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x084799256da637b6, 0x1f0fbcde1a282394, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x235333c674f1b2c8, 0x2648389c4fc42db0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x44d2daa8656007e5, 0x73cd4fe305548a6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x4329acf25d6f9dfd, 0x079112bc098e94fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x5c06557c2a948230, 0x792928e052b0c60e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x17cee7e073fc52a0, 0x29a9868925706ab1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x1131bc6e1da76863, 0x4c05cadc263d04e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x130bccf7784461a7, 0x5934a4c911e9f45d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x65ea995d525a508e, 0x2c1217f11b53661c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x474c03565ee4e3b0, 0x6b1793cd093dcd24, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x4444eb9516236a4b, 0x0e92578e0c1eddfe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x739308480ed69bdd, 0x15ad72fc076e9887, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x396b1e0d03c8e51e, 0x5a1f5e954f995dc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x77c537be410f9352, 0x7509c875513a05ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x5eb6fbb550abaf98, 0x77770acf08f6f42c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x48f0113f46f3007b, 0x1ae0e88971c2c8ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x194d5109782dc296, 0x0d162ec92edaaa9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x5712a64646aacf4f, 0x381877c06099545f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x5cce399a0265a55a, 0x6cb8325d1b5791dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x113c41377ce588f9, 0x22c62a63506141e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x00ae6e171504681b, 0x1ffa9fa64aa75f44, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x5613fb6d13587001, 0x1be165327873a5d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #17", 0x64041f991c4b828c, 0x016a9a0234caf723, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #17", 0x633e830733a3ee99, 0x268dbfd02cf430d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #17", 0x2bd1b13013e75335, 0x5bcedb757c8bd410, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x5a92228449dd5acc, 0x5d25286f02e45776, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x4c430026410213b6, 0x1e3be95237605c1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x3de79caf27bc3da6, 0x07c19e005d7f415d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x3cc0a5c2440805d4, 0x2826a0a23e960ac6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x576075d638744a9f, 0x3709b09c12d4a12f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x54bfcd2b6e2d5822, 0x479f98523b64956f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x21d146bc4427a1bd, 0x6858c64837fe5032, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x580ef4f211af4cb1, 0x348a24424da2f7ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x5b8ca77d6ec338b5, 0x50874f6232a11777, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x2fc54c6b71c31196, 0x6a01739527cfa7a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x197f4f3c2d7589a3, 0x054ee9016dace91a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x717d8f78634ca47d, 0x2c42f3e0563ff4fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x1bc0ef1c30b42e80, 0x6914962e48de054e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x1ee186a36c9b6105, 0x04429abd7080bc47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x30c302c25d0930bb, 0x287f0c7940b2cd5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x6eb87d6c5edd14ad, 0x0e55c54b08d1f7b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x4da04d62257482c1, 0x3b730f2c4a4524e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x173794577763b58f, 0x7214cc8d7d6599cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x24d93f32175576c8, 0x6b1282e730b6e394, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x7aa21b45700b6ec0, 0x06f6d8921656ceaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x20bf9d4163776eb6, 0x5f34d3f816630a61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x5012cfbb2f62d321, 0x06e3c6a83fa123e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x0c6c03dc0ea9b68e, 0x0053f14300d5d27e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x6d86cb3b451ad95f, 0x09a7ca337b248148, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x6a8f5c20377e72bf, 0x4569a6313b27189e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x2ee2284e239f3553, 0x388cb26b01c6f078, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x3af4ac1b3974ac9e, 0x327dd40c53bb6780, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #24", 0x29801b5f49470a23, 0x6a12362b3596c760, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #24", 0x2cbe78d952dd9869, 0x4bf9d1c14a3fb8a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #24", 0x02406b8a0a34cdc7, 0x09e0dc847cd14895, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x18de8455074ee546, 0x7da71b130eac6f66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x4c69bea54f3a96df, 0x09d0f0ae06654f90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x06b9099e7a191a9a, 0x418c682e36f91ac5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x1db84fed6b3ddf49, 0x38c00b3d359b31ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x24b28be87368cf98, 0x0956996d58acfc08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x3cafd9bb5a3d9529, 0x0e43c3684e32a747, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x2d1b2d9222533c6b, 0x18725fe7696e5295, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x2c880a3263e6b63d, 0x663f9b2a2f5b991c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x6b359b8347d8f930, 0x3e08088245668e87, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x1713900f0d584646, 0x4bcbde17379f5a28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x077160e02758802b, 0x6e9874ed1dcc99ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x12965f745cbe6507, 0x5367cb9a2529b0cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x5027349f0c1a703d, 0x7dd6acd53748eb5c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x665805661dedf28a, 0x057b92a30cd70e5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x40412ef55c84fc1a, 0x764560f0137332f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x406bb25700d6d496, 0x42cecc146cc93927, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x48afcdc67dfba5c6, 0x322fc7ae2ba14dda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x0b53ec0c51d91cef, 0x6340a8025fc35dd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x79319d1a50f7c31e, 0x7d8ff78312c54cec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x2db6282535c5aa8e, 0x37eefdb90bc7fc8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x41e01acb488c7a8f, 0x4310e7eb7ddd5cc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x667a6d1900f9cc10, 0x0ab46b2028382031, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x5d7ec82a7e7a1f3d, 0x3bab532926bb9c0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x7f50f3d345b49ce5, 0x1384d5361dea7a81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x43b042ab2ccc705d, 0x498bc85b4800c199, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x7ea58d4c255416f2, 0x27c41f6e4f042eb7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x764bda1019b8795c, 0x61c97ba377d72a67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #28", 0x4f7e23ea46b00ee1, 0x039f26f624020235, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #28", 0x0f3c89702c93ca1a, 0x21df5efa115e3eb5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #28", 0x2d8d962a7541b20f, 0x39965ee675b6f68a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x73bbd14c2ff767cf, 0x1c7292990b0c5e54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x75ac04b47282a130, 0x28f6d8d5730cc51f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x1f4f118d62d1a626, 0x3b0d86b8395c475f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x0825bd186a29f1b9, 0x086076161df49eda, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x03e26b15196af037, 0x15cbc9417e719728, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x601aff184452f858, 0x2273995e53608eff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x70e6c2731e552c9a, 0x64becdb46f578889, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x1396dea9018111ac, 0x650e7f131e74589d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x3178797b52778fc7, 0x2980b6f20752aff5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x44fa30f8356cfbcc, 0x7a5f751427247e30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x183ea1f368e13ba6, 0x6080c58f64494285, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x530b2d5f1809aaa0, 0x023de15f20645f0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x31749ad741498f92, 0x1ed5f63456ed9875, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x059c87ea0f0cf529, 0x2a4e2774118f99f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x2d6221c365f5a18c, 0x00e7227976834a5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x6776b3383e7859ed, 0x14f7a2fb40f9006d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x10efe9b442ab2577, 0x484bb06218ef2cb3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x7818214320947073, 0x4013aae355ea1aac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x0975ac193c713e91, 0x3a335d321056c336, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x547ae9324f911876, 0x30bb22425c80d978, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x10daa8085dbc9962, 0x336e71ed05ef8409, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x6cc98e8b18664072, 0x177f1df916772ff2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x7e5be1fe21f21d4b, 0x0cfa7a501a2bb04e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x606a77382370611e, 0x5b24b0bb65d29536, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x661b86953ed56ccd, 0x7ec1c1ea715a60ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x5f69dd400177d8cb, 0x47447b995e33a7d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x3de9175c1f458d51, 0x6e8a6b0f68df8959, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #29", 0x6ed6a5c778ced4bf, 0x456062d21264008e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #29", 0x568b6e212fd2a291, 0x185384987fb14dcf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #29", 0x4838e3042322f811, 0x16287dc14354fcac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x4515155c38a55db6, 0x5d80acfb4694c502, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x5c15bed42b291c23, 0x2c675a39257f8c94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x69fe88f05e1e691a, 0x16d9ed8142314569, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x5f9641e50eef5851, 0x2064ed4249686631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x2e34e5a277a8525c, 0x3247ef8a1d7f5941, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x7077271c4836de68, 0x2fe359d01d0b8b69, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x780980f932e556f9, 0x1cbcd9384702953d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x56084f0b67d83ee5, 0x0a5791ea404263fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x207d9c9b333e8339, 0x06d729001b1d6467, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x5e679f5c5776de7d, 0x409cf0fc7c935b70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x359547975f298e1b, 0x3ec4a0d94866284c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x6e18e66c44167e08, 0x11ce8e7d152b897c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x3bbed064628e3c8d, 0x32aae2bd1c4dcc0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x2ac51af5561630af, 0x395957772c35f780, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x08fb87a97d901ea8, 0x73388cbe22ce9bef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x65685d8d69e828ec, 0x6310ffec5f03d6b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x1d26ac253abe2c17, 0x7a213b1b05e5fa28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x12350a94413df672, 0x027955987b8e4b81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x2067848d55c3024b, 0x43f473ce47ca522b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x19d980530fa0be65, 0x5cf5dba70e806afa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x722efaf264278e80, 0x2ace3708559850b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x3a3dbf2f7506d4f6, 0x01ce48381cf415e8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x7296f39e22d3b1c3, 0x3fc2b1d7433946d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x0cbbdab01c5e58a8, 0x223d1d8c57ff512b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x571c84bf605ea0ec, 0x5de54b5429e286d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x219c975e69654625, 0x2570d25769518f54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x3f2848700e11bd27, 0x311be17f42041bec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #30", 0x1db27b8c7b52bdee, 0x508486e65901c8c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #30", 0x5f7a4c6e306861b4, 0x2e9a197c0fe1767e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #30", 0x256f36ab6c983e3d, 0x2cd58c6619b80b9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x0f6bf0017f2e7003, 0x5cf1527618062a49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x1b8cc8ab4deac6c9, 0x70057b751c27cab1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x2e4967b56b7b23dd, 0x460a518672a94d6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x54e06a020d16be3e, 0x5bfadcbe4fe5ff14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x1b287b65626ea1e6, 0x11ea1b001408b273, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x5dc15fd41ba494b3, 0x6d0a7b3738daf6f1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x4c0cf6677591f9d6, 0x48bc6d6f3d3bac43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x622a381333e50a57, 0x56f3b7e1717c2d12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x33137a5a7987d2d1, 0x0982575c71962814, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x4772999a53c8444c, 0x0dbdf2c54ea04305, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x3f4368291d446d2e, 0x4149907075bc014f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x2a5b2b6c578c1b63, 0x45a200631423d22c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x39fabd491536ffd6, 0x282c849f4583a6d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x30db9489471b0b32, 0x7e5e9dc217bc1d1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x3cad05082beb8142, 0x54f7c9617ce88af0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x5fd08b9977e70f5f, 0x6e64b8031ed73d1b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x716ee2301e2b57f5, 0x106d653012e405f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x71f39c4122cdd969, 0x618448f938e17bca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x40124698743f7d7d, 0x2e9d7d193137046b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x4bcb98e06d875b36, 0x455ad6976a6d7204, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x02be5b0c2e4fb698, 0x2ff118d605c6562a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x756ac1ca727a3ca9, 0x1d8273483399ef95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x1e65bdeb1ee73288, 0x30827a853217c6d2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x16ce41e7615c691e, 0x50ef03ee7e364984, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x7f87c113729e9872, 0x111a4f78083d2417, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x156c71db6fbc1cfb, 0x411e9fe1717b5d55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x63fb9a78680d3857, 0x22b261c0557eb873, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #28, #31", 0x5594938d6fdd434e, 0x3fec2a782fc73358, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #28, #31", 0x1e2cf9e6530ffcca, 0x358d89825852ee99, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #28, #31", 0x458a39733c6f58b3, 0x0becde2e1397bbb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x5b568b3c169e8671, 0x45af828363eff75e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x77faef8f7340905b, 0x622640e37224cd23, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x65df28cd3b80911c, 0x7a61f13b7782b0a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x2b3cae170bb06fb8, 0x68fe0df87b4b9aa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x73bda80f10b67d94, 0x50ca531c0f38488f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x0093c0e2748d056a, 0x3eff7be849523b9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x479d02352d920863, 0x21a52a351ec0bac9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x6a0161167807f8fd, 0x3258767a0d273ba8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x0ea67f6f533d73ea, 0x711733074557ec52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x467e044531deaab1, 0x377cb97606a16efe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x6d5f3bcd67222d99, 0x7e241fa12c5d2d13, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x72d29d5178731ad8, 0x27a8c7bc189be9e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x0929986d66d3ae5c, 0x27d4327466904560, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x5b60b3c75187ab31, 0x2fe280fc09bd594f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x7f19b3945ad68a92, 0x287e141822fdb5fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x52de8390213c24ab, 0x3024f1a4691b14ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x7479989565efba73, 0x2e7300fd618502ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x17ce6524664a919f, 0x682671fd3af79cdb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x4d6cbf380efd91aa, 0x6754c9ee052da0f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x0770ac82459dbd4b, 0x1dc98ad7403f5c8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x2c716ba856b222e7, 0x26cfa1ea109a44ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x2839ce1842d5b257, 0x1a579e3f07d21f6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x1dac3cea5af4c70f, 0x2acfd56b275381ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x7c30ebbb3ee19755, 0x106e9658708ac07a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x24d151c93a363576, 0x520fc37970aa8450, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x2080c71512f6eb19, 0x2ba2212b3c9fb6ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x21f47cc35f96e2b6, 0x41cd57df6ded864e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #0", 0x2534a00254fc84c2, 0x2e2ce2d829652946, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #0", 0x2baea7a954570c74, 0x39ff6e3551a60baa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #0", 0x172cbecc04480084, 0x59782b1953e875c2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x5f3cc7930baa8dc7, 0x7b3bf76f34d8fbb6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x4a8c251c77737fa9, 0x2563bc305b6db34e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x31a9b51f77ba58ca, 0x4c18379f6f5d76e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x0ab143e46dca85b2, 0x2bfd2dd3522a7c35, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x4d6168696e44e55b, 0x401802832ca5c0a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x43416a1d100a5823, 0x560ae9ed7296086b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x646164971db43f2e, 0x443c14156ef011c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x21fc3fb23e147ef8, 0x42d887897b8e2363, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x49bf0cbf55cadb49, 0x30671f1901390745, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x4d3e5af228bef233, 0x5ca6ba94144b31db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x20794afd2fa5d694, 0x03a8a8c17ee81012, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x1d705c46112a8eca, 0x51128c472b2a8ee1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x7f6f74252ddb3976, 0x57d04f896ad1c4af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x3de5919921a3e12f, 0x5d67cd1a42b0de42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x3f58205d74797792, 0x31a0f0092246f631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x328df68a4e3c38ae, 0x1dd519946154600f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x240713f73f3421e9, 0x628d67557c4d0349, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x67f3141c1440dde6, 0x1098352571456eea, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x43e6b47a41400b43, 0x702d7efc086c5f19, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x526a9a0d0b673d84, 0x3396edfb615710c0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x394276fa2990a28a, 0x4c28d57051da0e32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x4b3483ba462bdc7e, 0x148aec7477280894, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x3aa5541037441859, 0x196efec50a8ca417, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x058051074e6e6b7c, 0x6be104276d334a9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x0da28d657a188309, 0x69804de4298764ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x0e5960ef0afa52e5, 0x1accd3e97595a181, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x4c3a5e283198ee95, 0x7e02009a52401569, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #1", 0x3d002c197fbffb9a, 0x3397262a1ea4f835, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #1", 0x29509e240509f2db, 0x707f06677642a314, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #1", 0x4b35cf5906d9aa6d, 0x6d6aaba8748521de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x3e1dc2c66af2ca1d, 0x7f11c5f605db236a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x396135995c8ebbe9, 0x730e6e05439e13ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x56a73ef307f24cb6, 0x6d2578cd4703c2fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x12ec9f9b3a9b6519, 0x3c99647f65009fe2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x6c3453af6ad7db76, 0x3740b54c5f26fdc3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x6a97d7106e4afc5f, 0x7dcbf5f829347fc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x7354ef3a0ce1ce84, 0x1f7722dc13e87534, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x13bb78f1077f5d09, 0x086d97133e8abe94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x7272272637745003, 0x4465e1fe51d93bb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x14030bec029cc853, 0x15774f862bd35cbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x0a8f15092f70843c, 0x72d71fbd6aaa4adf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x6a0be95506eba00e, 0x4faaeac21d7bb4a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x71c37b847a6ea85f, 0x7ca2b26756403d04, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x68b9a4be1eebdfa9, 0x7f74bccd5c5b5294, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x2bcdae2e78b15edb, 0x7043c7c85c0e93f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x0030bbe45eff348a, 0x1a99528c3f89271f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x1673848d26d9b25d, 0x116262d772a2e30a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x29767ab0114d5f86, 0x1e763fc92a76907a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x40bde3c264cbc61b, 0x1520db5934058fb9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x6bb766294e23f6c4, 0x5181445d2ac9cd18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x48929f23007ec6e9, 0x010a0a1c5d7ae1ad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x1f6aa6932a19fc0a, 0x39d63441314c43e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x22cb5ae527f42a66, 0x0d5ad7da4b3854c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x06f35ef11c23deb8, 0x0ac17be022fc16ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x42fd91153415399e, 0x159ef9d41d66e37e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x456299245cfe4f52, 0x47dd73f86c740bc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x41ca156d71fadfdd, 0x20799b7f06207ce7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #2", 0x401ed6a131f4541b, 0x30ea49ff2d817b97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #2", 0x32731b0544d29186, 0x0afc5d4408b175c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #2", 0x6eec8d9047589180, 0x39fdb9a651ddc198, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x6f4cbbe727d79239, 0x1d16165911b7e875, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x43fb70f14a52f914, 0x34b3ff3f76401ad8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x7e6832b25b84724f, 0x13a6fe5606f90207, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x3882c1a113e6a94c, 0x736d0dcd43cacbd6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x05e189297ad592bc, 0x49eb48bd7a4cd70e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x2cc9e6d832caafea, 0x27ce52a546005fcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x779d417008af8f36, 0x4eb1d5905f3d01dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x500820b74e30d9ce, 0x311ac3756689cf00, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x76086c072cf5b6b5, 0x7841b7753f54dc9e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x7748afc9493bf5cc, 0x3594f7763a03dcf9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x24c0681b3469eccd, 0x40fcdf0075b0e27b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x485096190366f70f, 0x397bae515d4329bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x7e3c89cb7f5e5370, 0x579000cb4e321f43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x3229035a62e4549e, 0x14327f0e2b0670a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x6b93e3d43b5e35f5, 0x0a43728029c644ca, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x098f0fc30891cb40, 0x105013ca3b9c048b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x358781f53085d89f, 0x7af0e1297f977bcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x79c1ce6c7a9837c4, 0x399b58c42cd031be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x2f0224915bfcc28a, 0x228114391e823687, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x5f63b9995355610f, 0x7bc560447752baaa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x52b3b47f59b758fb, 0x4584d9ed5da04365, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x3c9bad9912ea2689, 0x08a6b40804dcb7da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x4e485c7e3ef3106f, 0x2ea2fca4282f916e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x4784dbaf5ebc7723, 0x63cb95f957d76c42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x0f424fc2110a40d1, 0x576ee80d7d0c5da4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x0ba278954c5da39b, 0x29dc8f6209041e2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x285a6625234bb4fa, 0x278654b63aa49d26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #3", 0x76a11609777c31be, 0x31f757d007be1fbf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #3", 0x51338ab96e05172c, 0x655e63244954ca88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #3", 0x00ef3db57cd47f07, 0x4e3182620dcf3853, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x3bc78f7619ca5fba, 0x35fec9c14f379a34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x7886d6dd7e7dee83, 0x270f0676034c6b25, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x0f882f542a35582b, 0x0058c8c907c926a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x7692fbc638539984, 0x10cd44ce1b2aa7e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x5b9f4e7e07c69cdf, 0x55cf450f1eed61eb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x7f42ce9d0c09e4ce, 0x26ab81aa52406487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x7a0efbfb69c6b172, 0x1b952f1050765957, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x669b307914445b6b, 0x5e4591aa7afe39b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x2e0ebb257144da5a, 0x4a35d3e42262bfef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x6fc2c8dd2607f3dd, 0x25af2b1426959203, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x503d4c083f2bfd71, 0x2e5eb8a37f4af831, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x777f96f67044e529, 0x1a75a01a46d047ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x780b82090c692b64, 0x65bda9ba531ee574, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x1873103340f4790c, 0x255f49fc774e50a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x2abb2a7e260a3ba7, 0x47c4a9fd12820c2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x3a4e971257b619c3, 0x0d8045de11565af8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x48faf41d596845fc, 0x33b91ae7685d5238, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x7f7039d93d519cde, 0x0ef2e43b38bdbcfb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x7c7d9a4f527e5547, 0x3808b52c4fad85e2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x42c33a707c3b776a, 0x167dcdb073fd3145, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x08a4a2cf6c7b60b6, 0x471c16ba3acebc79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x2d6fd9c279e1b71d, 0x321d0d202117b302, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x1febf2c5411a050e, 0x3399bf30582b0440, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x18d01ed11d3a7a20, 0x69815f385a3a89d7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x76a2c01c518ac04a, 0x4297dc0f61cb12ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x0edc5d2852918516, 0x1a88cfea7612f9f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x250fda5d5c3e4d88, 0x45c07fd70b59f778, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #10", 0x5879c4f246733f77, 0x7f5728bd67d314ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #10", 0x32eea02d54bede67, 0x22a1d147611e67c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #10", 0x4ea0958535cfd9f3, 0x02361ac3605e79ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x76e9df02220add68, 0x38897e306e8c884a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x3f4557880b5eee31, 0x48c712210fb9fdd3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x5ce9ae7b0c0de0ac, 0x718510c235e817a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x5e9f65c371bb9171, 0x2bfb119a6bc60ba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x4df9def976772bd9, 0x7720031c03af4020, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x3cea6b510e242636, 0x6b8254ee2673a3ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x62e3049d09c82671, 0x07920bad6fd90b7e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x3f98006408c1039e, 0x5037856e31839a22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x2acbe10668d7348e, 0x2010226c3681df66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x743622bf37c0edfc, 0x463bdd3a6a11388f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x43cecea94bf461cd, 0x1ff95033511fd13a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x3daff33f3405dffa, 0x3ce5dcde226e346c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x2a7d0bd4119fc97b, 0x261d748c0ba9d238, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x1fc3efb139af81d2, 0x321d762467677725, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x4377a84327780811, 0x574082a302a6f44e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x30390baf543ab0dd, 0x342a8e71030fa8a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x3d11e56b7fcd6548, 0x3991880e5b04ecb6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x378e5344650f7578, 0x451625453148082a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x3103d7463f4db643, 0x0267d9657b5d21ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x7353963e43e8cae6, 0x1dcb56596eb3ca85, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x558894612c7b12e2, 0x7a5d9cbd1dd0a212, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x662a94b45c789bda, 0x05381937754c8412, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x03f0a3ec2c1e06d1, 0x77f3786029a23cf7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x0058b7af66436dac, 0x2cb1e59e3429af9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x6610d2f45444c196, 0x0f2e9c513d6a9d1a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x3954370f711a7eaa, 0x6eb2a5451d9f2639, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x306834ed36c79e80, 0x18fc48266a580e55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #17", 0x7ab0696653697597, 0x590bd8da23bbcb2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #17", 0x7fe4887946c48674, 0x418c6d3d5038fdc7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #17", 0x233d224f3d78fa39, 0x458581d9660f1d2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x6997010b3c633fc3, 0x0fb15a24272dc63b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x22a6ad6f6a861228, 0x5b5775d669efb8ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x3ecad3be160cfb19, 0x275a55d408b78064, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x072779c33f52eec3, 0x2656a69d781f0acd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x761a8d433b82f1fc, 0x62771922378faeb1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x0eec67941cd7e71a, 0x5b4b79dc70caf6a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x639c6d8e06897649, 0x4103f4700ed0f00d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x440270830491675f, 0x74e00d3b06d98fdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x40f4a722095ecbef, 0x2e0756182d99718e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x73e4de173ee3801c, 0x17892a48639b5492, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x54f07b3612a97b93, 0x6c52d4f632afb1d5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x51fc6a560d45d5c5, 0x2acebca35c17f4f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x48c8c7c26ef31d87, 0x13a7a3aa4816f79a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x0bcb04a179e5e2b4, 0x38e1ee4357b52f56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x006f58fd5b662c9e, 0x66861f636f67722f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x5ff793fe24485825, 0x7641020d4471c980, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x2da7241409946556, 0x720b3b0e20ec3b20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x4877e57370da64a8, 0x04878fb2218c022b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x0383e03b7f0a70a4, 0x543bb4011d6860a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x0c5046690d27f94d, 0x798055a255804a92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x7c1b16d45679306f, 0x1d97422c55190e2b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x505f132313545ce5, 0x2cce3d8107e61b75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x6eba89836d8e8fb1, 0x774d8da450ce6c21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x11d6e7d7074b70b0, 0x154035a14eb21d81, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x10dfd6067425e854, 0x6f9e58a23f7e0beb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x65004cfd3545c218, 0x610a0e175957bb79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x345032bc704071c5, 0x76c01c2268842d38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #24", 0x7d686b125b9bb9f6, 0x3e0477ca40a07925, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #24", 0x3214ea664287c4d2, 0x15b98751798381e6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #24", 0x55dc21b778b72aff, 0x01699d5b0273fd89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x6645bab168829f4c, 0x534269aa4496ab3b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x6fce0ffc02e7215e, 0x1348c8bc781ca288, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x770d09b318a4bc8a, 0x379aae7300ade602, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x4dea7ea250c5bd9e, 0x5a05a17c5c0d56b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x41062f630295fbb3, 0x449183e8023ab15e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x5e31b5a95894b1d5, 0x42db2a843e6e9a75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x1b1c76a7395bb9b6, 0x37f21c5b1046a00f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x3212e4b665fd0743, 0x12ba9d9970f8985f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x4e7fa68f48d80c56, 0x358f439a18589f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x4bbf2db5480ff062, 0x107541ef3e4db68b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x60b4aced19013e0a, 0x3efb9c8e42cc3768, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x69c6fba8636b1200, 0x1ed98e182e9f2b8f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x66010db373b50772, 0x30d9dcee2acd2b0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x4c49b947212de1dd, 0x693bc5814432c35d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x5a899b9367340105, 0x5479636c67662fee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x4d3108490dee0be7, 0x585ec84d0c9c8049, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x56c6183e356a619f, 0x24f51fb01bb0aed8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x7d7a520218fa01f2, 0x59fe6564228545f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x31fb3ffc042b0b73, 0x65517d5b5e2efeef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x67961d733da8076c, 0x0cce2a7e1bc23ba4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x315d0ede2fcb2c32, 0x468f66b04d972b27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x50f90e0f664351f0, 0x11c9ee847da6c825, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x4d7752f63d6bc061, 0x650cf8142b82a9a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x4b59cc495d14499c, 0x381f29ec1aa85b3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x127eab3c10576f7b, 0x36590a17221fe487, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x2951716d29f6a7d5, 0x44a52a7a0ff8fd3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x2e21b3487af626ab, 0x6e27fc2d5b4cb169, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #28", 0x389e2e183d9e53be, 0x770eed0e15b7d0bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #28", 0x6d697ff07518ea66, 0x634efbe269fb3cf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #28", 0x5b5c3c574caefd30, 0x67a2051c3e628dff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x0a1abd912204618e, 0x69e537a228d38f4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x7f18ab2a79d4f4a3, 0x437bea8c557489da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x0a2c641f3c3998db, 0x77946e6111975666, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x663040b00fb84fd1, 0x219053a4337dd58c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x0aae767d05d97404, 0x0eca86f61451f3f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x4377c7c20d58c096, 0x2a09c4b4434ca495, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x0271aafd14e9e6a7, 0x2d47e18b30e147b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x6198e3d759290d54, 0x6f43d5b25dcde754, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x7b2d6ee24a1d612d, 0x06a176a16bb3a169, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x43f255d038bc99a5, 0x41282b437a461a0d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x74f632802d6dc418, 0x0bdd70734e1eb9ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x3d2613e910671672, 0x019c8f7c5b267331, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x16408a7619822bdd, 0x6f78672947d48a66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x26daec7438691087, 0x0b212efb59b85238, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x4d52f72e79dd6f9e, 0x0a9999eb294c9771, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x53067cf20dbbf566, 0x071a7ec52eebdb06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x57d956935bc7a7b2, 0x1a9f7c6f4e33ebd5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x1484415754577655, 0x487a05e21bcbac63, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x01c53a6d6b86f5cf, 0x69ea6653097a73d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x7bee0c4154194e32, 0x64a0e7093eeb4e57, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x6d9b7a1011e107b9, 0x06bfd8bd122e96b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x4a4a1840768082db, 0x6be6e8ef14766684, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x705df27944dd7cba, 0x3dc2fdf5179d0f6e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x52997220612866e3, 0x4688ea7443646f6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x3cf00e965a126122, 0x11985b402a72c8b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x2e69d7783028db69, 0x463e751651744fed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x1bafd1383f8faace, 0x5aeec3c5302f11e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #29", 0x13a8f90175da38fa, 0x6f1a603c179ddd79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #29", 0x07bb40b315b35d20, 0x29cc743001447311, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #29", 0x0c33dffb537dd78a, 0x15bad995520558f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x185b5444302b52d6, 0x69a268617c91d274, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x1153b9b9518e9d20, 0x3ff641df6af4c664, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x2ba0fe425ba6042d, 0x15678f174e43c84f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x0bcedf977aa6dc02, 0x1fb8183d5a0ad5ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x3a3686d1795447dc, 0x0a39e7a0277eb0cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x6f2e80d668e90279, 0x3f1c8e494ddf7fd2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x7e9c5f9964decc78, 0x4f23f2e376e9c189, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x385ca402329182de, 0x48ef1a7c0ad03f94, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x62bcd5b4475853e8, 0x0762120850b7f846, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x18e6f10851144dc1, 0x3bacbeaa74108f6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x2cba51ee620c6ffa, 0x425457bd4487ef4a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x5cb34bfc28ccaca5, 0x1e92c50538893185, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x2220f4811f24709e, 0x6007e25516e9d2cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x080d731733ed4582, 0x64c9529f114f7558, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x18cc11fa5128515e, 0x083936e106a9d2b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x03b9d43c18dc244e, 0x117a12455128b5fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x603478365d8d6cec, 0x21e0ae426676a9f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x2ea1baad1cdb911a, 0x5a87395d791b693e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x7ee801145c361d8d, 0x3da358885b5c0c9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x0502ca3273ed2076, 0x13e53e215b9b4d11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x13119114574e727e, 0x72851fde2723beb4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x0b3bb80040ac6aed, 0x3873340c1b1f042c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x11d4bc4b3342e922, 0x21c8d6dd2407c9fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x4c1f0d7017112e3a, 0x75307ff7158e9087, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x749e9b26568c73d5, 0x7c053a772c5385a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x736804ef6312476d, 0x256eeee4234055d4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x3f4864fa1281a091, 0x7e9c627072500604, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #30", 0x066ec108407072f3, 0x4deb5315444b2f2d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #30", 0x17bee57123e221ed, 0x6b6eede11980521c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #30", 0x648e8cda56682d25, 0x349f564822fa9d72, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x09ab16483c32e764, 0x4702676d76634926, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x5344159e07f71425, 0x0bf1d9ad55ca23b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x5e8387fa278c9843, 0x021da95f47e2b0c5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x0a9edfb069bf6909, 0x6b23069951eb8ce9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x7c41099a1226e602, 0x443b92ed49e744ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x529758f679a161b9, 0x0e3273d802afcaa2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x1d8383a650cf7307, 0x1c301cbf6a563e67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x2737a02d54534346, 0x0d50dbd902121080, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x10862aab04673354, 0x787559a630e2b675, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x0c5e477908ca838c, 0x06acda2d63ca4049, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x30571bd016cff7a7, 0x2bacf10e6ae1cf73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x008f60b00108ef4a, 0x3ccd5c5c3af5fb80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x132fd54c130fb403, 0x04dd402b7cd06a4b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x0cb115bc1bb051ac, 0x7f8034ed65c72e42, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x6c7fc4b45d6e4883, 0x501d6caa2a349962, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x31c18bca24bc0389, 0x2c46a9e313b764e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x292336dd4b46f583, 0x449a1b564247b675, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x5411791051bee7cd, 0x2611f6be35817e56, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x688edf745d30aa26, 0x20634dc9046894e0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x5e399970443bd08c, 0x3f5e9060691e4025, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x574b848f656edf5d, 0x65eeaa7071696ebc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x011f310a274e09a9, 0x57309cff63fc9a4c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x04bc522c3a77dd91, 0x0e3133ae6d9ef5be, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x5f33e11b45f075f5, 0x01565a9f367dddf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x11376b781ed78b2a, 0x78c5946b085717f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x709672f75e3be418, 0x3dd8964f6548e488, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x3b6c8e3e291009c9, 0x69b179685925526b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #29, #31", 0x6d4bda5528323d00, 0x4243929019a627ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #29, #31", 0x0da11c5e6240336a, 0x0b0f966b44975ee4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #29, #31", 0x098e3d1336c52cdf, 0x2893f9300ec04d68, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x713d0a707db59dc5, 0x7c5f43260e4a8f3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x43a613ba3d8e01a1, 0x44c86d365070eb8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x5c658ccb16a099d3, 0x58c8038454dd7f32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x74dc7deb23d7dd23, 0x3a2663bb4cfbffc2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x4ce7e6ec6864e4be, 0x2621522e30490c2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x109721bf54feca43, 0x49ef33d83a33c141, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x373efdad275f1956, 0x7ecb20261e383e1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x5e2446352957ceab, 0x2cf88b8540cd3ac0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x270d6c7013e03736, 0x4f17ca004f6150a6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x516e38d7789a3fb5, 0x1fd23c316ab3802a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x0f3ad98879b76317, 0x3f90ff5c2dd3c5a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x1d8f403b20f11793, 0x7acfc56504175774, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x0955fc527e4f9776, 0x3460639e6a772727, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x534e61ba2376088f, 0x24aae86919ed1e11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x4ad521e5651de7b3, 0x38255c2e0a8d5f67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x0e75b65e1a726428, 0x4b5a9a2828f9681b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x2e529b5e182cf4f2, 0x785ab8c1358322ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x10c734a85fc7a254, 0x2036a2f87fc0d435, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x597f056c28645f3e, 0x2d9499d820020e30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x495576d15879c942, 0x241965a4770e45a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x56c960b906305537, 0x61856cce52ab7323, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x29a65dc624bded62, 0x6c9891342a17c273, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x09dbd5157fffbc02, 0x34a521da747b7fac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x1a72202a15cfa088, 0x1d74e7c718518b73, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x2dfc957a6e0b5139, 0x4dd4ae4148c4bb88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x4dd2f38e761a2996, 0x48858fbe3ec3ca22, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x1e7e88d402df3df7, 0x5ec5d8532751f8fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #0", 0x5b59073a7fe5ab6f, 0x1e603ea167d3ffa6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #0", 0x061600a7271803fe, 0x3a7f72c9322267f3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #0", 0x4bd5f16010df4c40, 0x5c3a2a662fbc5e6d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x10df084341acc5e0, 0x2437de1955b1c676, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x577c66683bd8002b, 0x6e0351e92b51286d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x29e351643c9b73b4, 0x7415e3f60578fbe3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x32b59d4a23029e58, 0x443cc60577b644f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x25e1dc503d687c8d, 0x1f083dec5134261f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x3d4e27fd7387988e, 0x390825c5013ae38a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x1a9f9c8c0f9775e3, 0x335d4b7d436428a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x2076c2231758652b, 0x7320871166758ded, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x59052b0b2a2aa64c, 0x3c2754633155ca66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x6602a67750bcd6ca, 0x5ca6f2d430819174, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x0d584a7e7a37535c, 0x35fa8d570fe5f7dc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x1d39f1b526a47abb, 0x079c3cce400de7c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x640cf7484a4a33ac, 0x11420de7431bce05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x3dd1cc3b77b3fd0c, 0x4456b18f215b1f45, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x074b72ef57dfcefb, 0x64bf47e9587168c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x6f3834267b0e4b17, 0x3ee6f6b427c23512, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x2538f16435bef24d, 0x5917ff79483d5f31, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x067bc9172eb97dfc, 0x78bef0a50b3b97db, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x28f0d15922bdcc86, 0x1b218fb713d41395, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x4962474165240945, 0x53e1fb5d462ac30e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x2f6e3cf14d9d42a2, 0x094691132d6f3e89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x45513fae3389a5b8, 0x4eca5dcf6d40092c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x0b6974b3049868a8, 0x45b171f44c9cb29d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x7fa6b3c04d76e728, 0x745ee7af7aa1a8d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x0335d9753b9df8b0, 0x42df080b24dfa524, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x6a5776ad4b3cccb7, 0x301b3cff09b1a28c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x6dfa993d7167b17f, 0x1d85b62113484806, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #1", 0x568bbac462b99c27, 0x59730b14375ce07e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #1", 0x3056dec933967cd6, 0x64cc1f0705f9f7b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #1", 0x6720228f38eb72d6, 0x733a00e275a81e77, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x3d83db7e36a3b8c3, 0x4244d11472899742, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x041a9fec300a4827, 0x6d2b401c3d2a8f3e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x6ba840d712257162, 0x620a346207507961, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x5d623e192e87d20f, 0x11021bee55ffb784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x1fef838e42bb0a9e, 0x6947ff8a4b5cd756, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x2574a6c56785d6db, 0x02b9b7d4767b3e52, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x1b1c53b26faf36ea, 0x7c75360855cb858e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x289aa9c00db87519, 0x4b73a405023c7641, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x445c2ddd61f14d9f, 0x74c60d83661e853e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x11fb95c6055348df, 0x2349147d4876cdc9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x1778ba4160c96318, 0x4fc7472a7da3d69e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x0f5135283ceb8dad, 0x53a38e2274daf85a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x7fa6984b42f18784, 0x4037cfb02f40b8b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x2a775e6022312d11, 0x25bbf709251b3f11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x11e063fb465a68a5, 0x7ae6c49f4593b212, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x5412ddbe3c9635d6, 0x47d028533a7b0dbb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x1e87837643e2a776, 0x209992f9186f0b9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x4935f05630ad208f, 0x60e5d9643083193c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x117683a701ca7dfd, 0x2e26efda60aeaa97, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x3eb60baa15c172a2, 0x5589a2f220c7b8cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x58b2fa2775c4688f, 0x500871863e5ca3f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x17f595a05e5ea7a6, 0x6377e306032a5887, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x24b9104b108e32ec, 0x48be0a9929d5f99b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x4d2468c204ea9a4f, 0x6451075678cbee09, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x48cd41c67220d309, 0x113af9a56babec38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x22cdf3984a55f54f, 0x1c2f05751203321c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x4c20734c483b7fa5, 0x72b1dcb334447740, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #2", 0x5dfcf2482514a195, 0x550c300f0ad67ef6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #2", 0x1ad90a242cab05f2, 0x493322ec36afec6f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #2", 0x0b09ad9802984f8f, 0x39da44f632ce9fc4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x1326827b40f5a0b5, 0x5ca4995f2fc2bde3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x45e03b0539c9a592, 0x288eabed604aeb3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x2bea789b6825dceb, 0x4bf6d7760ead7ccb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x327bd23a13628b9a, 0x20b0aee74eb86c34, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x5b9e0b4058091383, 0x02fce3747e9c4587, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x7d1db51952a5e769, 0x0972c47d399afd88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x7f50ed5c2a252eed, 0x704ae9f717f6bf3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x2cbd7e7c2769f861, 0x4ac55f020a5a9af4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x685f991762ac04c5, 0x3a1d58d83fe400f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x1c75aa576c25c3aa, 0x202eec342e3fd41c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x544ba0955d9dffce, 0x3ced50e7486022f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x71008b681a15729a, 0x17188f2606c772d0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x721e861e0ed67cd4, 0x0563b8574c9e96a8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x617c643e76847e27, 0x063994306f3c3b37, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x20a9ad1451f85976, 0x0732fa7460cd519a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x796251d825454566, 0x6b27ec8e4d672b90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x07f14a2b2d7a18bc, 0x0d4b2c8761c1eaef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x199fdc664cef0ff2, 0x1001bf0b2466f482, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x2a8d0fc003dfa69b, 0x6cc717756deb7cfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x1df519367a16a823, 0x74b2efcc1b8d9b28, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x08ed24f76e65c601, 0x682c31d110139f54, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x64ea44290682d4ff, 0x7f4fda8b6a698935, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x587b2e76365ec75e, 0x4b36dacf0593f13d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x5ba40cc460464955, 0x52fb1cce51dd804e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x0dc0621143a12a48, 0x339f6b3d639556f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x10903a3a74c362e7, 0x07fc4b7227603e78, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x78a3098309feab40, 0x154bbb743b1d49fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #3", 0x041553633ed716f3, 0x56aae522169822b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #3", 0x2d3cdcf525fb9c98, 0x26abc20d0d02785a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #3", 0x2c7e719742a2dc5f, 0x776c01901227211e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x7901a3bd6ab62f29, 0x17bb125b04f9a00d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x4afc787f0a768b98, 0x56d7205b54a5b082, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x4e17b5e0403752e4, 0x383b077258bcda90, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x34fab5cc1568d47c, 0x001d19085ea7f01a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x1f677fbc70701f37, 0x19c53a142d9dbf4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x2f47362a6ae1a415, 0x4435e208237cd31f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x10dd40ad27eb4d0a, 0x307f4b7a5c84131f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x6a8e296906664699, 0x6eab343d3d5bb244, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x711c75c2192c72ad, 0x42555252638fcd27, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x23a2fe467070851b, 0x38357da93c18ee41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x30a7d7ff14f2e1da, 0x14d5c8d271bab426, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x2a5bb6576a27de55, 0x5062a44165a28dcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x5a97fd8c57762f22, 0x13404d1a49c33613, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x4257d3371dbf54ad, 0x6d40093309df33b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x45aaa1b7550e7b14, 0x666346d6533513e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x5b74c1ad52e6187b, 0x1090c6293038cb20, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x6c128b284bfe15f0, 0x13c898474c91376f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x3c6e9b0b1d7fee83, 0x08aa25b10fb5896e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x3272d05d51d2e1d6, 0x01703d956d16730b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x3bfac02b65f94df1, 0x52b900d65cce86b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x3d6f7d1313d1c5fb, 0x2691bcc81692bdb8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x31911aa806d53845, 0x2071f16f7fc7504b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x5be3b359638d2a58, 0x52fc642f773bbc5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x367342d33b3d1fc7, 0x2774877f37587506, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x073b35b70c93d227, 0x03e9ac762285cdfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x2a13c0aa33ab94ff, 0x323b576a43a9d0c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x057e76d5037944a4, 0x30c043ce5c869107, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #10", 0x697292955fe6d484, 0x395517bc41793701, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #10", 0x73b89a7f787de628, 0x580bf4b926e20fa9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #10", 0x7f531e6d79a5c423, 0x26a95ff42549b527, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x5d32ee7c43f9f905, 0x1c8571865b36d1c7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x7f3718cc1678f343, 0x128f46cd13a6314f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x230cc56a686756b6, 0x362bff4b06724e84, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x1c12ebb57adc6315, 0x4a1c1f474d208614, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x7e55a7b962fc2ed8, 0x29a7171c2191628b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x42e3035c3b168e45, 0x630a998c67c83a4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x3394746d3553a9ec, 0x0eaa49f8369b9ddb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x2ef96e0f786ac488, 0x5be5530232e792da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x3c64bd8d20adab6f, 0x0e1e64a10c2c5c8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x37269eb255fe8d26, 0x1fd28ddb3b9bd65a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x3e65e3dc0c2a4425, 0x420e24de5a33641d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x0706a73a50fb014d, 0x2753ea315a78cf92, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x33f730255f14cba9, 0x7c0a321d055c4ef3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x1a2b59ee7bced33a, 0x6d24894276da3381, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x31227d26095b245e, 0x2d75d15c4dbfce5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x01c5e8e60ec5c5d7, 0x00a76135601beb36, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x2f7371460c1ad59c, 0x6c4847c13e2aa674, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x621962c33bd4a1ac, 0x79c67cce669a0ff8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x47fee5d168215e47, 0x40cd7415207f469f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x391c5f947702484e, 0x7af816314f058d0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x561713f741866541, 0x5461dbfe6d138fba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x3d55387b11639498, 0x63edc33b70426de5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x1abeb8f63ea99d76, 0x3e023c406e77b5a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x4d6f634d3adbe899, 0x4e93a0d81c84a1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x46f6be365475c51f, 0x5aaf48517ce2d493, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x104a66cb244a58a1, 0x637ce48b291020f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x0c6bb6e844877dca, 0x498f679858494c9c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #17", 0x3b89c6187bb0b5a5, 0x274ed9a74588167c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #17", 0x3d371ae616896972, 0x329ba63611a0da10, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #17", 0x27ecfe0a3fe58436, 0x01e347f57a8c5362, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x7e8f21ac3797a9dc, 0x6904090442abb700, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x7273927539dfa12e, 0x5f3058dd4bfe84f9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x0e55664d2c5e3e17, 0x48e1598c396a50ab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x50a896b82c09d93d, 0x627a71a41e9fcd18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x709157071e37f35b, 0x76e919b45d144da0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x19e8a90155380a53, 0x229c641d2c1b1d1f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x6bc173c53f9f3f25, 0x3dbbf72f571fc3e7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x7f84c35b3ab0204d, 0x51ac174913ae71cf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x7247ca29358a81ad, 0x565a28d07e13e507, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x6f6a22dc12f3c38c, 0x4a126a0064bb5c9f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x3f5201a300a01eef, 0x1e25ad4a7dbf8929, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x2ca9f82c13486ff6, 0x1c5f56420ffa985c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x318063520fab4a19, 0x6d0ee5fc1d3b4f33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x64e3546d07126382, 0x49566c524b690c53, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x46b1a2a77434e784, 0x2288d03a50a4c832, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x2ee507d13aad62d2, 0x64533a0246366602, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x7037e47f0e5cb509, 0x444a4b09212cd1fb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x21507895240ddbe4, 0x05e82e9a5fa2075b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x24adfad379c0e6c7, 0x5d61908560a27a38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x0d0956bd5dabf891, 0x709d12945157f2ff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x6d5742aa37e9ae85, 0x6e9342323e89ba0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x3efc12072c7b969d, 0x09f2c662523a9717, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x20b07e210732994c, 0x22df5f4a05adb4ae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x41dffc1e102e65b9, 0x4be41ab04f9585f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x1e8b1ac276aa8687, 0x70c257ed3217e09d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x1ab8626c6f1b787e, 0x11b9e7f93fdb9357, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x68dc5f45111b2024, 0x207e0d8f3f665d3f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #24", 0x6ec718b57f519271, 0x10be503f75e5b602, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #24", 0x373b40f63e623674, 0x346f70125c1e5b5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #24", 0x6addcd11513851c1, 0x2e58f277763752fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x586aeb0d47c9225b, 0x7be507ab0b8e4b32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x57f788144be62912, 0x5b23d1251a4ae72b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x4290af9a5e1cafc1, 0x4c62c7c87682a2d6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x4d38283f56dc43bd, 0x365e362d5d491206, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x67f763e12d6dbf84, 0x1caf6f4536148784, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x2cbf51f66069ad99, 0x2bfa3d8756be7c96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x1ecbe40d6135ca6c, 0x32dcd7f563fa92ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x326e1c2d5616ed95, 0x5a31e5ea09a9b11f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x1de00ff1705bcd76, 0x1537fc510ad9073a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x3c41f6897186b62e, 0x2523ee6575d79805, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x4fa365ef22b87109, 0x6c5a3adc7ed2a623, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x7994b4c678cb276e, 0x5c1bb8291cdb8e2f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x2638e6f37eea533a, 0x52f015b3618c18a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x5f5400d36b276d33, 0x384a953d52f838e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x4c5d379f1124b1bf, 0x36f2cbd57e1fe4e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x673b9f551d019251, 0x07c996007ecb53cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x0d5d5fc82ec8496d, 0x09a45b07051baf46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x204eff9b674d8227, 0x7af3474b499f5651, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x0a05f331248db49d, 0x4871fc746ff2658a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x1d58dc0b5fbe096d, 0x0ccdf3b9039aa7f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x5ea85ca71d7155dc, 0x6526c09f4391c2fe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x0898c30f4d7cc7bd, 0x1689fbe73dfc5d7b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x5ea1797c43e5d85c, 0x3c1c425c54f5faaf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x60e76aad5d65a983, 0x53c14e7c45dd18d1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x0c2df2f045ec0f63, 0x4af8c8176e44ca75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x2d39918a00561d3a, 0x37e420c62c7cf28b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x24e3d1d7293d4bcf, 0x1c6f5816373f84bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #28", 0x08fb553c2000ed52, 0x3ada2cb3423cade3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #28", 0x3d72432e1c586cc9, 0x05ce70e167a3b1e4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #28", 0x69d5348661bc51bb, 0x25a00f5f460b063e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x25a22a176ec24f69, 0x1b0100ed4876ae02, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x4c27f8ec594c8eeb, 0x0e53c6d4068994c4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x1f389e4e2cb28000, 0x74ce5f3a5855ebdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x2d089d3b2142367e, 0x04d2de684c722fd9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x4a7f824e3e8be147, 0x03b1b49451ec6f12, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x5e8cce9919f78dd7, 0x14291cf5537ad78a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x364ffaa060be98cd, 0x3b1e896e1bff11c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x427aea887d0b18f3, 0x620a180620252f26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x6bcd685c76efa3fc, 0x689bdd28681d149f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x503c32e86375089e, 0x6ea6a96437f56148, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x1027889e151e2b8e, 0x104b4d256f74d136, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x3660620c3f98b5a4, 0x3be7010f3d3025d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x7e2496eb2345b1e1, 0x0f1c94ec00dfe45a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x3d3d3fb80f794553, 0x545abbe55cb16585, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x7037de215aba8f53, 0x78b0774d738d3a58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x57c5a8467c4e46a7, 0x13b2697e32b2c8a9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x733deaa3097686ad, 0x1acfdd49439310a2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x6ceb8f4b0bd3bf10, 0x7b8871ea437a1d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x20f1ea9e6ed5efd1, 0x32eeeec27d1317e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x2e6ea575495fd2af, 0x3a433dc357524caa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x6ca584902c8cecea, 0x583231052c933c61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x3c06323d01f51933, 0x0944a1e629e2c449, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x5cafa88631226820, 0x1d6ffea12c3e105e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x2d70aec779c0b651, 0x5ef0d908347550cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x03373cfe7390d358, 0x7808616e20ae996a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x7f6492681717a5b8, 0x6428b6f67022cc49, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x05ed9589277921f5, 0x6d35e43220567d06, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #29", 0x70d8f4a44fdafab6, 0x77a8c9b1345c3aff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #29", 0x7c67e7a06a341946, 0x60ef77605d7e7935, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #29", 0x6c29327924d13c1f, 0x07613d7e386e19dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x55f3a43f439d0344, 0x64ac2a3c48d8daff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x3d5db99575568d39, 0x7d4e2bcb03645306, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x68e76091083ba367, 0x2412ec714094f693, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x1f53491f1deda70e, 0x30b7c2dc684bf2fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x4566c904004b39b1, 0x08a270002540dea8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x502634673a8c9107, 0x599d19a7363fbda8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x24c0aa4d1b1f745b, 0x13be36dd4c8e1c07, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x3ff0b07b69a86021, 0x04fc35e510e9dcc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x2d4563655710e390, 0x59c2b7c515e454ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x4c6770c93d5b9432, 0x1948a7c16aa31cfa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x459737995befd669, 0x2b38138d354ed15b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x79dd7d77263d3455, 0x1d9ac45564ea80b8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x26886e0763c87908, 0x0a2b5f603f44467b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x1e550a0f09423b01, 0x7584042476aea26e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x2461af5d4838f45b, 0x433cbe764315b45d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x31e1547c2dc248e9, 0x53ff912364525fd8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x04d32c79137f5c53, 0x7a36b4925f26b7e1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x50daf0857501e868, 0x49c9d4db513a9d43, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x50f1bed1242432f3, 0x06896e9e1672281e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x4a61674805880837, 0x7b5ca8d64acf3c48, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x6950813f7f9786e8, 0x0a1382c470e9d54f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x08d9c1e92ad53634, 0x679877be07a58b4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x730e2a8f1ebad0cf, 0x4abb3fab2d3b7146, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x4c7d19b80bc485b1, 0x118dd11e24ef7f0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x1f43e2044de00bc7, 0x041636ec51504631, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x42e1f42f29145212, 0x228ae374701ed28a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x4d38850501eda37f, 0x0690faa813d3b300, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #30", 0x0775abb668b6720c, 0x5ea2ef481799ec4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #30", 0x684df8f4701c395b, 0x0883c19d70c62cf5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #30", 0x1af16f8f4326f7ef, 0x786bb8437127bade, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x61e1c8be2ff0fd43, 0x1e632c240dff9a1e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x3bb582f437055015, 0x32ef19292e5ee276, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x04e55bdc223a0c1c, 0x7faf28a75af964f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x4b4e5e2e51a9322b, 0x4b18378247c7500b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x5396d5aa3a3df254, 0x5b9b030b1886e334, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x22f4646038a4911f, 0x3020cf825b0c8160, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x28c0ca7b443e6698, 0x4bd2ae550b425d55, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x07655e871acd4457, 0x7c6a183343b23a0a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x4abe419a04a0ed52, 0x51b1d42969472745, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x3ba63d6817553263, 0x17a609bb0673c48e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x398f3e7f2c856109, 0x616d2987408b9944, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x7e2e933463edec5b, 0x0852e95004dd9cad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x1e2bdeaf4d854f63, 0x1d647fe151c568de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x0629e08378a49893, 0x2cd1ea3e41204310, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x3ce2ff2c48ccb898, 0x4c62a0652eeaaafe, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x6399fcef444eb931, 0x729ce50844485db3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x48efa68445358eb4, 0x2d8f84f92e583e8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x5c8ac11716392c9f, 0x34cc03180495e3ec, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x42be8da94d746680, 0x45217d301619ff96, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x316252dc385c1c25, 0x1af79c4440ed20dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x05e16b893f8473fa, 0x12b289bc4f8e318b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x38290c8e5d111500, 0x10ae749b0c0b4c0c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x25ddcd982d92dc12, 0x3af5f70a750c0bba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x71e1954466e3ee66, 0x3954696d0977ca88, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x2c197d1b6c9c0c2a, 0x37d009123ad13bc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x02d538ca04889ce4, 0x3f671fb408a43e32, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x51fd036539b5da0d, 0x1ebe3dc94593c673, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #30, #31", 0x7211f6321933710c, 0x0680e750035f5641, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #30, #31", 0x58b7e507639bfc68, 0x52ed87cc77f361bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #30, #31", 0x40ad11683ef4a4d1, 0x03feadc710e0f195, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x6c8780e43f4166bc, 0x05ecfd4f668adf01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x2625552327d2b29b, 0x7002a9895e691628, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x146ebec558a171a4, 0x193a51f0523ed23e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x5d2a0e8879a14e39, 0x5ae310701743f78f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x335728466358a553, 0x5cd7be022f2711ed, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x7c8c165f0573effb, 0x3286682e25691e79, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x690fec63215b2dfc, 0x1d5c80345543fb66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x604fd2cd6c11ea4a, 0x6624ecfb29bcfdcb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x2b535107004a8655, 0x1047dccc4cd753b1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x281d38f0447abbc9, 0x2b4069d95178a62a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x1d1c2d6d7e9a88d8, 0x23b778683c8bf7b6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x783bd71230a7ad48, 0x53cfef457a463bf6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x1400529b5bf3b612, 0x296d4de32b92ff58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x6167a60d6e589e06, 0x50fc1dd1108c68fa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x0fb3cc024bf5515c, 0x65d064614a779270, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x38073ba7047c6d08, 0x7434903b70039ecf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x04c6f35d681b5c5a, 0x3cdaf281635a8cae, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x2c961824588aab40, 0x34d332d82ce42c4e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x572534183d401349, 0x6970240449b24591, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x6de7c0916d65cf6b, 0x43f881874f610b2a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x4959857d4bf02854, 0x7af40a8301e8132c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x3a48c65a7844e088, 0x12747c272ac12b8a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x443a31e4696d4e35, 0x7538bdfa49fc925c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x6de9bb3d76db23ad, 0x3a00312c7c416d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x5ef68007146f2d11, 0x5f9bfa3972b0ae9b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x6cf9d8510904feed, 0x1f94dae90b8c982b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x4645123619375f44, 0x553eddbd441f0c6a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #0", 0x069d2eaf0e742217, 0x13801794342cd2c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #0", 0x5a644a6c4889621b, 0x3614e5f44ff6b42c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #0", 0x40ce42a36ff09db0, 0x7ab7dfb614ad10c6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x595debe618a9d44f, 0x5ea9a32305087488, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x0f84f7fc60e5dc4d, 0x0149e2134747a723, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x7555095e598d30a7, 0x39f855be6e7b7803, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x62922f944f46edec, 0x7a08102f624ee1b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x687e4d3039ee05ae, 0x266dee1a28d741cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x486227c61318fa87, 0x5d0414936f1b7be0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x5ba25ca339ca0fc3, 0x3f12300c22c67232, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x29baad73161d261b, 0x377382f81c709f46, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x2ec6fa6a22c2f5e2, 0x217913ce03189959, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x03a8d22f0458963b, 0x4a60407d3e4bf266, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x5de5c6e326cf7a99, 0x2cc76a6a78fddb8d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x7616688501baab57, 0x5b4cbd3d4077f677, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x3ba8b10646534cd5, 0x694f38425e94b5b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x596c475d0cc261a2, 0x4db03195040ad8cc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x468c71655e44cdf6, 0x26d14afe350ea400, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x7461f41272f85715, 0x517f434670471ed8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x15bb4cf73dbff8af, 0x735fb8322328ee7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x42188eea0e3c4b4d, 0x6174e0e319641f26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x350bc5e66daeb7f1, 0x1261fab31ffe55cd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x6f69634849c58487, 0x60764c452b222e6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x1018d15d576715b6, 0x09b6e4202b12144e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x6429775855ee3818, 0x2f1ced1a698518ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x3433060f70130000, 0x1e93bcba2ab5e8bd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x630b57150e5cbfc7, 0x1afd07952894fa21, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x4c1cb8762d32c980, 0x4bbde89d78c6a40c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x3b6f14cd248cbde6, 0x122ac3320e354761, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x123b75d70ea9e973, 0x2e339d2e707adab3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #1", 0x586f6dfb2553ed3f, 0x1b9d091e01a4d91f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #1", 0x7cbb02f55bd3da88, 0x2cb6ed6e68883f58, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #1", 0x31c212a170a114cc, 0x520d581260e47a4d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x60b414cc26976a9f, 0x0b9a630a65f518b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x34f42a675a47fb6e, 0x0e8a12d143bf6be2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x077ac4ef4eb0d321, 0x3c860fee0110e2dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x733d91073d79c76d, 0x0f462a3e42e9d9bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x4c23b0e04f01bd8e, 0x3364b470057906de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x7455aacd33d4cd6b, 0x071ddffd24931edb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x0fa8a7f45f28b645, 0x0d1b5e337110adc2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x4fc9cb115d8f8b19, 0x51f5280f416aba95, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x0426f5b935e9e616, 0x275fd345307ddfde, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x1031e18430c35bae, 0x743d4bc0391b2020, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x7f742ecf49722d3c, 0x3a2c02fd17aca673, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x06ebf4a90dfb34a0, 0x5a96803072b1bfd6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x5cfcf22e7f48a6b2, 0x782ac6b4530fa589, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x331d741d04be2298, 0x77a2c46551529cfc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x63e6d8de145872ce, 0x42634abe42c61c11, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x71e7fde72b90a9eb, 0x0430d6a633b0a3ef, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x617a9001586bcf8d, 0x642e83cd760ef3a0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x092f2b3c695616be, 0x2f2a13c071ac7186, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x32c843fa63ef9829, 0x095917f908a35a0b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x71eaccc9737fe096, 0x7b5519e239b438a3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x72c887480466a291, 0x0cc3de2c4ee7bef8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x0924c52a629da6b2, 0x203a5bf425e5fb66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x76f619806cdcee1e, 0x68ac17776d0b9e08, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x186d980904eac5c5, 0x20bc41f768de1768, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x5d5695520e171ec9, 0x5eed0b0879e8280b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x776d358774edb18a, 0x6b9499916685c08e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x58dd49b46a7e347c, 0x6f291a9a2a357981, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #2", 0x5dfe151270ad9050, 0x63e9b2244ac8167d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #2", 0x751432e239ea3169, 0x19afd57550c69c5b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #2", 0x1c87d81c5f58af38, 0x76ac97c17e38f80c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x4c359d560c00d80b, 0x6b449614137df19c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x10eb9dd05b49140d, 0x7c5c090464a33560, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x696032d64a1ff6fc, 0x5e8b5d6b6e423323, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x3f0da88643f10e4b, 0x54c7f3b160cd685d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x2e6f42c76eec9402, 0x0b02e1de17eaf23a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x5f9a24527c62de2d, 0x62b308b80c6d57da, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x364d0f9753e08bf6, 0x5d33f43554ae5734, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x33393b2e3e2be554, 0x52e74f4052d4e7b3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x4a2cbd6062aee254, 0x6652d94f7f6ed885, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x3df7f661429d6b50, 0x64120de55b185b30, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x0cbd624c1e228205, 0x495a8e5327582937, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x6213905013287372, 0x082591944bcb0ad2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x02150774466905c5, 0x63b5fd0d1082d318, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x42cbe3f27a241f27, 0x1cf02af261af2bc6, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x4e04ab1d0944d23b, 0x365d82fb7918f389, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x4770b7903240b48c, 0x4beddb3c013de64b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x14ef96e064beccb5, 0x00acbed0119d74f0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x275c380536105e74, 0x6cb5d02052e78d41, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x5432e0790265480c, 0x7a3fb67834199a51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x158dbb7e639aa231, 0x7fe4a524364670c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x2a03a7f663b96ed3, 0x46c943e117a2c2f2, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x5ddd8dfa2faf71b3, 0x7951eeb86ccf8be8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x38f443ef31d65aae, 0x65e87f722be23917, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x64170f3a2dccde33, 0x2d201f630064fb7f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x128baae97eb8408f, 0x1202706f7906a61a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x34c89f03462de9d3, 0x4bee335b39e7e2ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x489331df6de62264, 0x6e017d4008fb7f7c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #3", 0x5180c495060b3427, 0x3f41f0465e20ed5d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #3", 0x69c4a2fb6f159f08, 0x75c3b04f7b846c8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #3", 0x1ec510bb4e3c77e5, 0x6853f87347a230f5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x0012d29420a48970, 0x73846a0d57b954aa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x4e7167a36a20c098, 0x581e50296429e1ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x68d90128291ebb44, 0x5d3087e960fd128c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x6f4ca51808e672bb, 0x1ae4f57b1da1a02b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x76cc951f65df0fee, 0x269d1fa837dfd6f7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x6bea44150bc474a4, 0x1600c455484d59b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x7ada13ac2c25beb2, 0x43d1c63f55aee710, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x7a62369810d58213, 0x1d511806199f2468, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x317a0b834976c93c, 0x715879127a75092c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x339789d43bcf72e3, 0x5e9eeafa7feb7326, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x64ee2e287bcd7b2e, 0x60e885b31c708afc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x04b3ede960af4ad0, 0x3a122b28543ad340, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x468e5abe221b6e8c, 0x0c1aaa377b808308, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x2ddfe331079fa2fb, 0x43cddcbc32789ed3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x33c561ad25789dea, 0x082785e428b9f6dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x364e1ffd33b19458, 0x42591b452e279845, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x7d285d94073b8c6c, 0x289ca17167c82b80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x430aff4f489c2459, 0x67b39ea630bfe768, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x44699f8707429d8d, 0x4d30726527f92d77, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x67f1e85d084eaaef, 0x7c3400b7491d8d70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x2a6a197b086bed34, 0x449e10782e80431b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x100b902f692067d2, 0x60f8e1ee5849fcac, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x0e9905bc435d0ecf, 0x0103f38a43d0f1dd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x770ea3271a952b94, 0x71f88a2244e725b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x21d0b8001462efe0, 0x2caf5139743700bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x5cff143972275a89, 0x24f6e82464dbb74f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x7969f8160908e57e, 0x0cd4e4c72168b3c1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #10", 0x1157906d2f2451aa, 0x6a864131615be073, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #10", 0x37903ede70d5057c, 0x0fdc238e3bc1a9e9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #10", 0x59f56d4f150f9a1f, 0x140ba695479bcf0e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x586ca8ef7d654b0d, 0x0b6cc0eb688e730b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x17fa76a15a24e9fe, 0x2d7598c54f7b4c16, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x6e87d9de68a934f6, 0x43b24cd239cb2ea1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x5ad08f7f2b7bcab8, 0x1ea6e5f14b86ee18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x3484b0365775e30a, 0x6cefa1d9543a8795, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x069a34b445728b96, 0x3596680845dc40a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x3647911215a99122, 0x019dea8d3e2a7393, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x2ab92b421133038c, 0x05c642a1103cfe61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x0e984e9926410a32, 0x78cb716d0325d431, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x0065f43016536d19, 0x52a120472692c53b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x7efca20f7f04d9cd, 0x605df3dc6eedce0f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x2a80a48527645e00, 0x3a74bc2759cd318e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x7eda410a639e212b, 0x2e07b9235f0554bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x2910acc1267f7fed, 0x24e19560057475bf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x3c29110f49652bf3, 0x439ee9525f583dd4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x5a982f7f6860ada2, 0x6f953c3566e23c51, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x0ea1b7d43ca930ca, 0x6a08108269307e18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x52fc9de370213730, 0x0fc343530f07ac05, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x6f2610fd386a363b, 0x7df57a1451f93ff3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x5fce943b59ce2aa5, 0x2bc6718119a6b583, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x3d6c4bd01d8d9f9f, 0x78ac0a3f5ea8d545, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x440d1f8c27bc3456, 0x641d4b04667cf892, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x71216049356a729b, 0x45d536660036309b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x1dcb203e51207d6f, 0x67186ced4bb98fc8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x0dc9ae3944ad5134, 0x34ea0de12c6cd812, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x34ce88643969fe2b, 0x3b74841760c64c1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x71d434665e85fd91, 0x32bf8c1023f49962, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #17", 0x3854283636475924, 0x3d9b4ee551a2c8a1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #17", 0x53d4f8c31468e8eb, 0x304b9de775c07407, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #17", 0x3c251d422212a2ff, 0x5c3d6c9917e2184f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x577d159a7f30b5d7, 0x181848ea2d467d8b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x505133472dea1b35, 0x79000d54754835d8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x72976c695d299202, 0x21b50deb5e1ae180, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x1693902e71a0b9ad, 0x3ee12d9d2765f4ce, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x5026b73f08f5dd15, 0x4b5a8e300867c494, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x3f3d36390a562b1d, 0x5a0a8d36087adf75, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x1ebf14085a78c015, 0x7e3b537c13122efc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x7c8b6314430c9035, 0x2af4474b5ae4314a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x423d460d012abc2a, 0x082aaed6540878af, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x2f14d75f6b05bc72, 0x4950ae87128e7954, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x482f4e752f8a8872, 0x70a95ad421ac43c8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x212b421f146cc6c6, 0x491238965ec2dea3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x1d62a3db4135306d, 0x672aa3377151f95e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x4b8b5b8a78082c50, 0x79ccd8d45c9fda14, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x5280ec661aa6505b, 0x6fb209106a4a6f93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x5db2e0914d594fb3, 0x452ea0dd4f0c4f7a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x4e840bdd6c6576b1, 0x2314c8291ff0269e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x576b33232327fac6, 0x327e9ff27d98e33c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x52b2833868575f9b, 0x1f4527051f9a8198, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x7cc4266265880373, 0x7e5d603b73ddc558, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x26bd33e05efc978a, 0x652fbeb61a26ca3d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x5704c3db6678ad62, 0x76c6a45272488f6b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x011efdbe21c19fdb, 0x5c92fefe2985b041, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x6f1aef8f1ba6c7e5, 0x7891ffbb5ed1de4f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x080c3e963140a4df, 0x7ec204ed3d9efb6c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x54689fa55a7d05ae, 0x3b37dea95f7771b9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x42d465497d6f538d, 0x7f11f352271b22de, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #24", 0x62f757000028a6ec, 0x1af8e8363f988bab, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #24", 0x5f253e775085fa3b, 0x59bf55e909b48ae1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #24", 0x36fea79d5890194a, 0x7bfd1a4c362a0252, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x7a51b9255841b24e, 0x5fafb293381da55b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x73e87a3315b18897, 0x16ef83aa696ca8b4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x46f22d76624382ca, 0x270ba4217bf4b8c9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x3cc088785a7e1dd5, 0x5b6c2a831b5acd1c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x57ed71625d6ed830, 0x4275effa7f94edc1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x5d977f1c18eccf56, 0x3f2d796d3ae4c863, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x6972c99140966d90, 0x449953443cbcbd93, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x192686da52967278, 0x72e6bfe52071712e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x2ad824c76f7e9a34, 0x588f168a13783fff, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x053022cc23f08cd5, 0x7ce4e8b41ec09efa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x06340f9f76218247, 0x1ab557c44c225042, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x509fa01c29f30d58, 0x677d1d5e42f49817, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x0761e58801b6ff45, 0x428985d8288d117e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x1aa3ce9b280b2d25, 0x6371d9e164f964a5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x68a19ab5149ce21e, 0x21b622380416982c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x673354967d171fe5, 0x2488095b01c8218f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x6c95ba1912254a43, 0x1540618f120b795d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x3615d7184b81701c, 0x30cc185871c5dce5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x41a2f26325654a86, 0x3de82d283c49e6b7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x4f5857df41c804a6, 0x7f3e7ece1242927f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x437f03ec1e417ddf, 0x3acfa3fd56ba3d67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x464cab045d69c445, 0x3bb3a20c5e22d287, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x7206a66306c1740f, 0x62396ab42eee45ba, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x03d893f445f6c8d8, 0x30b667495939faf9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x581c131b1c118caf, 0x6b457457706e4e0d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x6792fccb201c581b, 0x62342af30e31ea33, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x4581a2a149ba4fb8, 0x4a7bd0ea2935ef2e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #28", 0x0b82545f764825aa, 0x3b7881ad14d9fa80, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #28", 0x1489a3892747d9f4, 0x6b9437e84f01584b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #28", 0x04b19e390f5d9586, 0x2d242ad25ad64e8e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x161f09953a7afb91, 0x09c4944876b8449c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x0071c46a3b37b3ed, 0x4ff23f9619f79d89, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x5749409c6c9a168a, 0x0a65eb97588dd785, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x0cb66ea5313b92a3, 0x66bfc1b93edc3d67, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x7af5e25c238aae42, 0x68122c9552381146, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x19d2d3ec52a643af, 0x67120bc7067836bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x79ee1da3029db9d8, 0x55798f062e5c7776, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x11fb4f5f12f75a4c, 0x0932c6047e9fbbdd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x4d7255dd454a400f, 0x75580079281a58f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x0081f3fc4c77e215, 0x4211f67e4de41a47, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x3911f89f0d31b386, 0x2671f1cd57cb3498, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x3e6d46297eb99e94, 0x16a771ff45c86744, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x22444cd67f128451, 0x1800788a39632885, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x51b8c8001554ee46, 0x3fdb5f403c1720c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x17f2a81f73a65e3d, 0x6a7398394ba6e5a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x069db8893f9ea1fa, 0x4a46a18129edf77e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x04e8e20a141a46f0, 0x5208507254100e66, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x6092290548661a7b, 0x21f428ae056ad606, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x5597ce0173dd7c9e, 0x5d360a9f19a421a4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x72971b33776d0173, 0x5f6c88e81405142a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x767f85c40d439bf0, 0x4d683cb014db6809, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x22988a373b662105, 0x50f288cc48384dc5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x2f0c7f425e25d4ea, 0x13df33693a8b3256, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x1dc476e436817a46, 0x647929d435aa37cb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x4a9bc1372bae6ee0, 0x09ba463222ad58ee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x7414895b054e3994, 0x28182ef52b2dea3c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x792bb632243e94c9, 0x44d20be149ac575c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #29", 0x1bab963c2b19a836, 0x5db16b866bc2d165, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #29", 0x385d44275190c23b, 0x009e396f122b1c01, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #29", 0x0cf6e3416e429d2f, 0x5a6369c65af5ce5e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x4c68721979fa2a88, 0x158100b43c036283, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x307ba4ce7b67e081, 0x71ad9a4f6a2ce8fd, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x27164f6134f270e1, 0x0cda41ec7b176605, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x3a40aa756b175c23, 0x264550421b2ad8bc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x0f55f0ec42889b9e, 0x64d73018336c60a7, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x6da243d51fcd6b7c, 0x1f2f320d2b018729, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x715e2db717900cf0, 0x3d2ca32a25ff87fc, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x05d2aa1f1676570e, 0x00f5565a7e5510f8, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x107081962c060dcb, 0x3a58737c523b1c38, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x276dee4c49424721, 0x3c68053540ec2664, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x7e34b8026248dcac, 0x3c038c6a4e843dad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x4d6038cf4e864681, 0x69af166938756277, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x110ee21f0b10f52c, 0x6be1c31f5cb629bb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x2ade60a844e4540e, 0x07b7b0e47eb125f4, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x5c7460fe25a6044a, 0x24b0adf01c3c8e5f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x3c1c5b5854ea12d4, 0x1a919f5862470b1d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x00f0209f70ea2c8b, 0x348227554c8cdcee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x3a2c73ac497c8fbd, 0x0d790353285e0eeb, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x2bc56c6960916301, 0x76e24c9838612baf, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x2f17a9825cb85145, 0x70d68e267925a538, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x67c946715d937fd8, 0x55dbcef340268ba1, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x2277d3e663885f86, 0x3ed7b19612a7a719, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x092e63d14975d4d1, 0x2ee435797eec34e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x1e5fe7a515b56758, 0x61334002454abf29, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x069f93e31f509f6b, 0x11d79c181f500844, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x68cd2f283e9063c7, 0x47ae172f40cc078f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x1f21c6c86a03c165, 0x792d333e14929b91, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #30", 0x46bc12aa63940fbc, 0x0db840c94e39704a, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #30", 0x41278f944d37ad81, 0x0e5ffbeb2e85591c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #30", 0x30c00d08701135ae, 0x412d0035639f637b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x39870a7f43bed862, 0x628b986039ee70d9, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x59743fba1110cc1a, 0x7f39300257e6f224, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x30616b853ee51197, 0x7736fa686013d39d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x7d75755e1a0d0e6b, 0x20dfdb2d192e9aad, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x0410cfd03b797707, 0x2dc1363e1c973c26, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x1f0d86c47930a85c, 0x6ad0ac704acce27b, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x466855dd3a7f3bcc, 0x79523b9760351658, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x2a90717b26601233, 0x43d479d3772862e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x6a1eea96305003c1, 0x3116d3be64177bfa, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x4160cfdb33356887, 0x3bfe6e1f43932a50, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x721a7a1f4486d91b, 0x23a6fdee71c23b61, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x5e93e78638b20c4d, 0x0af0d60e6f8fef7d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x742b835476f7d814, 0x0c272ba462a4b757, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x7028807026c3d569, 0x2d7199d213390a18, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x6143113537429a44, 0x736e20713690d64e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x5da2ac785ed00cf2, 0x2db939330bd382b0, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x0f2010b32be96cca, 0x6feafeab47c1970e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x5f1ed5512efbbf4c, 0x0b54c15e5080e08e, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x738298674d33f1fe, 0x42431bef51394f70, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x05e5fe4b4cf06a92, 0x40c93eee52167fee, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x43e842a6622cd117, 0x34bb37457a11819f, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x08f0a68000b8ac29, 0x0d4a8bb83410c317, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x37fb466d185ad298, 0x6aa199656a33b7b5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x772adf8a65f23911, 0x76073a66159df2e5, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x11dba5db68b44b52, 0x5d5f89f3064af03d, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x17b00a9e190eecbb, 0x56cbd0cc70fa7b2c, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x6642deb902fd098b, 0x4233ca9d0b32a306, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; ubfm w3, w4, #31, #31", 0x4fed741d12045a39, 0x5d4922f46c28dd04, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ; sbfm w3, w4, #31, #31", 0x74312b507384ea5c, 0x663a5ea413d5b6c3, x3, x4, x5, 0);
TESTINST3("mov x3, x5 ;  bfm w3, w4, #31, #31", 0x743d96853288133f, 0x47e679da7d21d1d0, x3, x4, x5, 0);

#endif /* if TEST_BFM */

////////////////////////////////////////////////////////////////
printf("EXTR(64)\n");

TESTINST3("extr x3, x4, x5, #0", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #0", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #0", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #0", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #0", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #0", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #1", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #1", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #1", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #1", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #1", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #1", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #2", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #2", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #2", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #2", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #2", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #2", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #3", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #3", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #3", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #3", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #3", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #3", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #32", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #32", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #32", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #32", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #32", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #32", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #60", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #60", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #60", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #60", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #60", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #60", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #61", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #61", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #61", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #61", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #61", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #61", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #62", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #62", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #62", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #62", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #62", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #62", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr x3, x4, x5, #63", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0xe57b3a514f5207f4, 0x8ef7bac0f0ac903a, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0x9d4a481b12743bf8, 0x9f014e8d2644ee47, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0xefdd33d64e6d6a8b, 0x44e875422d202c19, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0x5c6c9b2a7f109f5b, 0x568ee275e665f075, x3, x4, x5, 0);
TESTINST3("extr x3, x4, x5, #63", 0x9b14b0a4fbbd2c11, 0x6b5bac44aaa93980, x3, x4, x5, 0);

////////////////////////////////////////////////////////////////
printf("EXTR(32)\n");

TESTINST3("extr w3, w4, w5, #0", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #0", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #0", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #0", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #0", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #0", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #1", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #1", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #1", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #1", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #1", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #1", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #2", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #2", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #2", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #2", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #2", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #2", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #3", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #3", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #3", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #3", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #3", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #3", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #16", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #16", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #16", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #16", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #16", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #16", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #28", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #28", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #28", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #28", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #28", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #28", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #29", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #29", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #29", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #29", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #29", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #29", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #30", 0xdb432311d1e3a1d0, 0xa6325ae016fbd710, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #30", 0x192e7217e1ab63b0, 0xfd370f11bfcd4a4a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #30", 0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #30", 0xc58586ea2c6954df, 0xe861540945421773, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #30", 0xe51579fec3892795, 0x507865169b052546, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #30", 0x1b834ed5b21de6b5, 0x9a1140d0fd1dbf6c, x3, x4, x5, 0);

TESTINST3("extr w3, w4, w5, #31", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0xe57b3a514f5207f4, 0x8ef7bac0f0ac903a, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0x9d4a481b12743bf8, 0x9f014e8d2644ee47, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0xefdd33d64e6d6a8b, 0x44e875422d202c19, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0x5c6c9b2a7f109f5b, 0x568ee275e665f075, x3, x4, x5, 0);
TESTINST3("extr w3, w4, w5, #31", 0x9b14b0a4fbbd2c11, 0x6b5bac44aaa93980, x3, x4, x5, 0);

////////////////////////////////////////////////////////////////
printf("ADD/SUB(reg,64)\n");

TESTINST3("add  x7,x8,x9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,lsl #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,lsl #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("adds x7,x8,x9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsl #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsl #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsl #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("add  x7,x8,x9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,lsr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,lsr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("adds x7,x8,x9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,lsr #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("add  x7,x8,x9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,asr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("add  x7,x8,x9,asr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("adds x7,x8,x9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,asr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,asr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("adds x7,x8,x9,asr #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("sub  x7,x8,x9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,lsl #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,lsl #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("subs x7,x8,x9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsl #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsl #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsl #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("sub  x7,x8,x9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,lsr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,lsr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("subs x7,x8,x9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,lsr #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("sub  x7,x8,x9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,asr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("sub  x7,x8,x9,asr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("subs x7,x8,x9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,asr #62", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,asr #63", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,asr #0 ", ALL5s, ALL5s, x7,x8,x9,0);
TESTINST3("subs x7,x8,x9,asr #0 ", ALLas, ALL5s, x7,x8,x9,0);


////////////////////////////////////////////////////////////////
printf("ADD/SUB(reg,32)\n");

TESTINST3("add  w7,w8,w9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,lsl #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,lsl #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("adds w7,w8,w9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsl #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsl #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsl #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("add  w7,w8,w9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,lsr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,lsr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("adds w7,w8,w9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,lsr #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("add  w7,w8,w9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,asr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("add  w7,w8,w9,asr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("adds w7,w8,w9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,asr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,asr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("adds w7,w8,w9,asr #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("sub  w7,w8,w9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,lsl #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,lsl #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("subs w7,w8,w9,lsl #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsl #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsl #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsl #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsl #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("sub  w7,w8,w9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,lsr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,lsr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("subs w7,w8,w9,lsr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,lsr #0 ", 1+ALL5s, ALLas, x7,x8,x9,0);

TESTINST3("sub  w7,w8,w9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,asr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("sub  w7,w8,w9,asr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);

TESTINST3("subs w7,w8,w9,asr #0",  0x2b7c5939d7c0f528, 0xb73870a5a6630162, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,asr #1",  0xfc9a9d8be2434f5e, 0x6a13f7db3dfa4a3f, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,asr #30", 0xd98d2022a9b876ab, 0xa7e754e8ff3a554e, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,asr #31", 0x33566e6515990527, 0x3d7e7390195d82e2, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,asr #0 ", ALL5s, ALL5s, x7,x8,x9,0);
TESTINST3("subs w7,w8,w9,asr #0 ", ALLas, ALL5s, x7,x8,x9,0);


////////////////////////////////////////////////////////////////
printf("LOGIC(reg,64)\n");

TESTINST3("and x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("and x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("and x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("and x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("orr x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orr x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orr x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orr x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("eor x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eor x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eor x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eor x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("ands x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("ands x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("ands x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("ands x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);
TESTINST3("ands x7,x8,x9,ror #22",  ALL5s, ALLas, x7,x8,x9,0);


TESTINST3("bic x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bic x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bic x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bic x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("orn x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orn x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orn x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orn x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("eon x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eon x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eon x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eon x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("bics x7,x8,x9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,lsl #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,lsl #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bics x7,x8,x9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,lsr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,lsr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bics x7,x8,x9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,asr #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,asr #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bics x7,x8,x9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,ror #62", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics x7,x8,x9,ror #63", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


////////////////////////////////////////////////////////////////
printf("LOGIC(reg,32)\n");

TESTINST3("and w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("and w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("and w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("and w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("and w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("orr w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orr w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orr w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orr w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orr w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("eor w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eor w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eor w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eor w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eor w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("ands w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("ands w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("ands w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("ands w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);
TESTINST3("ands w7,w8,w9,ror #22",  ALL5s, ALLas, x7,x8,x9,0);


TESTINST3("bic w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bic w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bic w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bic w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bic w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("orn w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orn w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orn w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("orn w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("orn w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("eon w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eon w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eon w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("eon w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("eon w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


TESTINST3("bics w7,w8,w9,lsl #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,lsl #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,lsl #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,lsl #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bics w7,w8,w9,lsr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,lsr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,lsr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,lsr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bics w7,w8,w9,asr #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,asr #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,asr #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,asr #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);

TESTINST3("bics w7,w8,w9,ror #0",  0xdb432311d1e3a1d5, 0xa6325ae016fbd71a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,ror #1",  0xfd79baaee550b488, 0x5bc94f0d3ee4863a, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,ror #30", 0xc58586ea2c6954df, 0xe861540945421773, x7,x8,x9,0);
TESTINST3("bics w7,w8,w9,ror #31", 0xfb834ed5b21de6b5, 0x9a1140d0fd1dbf6f, x7,x8,x9,0);


////////////////////////////////////////////////////////////////
printf("UMULH/SMULH\n");

TESTINST3("umulh x9,x8,x7", 0xefdd33d64e6d6a8b, 0x44e875422d202c19, x9,x8,x7,0);
TESTINST3("umulh x9,x8,x7", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x9,x8,x7,0);
TESTINST3("umulh x9,x8,x7", 0xe57b3a514f5207f4, 0x8ef7bac0f0ac903a, x9,x8,x7,0);

TESTINST3("smulh x9,x8,x7", 0xefdd33d64e6d6a8b, 0x44e875422d202c19, x9,x8,x7,0);
TESTINST3("smulh x9,x8,x7", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x9,x8,x7,0);
TESTINST3("smulh x9,x8,x7", 0xe57b3a514f5207f4, 0x8ef7bac0f0ac903a, x9,x8,x7,0);


////////////////////////////////////////////////////////////////
printf("MADD/MSUB\n");

TESTINST4("madd x30,x26,x28,x27",
          0x7a3847909557e2b4, 0xcbbb98441b9e1029, 0x6a13f7db3dfa4a3f, x30,x26,x28,x27,0);
TESTINST4("madd x30,x26,x28,x27",
          0xe39b12157cf9610f, 0x0eb420e934db9f92, 0x7564a539bf3eb84d, x30,x26,x28,x27,0);
TESTINST4("madd x30,x26,x28,x27",
          0xd7588df1ecb46297, 0x26557c93f44473fa, 0x09fb0ab6a60b34c3, x30,x26,x28,x27,0);
TESTINST4("madd x30,x26,x28,x27",
          0x4f0c54f61ac8f7bd, 0x99b1794bbb4b19cd, 0x52d448b3d56f5369, x30,x26,x28,x27,0);
TESTINST4("madd x30,x26,x28,x27",
          0x5370e6469b1e28ed, 0x0a1925a090f7aaf5, 0xa7e754e8ff3a554e, x30,x26,x28,x27,0);

TESTINST4("msub x30,x26,x28,x27",
          0x7a3847909557e2b4, 0xcbbb98441b9e1029, 0x6a13f7db3dfa4a3f, x30,x26,x28,x27,0);
TESTINST4("msub x30,x26,x28,x27",
          0xe39b12157cf9610f, 0x0eb420e934db9f92, 0x7564a539bf3eb84d, x30,x26,x28,x27,0);
TESTINST4("msub x30,x26,x28,x27",
          0xd7588df1ecb46297, 0x26557c93f44473fa, 0x09fb0ab6a60b34c3, x30,x26,x28,x27,0);
TESTINST4("msub x30,x26,x28,x27",
          0x4f0c54f61ac8f7bd, 0x99b1794bbb4b19cd, 0x52d448b3d56f5369, x30,x26,x28,x27,0);
TESTINST4("msub x30,x26,x28,x27",
          0x5370e6469b1e28ed, 0x0a1925a090f7aaf5, 0xa7e754e8ff3a554e, x30,x26,x28,x27,0);

TESTINST4("madd w30,w26,w28,w27",
          0x7a3847909557e2b4, 0xcbbb98441b9e1029, 0x6a13f7db3dfa4a3f, x30,x26,x28,x27,0);
TESTINST4("madd w30,w26,w28,w27",
          0xe39b12157cf9610f, 0x0eb420e934db9f92, 0x7564a539bf3eb84d, x30,x26,x28,x27,0);
TESTINST4("madd w30,w26,w28,w27",
          0xd7588df1ecb46297, 0x26557c93f44473fa, 0x09fb0ab6a60b34c3, x30,x26,x28,x27,0);
TESTINST4("madd w30,w26,w28,w27",
          0x4f0c54f61ac8f7bd, 0x99b1794bbb4b19cd, 0x52d448b3d56f5369, x30,x26,x28,x27,0);
TESTINST4("madd w30,w26,w28,w27",
          0x5370e6469b1e28ed, 0x0a1925a090f7aaf5, 0xa7e754e8ff3a554e, x30,x26,x28,x27,0);

TESTINST4("msub w30,w26,w28,w27",
          0x7a3847909557e2b4, 0xcbbb98441b9e1029, 0x6a13f7db3dfa4a3f, x30,x26,x28,x27,0);
TESTINST4("msub w30,w26,w28,w27",
          0xe39b12157cf9610f, 0x0eb420e934db9f92, 0x7564a539bf3eb84d, x30,x26,x28,x27,0);
TESTINST4("msub w30,w26,w28,w27",
          0xd7588df1ecb46297, 0x26557c93f44473fa, 0x09fb0ab6a60b34c3, x30,x26,x28,x27,0);
TESTINST4("msub w30,w26,w28,w27",
          0x4f0c54f61ac8f7bd, 0x99b1794bbb4b19cd, 0x52d448b3d56f5369, x30,x26,x28,x27,0);
TESTINST4("msub w30,w26,w28,w27",
          0x5370e6469b1e28ed, 0x0a1925a090f7aaf5, 0xa7e754e8ff3a554e, x30,x26,x28,x27,0);


////////////////////////////////////////////////////////////////
printf("CS{EL,INC,INV,NEG}(64)\n");

TESTINST3("cmp x17,x18 ; csel x16,x17,x18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csel x16,x17,x18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csel x16,x17,x18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csel x16,x17,x18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csel x16,x17,x18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csel x16,x17,x18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csel x16,x17,x18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csel x16,x17,x18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);

TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinc x16,x17,x18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);

TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csinv x16,x17,x18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);

TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp x17,x18 ; csneg x16,x17,x18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);


////////////////////////////////////////////////////////////////
printf("CS{EL,INC,INV,NEG}(32)\n");

TESTINST3("cmp w17,w18 ; csel w16,w17,w18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csel w16,w17,w18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csel w16,w17,w18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csel w16,w17,w18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csel w16,w17,w18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csel w16,w17,w18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csel w16,w17,w18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csel w16,w17,w18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);

TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinc w16,w17,w18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);

TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csinv w16,w17,w18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);

TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,eq",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,ne",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,cc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,cs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,mi",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,pl",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,vc",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);
TESTINST3("cmp w17,w18 ; csneg w16,w17,w18,vs",
          0xafa6ef803bc9291c, 0x7a6c3d1a51246495, x16,x17,x18,0);


////////////////////////////////////////////////////////////////
printf("ADD/SUB(extended reg)(64)\n");

#define NN0 0xa3ca7e66297c469b
#define NN1 0xa67e09b8e126596c
#define NN2 0x09fb0ab6a60b34c3
#define NN3 0x2584971088d90924
#define NN4 0x52d448b3d56f5369
#define NN5 0xd98d2022a9b876ab
#define NN6 0xa7e754e8ff3a554e
#define NN7 0x7ab2520302849409
#define NN8 0x2e10f2a4055bec0e
#define NN9 0x77f3b8dcc730b96a

TESTINST3("add x21,x22,x23,uxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("add x21,x22,x23,uxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("add x21,x22,x23,uxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("add x21,x22,x23,uxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,uxtx #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("add x21,x22,x23,sxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("add x21,x22,x23,sxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("add x21,x22,x23,sxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("add x21,x22,x23,sxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("add x21,x22,x23,sxtx #4", NN8, NN9, x21,x22,x23,0);


TESTINST3("adds x21,x22,x23,uxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("adds x21,x22,x23,uxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("adds x21,x22,x23,uxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("adds x21,x22,x23,uxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,uxtx #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("adds x21,x22,x23,sxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("adds x21,x22,x23,sxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("adds x21,x22,x23,sxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("adds x21,x22,x23,sxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("adds x21,x22,x23,sxtx #4", NN8, NN9, x21,x22,x23,0);


TESTINST3("sub x21,x22,x23,uxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("sub x21,x22,x23,uxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("sub x21,x22,x23,uxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("sub x21,x22,x23,uxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,uxtx #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("sub x21,x22,x23,sxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("sub x21,x22,x23,sxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("sub x21,x22,x23,sxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("sub x21,x22,x23,sxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("sub x21,x22,x23,sxtx #4", NN8, NN9, x21,x22,x23,0);


TESTINST3("subs x21,x22,x23,uxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("subs x21,x22,x23,uxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("subs x21,x22,x23,uxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("subs x21,x22,x23,uxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,uxtx #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("subs x21,x22,x23,sxtb #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtb #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtb #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtb #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtb #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("subs x21,x22,x23,sxth #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxth #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxth #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxth #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxth #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("subs x21,x22,x23,sxtw #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtw #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtw #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtw #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtw #4", NN8, NN9, x21,x22,x23,0);

TESTINST3("subs x21,x22,x23,sxtx #0", NN0, NN1, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtx #1", NN2, NN3, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtx #2", NN4, NN5, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtx #3", NN6, NN7, x21,x22,x23,0);
TESTINST3("subs x21,x22,x23,sxtx #4", NN8, NN9, x21,x22,x23,0);


////////////////////////////////////////////////////////////////
printf("ADD/SUB(extended reg)(32)\n");

TESTINST3("add w21,w22,w23,uxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("add w21,w22,w23,uxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("add w21,w22,w23,uxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("add w21,w22,w23,uxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,uxtx #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("add w21,w22,w23,sxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("add w21,w22,w23,sxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("add w21,w22,w23,sxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("add w21,w22,w23,sxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("add w21,w22,w23,sxtx #4", NN8, NN9, x21,x22,x23 ,0);


TESTINST3("adds w21,w22,w23,uxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("adds w21,w22,w23,uxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("adds w21,w22,w23,uxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("adds w21,w22,w23,uxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,uxtx #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("adds w21,w22,w23,sxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("adds w21,w22,w23,sxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("adds w21,w22,w23,sxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("adds w21,w22,w23,sxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("adds w21,w22,w23,sxtx #4", NN8, NN9, x21,x22,x23 ,0);


TESTINST3("sub w21,w22,w23,uxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("sub w21,w22,w23,uxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("sub w21,w22,w23,uxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("sub w21,w22,w23,uxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,uxtx #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("sub w21,w22,w23,sxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("sub w21,w22,w23,sxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("sub w21,w22,w23,sxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("sub w21,w22,w23,sxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("sub w21,w22,w23,sxtx #4", NN8, NN9, x21,x22,x23 ,0);


TESTINST3("subs w21,w22,w23,uxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("subs w21,w22,w23,uxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("subs w21,w22,w23,uxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("subs w21,w22,w23,uxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,uxtx #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("subs w21,w22,w23,sxtb #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtb #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtb #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtb #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtb #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("subs w21,w22,w23,sxth #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxth #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxth #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxth #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxth #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("subs w21,w22,w23,sxtw #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtw #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtw #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtw #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtw #4", NN8, NN9, x21,x22,x23 ,0);

TESTINST3("subs w21,w22,w23,sxtx #0", NN0, NN1, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtx #1", NN2, NN3, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtx #2", NN4, NN5, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtx #3", NN6, NN7, x21,x22,x23 ,0);
TESTINST3("subs w21,w22,w23,sxtx #4", NN8, NN9, x21,x22,x23 ,0);


////////////////////////////////////////////////////////////////
printf("CCMP/CCMN(imm)(64)\n");

#define PRE  "msr nzcv,x24; "  // nzcv = x24
#define POST "; mrs x23,nzcv"  // x23 = nzcv (overall result)

#define TEST_CCMP_X_imm(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST3(PRE "ccmp x25,#" #argR_value ",#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, x23,x24,x25 ,0)

#define TEST_CCMN_X_imm(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST3(PRE "ccmn x25,#" #argR_value ",#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, x23,x24,x25 ,0)

TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x0);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x1);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x2);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x3);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x4);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x5);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x6);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x7);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x8);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x9);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0xA);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0xB);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0xC);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0xD);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0xE);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0xF);
printf("\n");
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x0);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x1);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x2);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x3);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x4);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x5);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x6);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x7);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x8);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x9);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0xA);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0xB);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0xC);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0xD);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0xE);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0xF);
printf("\n");
TEST_CCMP_X_imm(0x1, eq, 17, 17, 0x6);
TEST_CCMP_X_imm(0x2, eq, 17, 17, 0x5);
TEST_CCMP_X_imm(0x4, eq, 17, 17, 0x3);
TEST_CCMP_X_imm(0x8, eq, 17, 17, 0x7);
TEST_CCMP_X_imm(0x1, lt, 17, 17, 0x6);
TEST_CCMP_X_imm(0x2, lt, 17, 17, 0x5);
TEST_CCMP_X_imm(0x4, lt, 17, 17, 0x3);
TEST_CCMP_X_imm(0x8, lt, 17, 17, 0x7);
TEST_CCMP_X_imm(0x1, gt, 17, 17, 0x6);
TEST_CCMP_X_imm(0x2, gt, 17, 17, 0x5);
TEST_CCMP_X_imm(0x4, gt, 17, 17, 0x3);
TEST_CCMP_X_imm(0x8, gt, 17, 17, 0x7);
TEST_CCMP_X_imm(0x1, ne, 17, 17, 0x6);
TEST_CCMP_X_imm(0x2, ne, 17, 17, 0x5);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0x3);
TEST_CCMP_X_imm(0x8, ne, 17, 17, 0x7);
TEST_CCMP_X_imm(0x1, eq, 17, 18, 0x6);
TEST_CCMP_X_imm(0x2, eq, 17, 18, 0x5);
TEST_CCMP_X_imm(0x4, eq, 17, 18, 0x3);
TEST_CCMP_X_imm(0x8, eq, 17, 18, 0x7);
TEST_CCMP_X_imm(0x1, lt, 17, 18, 0x6);
TEST_CCMP_X_imm(0x2, lt, 17, 18, 0x5);
TEST_CCMP_X_imm(0x4, lt, 17, 18, 0x3);
TEST_CCMP_X_imm(0x8, lt, 17, 18, 0x7);
TEST_CCMP_X_imm(0x1, gt, 17, 18, 0x6);
TEST_CCMP_X_imm(0x2, gt, 17, 18, 0x5);
TEST_CCMP_X_imm(0x4, gt, 17, 18, 0x3);
TEST_CCMP_X_imm(0x8, gt, 17, 18, 0x7);
TEST_CCMP_X_imm(0x1, ne, 17, 18, 0x6);
TEST_CCMP_X_imm(0x2, ne, 17, 18, 0x5);
TEST_CCMP_X_imm(0x4, ne, 17, 18, 0x3);
TEST_CCMP_X_imm(0x8, ne, 17, 18, 0x7);


TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x0);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x1);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x2);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x3);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x4);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x5);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x6);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x7);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x8);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x9);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0xA);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0xB);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0xC);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0xD);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0xE);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0xF);
printf("\n");
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x0);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x1);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x2);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x3);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x4);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x5);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x6);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x7);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x8);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x9);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0xA);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0xB);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0xC);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0xD);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0xE);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0xF);
printf("\n");
TEST_CCMN_X_imm(0x1, eq, -17, 17, 0x6);
TEST_CCMN_X_imm(0x2, eq, -17, 17, 0x5);
TEST_CCMN_X_imm(0x4, eq, -17, 17, 0x3);
TEST_CCMN_X_imm(0x8, eq, -17, 17, 0x7);
TEST_CCMN_X_imm(0x1, lt, -17, 17, 0x6);
TEST_CCMN_X_imm(0x2, lt, -17, 17, 0x5);
TEST_CCMN_X_imm(0x4, lt, -17, 17, 0x3);
TEST_CCMN_X_imm(0x8, lt, -17, 17, 0x7);
TEST_CCMN_X_imm(0x1, gt, -17, 17, 0x6);
TEST_CCMN_X_imm(0x2, gt, -17, 17, 0x5);
TEST_CCMN_X_imm(0x4, gt, -17, 17, 0x3);
TEST_CCMN_X_imm(0x8, gt, -17, 17, 0x7);
TEST_CCMN_X_imm(0x1, ne, -17, 17, 0x6);
TEST_CCMN_X_imm(0x2, ne, -17, 17, 0x5);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0x3);
TEST_CCMN_X_imm(0x8, ne, -17, 17, 0x7);
TEST_CCMN_X_imm(0x1, eq, -17, 18, 0x6);
TEST_CCMN_X_imm(0x2, eq, -17, 18, 0x5);
TEST_CCMN_X_imm(0x4, eq, -17, 18, 0x3);
TEST_CCMN_X_imm(0x8, eq, -17, 18, 0x7);
TEST_CCMN_X_imm(0x1, lt, -17, 18, 0x6);
TEST_CCMN_X_imm(0x2, lt, -17, 18, 0x5);
TEST_CCMN_X_imm(0x4, lt, -17, 18, 0x3);
TEST_CCMN_X_imm(0x8, lt, -17, 18, 0x7);
TEST_CCMN_X_imm(0x1, gt, -17, 18, 0x6);
TEST_CCMN_X_imm(0x2, gt, -17, 18, 0x5);
TEST_CCMN_X_imm(0x4, gt, -17, 18, 0x3);
TEST_CCMN_X_imm(0x8, gt, -17, 18, 0x7);
TEST_CCMN_X_imm(0x1, ne, -17, 18, 0x6);
TEST_CCMN_X_imm(0x2, ne, -17, 18, 0x5);
TEST_CCMN_X_imm(0x4, ne, -17, 18, 0x3);
TEST_CCMN_X_imm(0x8, ne, -17, 18, 0x7);


////////////////////////////////////////////////////////////////
printf("CCMP/CCMN(imm)(32)\n");

#define PRE  "msr nzcv,x24; "  // nzcv = x24
#define POST "; mrs x23,nzcv"  // x23 = nzcv (overall result)

#define TEST_CCMP_W_imm(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST3(PRE "ccmp w25,#" #argR_value ",#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, x23,x24,x25 ,0)

#define TEST_CCMN_W_imm(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST3(PRE "ccmn w25,#" #argR_value ",#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, x23,x24,x25 ,0)

TEST_CCMP_W_imm(0x4, eq, 17, 17, 0xF);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0xF);
TEST_CCMP_W_imm(0x4, eq, 17+(17ULL<<32), 17, 0xF);
TEST_CCMP_W_imm(0x4, ne, 17+(17ULL<<32), 17, 0xF);

TEST_CCMP_X_imm(0x4, eq, 17, 17, 0xF);
TEST_CCMP_X_imm(0x4, ne, 17, 17, 0xF);
TEST_CCMP_X_imm(0x4, eq, 17+(17ULL<<32), 17, 0xF);
TEST_CCMP_X_imm(0x4, ne, 17+(17ULL<<32), 17, 0xF);

TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x0);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x1);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x2);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x3);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x4);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x5);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x6);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x7);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x8);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x9);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0xA);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0xB);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0xC);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0xD);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0xE);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0xF);
printf("\n");
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x0);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x1);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x2);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x3);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x4);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x5);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x6);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x7);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x8);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x9);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0xA);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0xB);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0xC);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0xD);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0xE);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0xF);
printf("\n");
TEST_CCMP_W_imm(0x1, eq, 17, 17, 0x6);
TEST_CCMP_W_imm(0x2, eq, 17, 17, 0x5);
TEST_CCMP_W_imm(0x4, eq, 17, 17, 0x3);
TEST_CCMP_W_imm(0x8, eq, 17, 17, 0x7);
TEST_CCMP_W_imm(0x1, lt, 17, 17, 0x6);
TEST_CCMP_W_imm(0x2, lt, 17, 17, 0x5);
TEST_CCMP_W_imm(0x4, lt, 17, 17, 0x3);
TEST_CCMP_W_imm(0x8, lt, 17, 17, 0x7);
TEST_CCMP_W_imm(0x1, gt, 17, 17, 0x6);
TEST_CCMP_W_imm(0x2, gt, 17, 17, 0x5);
TEST_CCMP_W_imm(0x4, gt, 17, 17, 0x3);
TEST_CCMP_W_imm(0x8, gt, 17, 17, 0x7);
TEST_CCMP_W_imm(0x1, ne, 17, 17, 0x6);
TEST_CCMP_W_imm(0x2, ne, 17, 17, 0x5);
TEST_CCMP_W_imm(0x4, ne, 17, 17, 0x3);
TEST_CCMP_W_imm(0x8, ne, 17, 17, 0x7);
TEST_CCMP_W_imm(0x1, eq, 17, 18, 0x6);
TEST_CCMP_W_imm(0x2, eq, 17, 18, 0x5);
TEST_CCMP_W_imm(0x4, eq, 17, 18, 0x3);
TEST_CCMP_W_imm(0x8, eq, 17, 18, 0x7);
TEST_CCMP_W_imm(0x1, lt, 17, 18, 0x6);
TEST_CCMP_W_imm(0x2, lt, 17, 18, 0x5);
TEST_CCMP_W_imm(0x4, lt, 17, 18, 0x3);
TEST_CCMP_W_imm(0x8, lt, 17, 18, 0x7);
TEST_CCMP_W_imm(0x1, gt, 17, 18, 0x6);
TEST_CCMP_W_imm(0x2, gt, 17, 18, 0x5);
TEST_CCMP_W_imm(0x4, gt, 17, 18, 0x3);
TEST_CCMP_W_imm(0x8, gt, 17, 18, 0x7);
TEST_CCMP_W_imm(0x1, ne, 17, 18, 0x6);
TEST_CCMP_W_imm(0x2, ne, 17, 18, 0x5);
TEST_CCMP_W_imm(0x4, ne, 17, 18, 0x3);
TEST_CCMP_W_imm(0x8, ne, 17, 18, 0x7);


TEST_CCMN_W_imm(0x4, eq, -17, 17, 0xF);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0xF);
TEST_CCMN_W_imm(0x4, eq, -(17+(17ULL<<32)), 17, 0xF);
TEST_CCMN_W_imm(0x4, ne, -(17+(17ULL<<32)), 17, 0xF);

TEST_CCMN_X_imm(0x4, eq, -17, 17, 0xF);
TEST_CCMN_X_imm(0x4, ne, -17, 17, 0xF);
TEST_CCMN_X_imm(0x4, eq, -(17+(17ULL<<32)), 17, 0xF);
TEST_CCMN_X_imm(0x4, ne, -(17+(17ULL<<32)), 17, 0xF);

TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x0);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x1);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x2);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x3);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x4);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x5);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x6);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x7);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x8);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x9);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0xA);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0xB);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0xC);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0xD);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0xE);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0xF);
printf("\n");
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x0);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x1);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x2);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x3);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x4);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x5);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x6);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x7);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x8);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x9);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0xA);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0xB);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0xC);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0xD);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0xE);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0xF);
printf("\n");
TEST_CCMN_W_imm(0x1, eq, -17, 17, 0x6);
TEST_CCMN_W_imm(0x2, eq, -17, 17, 0x5);
TEST_CCMN_W_imm(0x4, eq, -17, 17, 0x3);
TEST_CCMN_W_imm(0x8, eq, -17, 17, 0x7);
TEST_CCMN_W_imm(0x1, lt, -17, 17, 0x6);
TEST_CCMN_W_imm(0x2, lt, -17, 17, 0x5);
TEST_CCMN_W_imm(0x4, lt, -17, 17, 0x3);
TEST_CCMN_W_imm(0x8, lt, -17, 17, 0x7);
TEST_CCMN_W_imm(0x1, gt, -17, 17, 0x6);
TEST_CCMN_W_imm(0x2, gt, -17, 17, 0x5);
TEST_CCMN_W_imm(0x4, gt, -17, 17, 0x3);
TEST_CCMN_W_imm(0x8, gt, -17, 17, 0x7);
TEST_CCMN_W_imm(0x1, ne, -17, 17, 0x6);
TEST_CCMN_W_imm(0x2, ne, -17, 17, 0x5);
TEST_CCMN_W_imm(0x4, ne, -17, 17, 0x3);
TEST_CCMN_W_imm(0x8, ne, -17, 17, 0x7);
TEST_CCMN_W_imm(0x1, eq, -17, 18, 0x6);
TEST_CCMN_W_imm(0x2, eq, -17, 18, 0x5);
TEST_CCMN_W_imm(0x4, eq, -17, 18, 0x3);
TEST_CCMN_W_imm(0x8, eq, -17, 18, 0x7);
TEST_CCMN_W_imm(0x1, lt, -17, 18, 0x6);
TEST_CCMN_W_imm(0x2, lt, -17, 18, 0x5);
TEST_CCMN_W_imm(0x4, lt, -17, 18, 0x3);
TEST_CCMN_W_imm(0x8, lt, -17, 18, 0x7);
TEST_CCMN_W_imm(0x1, gt, -17, 18, 0x6);
TEST_CCMN_W_imm(0x2, gt, -17, 18, 0x5);
TEST_CCMN_W_imm(0x4, gt, -17, 18, 0x3);
TEST_CCMN_W_imm(0x8, gt, -17, 18, 0x7);
TEST_CCMN_W_imm(0x1, ne, -17, 18, 0x6);
TEST_CCMN_W_imm(0x2, ne, -17, 18, 0x5);
TEST_CCMN_W_imm(0x4, ne, -17, 18, 0x3);
TEST_CCMN_W_imm(0x8, ne, -17, 18, 0x7);


////////////////////////////////////////////////////////////////
printf("CCMP/CCMN(reg)(64)\n");

#define PRE  "msr nzcv,x24; "  // nzcv = x24
#define POST "; mrs x23,nzcv"  // x23 = nzcv (overall result)

#define TEST_CCMP_X_reg(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST4(PRE "ccmp x25,x26,#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, argR_value, x23,x24,x25,x26 ,0)

#define TEST_CCMN_X_reg(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST4(PRE "ccmn x25,x26,#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, argR_value, x23,x24,x25,x26 ,0)

TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x0);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x1);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x2);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x3);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x4);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x5);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x6);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x7);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x8);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x9);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0xA);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0xB);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0xC);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0xD);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0xE);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0xF);
printf("\n");
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x0);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x1);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x2);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x3);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x4);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x5);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x6);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x7);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x8);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x9);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0xA);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0xB);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0xC);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0xD);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0xE);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0xF);
printf("\n");
TEST_CCMP_X_reg(0x1, eq, 17, 17, 0x6);
TEST_CCMP_X_reg(0x2, eq, 17, 17, 0x5);
TEST_CCMP_X_reg(0x4, eq, 17, 17, 0x3);
TEST_CCMP_X_reg(0x8, eq, 17, 17, 0x7);
TEST_CCMP_X_reg(0x1, lt, 17, 17, 0x6);
TEST_CCMP_X_reg(0x2, lt, 17, 17, 0x5);
TEST_CCMP_X_reg(0x4, lt, 17, 17, 0x3);
TEST_CCMP_X_reg(0x8, lt, 17, 17, 0x7);
TEST_CCMP_X_reg(0x1, gt, 17, 17, 0x6);
TEST_CCMP_X_reg(0x2, gt, 17, 17, 0x5);
TEST_CCMP_X_reg(0x4, gt, 17, 17, 0x3);
TEST_CCMP_X_reg(0x8, gt, 17, 17, 0x7);
TEST_CCMP_X_reg(0x1, ne, 17, 17, 0x6);
TEST_CCMP_X_reg(0x2, ne, 17, 17, 0x5);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0x3);
TEST_CCMP_X_reg(0x8, ne, 17, 17, 0x7);
TEST_CCMP_X_reg(0x1, eq, 17, 18, 0x6);
TEST_CCMP_X_reg(0x2, eq, 17, 18, 0x5);
TEST_CCMP_X_reg(0x4, eq, 17, 18, 0x3);
TEST_CCMP_X_reg(0x8, eq, 17, 18, 0x7);
TEST_CCMP_X_reg(0x1, lt, 17, 18, 0x6);
TEST_CCMP_X_reg(0x2, lt, 17, 18, 0x5);
TEST_CCMP_X_reg(0x4, lt, 17, 18, 0x3);
TEST_CCMP_X_reg(0x8, lt, 17, 18, 0x7);
TEST_CCMP_X_reg(0x1, gt, 17, 18, 0x6);
TEST_CCMP_X_reg(0x2, gt, 17, 18, 0x5);
TEST_CCMP_X_reg(0x4, gt, 17, 18, 0x3);
TEST_CCMP_X_reg(0x8, gt, 17, 18, 0x7);
TEST_CCMP_X_reg(0x1, ne, 17, 18, 0x6);
TEST_CCMP_X_reg(0x2, ne, 17, 18, 0x5);
TEST_CCMP_X_reg(0x4, ne, 17, 18, 0x3);
TEST_CCMP_X_reg(0x8, ne, 17, 18, 0x7);


TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x0);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x1);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x2);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x3);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x4);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x5);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x6);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x7);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x8);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x9);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0xA);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0xB);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0xC);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0xD);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0xE);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0xF);
printf("\n");
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x0);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x1);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x2);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x3);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x4);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x5);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x6);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x7);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x8);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x9);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0xA);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0xB);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0xC);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0xD);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0xE);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0xF);
printf("\n");
TEST_CCMN_X_reg(0x1, eq, -17, 17, 0x6);
TEST_CCMN_X_reg(0x2, eq, -17, 17, 0x5);
TEST_CCMN_X_reg(0x4, eq, -17, 17, 0x3);
TEST_CCMN_X_reg(0x8, eq, -17, 17, 0x7);
TEST_CCMN_X_reg(0x1, lt, -17, 17, 0x6);
TEST_CCMN_X_reg(0x2, lt, -17, 17, 0x5);
TEST_CCMN_X_reg(0x4, lt, -17, 17, 0x3);
TEST_CCMN_X_reg(0x8, lt, -17, 17, 0x7);
TEST_CCMN_X_reg(0x1, gt, -17, 17, 0x6);
TEST_CCMN_X_reg(0x2, gt, -17, 17, 0x5);
TEST_CCMN_X_reg(0x4, gt, -17, 17, 0x3);
TEST_CCMN_X_reg(0x8, gt, -17, 17, 0x7);
TEST_CCMN_X_reg(0x1, ne, -17, 17, 0x6);
TEST_CCMN_X_reg(0x2, ne, -17, 17, 0x5);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0x3);
TEST_CCMN_X_reg(0x8, ne, -17, 17, 0x7);
TEST_CCMN_X_reg(0x1, eq, -17, 18, 0x6);
TEST_CCMN_X_reg(0x2, eq, -17, 18, 0x5);
TEST_CCMN_X_reg(0x4, eq, -17, 18, 0x3);
TEST_CCMN_X_reg(0x8, eq, -17, 18, 0x7);
TEST_CCMN_X_reg(0x1, lt, -17, 18, 0x6);
TEST_CCMN_X_reg(0x2, lt, -17, 18, 0x5);
TEST_CCMN_X_reg(0x4, lt, -17, 18, 0x3);
TEST_CCMN_X_reg(0x8, lt, -17, 18, 0x7);
TEST_CCMN_X_reg(0x1, gt, -17, 18, 0x6);
TEST_CCMN_X_reg(0x2, gt, -17, 18, 0x5);
TEST_CCMN_X_reg(0x4, gt, -17, 18, 0x3);
TEST_CCMN_X_reg(0x8, gt, -17, 18, 0x7);
TEST_CCMN_X_reg(0x1, ne, -17, 18, 0x6);
TEST_CCMN_X_reg(0x2, ne, -17, 18, 0x5);
TEST_CCMN_X_reg(0x4, ne, -17, 18, 0x3);
TEST_CCMN_X_reg(0x8, ne, -17, 18, 0x7);


////////////////////////////////////////////////////////////////
printf("CCMP/CCMN(reg)(32)\n");

#define PRE  "msr nzcv,x24; "  // nzcv = x24
#define POST "; mrs x23,nzcv"  // x23 = nzcv (overall result)

#define TEST_CCMP_W_reg(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST4(PRE "ccmp w25,w26,#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, argR_value, x23,x24,x25,x26 ,0)

#define TEST_CCMN_W_reg(initial_nzcv, cond, argL_value, argR_value, iffalse_nzcv) \
   TESTINST4(PRE "ccmn w25,w26,#" #iffalse_nzcv "," #cond POST, \
              (initial_nzcv<<28), argL_value, argR_value, x23,x24,x25,x26 ,0)

TEST_CCMP_W_reg(0x4, eq, 17, 17, 0xF);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0xF);
TEST_CCMP_W_reg(0x4, eq, 17+(17ULL<<32), 17, 0xF);
TEST_CCMP_W_reg(0x4, ne, 17+(17ULL<<32), 17, 0xF);

TEST_CCMP_X_reg(0x4, eq, 17, 17, 0xF);
TEST_CCMP_X_reg(0x4, ne, 17, 17, 0xF);
TEST_CCMP_X_reg(0x4, eq, 17+(17ULL<<32), 17, 0xF);
TEST_CCMP_X_reg(0x4, ne, 17+(17ULL<<32), 17, 0xF);

TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x0);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x1);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x2);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x3);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x4);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x5);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x6);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x7);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x8);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x9);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0xA);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0xB);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0xC);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0xD);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0xE);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0xF);
printf("\n");
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x0);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x1);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x2);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x3);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x4);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x5);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x6);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x7);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x8);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x9);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0xA);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0xB);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0xC);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0xD);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0xE);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0xF);
printf("\n");
TEST_CCMP_W_reg(0x1, eq, 17, 17, 0x6);
TEST_CCMP_W_reg(0x2, eq, 17, 17, 0x5);
TEST_CCMP_W_reg(0x4, eq, 17, 17, 0x3);
TEST_CCMP_W_reg(0x8, eq, 17, 17, 0x7);
TEST_CCMP_W_reg(0x1, lt, 17, 17, 0x6);
TEST_CCMP_W_reg(0x2, lt, 17, 17, 0x5);
TEST_CCMP_W_reg(0x4, lt, 17, 17, 0x3);
TEST_CCMP_W_reg(0x8, lt, 17, 17, 0x7);
TEST_CCMP_W_reg(0x1, gt, 17, 17, 0x6);
TEST_CCMP_W_reg(0x2, gt, 17, 17, 0x5);
TEST_CCMP_W_reg(0x4, gt, 17, 17, 0x3);
TEST_CCMP_W_reg(0x8, gt, 17, 17, 0x7);
TEST_CCMP_W_reg(0x1, ne, 17, 17, 0x6);
TEST_CCMP_W_reg(0x2, ne, 17, 17, 0x5);
TEST_CCMP_W_reg(0x4, ne, 17, 17, 0x3);
TEST_CCMP_W_reg(0x8, ne, 17, 17, 0x7);
TEST_CCMP_W_reg(0x1, eq, 17, 18, 0x6);
TEST_CCMP_W_reg(0x2, eq, 17, 18, 0x5);
TEST_CCMP_W_reg(0x4, eq, 17, 18, 0x3);
TEST_CCMP_W_reg(0x8, eq, 17, 18, 0x7);
TEST_CCMP_W_reg(0x1, lt, 17, 18, 0x6);
TEST_CCMP_W_reg(0x2, lt, 17, 18, 0x5);
TEST_CCMP_W_reg(0x4, lt, 17, 18, 0x3);
TEST_CCMP_W_reg(0x8, lt, 17, 18, 0x7);
TEST_CCMP_W_reg(0x1, gt, 17, 18, 0x6);
TEST_CCMP_W_reg(0x2, gt, 17, 18, 0x5);
TEST_CCMP_W_reg(0x4, gt, 17, 18, 0x3);
TEST_CCMP_W_reg(0x8, gt, 17, 18, 0x7);
TEST_CCMP_W_reg(0x1, ne, 17, 18, 0x6);
TEST_CCMP_W_reg(0x2, ne, 17, 18, 0x5);
TEST_CCMP_W_reg(0x4, ne, 17, 18, 0x3);
TEST_CCMP_W_reg(0x8, ne, 17, 18, 0x7);


TEST_CCMN_W_reg(0x4, eq, -17, 17, 0xF);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0xF);
TEST_CCMN_W_reg(0x4, eq, -(17+(17ULL<<32)), 17, 0xF);
TEST_CCMN_W_reg(0x4, ne, -(17+(17ULL<<32)), 17, 0xF);

TEST_CCMN_X_reg(0x4, eq, -17, 17, 0xF);
TEST_CCMN_X_reg(0x4, ne, -17, 17, 0xF);
TEST_CCMN_X_reg(0x4, eq, -(17+(17ULL<<32)), 17, 0xF);
TEST_CCMN_X_reg(0x4, ne, -(17+(17ULL<<32)), 17, 0xF);

TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x0);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x1);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x2);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x3);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x4);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x5);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x6);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x7);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x8);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x9);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0xA);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0xB);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0xC);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0xD);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0xE);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0xF);
printf("\n");
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x0);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x1);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x2);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x3);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x4);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x5);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x6);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x7);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x8);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x9);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0xA);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0xB);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0xC);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0xD);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0xE);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0xF);
printf("\n");
TEST_CCMN_W_reg(0x1, eq, -17, 17, 0x6);
TEST_CCMN_W_reg(0x2, eq, -17, 17, 0x5);
TEST_CCMN_W_reg(0x4, eq, -17, 17, 0x3);
TEST_CCMN_W_reg(0x8, eq, -17, 17, 0x7);
TEST_CCMN_W_reg(0x1, lt, -17, 17, 0x6);
TEST_CCMN_W_reg(0x2, lt, -17, 17, 0x5);
TEST_CCMN_W_reg(0x4, lt, -17, 17, 0x3);
TEST_CCMN_W_reg(0x8, lt, -17, 17, 0x7);
TEST_CCMN_W_reg(0x1, gt, -17, 17, 0x6);
TEST_CCMN_W_reg(0x2, gt, -17, 17, 0x5);
TEST_CCMN_W_reg(0x4, gt, -17, 17, 0x3);
TEST_CCMN_W_reg(0x8, gt, -17, 17, 0x7);
TEST_CCMN_W_reg(0x1, ne, -17, 17, 0x6);
TEST_CCMN_W_reg(0x2, ne, -17, 17, 0x5);
TEST_CCMN_W_reg(0x4, ne, -17, 17, 0x3);
TEST_CCMN_W_reg(0x8, ne, -17, 17, 0x7);
TEST_CCMN_W_reg(0x1, eq, -17, 18, 0x6);
TEST_CCMN_W_reg(0x2, eq, -17, 18, 0x5);
TEST_CCMN_W_reg(0x4, eq, -17, 18, 0x3);
TEST_CCMN_W_reg(0x8, eq, -17, 18, 0x7);
TEST_CCMN_W_reg(0x1, lt, -17, 18, 0x6);
TEST_CCMN_W_reg(0x2, lt, -17, 18, 0x5);
TEST_CCMN_W_reg(0x4, lt, -17, 18, 0x3);
TEST_CCMN_W_reg(0x8, lt, -17, 18, 0x7);
TEST_CCMN_W_reg(0x1, gt, -17, 18, 0x6);
TEST_CCMN_W_reg(0x2, gt, -17, 18, 0x5);
TEST_CCMN_W_reg(0x4, gt, -17, 18, 0x3);
TEST_CCMN_W_reg(0x8, gt, -17, 18, 0x7);
TEST_CCMN_W_reg(0x1, ne, -17, 18, 0x6);
TEST_CCMN_W_reg(0x2, ne, -17, 18, 0x5);
TEST_CCMN_W_reg(0x4, ne, -17, 18, 0x3);
TEST_CCMN_W_reg(0x8, ne, -17, 18, 0x7);


////////////////////////////////////////////////////////////////
printf("REV\n");

TESTINST2("rev x11,x23", 0xfd79baaee550b488, x11,x23,0);
TESTINST2("rev x11,x23", 0xe861540945421773, x11,x23,0);
TESTINST2("rev x11,x23", 0x9a1140d0fd1dbf6c, x11,x23,0);

TESTINST2("rev w11,w23", 0xfd79baaee550b488, x11,x23,0);
TESTINST2("rev w11,w23", 0xe861540945421773, x11,x23,0);
TESTINST2("rev w11,w23", 0x9a1140d0fd1dbf6c, x11,x23,0);


////////////////////////////////////////////////////////////////
printf("RBIT\n");

TESTINST2("rbit x11,x23", 0xfd79baaee550b488, x11,x23,0);
TESTINST2("rbit x11,x23", 0xe861540945421773, x11,x23,0);
TESTINST2("rbit x11,x23", 0x9a1140d0fd1dbf6c, x11,x23,0);

TESTINST2("rbit w11,w23", 0xfd79baaee550b488, x11,x23,0);
TESTINST2("rbit w11,w23", 0xe861540945421773, x11,x23,0);
TESTINST2("rbit w11,w23", 0x9a1140d0fd1dbf6c, x11,x23,0);


////////////////////////////////////////////////////////////////
printf("REV16\n");

TESTINST2("rev16 x11,x23", 0xfd79baaee550b488, x11,x23,0);
TESTINST2("rev16 x11,x23", 0xe861540945421773, x11,x23,0);
TESTINST2("rev16 x11,x23", 0x9a1140d0fd1dbf6c, x11,x23,0);

TESTINST2("rev16 w11,w23", 0xfd79baaee550b488, x11,x23,0);
TESTINST2("rev16 w11,w23", 0xe861540945421773, x11,x23,0);
TESTINST2("rev16 w11,w23", 0x9a1140d0fd1dbf6c, x11,x23,0);


////////////////////////////////////////////////////////////////
printf("REV32\n");

TESTINST2("rev32 x11,x23", 0xfd79baaee550b488, x11,x23,0);
TESTINST2("rev32 x11,x23", 0xe861540945421773, x11,x23,0);
TESTINST2("rev32 x11,x23", 0x9a1140d0fd1dbf6c, x11,x23,0);


////////////////////////////////////////////////////////////////
printf("CLZ\n");

TESTINST2("clz x17, x22", 0xFFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("clz x17, x22", 0ULL, x17, x22, 0);
TESTINST2("clz x17, x22", 0x0070FFFF01FFFFFFULL, x17, x22, 0);

TESTINST2("clz w17, w22", 0xFFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("clz w17, w22", 0ULL, x17, x22, 0);
TESTINST2("clz w17, w22", 0x0070FFFF01FFFFFFULL, x17, x22, 0);


////////////////////////////////////////////////////////////////
printf("CLS\n");

TESTINST2("cls x17, x22", 0x0FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x1FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x2FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x3FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x4FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x5FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x6FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x7FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x8FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x9FFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xAFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xBFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xCFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xDFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xEFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFFFULL, x17, x22, 0);

TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF0ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF1ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF2ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF3ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF4ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF5ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF6ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF7ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF8ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFF9ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFFAULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFFBULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFFCULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFFDULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFFEULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xFFFFFFFFFFFFFFFFULL, x17, x22, 0);

TESTINST2("cls x17, x22", 0x0000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x1000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x2000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x3000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x4000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x5000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x6000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x7000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x8000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x9000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xA000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xB000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xC000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xD000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xE000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0xF000000000000000ULL, x17, x22, 0);

TESTINST2("cls x17, x22", 0x0000000000000000ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000001ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000002ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000003ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000004ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000005ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000006ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000007ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000008ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x0000000000000009ULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x000000000000000AULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x000000000000000BULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x000000000000000CULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x000000000000000DULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x000000000000000EULL, x17, x22, 0);
TESTINST2("cls x17, x22", 0x000000000000000FULL, x17, x22, 0);

TESTINST2("cls x17, x22", 0x0070FFFF01FFFFFFULL, x17, x22, 0);

TESTINST2("cls w17, w22", 0xFFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls w17, w22", 0xFFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls w17, w22", 0xFFFFFFFF5FFFFFFFULL, x17, x22, 0);
TESTINST2("cls w17, w22", 0xFFFFFFFFAFFFFFFFULL, x17, x22, 0);
TESTINST2("cls w17, w22", 0xFFFFFFFF0FFFFFFFULL, x17, x22, 0);

TESTINST2("cls w17, w22", 0xFFFFFFFFFFFFFFFFULL, x17, x22, 0);
TESTINST2("cls w17, w22", 0xFFFFFFFFFFFFFFF5ULL, x17, x22, 0);
TESTINST2("cls w17, w22", 0xFFFFFFFFFFFFFFFAULL, x17, x22, 0);
TESTINST2("cls w17, w22", 0xFFFFFFFFFFFFFFF0ULL, x17, x22, 0);

TESTINST2("cls w17, w22", 0x0000000000000000ULL, x17, x22, 0);

TESTINST2("cls w17, w22", 0x0070FFFF01FFFFFFULL, x17, x22, 0);


////////////////////////////////////////////////////////////////
printf("LSLV/LSRV/ASRV/RORV\n");

TESTINST3("lslv x21,x20,x19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("lslv x21,x20,x19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("lslv x21,x20,x19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("lslv x21,x20,x19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("lslv x21,x20,x19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("lslv x21,x20,x19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("lslv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);

TESTINST3("lsrv x21,x20,x19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("lsrv x21,x20,x19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("lsrv x21,x20,x19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("lsrv x21,x20,x19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("lsrv x21,x20,x19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("lsrv x21,x20,x19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("lsrv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);

TESTINST3("asrv x21,x20,x19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("asrv x21,x20,x19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("asrv x21,x20,x19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("asrv x21,x20,x19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("asrv x21,x20,x19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("asrv x21,x20,x19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("asrv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);

TESTINST3("rorv x21,x20,x19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff00, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff01, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff02, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff3d, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff3e, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff3f, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff40, x21,x20,x19, 0);
TESTINST3("rorv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff41, x21,x20,x19, 0);

TESTINST3("lslv w21,w20,w19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("lslv w21,w20,w19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("lslv w21,w20,w19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("lslv w21,w20,w19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("lslv w21,w20,w19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("lslv w21,w20,w19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("lslv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);

TESTINST3("lsrv w21,w20,w19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("lsrv w21,w20,w19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("lsrv w21,w20,w19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("lsrv w21,w20,w19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("lsrv w21,w20,w19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("lsrv w21,w20,w19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("lsrv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);

TESTINST3("asrv w21,w20,w19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("asrv w21,w20,w19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("asrv w21,w20,w19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("asrv w21,w20,w19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("asrv w21,w20,w19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("asrv w21,w20,w19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("asrv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);

TESTINST3("rorv w21,w20,w19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff00, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff01, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff02, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff1d, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff1e, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff1f, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff20, x21,x20,x19, 0);
TESTINST3("rorv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff21, x21,x20,x19, 0);


////////////////////////////////////////////////////////////////
printf("SDIV/UDIV\n");

TESTINST3("sdiv x21,x20,x19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 101, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 100, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  99, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  98, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", -101LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", -100LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  -99LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  -98LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 101, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", 100, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  99, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  98, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", -101LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", -100LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  -99LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  -98LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  1LL, 0LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  0LL, 0LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19", -1LL, 0LL, x21,x20,x19, 0);
TESTINST3("sdiv x21,x20,x19",  0x8000000000000000ULL, 0xFFFFFFFFFFFFFFFFULL, x21,x20,x19, 0);

TESTINST3("sdiv w21,w20,w19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 101, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 100, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  99, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  98, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", -101LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", -100LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  -99LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  -98LL, 20, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 101, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", 100, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  99, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  98, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", -101LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", -100LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  -99LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  -98LL, -20LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  1LL, 0LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  0LL, 0LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19", -1LL, 0LL, x21,x20,x19, 0);
TESTINST3("sdiv w21,w20,w19",  0x80000000ULL, 0xFFFFFFFFULL, x21,x20,x19, 0);

TESTINST3("udiv x21,x20,x19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 101, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 100, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  99, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  98, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", -101LL, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", -100LL, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  -99LL, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  -98LL, 20, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 101, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", 100, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  99, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  98, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", -101LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", -100LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  -99LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  -98LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  1LL, 0LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  0LL, 0LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19", -1LL, 0LL, x21,x20,x19, 0);
TESTINST3("udiv x21,x20,x19",  0x8000000000000000ULL, 0xFFFFFFFFFFFFFFFFULL, x21,x20,x19, 0);

TESTINST3("udiv w21,w20,w19", 0x4b154113f7d32514, 0xcce230caafbf9cc9, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 0x33d5d595721d4f13, 0xf4509311f443a7ce, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 0x4a3c6de6954cbc17, 0x111b21e39fbd7254, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 0xfbb5c64ed1b044c6, 0x33ca4c4fb3960326, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 0x2b7c5939d7c0f528, 0xb73870a5a6630162, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 0x02fe41918ac5cdba, 0x48e0815289728f05, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 0xb60a8f381f187bae, 0x008c208cc413ff72, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 101, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 100, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  99, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  98, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", -101LL, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", -100LL, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  -99LL, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  -98LL, 20, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 101, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", 100, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  99, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  98, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", -101LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", -100LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  -99LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  -98LL, -20LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  1LL, 0LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  0LL, 0LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19", -1LL, 0LL, x21,x20,x19, 0);
TESTINST3("udiv w21,w20,w19",  0x80000000ULL, 0xFFFFFFFFULL, x21,x20,x19, 0);


////////////////////////////////////////////////////////////////
printf("UMADDL/SMADDL/UMSUBL/SMSUBL\n");

TESTINST4("umaddl x14,w15,w16,x17",
          0x8318f285284c6473, 0xf2deaa8a065b5b97, 0xdb432311d1e3a1d0, x14,x15,x16,x17, 0);
TESTINST4("umaddl x14,w15,w16,x17",
          0xa6325ae016fbd710, 0xf0211fade82d1008, 0x70668d1659e224e8, x14,x15,x16,x17, 0);
TESTINST4("umaddl x14,w15,w16,x17",
          0x1f1dd8017f191501, 0xf69aef71040bfeab, 0x559bc9e2fca45761, x14,x15,x16,x17, 0);
TESTINST4("umaddl x14,w15,w16,x17",
          0x389ce2f3140cec0c, 0x7a3ab866f2dcd171, 0xa5d72d6243684403, x14,x15,x16,x17, 0);

TESTINST4("smaddl x14,w15,w16,x17",
          0x8318f285284c6473, 0xf2deaa8a065b5b97, 0xdb432311d1e3a1d0, x14,x15,x16,x17, 0);
TESTINST4("smaddl x14,w15,w16,x17",
          0xa6325ae016fbd710, 0xf0211fade82d1008, 0x70668d1659e224e8, x14,x15,x16,x17, 0);
TESTINST4("smaddl x14,w15,w16,x17",
          0x1f1dd8017f191501, 0xf69aef71040bfeab, 0x559bc9e2fca45761, x14,x15,x16,x17, 0);
TESTINST4("smaddl x14,w15,w16,x17",
          0x389ce2f3140cec0c, 0x7a3ab866f2dcd171, 0xa5d72d6243684403, x14,x15,x16,x17, 0);

TESTINST4("umsubl x14,w15,w16,x17",
          0x8318f285284c6473, 0xf2deaa8a065b5b97, 0xdb432311d1e3a1d0, x14,x15,x16,x17, 0);
TESTINST4("umsubl x14,w15,w16,x17",
          0xa6325ae016fbd710, 0xf0211fade82d1008, 0x70668d1659e224e8, x14,x15,x16,x17, 0);
TESTINST4("umsubl x14,w15,w16,x17",
          0x1f1dd8017f191501, 0xf69aef71040bfeab, 0x559bc9e2fca45761, x14,x15,x16,x17, 0);
TESTINST4("umsubl x14,w15,w16,x17",
          0x389ce2f3140cec0c, 0x7a3ab866f2dcd171, 0xa5d72d6243684403, x14,x15,x16,x17, 0);

TESTINST4("smsubl x14,w15,w16,x17",
          0x8318f285284c6473, 0xf2deaa8a065b5b97, 0xdb432311d1e3a1d0, x14,x15,x16,x17, 0);
TESTINST4("smsubl x14,w15,w16,x17",
          0xa6325ae016fbd710, 0xf0211fade82d1008, 0x70668d1659e224e8, x14,x15,x16,x17, 0);
TESTINST4("smsubl x14,w15,w16,x17",
          0x1f1dd8017f191501, 0xf69aef71040bfeab, 0x559bc9e2fca45761, x14,x15,x16,x17, 0);
TESTINST4("smsubl x14,w15,w16,x17",
          0x389ce2f3140cec0c, 0x7a3ab866f2dcd171, 0xa5d72d6243684403, x14,x15,x16,x17, 0);

} /* end of test_arith() */


////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

int main ( void )
{
  if (1) test_arith();
  return 0;
}
