/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.VersionAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.EquinoxExecutableAction;
import org.eclipse.equinox.p2.publisher.eclipse.EquinoxLauncherCUAction;

public class ApplicationLauncherAction
extends AbstractPublisherAction {
    private String flavor;
    private String[] configSpecs;
    private File location;
    private String executableName;
    private Version version;
    private String id;
    static /* synthetic */ Class class$0;

    public static String computeIUId(String id, String flavor) {
        return String.valueOf(flavor) + id + ".application";
    }

    public ApplicationLauncherAction(String id, Version version, String flavor, String executableName, File location, String[] configSpecs) {
        this.flavor = flavor;
        this.configSpecs = configSpecs;
        this.id = id;
        this.version = version;
        this.executableName = executableName;
        this.location = location;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        Collection actions = this.createActions(info);
        this.createAdvice(info, results);
        PublisherResult innerResult = new PublisherResult();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.ApplicationLauncherAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MultiStatus finalStatus = new MultiStatus(clazz.getName(), 0, "publishing result", null);
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            finalStatus.merge(((IPublisherAction)i.next()).perform(info, innerResult, monitor));
        }
        if (!finalStatus.isOK()) {
            return finalStatus;
        }
        results.merge(innerResult, 2);
        this.publishApplicationLauncherIU(innerResult.getIUs((String)null, "root"), results);
        return Status.OK_STATUS;
    }

    private void createAdvice(IPublisherInfo info, IPublisherResult results) {
        this.createLauncherAdvice(info, results);
    }

    private void createLauncherAdvice(IPublisherInfo info, IPublisherResult results) {
        Collection ius = this.getIUs(results.getIUs(null, null), "org.eclipse.equinox.launcher");
        VersionAdvice advice = new VersionAdvice();
        boolean found = false;
        Iterator i = ius.iterator();
        while (i.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)i.next();
            if (iu.getId().endsWith(".source") || iu.isFragment()) continue;
            advice.setVersion("org.eclipse.equinox.p2.iu", iu.getId(), iu.getVersion());
            found = true;
        }
        if (found) {
            info.addAdvice(advice);
        }
    }

    private Collection getIUs(Collection ius, String prefix) {
        HashSet<IInstallableUnit> result = new HashSet<IInstallableUnit>();
        Iterator iterator = ius.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit tmp = (IInstallableUnit)iterator.next();
            if (!tmp.getId().startsWith(prefix)) continue;
            result.add(tmp);
        }
        return result;
    }

    private void publishApplicationLauncherIU(Collection children, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription descriptor = this.createParentIU(children, ApplicationLauncherAction.computeIUId(this.id, this.flavor), this.version);
        descriptor.setSingleton(true);
        IInstallableUnit rootIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        if (rootIU == null) {
            return;
        }
        result.addIU(rootIU, "root");
    }

    private Collection createActions(IPublisherInfo info) {
        ArrayList<EquinoxLauncherCUAction> actions = new ArrayList<EquinoxLauncherCUAction>();
        actions.add(new EquinoxLauncherCUAction(this.flavor, this.configSpecs));
        actions.addAll(this.createExecutablesActions(this.configSpecs));
        return actions;
    }

    protected Collection createExecutablesActions(String[] configSpecs) {
        ArrayList<EquinoxExecutableAction> actions = new ArrayList<EquinoxExecutableAction>(configSpecs.length);
        int i = 0;
        while (i < configSpecs.length) {
            ExecutablesDescriptor executables = this.computeExecutables(configSpecs[i]);
            EquinoxExecutableAction action = new EquinoxExecutableAction(executables, configSpecs[i], this.id, this.version, this.flavor);
            actions.add(action);
            ++i;
        }
        return actions;
    }

    protected ExecutablesDescriptor computeExecutables(String configSpec) {
        ExecutablesDescriptor result = ExecutablesDescriptor.createExecutablesFromFeature(this.location, configSpec);
        if (result != null) {
            return result;
        }
        String os = AbstractPublisherAction.parseConfigSpec(configSpec)[1];
        return ExecutablesDescriptor.createDescriptor(os, this.executableName, this.location);
    }
}

