/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.rmi.RemoteException;
import javax.net.SocketFactory;
import javax.security.auth.x500.X500Principal;
import net.jini.jeri.ssl.ConfidentialityStrength;
import net.jini.jeri.ssl.HttpsEndpoint;
import net.jini.jeri.ssl.SslEndpoint;
import net.jini.security.TrustVerifier;

public final class SslTrustVerifier
implements TrustVerifier {
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        SocketFactory factory;
        if (obj == null || ctx == null) {
            throw new NullPointerException();
        }
        if (obj instanceof ConfidentialityStrength || obj instanceof X500Principal) {
            return true;
        }
        if (obj instanceof SslEndpoint) {
            factory = ((SslEndpoint)obj).getSocketFactory();
        } else if (obj instanceof HttpsEndpoint) {
            factory = ((HttpsEndpoint)obj).getSocketFactory();
        } else {
            return false;
        }
        return factory == null || ctx.isTrustedObject(factory);
    }
}

