/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.Frequency;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class VcalRewriter {
    private static final String DATE = "[0-9]{8,}(?:T[0-9]{6}Z?)?";
    private static final Pattern VCAL_RRULE = Pattern.compile("^((?:RRULE|EXRULE)(?:;[\\w-]+=(?:\"[^\"]*\"|[^;:\"]*))*:)(D|W|M[DP]|Y[DM])([0-9]*)((?:\\s+(?:MO|TU|WE|TH|FR|SA|SU|LD|(?:[0-9]{1,3}[+-]?)))*)(?:\\s+(?:#([0-9]+)|([0-9]{8,}(?:T[0-9]{6}Z?)?)))?$", 2);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    static String rewriteRule(String vcalText) {
        Frequency f;
        Matcher m = VCAL_RRULE.matcher(vcalText.trim());
        if (!m.matches()) {
            return vcalText;
        }
        StringBuilder sb = new StringBuilder();
        String nameAndParams = m.group(1);
        String freq = m.group(2).toUpperCase();
        String interval = m.group(3);
        String modifier = m.group(4).trim().toUpperCase();
        String count = m.group(5);
        String until = m.group(6);
        sb.append(nameAndParams);
        switch (freq.charAt(0)) {
            case 'Y': {
                f = Frequency.YEARLY;
                break;
            }
            case 'M': {
                f = Frequency.MONTHLY;
                break;
            }
            case 'W': {
                f = Frequency.WEEKLY;
                break;
            }
            case 'D': {
                f = Frequency.DAILY;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        sb.append("FREQ=").append(f.name());
        if (!"".equals(interval) && !"1".equals(interval)) {
            sb.append(";INTERVAL=").append(interval);
        }
        if (!"".equals(modifier)) {
            String[] parts = WHITESPACE.split(modifier);
            for (int i = 0; i < parts.length; ++i) {
                String p = parts[i];
                char lastchar = p.charAt(p.length() - 1);
                switch (lastchar) {
                    case '+': {
                        parts[i] = p.substring(0, p.length() - 1);
                        break;
                    }
                    case '-': {
                        parts[i] = lastchar + p.substring(0, p.length() - 1);
                    }
                }
                if (!p.equals("LD")) continue;
                parts[i] = "-1";
            }
            switch (f) {
                case YEARLY: {
                    if ('D' == freq.charAt(1)) {
                        sb.append(";BYYEARDAY=");
                        VcalRewriter.join(sb, ",", parts);
                        break;
                    }
                    sb.append(";BYMONTH=");
                    VcalRewriter.join(sb, ",", parts);
                    break;
                }
                case MONTHLY: {
                    if ('P' == freq.charAt(1)) {
                        int pos = 0;
                        boolean comma = false;
                        sb.append(";BYDAY=");
                        for (int i = 0; i < parts.length; ++i) {
                            if (!Character.isLetter(parts[i].charAt(0))) continue;
                            if (i > pos) {
                                for (int j = pos; j < i; ++j) {
                                    if (comma) {
                                        sb.append(',');
                                    } else {
                                        comma = true;
                                    }
                                    sb.append(parts[j]).append(parts[i]);
                                }
                            } else {
                                if (comma) {
                                    sb.append(',');
                                } else {
                                    comma = true;
                                }
                                sb.append(parts[i]);
                            }
                            pos = i + 1;
                        }
                        break;
                    }
                    sb.append(";BYMONTHDAY=");
                    VcalRewriter.join(sb, ",", parts);
                    break;
                }
                case WEEKLY: {
                    sb.append(";BYDAY=");
                    VcalRewriter.join(sb, ",", parts);
                    break;
                }
            }
        }
        if (null != count) {
            if (!"0".equals(count)) {
                sb.append(";COUNT=").append(count);
            }
        } else if (null != until) {
            until = until.toUpperCase();
            sb.append(";UNTIL=").append(until);
            if (!until.endsWith("Z") && until.indexOf(84) >= 0) {
                sb.append('Z');
            }
        }
        return sb.toString();
    }

    private static void join(StringBuilder out, String delim, String[] parts) {
        if (0 != parts.length) {
            out.append(parts[0]);
            for (int i = 1; i < parts.length; ++i) {
                out.append(delim).append(parts[i]);
            }
        }
    }

    private VcalRewriter() {
    }
}

