/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.instruments;

import org.jquantlib.instruments.Option;
import org.jquantlib.instruments.Payoff;
import org.jquantlib.instruments.StrikedTypePayoff;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public class CashOrNothingPayoff
extends StrikedTypePayoff {
    protected double cashPayoff;

    public CashOrNothingPayoff(Option.Type type, double strike, double cashPayoff) {
        super(type, strike);
        this.cashPayoff = cashPayoff;
    }

    public final double getCashPayoff() {
        return this.cashPayoff;
    }

    @Override
    public final double valueOf(double price) {
        if (this.type == Option.Type.CALL) {
            return price - this.strike > 0.0 ? this.cashPayoff : 0.0;
        }
        if (this.type == Option.Type.PUT) {
            return this.strike - price > 0.0 ? this.cashPayoff : 0.0;
        }
        throw new IllegalArgumentException("unknown option type");
    }

    @Override
    public void accept(TypedVisitor<Payoff> v) {
        Visitor<Payoff> v1;
        Visitor<Payoff> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 != null) {
            v1.visit(this);
        } else {
            super.accept(v);
        }
    }
}

