/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.time.Weekday;
import org.jquantlib.time.WesternCalendar;
import org.jquantlib.time.calendars.DelegateCalendar;
import org.jquantlib.util.Date;
import org.jquantlib.util.Month;

public class Denmark
extends DelegateCalendar {
    private static Denmark CSECalendar = new Denmark(Market.CSE);

    private Denmark(Market market) {
        CSECalendar delegate;
        switch (market) {
            case CSE: {
                delegate = new CSECalendar();
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown Market");
            }
        }
        this.setDelegate(delegate);
    }

    public static Denmark getCalendar(Market market) {
        switch (market) {
            case CSE: {
                return CSECalendar;
            }
        }
        throw new IllegalArgumentException("unkonwn Market");
    }

    private static final class CSECalendar
    extends WesternCalendar {
        private CSECalendar() {
        }

        @Override
        public String getName() {
            return "CSE";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.getWeekday();
            int d = date.getDayOfMonth();
            int dd = date.getDayOfYear();
            Month m = date.getMonthEnum();
            int y = date.getYear();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || dd == em - 4 || dd == em - 3 || dd == em || dd == em + 25 || dd == em + 38 || dd == em + 49 || d == 1 && m == Month.JANUARY || d == 5 && m == Month.JUNE || d == 25 && m == Month.DECEMBER || d == 26 && m == Month.DECEMBER || d == 24 && m == Month.DECEMBER && (y == 2008 || y == 2009 || y == 2007) || d == 31 && m == Month.DECEMBER && (y == 2008 || y == 2009 || y == 2007)) && (d != 22 || m != Month.MAY || y != 2009);
        }
    }

    public static enum Market {
        CSE;

    }
}

