/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.cashflow;

import java.util.List;
import org.jquantlib.Configuration;
import org.jquantlib.util.Date;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;
import org.jquantlib.util.TypedVisitable;
import org.jquantlib.util.TypedVisitor;
import org.jquantlib.util.Visitor;

public abstract class Event
implements Observable,
TypedVisitable<Event> {
    private boolean todaysPayments = Configuration.getSystemConfiguration(null).getGlobalSettings().isTodaysPayments();
    private DefaultObservable delegatedObservable = new DefaultObservable(this);

    protected Event() {
    }

    public abstract Date date();

    public boolean hasOccurred(Date d) {
        return this.hasOccurred(d, this.todaysPayments);
    }

    public boolean hasOccurred(Date d, boolean includeToday) {
        if (includeToday) {
            return this.date().compareTo(d) < 0;
        }
        return this.date().compareTo(d) <= 0;
    }

    @Override
    public void addObserver(Observer observer) {
        this.delegatedObservable.addObserver(observer);
    }

    @Override
    public int countObservers() {
        return this.delegatedObservable.countObservers();
    }

    @Override
    public void deleteObserver(Observer observer) {
        this.delegatedObservable.deleteObserver(observer);
    }

    @Override
    public void notifyObservers() {
        this.delegatedObservable.notifyObservers();
    }

    @Override
    public void notifyObservers(Object arg) {
        this.delegatedObservable.notifyObservers(arg);
    }

    @Override
    public void deleteObservers() {
        this.delegatedObservable.deleteObservers();
    }

    @Override
    public List<Observer> getObservers() {
        return this.delegatedObservable.getObservers();
    }

    @Override
    public void accept(TypedVisitor<Event> v) {
        Visitor<Event> v1;
        Visitor<Event> visitor = v1 = v != null ? v.getVisitor(this.getClass()) : null;
        if (v1 == null) {
            throw new IllegalArgumentException("null event visitor");
        }
        v1.visit(this);
    }
}

