package aQute.lib.diff;

/**
 * @author pkriens
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class Delta implements Comparable {
	
	public static final int DELE = 'd';
	public static final int INSE = 'i';
	public static final int COPY = 'c';
	public static final int ERRO = 'e';
	
	
	char type;
	int from;
	int length;
	byte src[];
	int	to;
	String error;
	
	
	Delta( String error ) { 
		this.type = 'e';
		this.error = error;
	}
	
	Delta( char type, byte[] src, int from, int to, int length  ) {
		this.type = type;
		this.src = src;
		this.from = from;
		this.to = to;
		this.length = length;
	}

	public int compareTo(Object other) {
		Delta d = (Delta) other;
		return from - d.from;
	}

	public String toString() {
		switch (type) {
			case 'c' : return "ok     " + context(src,from, from+length);
			case 'd' : return "delete " + "[" + context(src,from,from+length) + "]";
			case 'i' : return "insert " + context(src,from,from+length) ;
			case 'e' : return "error  " + error;
		}
		return null;
	}
	
	
	
	public String context() {
		switch (type) {
			case 'c' : return context(src,from, from+length);
			case 'd' : return context(src,from,from+length);
			case 'i' : return context(src,from,from+length) ;
			case 'e' : return "!" + error + "!";
		}
		return null;
	}
	
	public String hexContext() {
		switch (type) {
			case 'c' : return hexContext(src,from, from+length);
			case 'd' : return hexContext(src,from,from+length);
			case 'i' : return hexContext(src,from,from+length) ;
			case 'e' : return "!" + error + "!";
		}
		return null;
	}
	
	
	String context(byte[] buffer,int start, int end ) {
		StringBuffer	sb = new StringBuffer();
		
		if ( start < 0 )
			start =0;

		if ( end >=buffer.length )
			end = buffer.length;
			
		int l = end - start;
		String trunc = "";
		if ( l > 4096 ) {
			l = 4096;
			trunc = "...";
		}
		
		
		int left = l/2;
		int right = l - l/2;
		
		for ( int i=0; i<left; i++ )
			sb.append( escape(buffer[start+i]));
			
		sb.append( trunc );		
		for ( int i=-right; i<0; i++ )
			sb.append( escape(buffer[end+i]));

		return sb.toString();
	}
	
	String hexContext(byte[] buffer,int start, int end ) {
		StringBuffer	sb = new StringBuffer();
		sb.append( hex(start,6) );
		sb.append( " - " );
		sb.append( hex(end,6) );
		sb.append( " : " );
		if ( start < 0 )
			start =0;

		if ( end >=buffer.length )
			end = buffer.length;
			
		int l = end - start;
		String trunc = "";
		if ( l > 4096 ) {
			l = 4096;
			trunc = "...";
		}
		
		
		int left = l/2;
		int right = l - l/2;
		
		for ( int i=0; i<left; i++ ) {
			sb.append( hex(buffer[start+i],2));
			sb.append( " " );
		}
			
		sb.append( trunc );		
		for ( int i=-right; i<0; i++ ) {
			sb.append( hex(buffer[end+i],2));
			sb.append( " " );
		}

		return sb.toString();
	}

	public String escape( byte b ) {
		char	c = (char)b;
		if ( c > 127 ) {
			return "\\u00" + hex(c,2);
		}
		return ""+c;
	}
	
	String hex( int i, int width ) {
		String		hex =Integer.toHexString(0xFF&i).toUpperCase();
		String 		prefix = "000000000000000".substring(0,width-hex.length());
		return prefix + hex;
	}



	/**
	 * Returns the from.
	 * @return int
	 */
	public int getFrom() {
		return from;
	}

	/**
	 * Returns the length.
	 * @return int
	 */
	public int getLength() {
		return length;
	}

	/**
	 * Returns the type.
	 * @return char
	 */
	public char getType() {
		return type;
	}		

}
