// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -DLAMBDA -verify -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -DLAMBDA -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DLAMBDA -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -DLAMBDA -verify -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -DLAMBDA -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DLAMBDA -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK3

// RUN: %clang_cc1 -DLAMBDA -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DLAMBDA -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK5
// RUN: %clang_cc1 -DLAMBDA -verify -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK6
// RUN: %clang_cc1 -DLAMBDA -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1 -DLAMBDA -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK6

// RUN: %clang_cc1  -verify -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK8
// RUN: %clang_cc1  -fopenmp -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1  -fopenmp -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK8
// RUN: %clang_cc1  -verify -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK10
// RUN: %clang_cc1  -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1  -fopenmp -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK10

// RUN: %clang_cc1  -verify -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-llvm %s -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK12
// RUN: %clang_cc1  -fopenmp-simd -x c++ -std=c++11 -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1  -fopenmp-simd -x c++ -triple powerpc64le-unknown-unknown -fopenmp-targets=powerpc64le-ibm-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK12
// RUN: %clang_cc1  -verify -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-llvm %s -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK14
// RUN: %clang_cc1  -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -emit-pch -o %t %s
// RUN: %clang_cc1  -fopenmp-simd -x c++ -std=c++11 -triple i386-unknown-unknown -fopenmp-targets=i386-pc-linux-gnu -std=c++11 -include-pch %t -verify %s -emit-llvm -o - -Wno-openmp-mapping | FileCheck %s --check-prefix=CHECK14
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

template <class T>
struct S {
  T f;
  S(T a) : f(a) {}
  S() : f() {}
  operator T() { return T(); }
  ~S() {}
};

template <typename T>
T tmain() {
  S<T> test;
  T t_var = T();
  T vec[] = {1, 2};
  S<T> s_arr[] = {1, 2};
  S<T> &var = test;
  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for simd firstprivate(t_var, vec, s_arr, s_arr, var, var)
  for (int i = 0; i < 2; ++i) {
    vec[i] = t_var;
    s_arr[i] = var;
  }
  return T();
}

int main() {
  static int svar;
  volatile double g;
  volatile double &g1 = g;

  #ifdef LAMBDA
  [&]() {
    static float sfvar;

    #pragma omp target
    #pragma omp teams
    #pragma omp distribute parallel for simd firstprivate(g, g1, svar, sfvar)
    for (int i = 0; i < 2; ++i) {

      // addr alloca's

      // private alloca's

      // transfer input parameters into addr alloca's

      // init private alloca's with addr alloca's
      // g

      // g1

      // svar

      // sfvar

      // pass firstprivate parameters to parallel outlined function
      // g

      // g1

      // svar

      // sfvar



      // skip initial params

      // addr alloca's

      // private alloca's (only for 32-bit)

      // transfer input parameters into addr alloca's

      // prepare parameters for lambda
      // g

      // g1

      // svar

      // sfvar

      g = 1;
      g1 = 1;
      svar = 3;
      sfvar = 4.0;

      // pass params to inner lambda
      [&]() {
	g = 2;
	g1 = 2;
	svar = 4;
	sfvar = 8.0;

      }();
    }
  }();
  return 0;
  #else
  S<float> test;
  int t_var = 0;
  int vec[] = {1, 2};
  S<float> s_arr[] = {1, 2};
  S<float> &var = test;

  #pragma omp target
  #pragma omp teams
  #pragma omp distribute parallel for simd firstprivate(t_var, vec, s_arr, s_arr, var, var, svar)
  for (int i = 0; i < 2; ++i) {
    vec[i] = t_var;
    s_arr[i] = var;
  }
  return tmain<int>();
  #endif
}




// addr alloca's

// skip loop alloca's

// private alloca's


// init addr alloca's with input values

// init private alloca's with addr alloca's
// t-var

// vec

// s_arr

// var

// svar

// pass private alloca's to fork
// not dag to distinguish with S_VAR_CAST

// call destructors: var..

// ..and s_arr


// By OpenMP specifications, 'firstprivate' applies to both distribute and parallel for.
// However, the support for 'firstprivate' of 'parallel' is only used when 'parallel'
// is found alone. Therefore we only have one 'firstprivate' support for 'parallel for'
// in combination

// addr alloca's

// skip loop alloca's

// private alloca's


// init addr alloca's with input values

// init private alloca's with addr alloca's
// vec

// s_arr

// var


// call destructors: var..

// ..and s_arr


// template tmain with S_INT_TY



// addr alloca's

// skip loop alloca's

// private alloca's


// init addr alloca's with input values

// init private alloca's with addr alloca's
// t-var

// vec

// s_arr

// var

// pass private alloca's to fork
// not dag to distinguish with S_VAR_CAST

// call destructors: var..

// ..and s_arr


// By OpenMP specifications, 'firstprivate' applies to both distribute and parallel for.
// However, the support for 'firstprivate' of 'parallel' is only used when 'parallel'
// is found alone. Therefore we only have one 'firstprivate' support for 'parallel for'
// in combination

// addr alloca's

// skip loop alloca's

// private alloca's


// init addr alloca's with input values

// init private alloca's with addr alloca's
// vec

// s_arr

// var


// call destructors: var..

// ..and s_arr


#endif
// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[G1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    store ptr [[G]], ptr [[G1]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[G]], ptr [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[G1]], align 8
// CHECK1-NEXT:    store ptr [[TMP2]], ptr [[TMP1]], align 8
// CHECK1-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l67
// CHECK1-SAME: (i64 noundef [[G:%.*]], i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store i64 [[G]], ptr [[G_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G1]], ptr [[G1_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SVAR]], ptr [[SVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SFVAR]], ptr [[SFVAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[G1_ADDR]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3:[0-9]+]], i32 4, ptr @.omp_outlined., ptr [[G_ADDR]], ptr [[TMP0]], ptr [[SVAR_ADDR]], ptr [[SFVAR_ADDR]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[G:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[G1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SVAR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SFVAR:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[G_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[G1_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SVAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SFVAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[G3:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[G14:%.*]] = alloca double, align 8
// CHECK1-NEXT:    [[_TMP5:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SVAR6:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[SFVAR7:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[G_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G1_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[G]], ptr [[G_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[G1]], ptr [[G1_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[SVAR]], ptr [[SVAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[SFVAR]], ptr [[SFVAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[G_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[G1_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SVAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SFVAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[TMP4]], ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load double, ptr [[TMP0]], align 8
// CHECK1-NEXT:    store double [[TMP5]], ptr [[G3]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8
// CHECK1-NEXT:    store double [[TMP7]], ptr [[G14]], align 8
// CHECK1-NEXT:    store ptr [[G14]], ptr [[_TMP5]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], ptr [[SVAR6]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load float, ptr [[TMP3]], align 4
// CHECK1-NEXT:    store float [[TMP9]], ptr [[SFVAR7]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP11]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP12]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP4:![0-9]+]]
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK1-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK1-NEXT:    [[TMP21:%.*]] = load double, ptr [[G3]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    store double [[TMP21]], ptr [[G_CASTED]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP22:%.*]] = load i64, ptr [[G_CASTED]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[_TMP5]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP24:%.*]] = load volatile double, ptr [[TMP23]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    store double [[TMP24]], ptr [[G1_CASTED]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP25:%.*]] = load i64, ptr [[G1_CASTED]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, ptr [[SVAR6]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    store i32 [[TMP26]], ptr [[SVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP27:%.*]] = load i64, ptr [[SVAR_CASTED]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP28:%.*]] = load float, ptr [[SFVAR7]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    store float [[TMP28]], ptr [[SFVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP29:%.*]] = load i64, ptr [[SFVAR_CASTED]], align 8, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 6, ptr @.omp_outlined..1, i64 [[TMP18]], i64 [[TMP20]], i64 [[TMP22]], i64 [[TMP25]], i64 [[TMP27]], i64 [[TMP29]]), !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP30]], [[TMP31]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP4]]
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP5:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP11]])
// CHECK1-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP33:%.*]] = icmp ne i32 [[TMP32]], 0
// CHECK1-NEXT:    br i1 [[TMP33]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], i64 noundef [[G:%.*]], i64 noundef [[G1:%.*]], i64 noundef [[SVAR:%.*]], i64 noundef [[SFVAR:%.*]]) #[[ATTR2]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[G1_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G]], ptr [[G_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[G1]], ptr [[G1_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SVAR]], ptr [[SVAR_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[SFVAR]], ptr [[SFVAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[G1_ADDR]], ptr [[TMP]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP0:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP0]] to i32
// CHECK1-NEXT:    [[TMP1:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK1-NEXT:    [[CONV2:%.*]] = trunc i64 [[TMP1]] to i32
// CHECK1-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[CONV2]], ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP3]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP4]], 1
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP5]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK1-NEXT:    store i32 [[TMP6]], ptr [[DOTOMP_IV]], align 4
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK1:       omp.inner.for.cond:
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP8:![0-9]+]]
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP7]], [[TMP8]]
// CHECK1-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK1:       omp.inner.for.body:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], 1
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    store double 1.000000e+00, ptr [[G_ADDR]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    store volatile double 1.000000e+00, ptr [[TMP10]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    store i32 3, ptr [[SVAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    store float 4.000000e+00, ptr [[SFVAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[G_ADDR]], ptr [[TMP11]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[SVAR_ADDR]], ptr [[TMP14]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    store ptr [[SFVAR_ADDR]], ptr [[TMP15]], align 8, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(ptr noundef nonnull align 8 dereferenceable(32) [[REF_TMP]]), !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK1:       omp.body.continue:
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK1:       omp.inner.for.inc:
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP16]], 1
// CHECK1-NEXT:    store i32 [[ADD4]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP8]]
// CHECK1-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP9:![0-9]+]]
// CHECK1:       omp.inner.for.end:
// CHECK1-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK1:       omp.loop.exit:
// CHECK1-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = icmp ne i32 [[TMP17]], 0
// CHECK1-NEXT:    br i1 [[TMP18]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK1:       .omp.final.then:
// CHECK1-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK1-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK1:       .omp.final.done:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK1-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK1-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@main
// CHECK3-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[G1:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK3-NEXT:    store ptr [[G]], ptr [[G1]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store ptr [[G]], ptr [[TMP0]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[G1]], align 4
// CHECK3-NEXT:    store ptr [[TMP2]], ptr [[TMP1]], align 4
// CHECK3-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(ptr noundef nonnull align 4 dereferenceable(8) [[REF_TMP]])
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l67
// CHECK3-SAME: (ptr noundef nonnull align 4 dereferenceable(8) [[G:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[G_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[G1_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[G2:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[G13:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[_TMP4:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    store ptr [[G]], ptr [[G_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[G1]], ptr [[G1_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SVAR]], ptr [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SFVAR]], ptr [[SFVAR_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[G_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[G1_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load double, ptr [[TMP0]], align 8
// CHECK3-NEXT:    store double [[TMP2]], ptr [[G2]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load volatile double, ptr [[TMP3]], align 4
// CHECK3-NEXT:    store double [[TMP4]], ptr [[G13]], align 8
// CHECK3-NEXT:    store ptr [[G13]], ptr [[_TMP4]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[_TMP4]], align 4
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3:[0-9]+]], i32 4, ptr @.omp_outlined., ptr [[G2]], ptr [[TMP5]], ptr [[SVAR_ADDR]], ptr [[SFVAR_ADDR]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[G:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[G1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SVAR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SFVAR:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[G_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[G1_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SVAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SFVAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G3:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[G14:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[_TMP5:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[SVAR6:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR7:%.*]] = alloca float, align 4
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G1_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[G]], ptr [[G_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[G1]], ptr [[G1_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[SVAR]], ptr [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[SFVAR]], ptr [[SFVAR_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[G_ADDR]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[G1_ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SFVAR_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 4
// CHECK3-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK3-NEXT:    store ptr [[TMP4]], ptr [[_TMP1]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 1, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load double, ptr [[TMP0]], align 8
// CHECK3-NEXT:    store double [[TMP5]], ptr [[G3]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP1]], align 4
// CHECK3-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 4
// CHECK3-NEXT:    store double [[TMP7]], ptr [[G14]], align 8
// CHECK3-NEXT:    store ptr [[G14]], ptr [[_TMP5]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], ptr [[SVAR6]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load float, ptr [[TMP3]], align 4
// CHECK3-NEXT:    store float [[TMP9]], ptr [[SFVAR7]], align 4
// CHECK3-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP11]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP12]], 1
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK3-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP5:![0-9]+]]
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK3-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[_TMP5]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP20:%.*]] = load volatile double, ptr [[TMP19]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    store double [[TMP20]], ptr [[G1_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[G1_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[SVAR6]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    store i32 [[TMP22]], ptr [[SVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, ptr [[SVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP24:%.*]] = load float, ptr [[SFVAR7]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    store float [[TMP24]], ptr [[SFVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, ptr [[SFVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 6, ptr @.omp_outlined..1, i32 [[TMP17]], i32 [[TMP18]], ptr [[G3]], i32 [[TMP21]], i32 [[TMP23]], i32 [[TMP25]]), !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP26]], [[TMP27]]
// CHECK3-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP11]])
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK3-NEXT:    br i1 [[TMP29]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[G:%.*]], i32 noundef [[G1:%.*]], i32 noundef [[SVAR:%.*]], i32 noundef [[SFVAR:%.*]]) #[[ATTR2]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G_ADDR:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[G1_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SFVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK3-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[G2:%.*]] = alloca double, align 8
// CHECK3-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 4
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store ptr [[G]], ptr [[G_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[G1]], ptr [[G1_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SVAR]], ptr [[SVAR_ADDR]], align 4
// CHECK3-NEXT:    store i32 [[SFVAR]], ptr [[SFVAR_ADDR]], align 4
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[G_ADDR]], align 4
// CHECK3-NEXT:    store ptr [[G1_ADDR]], ptr [[TMP]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP1:%.*]] = load i32, ptr [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK3-NEXT:    [[TMP2:%.*]] = load i32, ptr [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK3-NEXT:    store i32 [[TMP1]], ptr [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP2]], ptr [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK3-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP3:%.*]] = load double, ptr [[TMP0]], align 8
// CHECK3-NEXT:    store double [[TMP3]], ptr [[G2]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK3-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP5]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK3-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP6]], 1
// CHECK3-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK3:       cond.true:
// CHECK3-NEXT:    br label [[COND_END:%.*]]
// CHECK3:       cond.false:
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    br label [[COND_END]]
// CHECK3:       cond.end:
// CHECK3-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP7]], [[COND_FALSE]] ]
// CHECK3-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK3-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV]], align 4
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK3:       omp.inner.for.cond:
// CHECK3-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9:![0-9]+]]
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[CMP3:%.*]] = icmp sle i32 [[TMP9]], [[TMP10]]
// CHECK3-NEXT:    br i1 [[CMP3]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK3:       omp.inner.for.body:
// CHECK3-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP11]], 1
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK3-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    store double 1.000000e+00, ptr [[G2]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    store volatile double 1.000000e+00, ptr [[TMP12]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    store i32 3, ptr [[SVAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    store float 4.000000e+00, ptr [[SFVAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store ptr [[G2]], ptr [[TMP13]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    store ptr [[TMP15]], ptr [[TMP14]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[SVAR_ADDR]], ptr [[TMP16]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    store ptr [[SFVAR_ADDR]], ptr [[TMP17]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    call void @"_ZZZ4mainENK3$_0clEvENKUlvE_clEv"(ptr noundef nonnull align 4 dereferenceable(16) [[REF_TMP]]), !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK3:       omp.body.continue:
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK3:       omp.inner.for.inc:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    [[ADD4:%.*]] = add nsw i32 [[TMP18]], 1
// CHECK3-NEXT:    store i32 [[ADD4]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK3-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK3:       omp.inner.for.end:
// CHECK3-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK3:       omp.loop.exit:
// CHECK3-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP5]])
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = icmp ne i32 [[TMP19]], 0
// CHECK3-NEXT:    br i1 [[TMP20]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK3:       .omp.final.then:
// CHECK3-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK3-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK3:       .omp.final.done:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK3-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK3-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@main
// CHECK5-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK5-NEXT:    [[G1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK5-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK5-NEXT:    store ptr [[G]], ptr [[G1]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK5-NEXT:    store ptr [[G]], ptr [[TMP0]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[G1]], align 8
// CHECK5-NEXT:    store ptr [[TMP2]], ptr [[TMP1]], align 8
// CHECK5-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK5-NEXT:    ret i32 0
//
//
// CHECK6-LABEL: define {{[^@]+}}@main
// CHECK6-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK6-NEXT:    [[G1:%.*]] = alloca ptr, align 4
// CHECK6-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 4
// CHECK6-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK6-NEXT:    store ptr [[G]], ptr [[G1]], align 4
// CHECK6-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK6-NEXT:    store ptr [[G]], ptr [[TMP0]], align 4
// CHECK6-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK6-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[G1]], align 4
// CHECK6-NEXT:    store ptr [[TMP2]], ptr [[TMP1]], align 4
// CHECK6-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(ptr noundef nonnull align 4 dereferenceable(8) [[REF_TMP]])
// CHECK6-NEXT:    ret i32 0
//
//
// CHECK8-LABEL: define {{[^@]+}}@main
// CHECK8-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK8-NEXT:    [[G1:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK8-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK8-NEXT:    [[VAR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x ptr], align 8
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x ptr], align 8
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x ptr], align 8
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK8-NEXT:    store ptr [[G]], ptr [[G1]], align 8
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK8-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i64 8, i1 false)
// CHECK8-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK8-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK8-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK8-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 8
// CHECK8-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load i32, ptr [[T_VAR]], align 4
// CHECK8-NEXT:    store i32 [[TMP1]], ptr [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i64, ptr [[T_VAR_CASTED]], align 8
// CHECK8-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP4:%.*]] = load i32, ptr @_ZZ4mainE4svar, align 4
// CHECK8-NEXT:    store i32 [[TMP4]], ptr [[SVAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i64, ptr [[SVAR_CASTED]], align 8
// CHECK8-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    store i64 [[TMP2]], ptr [[TMP8]], align 8
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    store i64 [[TMP2]], ptr [[TMP9]], align 8
// CHECK8-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK8-NEXT:    store ptr null, ptr [[TMP10]], align 8
// CHECK8-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[TMP11]], align 8
// CHECK8-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[TMP12]], align 8
// CHECK8-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK8-NEXT:    store ptr null, ptr [[TMP13]], align 8
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[TMP14]], align 8
// CHECK8-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[TMP15]], align 8
// CHECK8-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK8-NEXT:    store ptr null, ptr [[TMP16]], align 8
// CHECK8-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK8-NEXT:    store ptr [[TMP6]], ptr [[TMP17]], align 8
// CHECK8-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK8-NEXT:    store ptr [[TMP7]], ptr [[TMP18]], align 8
// CHECK8-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK8-NEXT:    store ptr null, ptr [[TMP19]], align 8
// CHECK8-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK8-NEXT:    store i64 [[TMP5]], ptr [[TMP20]], align 8
// CHECK8-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK8-NEXT:    store i64 [[TMP5]], ptr [[TMP21]], align 8
// CHECK8-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 4
// CHECK8-NEXT:    store ptr null, ptr [[TMP22]], align 8
// CHECK8-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK8-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK8-NEXT:    store i32 1, ptr [[TMP25]], align 4
// CHECK8-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK8-NEXT:    store i32 5, ptr [[TMP26]], align 4
// CHECK8-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK8-NEXT:    store ptr [[TMP23]], ptr [[TMP27]], align 8
// CHECK8-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK8-NEXT:    store ptr [[TMP24]], ptr [[TMP28]], align 8
// CHECK8-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK8-NEXT:    store ptr @.offload_sizes, ptr [[TMP29]], align 8
// CHECK8-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK8-NEXT:    store ptr @.offload_maptypes, ptr [[TMP30]], align 8
// CHECK8-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK8-NEXT:    store ptr null, ptr [[TMP31]], align 8
// CHECK8-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK8-NEXT:    store ptr null, ptr [[TMP32]], align 8
// CHECK8-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK8-NEXT:    store i64 2, ptr [[TMP33]], align 8
// CHECK8-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB3:[0-9]+]], i64 -1, i32 0, i32 1, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l138.region_id, ptr [[KERNEL_ARGS]])
// CHECK8-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK8-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l138(i64 [[TMP2]], ptr [[VEC]], ptr [[S_ARR]], ptr [[TMP3]], i64 [[TMP5]]) #[[ATTR4:[0-9]+]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z5tmainIiET_v()
// CHECK8-NEXT:    store i32 [[CALL]], ptr [[RETVAL]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP36]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done2:
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK8-NEXT:    [[TMP37:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK8-NEXT:    ret i32 [[TMP37]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    call void @_ZN1SIfEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIfEC2Ef(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l138
// CHECK8-SAME: (i64 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store i64 [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store i64 [[SVAR]], ptr [[SVAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 5, ptr @.omp_outlined., ptr [[T_VAR_ADDR]], ptr [[TMP0]], ptr [[TMP1]], ptr [[TMP3]], ptr [[SVAR_ADDR]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK8-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[SVAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR3:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC4:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR5:%.*]] = alloca [2 x %struct.S], align 4
// CHECK8-NEXT:    [[VAR7:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK8-NEXT:    [[_TMP8:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[SVAR9:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[SVAR_CASTED:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[SVAR]], ptr [[SVAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SVAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[TMP3]], ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    store ptr [[TMP5]], ptr [[_TMP1]], align 8
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK8-NEXT:    store i32 [[TMP6]], ptr [[T_VAR3]], align 4
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC4]], ptr align 4 [[TMP1]], i64 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR5]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP7:%.*]] = getelementptr [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP7]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE6:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i64 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP7]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE6]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done6:
// CHECK8-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VAR7]], ptr align 4 [[TMP8]], i64 4, i1 false)
// CHECK8-NEXT:    store ptr [[VAR7]], ptr [[_TMP8]], align 8
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK8-NEXT:    store i32 [[TMP9]], ptr [[SVAR9]], align 4
// CHECK8-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP11]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP12]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP5:![0-9]+]]
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK8-NEXT:    br i1 [[CMP10]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[TMP20:%.*]] = zext i32 [[TMP19]] to i64
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, ptr [[T_VAR3]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    store i32 [[TMP21]], ptr [[T_VAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[TMP22:%.*]] = load i64, ptr [[T_VAR_CASTED]], align 8, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[_TMP8]], align 8, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[TMP24:%.*]] = load i32, ptr [[SVAR9]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    store i32 [[TMP24]], ptr [[SVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[TMP25:%.*]] = load i64, ptr [[SVAR_CASTED]], align 8, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @.omp_outlined..1, i64 [[TMP18]], i64 [[TMP20]], ptr [[VEC4]], i64 [[TMP22]], ptr [[S_ARR5]], ptr [[TMP23]], i64 [[TMP25]]), !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP26]], [[TMP27]]
// CHECK8-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP5]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP6:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP29:%.*]] = load i32, ptr [[TMP28]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP29]])
// CHECK8-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP31:%.*]] = icmp ne i32 [[TMP30]], 0
// CHECK8-NEXT:    br i1 [[TMP31]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR7]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR5]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN11]], i64 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP32]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done12:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK8-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i64 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[SVAR_ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S], align 4
// CHECK8-NEXT:    [[VAR6:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK8-NEXT:    [[_TMP7:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK8-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK8-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    store i64 [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store i64 [[SVAR]], ptr [[SVAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 8
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK8-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK8-NEXT:    [[TMP4:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK8-NEXT:    [[CONV2:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK8-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[CONV2]], ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC3]], ptr align 4 [[TMP0]], i64 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP5:%.*]] = getelementptr [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP5]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE5:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP1]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i64 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP5]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE5]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done5:
// CHECK8-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VAR6]], ptr align 4 [[TMP6]], i64 4, i1 false)
// CHECK8-NEXT:    store ptr [[VAR6]], ptr [[_TMP7]], align 8
// CHECK8-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP8]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP9]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP10]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP11]], ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9:![0-9]+]]
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP12]], [[TMP13]]
// CHECK8-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP14]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, ptr [[T_VAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP16]] to i64
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC3]], i64 0, i64 [[IDXPROM]]
// CHECK8-NEXT:    store i32 [[TMP15]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP7]], align 8, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP18]] to i64
// CHECK8-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR4]], i64 0, i64 [[IDXPROM9]]
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX10]], ptr align 4 [[TMP17]], i64 4, i1 false), !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK8-NEXT:    store i32 [[ADD11]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP9]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP10:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP21]])
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK8-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR6]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN12]], i64 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK8-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done13:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    call void @_ZN1SIfED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK8-SAME: () #[[ATTR5:[0-9]+]] comdat {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK8-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK8-NEXT:    [[VAR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x ptr], align 8
// CHECK8-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x ptr], align 8
// CHECK8-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x ptr], align 8
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK8-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i64 8, i1 false)
// CHECK8-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef signext 1)
// CHECK8-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK8-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef signext 2)
// CHECK8-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 8
// CHECK8-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load i32, ptr [[T_VAR]], align 4
// CHECK8-NEXT:    store i32 [[TMP1]], ptr [[T_VAR_CASTED]], align 4
// CHECK8-NEXT:    [[TMP2:%.*]] = load i64, ptr [[T_VAR_CASTED]], align 8
// CHECK8-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    store i64 [[TMP2]], ptr [[TMP6]], align 8
// CHECK8-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    store i64 [[TMP2]], ptr [[TMP7]], align 8
// CHECK8-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 0
// CHECK8-NEXT:    store ptr null, ptr [[TMP8]], align 8
// CHECK8-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[TMP9]], align 8
// CHECK8-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[TMP10]], align 8
// CHECK8-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 1
// CHECK8-NEXT:    store ptr null, ptr [[TMP11]], align 8
// CHECK8-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[TMP12]], align 8
// CHECK8-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[TMP13]], align 8
// CHECK8-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 2
// CHECK8-NEXT:    store ptr null, ptr [[TMP14]], align 8
// CHECK8-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK8-NEXT:    store ptr [[TMP4]], ptr [[TMP15]], align 8
// CHECK8-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK8-NEXT:    store ptr [[TMP5]], ptr [[TMP16]], align 8
// CHECK8-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i64 0, i64 3
// CHECK8-NEXT:    store ptr null, ptr [[TMP17]], align 8
// CHECK8-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK8-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK8-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK8-NEXT:    store i32 1, ptr [[TMP20]], align 4
// CHECK8-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK8-NEXT:    store i32 4, ptr [[TMP21]], align 4
// CHECK8-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK8-NEXT:    store ptr [[TMP18]], ptr [[TMP22]], align 8
// CHECK8-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK8-NEXT:    store ptr [[TMP19]], ptr [[TMP23]], align 8
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK8-NEXT:    store ptr @.offload_sizes.4, ptr [[TMP24]], align 8
// CHECK8-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK8-NEXT:    store ptr @.offload_maptypes.5, ptr [[TMP25]], align 8
// CHECK8-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK8-NEXT:    store ptr null, ptr [[TMP26]], align 8
// CHECK8-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK8-NEXT:    store ptr null, ptr [[TMP27]], align 8
// CHECK8-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK8-NEXT:    store i64 2, ptr [[TMP28]], align 8
// CHECK8-NEXT:    [[TMP29:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB3]], i64 -1, i32 0, i32 1, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l48.region_id, ptr [[KERNEL_ARGS]])
// CHECK8-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK8-NEXT:    br i1 [[TMP30]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK8:       omp_offload.failed:
// CHECK8-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l48(i64 [[TMP2]], ptr [[VEC]], ptr [[S_ARR]], ptr [[TMP3]]) #[[ATTR4]]
// CHECK8-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK8:       omp_offload.cont:
// CHECK8-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP31]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done2:
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK8-NEXT:    [[TMP32:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK8-NEXT:    ret i32 [[TMP32]]
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    store float 0.000000e+00, ptr [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    store float [[TMP0]], ptr [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef signext [[TMP0]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l48
// CHECK8-SAME: (i64 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store i64 [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 4, ptr @.omp_outlined..2, ptr [[T_VAR_ADDR]], ptr [[TMP0]], ptr [[TMP1]], ptr [[TMP3]])
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK8-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR3:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC4:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR5:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK8-NEXT:    [[VAR7:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK8-NEXT:    [[_TMP8:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[TMP3]], ptr [[TMP]], align 8
// CHECK8-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    store ptr [[TMP4]], ptr [[_TMP1]], align 8
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK8-NEXT:    store i32 [[TMP5]], ptr [[T_VAR3]], align 4
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC4]], ptr align 4 [[TMP1]], i64 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR5]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP6]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE6:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i64 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP6]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE6]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done6:
// CHECK8-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VAR7]], ptr align 4 [[TMP7]], i64 4, i1 false)
// CHECK8-NEXT:    store ptr [[VAR7]], ptr [[_TMP8]], align 8
// CHECK8-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14:![0-9]+]]
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK8-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP15]] to i64
// CHECK8-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP17]] to i64
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, ptr [[T_VAR3]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    store i32 [[TMP19]], ptr [[T_VAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[TMP20:%.*]] = load i64, ptr [[T_VAR_CASTED]], align 8, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[_TMP8]], align 8, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 6, ptr @.omp_outlined..3, i64 [[TMP16]], i64 [[TMP18]], ptr [[VEC4]], i64 [[TMP20]], ptr [[S_ARR5]], ptr [[TMP21]]), !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP22]], [[TMP23]]
// CHECK8-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP14]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP25]])
// CHECK8-NEXT:    [[TMP26:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], 0
// CHECK8-NEXT:    br i1 [[TMP27]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR7]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR5]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN10]], i64 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP28]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN10]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE11:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done11:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK8-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i64 noundef [[DOTPREVIOUS_LB_:%.*]], i64 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i64 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i64, align 8
// CHECK8-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    [[VEC3:%.*]] = alloca [2 x i32], align 4
// CHECK8-NEXT:    [[S_ARR4:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK8-NEXT:    [[VAR6:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK8-NEXT:    [[_TMP7:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK8-NEXT:    store i64 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK8-NEXT:    store i64 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    store i64 [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK8-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK8-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK8-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 8
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP3:%.*]] = load i64, ptr [[DOTPREVIOUS_LB__ADDR]], align 8
// CHECK8-NEXT:    [[CONV:%.*]] = trunc i64 [[TMP3]] to i32
// CHECK8-NEXT:    [[TMP4:%.*]] = load i64, ptr [[DOTPREVIOUS_UB__ADDR]], align 8
// CHECK8-NEXT:    [[CONV2:%.*]] = trunc i64 [[TMP4]] to i32
// CHECK8-NEXT:    store i32 [[CONV]], ptr [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[CONV2]], ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK8-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC3]], ptr align 4 [[TMP0]], i64 8, i1 false)
// CHECK8-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP5:%.*]] = getelementptr [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK8-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP5]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE5:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK8:       omp.arraycpy.body:
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP1]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i64 4, i1 false)
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK8-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP5]]
// CHECK8-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE5]], label [[OMP_ARRAYCPY_BODY]]
// CHECK8:       omp.arraycpy.done5:
// CHECK8-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VAR6]], ptr align 4 [[TMP6]], i64 4, i1 false)
// CHECK8-NEXT:    store ptr [[VAR6]], ptr [[_TMP7]], align 8
// CHECK8-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP8]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK8-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP9]], 1
// CHECK8-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK8:       cond.true:
// CHECK8-NEXT:    br label [[COND_END:%.*]]
// CHECK8:       cond.false:
// CHECK8-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    br label [[COND_END]]
// CHECK8:       cond.end:
// CHECK8-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP10]], [[COND_FALSE]] ]
// CHECK8-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK8-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK8-NEXT:    store i32 [[TMP11]], ptr [[DOTOMP_IV]], align 4
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK8:       omp.inner.for.cond:
// CHECK8-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP17:![0-9]+]]
// CHECK8-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[CMP8:%.*]] = icmp sle i32 [[TMP12]], [[TMP13]]
// CHECK8-NEXT:    br i1 [[CMP8]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK8:       omp.inner.for.cond.cleanup:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK8:       omp.inner.for.body:
// CHECK8-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP14]], 1
// CHECK8-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK8-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[TMP15:%.*]] = load i32, ptr [[T_VAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[TMP16:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP16]] to i64
// CHECK8-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC3]], i64 0, i64 [[IDXPROM]]
// CHECK8-NEXT:    store i32 [[TMP15]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP7]], align 8, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[TMP18:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP18]] to i64
// CHECK8-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR4]], i64 0, i64 [[IDXPROM9]]
// CHECK8-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX10]], ptr align 4 [[TMP17]], i64 4, i1 false), !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK8:       omp.body.continue:
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK8:       omp.inner.for.inc:
// CHECK8-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    [[ADD11:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK8-NEXT:    store i32 [[ADD11]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP17]]
// CHECK8-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP18:![0-9]+]]
// CHECK8:       omp.inner.for.end:
// CHECK8-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK8:       omp.loop.exit:
// CHECK8-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK8-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK8-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP21]])
// CHECK8-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK8-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK8-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK8:       .omp.final.then:
// CHECK8-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK8-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK8:       .omp.final.done:
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR6]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAY_BEGIN12:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR4]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN12]], i64 2
// CHECK8-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK8:       arraydestroy.body:
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK8-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK8-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK8-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN12]]
// CHECK8-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE13:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK8:       arraydestroy.done13:
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    store i32 0, ptr [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK8-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK8-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK8-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK8-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK8-NEXT:    ret void
//
//
// CHECK8-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK8-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK8-NEXT:  entry:
// CHECK8-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK8-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@main
// CHECK10-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK10-NEXT:    [[G1:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK10-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK10-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK10-NEXT:    [[VAR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [5 x ptr], align 4
// CHECK10-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [5 x ptr], align 4
// CHECK10-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [5 x ptr], align 4
// CHECK10-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK10-NEXT:    store ptr [[G]], ptr [[G1]], align 4
// CHECK10-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK10-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i32 8, i1 false)
// CHECK10-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK10-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK10-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i32 1
// CHECK10-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK10-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 4
// CHECK10-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32, ptr [[T_VAR]], align 4
// CHECK10-NEXT:    store i32 [[TMP1]], ptr [[T_VAR_CASTED]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32, ptr [[T_VAR_CASTED]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, ptr @_ZZ4mainE4svar, align 4
// CHECK10-NEXT:    store i32 [[TMP4]], ptr [[SVAR_CASTED]], align 4
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, ptr [[SVAR_CASTED]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    store i32 [[TMP2]], ptr [[TMP8]], align 4
// CHECK10-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    store i32 [[TMP2]], ptr [[TMP9]], align 4
// CHECK10-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK10-NEXT:    store ptr null, ptr [[TMP10]], align 4
// CHECK10-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[TMP11]], align 4
// CHECK10-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[TMP12]], align 4
// CHECK10-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK10-NEXT:    store ptr null, ptr [[TMP13]], align 4
// CHECK10-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[TMP14]], align 4
// CHECK10-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[TMP15]], align 4
// CHECK10-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr null, ptr [[TMP16]], align 4
// CHECK10-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr [[TMP6]], ptr [[TMP17]], align 4
// CHECK10-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr [[TMP7]], ptr [[TMP18]], align 4
// CHECK10-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr null, ptr [[TMP19]], align 4
// CHECK10-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 4
// CHECK10-NEXT:    store i32 [[TMP5]], ptr [[TMP20]], align 4
// CHECK10-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 4
// CHECK10-NEXT:    store i32 [[TMP5]], ptr [[TMP21]], align 4
// CHECK10-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 4
// CHECK10-NEXT:    store ptr null, ptr [[TMP22]], align 4
// CHECK10-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK10-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK10-NEXT:    store i32 1, ptr [[TMP25]], align 4
// CHECK10-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK10-NEXT:    store i32 5, ptr [[TMP26]], align 4
// CHECK10-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr [[TMP23]], ptr [[TMP27]], align 4
// CHECK10-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr [[TMP24]], ptr [[TMP28]], align 4
// CHECK10-NEXT:    [[TMP29:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK10-NEXT:    store ptr @.offload_sizes, ptr [[TMP29]], align 4
// CHECK10-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK10-NEXT:    store ptr @.offload_maptypes, ptr [[TMP30]], align 4
// CHECK10-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK10-NEXT:    store ptr null, ptr [[TMP31]], align 4
// CHECK10-NEXT:    [[TMP32:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK10-NEXT:    store ptr null, ptr [[TMP32]], align 4
// CHECK10-NEXT:    [[TMP33:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK10-NEXT:    store i64 2, ptr [[TMP33]], align 8
// CHECK10-NEXT:    [[TMP34:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB3:[0-9]+]], i64 -1, i32 0, i32 1, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l138.region_id, ptr [[KERNEL_ARGS]])
// CHECK10-NEXT:    [[TMP35:%.*]] = icmp ne i32 [[TMP34]], 0
// CHECK10-NEXT:    br i1 [[TMP35]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK10:       omp_offload.failed:
// CHECK10-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l138(i32 [[TMP2]], ptr [[VEC]], ptr [[S_ARR]], ptr [[TMP3]], i32 [[TMP5]]) #[[ATTR4:[0-9]+]]
// CHECK10-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK10:       omp_offload.cont:
// CHECK10-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK10-NEXT:    store i32 [[CALL]], ptr [[RETVAL]], align 4
// CHECK10-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP36:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK10-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK10:       arraydestroy.body:
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP36]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK10-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK10-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK10:       arraydestroy.done2:
// CHECK10-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK10-NEXT:    [[TMP37:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK10-NEXT:    ret i32 [[TMP37]]
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    call void @_ZN1SIfEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    call void @_ZN1SIfEC2Ef(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l138
// CHECK10-SAME: (i32 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store i32 [[T_VAR]], ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store i32 [[SVAR]], ptr [[SVAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 5, ptr @.omp_outlined., ptr [[T_VAR_ADDR]], ptr [[TMP0]], ptr [[TMP1]], ptr [[TMP3]], ptr [[SVAR_ADDR]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_outlined.
// CHECK10-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[T_VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[SVAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[T_VAR3:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC4:%.*]] = alloca [2 x i32], align 4
// CHECK10-NEXT:    [[S_ARR5:%.*]] = alloca [2 x %struct.S], align 4
// CHECK10-NEXT:    [[VAR7:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK10-NEXT:    [[_TMP8:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[SVAR9:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[SVAR_CASTED:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[T_VAR]], ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[SVAR]], ptr [[SVAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SVAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[TMP3]], ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    store ptr [[TMP5]], ptr [[_TMP1]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK10-NEXT:    store i32 [[TMP6]], ptr [[T_VAR3]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC4]], ptr align 4 [[TMP1]], i32 8, i1 false)
// CHECK10-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR5]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP7:%.*]] = getelementptr [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK10-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP7]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE6:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK10:       omp.arraycpy.body:
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 4, i1 false)
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP7]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE6]], label [[OMP_ARRAYCPY_BODY]]
// CHECK10:       omp.arraycpy.done6:
// CHECK10-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP1]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VAR7]], ptr align 4 [[TMP8]], i32 4, i1 false)
// CHECK10-NEXT:    store ptr [[VAR7]], ptr [[_TMP8]], align 4
// CHECK10-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK10-NEXT:    store i32 [[TMP9]], ptr [[SVAR9]], align 4
// CHECK10-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1:[0-9]+]], i32 [[TMP11]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP12]], 1
// CHECK10-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK10:       cond.true:
// CHECK10-NEXT:    br label [[COND_END:%.*]]
// CHECK10:       cond.false:
// CHECK10-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    br label [[COND_END]]
// CHECK10:       cond.end:
// CHECK10-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP13]], [[COND_FALSE]] ]
// CHECK10-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6:![0-9]+]]
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[CMP10:%.*]] = icmp sle i32 [[TMP15]], [[TMP16]]
// CHECK10-NEXT:    br i1 [[CMP10]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK10:       omp.inner.for.cond.cleanup:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[TMP19:%.*]] = load i32, ptr [[T_VAR3]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    store i32 [[TMP19]], ptr [[T_VAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[TMP20:%.*]] = load i32, ptr [[T_VAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[_TMP8]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[TMP22:%.*]] = load i32, ptr [[SVAR9]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    store i32 [[TMP22]], ptr [[SVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[TMP23:%.*]] = load i32, ptr [[SVAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 7, ptr @.omp_outlined..1, i32 [[TMP17]], i32 [[TMP18]], ptr [[VEC4]], i32 [[TMP20]], ptr [[S_ARR5]], ptr [[TMP21]], i32 [[TMP23]]), !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP24]], [[TMP25]]
// CHECK10-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK10:       omp.loop.exit:
// CHECK10-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP27:%.*]] = load i32, ptr [[TMP26]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP27]])
// CHECK10-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP29:%.*]] = icmp ne i32 [[TMP28]], 0
// CHECK10-NEXT:    br i1 [[TMP29]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK10:       .omp.final.then:
// CHECK10-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK10-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK10:       .omp.final.done:
// CHECK10-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR7]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAY_BEGIN11:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR5]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP30:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN11]], i32 2
// CHECK10-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK10:       arraydestroy.body:
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP30]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK10-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN11]]
// CHECK10-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE12:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK10:       arraydestroy.done12:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_outlined..1
// CHECK10-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], i32 noundef [[SVAR:%.*]]) #[[ATTR3]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[SVAR_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC2:%.*]] = alloca [2 x i32], align 4
// CHECK10-NEXT:    [[S_ARR3:%.*]] = alloca [2 x %struct.S], align 4
// CHECK10-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK10-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK10-NEXT:    store i32 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK10-NEXT:    store i32 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    store i32 [[T_VAR]], ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store i32 [[SVAR]], ptr [[SVAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK10-NEXT:    store i32 [[TMP3]], ptr [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC2]], ptr align 4 [[TMP0]], i32 8, i1 false)
// CHECK10-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR3]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP5:%.*]] = getelementptr [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK10-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP5]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK10:       omp.arraycpy.body:
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP1]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 4, i1 false)
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP5]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK10:       omp.arraycpy.done4:
// CHECK10-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VAR5]], ptr align 4 [[TMP6]], i32 4, i1 false)
// CHECK10-NEXT:    store ptr [[VAR5]], ptr [[_TMP6]], align 4
// CHECK10-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2:[0-9]+]], i32 [[TMP8]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK10-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP9]], 1
// CHECK10-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK10:       cond.true:
// CHECK10-NEXT:    br label [[COND_END:%.*]]
// CHECK10:       cond.false:
// CHECK10-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    br label [[COND_END]]
// CHECK10:       cond.end:
// CHECK10-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP10]], [[COND_FALSE]] ]
// CHECK10-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP11]], ptr [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP10:![0-9]+]]
// CHECK10-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP12]], [[TMP13]]
// CHECK10-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK10:       omp.inner.for.cond.cleanup:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP14]], 1
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, ptr [[T_VAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC2]], i32 0, i32 [[TMP16]]
// CHECK10-NEXT:    store i32 [[TMP15]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP6]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[TMP18:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR3]], i32 0, i32 [[TMP18]]
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[ARRAYIDX8]], ptr align 4 [[TMP17]], i32 4, i1 false), !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK10-NEXT:    store i32 [[ADD9]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP10]]
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP11:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK10:       omp.loop.exit:
// CHECK10-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP21]])
// CHECK10-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK10-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK10:       .omp.final.then:
// CHECK10-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK10-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK10:       .omp.final.done:
// CHECK10-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR3]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN10]], i32 2
// CHECK10-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK10:       arraydestroy.body:
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK10-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN10]]
// CHECK10-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE11:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK10:       arraydestroy.done11:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    call void @_ZN1SIfED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK10-SAME: () #[[ATTR5:[0-9]+]] comdat {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK10-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK10-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK10-NEXT:    [[VAR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOFFLOAD_BASEPTRS:%.*]] = alloca [4 x ptr], align 4
// CHECK10-NEXT:    [[DOTOFFLOAD_PTRS:%.*]] = alloca [4 x ptr], align 4
// CHECK10-NEXT:    [[DOTOFFLOAD_MAPPERS:%.*]] = alloca [4 x ptr], align 4
// CHECK10-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK10-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i32 8, i1 false)
// CHECK10-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK10-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK10-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i32 1
// CHECK10-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK10-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 4
// CHECK10-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load i32, ptr [[T_VAR]], align 4
// CHECK10-NEXT:    store i32 [[TMP1]], ptr [[T_VAR_CASTED]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load i32, ptr [[T_VAR_CASTED]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    store i32 [[TMP2]], ptr [[TMP6]], align 4
// CHECK10-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    store i32 [[TMP2]], ptr [[TMP7]], align 4
// CHECK10-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 0
// CHECK10-NEXT:    store ptr null, ptr [[TMP8]], align 4
// CHECK10-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 1
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[TMP9]], align 4
// CHECK10-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 1
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[TMP10]], align 4
// CHECK10-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 1
// CHECK10-NEXT:    store ptr null, ptr [[TMP11]], align 4
// CHECK10-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[TMP12]], align 4
// CHECK10-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[TMP13]], align 4
// CHECK10-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr null, ptr [[TMP14]], align 4
// CHECK10-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr [[TMP4]], ptr [[TMP15]], align 4
// CHECK10-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr [[TMP5]], ptr [[TMP16]], align 4
// CHECK10-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_MAPPERS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr null, ptr [[TMP17]], align 4
// CHECK10-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_BASEPTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOFFLOAD_PTRS]], i32 0, i32 0
// CHECK10-NEXT:    [[KERNEL_ARGS:%.*]] = alloca [[STRUCT___TGT_KERNEL_ARGUMENTS:%.*]], align 8
// CHECK10-NEXT:    [[TMP20:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 0
// CHECK10-NEXT:    store i32 1, ptr [[TMP20]], align 4
// CHECK10-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 1
// CHECK10-NEXT:    store i32 4, ptr [[TMP21]], align 4
// CHECK10-NEXT:    [[TMP22:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 2
// CHECK10-NEXT:    store ptr [[TMP18]], ptr [[TMP22]], align 4
// CHECK10-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 3
// CHECK10-NEXT:    store ptr [[TMP19]], ptr [[TMP23]], align 4
// CHECK10-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 4
// CHECK10-NEXT:    store ptr @.offload_sizes.4, ptr [[TMP24]], align 4
// CHECK10-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 5
// CHECK10-NEXT:    store ptr @.offload_maptypes.5, ptr [[TMP25]], align 4
// CHECK10-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 6
// CHECK10-NEXT:    store ptr null, ptr [[TMP26]], align 4
// CHECK10-NEXT:    [[TMP27:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 7
// CHECK10-NEXT:    store ptr null, ptr [[TMP27]], align 4
// CHECK10-NEXT:    [[TMP28:%.*]] = getelementptr inbounds [[STRUCT___TGT_KERNEL_ARGUMENTS]], ptr [[KERNEL_ARGS]], i32 0, i32 8
// CHECK10-NEXT:    store i64 2, ptr [[TMP28]], align 8
// CHECK10-NEXT:    [[TMP29:%.*]] = call i32 @__tgt_target_kernel(ptr @[[GLOB3]], i64 -1, i32 0, i32 1, ptr @.{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l48.region_id, ptr [[KERNEL_ARGS]])
// CHECK10-NEXT:    [[TMP30:%.*]] = icmp ne i32 [[TMP29]], 0
// CHECK10-NEXT:    br i1 [[TMP30]], label [[OMP_OFFLOAD_FAILED:%.*]], label [[OMP_OFFLOAD_CONT:%.*]]
// CHECK10:       omp_offload.failed:
// CHECK10-NEXT:    call void @{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l48(i32 [[TMP2]], ptr [[VEC]], ptr [[S_ARR]], ptr [[TMP3]]) #[[ATTR4]]
// CHECK10-NEXT:    br label [[OMP_OFFLOAD_CONT]]
// CHECK10:       omp_offload.cont:
// CHECK10-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK10-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP31:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK10-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK10:       arraydestroy.body:
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP31]], [[OMP_OFFLOAD_CONT]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK10-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK10-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK10:       arraydestroy.done2:
// CHECK10-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK10-NEXT:    [[TMP32:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK10-NEXT:    ret i32 [[TMP32]]
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK10-NEXT:    store float 0.000000e+00, ptr [[F]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    store float [[TMP0]], ptr [[F]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z5tmainIiET_v_l48
// CHECK10-SAME: (i32 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store i32 [[T_VAR]], ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_teams(ptr @[[GLOB3]], i32 4, ptr @.omp_outlined..2, ptr [[T_VAR_ADDR]], ptr [[TMP0]], ptr [[TMP1]], ptr [[TMP3]])
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_outlined..2
// CHECK10-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[T_VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[_TMP2:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_COMB_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_COMB_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[T_VAR3:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC4:%.*]] = alloca [2 x i32], align 4
// CHECK10-NEXT:    [[S_ARR5:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK10-NEXT:    [[VAR7:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK10-NEXT:    [[_TMP8:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[T_VAR_CASTED:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[T_VAR]], ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[TMP3]], ptr [[TMP]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    store ptr [[TMP4]], ptr [[_TMP1]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP5:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK10-NEXT:    store i32 [[TMP5]], ptr [[T_VAR3]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC4]], ptr align 4 [[TMP1]], i32 8, i1 false)
// CHECK10-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR5]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP6:%.*]] = getelementptr [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK10-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP6]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE6:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK10:       omp.arraycpy.body:
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 4, i1 false)
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP6]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE6]], label [[OMP_ARRAYCPY_BODY]]
// CHECK10:       omp.arraycpy.done6:
// CHECK10-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP1]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VAR7]], ptr align 4 [[TMP7]], i32 4, i1 false)
// CHECK10-NEXT:    store ptr [[VAR7]], ptr [[_TMP8]], align 4
// CHECK10-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP8]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB1]], i32 [[TMP9]], i32 92, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_COMB_LB]], ptr [[DOTOMP_COMB_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK10-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP10]], 1
// CHECK10-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK10:       cond.true:
// CHECK10-NEXT:    br label [[COND_END:%.*]]
// CHECK10:       cond.false:
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    br label [[COND_END]]
// CHECK10:       cond.end:
// CHECK10-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP11]], [[COND_FALSE]] ]
// CHECK10-NEXT:    store i32 [[COND]], ptr [[DOTOMP_COMB_UB]], align 4
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP15:![0-9]+]]
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    [[CMP9:%.*]] = icmp sle i32 [[TMP13]], [[TMP14]]
// CHECK10-NEXT:    br i1 [[CMP9]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK10:       omp.inner.for.cond.cleanup:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_COMB_LB]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_COMB_UB]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    [[TMP17:%.*]] = load i32, ptr [[T_VAR3]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    store i32 [[TMP17]], ptr [[T_VAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    [[TMP18:%.*]] = load i32, ptr [[T_VAR_CASTED]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[_TMP8]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB3]], i32 6, ptr @.omp_outlined..3, i32 [[TMP15]], i32 [[TMP16]], ptr [[VEC4]], i32 [[TMP18]], ptr [[S_ARR5]], ptr [[TMP19]]), !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP20:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_STRIDE]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK10-NEXT:    store i32 [[ADD]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP15]]
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK10:       omp.loop.exit:
// CHECK10-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP22]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP23]])
// CHECK10-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP25:%.*]] = icmp ne i32 [[TMP24]], 0
// CHECK10-NEXT:    br i1 [[TMP25]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK10:       .omp.final.then:
// CHECK10-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK10-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK10:       .omp.final.done:
// CHECK10-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR7]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR5]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP26:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN10]], i32 2
// CHECK10-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK10:       arraydestroy.body:
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP26]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK10-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN10]]
// CHECK10-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE11:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK10:       arraydestroy.done11:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_outlined..3
// CHECK10-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], i32 noundef [[DOTPREVIOUS_LB_:%.*]], i32 noundef [[DOTPREVIOUS_UB_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], i32 noundef [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]]) #[[ATTR3]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTPREVIOUS_LB__ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTPREVIOUS_UB__ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[T_VAR_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[_TMP1:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_STRIDE:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[DOTOMP_IS_LAST:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    [[VEC2:%.*]] = alloca [2 x i32], align 4
// CHECK10-NEXT:    [[S_ARR3:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK10-NEXT:    [[VAR5:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK10-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 4
// CHECK10-NEXT:    store i32 [[DOTPREVIOUS_LB_]], ptr [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK10-NEXT:    store i32 [[DOTPREVIOUS_UB_]], ptr [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    store i32 [[T_VAR]], ptr [[T_VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 4
// CHECK10-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 4
// CHECK10-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[VAR_ADDR]], align 4
// CHECK10-NEXT:    store ptr [[TMP2]], ptr [[TMP]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP3:%.*]] = load i32, ptr [[DOTPREVIOUS_LB__ADDR]], align 4
// CHECK10-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTPREVIOUS_UB__ADDR]], align 4
// CHECK10-NEXT:    store i32 [[TMP3]], ptr [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    store i32 1, ptr [[DOTOMP_STRIDE]], align 4
// CHECK10-NEXT:    store i32 0, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC2]], ptr align 4 [[TMP0]], i32 8, i1 false)
// CHECK10-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR3]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP5:%.*]] = getelementptr [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK10-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[TMP5]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK10:       omp.arraycpy.body:
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP1]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr align 4 [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 4, i1 false)
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[STRUCT_S_0]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK10-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP5]]
// CHECK10-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK10:       omp.arraycpy.done4:
// CHECK10-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VAR5]], ptr align 4 [[TMP6]], i32 4, i1 false)
// CHECK10-NEXT:    store ptr [[VAR5]], ptr [[_TMP6]], align 4
// CHECK10-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_init_4(ptr @[[GLOB2]], i32 [[TMP8]], i32 34, ptr [[DOTOMP_IS_LAST]], ptr [[DOTOMP_LB]], ptr [[DOTOMP_UB]], ptr [[DOTOMP_STRIDE]], i32 1, i32 1)
// CHECK10-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[TMP9]], 1
// CHECK10-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK10:       cond.true:
// CHECK10-NEXT:    br label [[COND_END:%.*]]
// CHECK10:       cond.false:
// CHECK10-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    br label [[COND_END]]
// CHECK10:       cond.end:
// CHECK10-NEXT:    [[COND:%.*]] = phi i32 [ 1, [[COND_TRUE]] ], [ [[TMP10]], [[COND_FALSE]] ]
// CHECK10-NEXT:    store i32 [[COND]], ptr [[DOTOMP_UB]], align 4
// CHECK10-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK10-NEXT:    store i32 [[TMP11]], ptr [[DOTOMP_IV]], align 4
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK10:       omp.inner.for.cond:
// CHECK10-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP18:![0-9]+]]
// CHECK10-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[CMP7:%.*]] = icmp sle i32 [[TMP12]], [[TMP13]]
// CHECK10-NEXT:    br i1 [[CMP7]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_COND_CLEANUP:%.*]]
// CHECK10:       omp.inner.for.cond.cleanup:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_END:%.*]]
// CHECK10:       omp.inner.for.body:
// CHECK10-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP14]], 1
// CHECK10-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK10-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[TMP15:%.*]] = load i32, ptr [[T_VAR_ADDR]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[TMP16:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC2]], i32 0, i32 [[TMP16]]
// CHECK10-NEXT:    store i32 [[TMP15]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP6]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[TMP18:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR3]], i32 0, i32 [[TMP18]]
// CHECK10-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[ARRAYIDX8]], ptr align 4 [[TMP17]], i32 4, i1 false), !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK10:       omp.body.continue:
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK10:       omp.inner.for.inc:
// CHECK10-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], 1
// CHECK10-NEXT:    store i32 [[ADD9]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP18]]
// CHECK10-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP19:![0-9]+]]
// CHECK10:       omp.inner.for.end:
// CHECK10-NEXT:    br label [[OMP_LOOP_EXIT:%.*]]
// CHECK10:       omp.loop.exit:
// CHECK10-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 4
// CHECK10-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK10-NEXT:    call void @__kmpc_for_static_fini(ptr @[[GLOB1]], i32 [[TMP21]])
// CHECK10-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IS_LAST]], align 4
// CHECK10-NEXT:    [[TMP23:%.*]] = icmp ne i32 [[TMP22]], 0
// CHECK10-NEXT:    br i1 [[TMP23]], label [[DOTOMP_FINAL_THEN:%.*]], label [[DOTOMP_FINAL_DONE:%.*]]
// CHECK10:       .omp.final.then:
// CHECK10-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK10-NEXT:    br label [[DOTOMP_FINAL_DONE]]
// CHECK10:       .omp.final.done:
// CHECK10-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR5]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAY_BEGIN10:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR3]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP24:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN10]], i32 2
// CHECK10-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK10:       arraydestroy.body:
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[DOTOMP_FINAL_DONE]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK10-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK10-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK10-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN10]]
// CHECK10-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE11:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK10:       arraydestroy.done11:
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK10-NEXT:    store i32 0, ptr [[F]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK10-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK10-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK10-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK10-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK10-NEXT:    ret void
//
//
// CHECK10-LABEL: define {{[^@]+}}@.omp_offloading.requires_reg
// CHECK10-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK10-NEXT:  entry:
// CHECK10-NEXT:    call void @__tgt_register_requires(i64 1)
// CHECK10-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@main
// CHECK12-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK12-NEXT:    [[G1:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK12-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK12-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK12-NEXT:    [[VAR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK12-NEXT:    store ptr [[G]], ptr [[G1]], align 8
// CHECK12-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK12-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK12-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i64 8, i1 false)
// CHECK12-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// CHECK12-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK12-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK12-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK12-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 8
// CHECK12-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 8
// CHECK12-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 8
// CHECK12-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VAR]], align 8
// CHECK12-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK12-NEXT:    store ptr [[TMP2]], ptr [[_TMP1]], align 8
// CHECK12-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK12-NEXT:    store ptr [[TMP3]], ptr [[_TMP2]], align 8
// CHECK12-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2:![0-9]+]]
// CHECK12-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32, ptr [[T_VAR]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[TMP9:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i64 0, i64 [[IDXPROM]]
// CHECK12-NEXT:    store i32 [[TMP8]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP2]], align 8, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP11]] to i64
// CHECK12-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 [[IDXPROM4]]
// CHECK12-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX5]], ptr align 4 [[TMP10]], i64 4, i1 false), !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK12-NEXT:    store i32 [[ADD6]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP2]]
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP3:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK12-NEXT:    [[CALL:%.*]] = call noundef signext i32 @_Z5tmainIiET_v()
// CHECK12-NEXT:    store i32 [[CALL]], ptr [[RETVAL]], align 4
// CHECK12-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK12-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK12:       arraydestroy.body:
// CHECK12-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP13]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK12-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK12-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4:[0-9]+]]
// CHECK12-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK12-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE7:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK12:       arraydestroy.done7:
// CHECK12-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK12-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK12-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    call void @_ZN1SIfEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    call void @_ZN1SIfEC2Ef(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK12-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK12-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK12-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK12-NEXT:    [[VAR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK12-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK12-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i64 8, i1 false)
// CHECK12-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// CHECK12-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef signext 1)
// CHECK12-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK12-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef signext 2)
// CHECK12-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 8
// CHECK12-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 8
// CHECK12-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 8
// CHECK12-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VAR]], align 8
// CHECK12-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK12-NEXT:    store ptr [[TMP2]], ptr [[_TMP1]], align 8
// CHECK12-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK12-NEXT:    store ptr [[TMP3]], ptr [[_TMP2]], align 8
// CHECK12-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK12-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK12-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_IV]], align 4
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK12:       omp.inner.for.cond:
// CHECK12-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6:![0-9]+]]
// CHECK12-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK12-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK12:       omp.inner.for.body:
// CHECK12-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK12-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK12-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[TMP8:%.*]] = load i32, ptr [[T_VAR]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[TMP9:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP9]] to i64
// CHECK12-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i64 0, i64 [[IDXPROM]]
// CHECK12-NEXT:    store i32 [[TMP8]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP2]], align 8, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[IDXPROM4:%.*]] = sext i32 [[TMP11]] to i64
// CHECK12-NEXT:    [[ARRAYIDX5:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 [[IDXPROM4]]
// CHECK12-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX5]], ptr align 4 [[TMP10]], i64 4, i1 false), !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK12:       omp.body.continue:
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK12:       omp.inner.for.inc:
// CHECK12-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    [[ADD6:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK12-NEXT:    store i32 [[ADD6]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP6]]
// CHECK12-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP7:![0-9]+]]
// CHECK12:       omp.inner.for.end:
// CHECK12-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK12-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK12-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK12-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK12:       arraydestroy.body:
// CHECK12-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP13]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK12-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK12-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK12-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK12-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE7:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK12:       arraydestroy.done7:
// CHECK12-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK12-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK12-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    call void @_ZN1SIfED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK12-NEXT:    store float 0.000000e+00, ptr [[F]], align 4
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    store float [[TMP0]], ptr [[F]], align 4
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef signext [[TMP0]])
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK12-NEXT:    store i32 0, ptr [[F]], align 4
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef signext [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK12-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK12-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// CHECK12-NEXT:    ret void
//
//
// CHECK12-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK12-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK12-NEXT:  entry:
// CHECK12-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK12-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK12-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@main
// CHECK14-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[G:%.*]] = alloca double, align 8
// CHECK14-NEXT:    [[G1:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK14-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK14-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK14-NEXT:    [[VAR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK14-NEXT:    store ptr [[G]], ptr [[G1]], align 4
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK14-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK14-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i32 8, i1 false)
// CHECK14-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK14-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i32 1
// CHECK14-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK14-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 4
// CHECK14-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 4
// CHECK14-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VAR]], align 4
// CHECK14-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK14-NEXT:    store ptr [[TMP2]], ptr [[_TMP1]], align 4
// CHECK14-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[_TMP1]], align 4
// CHECK14-NEXT:    store ptr [[TMP3]], ptr [[_TMP2]], align 4
// CHECK14-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP3:![0-9]+]]
// CHECK14-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, ptr [[T_VAR]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i32 0, i32 [[TMP9]]
// CHECK14-NEXT:    store i32 [[TMP8]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP2]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 [[TMP11]]
// CHECK14-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[ARRAYIDX4]], ptr align 4 [[TMP10]], i32 4, i1 false), !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK14-NEXT:    store i32 [[ADD5]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP3]]
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP4:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK14-NEXT:    [[CALL:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK14-NEXT:    store i32 [[CALL]], ptr [[RETVAL]], align 4
// CHECK14-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK14-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK14:       arraydestroy.body:
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP13]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK14-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4:[0-9]+]]
// CHECK14-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK14-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE6:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK14:       arraydestroy.done6:
// CHECK14-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK14-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK14-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIfEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIfEC2Ef(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK14-SAME: () #[[ATTR3:[0-9]+]] comdat {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK14-NEXT:    [[T_VAR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK14-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK14-NEXT:    [[VAR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[TMP:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    [[I:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK14-NEXT:    store i32 0, ptr [[T_VAR]], align 4
// CHECK14-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i32 8, i1 false)
// CHECK14-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK14-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i32 1
// CHECK14-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK14-NEXT:    store ptr [[TEST]], ptr [[VAR]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VAR]], align 4
// CHECK14-NEXT:    store ptr [[TMP0]], ptr [[TMP]], align 4
// CHECK14-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[VAR]], align 4
// CHECK14-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP]], align 4
// CHECK14-NEXT:    store ptr [[TMP2]], ptr [[_TMP1]], align 4
// CHECK14-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[_TMP1]], align 4
// CHECK14-NEXT:    store ptr [[TMP3]], ptr [[_TMP2]], align 4
// CHECK14-NEXT:    store i32 0, ptr [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 1, ptr [[DOTOMP_UB]], align 4
// CHECK14-NEXT:    [[TMP4:%.*]] = load i32, ptr [[DOTOMP_LB]], align 4
// CHECK14-NEXT:    store i32 [[TMP4]], ptr [[DOTOMP_IV]], align 4
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND:%.*]]
// CHECK14:       omp.inner.for.cond:
// CHECK14-NEXT:    [[TMP5:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP7:![0-9]+]]
// CHECK14-NEXT:    [[TMP6:%.*]] = load i32, ptr [[DOTOMP_UB]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP5]], [[TMP6]]
// CHECK14-NEXT:    br i1 [[CMP]], label [[OMP_INNER_FOR_BODY:%.*]], label [[OMP_INNER_FOR_END:%.*]]
// CHECK14:       omp.inner.for.body:
// CHECK14-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP7]], 1
// CHECK14-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK14-NEXT:    store i32 [[ADD]], ptr [[I]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[TMP8:%.*]] = load i32, ptr [[T_VAR]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[TMP9:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[VEC]], i32 0, i32 [[TMP9]]
// CHECK14-NEXT:    store i32 [[TMP8]], ptr [[ARRAYIDX]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP2]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[TMP11:%.*]] = load i32, ptr [[I]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[ARRAYIDX4:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 [[TMP11]]
// CHECK14-NEXT:    call void @llvm.memcpy.p0.p0.i32(ptr align 4 [[ARRAYIDX4]], ptr align 4 [[TMP10]], i32 4, i1 false), !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK14:       omp.body.continue:
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_INC:%.*]]
// CHECK14:       omp.inner.for.inc:
// CHECK14-NEXT:    [[TMP12:%.*]] = load i32, ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    [[ADD5:%.*]] = add nsw i32 [[TMP12]], 1
// CHECK14-NEXT:    store i32 [[ADD5]], ptr [[DOTOMP_IV]], align 4, !llvm.access.group [[ACC_GRP7]]
// CHECK14-NEXT:    br label [[OMP_INNER_FOR_COND]], !llvm.loop [[LOOP8:![0-9]+]]
// CHECK14:       omp.inner.for.end:
// CHECK14-NEXT:    store i32 2, ptr [[I]], align 4
// CHECK14-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK14-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i32 2
// CHECK14-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK14:       arraydestroy.body:
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP13]], [[OMP_INNER_FOR_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK14-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i32 -1
// CHECK14-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR4]]
// CHECK14-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK14-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE6:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK14:       arraydestroy.done6:
// CHECK14-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR4]]
// CHECK14-NEXT:    [[TMP14:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK14-NEXT:    ret i32 [[TMP14]]
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIfED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    store float 0.000000e+00, ptr [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    store float [[TMP0]], ptr [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR4]]
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    store i32 0, ptr [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK14-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK14-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// CHECK14-NEXT:    ret void
//
//
// CHECK14-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK14-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK14-NEXT:  entry:
// CHECK14-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 4
// CHECK14-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 4
// CHECK14-NEXT:    ret void
//
