// This testcase checks emission of DIFlagArtificial flag for outlined
// subroutines generated by compiler.

// REQUIRES: x86_64-linux

// RUN: %clang_cc1 -debug-info-kind=constructor -x c -verify -triple x86_64-pc-linux-gnu -fopenmp -emit-llvm %s -o - | FileCheck %s
// expected-no-diagnostics

#if defined(_WIN32)
#define __KAI_KMPC_CONVENTION __cdecl
#else
#define __KAI_KMPC_CONVENTION
#endif

extern int printf(const char *, ...);
extern void __KAI_KMPC_CONVENTION omp_set_num_threads(int);
extern int __KAI_KMPC_CONVENTION omp_get_thread_num(void);

#define N 10

float f[10];
void foo_simd(int low, int up) {
  for (int i = low; i < up; ++i) {
    f[i] = 0.0;
#pragma omp ordered simd
    f[i] = 1.0;
  }
}

int main() {
  int arr[10];
  int i;
  omp_set_num_threads(2);
#pragma omp parallel
#pragma omp single
#pragma omp taskloop num_tasks(10)
  for (i = 0; i < N; i++) {
    arr[i] = i * i;
  }

  for (int j = 0; j < N; j++) {
    printf("%d\n", arr[j]);
  }
  return 0;
}

// foo_simd is not artificial.
// CHECK-DAG: !DISubprogram(name: "foo_simd"
// CHECK-DAG-SAME: flags: DIFlagPrototyped,

// CHECK-DAG: !DISubprogram(name: "__captured_stmt_debug__"
// CHECK-DAG-SAME: flags: DIFlagArtificial

// CHECK-DAG: !DISubprogram(name: "__captured_stmt"
// CHECK-DAG-SAME: flags: DIFlagArtificial

// CHECK-DAG: !DISubprogram(name: ".omp_outlined._debug__"
// CHECK-DAG-SAME: flags: DIFlagArtificial

// CHECK-DAG: !DISubprogram(linkageName: ".omp_task_entry."
// CHECK-DAG-SAME: flags: DIFlagArtificial

// CHECK-DAG: !DISubprogram(name: ".omp_outlined."
// CHECK-DAG-SAME: flags: DIFlagArtificial

// CHECK-DAG: !DISubprogram(name: ".omp_outlined..1"
// CHECK-DAG-SAME: flags: DIFlagArtificial
