/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.io.Serializable;

@BugPattern(name="BanSerializableRead", summary="Deserializing user input via the `Serializable` API is extremely dangerous", severity=BugPattern.SeverityLevel.ERROR)
public final class BanSerializableRead
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> BANNED_OBJECT_INPUT_STREAM_METHODS = ImmutableSet.of((Object)"readObject", (Object)"defaultReadObject", (Object)"readObjectOverride", (Object)"readClassDescriptor", (Object)"resolveClass", (Object)"resolveObject", (Object[])new String[0]);
    private static final Matcher<ExpressionTree> EXEMPT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"java.io.Serializable")), Matchers.enclosingMethod((Matcher)Matchers.methodIsNamed((String)"readObject"))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingClass((Matcher)Matchers.isSubtypeOf((String)"java.io.ObjectInputStream")), Matchers.enclosingMethod((Matcher & Serializable)(methodTree, state) -> BANNED_OBJECT_INPUT_STREAM_METHODS.contains((Object)methodTree.getName().toString()))})});
    private static final Matcher<ExpressionTree> OBJECT_INPUT_STREAM_DESERIALIZE_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.io.ObjectInputStream").namedAnyOf(BANNED_OBJECT_INPUT_STREAM_METHODS), Matchers.instanceMethod().onDescendantOf("java.io.Serializable").named("readObject")}), Matchers.not(EXEMPT)});
    private static final Matcher<ExpressionTree> MATCHER = OBJECT_INPUT_STREAM_DESERIALIZE_MATCHER;

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget() || !MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        return description.build();
    }
}

