/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByBinder;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByExpression;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.util.Objects;
import javax.lang.model.element.ElementKind;

public class GuardedBySymbolResolver
implements GuardedByBinder.Resolver {
    private final Symbol.ClassSymbol enclosingClass;
    private final Tree decl;
    private final JCTree.JCCompilationUnit compilationUnit;
    private final Context context;
    private final VisitorState visitorState;
    private final Types types;

    public static GuardedBySymbolResolver from(Tree tree, VisitorState visitorState) {
        return GuardedBySymbolResolver.from(ASTHelpers.getSymbol((Tree)tree).owner.enclClass(), visitorState.getPath().getCompilationUnit(), visitorState.context, tree, visitorState);
    }

    public static GuardedBySymbolResolver from(Symbol.ClassSymbol owner, CompilationUnitTree compilationUnit, Context context, Tree leaf, VisitorState visitorState) {
        return new GuardedBySymbolResolver(owner, compilationUnit, context, leaf, visitorState);
    }

    private GuardedBySymbolResolver(Symbol.ClassSymbol enclosingClass, CompilationUnitTree compilationUnit, Context context, Tree leaf, VisitorState visitorState) {
        this.compilationUnit = (JCTree.JCCompilationUnit)compilationUnit;
        this.enclosingClass = Objects.requireNonNull(enclosingClass);
        this.context = context;
        this.types = visitorState.getTypes();
        this.decl = leaf;
        this.visitorState = visitorState;
    }

    public Context context() {
        return this.context;
    }

    public VisitorState visitorState() {
        return this.visitorState;
    }

    public Symbol.ClassSymbol enclosingClass() {
        return this.enclosingClass;
    }

    @Override
    public Symbol resolveIdentifier(IdentifierTree node) {
        String name = node.getName().toString();
        if (name.equals("this")) {
            return this.enclosingClass;
        }
        if (name.equals("itself")) {
            Symbol sym = ASTHelpers.getSymbol((Tree)this.decl);
            if (sym == null) {
                throw new IllegalGuardedBy(this.decl.getClass().toString());
            }
            return sym;
        }
        Symbol.VarSymbol field = this.getField(this.enclosingClass, name);
        if (field != null) {
            return field;
        }
        Symbol type = this.resolveType(name, SearchSuperTypes.YES);
        if (type != null) {
            return type;
        }
        throw new IllegalGuardedBy(name);
    }

    @Override
    public Symbol.MethodSymbol resolveMethod(MethodInvocationTree node, javax.lang.model.element.Name name) {
        return this.getMethod(this.enclosingClass, name.toString());
    }

    @Override
    public Symbol.MethodSymbol resolveMethod(MethodInvocationTree node, GuardedByExpression base, javax.lang.model.element.Name identifier) {
        Symbol.TypeSymbol baseSym = base.kind() == GuardedByExpression.Kind.THIS ? this.enclosingClass : base.type().asElement();
        return this.getMethod(baseSym, identifier.toString());
    }

    private Symbol.MethodSymbol getMethod(Symbol classSymbol, String name) {
        return this.getMember(Symbol.MethodSymbol.class, ElementKind.METHOD, classSymbol, name);
    }

    @Override
    public Symbol resolveSelect(GuardedByExpression base, MemberSelectTree node) {
        Symbol.TypeSymbol baseSym = base.kind() == GuardedByExpression.Kind.THIS ? this.enclosingClass : base.type().asElement();
        return this.getField(baseSym, node.getIdentifier().toString());
    }

    private Symbol.VarSymbol getField(Symbol classSymbol, String name) {
        return this.getMember(Symbol.VarSymbol.class, ElementKind.FIELD, classSymbol, name);
    }

    private <T extends Symbol> T getMember(Class<T> type, ElementKind kind, Symbol classSymbol, String name) {
        T sym;
        if (classSymbol.type == null) {
            return null;
        }
        for (Type t : this.types.closure(classSymbol.type)) {
            Scope.WriteableScope scope = t.tsym.members();
            for (Symbol sym2 : scope.getSymbolsByName(this.visitorState.getName(name))) {
                if (!sym2.getKind().equals((Object)kind)) continue;
                return (T)((Symbol)type.cast(sym2));
            }
        }
        if (classSymbol.hasOuterInstance() && (sym = this.getMember(type, kind, classSymbol.type.getEnclosingType().asElement(), name)) != null) {
            return sym;
        }
        if (classSymbol.owner != null && classSymbol != classSymbol.owner && classSymbol.owner instanceof Symbol.ClassSymbol && (sym = this.getMember(type, kind, classSymbol.owner, name)) != null && ((Symbol)sym).isStatic()) {
            return sym;
        }
        return null;
    }

    @Override
    public Symbol resolveTypeLiteral(ExpressionTree expr) {
        IllegalGuardedBy.checkGuardedBy(expr instanceof IdentifierTree, "bad type literal: %s", expr);
        IdentifierTree ident = (IdentifierTree)expr;
        Symbol type = this.resolveType(ident.getName().toString(), SearchSuperTypes.YES);
        if (type instanceof Symbol.ClassSymbol) {
            return type;
        }
        return null;
    }

    private Symbol resolveType(String name, SearchSuperTypes searchSuperTypes) {
        Symbol type = null;
        if (searchSuperTypes == SearchSuperTypes.YES) {
            type = this.getSuperType(this.enclosingClass, name);
        }
        if (this.enclosingClass.getSimpleName().contentEquals(name)) {
            type = this.enclosingClass;
        }
        if (type == null) {
            type = GuardedBySymbolResolver.getLexicallyEnclosing(this.enclosingClass, name);
        }
        if (type == null) {
            type = this.attribIdent(name);
        }
        IllegalGuardedBy.checkGuardedBy(!(type instanceof Symbol.PackageSymbol), "All we could find for '%s' was a package symbol.", name);
        return type;
    }

    private Symbol getSuperType(Symbol symbol, String name) {
        for (Type t : this.types.closure(symbol.type)) {
            if (!((Name)t.asElement().getSimpleName()).contentEquals(name)) continue;
            return t.asElement();
        }
        return null;
    }

    private static Symbol getLexicallyEnclosing(Symbol.ClassSymbol symbol, String name) {
        Symbol current = symbol.owner;
        while (true) {
            if (current == null || current.getSimpleName().contentEquals(name)) {
                return current;
            }
            if (current == current.owner || !(current.owner instanceof Symbol.ClassSymbol)) break;
            current = current.owner;
        }
        return null;
    }

    private Symbol attribIdent(String name) {
        Attr attr = Attr.instance(this.context);
        TreeMaker tm = this.visitorState.getTreeMaker();
        return attr.attribIdent((JCTree)tm.Ident(this.visitorState.getName(name)), this.compilationUnit);
    }

    @Override
    public Symbol resolveEnclosingClass(ExpressionTree expr) {
        IllegalGuardedBy.checkGuardedBy(expr instanceof IdentifierTree, "bad type literal: %s", expr);
        IdentifierTree ident = (IdentifierTree)expr;
        Symbol type = this.resolveType(ident.getName().toString(), SearchSuperTypes.NO);
        if (type instanceof Symbol.ClassSymbol) {
            return type;
        }
        return null;
    }

    private static enum SearchSuperTypes {
        YES,
        NO;

    }
}

