/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.strings;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.CodecRegisterer;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.strings.UnsafeJdk9StringCodec;
import com.google.devtools.build.lib.unsafe.StringUnsafe;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;

@VisibleForTesting
public final class StringCodec
implements ObjectCodec<String> {
    @VisibleForTesting
    public static ObjectCodec<String> getBestAvailable() {
        return StringUnsafe.canUse() ? new UnsafeJdk9StringCodec(StringUnsafe.getInstance()) : new StringCodec();
    }

    @Override
    public Class<String> getEncodedClass() {
        return String.class;
    }

    @Override
    public boolean autoRegister() {
        return false;
    }

    @Override
    public ObjectCodec.MemoizationStrategy getStrategy() {
        return ObjectCodec.MemoizationStrategy.DO_NOT_MEMOIZE;
    }

    @Override
    public void serialize(SerializationContext context, String str, CodedOutputStream codedOut) throws IOException {
        codedOut.writeStringNoTag(str);
    }

    @Override
    public String deserialize(DeserializationContext context, CodedInputStream codedIn) throws IOException {
        return codedIn.readString();
    }

    private static final class StringCodecRegisterer
    implements CodecRegisterer {
        private StringCodecRegisterer() {
        }

        @Override
        public ImmutableList<ObjectCodec<?>> getCodecsToRegister() {
            return ImmutableList.of(StringCodec.getBestAvailable());
        }
    }
}

