/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.qual.Pure;
import org.checkerframework.shaded.dataflow.qual.SideEffectFree;

public class Pair<V1, V2> {
    public final V1 first;
    public final V2 second;
    private int hashCode = -1;

    private Pair(V1 v1, V2 v2) {
        this.first = v1;
        this.second = v2;
    }

    public static <V1, V2> Pair<V1, V2> of(V1 v1, V2 v2) {
        return new Pair<V1, V2>(v1, v2);
    }

    @SideEffectFree
    public String toString() {
        return "Pair(" + this.first + ", " + this.second + ")";
    }

    @Pure
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = Objects.hash(this.first, this.second);
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }
}

