/**
 * Copyright (c) 2007, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package sun.launcher.resources;

import java.util.ListResourceBundle;

public final class launcher_ja extends ListResourceBundle {
    protected final Object[][] getContents() {
        return new Object[][] {
            { "java.launcher.X.macosx.usage", "\n\u6B21\u306E\u30AA\u30D7\u30B7\u30E7\u30F3\u306FMac OS X\u56FA\u6709\u3067\u3059:\n    -XstartOnFirstThread\n                      main()\u30E1\u30BD\u30C3\u30C9\u3092\u6700\u521D(AppKit)\u306E\u30B9\u30EC\u30C3\u30C9\u3067\u5B9F\u884C\u3059\u308B\n    -Xdock:name=<application name>\n                      Dock\u306B\u8868\u793A\u3055\u308C\u308B\u30C7\u30D5\u30A9\u30EB\u30C8\u30FB\u30A2\u30D7\u30EA\u30B1\u30FC\u30B7\u30E7\u30F3\u540D\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3059\u308B\n    -Xdock:icon=<path to icon file>\n                      Dock\u306B\u8868\u793A\u3055\u308C\u308B\u30C7\u30D5\u30A9\u30EB\u30C8\u30FB\u30A2\u30A4\u30B3\u30F3\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u3059\u308B\n\n" },
            { "java.launcher.X.usage", "\n    -Xbatch           \u30D0\u30C3\u30AF\u30B0\u30E9\u30A6\u30F3\u30C9\u306E\u30B3\u30F3\u30D1\u30A4\u30EB\u3092\u7121\u52B9\u306B\u3059\u308B\n    -Xbootclasspath/a:<{0}\u3067\u533A\u5207\u3089\u308C\u305F\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u304A\u3088\u3073zip/jar\u30D5\u30A1\u30A4\u30EB>\n                      \u30D6\u30FC\u30C8\u30B9\u30C8\u30E9\u30C3\u30D7\u30FB\u30AF\u30E9\u30B9\u30FB\u30D1\u30B9\u306E\u6700\u5F8C\u306B\u8FFD\u52A0\u3059\u308B\n    -Xcheck:jni       JNI\u95A2\u6570\u306B\u5BFE\u3059\u308B\u8FFD\u52A0\u306E\u30C1\u30A7\u30C3\u30AF\u3092\u5B9F\u884C\u3059\u308B\n    -Xcomp            \u521D\u56DE\u547C\u51FA\u3057\u6642\u306B\u30E1\u30BD\u30C3\u30C9\u306E\u30B3\u30F3\u30D1\u30A4\u30EB\u3092\u5F37\u5236\u3059\u308B\n    -Xdebug           \u4E0B\u4F4D\u4E92\u63DB\u6027\u306E\u305F\u3081\u306B\u63D0\u4F9B\n    -Xdiag            \u8FFD\u52A0\u306E\u8A3A\u65AD\u30E1\u30C3\u30BB\u30FC\u30B8\u3092\u8868\u793A\u3059\u308B\n    -Xfuture          \u5C06\u6765\u306E\u30C7\u30D5\u30A9\u30EB\u30C8\u3092\u898B\u8D8A\u3057\u3066\u3001\u6700\u3082\u53B3\u5BC6\u306A\u30C1\u30A7\u30C3\u30AF\u3092\u6709\u52B9\u306B\u3059\u308B\n    -Xint             \u30A4\u30F3\u30BF\u30D7\u30EA\u30BF\u30FB\u30E2\u30FC\u30C9\u306E\u5B9F\u884C\u306E\u307F\n    -Xinternalversion\n                      -version\u30AA\u30D7\u30B7\u30E7\u30F3\u3088\u308A\u8A73\u7D30\u306AJVM\u30D0\u30FC\u30B8\u30E7\u30F3\u60C5\u5831\u3092\n                      \u8868\u793A\u3059\u308B\n    -Xloggc:<file>    \u30BF\u30A4\u30E0\u30B9\u30BF\u30F3\u30D7\u304C\u4ED8\u3044\u305F\u30D5\u30A1\u30A4\u30EB\u306BGC\u30B9\u30C6\u30FC\u30BF\u30B9\u306E\u30ED\u30B0\u3092\u8A18\u9332\u3059\u308B\n    -Xmixed           \u6DF7\u5408\u30E2\u30FC\u30C9\u306E\u5B9F\u884C(\u30C7\u30D5\u30A9\u30EB\u30C8)\n    -Xmn<size>        \u82E5\u3044\u4E16\u4EE3(\u30CA\u30FC\u30B5\u30EA)\u306E\u30D2\u30FC\u30D7\u306E\u521D\u671F\u304A\u3088\u3073\u6700\u5927\u30B5\u30A4\u30BA(\u30D0\u30A4\u30C8\u5358\u4F4D)\n                      \u3092\u8A2D\u5B9A\u3059\u308B\n    -Xms<size>        Java\u306E\u521D\u671F\u30D2\u30FC\u30D7\u30FB\u30B5\u30A4\u30BA\u3092\u8A2D\u5B9A\u3059\u308B\n    -Xmx<size>        Java\u306E\u6700\u5927\u30D2\u30FC\u30D7\u30FB\u30B5\u30A4\u30BA\u3092\u8A2D\u5B9A\u3059\u308B\n    -Xnoclassgc       \u30AF\u30E9\u30B9\u306E\u30AC\u30D9\u30FC\u30B8\u30FB\u30B3\u30EC\u30AF\u30B7\u30E7\u30F3\u3092\u7121\u52B9\u306B\u3059\u308B\n    -Xrs              Java/VM\u306B\u3088\u308BOS\u30B7\u30B0\u30CA\u30EB\u306E\u4F7F\u7528\u3092\u524A\u6E1B\u3059\u308B(\u30C9\u30AD\u30E5\u30E1\u30F3\u30C8\u3092\u53C2\u7167)\n    -Xshare:auto      \u53EF\u80FD\u3067\u3042\u308C\u3070\u5171\u6709\u30AF\u30E9\u30B9\u306E\u30C7\u30FC\u30BF\u3092\u4F7F\u7528\u3059\u308B(\u30C7\u30D5\u30A9\u30EB\u30C8)\n    -Xshare:off       \u5171\u6709\u30AF\u30E9\u30B9\u306E\u30C7\u30FC\u30BF\u3092\u4F7F\u7528\u3057\u3088\u3046\u3068\u3057\u306A\u3044\n    -Xshare:on        \u5171\u6709\u30AF\u30E9\u30B9\u30FB\u30C7\u30FC\u30BF\u306E\u4F7F\u7528\u3092\u5FC5\u9808\u306B\u3057\u3001\u3067\u304D\u306A\u3051\u308C\u3070\u5931\u6557\u3059\u308B\u3002\n    -XshowSettings    \u3059\u3079\u3066\u306E\u8A2D\u5B9A\u3092\u8868\u793A\u3057\u3066\u7D9A\u884C\u3059\u308B\n    -XshowSettings:all\n                      \u3059\u3079\u3066\u306E\u8A2D\u5B9A\u3092\u8868\u793A\u3057\u3066\u7D9A\u884C\u3059\u308B\n    -XshowSettings:locale\n                      \u3059\u3079\u3066\u306E\u30ED\u30B1\u30FC\u30EB\u95A2\u9023\u306E\u8A2D\u5B9A\u3092\u8868\u793A\u3057\u3066\u7D9A\u884C\u3059\u308B\n    -XshowSettings:properties\n                      \u3059\u3079\u3066\u306E\u30D7\u30ED\u30D1\u30C6\u30A3\u8A2D\u5B9A\u3092\u8868\u793A\u3057\u3066\u7D9A\u884C\u3059\u308B\n    -XshowSettings:vm\n                      \u3059\u3079\u3066\u306EVM\u95A2\u9023\u306E\u8A2D\u5B9A\u3092\u8868\u793A\u3057\u3066\u7D9A\u884C\u3059\u308B\n    -XshowSettings:system\n                      (Linux\u306E\u307F) \u30DB\u30B9\u30C8\u30FB\u30B7\u30B9\u30C6\u30E0\u307E\u305F\u306F\u30B3\u30F3\u30C6\u30CA\u306E\n                      \u69CB\u6210\u3092\u8868\u793A\u3057\u3066\u7D9A\u884C\u3059\u308B\n    -Xss<size>        Java\u306E\u30B9\u30EC\u30C3\u30C9\u30FB\u30B9\u30BF\u30C3\u30AF\u30FB\u30B5\u30A4\u30BA\u3092\u8A2D\u5B9A\u3059\u308B\n    -Xverify          \u30D0\u30A4\u30C8\u30B3\u30FC\u30C9\u691C\u8A3C\u6A5F\u80FD\u306E\u30E2\u30FC\u30C9\u3092\u8A2D\u5B9A\u3059\u308B\n    --add-reads <module>=<target-module>(,<target-module>)*\n                      \u30E2\u30B8\u30E5\u30FC\u30EB\u5BA3\u8A00\u306B\u95A2\u4FC2\u306A\u304F\u3001<module>\u3092\u66F4\u65B0\u3057\u3066<target-module>\n                      \u3092\u8AAD\u307F\u53D6\u308B\u3002 \n                       <target-module>\u3092ALL-UNNAMED\u306B\u8A2D\u5B9A\u3059\u308B\u3068\u3001\u3059\u3079\u3066\u306E\u540D\u524D\u306E\u306A\u3044\u30E2\u30B8\u30E5\u30FC\u30EB\u3092\n                      \u8AAD\u307F\u53D6\u308C\u307E\u3059\u3002\n    --add-exports <module>/<package>=<target-module>(,<target-module>)*\n                      \u30E2\u30B8\u30E5\u30FC\u30EB\u5BA3\u8A00\u306B\u95A2\u4FC2\u306A\u304F\u3001<module>\u3092\u66F4\u65B0\u3057\u3066<package>\u3092<target-module>\u306B\n                      \u30A8\u30AF\u30B9\u30DD\u30FC\u30C8\u3059\u308B\u3002\n                      <target-module>\u3092ALL-UNNAMED\u306B\u8A2D\u5B9A\u3059\u308B\u3068\u3001\u3059\u3079\u3066\u306E\u540D\u524D\u306E\u306A\u3044\u30E2\u30B8\u30E5\u30FC\u30EB\u306B\n                      \u30A8\u30AF\u30B9\u30DD\u30FC\u30C8\u3067\u304D\u307E\u3059\u3002\n    --add-opens <module>/<package>=<target-module>(,<target-module>)*\n                      \u30E2\u30B8\u30E5\u30FC\u30EB\u5BA3\u8A00\u306B\u95A2\u4FC2\u306A\u304F\u3001<module>\u3092\u66F4\u65B0\u3057\u3066\n                      <package>\u3092<target-module>\u306B\u958B\u304F\u3002\n    --illegal-access=<value>\n                      \u540D\u524D\u306E\u306A\u3044\u30E2\u30B8\u30E5\u30FC\u30EB\u5185\u306E\u30B3\u30FC\u30C9\u306B\u3088\u308B\u3001\u540D\u524D\u306E\u3042\u308B\u30E2\u30B8\u30E5\u30FC\u30EB\u5185\u306E\n                      \u30BF\u30A4\u30D7\u306E\u30E1\u30F3\u30D0\u30FC\u3078\u306E\u30A2\u30AF\u30BB\u30B9\u3092\u8A31\u53EF\u307E\u305F\u306F\u62D2\u5426\u3059\u308B\u3002\n                      <value>\u306F\"deny\"\u3001\"permit\"\u3001\"warn\"\u3001\"debug\"\u306E\u3044\u305A\u308C\u304B\u3067\u3059\n                      \u3053\u306E\u30AA\u30D7\u30B7\u30E7\u30F3\u306F\u5C06\u6765\u306E\u30EA\u30EA\u30FC\u30B9\u3067\u524A\u9664\u3055\u308C\u307E\u3059\u3002\n    --limit-modules <module name>[,<module name>...]\n                      \u53C2\u7167\u53EF\u80FD\u306A\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u9818\u57DF\u3092\u5236\u9650\u3059\u308B\n    --patch-module <module>=<file>({0}<file>)*\n                      JAR\u30D5\u30A1\u30A4\u30EB\u307E\u305F\u306F\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u306E\u30AF\u30E9\u30B9\u304A\u3088\u3073\u30EA\u30BD\u30FC\u30B9\u3067\n                      \u30E2\u30B8\u30E5\u30FC\u30EB\u3092\u30AA\u30FC\u30D0\u30FC\u30E9\u30A4\u30C9\u307E\u305F\u306F\u62E1\u5F35\u3059\u308B\u3002\n    --disable-@files  \u3055\u3089\u306A\u308B\u30D5\u30A1\u30A4\u30EB\u62E1\u5F35\u3092\u7121\u52B9\u306B\u3059\u308B\n    --source <version>\n                      \u30BD\u30FC\u30B9\u30D5\u30A1\u30A4\u30EB\u30FB\u30E2\u30FC\u30C9\u3067\u30BD\u30FC\u30B9\u306E\u30D0\u30FC\u30B8\u30E7\u30F3\u3092\u8A2D\u5B9A\u3059\u308B\u3002\n\n\u3053\u308C\u3089\u306F\u8FFD\u52A0\u30AA\u30D7\u30B7\u30E7\u30F3\u3067\u3042\u308A\u4E88\u544A\u306A\u3057\u306B\u5909\u66F4\u3055\u308C\u308B\u3053\u3068\u304C\u3042\u308A\u307E\u3059\u3002\n" },
            { "java.launcher.cls.error1", "\u30A8\u30E9\u30FC: \u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9{0}\u3092\u691C\u51FA\u304A\u3088\u3073\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F\n\u539F\u56E0: {1}: {2}" },
            { "java.launcher.cls.error2", "\u30A8\u30E9\u30FC: \u30E1\u30A4\u30F3\u30FB\u30E1\u30BD\u30C3\u30C9\u304C\u30AF\u30E9\u30B9{1}\u306E{0}\u3067\u306F\u3042\u308A\u307E\u305B\u3093\u3002\u6B21\u306E\u3088\u3046\u306B\u30E1\u30A4\u30F3\u30FB\u30E1\u30BD\u30C3\u30C9\u3092\u5B9A\u7FA9\u3057\u3066\u304F\u3060\u3055\u3044\u3002\n   public static void main(String[] args)" },
            { "java.launcher.cls.error3", "\u30A8\u30E9\u30FC: \u30E1\u30A4\u30F3\u30FB\u30E1\u30BD\u30C3\u30C9\u306F\u30AF\u30E9\u30B9{0}\u306Evoid\u578B\u306E\u5024\u3092\u8FD4\u3059\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059\u3002\n\u6B21\u306E\u3088\u3046\u306B\u30E1\u30A4\u30F3\u30FB\u30E1\u30BD\u30C3\u30C9\u3092\u5B9A\u7FA9\u3057\u3066\u304F\u3060\u3055\u3044\u3002\n   public static void main(String[] args)" },
            { "java.launcher.cls.error4", "\u30A8\u30E9\u30FC: \u30E1\u30A4\u30F3\u30FB\u30E1\u30BD\u30C3\u30C9\u304C\u30AF\u30E9\u30B9{0}\u3067\u898B\u3064\u304B\u308A\u307E\u305B\u3093\u3002\u6B21\u306E\u3088\u3046\u306B\u30E1\u30A4\u30F3\u30FB\u30E1\u30BD\u30C3\u30C9\u3092\u5B9A\u7FA9\u3057\u3066\u304F\u3060\u3055\u3044\u3002\n   public static void main(String[] args)\n\u307E\u305F\u306FJavaFX\u30A2\u30D7\u30EA\u30B1\u30FC\u30B7\u30E7\u30F3\u30FB\u30AF\u30E9\u30B9\u306F{1}\u3092\u62E1\u5F35\u3059\u308B\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059" },
            { "java.launcher.cls.error5", "\u30A8\u30E9\u30FC: JavaFX\u30E9\u30F3\u30BF\u30A4\u30E0\u30FB\u30B3\u30F3\u30DD\u30FC\u30CD\u30F3\u30C8\u304C\u4E0D\u8DB3\u3057\u3066\u304A\u308A\u3001\u3053\u306E\u30A2\u30D7\u30EA\u30B1\u30FC\u30B7\u30E7\u30F3\u306E\u5B9F\u884C\u306B\u5FC5\u8981\u3067\u3059" },
            { "java.launcher.cls.error6", "\u30A8\u30E9\u30FC: \u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9{0}\u306E\u30ED\u30FC\u30C9\u4E2D\u306BLinkageError\u304C\u767A\u751F\u3057\u307E\u3057\u305F\n\t{1}" },
            { "java.launcher.cls.error7", "\u30A8\u30E9\u30FC: \u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9{0}\u3092\u521D\u671F\u5316\u3067\u304D\u307E\u305B\u3093\n\u539F\u56E0: {1}: {2}" },
            { "java.launcher.init.error", "\u521D\u671F\u5316\u30A8\u30E9\u30FC" },
            { "java.launcher.jar.error1", "\u30A8\u30E9\u30FC: \u30D5\u30A1\u30A4\u30EB{0}\u3092\u958B\u3053\u3046\u3068\u3057\u3066\u3044\u308B\u3068\u304D\u306B\u3001\u4E88\u671F\u3057\u306A\u3044\u30A8\u30E9\u30FC\u304C\u767A\u751F\u3057\u307E\u3057\u305F" },
            { "java.launcher.jar.error2", "{0}\u306B\u30DE\u30CB\u30D5\u30A7\u30B9\u30C8\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093" },
            { "java.launcher.jar.error3", "{0}\u306B\u30E1\u30A4\u30F3\u30FB\u30DE\u30CB\u30D5\u30A7\u30B9\u30C8\u5C5E\u6027\u304C\u3042\u308A\u307E\u305B\u3093" },
            { "java.launcher.jar.error4", "{0}\u5185\u306EJava\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u306E\u30ED\u30FC\u30C9\u4E2D\u306B\u30A8\u30E9\u30FC\u304C\u767A\u751F\u3057\u307E\u3057\u305F" },
            { "java.launcher.javafx.error1", "\u30A8\u30E9\u30FC: JavaFX launchApplication\u30E1\u30BD\u30C3\u30C9\u306B\u8AA4\u3063\u305F\u30B7\u30B0\u30CD\u30C1\u30E3\u304C\u3042\u308A\u3001\nstatic\u3092\u5BA3\u8A00\u3057\u3066void\u578B\u306E\u5024\u3092\u8FD4\u3059\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059" },
            { "java.launcher.module.error1", "\u30E2\u30B8\u30E5\u30FC\u30EB{0}\u306BModuleMainClass\u5C5E\u6027\u304C\u3042\u308A\u307E\u305B\u3093\u3002-m <module>/<main-class>\u3092\u4F7F\u7528\u3057\u3066\u304F\u3060\u3055\u3044" },
            { "java.launcher.module.error2", "\u30A8\u30E9\u30FC: \u30E2\u30B8\u30E5\u30FC\u30EB{1}\u306B\u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9{0}\u304C\u898B\u3064\u304B\u3089\u306A\u304B\u3063\u305F\u304B\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093\u3067\u3057\u305F" },
            { "java.launcher.module.error3", "\u30A8\u30E9\u30FC: \u30E2\u30B8\u30E5\u30FC\u30EB{1}\u306E\u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9{0}\u3092\u30ED\u30FC\u30C9\u3067\u304D\u307E\u305B\u3093\n\t{2}" },
            { "java.launcher.module.error4", "{0}\u304C\u898B\u3064\u304B\u308A\u307E\u305B\u3093" },
            { "java.launcher.module.error5", "\u30A8\u30E9\u30FC: \u30E2\u30B8\u30E5\u30FC\u30EB{1}\u306E\u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9{0}\u3092\u521D\u671F\u5316\u3067\u304D\u307E\u305B\u3093\n\u539F\u56E0: {1}: {2}" },
            { "java.launcher.opt.footer", "    -cp <\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u304A\u3088\u3073zip/jar\u30D5\u30A1\u30A4\u30EB\u306E\u30AF\u30E9\u30B9\u691C\u7D22\u30D1\u30B9>\n    -classpath <\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u304A\u3088\u3073zip/jar\u30D5\u30A1\u30A4\u30EB\u306E\u30AF\u30E9\u30B9\u691C\u7D22\u30D1\u30B9>\n    --class-path <\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u304A\u3088\u3073zip/jar\u30D5\u30A1\u30A4\u30EB\u306E\u30AF\u30E9\u30B9\u691C\u7D22\u30D1\u30B9>\n                  {0}\u533A\u5207\u308A\u30EA\u30B9\u30C8(\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u3001JAR\u30A2\u30FC\u30AB\u30A4\u30D6\u3001\n                  ZIP\u30A2\u30FC\u30AB\u30A4\u30D6)\u3067\u3001\u30AF\u30E9\u30B9\u30FB\u30D5\u30A1\u30A4\u30EB\u306E\u691C\u7D22\u7528\u3002\n    -p <module path>\n    --module-path <module path>...\n                  \u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u306E{0}\u533A\u5207\u308A\u30EA\u30B9\u30C8\u3001\u5404\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\n                  \u306F\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u3067\u3059\u3002\n    --upgrade-module-path <module path>...\n                  \u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u306E{0}\u533A\u5207\u308A\u30EA\u30B9\u30C8\u3001\u5404\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\n                  \u306F\u3001\u30E9\u30F3\u30BF\u30A4\u30E0\u30FB\u30A4\u30E1\u30FC\u30B8\u5185\u306E\u30A2\u30C3\u30D7\u30B0\u30EC\u30FC\u30C9\u53EF\u80FD\u306A\n                  \u30E2\u30B8\u30E5\u30FC\u30EB\u3092\u7F6E\u63DB\u3059\u308B\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u30C7\u30A3\u30EC\u30AF\u30C8\u30EA\u3067\u3059\n    --add-modules <module name>[,<module name>...]\n                  \u521D\u671F\u30E2\u30B8\u30E5\u30FC\u30EB\u306B\u52A0\u3048\u3066\u89E3\u6C7A\u3059\u308B\u30EB\u30FC\u30C8\u30FB\u30E2\u30B8\u30E5\u30FC\u30EB\u3002\n                  <module name>\u306B\u306F\u6B21\u3082\u6307\u5B9A\u3067\u304D\u307E\u3059: ALL-DEFAULT\u3001ALL-SYSTEM\u3001\n                  ALL-MODULE-PATH.\n    --list-modules\n                  \u53C2\u7167\u53EF\u80FD\u306A\u30E2\u30B8\u30E5\u30FC\u30EB\u3092\u30EA\u30B9\u30C8\u3057\u7D42\u4E86\u3057\u307E\u3059\n    -d <module name>\n    --describe-module <module name>\n                  \u30E2\u30B8\u30E5\u30FC\u30EB\u3092\u8AAC\u660E\u3057\u7D42\u4E86\u3057\u307E\u3059\n    --dry-run     VM\u3092\u4F5C\u6210\u3057\u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9\u3092\u30ED\u30FC\u30C9\u3057\u307E\u3059\u304C\u3001\u30E1\u30A4\u30F3\u30FB\u30E1\u30BD\u30C3\u30C9\u306F\u5B9F\u884C\u3057\u307E\u305B\u3093\u3002\n                  --dry-run\u30AA\u30D7\u30B7\u30E7\u30F3\u306F\u3001\u6B21\u306E\u691C\u8A3C\u306B\u5F79\u7ACB\u3064\u5834\u5408\u304C\u3042\u308A\u307E\u3059:\n                  \u30E2\u30B8\u30E5\u30FC\u30EB\u30FB\u30B7\u30B9\u30C6\u30E0\u69CB\u6210\u306A\u3069\u306E\u30B3\u30DE\u30F3\u30C9\u884C\u30AA\u30D7\u30B7\u30E7\u30F3\u3002\n    --validate-modules\n                  \u3059\u3079\u3066\u306E\u30E2\u30B8\u30E5\u30FC\u30EB\u3092\u691C\u8A3C\u3057\u7D42\u4E86\u3057\u307E\u3059\n                  --validate-modules\u30AA\u30D7\u30B7\u30E7\u30F3\u306F\u3001\u6B21\u306E\u691C\u7D22\u306B\u5F79\u7ACB\u3064\u5834\u5408\u304C\u3042\u308A\u307E\u3059:\n                  \u30E2\u30B8\u30E5\u30FC\u30EB\u30FB\u30D1\u30B9\u4E0A\u306E\u30E2\u30B8\u30E5\u30FC\u30EB\u3067\u306E\u7AF6\u5408\u304A\u3088\u3073\u305D\u306E\u4ED6\u306E\u30A8\u30E9\u30FC\u3002\n    -D<name>=<value>\n                  \u30B7\u30B9\u30C6\u30E0\u30FB\u30D7\u30ED\u30D1\u30C6\u30A3\u3092\u8A2D\u5B9A\u3057\u307E\u3059\n    -verbose:[class|module|gc|jni]\n                  \u8A73\u7D30\u51FA\u529B\u3092\u6709\u52B9\u306B\u3057\u307E\u3059\n    -version      \u88FD\u54C1\u30D0\u30FC\u30B8\u30E7\u30F3\u3092\u30A8\u30E9\u30FC\u30FB\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u3066\u7D42\u4E86\u3057\u307E\u3059\n    --version     \u88FD\u54C1\u30D0\u30FC\u30B8\u30E7\u30F3\u3092\u51FA\u529B\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u3066\u7D42\u4E86\u3057\u307E\u3059\n    -showversion  \u88FD\u54C1\u30D0\u30FC\u30B8\u30E7\u30F3\u3092\u30A8\u30E9\u30FC\u30FB\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u3066\u7D9A\u884C\u3057\u307E\u3059\n    --show-version\n                  \u88FD\u54C1\u30D0\u30FC\u30B8\u30E7\u30F3\u3092\u51FA\u529B\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u3066\u7D9A\u884C\u3057\u307E\u3059\n    --show-module-resolution\n                  \u8D77\u52D5\u6642\u306B\u30E2\u30B8\u30E5\u30FC\u30EB\u89E3\u6C7A\u51FA\u529B\u3092\u8868\u793A\u3057\u307E\u3059\n    -? -h -help\n                  \u3053\u306E\u30D8\u30EB\u30D7\u30FB\u30E1\u30C3\u30BB\u30FC\u30B8\u3092\u30A8\u30E9\u30FC\u30FB\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u307E\u3059\n    --help        \u3053\u306E\u30D8\u30EB\u30D7\u30FB\u30E1\u30C3\u30BB\u30FC\u30B8\u3092\u51FA\u529B\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u307E\u3059\n    -X            \u8FFD\u52A0\u30AA\u30D7\u30B7\u30E7\u30F3\u306E\u30D8\u30EB\u30D7\u3092\u30A8\u30E9\u30FC\u30FB\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u307E\u3059\n    --help-extra  \u8FFD\u52A0\u30AA\u30D7\u30B7\u30E7\u30F3\u306E\u30D8\u30EB\u30D7\u3092\u51FA\u529B\u30B9\u30C8\u30EA\u30FC\u30E0\u306B\u51FA\u529B\u3057\u307E\u3059\n    -ea[:<packagename>...|:<classname>]\n    -enableassertions[:<packagename>...|:<classname>]\n                  \u6307\u5B9A\u3057\u305F\u7C92\u5EA6\u3067\u30A2\u30B5\u30FC\u30B7\u30E7\u30F3\u3092\u6709\u52B9\u306B\u3057\u307E\u3059\n    -da[:<packagename>...|:<classname>]\n    -disableassertions[:<packagename>...|:<classname>]\n                  \u6307\u5B9A\u3057\u305F\u7C92\u5EA6\u3067\u30A2\u30B5\u30FC\u30B7\u30E7\u30F3\u3092\u7121\u52B9\u306B\u3057\u307E\u3059\n    -esa | -enablesystemassertions\n                  \u30B7\u30B9\u30C6\u30E0\u30FB\u30A2\u30B5\u30FC\u30B7\u30E7\u30F3\u3092\u6709\u52B9\u306B\u3057\u307E\u3059\n    -dsa | -disablesystemassertions\n                  \u30B7\u30B9\u30C6\u30E0\u30FB\u30A2\u30B5\u30FC\u30B7\u30E7\u30F3\u3092\u7121\u52B9\u306B\u3057\u307E\u3059\n    -agentlib:<libname>[=<options>]\n                  \u30CD\u30A4\u30C6\u30A3\u30D6\u30FB\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30FB\u30E9\u30A4\u30D6\u30E9\u30EA<libname>\u3092\u30ED\u30FC\u30C9\u3057\u307E\u3059\u3002\u4F8B: -agentlib:jdwp\n                  -agentlib:jdwp=help\u3082\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044\n    -agentpath:<pathname>[=<options>]\n                  \u30D5\u30EB\u30D1\u30B9\u540D\u3092\u4F7F\u7528\u3057\u3066\u3001\u30CD\u30A4\u30C6\u30A3\u30D6\u30FB\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u30FB\u30E9\u30A4\u30D6\u30E9\u30EA\u3092\u30ED\u30FC\u30C9\u3057\u307E\u3059\n    -javaagent:<jarpath>[=<options>]\n                  Java\u30D7\u30ED\u30B0\u30E9\u30DF\u30F3\u30B0\u8A00\u8A9E\u30A8\u30FC\u30B8\u30A7\u30F3\u30C8\u3092\u30ED\u30FC\u30C9\u3057\u307E\u3059\u3002java.lang.instrument\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044\n    -splash:<imagepath>\n                  \u6307\u5B9A\u3055\u308C\u305F\u30A4\u30E1\u30FC\u30B8\u3092\u542B\u3080\u30B9\u30D7\u30E9\u30C3\u30B7\u30E5\u753B\u9762\u3092\u8868\u793A\u3057\u307E\u3059\n                  HiDPI\u30B9\u30B1\u30FC\u30EB\u306E\u30A4\u30E1\u30FC\u30B8\u304C\u81EA\u52D5\u7684\u306B\u30B5\u30DD\u30FC\u30C8\u3055\u308C\u3066\u4F7F\u7528\u3055\u308C\u307E\u3059\n                  (\u53EF\u80FD\u306A\u5834\u5408)\u3002\u30B9\u30B1\u30FC\u30EA\u30F3\u30B0\u3055\u308C\u306A\u3044\u30A4\u30E1\u30FC\u30B8\u306E\u30D5\u30A1\u30A4\u30EB\u540D(image.ext\u306A\u3069)\u3092\n                  \u5F15\u6570\u3068\u3057\u3066-splash\u30AA\u30D7\u30B7\u30E7\u30F3\u306B\u5FC5\u305A\u6E21\u3059\u5FC5\u8981\u304C\u3042\u308A\u307E\u3059\u3002\n                  \u6307\u5B9A\u3055\u308C\u305F\u6700\u3082\u9069\u5207\u306A\u30B9\u30B1\u30FC\u30EA\u30F3\u30B0\u6E08\u30A4\u30E1\u30FC\u30B8\u304C\u9078\u629E\u3055\u308C\u307E\u3059\n                  (\u81EA\u52D5\u7684)\u3002\n                  \u8A73\u7D30\u306F\u3001SplashScreen API\u306E\u30C9\u30AD\u30E5\u30E1\u30F3\u30C8\u3092\u53C2\u7167\u3057\u3066\u304F\u3060\u3055\u3044\n    @argument\u30D5\u30A1\u30A4\u30EB\n                  \u30AA\u30D7\u30B7\u30E7\u30F3\u3092\u542B\u30801\u3064\u4EE5\u4E0A\u306E\u5F15\u6570\u30D5\u30A1\u30A4\u30EB\n    -disable-@files\n                  \u3055\u3089\u306A\u308B\u5F15\u6570\u30D5\u30A1\u30A4\u30EB\u62E1\u5F35\u3092\u7121\u52B9\u306B\u3057\u307E\u3059\n    --enable-preview\n                  \u30AF\u30E9\u30B9\u3092\u3053\u306E\u30EA\u30EA\u30FC\u30B9\u306E\u30D7\u30EC\u30D3\u30E5\u30FC\u6A5F\u80FD\u306B\u4F9D\u5B58\u3055\u305B\u308B\u3053\u3068\u304C\u3067\u304D\u307E\u3059\n\u9577\u3044\u30AA\u30D7\u30B7\u30E7\u30F3\u306E\u5F15\u6570\u3092\u6307\u5B9A\u3059\u308B\u5834\u5408\u3001--<name>=<value>\u307E\u305F\u306F\n--<name> <value>\u3092\u4F7F\u7528\u3067\u304D\u307E\u3059\u3002\n" },
            { "java.launcher.opt.header", "\u4F7F\u7528\u65B9\u6CD5: {0} [options] <mainclass> [args...]\n           (\u30AF\u30E9\u30B9\u3092\u5B9F\u884C\u3059\u308B\u5834\u5408)\n   \u307E\u305F\u306F  {0} [options] -jar <jarfile> [args...]\n           (jar\u30D5\u30A1\u30A4\u30EB\u3092\u5B9F\u884C\u3059\u308B\u5834\u5408)\n   \u307E\u305F\u306F  {0} [options] -m <module>[/<mainclass>] [args...]\n       {0} [options] --module <module>[/<mainclass>] [args...]\n           (\u30E2\u30B8\u30E5\u30FC\u30EB\u306E\u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9\u3092\u5B9F\u884C\u3059\u308B\u5834\u5408)\n   \u307E\u305F\u306F  {0} [options] <sourcefile> [args]\n           (\u5358\u4E00\u306E\u30BD\u30FC\u30B9\u30D5\u30A1\u30A4\u30EB\u30FB\u30D7\u30ED\u30B0\u30E9\u30E0\u3092\u5B9F\u884C\u3059\u308B\u5834\u5408)\n\n \u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9\u3001\u30BD\u30FC\u30B9\u30FB\u30D5\u30A1\u30A4\u30EB\u3001-jar <jarfile>\u3001\n -m\u307E\u305F\u306F--module <module>/<mainclass>\u306B\u7D9A\u304F\u5F15\u6570\u306F\u3001\u30E1\u30A4\u30F3\u30FB\u30AF\u30E9\u30B9\u3078\u306E\u5F15\u6570\u3068\u3057\u3066\n \u6E21\u3055\u308C\u307E\u3059\u3002\n\n \u30AA\u30D7\u30B7\u30E7\u30F3\u306F\u6B21\u306E\u3068\u304A\u308A\u3067\u3059:\n\n" },
            { "java.launcher.opt.hotspot", "    {0}\t  \u306F\"{1}\" VM\u306E\u30B7\u30CE\u30CB\u30E0\u3067\u3059  [\u975E\u63A8\u5968]\n" },
            { "java.launcher.opt.vmselect", "    {0}\t  \"{1}\" VM\u3092\u9078\u629E\u3059\u308B\u5834\u5408\n" },
        };
    }
}
