// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["Abs.Vector128.Double"] = Abs_Vector128_Double,
                ["Abs.Vector128.Int64"] = Abs_Vector128_Int64,
                ["AbsSaturate.Vector128.Int64"] = AbsSaturate_Vector128_Int64,
                ["AbsSaturateScalar.Vector64.Int16"] = AbsSaturateScalar_Vector64_Int16,
                ["AbsSaturateScalar.Vector64.Int32"] = AbsSaturateScalar_Vector64_Int32,
                ["AbsSaturateScalar.Vector64.Int64"] = AbsSaturateScalar_Vector64_Int64,
                ["AbsSaturateScalar.Vector64.SByte"] = AbsSaturateScalar_Vector64_SByte,
                ["AbsScalar.Vector64.Int64"] = AbsScalar_Vector64_Int64,
                ["AbsoluteCompareGreaterThan.Vector128.Double"] = AbsoluteCompareGreaterThan_Vector128_Double,
                ["AbsoluteCompareGreaterThanScalar.Vector64.Double"] = AbsoluteCompareGreaterThanScalar_Vector64_Double,
                ["AbsoluteCompareGreaterThanScalar.Vector64.Single"] = AbsoluteCompareGreaterThanScalar_Vector64_Single,
                ["AbsoluteCompareGreaterThanOrEqual.Vector128.Double"] = AbsoluteCompareGreaterThanOrEqual_Vector128_Double,
                ["AbsoluteCompareGreaterThanOrEqualScalar.Vector64.Double"] = AbsoluteCompareGreaterThanOrEqualScalar_Vector64_Double,
                ["AbsoluteCompareGreaterThanOrEqualScalar.Vector64.Single"] = AbsoluteCompareGreaterThanOrEqualScalar_Vector64_Single,
                ["AbsoluteCompareLessThan.Vector128.Double"] = AbsoluteCompareLessThan_Vector128_Double,
                ["AbsoluteCompareLessThanScalar.Vector64.Double"] = AbsoluteCompareLessThanScalar_Vector64_Double,
                ["AbsoluteCompareLessThanScalar.Vector64.Single"] = AbsoluteCompareLessThanScalar_Vector64_Single,
                ["AbsoluteCompareLessThanOrEqual.Vector128.Double"] = AbsoluteCompareLessThanOrEqual_Vector128_Double,
                ["AbsoluteCompareLessThanOrEqualScalar.Vector64.Double"] = AbsoluteCompareLessThanOrEqualScalar_Vector64_Double,
                ["AbsoluteCompareLessThanOrEqualScalar.Vector64.Single"] = AbsoluteCompareLessThanOrEqualScalar_Vector64_Single,
                ["AbsoluteDifference.Vector128.Double"] = AbsoluteDifference_Vector128_Double,
                ["AbsoluteDifferenceScalar.Vector64.Double"] = AbsoluteDifferenceScalar_Vector64_Double,
                ["AbsoluteDifferenceScalar.Vector64.Single"] = AbsoluteDifferenceScalar_Vector64_Single,
                ["Add.Vector128.Double"] = Add_Vector128_Double,
                ["AddAcross.Vector64.Byte"] = AddAcross_Vector64_Byte,
                ["AddAcross.Vector64.Int16"] = AddAcross_Vector64_Int16,
                ["AddAcross.Vector64.SByte"] = AddAcross_Vector64_SByte,
                ["AddAcross.Vector64.UInt16"] = AddAcross_Vector64_UInt16,
                ["AddAcross.Vector128.Byte"] = AddAcross_Vector128_Byte,
                ["AddAcross.Vector128.Int16"] = AddAcross_Vector128_Int16,
                ["AddAcross.Vector128.Int32"] = AddAcross_Vector128_Int32,
                ["AddAcross.Vector128.SByte"] = AddAcross_Vector128_SByte,
                ["AddAcross.Vector128.UInt16"] = AddAcross_Vector128_UInt16,
                ["AddAcross.Vector128.UInt32"] = AddAcross_Vector128_UInt32,
                ["AddAcrossWidening.Vector64.Byte"] = AddAcrossWidening_Vector64_Byte,
                ["AddAcrossWidening.Vector64.Int16"] = AddAcrossWidening_Vector64_Int16,
                ["AddAcrossWidening.Vector64.SByte"] = AddAcrossWidening_Vector64_SByte,
                ["AddAcrossWidening.Vector64.UInt16"] = AddAcrossWidening_Vector64_UInt16,
                ["AddAcrossWidening.Vector128.Byte"] = AddAcrossWidening_Vector128_Byte,
                ["AddAcrossWidening.Vector128.Int16"] = AddAcrossWidening_Vector128_Int16,
                ["AddAcrossWidening.Vector128.Int32"] = AddAcrossWidening_Vector128_Int32,
                ["AddAcrossWidening.Vector128.SByte"] = AddAcrossWidening_Vector128_SByte,
                ["AddAcrossWidening.Vector128.UInt16"] = AddAcrossWidening_Vector128_UInt16,
                ["AddAcrossWidening.Vector128.UInt32"] = AddAcrossWidening_Vector128_UInt32,
                ["AddPairwise.Vector128.Byte"] = AddPairwise_Vector128_Byte,
                ["AddPairwise.Vector128.Double"] = AddPairwise_Vector128_Double,
                ["AddPairwise.Vector128.Int16"] = AddPairwise_Vector128_Int16,
                ["AddPairwise.Vector128.Int32"] = AddPairwise_Vector128_Int32,
                ["AddPairwise.Vector128.Int64"] = AddPairwise_Vector128_Int64,
                ["AddPairwise.Vector128.SByte"] = AddPairwise_Vector128_SByte,
                ["AddPairwise.Vector128.Single"] = AddPairwise_Vector128_Single,
                ["AddPairwise.Vector128.UInt16"] = AddPairwise_Vector128_UInt16,
                ["AddPairwise.Vector128.UInt32"] = AddPairwise_Vector128_UInt32,
                ["AddPairwise.Vector128.UInt64"] = AddPairwise_Vector128_UInt64,
                ["AddPairwiseScalar.Vector64.Single"] = AddPairwiseScalar_Vector64_Single,
                ["AddPairwiseScalar.Vector128.Double"] = AddPairwiseScalar_Vector128_Double,
                ["AddPairwiseScalar.Vector128.Int64"] = AddPairwiseScalar_Vector128_Int64,
                ["AddPairwiseScalar.Vector128.UInt64"] = AddPairwiseScalar_Vector128_UInt64,
                ["AddSaturate.Vector64.Byte.Vector64.SByte"] = AddSaturate_Vector64_Byte_Vector64_SByte,
                ["AddSaturate.Vector64.Int16.Vector64.UInt16"] = AddSaturate_Vector64_Int16_Vector64_UInt16,
                ["AddSaturate.Vector64.Int32.Vector64.UInt32"] = AddSaturate_Vector64_Int32_Vector64_UInt32,
                ["AddSaturate.Vector64.SByte.Vector64.Byte"] = AddSaturate_Vector64_SByte_Vector64_Byte,
                ["AddSaturate.Vector64.UInt16.Vector64.Int16"] = AddSaturate_Vector64_UInt16_Vector64_Int16,
                ["AddSaturate.Vector64.UInt32.Vector64.Int32"] = AddSaturate_Vector64_UInt32_Vector64_Int32,
                ["AddSaturate.Vector128.Byte.Vector128.SByte"] = AddSaturate_Vector128_Byte_Vector128_SByte,
                ["AddSaturate.Vector128.Int16.Vector128.UInt16"] = AddSaturate_Vector128_Int16_Vector128_UInt16,
                ["AddSaturate.Vector128.Int32.Vector128.UInt32"] = AddSaturate_Vector128_Int32_Vector128_UInt32,
                ["AddSaturate.Vector128.Int64.Vector128.UInt64"] = AddSaturate_Vector128_Int64_Vector128_UInt64,
                ["AddSaturate.Vector128.SByte.Vector128.Byte"] = AddSaturate_Vector128_SByte_Vector128_Byte,
                ["AddSaturate.Vector128.UInt16.Vector128.Int16"] = AddSaturate_Vector128_UInt16_Vector128_Int16,
                ["AddSaturate.Vector128.UInt32.Vector128.Int32"] = AddSaturate_Vector128_UInt32_Vector128_Int32,
                ["AddSaturate.Vector128.UInt64.Vector128.Int64"] = AddSaturate_Vector128_UInt64_Vector128_Int64,
                ["AddSaturateScalar.Vector64.Byte.Vector64.Byte"] = AddSaturateScalar_Vector64_Byte_Vector64_Byte,
                ["AddSaturateScalar.Vector64.Byte.Vector64.SByte"] = AddSaturateScalar_Vector64_Byte_Vector64_SByte,
                ["AddSaturateScalar.Vector64.Int16.Vector64.Int16"] = AddSaturateScalar_Vector64_Int16_Vector64_Int16,
                ["AddSaturateScalar.Vector64.Int16.Vector64.UInt16"] = AddSaturateScalar_Vector64_Int16_Vector64_UInt16,
                ["AddSaturateScalar.Vector64.Int32.Vector64.Int32"] = AddSaturateScalar_Vector64_Int32_Vector64_Int32,
                ["AddSaturateScalar.Vector64.Int32.Vector64.UInt32"] = AddSaturateScalar_Vector64_Int32_Vector64_UInt32,
                ["AddSaturateScalar.Vector64.Int64.Vector64.UInt64"] = AddSaturateScalar_Vector64_Int64_Vector64_UInt64,
                ["AddSaturateScalar.Vector64.SByte.Vector64.Byte"] = AddSaturateScalar_Vector64_SByte_Vector64_Byte,
                ["AddSaturateScalar.Vector64.SByte.Vector64.SByte"] = AddSaturateScalar_Vector64_SByte_Vector64_SByte,
                ["AddSaturateScalar.Vector64.UInt16.Vector64.Int16"] = AddSaturateScalar_Vector64_UInt16_Vector64_Int16,
                ["AddSaturateScalar.Vector64.UInt16.Vector64.UInt16"] = AddSaturateScalar_Vector64_UInt16_Vector64_UInt16,
                ["AddSaturateScalar.Vector64.UInt32.Vector64.Int32"] = AddSaturateScalar_Vector64_UInt32_Vector64_Int32,
                ["AddSaturateScalar.Vector64.UInt32.Vector64.UInt32"] = AddSaturateScalar_Vector64_UInt32_Vector64_UInt32,
                ["AddSaturateScalar.Vector64.UInt64.Vector64.Int64"] = AddSaturateScalar_Vector64_UInt64_Vector64_Int64,
                ["Ceiling.Vector128.Double"] = Ceiling_Vector128_Double,
                ["CompareEqual.Vector128.Double"] = CompareEqual_Vector128_Double,
                ["CompareEqual.Vector128.Int64"] = CompareEqual_Vector128_Int64,
                ["CompareEqual.Vector128.UInt64"] = CompareEqual_Vector128_UInt64,
                ["CompareEqualScalar.Vector64.Double"] = CompareEqualScalar_Vector64_Double,
                ["CompareEqualScalar.Vector64.Int64"] = CompareEqualScalar_Vector64_Int64,
                ["CompareEqualScalar.Vector64.Single"] = CompareEqualScalar_Vector64_Single,
                ["CompareEqualScalar.Vector64.UInt64"] = CompareEqualScalar_Vector64_UInt64,
                ["CompareGreaterThan.Vector128.Double"] = CompareGreaterThan_Vector128_Double,
                ["CompareGreaterThan.Vector128.Int64"] = CompareGreaterThan_Vector128_Int64,
                ["CompareGreaterThan.Vector128.UInt64"] = CompareGreaterThan_Vector128_UInt64,
                ["CompareGreaterThanScalar.Vector64.Double"] = CompareGreaterThanScalar_Vector64_Double,
                ["CompareGreaterThanScalar.Vector64.Int64"] = CompareGreaterThanScalar_Vector64_Int64,
                ["CompareGreaterThanScalar.Vector64.Single"] = CompareGreaterThanScalar_Vector64_Single,
            };
        }
    }
}
