// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

namespace JIT.HardwareIntrinsics.Arm
{
    public static partial class Program
    {
        static Program()
        {
            TestList = new Dictionary<string, Action>() {
                ["MultiplyScalar.Vector64.Double"] = MultiplyScalar_Vector64_Double,
                ["MultiplyScalar.Vector64.Single"] = MultiplyScalar_Vector64_Single,
                ["MultiplyAdd.Vector64.Byte"] = MultiplyAdd_Vector64_Byte,
                ["MultiplyAdd.Vector64.Int16"] = MultiplyAdd_Vector64_Int16,
                ["MultiplyAdd.Vector64.Int32"] = MultiplyAdd_Vector64_Int32,
                ["MultiplyAdd.Vector64.SByte"] = MultiplyAdd_Vector64_SByte,
                ["MultiplyAdd.Vector64.UInt16"] = MultiplyAdd_Vector64_UInt16,
                ["MultiplyAdd.Vector64.UInt32"] = MultiplyAdd_Vector64_UInt32,
                ["MultiplyAdd.Vector128.Byte"] = MultiplyAdd_Vector128_Byte,
                ["MultiplyAdd.Vector128.Int16"] = MultiplyAdd_Vector128_Int16,
                ["MultiplyAdd.Vector128.Int32"] = MultiplyAdd_Vector128_Int32,
                ["MultiplyAdd.Vector128.SByte"] = MultiplyAdd_Vector128_SByte,
                ["MultiplyAdd.Vector128.UInt16"] = MultiplyAdd_Vector128_UInt16,
                ["MultiplyAdd.Vector128.UInt32"] = MultiplyAdd_Vector128_UInt32,
                ["MultiplyAddByScalar.Vector64.Int16"] = MultiplyAddByScalar_Vector64_Int16,
                ["MultiplyAddByScalar.Vector64.Int32"] = MultiplyAddByScalar_Vector64_Int32,
                ["MultiplyAddByScalar.Vector64.UInt16"] = MultiplyAddByScalar_Vector64_UInt16,
                ["MultiplyAddByScalar.Vector64.UInt32"] = MultiplyAddByScalar_Vector64_UInt32,
                ["MultiplyAddByScalar.Vector128.Int16"] = MultiplyAddByScalar_Vector128_Int16,
                ["MultiplyAddByScalar.Vector128.Int32"] = MultiplyAddByScalar_Vector128_Int32,
                ["MultiplyAddByScalar.Vector128.UInt16"] = MultiplyAddByScalar_Vector128_UInt16,
                ["MultiplyAddByScalar.Vector128.UInt32"] = MultiplyAddByScalar_Vector128_UInt32,
                ["MultiplyAddBySelectedScalar.Vector64.Int16.Vector64.Int16.3"] = MultiplyAddBySelectedScalar_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyAddBySelectedScalar.Vector64.Int16.Vector128.Int16.7"] = MultiplyAddBySelectedScalar_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyAddBySelectedScalar.Vector64.Int32.Vector64.Int32.1"] = MultiplyAddBySelectedScalar_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyAddBySelectedScalar.Vector64.Int32.Vector128.Int32.3"] = MultiplyAddBySelectedScalar_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyAddBySelectedScalar.Vector64.UInt16.Vector64.UInt16.3"] = MultiplyAddBySelectedScalar_Vector64_UInt16_Vector64_UInt16_3,
                ["MultiplyAddBySelectedScalar.Vector64.UInt16.Vector128.UInt16.7"] = MultiplyAddBySelectedScalar_Vector64_UInt16_Vector128_UInt16_7,
                ["MultiplyAddBySelectedScalar.Vector64.UInt32.Vector64.UInt32.1"] = MultiplyAddBySelectedScalar_Vector64_UInt32_Vector64_UInt32_1,
                ["MultiplyAddBySelectedScalar.Vector64.UInt32.Vector128.UInt32.3"] = MultiplyAddBySelectedScalar_Vector64_UInt32_Vector128_UInt32_3,
                ["MultiplyAddBySelectedScalar.Vector128.Int16.Vector64.Int16.3"] = MultiplyAddBySelectedScalar_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyAddBySelectedScalar.Vector128.Int16.Vector128.Int16.7"] = MultiplyAddBySelectedScalar_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyAddBySelectedScalar.Vector128.Int32.Vector64.Int32.1"] = MultiplyAddBySelectedScalar_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyAddBySelectedScalar.Vector128.Int32.Vector128.Int32.3"] = MultiplyAddBySelectedScalar_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyAddBySelectedScalar.Vector128.UInt16.Vector64.UInt16.3"] = MultiplyAddBySelectedScalar_Vector128_UInt16_Vector64_UInt16_3,
                ["MultiplyAddBySelectedScalar.Vector128.UInt16.Vector128.UInt16.7"] = MultiplyAddBySelectedScalar_Vector128_UInt16_Vector128_UInt16_7,
                ["MultiplyAddBySelectedScalar.Vector128.UInt32.Vector64.UInt32.1"] = MultiplyAddBySelectedScalar_Vector128_UInt32_Vector64_UInt32_1,
                ["MultiplyAddBySelectedScalar.Vector128.UInt32.Vector128.UInt32.3"] = MultiplyAddBySelectedScalar_Vector128_UInt32_Vector128_UInt32_3,
                ["MultiplyByScalar.Vector64.Int16"] = MultiplyByScalar_Vector64_Int16,
                ["MultiplyByScalar.Vector64.Int32"] = MultiplyByScalar_Vector64_Int32,
                ["MultiplyByScalar.Vector64.Single"] = MultiplyByScalar_Vector64_Single,
                ["MultiplyByScalar.Vector64.UInt16"] = MultiplyByScalar_Vector64_UInt16,
                ["MultiplyByScalar.Vector64.UInt32"] = MultiplyByScalar_Vector64_UInt32,
                ["MultiplyByScalar.Vector128.Int16"] = MultiplyByScalar_Vector128_Int16,
                ["MultiplyByScalar.Vector128.Int32"] = MultiplyByScalar_Vector128_Int32,
                ["MultiplyByScalar.Vector128.Single"] = MultiplyByScalar_Vector128_Single,
                ["MultiplyByScalar.Vector128.UInt16"] = MultiplyByScalar_Vector128_UInt16,
                ["MultiplyByScalar.Vector128.UInt32"] = MultiplyByScalar_Vector128_UInt32,
                ["MultiplyBySelectedScalar.Vector64.Int16.Vector64.Int16.1"] = MultiplyBySelectedScalar_Vector64_Int16_Vector64_Int16_1,
                ["MultiplyBySelectedScalar.Vector64.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalar_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalar.Vector64.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalar_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalar.Vector64.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalar_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalar.Vector64.Single.Vector64.Single.1"] = MultiplyBySelectedScalar_Vector64_Single_Vector64_Single_1,
                ["MultiplyBySelectedScalar.Vector64.Single.Vector128.Single.3"] = MultiplyBySelectedScalar_Vector64_Single_Vector128_Single_3,
                ["MultiplyBySelectedScalar.Vector64.UInt16.Vector64.UInt16.1"] = MultiplyBySelectedScalar_Vector64_UInt16_Vector64_UInt16_1,
                ["MultiplyBySelectedScalar.Vector64.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalar_Vector64_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalar.Vector64.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalar_Vector64_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalar.Vector64.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalar_Vector64_UInt32_Vector128_UInt32_3,
                ["MultiplyBySelectedScalar.Vector128.Int16.Vector64.Int16.1"] = MultiplyBySelectedScalar_Vector128_Int16_Vector64_Int16_1,
                ["MultiplyBySelectedScalar.Vector128.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalar_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalar.Vector128.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalar_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalar.Vector128.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalar_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalar.Vector128.Single.Vector64.Single.1"] = MultiplyBySelectedScalar_Vector128_Single_Vector64_Single_1,
                ["MultiplyBySelectedScalar.Vector128.Single.Vector128.Single.3"] = MultiplyBySelectedScalar_Vector128_Single_Vector128_Single_3,
                ["MultiplyBySelectedScalar.Vector128.UInt16.Vector64.UInt16.1"] = MultiplyBySelectedScalar_Vector128_UInt16_Vector64_UInt16_1,
                ["MultiplyBySelectedScalar.Vector128.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalar_Vector128_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalar.Vector128.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalar_Vector128_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalar.Vector128.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalar_Vector128_UInt32_Vector128_UInt32_3,
                ["MultiplyBySelectedScalarWideningLower.Vector64.Int16.Vector64.Int16.3"] = MultiplyBySelectedScalarWideningLower_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyBySelectedScalarWideningLower.Vector64.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalarWideningLower_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalarWideningLower.Vector64.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalarWideningLower_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalarWideningLower.Vector64.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalarWideningLower_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalarWideningLower.Vector64.UInt16.Vector64.UInt16.3"] = MultiplyBySelectedScalarWideningLower_Vector64_UInt16_Vector64_UInt16_3,
                ["MultiplyBySelectedScalarWideningLower.Vector64.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalarWideningLower_Vector64_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalarWideningLower.Vector64.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalarWideningLower_Vector64_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalarWideningLower.Vector64.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalarWideningLower_Vector64_UInt32_Vector128_UInt32_3,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.Int16.Vector64.Int16.3"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.UInt16.Vector64.UInt16.3"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt16_Vector64_UInt16_3,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalarWideningLowerAndAdd.Vector64.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt32_Vector128_UInt32_3,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.Int16.Vector64.Int16.3"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int16_Vector64_Int16_3,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.UInt16.Vector64.UInt16.3"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt16_Vector64_UInt16_3,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalarWideningLowerAndSubtract.Vector64.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt32_Vector128_UInt32_3,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.Int16.Vector64.Int16.3"] = MultiplyBySelectedScalarWideningUpper_Vector128_Int16_Vector64_Int16_3,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.Int16.Vector128.Int16.7"] = MultiplyBySelectedScalarWideningUpper_Vector128_Int16_Vector128_Int16_7,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.Int32.Vector64.Int32.1"] = MultiplyBySelectedScalarWideningUpper_Vector128_Int32_Vector64_Int32_1,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.Int32.Vector128.Int32.3"] = MultiplyBySelectedScalarWideningUpper_Vector128_Int32_Vector128_Int32_3,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.UInt16.Vector64.UInt16.3"] = MultiplyBySelectedScalarWideningUpper_Vector128_UInt16_Vector64_UInt16_3,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.UInt16.Vector128.UInt16.7"] = MultiplyBySelectedScalarWideningUpper_Vector128_UInt16_Vector128_UInt16_7,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.UInt32.Vector64.UInt32.1"] = MultiplyBySelectedScalarWideningUpper_Vector128_UInt32_Vector64_UInt32_1,
                ["MultiplyBySelectedScalarWideningUpper.Vector128.UInt32.Vector128.UInt32.3"] = MultiplyBySelectedScalarWideningUpper_Vector128_UInt32_Vector128_UInt32_3,
            };
        }
    }
}
