// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Threading;

class CtorTest
{
    public static int Main(string[] args)
    {
        // Check args
        if (args.Length < 3)
        {
            Console.WriteLine("USAGE: SemaphoreCtorNeg3 /iCount:<int> /mCount:<int> " + 
                "[/semName:<string>] [/iRandom:<int>]");
            return -1;
        }

        // Get the args
        int iCount = -1, mCount = -1, iRandom = -1;
        string semName = "DefaultString";

        for (int i = 0; i < args.Length; i++)
        {
            if (args[i].ToLower().StartsWith("/icount:"))
            {
                iCount = Convert.ToInt32(args[i].Substring(8));
                continue;
            }

            if (args[i].ToLower().StartsWith("/mcount:"))
            {
                mCount = Convert.ToInt32(args[i].Substring(8));
                continue;
            }

            if (args[i].ToLower().StartsWith("/irandom:"))
            {
                iRandom = Convert.ToInt32(args[i].Substring(9));
                continue;
            }

            if (args[i].ToLower().StartsWith("/semname:"))
            {
                semName = args[i].Substring(9);
                if (semName.ToLower() == "null")
                    semName = null;
                continue;
            }

            if (args[i].ToLower().StartsWith("/unisemname:"))
            {
                semName = string.Empty;
                //    Convert to unicode
                string[] s = args[i].Substring(12).Split(';');
                foreach (string str in s)
                    semName += Convert.ToChar(Convert.ToInt32(str));
                continue;
            }
        }
        CtorTest ct = new CtorTest();
        return ct.Run(iCount, mCount, semName, iRandom);
    }
           
    private int Run(int initalValue, int maxValue, string semName,
        int iRandom) 
    {
        int iRet = -1;
        Semaphore sem = null;
        if (iRandom > 0)
        { 
            //TestFramework.GlobalData intl = new TestFramework.GlobalData();
            //semName = intl.GetString(iRandom, iRandom).Replace(@"\", "");
            Console.WriteLine("WARNING: Random name generation is disabled");
        }
        bool bRet=true;
        try
        {
            using (sem = new Semaphore(initalValue, maxValue, semName, out bRet))
            {
                if(bRet)
                    Console.WriteLine("Semaphore was created!");
            }
        }
        catch(ArgumentException)
        {
            //  Expected
            if(bRet)
                iRet = 100;
            else
                Console.WriteLine("Returned FALSE");
        }
        catch(Exception e)
        {
            Console.WriteLine("Unexpected exception thrown: " + 
                e.ToString());
        }
 
        Console.WriteLine(100 == iRet ? "Test Passed" : "Test Failed");
        return iRet;
    }
}
