# Meetings

## Introduction
In this new hybrid world there are many challenges ahead.  This is our current attempt as a team to navigate.  We know we're wrong at least in some ways, but will bravely move forward, learn, and then adjust as appropriate.

## Definition
To distinguish team gatherings that fall into the guidelines below from others, we should define what we mean by a meeting. 
- A **Meeting** - for the context of our principles and guidelines below - is any gathering of the team where a planned discussion or decision is made that will long lived (more than a week). 
- Team social events (such as the weekly Prague Coffee Break or the Redmond Happy Hour), Stand Up (the daily one in Prague, the twice weekly one in Redmond, and the daily FR one), and 1:1 do not meet our definition of a meeting. 

## Principles
- All of our meetings must be inclusive of everyone who wants to participate.
- Meetings should be reserved for situations and discussions that are unreasonable or silly to have async.
- Meetings are an important, necessary, and key part of belonging.
- Social interactions are also a priority.  (not just the agenda)
- Nobody should feel like they *only* go to meetings all day

## Guidelines
- Every meeting is a Teams meeting.  (regardless if synchronous or async)
- Meetings should start after the hour (or half hour) so that folks have breathing space in between. At least five minutes are recommended, and ten minutes if reasonable.
- Every meeting has recording turned on by default
- A meeting agenda articulating what is hoped to be accomplished is highly encouraged.
- Notes that articulate the main points discussed and conclusion are sent out after every meeting that is of general concern.  (1:1's don't count of course)
- When folks are meeting physically together, laptops (or other devices) should be used to aid remote folks.  (see logistics note below)
- The meeting organizer should *always* have a laptop.
- Attendees (remote and in-person) should use the "hand raise" feature to request time to speak. The meeting organizer, or her designee, should monitor and use this list.
- The meeting organizer, or her designee, should monitor Teams chat for relevant meeting information.
- It's probably better to schedule meetings in a conference room and/or focus room so as to not disrupt the team room.  However, there are undoubtedly times when having the meeting in the team room is appropriate.
- Only one person should speak at a time
  - Modern conference room microphones are sensitive. Even quiet side conversations come through clearly to remote attendees. 
  - Simultaneous speakers in a conference room quickly become incoherent to remote attendees and make it difficult to understand individuals. 
  - Use the Teams meeting chat for side conversations or request the floor from the meeting organizer.
- Close meetings on time. Conference rooms may be booked by others, which can cause an abrupt ending (and remote folks do not get to participate in the wrap-up hallway conversations that can happen after).

## Logistics
- A pool of laptops is available which can be 'checked out' and used for meetings.  At this time, there's probably not enough for everyone, but we do have a few already.  Also, most devs now already have a laptop which is helpful.
- Meeting notes:
  - V-Team meeting notes are posted in the v-team channel in Teams.
  - Inter-Team notes are sent to the invite list.
  - General team meeting notes are sent to the whole team alias. 

## Possible Feature Requests
- Teams to add the ability to auto deep link portions of the transcript
