﻿// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
//-----------------------------------------------------------------------
// </copyright>
// <summary>A packet which contains information needed for a node to configure itself for build.</summary>
//-----------------------------------------------------------------------

#nullable disable

namespace Microsoft.Build.BackEnd
{
    internal sealed class LoggingNodeConfiguration : ITranslatable
    {
        private bool _includeEvaluationMetaprojects;
        private bool _includeEvaluationProfiles;
        private bool _includeEvaluationPropertiesAndItems;
        private bool _includeTaskInputs;

        public bool IncludeEvaluationMetaprojects => _includeEvaluationMetaprojects;
        public bool IncludeEvaluationProfiles => _includeEvaluationProfiles;
        public bool IncludeEvaluationPropertiesAndItems => _includeEvaluationPropertiesAndItems;
        public bool IncludeTaskInputs => _includeTaskInputs;

        public LoggingNodeConfiguration()
        {
        }

        public LoggingNodeConfiguration(
            bool includeEvaluationMetaprojects,
            bool includeEvaluationProfiles,
            bool includeEvaluationPropertiesAndItems,
            bool includeTaskInputs)
        {
            _includeEvaluationMetaprojects = includeEvaluationMetaprojects;
            _includeEvaluationProfiles = includeEvaluationProfiles;
            _includeEvaluationPropertiesAndItems = includeEvaluationPropertiesAndItems;
            _includeTaskInputs = includeTaskInputs;
        }

        void ITranslatable.Translate(ITranslator translator)
        {
            translator.Translate(ref _includeEvaluationMetaprojects);
            translator.Translate(ref _includeEvaluationProfiles);
            translator.Translate(ref _includeEvaluationPropertiesAndItems);
            translator.Translate(ref _includeTaskInputs);
        }
    }
}
