import * as DomQueries from '@testing-library/dom';
import { screen, } from '@testing-library/dom';
function makeRTLSelector(selection) {
    // too lazy to list out all combinations... macros would come in handy here!
    const exec = (type, waitForOptions, container) => {
        const methodName = `${type}${selection.query === 'ByBoundAttribute'
            ? `By${selection.attribute}`
            : selection.query}`;
        const args = [
            selection.matcher,
            selection.options,
            ...(waitForOptions ? [waitForOptions] : []),
        ];
        if (container) {
            // @ts-ignore
            return DomQueries[methodName](container, ...args);
        }
        // @ts-ignore
        return screen[methodName](...args);
    };
    return {
        get: (container) => exec('get', undefined, container),
        getAll: (container) => exec('getAll', undefined, container),
        find: (container, waitForOptions) => exec('find', waitForOptions, container),
        findAll: (container, waitForOptions) => exec('findAll', waitForOptions, container),
        query: (container) => exec('query', undefined, container),
        queryAll: (container) => exec('queryAll', undefined, container),
    };
}
export function byRole(role, options) {
    return makeRTLSelector({ query: 'ByRole', matcher: role, options });
}
export function byText(id, options) {
    return makeRTLSelector({ query: 'ByText', matcher: id, options });
}
export function byBoundAttribute(attribute, id, options) {
    return makeRTLSelector({
        query: 'ByBoundAttribute',
        attribute,
        matcher: id,
        options,
    });
}
export function byLabelText(id, options) {
    return makeRTLSelector({ query: 'ByLabelText', matcher: id, options });
}
export function byAltText(id, options) {
    return byBoundAttribute('AltText', id, options);
}
export function byDisplayValue(id, options) {
    return byBoundAttribute('DisplayValue', id, options);
}
export function byTestId(id, options) {
    return byBoundAttribute('TestId', id, options);
}
export function byPlaceholderText(id, options) {
    return byBoundAttribute('PlaceholderText', id, options);
}
export function byTitle(id, options) {
    return byBoundAttribute('Title', id, options);
}
//# sourceMappingURL=data:application/json;base64,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