"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Config = void 0;
const render_1 = require("@betterer/render");
const EditConfig_1 = require("./EditConfig");
const Config = function Config({ context, editField }) {
    const [filters, setFilters] = (0, render_1.useState)(serialiseFilters(context.config));
    const [ignores, setIgnores] = (0, render_1.useState)(serialiseIgnores(context.config));
    function updateFilters(newFilters) {
        setFilters(newFilters);
        try {
            const validated = deserialiseFilters(newFilters);
            return [validated, null];
        }
        catch (error) {
            return [null, error];
        }
    }
    function submitFilters(filters) {
        return context.options({ filters });
    }
    function updateIgnores(newIgnores) {
        setIgnores(newIgnores);
        try {
            const validated = deserialiseIgnores(newIgnores);
            return [validated, null];
        }
        catch (error) {
            return [null, error];
        }
    }
    function submitIgnores(ignores) {
        return context.options({ ignores });
    }
    return (render_1.React.createElement(render_1.Box, { flexDirection: "column", marginBottom: 1 },
        editField == null && (render_1.React.createElement(render_1.React.Fragment, null,
            render_1.React.createElement(render_1.Box, null,
                render_1.React.createElement(render_1.Text, { color: "yellowBright" }, "Filters"),
                render_1.React.createElement(render_1.Text, null, " (press \"f\" to edit)"),
                render_1.React.createElement(render_1.Text, { color: "yellowBright" }, ": "),
                filters.length ? render_1.React.createElement(render_1.Text, null, filters) : render_1.React.createElement(render_1.Text, { color: "gray" }, "No current filter patterns")),
            render_1.React.createElement(render_1.Box, null,
                render_1.React.createElement(render_1.Text, { color: "yellowBright" }, "Ignores"),
                render_1.React.createElement(render_1.Text, null, " (press \"i\" to edit)"),
                render_1.React.createElement(render_1.Text, { color: "yellowBright" }, ": "),
                ignores.length ? render_1.React.createElement(render_1.Text, null, ignores) : render_1.React.createElement(render_1.Text, { color: "gray" }, "No current ignore patterns")))),
        editField == 'filters' && (render_1.React.createElement(EditConfig_1.EditConfig, { name: "Filters", value: filters, onChange: updateFilters, onSubmit: submitFilters }, "Use RegExp patterns e.g. /my test/. Use \",\" to separate multiple filters.")),
        editField == 'ignores' && (render_1.React.createElement(EditConfig_1.EditConfig, { name: "Ignores", value: ignores, onChange: updateIgnores, onSubmit: submitIgnores }, "Use glob patterns starting from CWD e.g. **/*.ts. Use \",\" to separate multiple ignores."))));
};
exports.Config = Config;
function serialiseFilters(config) {
    return config.filters.map((filter) => `/${filter.source}/`).join(', ');
}
function serialiseIgnores(config) {
    return config.ignores.join(', ');
}
function deserialiseFilters(filters) {
    if (filters === '') {
        return [];
    }
    return filters.split(',').map((filter) => new RegExp(filter.replace(/^\//, '').replace(/\/$/, ''), 'i'));
}
function deserialiseIgnores(ignores) {
    return ignores.split(',').map((ignore) => ignore.trim());
}
//# sourceMappingURL=Config.js.map