import { IObject } from "@daybrush/utils";
import { PROPERTIES, METHODS } from "./consts";
import Selecto from "./Selecto";
import { OnDragStart as OnParentDragStart, OnDrag as OnParentDrag, OnDragEnd as OnParentDragEnd } from "gesto";
import { DragScrollOptions } from "@scena/dragscroll";
export interface SelectoOptions {
    container: HTMLElement | null;
    rootContainer: HTMLElement | null;
    dragContainer: Element | Window | Element[] | string;
    selectableTargets: Array<HTMLElement | string>;
    selectFromInside: boolean;
    selectByClick: boolean;
    preventDragFromInside: boolean;
    clickBySelectEnd: boolean;
    continueSelect: boolean;
    continueSelectWithoutDeselect: boolean;
    toggleContinueSelect: string[][] | string[] | string | null;
    keyContainer: Document | HTMLElement | Window | null;
    hitRate: number | string;
    boundContainer: BoundContainer | boolean | HTMLElement | string | null;
    scrollOptions: DragScrollOptions;
    checkInput: boolean;
    preventDefault: boolean;
    cspNonce: string;
    ratio: number;
    getElementRect: getElementRectFunction;
    dragCondition: ((e: OnParentDragStart) => boolean) | null;
    portalContainer: HTMLElement | null;
}
export interface BoundContainer {
    element: HTMLElement | string | boolean;
    left?: boolean;
    top?: boolean;
    right?: boolean;
    bottom?: boolean;
}
export interface Hypertext {
    tag: string;
    className: string;
    style: IObject<any>;
    attributes: object;
    children: Hypertext[];
}
export interface Rect {
    top: number;
    left: number;
    bottom: number;
    right: number;
    width: number;
    height: number;
}
export interface Point {
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
}
export interface CurrentTarget<T = Selecto> {
    currentTarget: T;
}
export interface OnSelect<T = Selecto> extends CurrentTarget<T> {
    selected: Array<HTMLElement | SVGElement>;
    added: Array<HTMLElement | SVGElement>;
    removed: Array<HTMLElement | SVGElement>;
    rect: Rect;
    inputEvent: any;
}
export interface OnSelectEnd<T = Selecto> extends OnSelect<T>, CurrentTarget<T> {
    afterAdded: Array<HTMLElement | SVGElement>;
    afterRemoved: Array<HTMLElement | SVGElement>;
    isDragStart: boolean;
    isClick: boolean;
    isDouble: boolean;
}
export interface OnDragEvent {
    datas: IObject<any>;
    clientX: number;
    clientY: number;
    deltaX: number;
    deltaY: number;
    distX: number;
    distY: number;
    isClick?: boolean;
    isDouble?: boolean;
    inputEvent: any;
}
export interface OnKeyEvent<T = Selecto> extends CurrentTarget<T> {
}
export interface OnScroll {
    container: HTMLElement;
    direction: number[];
}
export interface OnDragStart<T = Selecto> extends OnParentDragStart<T> {
    stop(): void;
}
export interface OnDrag<T = Selecto> extends OnParentDrag<T> {
    rect: Rect;
    isSelect: boolean;
}
export interface OnDragEnd<T = Selecto> extends OnParentDragEnd<T> {
    rect: Rect;
    isSelect: boolean;
}
export interface SelectoEvents {
    dragStart: OnDragStart;
    drag: OnDrag;
    dragEnd: OnDragEnd;
    selectStart: OnSelect;
    select: OnSelect;
    selectEnd: OnSelectEnd;
    keydown: OnKeyEvent;
    keyup: OnKeyEvent;
    scroll: OnScroll;
}
export declare type SelectoProperties = {
    [P in typeof PROPERTIES[number]]: SelectoOptions[P];
};
export declare type SelectoMethods = {
    [P in typeof METHODS[number]]: Selecto[P];
};
export declare type getElementRectFunction = (el: HTMLElement | SVGElement) => PointArea;
export interface PointArea {
    pos1: number[];
    pos2: number[];
    pos3: number[];
    pos4: number[];
}
