"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.write = exports.forceRelativePaths = void 0;
const tslib_1 = require("tslib");
const errors_1 = require("@betterer/errors");
const path_1 = (0, tslib_1.__importDefault)(require("path"));
const fs_1 = require("fs");
const utils_1 = require("../utils");
function forceRelativePaths(toWrite, basePath) {
    const directory = `${(0, utils_1.normalisedPath)(path_1.default.dirname(basePath))}/`;
    return toWrite.replace(new RegExp(directory, 'g'), '');
}
exports.forceRelativePaths = forceRelativePaths;
async function write(toWrite, filePath) {
    try {
        await fs_1.promises.mkdir(path_1.default.dirname(filePath), { recursive: true });
        await fs_1.promises.writeFile(filePath, toWrite, 'utf8');
    }
    catch (_a) {
        throw new errors_1.BettererError(`could not write to "${filePath}". 😔`);
    }
}
exports.write = write;
//# sourceMappingURL=writer.js.map