import { BettererTestBase, BettererTestConfig, BettererTestConstraint, BettererTestDeadline, BettererTestGoal, BettererTestOptions } from './types';
/**
 * @public The main interface to the **Betterer** {@link https://phenomnomnominal.github.io/betterer/docs/tests | test system}.
 *
 * @example
 * ```typescript
 * import { BettererTest } from '@betterer/betterer';
 * import { smaller } from '@betterer/constraints';
 * import glob from 'glob';
 *
 * const test = new BettererTest({
 *   test: () => glob.sync('**\/*').length,
 *   constraint: smaller
 * });
 * ```
 *
 * @param options - The options that define the test.
 */
export declare class BettererTest<DeserialisedType, SerialisedType = DeserialisedType, DiffType = null> implements BettererTestBase<DeserialisedType, SerialisedType, DiffType> {
    /**
     * The complete configuration for the test.
     */
    readonly config: BettererTestConfig<DeserialisedType, SerialisedType, DiffType>;
    private _isOnly;
    private _isSkipped;
    constructor(options: BettererTestOptions<DeserialisedType, SerialisedType, DiffType>);
    /**
     * When `true`, all other tests will be skipped. Calling `only()` will set this to `true`.
     */
    get isOnly(): boolean;
    /**
     * When `true`, this test will be skipped. Calling `skip()` will set this to `true`.
     */
    get isSkipped(): boolean;
    /**
     * Override the constraint in the test configuration.
     *
     * @param constraintOverride - The new constraint for the test.
     * @returns This {@link @betterer/betterer#BettererTest | `BettererTest`}, so it is chainable.
     */
    constraint(constraintOverride: BettererTestConstraint<DeserialisedType>): this;
    /**
     * Override the deadline in the test configuration.
     *
     * @param deadlineOverride - The new deadline for the test.
     * @returns This {@link @betterer/betterer#BettererTest | `BettererTest`}, so it is chainable.
     */
    deadline(deadlineOverride: BettererTestDeadline): this;
    /**
     * Override the goal in the test configuration.
     *
     * @param goalOverride - The new goal for the test.
     * @returns This {@link @betterer/betterer#BettererTest | `BettererTest`}, so it is chainable.
     */
    goal(goalOverride: BettererTestGoal<DeserialisedType>): this;
    /**
     * Run only this test. All other tests will be marked as skipped.
     *
     * @returns This {@link @betterer/betterer#BettererTest | `BettererTest`}, so it is chainable.
     */
    only(): this;
    /**
     * Skip this test.
     *
     * @returns This {@link @betterer/betterer#BettererTest | `BettererTest`}, so it is chainable.
     */
    skip(): this;
}
export declare function isBettererTest(test: unknown): test is BettererTestBase;
//# sourceMappingURL=test.d.ts.map