/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.31.1(337587859b1c171314b40503171188b6cea6a32a)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/typescript/tsMode",[],()=>{
var moduleExports = (() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __require = /* @__PURE__ */ ((x) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x, {
    get: (a, b) => (typeof require !== "undefined" ? require : a)[b]
  }) : x)(function(x) {
    if (typeof require !== "undefined")
      return require.apply(this, arguments);
    throw new Error('Dynamic require of "' + x + '" is not supported');
  });
  var __commonJS = (cb, mod) => function __require2() {
    return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __reExport = (target, module, desc) => {
    if (module && typeof module === "object" || typeof module === "function") {
      for (let key of __getOwnPropNames(module))
        if (!__hasOwnProp.call(target, key) && key !== "default")
          __defProp(target, key, { get: () => module[key], enumerable: !(desc = __getOwnPropDesc(module, key)) || desc.enumerable });
    }
    return target;
  };
  var __toModule = (module) => {
    return __reExport(__markAsModule(__defProp(module != null ? __create(__getProtoOf(module)) : {}, "default", module && module.__esModule && "default" in module ? { get: () => module.default, enumerable: true } : { value: module, enumerable: true })), module);
  };

  // build/fillers/monaco-editor-core-amd.ts
  var require_monaco_editor_core_amd = __commonJS({
    "build/fillers/monaco-editor-core-amd.ts"(exports, module) {
      module.exports = self.monaco;
    }
  });

  // src/typescript/tsMode.ts
  var tsMode_exports = {};
  __export(tsMode_exports, {
    getJavaScriptWorker: () => getJavaScriptWorker2,
    getTypeScriptWorker: () => getTypeScriptWorker2,
    setupJavaScript: () => setupJavaScript,
    setupTypeScript: () => setupTypeScript
  });

  // src/fillers/monaco-editor-core.ts
  var monaco_editor_core_exports = {};
  __markAsModule(monaco_editor_core_exports);
  __reExport(monaco_editor_core_exports, __toModule(require_monaco_editor_core_amd()));

  // src/typescript/workerManager.ts
  var WorkerManager = class {
    constructor(modeId, defaults) {
      this._modeId = modeId;
      this._defaults = defaults;
      this._worker = null;
      this._client = null;
      this._configChangeListener = this._defaults.onDidChange(() => this._stopWorker());
      this._updateExtraLibsToken = 0;
      this._extraLibsChangeListener = this._defaults.onDidExtraLibsChange(() => this._updateExtraLibs());
    }
    _stopWorker() {
      if (this._worker) {
        this._worker.dispose();
        this._worker = null;
      }
      this._client = null;
    }
    dispose() {
      this._configChangeListener.dispose();
      this._extraLibsChangeListener.dispose();
      this._stopWorker();
    }
    async _updateExtraLibs() {
      if (!this._worker) {
        return;
      }
      const myToken = ++this._updateExtraLibsToken;
      const proxy = await this._worker.getProxy();
      if (this._updateExtraLibsToken !== myToken) {
        return;
      }
      proxy.updateExtraLibs(this._defaults.getExtraLibs());
    }
    _getClient() {
      if (!this._client) {
        this._worker = monaco_editor_core_exports.editor.createWebWorker({
          moduleId: "vs/language/typescript/tsWorker",
          label: this._modeId,
          keepIdleModels: true,
          createData: {
            compilerOptions: this._defaults.getCompilerOptions(),
            extraLibs: this._defaults.getExtraLibs(),
            customWorkerPath: this._defaults.workerOptions.customWorkerPath,
            inlayHintsOptions: this._defaults.inlayHintsOptions
          }
        });
        let p = this._worker.getProxy();
        if (this._defaults.getEagerModelSync()) {
          p = p.then((worker) => {
            if (this._worker) {
              return this._worker.withSyncedResources(monaco_editor_core_exports.editor.getModels().filter((model) => model.getLanguageId() === this._modeId).map((model) => model.uri));
            }
            return worker;
          });
        }
        this._client = p;
      }
      return this._client;
    }
    getLanguageServiceWorker(...resources) {
      let _client;
      return this._getClient().then((client) => {
        _client = client;
      }).then((_) => {
        if (this._worker) {
          return this._worker.withSyncedResources(resources);
        }
      }).then((_) => _client);
    }
  };

  // src/typescript/lib/typescriptServicesMetadata.ts
  var typescriptVersion = "4.4.4";

  // src/typescript/monaco.contribution.ts
  var ModuleKind;
  (function(ModuleKind2) {
    ModuleKind2[ModuleKind2["None"] = 0] = "None";
    ModuleKind2[ModuleKind2["CommonJS"] = 1] = "CommonJS";
    ModuleKind2[ModuleKind2["AMD"] = 2] = "AMD";
    ModuleKind2[ModuleKind2["UMD"] = 3] = "UMD";
    ModuleKind2[ModuleKind2["System"] = 4] = "System";
    ModuleKind2[ModuleKind2["ES2015"] = 5] = "ES2015";
    ModuleKind2[ModuleKind2["ESNext"] = 99] = "ESNext";
  })(ModuleKind || (ModuleKind = {}));
  var JsxEmit;
  (function(JsxEmit2) {
    JsxEmit2[JsxEmit2["None"] = 0] = "None";
    JsxEmit2[JsxEmit2["Preserve"] = 1] = "Preserve";
    JsxEmit2[JsxEmit2["React"] = 2] = "React";
    JsxEmit2[JsxEmit2["ReactNative"] = 3] = "ReactNative";
    JsxEmit2[JsxEmit2["ReactJSX"] = 4] = "ReactJSX";
    JsxEmit2[JsxEmit2["ReactJSXDev"] = 5] = "ReactJSXDev";
  })(JsxEmit || (JsxEmit = {}));
  var NewLineKind;
  (function(NewLineKind2) {
    NewLineKind2[NewLineKind2["CarriageReturnLineFeed"] = 0] = "CarriageReturnLineFeed";
    NewLineKind2[NewLineKind2["LineFeed"] = 1] = "LineFeed";
  })(NewLineKind || (NewLineKind = {}));
  var ScriptTarget;
  (function(ScriptTarget2) {
    ScriptTarget2[ScriptTarget2["ES3"] = 0] = "ES3";
    ScriptTarget2[ScriptTarget2["ES5"] = 1] = "ES5";
    ScriptTarget2[ScriptTarget2["ES2015"] = 2] = "ES2015";
    ScriptTarget2[ScriptTarget2["ES2016"] = 3] = "ES2016";
    ScriptTarget2[ScriptTarget2["ES2017"] = 4] = "ES2017";
    ScriptTarget2[ScriptTarget2["ES2018"] = 5] = "ES2018";
    ScriptTarget2[ScriptTarget2["ES2019"] = 6] = "ES2019";
    ScriptTarget2[ScriptTarget2["ES2020"] = 7] = "ES2020";
    ScriptTarget2[ScriptTarget2["ESNext"] = 99] = "ESNext";
    ScriptTarget2[ScriptTarget2["JSON"] = 100] = "JSON";
    ScriptTarget2[ScriptTarget2["Latest"] = 99] = "Latest";
  })(ScriptTarget || (ScriptTarget = {}));
  var ModuleResolutionKind;
  (function(ModuleResolutionKind2) {
    ModuleResolutionKind2[ModuleResolutionKind2["Classic"] = 1] = "Classic";
    ModuleResolutionKind2[ModuleResolutionKind2["NodeJs"] = 2] = "NodeJs";
  })(ModuleResolutionKind || (ModuleResolutionKind = {}));
  var LanguageServiceDefaultsImpl = class {
    constructor(compilerOptions, diagnosticsOptions, workerOptions, inlayHintsOptions) {
      this._onDidChange = new monaco_editor_core_exports.Emitter();
      this._onDidExtraLibsChange = new monaco_editor_core_exports.Emitter();
      this._extraLibs = Object.create(null);
      this._removedExtraLibs = Object.create(null);
      this._eagerModelSync = false;
      this.setCompilerOptions(compilerOptions);
      this.setDiagnosticsOptions(diagnosticsOptions);
      this.setWorkerOptions(workerOptions);
      this.setInlayHintsOptions(inlayHintsOptions);
      this._onDidExtraLibsChangeTimeout = -1;
    }
    get onDidChange() {
      return this._onDidChange.event;
    }
    get onDidExtraLibsChange() {
      return this._onDidExtraLibsChange.event;
    }
    get workerOptions() {
      return this._workerOptions;
    }
    get inlayHintsOptions() {
      return this._inlayHintsOptions;
    }
    getExtraLibs() {
      return this._extraLibs;
    }
    addExtraLib(content, _filePath) {
      let filePath;
      if (typeof _filePath === "undefined") {
        filePath = `ts:extralib-${Math.random().toString(36).substring(2, 15)}`;
      } else {
        filePath = _filePath;
      }
      if (this._extraLibs[filePath] && this._extraLibs[filePath].content === content) {
        return {
          dispose: () => {
          }
        };
      }
      let myVersion = 1;
      if (this._removedExtraLibs[filePath]) {
        myVersion = this._removedExtraLibs[filePath] + 1;
      }
      if (this._extraLibs[filePath]) {
        myVersion = this._extraLibs[filePath].version + 1;
      }
      this._extraLibs[filePath] = {
        content,
        version: myVersion
      };
      this._fireOnDidExtraLibsChangeSoon();
      return {
        dispose: () => {
          let extraLib = this._extraLibs[filePath];
          if (!extraLib) {
            return;
          }
          if (extraLib.version !== myVersion) {
            return;
          }
          delete this._extraLibs[filePath];
          this._removedExtraLibs[filePath] = myVersion;
          this._fireOnDidExtraLibsChangeSoon();
        }
      };
    }
    setExtraLibs(libs) {
      for (const filePath in this._extraLibs) {
        this._removedExtraLibs[filePath] = this._extraLibs[filePath].version;
      }
      this._extraLibs = Object.create(null);
      if (libs && libs.length > 0) {
        for (const lib of libs) {
          const filePath = lib.filePath || `ts:extralib-${Math.random().toString(36).substring(2, 15)}`;
          const content = lib.content;
          let myVersion = 1;
          if (this._removedExtraLibs[filePath]) {
            myVersion = this._removedExtraLibs[filePath] + 1;
          }
          this._extraLibs[filePath] = {
            content,
            version: myVersion
          };
        }
      }
      this._fireOnDidExtraLibsChangeSoon();
    }
    _fireOnDidExtraLibsChangeSoon() {
      if (this._onDidExtraLibsChangeTimeout !== -1) {
        return;
      }
      this._onDidExtraLibsChangeTimeout = window.setTimeout(() => {
        this._onDidExtraLibsChangeTimeout = -1;
        this._onDidExtraLibsChange.fire(void 0);
      }, 0);
    }
    getCompilerOptions() {
      return this._compilerOptions;
    }
    setCompilerOptions(options) {
      this._compilerOptions = options || Object.create(null);
      this._onDidChange.fire(void 0);
    }
    getDiagnosticsOptions() {
      return this._diagnosticsOptions;
    }
    setDiagnosticsOptions(options) {
      this._diagnosticsOptions = options || Object.create(null);
      this._onDidChange.fire(void 0);
    }
    setWorkerOptions(options) {
      this._workerOptions = options || Object.create(null);
      this._onDidChange.fire(void 0);
    }
    setInlayHintsOptions(options) {
      this._inlayHintsOptions = options || Object.create(null);
      this._onDidChange.fire(void 0);
    }
    setMaximumWorkerIdleTime(value) {
    }
    setEagerModelSync(value) {
      this._eagerModelSync = value;
    }
    getEagerModelSync() {
      return this._eagerModelSync;
    }
  };
  var typescriptVersion2 = typescriptVersion;
  var typescriptDefaults = new LanguageServiceDefaultsImpl({ allowNonTsExtensions: true, target: 99 }, { noSemanticValidation: false, noSyntaxValidation: false, onlyVisible: false }, {}, {});
  var javascriptDefaults = new LanguageServiceDefaultsImpl({ allowNonTsExtensions: true, allowJs: true, target: 99 }, { noSemanticValidation: true, noSyntaxValidation: false, onlyVisible: false }, {}, {});
  var getTypeScriptWorker = () => {
    return getMode().then((mode) => mode.getTypeScriptWorker());
  };
  var getJavaScriptWorker = () => {
    return getMode().then((mode) => mode.getJavaScriptWorker());
  };
  monaco_editor_core_exports.languages.typescript = {
    ModuleKind,
    JsxEmit,
    NewLineKind,
    ScriptTarget,
    ModuleResolutionKind,
    typescriptVersion: typescriptVersion2,
    typescriptDefaults,
    javascriptDefaults,
    getTypeScriptWorker,
    getJavaScriptWorker
  };
  function getMode() {
    if (true) {
      return new Promise((resolve, reject) => {
        __require(["vs/language/typescript/tsMode"], resolve, reject);
      });
    } else {
      return null;
    }
  }
  monaco_editor_core_exports.languages.onLanguage("typescript", () => {
    return getMode().then((mode) => mode.setupTypeScript(typescriptDefaults));
  });
  monaco_editor_core_exports.languages.onLanguage("javascript", () => {
    return getMode().then((mode) => mode.setupJavaScript(javascriptDefaults));
  });

  // src/typescript/lib/lib.index.ts
  var libFileSet = {};
  libFileSet["lib.d.ts"] = true;
  libFileSet["lib.dom.d.ts"] = true;
  libFileSet["lib.dom.iterable.d.ts"] = true;
  libFileSet["lib.es2015.collection.d.ts"] = true;
  libFileSet["lib.es2015.core.d.ts"] = true;
  libFileSet["lib.es2015.d.ts"] = true;
  libFileSet["lib.es2015.generator.d.ts"] = true;
  libFileSet["lib.es2015.iterable.d.ts"] = true;
  libFileSet["lib.es2015.promise.d.ts"] = true;
  libFileSet["lib.es2015.proxy.d.ts"] = true;
  libFileSet["lib.es2015.reflect.d.ts"] = true;
  libFileSet["lib.es2015.symbol.d.ts"] = true;
  libFileSet["lib.es2015.symbol.wellknown.d.ts"] = true;
  libFileSet["lib.es2016.array.include.d.ts"] = true;
  libFileSet["lib.es2016.d.ts"] = true;
  libFileSet["lib.es2016.full.d.ts"] = true;
  libFileSet["lib.es2017.d.ts"] = true;
  libFileSet["lib.es2017.full.d.ts"] = true;
  libFileSet["lib.es2017.intl.d.ts"] = true;
  libFileSet["lib.es2017.object.d.ts"] = true;
  libFileSet["lib.es2017.sharedmemory.d.ts"] = true;
  libFileSet["lib.es2017.string.d.ts"] = true;
  libFileSet["lib.es2017.typedarrays.d.ts"] = true;
  libFileSet["lib.es2018.asyncgenerator.d.ts"] = true;
  libFileSet["lib.es2018.asynciterable.d.ts"] = true;
  libFileSet["lib.es2018.d.ts"] = true;
  libFileSet["lib.es2018.full.d.ts"] = true;
  libFileSet["lib.es2018.intl.d.ts"] = true;
  libFileSet["lib.es2018.promise.d.ts"] = true;
  libFileSet["lib.es2018.regexp.d.ts"] = true;
  libFileSet["lib.es2019.array.d.ts"] = true;
  libFileSet["lib.es2019.d.ts"] = true;
  libFileSet["lib.es2019.full.d.ts"] = true;
  libFileSet["lib.es2019.object.d.ts"] = true;
  libFileSet["lib.es2019.string.d.ts"] = true;
  libFileSet["lib.es2019.symbol.d.ts"] = true;
  libFileSet["lib.es2020.bigint.d.ts"] = true;
  libFileSet["lib.es2020.d.ts"] = true;
  libFileSet["lib.es2020.full.d.ts"] = true;
  libFileSet["lib.es2020.intl.d.ts"] = true;
  libFileSet["lib.es2020.promise.d.ts"] = true;
  libFileSet["lib.es2020.sharedmemory.d.ts"] = true;
  libFileSet["lib.es2020.string.d.ts"] = true;
  libFileSet["lib.es2020.symbol.wellknown.d.ts"] = true;
  libFileSet["lib.es2021.d.ts"] = true;
  libFileSet["lib.es2021.full.d.ts"] = true;
  libFileSet["lib.es2021.promise.d.ts"] = true;
  libFileSet["lib.es2021.string.d.ts"] = true;
  libFileSet["lib.es2021.weakref.d.ts"] = true;
  libFileSet["lib.es5.d.ts"] = true;
  libFileSet["lib.es6.d.ts"] = true;
  libFileSet["lib.esnext.d.ts"] = true;
  libFileSet["lib.esnext.full.d.ts"] = true;
  libFileSet["lib.esnext.intl.d.ts"] = true;
  libFileSet["lib.esnext.promise.d.ts"] = true;
  libFileSet["lib.esnext.string.d.ts"] = true;
  libFileSet["lib.esnext.weakref.d.ts"] = true;
  libFileSet["lib.scripthost.d.ts"] = true;
  libFileSet["lib.webworker.d.ts"] = true;
  libFileSet["lib.webworker.importscripts.d.ts"] = true;
  libFileSet["lib.webworker.iterable.d.ts"] = true;

  // src/typescript/languageFeatures.ts
  var IndentStyle;
  (function(IndentStyle2) {
    IndentStyle2[IndentStyle2["None"] = 0] = "None";
    IndentStyle2[IndentStyle2["Block"] = 1] = "Block";
    IndentStyle2[IndentStyle2["Smart"] = 2] = "Smart";
  })(IndentStyle || (IndentStyle = {}));
  function flattenDiagnosticMessageText(diag, newLine, indent = 0) {
    if (typeof diag === "string") {
      return diag;
    } else if (diag === void 0) {
      return "";
    }
    let result = "";
    if (indent) {
      result += newLine;
      for (let i = 0; i < indent; i++) {
        result += "  ";
      }
    }
    result += diag.messageText;
    indent++;
    if (diag.next) {
      for (const kid of diag.next) {
        result += flattenDiagnosticMessageText(kid, newLine, indent);
      }
    }
    return result;
  }
  function displayPartsToString(displayParts) {
    if (displayParts) {
      return displayParts.map((displayPart) => displayPart.text).join("");
    }
    return "";
  }
  var Adapter = class {
    constructor(_worker) {
      this._worker = _worker;
    }
    _textSpanToRange(model, span) {
      let p1 = model.getPositionAt(span.start);
      let p2 = model.getPositionAt(span.start + span.length);
      let { lineNumber: startLineNumber, column: startColumn } = p1;
      let { lineNumber: endLineNumber, column: endColumn } = p2;
      return { startLineNumber, startColumn, endLineNumber, endColumn };
    }
  };
  var LibFiles = class {
    constructor(_worker) {
      this._worker = _worker;
      this._libFiles = {};
      this._hasFetchedLibFiles = false;
      this._fetchLibFilesPromise = null;
    }
    isLibFile(uri) {
      if (!uri) {
        return false;
      }
      if (uri.path.indexOf("/lib.") === 0) {
        return !!libFileSet[uri.path.slice(1)];
      }
      return false;
    }
    getOrCreateModel(fileName) {
      const uri = monaco_editor_core_exports.Uri.parse(fileName);
      const model = monaco_editor_core_exports.editor.getModel(uri);
      if (model) {
        return model;
      }
      if (this.isLibFile(uri) && this._hasFetchedLibFiles) {
        return monaco_editor_core_exports.editor.createModel(this._libFiles[uri.path.slice(1)], "typescript", uri);
      }
      const matchedLibFile = typescriptDefaults.getExtraLibs()[fileName];
      if (matchedLibFile) {
        return monaco_editor_core_exports.editor.createModel(matchedLibFile.content, "typescript", uri);
      }
      return null;
    }
    _containsLibFile(uris) {
      for (let uri of uris) {
        if (this.isLibFile(uri)) {
          return true;
        }
      }
      return false;
    }
    async fetchLibFilesIfNecessary(uris) {
      if (!this._containsLibFile(uris)) {
        return;
      }
      await this._fetchLibFiles();
    }
    _fetchLibFiles() {
      if (!this._fetchLibFilesPromise) {
        this._fetchLibFilesPromise = this._worker().then((w) => w.getLibFiles()).then((libFiles) => {
          this._hasFetchedLibFiles = true;
          this._libFiles = libFiles;
        });
      }
      return this._fetchLibFilesPromise;
    }
  };
  var DiagnosticCategory;
  (function(DiagnosticCategory2) {
    DiagnosticCategory2[DiagnosticCategory2["Warning"] = 0] = "Warning";
    DiagnosticCategory2[DiagnosticCategory2["Error"] = 1] = "Error";
    DiagnosticCategory2[DiagnosticCategory2["Suggestion"] = 2] = "Suggestion";
    DiagnosticCategory2[DiagnosticCategory2["Message"] = 3] = "Message";
  })(DiagnosticCategory || (DiagnosticCategory = {}));
  var DiagnosticsAdapter = class extends Adapter {
    constructor(_libFiles, _defaults, _selector, worker) {
      super(worker);
      this._libFiles = _libFiles;
      this._defaults = _defaults;
      this._selector = _selector;
      this._disposables = [];
      this._listener = Object.create(null);
      const onModelAdd = (model) => {
        if (model.getLanguageId() !== _selector) {
          return;
        }
        const maybeValidate = () => {
          const { onlyVisible } = this._defaults.getDiagnosticsOptions();
          if (onlyVisible) {
            if (model.isAttachedToEditor()) {
              this._doValidate(model);
            }
          } else {
            this._doValidate(model);
          }
        };
        let handle;
        const changeSubscription = model.onDidChangeContent(() => {
          clearTimeout(handle);
          handle = window.setTimeout(maybeValidate, 500);
        });
        const visibleSubscription = model.onDidChangeAttached(() => {
          const { onlyVisible } = this._defaults.getDiagnosticsOptions();
          if (onlyVisible) {
            if (model.isAttachedToEditor()) {
              maybeValidate();
            } else {
              monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, []);
            }
          }
        });
        this._listener[model.uri.toString()] = {
          dispose() {
            changeSubscription.dispose();
            visibleSubscription.dispose();
            clearTimeout(handle);
          }
        };
        maybeValidate();
      };
      const onModelRemoved = (model) => {
        monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, []);
        const key = model.uri.toString();
        if (this._listener[key]) {
          this._listener[key].dispose();
          delete this._listener[key];
        }
      };
      this._disposables.push(monaco_editor_core_exports.editor.onDidCreateModel((model) => onModelAdd(model)));
      this._disposables.push(monaco_editor_core_exports.editor.onWillDisposeModel(onModelRemoved));
      this._disposables.push(monaco_editor_core_exports.editor.onDidChangeModelLanguage((event) => {
        onModelRemoved(event.model);
        onModelAdd(event.model);
      }));
      this._disposables.push({
        dispose() {
          for (const model of monaco_editor_core_exports.editor.getModels()) {
            onModelRemoved(model);
          }
        }
      });
      const recomputeDiagostics = () => {
        for (const model of monaco_editor_core_exports.editor.getModels()) {
          onModelRemoved(model);
          onModelAdd(model);
        }
      };
      this._disposables.push(this._defaults.onDidChange(recomputeDiagostics));
      this._disposables.push(this._defaults.onDidExtraLibsChange(recomputeDiagostics));
      monaco_editor_core_exports.editor.getModels().forEach((model) => onModelAdd(model));
    }
    dispose() {
      this._disposables.forEach((d) => d && d.dispose());
      this._disposables = [];
    }
    async _doValidate(model) {
      const worker = await this._worker(model.uri);
      if (model.isDisposed()) {
        return;
      }
      const promises = [];
      const { noSyntaxValidation, noSemanticValidation, noSuggestionDiagnostics } = this._defaults.getDiagnosticsOptions();
      if (!noSyntaxValidation) {
        promises.push(worker.getSyntacticDiagnostics(model.uri.toString()));
      }
      if (!noSemanticValidation) {
        promises.push(worker.getSemanticDiagnostics(model.uri.toString()));
      }
      if (!noSuggestionDiagnostics) {
        promises.push(worker.getSuggestionDiagnostics(model.uri.toString()));
      }
      const allDiagnostics = await Promise.all(promises);
      if (!allDiagnostics || model.isDisposed()) {
        return;
      }
      const diagnostics = allDiagnostics.reduce((p, c) => c.concat(p), []).filter((d) => (this._defaults.getDiagnosticsOptions().diagnosticCodesToIgnore || []).indexOf(d.code) === -1);
      const relatedUris = diagnostics.map((d) => d.relatedInformation || []).reduce((p, c) => c.concat(p), []).map((relatedInformation) => relatedInformation.file ? monaco_editor_core_exports.Uri.parse(relatedInformation.file.fileName) : null);
      await this._libFiles.fetchLibFilesIfNecessary(relatedUris);
      if (model.isDisposed()) {
        return;
      }
      monaco_editor_core_exports.editor.setModelMarkers(model, this._selector, diagnostics.map((d) => this._convertDiagnostics(model, d)));
    }
    _convertDiagnostics(model, diag) {
      const diagStart = diag.start || 0;
      const diagLength = diag.length || 1;
      const { lineNumber: startLineNumber, column: startColumn } = model.getPositionAt(diagStart);
      const { lineNumber: endLineNumber, column: endColumn } = model.getPositionAt(diagStart + diagLength);
      const tags = [];
      if (diag.reportsUnnecessary) {
        tags.push(monaco_editor_core_exports.MarkerTag.Unnecessary);
      }
      if (diag.reportsDeprecated) {
        tags.push(monaco_editor_core_exports.MarkerTag.Deprecated);
      }
      return {
        severity: this._tsDiagnosticCategoryToMarkerSeverity(diag.category),
        startLineNumber,
        startColumn,
        endLineNumber,
        endColumn,
        message: flattenDiagnosticMessageText(diag.messageText, "\n"),
        code: diag.code.toString(),
        tags,
        relatedInformation: this._convertRelatedInformation(model, diag.relatedInformation)
      };
    }
    _convertRelatedInformation(model, relatedInformation) {
      if (!relatedInformation) {
        return [];
      }
      const result = [];
      relatedInformation.forEach((info) => {
        let relatedResource = model;
        if (info.file) {
          relatedResource = this._libFiles.getOrCreateModel(info.file.fileName);
        }
        if (!relatedResource) {
          return;
        }
        const infoStart = info.start || 0;
        const infoLength = info.length || 1;
        const { lineNumber: startLineNumber, column: startColumn } = relatedResource.getPositionAt(infoStart);
        const { lineNumber: endLineNumber, column: endColumn } = relatedResource.getPositionAt(infoStart + infoLength);
        result.push({
          resource: relatedResource.uri,
          startLineNumber,
          startColumn,
          endLineNumber,
          endColumn,
          message: flattenDiagnosticMessageText(info.messageText, "\n")
        });
      });
      return result;
    }
    _tsDiagnosticCategoryToMarkerSeverity(category) {
      switch (category) {
        case 1:
          return monaco_editor_core_exports.MarkerSeverity.Error;
        case 3:
          return monaco_editor_core_exports.MarkerSeverity.Info;
        case 0:
          return monaco_editor_core_exports.MarkerSeverity.Warning;
        case 2:
          return monaco_editor_core_exports.MarkerSeverity.Hint;
      }
      return monaco_editor_core_exports.MarkerSeverity.Info;
    }
  };
  var SuggestAdapter = class extends Adapter {
    get triggerCharacters() {
      return ["."];
    }
    async provideCompletionItems(model, position, _context, token) {
      const wordInfo = model.getWordUntilPosition(position);
      const wordRange = new monaco_editor_core_exports.Range(position.lineNumber, wordInfo.startColumn, position.lineNumber, wordInfo.endColumn);
      const resource = model.uri;
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const info = await worker.getCompletionsAtPosition(resource.toString(), offset);
      if (!info || model.isDisposed()) {
        return;
      }
      const suggestions = info.entries.map((entry) => {
        let range = wordRange;
        if (entry.replacementSpan) {
          const p1 = model.getPositionAt(entry.replacementSpan.start);
          const p2 = model.getPositionAt(entry.replacementSpan.start + entry.replacementSpan.length);
          range = new monaco_editor_core_exports.Range(p1.lineNumber, p1.column, p2.lineNumber, p2.column);
        }
        const tags = [];
        if (entry.kindModifiers?.indexOf("deprecated") !== -1) {
          tags.push(monaco_editor_core_exports.languages.CompletionItemTag.Deprecated);
        }
        return {
          uri: resource,
          position,
          offset,
          range,
          label: entry.name,
          insertText: entry.name,
          sortText: entry.sortText,
          kind: SuggestAdapter.convertKind(entry.kind),
          tags
        };
      });
      return {
        suggestions
      };
    }
    async resolveCompletionItem(item, token) {
      const myItem = item;
      const resource = myItem.uri;
      const position = myItem.position;
      const offset = myItem.offset;
      const worker = await this._worker(resource);
      const details = await worker.getCompletionEntryDetails(resource.toString(), offset, myItem.label);
      if (!details) {
        return myItem;
      }
      return {
        uri: resource,
        position,
        label: details.name,
        kind: SuggestAdapter.convertKind(details.kind),
        detail: displayPartsToString(details.displayParts),
        documentation: {
          value: SuggestAdapter.createDocumentationString(details)
        }
      };
    }
    static convertKind(kind) {
      switch (kind) {
        case Kind.primitiveType:
        case Kind.keyword:
          return monaco_editor_core_exports.languages.CompletionItemKind.Keyword;
        case Kind.variable:
        case Kind.localVariable:
          return monaco_editor_core_exports.languages.CompletionItemKind.Variable;
        case Kind.memberVariable:
        case Kind.memberGetAccessor:
        case Kind.memberSetAccessor:
          return monaco_editor_core_exports.languages.CompletionItemKind.Field;
        case Kind.function:
        case Kind.memberFunction:
        case Kind.constructSignature:
        case Kind.callSignature:
        case Kind.indexSignature:
          return monaco_editor_core_exports.languages.CompletionItemKind.Function;
        case Kind.enum:
          return monaco_editor_core_exports.languages.CompletionItemKind.Enum;
        case Kind.module:
          return monaco_editor_core_exports.languages.CompletionItemKind.Module;
        case Kind.class:
          return monaco_editor_core_exports.languages.CompletionItemKind.Class;
        case Kind.interface:
          return monaco_editor_core_exports.languages.CompletionItemKind.Interface;
        case Kind.warning:
          return monaco_editor_core_exports.languages.CompletionItemKind.File;
      }
      return monaco_editor_core_exports.languages.CompletionItemKind.Property;
    }
    static createDocumentationString(details) {
      let documentationString = displayPartsToString(details.documentation);
      if (details.tags) {
        for (const tag of details.tags) {
          documentationString += `

${tagToString(tag)}`;
        }
      }
      return documentationString;
    }
  };
  function tagToString(tag) {
    let tagLabel = `*@${tag.name}*`;
    if (tag.name === "param" && tag.text) {
      const [paramName, ...rest] = tag.text;
      tagLabel += `\`${paramName.text}\``;
      if (rest.length > 0)
        tagLabel += ` \u2014 ${rest.map((r) => r.text).join(" ")}`;
    } else if (Array.isArray(tag.text)) {
      tagLabel += ` \u2014 ${tag.text.map((r) => r.text).join(" ")}`;
    } else if (tag.text) {
      tagLabel += ` \u2014 ${tag.text}`;
    }
    return tagLabel;
  }
  var SignatureHelpAdapter = class extends Adapter {
    constructor() {
      super(...arguments);
      this.signatureHelpTriggerCharacters = ["(", ","];
    }
    static _toSignatureHelpTriggerReason(context) {
      switch (context.triggerKind) {
        case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.TriggerCharacter:
          if (context.triggerCharacter) {
            if (context.isRetrigger) {
              return { kind: "retrigger", triggerCharacter: context.triggerCharacter };
            } else {
              return { kind: "characterTyped", triggerCharacter: context.triggerCharacter };
            }
          } else {
            return { kind: "invoked" };
          }
        case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.ContentChange:
          return context.isRetrigger ? { kind: "retrigger" } : { kind: "invoked" };
        case monaco_editor_core_exports.languages.SignatureHelpTriggerKind.Invoke:
        default:
          return { kind: "invoked" };
      }
    }
    async provideSignatureHelp(model, position, token, context) {
      const resource = model.uri;
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const info = await worker.getSignatureHelpItems(resource.toString(), offset, {
        triggerReason: SignatureHelpAdapter._toSignatureHelpTriggerReason(context)
      });
      if (!info || model.isDisposed()) {
        return;
      }
      const ret = {
        activeSignature: info.selectedItemIndex,
        activeParameter: info.argumentIndex,
        signatures: []
      };
      info.items.forEach((item) => {
        const signature = {
          label: "",
          parameters: []
        };
        signature.documentation = {
          value: displayPartsToString(item.documentation)
        };
        signature.label += displayPartsToString(item.prefixDisplayParts);
        item.parameters.forEach((p, i, a) => {
          const label = displayPartsToString(p.displayParts);
          const parameter = {
            label,
            documentation: {
              value: displayPartsToString(p.documentation)
            }
          };
          signature.label += label;
          signature.parameters.push(parameter);
          if (i < a.length - 1) {
            signature.label += displayPartsToString(item.separatorDisplayParts);
          }
        });
        signature.label += displayPartsToString(item.suffixDisplayParts);
        ret.signatures.push(signature);
      });
      return {
        value: ret,
        dispose() {
        }
      };
    }
  };
  var QuickInfoAdapter = class extends Adapter {
    async provideHover(model, position, token) {
      const resource = model.uri;
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const info = await worker.getQuickInfoAtPosition(resource.toString(), offset);
      if (!info || model.isDisposed()) {
        return;
      }
      const documentation = displayPartsToString(info.documentation);
      const tags = info.tags ? info.tags.map((tag) => tagToString(tag)).join("  \n\n") : "";
      const contents = displayPartsToString(info.displayParts);
      return {
        range: this._textSpanToRange(model, info.textSpan),
        contents: [
          {
            value: "```typescript\n" + contents + "\n```\n"
          },
          {
            value: documentation + (tags ? "\n\n" + tags : "")
          }
        ]
      };
    }
  };
  var OccurrencesAdapter = class extends Adapter {
    async provideDocumentHighlights(model, position, token) {
      const resource = model.uri;
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const entries = await worker.getOccurrencesAtPosition(resource.toString(), offset);
      if (!entries || model.isDisposed()) {
        return;
      }
      return entries.map((entry) => {
        return {
          range: this._textSpanToRange(model, entry.textSpan),
          kind: entry.isWriteAccess ? monaco_editor_core_exports.languages.DocumentHighlightKind.Write : monaco_editor_core_exports.languages.DocumentHighlightKind.Text
        };
      });
    }
  };
  var DefinitionAdapter = class extends Adapter {
    constructor(_libFiles, worker) {
      super(worker);
      this._libFiles = _libFiles;
    }
    async provideDefinition(model, position, token) {
      const resource = model.uri;
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const entries = await worker.getDefinitionAtPosition(resource.toString(), offset);
      if (!entries || model.isDisposed()) {
        return;
      }
      await this._libFiles.fetchLibFilesIfNecessary(entries.map((entry) => monaco_editor_core_exports.Uri.parse(entry.fileName)));
      if (model.isDisposed()) {
        return;
      }
      const result = [];
      for (let entry of entries) {
        const refModel = this._libFiles.getOrCreateModel(entry.fileName);
        if (refModel) {
          result.push({
            uri: refModel.uri,
            range: this._textSpanToRange(refModel, entry.textSpan)
          });
        }
      }
      return result;
    }
  };
  var ReferenceAdapter = class extends Adapter {
    constructor(_libFiles, worker) {
      super(worker);
      this._libFiles = _libFiles;
    }
    async provideReferences(model, position, context, token) {
      const resource = model.uri;
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const entries = await worker.getReferencesAtPosition(resource.toString(), offset);
      if (!entries || model.isDisposed()) {
        return;
      }
      await this._libFiles.fetchLibFilesIfNecessary(entries.map((entry) => monaco_editor_core_exports.Uri.parse(entry.fileName)));
      if (model.isDisposed()) {
        return;
      }
      const result = [];
      for (let entry of entries) {
        const refModel = this._libFiles.getOrCreateModel(entry.fileName);
        if (refModel) {
          result.push({
            uri: refModel.uri,
            range: this._textSpanToRange(refModel, entry.textSpan)
          });
        }
      }
      return result;
    }
  };
  var OutlineAdapter = class extends Adapter {
    async provideDocumentSymbols(model, token) {
      const resource = model.uri;
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const items = await worker.getNavigationBarItems(resource.toString());
      if (!items || model.isDisposed()) {
        return;
      }
      const convert = (bucket, item, containerLabel) => {
        let result2 = {
          name: item.text,
          detail: "",
          kind: outlineTypeTable[item.kind] || monaco_editor_core_exports.languages.SymbolKind.Variable,
          range: this._textSpanToRange(model, item.spans[0]),
          selectionRange: this._textSpanToRange(model, item.spans[0]),
          tags: []
        };
        if (containerLabel)
          result2.containerName = containerLabel;
        if (item.childItems && item.childItems.length > 0) {
          for (let child of item.childItems) {
            convert(bucket, child, result2.name);
          }
        }
        bucket.push(result2);
      };
      let result = [];
      items.forEach((item) => convert(result, item));
      return result;
    }
  };
  var Kind = class {
  };
  Kind.unknown = "";
  Kind.keyword = "keyword";
  Kind.script = "script";
  Kind.module = "module";
  Kind.class = "class";
  Kind.interface = "interface";
  Kind.type = "type";
  Kind.enum = "enum";
  Kind.variable = "var";
  Kind.localVariable = "local var";
  Kind.function = "function";
  Kind.localFunction = "local function";
  Kind.memberFunction = "method";
  Kind.memberGetAccessor = "getter";
  Kind.memberSetAccessor = "setter";
  Kind.memberVariable = "property";
  Kind.constructorImplementation = "constructor";
  Kind.callSignature = "call";
  Kind.indexSignature = "index";
  Kind.constructSignature = "construct";
  Kind.parameter = "parameter";
  Kind.typeParameter = "type parameter";
  Kind.primitiveType = "primitive type";
  Kind.label = "label";
  Kind.alias = "alias";
  Kind.const = "const";
  Kind.let = "let";
  Kind.warning = "warning";
  var outlineTypeTable = Object.create(null);
  outlineTypeTable[Kind.module] = monaco_editor_core_exports.languages.SymbolKind.Module;
  outlineTypeTable[Kind.class] = monaco_editor_core_exports.languages.SymbolKind.Class;
  outlineTypeTable[Kind.enum] = monaco_editor_core_exports.languages.SymbolKind.Enum;
  outlineTypeTable[Kind.interface] = monaco_editor_core_exports.languages.SymbolKind.Interface;
  outlineTypeTable[Kind.memberFunction] = monaco_editor_core_exports.languages.SymbolKind.Method;
  outlineTypeTable[Kind.memberVariable] = monaco_editor_core_exports.languages.SymbolKind.Property;
  outlineTypeTable[Kind.memberGetAccessor] = monaco_editor_core_exports.languages.SymbolKind.Property;
  outlineTypeTable[Kind.memberSetAccessor] = monaco_editor_core_exports.languages.SymbolKind.Property;
  outlineTypeTable[Kind.variable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
  outlineTypeTable[Kind.const] = monaco_editor_core_exports.languages.SymbolKind.Variable;
  outlineTypeTable[Kind.localVariable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
  outlineTypeTable[Kind.variable] = monaco_editor_core_exports.languages.SymbolKind.Variable;
  outlineTypeTable[Kind.function] = monaco_editor_core_exports.languages.SymbolKind.Function;
  outlineTypeTable[Kind.localFunction] = monaco_editor_core_exports.languages.SymbolKind.Function;
  var FormatHelper = class extends Adapter {
    static _convertOptions(options) {
      return {
        ConvertTabsToSpaces: options.insertSpaces,
        TabSize: options.tabSize,
        IndentSize: options.tabSize,
        IndentStyle: 2,
        NewLineCharacter: "\n",
        InsertSpaceAfterCommaDelimiter: true,
        InsertSpaceAfterSemicolonInForStatements: true,
        InsertSpaceBeforeAndAfterBinaryOperators: true,
        InsertSpaceAfterKeywordsInControlFlowStatements: true,
        InsertSpaceAfterFunctionKeywordForAnonymousFunctions: true,
        InsertSpaceAfterOpeningAndBeforeClosingNonemptyParenthesis: false,
        InsertSpaceAfterOpeningAndBeforeClosingNonemptyBrackets: false,
        InsertSpaceAfterOpeningAndBeforeClosingTemplateStringBraces: false,
        PlaceOpenBraceOnNewLineForControlBlocks: false,
        PlaceOpenBraceOnNewLineForFunctions: false
      };
    }
    _convertTextChanges(model, change) {
      return {
        text: change.newText,
        range: this._textSpanToRange(model, change.span)
      };
    }
  };
  var FormatAdapter = class extends FormatHelper {
    async provideDocumentRangeFormattingEdits(model, range, options, token) {
      const resource = model.uri;
      const startOffset = model.getOffsetAt({
        lineNumber: range.startLineNumber,
        column: range.startColumn
      });
      const endOffset = model.getOffsetAt({
        lineNumber: range.endLineNumber,
        column: range.endColumn
      });
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const edits = await worker.getFormattingEditsForRange(resource.toString(), startOffset, endOffset, FormatHelper._convertOptions(options));
      if (!edits || model.isDisposed()) {
        return;
      }
      return edits.map((edit) => this._convertTextChanges(model, edit));
    }
  };
  var FormatOnTypeAdapter = class extends FormatHelper {
    get autoFormatTriggerCharacters() {
      return [";", "}", "\n"];
    }
    async provideOnTypeFormattingEdits(model, position, ch, options, token) {
      const resource = model.uri;
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const edits = await worker.getFormattingEditsAfterKeystroke(resource.toString(), offset, ch, FormatHelper._convertOptions(options));
      if (!edits || model.isDisposed()) {
        return;
      }
      return edits.map((edit) => this._convertTextChanges(model, edit));
    }
  };
  var CodeActionAdaptor = class extends FormatHelper {
    async provideCodeActions(model, range, context, token) {
      const resource = model.uri;
      const start = model.getOffsetAt({
        lineNumber: range.startLineNumber,
        column: range.startColumn
      });
      const end = model.getOffsetAt({
        lineNumber: range.endLineNumber,
        column: range.endColumn
      });
      const formatOptions = FormatHelper._convertOptions(model.getOptions());
      const errorCodes = context.markers.filter((m) => m.code).map((m) => m.code).map(Number);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const codeFixes = await worker.getCodeFixesAtPosition(resource.toString(), start, end, errorCodes, formatOptions);
      if (!codeFixes || model.isDisposed()) {
        return { actions: [], dispose: () => {
        } };
      }
      const actions = codeFixes.filter((fix) => {
        return fix.changes.filter((change) => change.isNewFile).length === 0;
      }).map((fix) => {
        return this._tsCodeFixActionToMonacoCodeAction(model, context, fix);
      });
      return {
        actions,
        dispose: () => {
        }
      };
    }
    _tsCodeFixActionToMonacoCodeAction(model, context, codeFix) {
      const edits = [];
      for (const change of codeFix.changes) {
        for (const textChange of change.textChanges) {
          edits.push({
            resource: model.uri,
            edit: {
              range: this._textSpanToRange(model, textChange.span),
              text: textChange.newText
            }
          });
        }
      }
      const action = {
        title: codeFix.description,
        edit: { edits },
        diagnostics: context.markers,
        kind: "quickfix"
      };
      return action;
    }
  };
  var RenameAdapter = class extends Adapter {
    constructor(_libFiles, worker) {
      super(worker);
      this._libFiles = _libFiles;
    }
    async provideRenameEdits(model, position, newName, token) {
      const resource = model.uri;
      const fileName = resource.toString();
      const offset = model.getOffsetAt(position);
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return;
      }
      const renameInfo = await worker.getRenameInfo(fileName, offset, {
        allowRenameOfImportPath: false
      });
      if (renameInfo.canRename === false) {
        return {
          edits: [],
          rejectReason: renameInfo.localizedErrorMessage
        };
      }
      if (renameInfo.fileToRename !== void 0) {
        throw new Error("Renaming files is not supported.");
      }
      const renameLocations = await worker.findRenameLocations(fileName, offset, false, false, false);
      if (!renameLocations || model.isDisposed()) {
        return;
      }
      const edits = [];
      for (const renameLocation of renameLocations) {
        const model2 = this._libFiles.getOrCreateModel(renameLocation.fileName);
        if (model2) {
          edits.push({
            resource: model2.uri,
            edit: {
              range: this._textSpanToRange(model2, renameLocation.textSpan),
              text: newName
            }
          });
        } else {
          throw new Error(`Unknown file ${renameLocation.fileName}.`);
        }
      }
      return { edits };
    }
  };
  var InlayHintsAdapter = class extends Adapter {
    async provideInlayHints(model, range, token) {
      const resource = model.uri;
      const fileName = resource.toString();
      const start = model.getOffsetAt({
        lineNumber: range.startLineNumber,
        column: range.startColumn
      });
      const end = model.getOffsetAt({
        lineNumber: range.endLineNumber,
        column: range.endColumn
      });
      const worker = await this._worker(resource);
      if (model.isDisposed()) {
        return [];
      }
      const hints = await worker.provideInlayHints(fileName, start, end);
      return hints.map((hint) => {
        return {
          ...hint,
          position: model.getPositionAt(hint.position),
          kind: this._convertHintKind(hint.kind)
        };
      });
    }
    _convertHintKind(kind) {
      switch (kind) {
        case "Parameter":
          return monaco_editor_core_exports.languages.InlayHintKind.Parameter;
        case "Type":
          return monaco_editor_core_exports.languages.InlayHintKind.Type;
        default:
          return monaco_editor_core_exports.languages.InlayHintKind.Other;
      }
    }
  };

  // src/typescript/tsMode.ts
  var javaScriptWorker;
  var typeScriptWorker;
  function setupTypeScript(defaults) {
    typeScriptWorker = setupMode(defaults, "typescript");
  }
  function setupJavaScript(defaults) {
    javaScriptWorker = setupMode(defaults, "javascript");
  }
  function getJavaScriptWorker2() {
    return new Promise((resolve, reject) => {
      if (!javaScriptWorker) {
        return reject("JavaScript not registered!");
      }
      resolve(javaScriptWorker);
    });
  }
  function getTypeScriptWorker2() {
    return new Promise((resolve, reject) => {
      if (!typeScriptWorker) {
        return reject("TypeScript not registered!");
      }
      resolve(typeScriptWorker);
    });
  }
  function setupMode(defaults, modeId) {
    const client = new WorkerManager(modeId, defaults);
    const worker = (...uris) => {
      return client.getLanguageServiceWorker(...uris);
    };
    const libFiles = new LibFiles(worker);
    monaco_editor_core_exports.languages.registerCompletionItemProvider(modeId, new SuggestAdapter(worker));
    monaco_editor_core_exports.languages.registerSignatureHelpProvider(modeId, new SignatureHelpAdapter(worker));
    monaco_editor_core_exports.languages.registerHoverProvider(modeId, new QuickInfoAdapter(worker));
    monaco_editor_core_exports.languages.registerDocumentHighlightProvider(modeId, new OccurrencesAdapter(worker));
    monaco_editor_core_exports.languages.registerDefinitionProvider(modeId, new DefinitionAdapter(libFiles, worker));
    monaco_editor_core_exports.languages.registerReferenceProvider(modeId, new ReferenceAdapter(libFiles, worker));
    monaco_editor_core_exports.languages.registerDocumentSymbolProvider(modeId, new OutlineAdapter(worker));
    monaco_editor_core_exports.languages.registerDocumentRangeFormattingEditProvider(modeId, new FormatAdapter(worker));
    monaco_editor_core_exports.languages.registerOnTypeFormattingEditProvider(modeId, new FormatOnTypeAdapter(worker));
    monaco_editor_core_exports.languages.registerCodeActionProvider(modeId, new CodeActionAdaptor(worker));
    monaco_editor_core_exports.languages.registerRenameProvider(modeId, new RenameAdapter(libFiles, worker));
    monaco_editor_core_exports.languages.registerInlayHintsProvider(modeId, new InlayHintsAdapter(worker));
    new DiagnosticsAdapter(libFiles, defaults, modeId, worker);
    return worker;
  }
  return tsMode_exports;
})();
return moduleExports;
});
