/**
 * Copyright (c) 2021 OceanBase
 * OceanBase CE is licensed under Mulan PubL v2.
 * You can use this software according to the terms and conditions of the Mulan PubL v2.
 * You may obtain a copy of Mulan PubL v2 at:
 *          http://license.coscl.org.cn/MulanPubL-2.0
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PubL v2 for more details.
 */

#ifndef OCEANBASE_SQL_OB_ITEM_TYPE_H_
#define OCEANBASE_SQL_OB_ITEM_TYPE_H_

// @note !!!Contact with Zhuweng before you modify this file!!!

#ifdef __cplusplus
extern "C" {
#endif
typedef enum ObItemType
{
  T_INVALID = -1, //Attention: add a new type after T_INVALID

  /* Literal data type tags, the same as ObObjType */
  // Although some of the following types are not used in the parser,
  // we define them here to make it the same as ObObjType!!!
  T_NULL = 0,

  T_TINYINT = 1,
  T_SMALLINT = 2,
  T_MEDIUMINT = 3,
  T_INT32 = 4,
  T_INT = 5,

  T_UTINYINT = 6,
  T_USMALLINT = 7,
  T_UMEDIUMINT = 8,
  T_UINT32 = 9,
  T_UINT64 = 10,

  T_FLOAT = 11,
  T_DOUBLE = 12,
  T_UFLOAT = 13,
  T_UDOUBLE = 14,

  T_NUMBER = 15,
  T_UNUMBER = 16,

  T_DATETIME = 17,
  T_TIMESTAMP = 18,
  T_DATE = 19,
  T_TIME = 20,
  T_YEAR = 21,

  T_VARCHAR = 22, /*ObVarcharType*/
  T_CHAR = 23,
  T_HEX_STRING = 24,

  T_EXTEND = 25,
  T_QUESTIONMARK = 26, /*ObUnknownType*/
  T_TINYTEXT = 27,
  T_TEXT = 28,
  T_MEDIUMTEXT = 29,
  T_LONGTEXT = 30,
  T_BIT = 31,
  T_ENUM = 32,
  T_SET = 33,

  T_TIMESTAMP_TZ = 36,
  T_TIMESTAMP_LTZ = 37,
  T_TIMESTAMP_NANO = 38,
  T_RAW = 39,
  T_INTERVAL_YM = 40,
  T_INTERVAL_DS = 41,
  T_NUMBER_FLOAT = 42,
  T_NVARCHAR2   = 43,
  T_NCHAR       = 44,
  T_UROWID      = 45,
  T_LOB         = 46,
  T_JSON        = 47,
  T_GEOMETRY    = 48,
  T_UDT_SQL     = 49,

  T_IEEE754_NAN = 61,
  T_IEEE754_INFINITE = 62,
  T_BOOL = 63, /*@todo remove later*/
  T_MAX_CONST = 64,
  T_VAR_INT = 65,

  T_EXEC_VAR = 66,

  T_REF_ALIAS_COLUMN = 88,
  T_REF_COLUMN = 89,
  // @note !!! the values of the following tags between T_FUN_MAX and T_FUN_AVG SHOULD NOT be changed
  /* Aggregate function tags */
  T_FUN_MAX = 90,
  T_FUN_MIN = 91,
  T_FUN_SUM = 92,
  T_FUN_COUNT_SUM = 93,
  T_FUN_COUNT = 94,
  T_FUN_GROUP_CONCAT = 95,
  T_FUN_AVG = 96,
  T_FUN_APPROX_COUNT_DISTINCT = 97,
  T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS = 98,
  T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS_MERGE = 99,

  // @note !!! the values of the following tags between T_MIN_OP and T_FUN_SYS SHOULD NOT be changed, new operator should be appended only
  /* Operator tags */
  T_MIN_OP = 100, /* 1. arithmetic operators */
  T_OP_NEG = 101,   // negative
  T_OP_POS = 102,   // positive
  T_OP_ABS = 103,   // for abs
  T_OP_ADD = 104,
  T_OP_MINUS = 105,
  T_OP_MUL = 106,
  T_OP_DIV = 107,
  T_OP_REM = 108,   // remainder
  T_OP_MOD = 109,
  /* common comparison operators */
  T_OP_EQ = 110,      /* 2. Bool operators */
  T_OP_NSEQ = 111,
  T_OP_LE = 112,
  T_OP_LT = 113,
  T_OP_GE = 114,
  T_OP_GT = 115,
  T_OP_NE = 116,
  /* subquery comparison operators */
  T_OP_SQ_EQ = 117,
  T_OP_SQ_NSEQ = 118,
  T_OP_SQ_LE = 119,
  T_OP_SQ_LT = 120,
  T_OP_SQ_GE = 121,
  T_OP_SQ_GT = 122,
  T_OP_SQ_NE = 123,
  T_OP_POW = 124,

  T_OP_IS = 125,
  T_OP_IS_NOT = 126,
  T_OP_BTW = 127,
  T_OP_NOT_BTW = 128,
  T_OP_LIKE = 129,
  T_OP_NOT_LIKE = 130,
  T_OP_REGEXP = 131,
  T_OP_NOT_REGEXP = 132,
  T_OP_NOT = 133,
  T_OP_AND = 134,
  T_OP_OR = 135,
  T_OP_IN = 136,
  T_OP_NOT_IN = 137,
  T_OP_ARG_CASE = 138,
  T_OP_CASE = 139,
  T_OP_ROW = 140,
  T_OP_EXISTS = 141,
  T_OP_NOT_EXISTS = 142,
  T_OP_QUOTE = 143,
  T_OP_CONV = 144,
  T_OP_CNN = 145,  /* 3. String operators */
  T_OP_INT_DIV = 146,
  T_OP_SIGN = 147,
  T_OP_ASSIGN = 148,
  T_OP_GET_USER_VAR = 149,
  T_OP_GET_SYS_VAR = 150,
  T_OP_COLUMN_REF = 151, /* normalize column to function */
  T_OP_CONST_VAL = 152,  /* normalize const to funciton */

  //set expr operators
  T_OP_SET = 153,
  T_OP_UNION = 154,
  T_OP_INTERSECT = 155,
  T_OP_EXCEPT = 156,

  /*bit operators*/
  T_OP_BIT_AND = 157,
  T_OP_BIT_OR = 158,
  T_OP_BIT_XOR = 159,
  T_OP_BIT_INVERT = 160,
  T_OP_BIT_NEG = 161,
  T_OP_BIT_LEFT_SHIFT = 162,
  T_OP_BIT_RIGHT_SHIFT = 163,
  /*bit operators end*/

  /* special op*/
  T_OP_AGG_PARAM_LIST = 164,
  /* reference tags */
  T_REF_QUERY = 165,
  T_OP_PRIOR = 166,
  T_OBJ_ACCESS_REF = 167,
  T_OP_CONNECT_BY_ROOT = 168,

  /*regexp_substr这个函数注册已经由T_FUN_SYS_REGEXP_SUBSTR代替,因为将其注册在这会造成oracle无法识别这个函数，
  因此同时不确定删除会不会影响其它,因此选择了保留*/
  T_OP_REGEXP_SUBSTR = 169,
  T_OP_GET_PACKAGE_VAR = 170,
  T_OP_SHADOW_UK_PROJECT = 171,

  T_OP_XOR = 172,
  /* oracle outer join symbol as a dummy op*/
  T_OP_ORACLE_OUTER_JOIN_SYMBOL = 173,
  T_OP_RANGE_PARAM = 174,
  T_OP_GET_SUBPROGRAM_VAR = 175,
  T_OP_MULTISET = 176,
  T_OP_COLL_PRED = 177, // collection predicate, such as: xx is member of collection
  T_OP_BOOL = 178,
  T_OP_STACK_OVERFLOW_CHECK = 179,  // stack over flow check expr.
  T_OP_RUNTIME_FILTER = 180,
  T_OP_TO_OUTFILE_ROW = 181,
  // The aggregation version arithmetic operator is used to ignore the double overflow error,
  // because mysql do not check overflow for double in aggregation.
  T_OP_AGG_ADD = 182,
  T_OP_AGG_MINUS = 183,
  T_OP_AGG_MUL = 184,
  T_OP_AGG_DIV = 185,
  T_OP_OUTPUT_PACK = 186,
  T_FUN_GET_TEMP_TABLE_SESSID = 187,
  ///< @note add new operator before this line

  // system functions
  // @note !!! the values of the following tags between T_FUN_SYS and T_MAX_OP SHOULD NOT be changed, new function should be appended only
  T_FUN_SYS = 500,
  T_FUN_SYS_CAST = 501,
  T_FUN_SYS_CHAR = 502,
  T_FUN_SYS_CONVERT = 503,
  T_FUN_SYS_GREATEST = 504,
  T_FUN_SYS_LEAST = 505,
  T_FUN_SYS_COALESCE = 506,
  T_FUN_SYS_TRIM = 507,
  T_FUN_SYS_SUBSTR = 508,
  T_FUN_SYS_SUBSTRING_INDEX = 509,
  T_FUN_SYS_MD5 = 510,
  T_FUN_SYS_IP2INT = 511,
  T_FUN_SYS_INT2IP = 512,
  T_FUN_SYS_INSERT = 513,
  T_FUN_SYS_LENGTH = 514,
  T_FUN_SYS_HEX = 515,
  T_FUN_SYS_UNHEX = 516,
  T_FUN_SYS_UPPER = 517,
  T_FUN_SYS_LOWER = 518,
  T_FUN_SYS_BIN = 519,
  T_FUN_SYS_DATE = 520,
  T_FUN_SYS_DATE_ADD = 521,
  T_FUN_SYS_DATE_SUB = 522,
  T_FUN_SYS_DATE_DIFF = 523,
  T_FUN_SYS_TIME_STAMP_DIFF = 524,
  T_FUN_SYS_TIME_DIFF = 525,
  T_FUN_SYS_PERIOD_DIFF = 526,
  T_FUN_SYS_FROM_UNIX_TIME = 527,
  T_FUN_SYS_EXTRACT = 528,
  T_FUN_SYS_MONTH = 529,
  T_FUN_SYS_DATE_FORMAT = 530,
  T_FUN_SYS_STR_TO_DATE = 531,
  T_FUN_SYS_UTC_TIMESTAMP = 532,
  T_FUN_SYS_UPS_TIME = 533,
  T_FUN_SYS_CUR_TIMESTAMP = 534,
  T_FUN_SYS_CUR_TIME = 535,
  T_FUN_SYS_CUR_DATE = 536,
  T_FUN_SYS_TO_DAYS = 537,
  T_FUN_SYS_FROM_DAYS = 538,
  T_FUN_SYS_NVL = 539,
  T_FUN_SYS_TIME_TO_USEC = 540,
  T_FUN_SYS_USEC_TO_TIME = 541,
  T_FUN_SYS_UNIX_TIMESTAMP = 542,
  T_FUN_SYS_ROUND = 543,
  T_FUN_SYS_DUMP = 544,
  T_FUN_SYS_FLOOR = 545,
  T_FUN_SYS_CEIL = 546,
  T_FUN_SYS_REPEAT = 547,
  T_FUN_SYS_REPLACE = 548,
  T_FUN_SYS_MERGING_FROZEN_TIME = 549,
  T_FUN_SYS_PART_HASH = 550,
  //following T_FUN_SYS_PART_KEY_V1 has been removed, it's useless now.
  T_FUN_SYS_PART_KEY_V1 = 551,
  T_FUN_SYS_ADDR_TO_PART_ID = 552,
  T_FUN_SYS_DATABASE = 553,
  T_FUN_SYS_AUTOINC_NEXTVAL = 554,
  T_FUN_SYS_LAST_INSERT_ID = 555,
  T_FUN_SYS_INSTR = 556,
  T_FUN_SYS_LNNVL = 557,
  T_FUN_SYS_LOCATE = 558,
  T_FUN_SYS_EFFECTIVE_TENANT = 559,
  T_FUN_SYS_CURRENT_USER = 560,
  T_FUN_SYS_USER = 561,
  T_FUN_SYS_VERSION = 562,
  T_FUN_SYS_CHARSET = 563,
  T_FUN_SYS_COLLATION = 564,
  T_FUN_SYS_SYS_VIEW_BIGINT_PARAM = 565,
  T_FUN_SYS_COERCIBILITY = 566,
  T_FUN_SYS_REVERSE = 567,
  T_FUN_SYS_RIGHT = 568,
  T_FUN_SYS_EFFECTIVE_TENANT_ID = 569,
  T_FUN_SYS_VALUES = 570,
  T_FUN_SYS_OCT = 571,
  T_FUN_SYS_RPAD = 572,
  T_FUN_SYS_SET_COLLATION = 573,
  T_FUN_SYS_CHAR_LENGTH = 574,
  T_FUN_SYS_CONNECTION_ID = 575,
  T_FUN_SYS_HOST_IP = 576,
  T_FUN_SYS_RPC_PORT = 577,
  T_FUN_SYS_MYSQL_PORT = 578,
  T_FUN_SYS_IFNULL = 579,
  T_FUN_SYS_FOUND_ROWS = 580,
  T_FUN_SYS_ROW_COUNT = 581,
  T_FUN_CNN_WS = 582,
  T_FUN_SYS_SYS_PRIVILEGE_CHECK = 583,
  T_FUN_SYS_CMP_META = 585,
  T_FUN_SYS_DEFAULT = 586,
  T_FUN_SYS_FIELD = 587,
  T_FUN_SYS_NULLIF = 588,
  T_FUN_PAD = 589,
  T_FUN_COLUMN_CONV = 590,
  T_FUN_SYS_IF = 591,
  T_FUN_SYS_ISNULL = 592,
  T_FUN_SYS_TIMESTAMP_NVL = 593,
  T_FUN_IS_SERVING_TENANT = 594,
  T_FUN_SYS_POSITION = 595,
  T_FUN_SYS_ORA_DECODE = 596,
  T_FUN_SYS_ELT = 597,
  T_FUN_SYS_STRCMP = 598,
  T_FUN_SYS_PART_KEY = 599,
  T_FUN_INNER_TRIM = 600,
  T_FUN_SYS_PART_ID = 601,
  T_FUN_SYS_ORA_TRUNC = 602,
  T_FUN_SYS_TO_TYPE = 603,
  T_FUN_SYS_SLEEP = 604,
  T_FUN_GET_LAST_EXEC_ID = 605,
  T_FUN_GET_LAST_TRACE_ID = 606,
  T_FUN_SYS_CEILING = 607,
  T_FUN_DES_HEX_STR = 608,
  T_FUN_SYS_YEAR = 609,
  T_FUN_SYS_UUID = 610,
  T_FUN_SYS_TIME = 611,
  T_FUN_SYS_ASCII = 612,
  T_FUN_SYS_ORD = 613,
  T_FUN_SYS_WORD_SEGMENT = 614,
  T_FUN_SYS_LTRIM = 615,
  T_FUN_SYS_SPACE = 616,
  T_FUN_SYS_RTRIM = 617,
  T_FUN_SYS_LPAD = 618,
  T_FUN_SYS_TIME_STAMP_ADD = 619,
  T_FUN_SYS_BIT_COUNT = 620,
  T_FUN_SYS_FIND_IN_SET = 621,
  T_FUN_SYS_LEFT = 622,
  T_FUN_SYS_MAKE_SET = 623,
  T_FUN_SYS_RAND = 624,
  T_FUN_SYS_ROWNUM = 625,
  T_FUN_SYS_ESTIMATE_NDV = 626,
  T_FUN_ENUM_TO_STR = 627,
  T_FUN_ENUM_TO_INNER_TYPE = 628,
  T_FUN_SET_TO_STR = 629,
  T_FUN_SET_TO_INNER_TYPE = 630,
  T_FUN_GROUPING = 631,
  T_FUN_SYS_OP_OPNSIZE = 632,
  T_FUN_SYS_PDB_ON = 633,
  T_FUN_SYS_PDB_OFF = 634,
  T_FUN_SYS_PDB_INITIALIZE = 635,
  T_FUN_SYS_PDB_ATTACHSESSION = 636,
  T_FUN_SYS_PDB_DETACHSESSION = 637,
  T_FUN_SYS_PDB_SETBREAKPOINT = 638,
  T_FUN_SYS_PDB_PRINTBACKTRACE = 639,
  T_FUN_SYS_PDB_CONTINUE = 640,
  T_FUN_SYS_PDB_SHOWBREAKPOINTS = 641,
  T_FUN_SYS_PDB_GETVALUE = 642,
  T_FUN_SYS_PDB_DELBREAKPOINT = 643,
  T_FUN_SYS_PDB_ENABLE_BP = 644,
  T_FUN_SYS_PDB_DISABLE_BP = 645,
  T_FUN_SYS_PDB_SET_TIMEOUT = 646,
  T_FUN_SYS_PDB_SET_TIMEOUT_BEHAVIOUR = 647,
  T_FUN_SYS_PDB_GET_TIMEOUT_BEHAVIOUR = 648,
  // 649, 650 has beed removed
  T_FUN_SYS_DAY_OF_MONTH = 651,
  T_FUN_SYS_DAY_OF_WEEK = 652,
  T_FUN_SYS_DAY_OF_YEAR = 653,
  T_FUN_SYS_SECOND = 654,
  T_FUN_SYS_MINUTE = 655,
  T_FUN_SYS_MICROSECOND = 656,
  T_FUN_SYS_TO_SECONDS = 657,
  T_FUN_SYS_TIME_TO_SEC = 658,
  T_FUN_SYS_SEC_TO_TIME = 659,
  T_FUN_SYS_INTERVAL = 660,
  T_FUN_UDF = 661,
  T_FUN_SYS_SUBTIME = 662,
  T_FUN_SYS_SQRT = 663,
  T_FUN_SYS_LOG_TWO = 664,
  T_FUN_SYS_LOG_TEN = 665,
  T_FUN_SYS_SYSDATE = 666,
  T_FUN_SYS_TRUNCATE = 667,
  T_FUN_SYS_WEEK_OF_YEAR = 668,
  T_FUN_SYS_WEEKDAY_OF_DATE = 669,
  T_FUN_SYS_YEARWEEK_OF_DATE = 670,
  T_FUN_SYS_WEEK = 671,
  T_FUN_NORMAL_UDF = 672,
  T_FUN_AGG_UDF = 673,
  T_FUN_SYS_SEQ_NEXTVAL = 674,
  T_FUN_SYS_ROWKEY_TO_ROWID = 675,
  T_FUN_SYS_UID = 676,
  T_FUN_SYS_LOCALTIMESTAMP = 677,
  // 678 has been removed
  T_FUN_SYS_EXP = 679,
  T_FUN_STDDEV_SAMP = 680,
  T_FUN_STDDEV_POP = 681,
  T_FUN_STDDEV = 682,
  T_FUN_VARIANCE = 683,
  T_FUN_SYS_HOUR = 684,
  T_FUN_SYS_STMT_ID = 685,
  T_FUN_SYS_REGEXP_INSTR = 686,
  T_FUN_SYS_REGEXP_REPLACE = 687,
  T_FUN_SYS_REGEXP_LIKE = 688,
  T_FUN_SYS_REGEXP_SUBSTR = 689,
  T_FUN_COLUMN_CONV_SKIP_NULL_CHECK = 690,
  // use for pdml, pseudo column
  T_PDML_PARTITION_ID = 691,
  T_FUN_SYS_MID = 692,
  T_FUN_SYS_CALC_UROWID = 693,
  // udf for pl debugger get_runtime_info
  T_FUN_SYS_PDB_GET_RUNTIME_INFO = 694,
  T_FUN_SYS_REMOVE_CONST = 695,
  //following T_FUN_SYS_PART_KEY_V3 has been removed, it's useless now.
  T_FUN_SYS_PART_KEY_V3 = 696,
  //following T_FUN_SYS_PART_HASH_V2 has been removed, it's useless now.
  T_FUN_SYS_PART_HASH_V2 = 697,
  T_FUN_SYS_SQL_MODE_CONVERT = 698,
  T_FUN_SYS_PREFIX_PATTERN = 699,

  ///< @note add new mysql/oracle function type before this line
  T_COMMON_FUN_SYS_END = 700,

  // system function for mysql only
  T_MYSQL_ONLY_SYS_MIN_OP = 701,
  T_FUN_AES_ENCRYPT = 702,
  T_FUN_AES_DECRYPT = 703,
  T_FUN_SYS_OB_VERSION = 704,
  T_FUN_SYS_CALC_PARTITION_ID = 705,
  T_FUN_SYS_RADIANS = 706,
  T_FUN_SYS_MAKETIME = 707,
  T_FUN_SYS_MONTH_NAME = 708,
  T_FUN_SYS_FORMAT = 709,
  T_FUN_SYS_COT = 710,
  T_FUN_SYS_QUARTER = 711,
  T_FUN_SYS_BIT_LENGTH = 712,
  T_FUN_SYS_PI = 713,
  T_FUN_SYS_ANY_VALUE = 714,
  T_FUN_SYS_DEGREES = 715,
  T_FUN_SYS_VALIDATE_PASSWORD_STRENGTH = 716,
  T_FUN_SYS_DAY = 717,
  T_FUN_SYS_SOUNDEX= 718,
  T_FUN_SYS_UUID_SHORT = 719,
  T_FUN_SYS_BENCHMARK = 720,
  T_FUN_SYS_EXPORT_SET = 721,
  T_FUN_SYS_INET6NTOA = 722,
  T_FUN_SYS_INET6ATON = 723,
  T_FUN_SYS_IS_IPV4 = 724,
  T_FUN_SYS_IS_IPV6 = 725,
  T_FUN_SYS_IS_IPV4_MAPPED = 726,
  T_FUN_SYS_IS_IPV4_COMPAT = 727,
  T_FUN_SYS_INETATON = 728,
  T_FUN_SYS_WEIGHT_STRING = 729,
  T_FUN_SYS_CONVERT_TZ = 730,
  T_FUN_SYS_CRC32 = 731,
  // @note !!! the values of the following tags between T_FUN_SYS_BIT_AND and T_FUN_SYS_BIT_XOR
  // SHOULD NOT be changed
  T_FUN_SYS_BIT_AND = 732,
  T_FUN_SYS_BIT_OR = 733,
  T_FUN_SYS_BIT_XOR = 734,
  T_FUN_SYS_TO_BASE64 = 735,
  T_FUN_SYS_FROM_BASE64 = 736,
  T_FUN_SYS_RANDOM_BYTES = 737,
  T_FUN_SUBQUERY = 738,
  T_FUN_SYS_ENCODE_SORTKEY = 739,
  T_FUN_SYS_SHA = 740,
  T_FUN_SYS_SHA1 = 741,
  T_FUN_SYS_SHA2 = 742,
  T_FUN_SYS_COMPRESS = 743,
  T_FUN_SYS_UNCOMPRESS = 744,
  T_FUN_SYS_UNCOMPRESSED_LENGTH = 745,
  T_FUN_SYS_STATEMENT_DIGEST = 746,
  T_FUN_SYS_STATEMENT_DIGEST_TEXT = 747,
  T_FUN_SYS_HASH = 748,
  T_FUN_SYS_CALC_TABLET_ID = 749,
  T_FUN_SYS_CALC_PARTITION_TABLET_ID = 750,
  T_FUN_SYS_ERRNO = 751,
  T_FUN_SYS_ADDTIME = 752,
  T_FUN_SYS_DAY_NAME = 753,
  T_FUN_SYS_UUID2BIN = 754,
  T_FUN_SYS_IS_UUID = 755,
  T_FUN_SYS_BIN2UUID = 756,
  T_FUN_SYS_NAME_CONST = 757,
  T_FUN_SYS_FORMAT_BYTES = 758,
  T_FUN_SYS_FORMAT_PICO_TIME = 759,
  T_FUN_SYS_DECODE = 760,
  T_FUN_SYS_ENCODE = 761,
  T_FUN_SYS_DES_DECRYPT = 762,
  T_FUN_SYS_DES_ENCRYPT = 763,
  T_FUN_SYS_ENCRYPT = 764,
  T_FUN_SYS_ICU_VERSION = 765,

  T_FUN_SYS_CURRENT_USER_PRIV = 766,
  ///< @note add new mysql only function type before this line
  T_MYSQL_ONLY_SYS_MAX_OP = 800,

  // system function for oracle only
  T_FUN_SYS_CONNECT_BY_PATH = 1401,
  T_FUN_SYS_SYSTIMESTAMP = 1402,
  T_FUN_SYS_TO_DATE = 1403,
  T_FUN_SYS_TO_CHAR = 1404,
  T_FUN_SYS_TO_NUMBER = 1405,
  T_FUN_SYS_USERENV = 1406,
  T_FUN_SYS_SYS_CONTEXT = 1407,
  T_FUN_SYS_LENGTHB = 1408,
  T_FUN_SYS_HEXTORAW = 1409,
  T_FUN_SYS_RAWTOHEX = 1410,
  T_FUN_SYS_UTL_RAW_CAST_TO_RAW = 1411,
  T_FUN_SYS_UTL_RAW_CAST_TO_VARCHAR2 = 1412,
  T_FUN_SYS_TO_TIMESTAMP = 1413,
  T_FUN_SYS_TO_TIMESTAMP_TZ = 1414,
  T_FUN_SYS_UTL_RAW_LENGTH = 1415,
  T_FUN_SYS_UTL_RAW_BIT_AND = 1416,
  T_FUN_SYS_UTL_RAW_BIT_OR = 1417,
  T_FUN_SYS_UTL_RAW_BIT_XOR = 1418,
  T_FUN_SYS_UTL_RAW_BIT_COMPLEMENT = 1419,
  T_FUN_SYS_UTL_RAW_REVERSE = 1420,
  T_FUN_SYS_UTL_RAW_COPIES = 1421,
  T_FUN_SYS_UTL_RAW_COMPARE = 1422,
  T_FUN_SYS_UTL_RAW_SUBSTR = 1423,
  T_FUN_SYS_UTL_RAW_CONCAT = 1424,
  T_FUN_SYS_TO_CLOB = 1425,
  T_FUN_SYS_CHR = 1426,
  T_FUN_PL_INTEGER_CHECKER = 1427,
  T_FUN_PL_GET_CURSOR_ATTR = 1428,
  T_FUN_PL_ASSOCIATIVE_INDEX = 1429,
  T_FUN_SYS_SESSIONTIMEZONE = 1430,
  T_FUN_SYS_DBTIMEZONE = 1431,
  T_FUN_SYS_SYS_EXTRACT_UTC = 1432,
  T_FUN_SYS_TZ_OFFSET = 1433,
  T_FUN_SYS_FROM_TZ = 1434,
  T_FUN_SYS_DBMS_LOB_GETLENGTH = 1435,
  T_FUN_SYS_DBMS_LOB_APPEND = 1436,
  T_FUN_SYS_DBMS_LOB_READ = 1437,
  T_FUN_SYS_DBMS_LOB_CONVERTTOBLOB = 1438,
  T_FUN_SYS_DBMS_LOB_CAST_CLOB_TO_BLOB = 1439,
  T_FUN_SYS_DBMS_LOB_CONVERT_CLOB_CHARSET = 1440,
  //Lable Security, only used in oracle PL
  T_FUN_LABEL_SE_POLICY_CREATE = 1441,
  T_FUN_LABEL_SE_POLICY_ALTER = 1442,
  T_FUN_LABEL_SE_POLICY_DISABLE = 1443,
  T_FUN_LABEL_SE_POLICY_ENABLE = 1444,
  T_FUN_LABEL_SE_POLICY_DROP = 1445,
  T_FUN_LABEL_SE_LEVEL_CREATE = 1446,
  T_FUN_LABEL_SE_LEVEL_ALTER = 1447,
  T_FUN_LABEL_SE_LEVEL_DROP = 1448,
  T_FUN_LABEL_SE_COMPARTMENT_CREATE = 1449,
  T_FUN_LABEL_SE_COMPARTMENT_ALTER = 1450,
  T_FUN_LABEL_SE_COMPARTMENT_DROP = 1451,
  T_FUN_LABEL_SE_GROUP_CREATE = 1452,
  T_FUN_LABEL_SE_GROUP_ALTER = 1453,
  T_FUN_LABEL_SE_GROUP_ALTER_PARENT = 1454,
  T_FUN_LABEL_SE_GROUP_DROP = 1455,
  T_FUN_LABEL_SE_LABEL_CREATE = 1456,
  T_FUN_LABEL_SE_LABEL_ALTER = 1457,
  T_FUN_LABEL_SE_LABEL_DROP = 1458,
  T_FUN_LABEL_SE_TABLE_POLICY_APPLY = 1459,
  T_FUN_LABEL_SE_TABLE_POLICY_REMOVE = 1460,
  T_FUN_LABEL_SE_TABLE_POLICY_DISABLE = 1461,
  T_FUN_LABEL_SE_TABLE_POLICY_ENABLE = 1462,
  T_FUN_LABEL_SE_SCHEMA_POLICY_APPLY = 1463,
  T_FUN_LABEL_SE_SCHEMA_POLICY_REMOVE = 1464,
  T_FUN_LABEL_SE_SCHEMA_POLICY_DISABLE = 1465,
  T_FUN_LABEL_SE_SCHEMA_POLICY_ENABLE = 1466,
  T_FUN_LABEL_SE_USER_SET_LEVELS = 1467,
  T_FUN_LABEL_SE_USER_SET_COMPARTMENTS = 1468,
  T_FUN_LABEL_SE_USER_SET_GROUPS = 1469,
  T_FUN_LABEL_SE_USER_ADD_COMPARTMENTS = 1470,
  T_FUN_LABEL_SE_USER_ALTER_COMPARTMENTS = 1471,
  T_FUN_LABEL_SE_USER_DROP_COMPARTMENTS = 1472,
  T_FUN_LABEL_SE_USER_DROP_ALL_COMPARTMENTS = 1473,
  T_FUN_LABEL_SE_USER_ADD_GROUPS = 1474,
  T_FUN_LABEL_SE_USER_ALTER_GROUPS = 1475,
  T_FUN_LABEL_SE_USER_DROP_GROUPS = 1476,
  T_FUN_LABEL_SE_USER_DROP_ALL_GROUPS = 1477,
  T_FUN_LABEL_SE_LABEL_VALUE_CMP_LE = 1478,
  T_FUN_LABEL_SE_LABEL_VALUE_CHECK = 1479,
  T_FUN_LABEL_SE_LABEL_VALUE_TO_CHAR = 1480,
  T_FUN_LABEL_SE_CHAR_TO_LABEL_VALUE = 1481,
  T_FUN_LABEL_SE_SESSION_SET_LABEL = 1482,
  T_FUN_LABEL_SE_SESSION_SET_ROW_LABEL = 1483,
  T_FUN_LABEL_SE_SESSION_RESTORE_DEFAULT_LABEL = 1484,
  T_FUN_LABEL_SE_SESSION_SAVE_DEFAULT_LABEL = 1485,
  T_FUN_LABEL_SE_SESSION_LABEL = 1486,
  T_FUN_LABEL_SE_SESSION_ROW_LABEL = 1487,
  T_FUN_PL_SQLCODE_SQLERRM = 1488,
  T_FUN_PL_COLLECTION_CONSTRUCT = 1489,
  T_FUN_SYS_REMAINDER = 1490,

  T_FUN_PL_OBJECT_CONSTRUCT = 1491,
  T_FUN_SYS_ADD_MONTHS = 1492,
  T_FUN_SYS_LAST_DAY = 1493,
  T_FUN_SYS_MONTHS_BETWEEN = 1494,
  T_FUN_SYS_NEXT_DAY = 1495,
  T_FUN_SYS_TO_DSINTERVAL = 1496,
  T_FUN_SYS_TO_YMINTERVAL = 1497,
  T_FUN_SYS_NUMTODSINTERVAL = 1498,
  T_FUN_SYS_NUMTOYMINTERVAL = 1499,
  T_FUN_SYS_INITCAP = 1500,
  T_FUN_SYS_INSTRB = 1501,
  T_FUN_SYS_SUBSTRB = 1502,
  T_FUN_SYS_LENGTHC = 1503,
  T_FUN_SYS_SUBSTRC = 1504,
  T_FUN_SYS_INSTRC = 1505,
  T_FUN_SYS_POWER = 1506,
  T_FUN_SYS_LN = 1507,
  T_FUN_SYS_LOG = 1508,
  T_FUN_SYS_WIDTH_BUCKET = 1509,
  T_FUN_SYS_TRANSLATE = 1510,
  T_FUN_SYS_ASIN = 1511,
  T_FUN_SYS_ACOS = 1512,
  T_FUN_SYS_ATAN = 1513,
  T_FUN_SYS_ATAN2 = 1514,
  T_FUN_SYS_REGEXP_COUNT = 1515,
  T_FUN_NVL2 = 1516,
  T_FUN_SYS_TO_BINARY_FLOAT = 1517,
  T_FUN_SYS_TO_BINARY_DOUBLE = 1518,
  T_FUN_SYS_NANVL = 1519,
  T_FUN_SYS_COS = 1520,
  T_FUN_SYS_TAN = 1521,
  T_FUN_SYS_SIN = 1522,
  T_FUN_SYS_SINH = 1523,
  T_FUN_SYS_COSH = 1524,
  T_FUN_SYS_TANH = 1525,
  T_FUN_SYS_VSIZE = 1526,
  T_FUN_SYS_ORAHASH = 1527,
  T_FUN_SYS_PL_SEQ_NEXT_VALUE = 1528,
  T_FUN_SYS_GUID = 1529,
  T_FUN_SYS_TO_SINGLE_BYTE = 1530,
  T_FUN_SYS_TO_MULTI_BYTE = 1531,
  T_FUN_SYS_UTL_I18N_STRING_TO_RAW = 1532,
  T_FUN_SYS_UTL_I18N_RAW_TO_CHAR = 1533,
  T_FUC_SYS_DBMS_CRYPTO_ENCRYPT = 1534,
  T_FUC_SYS_DBMS_CRYPTO_DECRYPT = 1535,
  T_FUN_SYS_TO_NCHAR = 1536,
  T_FUN_SYS_SET = 1537,
  T_FUN_SYS_CARDINALITY = 1538,
  T_FUN_CORR = 1539,
  T_FUN_COVAR_POP = 1540,
  T_FUN_COVAR_SAMP = 1541,
  T_FUN_VAR_POP = 1542,
  T_FUN_VAR_SAMP = 1543,
  T_FUN_REGR_SLOPE = 1544,
  T_FUN_REGR_INTERCEPT = 1545,
  T_FUN_REGR_COUNT = 1546,
  T_FUN_REGR_R2 = 1547,
  T_FUN_REGR_AVGX = 1548,
  T_FUN_REGR_AVGY = 1549,
  T_FUN_REGR_SXX = 1550,
  T_FUN_REGR_SYY = 1551,
  T_FUN_REGR_SXY = 1552,
  T_FUN_SYS_UTL_INADDR_GET_HOST_ADDR = 1553,
  T_FUN_SYS_UTL_INADDR_GET_HOST_NAME = 1554,
  T_FUN_GROUP_RANK = 1555,
  T_FUN_GROUP_PERCENT_RANK = 1556,
  T_FUN_GROUP_DENSE_RANK = 1557,
  T_FUN_GROUP_CUME_DIST = 1558,
  T_FUN_KEEP_MAX = 1559,
  T_FUN_KEEP_MIN = 1560,
  T_FUN_KEEP_SUM = 1561,
  T_FUN_KEEP_COUNT = 1562,
  T_FUN_KEEP_AVG = 1563,
  T_FUN_KEEP_VARIANCE = 1564,
  T_FUN_KEEP_STDDEV = 1565,
  T_FUN_MEDIAN = 1566,
  T_FUN_GROUP_PERCENTILE_CONT = 1567,
  T_FUN_GROUP_PERCENTILE_DISC = 1568,
  T_FUN_SYS_USER_CAN_ACCESS_OBJ = 1569,
  T_FUN_EMPTY_CLOB = 1570,
  T_FUN_EMPTY_BLOB = 1571,
  T_FUN_SYS_ROWID_TO_CHAR = 1572,
  T_FUN_SYS_ROWID_TO_NCHAR = 1573,
  T_FUN_SYS_CHAR_TO_ROWID = 1574,
  T_FUN_SYS_TO_BLOB = 1575,
  T_FUN_SYS_NLS_LOWER = 1576,
  T_FUN_SYS_NLS_UPPER = 1577,
  T_FUN_KEEP_WM_CONCAT = 1578,
  T_FUN_WM_CONCAT = 1579,
  T_FUN_TOP_FRE_HIST = 1580,
  T_FUN_UNISTR = 1581,
  T_FUN_PLSQL_VARIABLE = 1582,
  T_FUN_ASCIISTR = 1583,
  T_FUN_PL_AGG_UDF = 1584,
  T_FUN_SYS_AT_TIME_ZONE = 1585,
  T_FUN_SYS_AT_LOCAL = 1586,
  T_FUN_HYBRID_HIST = 1587,
  T_FUN_RETURNING_LOB = 1588,
  T_FUN_SYS_TIMESTAMP = 1589,
  T_FUN_SYS_GET_FORMAT = 1590,
  T_FUN_SYS_MAKEDATE = 1591,
  T_FUN_SYS_PERIOD_ADD = 1592,
  T_FUN_SYS_UTC_TIME = 1593,
  T_FUN_SYS_UTC_DATE = 1594,
  T_FUN_SYS_TIME_FORMAT = 1595,
  T_FUN_SYS_WRAPPER_INNER = 1596,
  T_FUN_SYS_RAWTONHEX = 1597,
  T_FUN_SYS_DML_EVENT = 1598,
  T_FUN_GROUPING_ID = 1599,
  T_FUN_GROUP_ID = 1600,
  T_FUN_SYS_NLSSORT = 1601,
  T_FUN_SYS_JSON_OBJECT = 1602,
  T_FUN_SYS_JSON_EXTRACT = 1603,
  T_FUN_SYS_JSON_CONTAINS = 1604,
  T_FUN_SYS_JSON_CONTAINS_PATH = 1605,
  T_FUN_SYS_JSON_DEPTH = 1606,
  T_FUN_SYS_JSON_KEYS = 1607,
  T_FUN_SYS_JSON_ARRAY = 1608,
  T_FUN_SYS_JSON_QUOTE = 1609,
  T_FUN_SYS_JSON_UNQUOTE = 1610,
  T_FUN_SYS_JSON_OVERLAPS = 1611,
  T_FUN_SYS_JSON_REMOVE = 1612,
  T_FUN_SYS_JSON_SEARCH = 1613,
  T_FUN_SYS_JSON_VALID = 1614,
  T_FUN_SYS_JSON_ARRAY_APPEND = 1615,
  T_FUN_SYS_JSON_ARRAY_INSERT = 1616,
  T_FUN_SYS_JSON_REPLACE = 1617,
  T_FUN_SYS_JSON_TYPE = 1618,
  T_FUN_SYS_JSON_LENGTH = 1619,
  T_FUN_SYS_JSON_INSERT = 1620,
  T_FUN_SYS_JSON_STORAGE_SIZE = 1621,
  T_FUN_SYS_JSON_STORAGE_FREE = 1622,
  T_FUN_SYS_JSON_MERGE_PRESERVE = 1623,
  T_FUN_SYS_JSON_MERGE = 1624,
  T_FUN_SYS_JSON_MERGE_PATCH = 1625,
  T_FUN_SYS_JSON_PRETTY = 1626,
  T_FUN_SYS_JSON_SET = 1627,
  T_FUN_SYS_JSON_MEMBER_OF = 1628,
  T_FUN_SYS_JSON_VALUE = 1629,
  T_FUN_JSON_ARRAYAGG = 1630,
  T_FUN_JSON_OBJECTAGG = 1631,
// please modify need_calc_json_as_text if other json functions are added
  T_FUN_SYS_INNER_AGGR_CODE = 1632,
  //T_FUN_SYS_TIMESTAMP_TO_SCN and T_FUN_SYS_SCN_TO_TIMESTAMP are supported both in mysql and oracle
  T_FUN_SYS_TIMESTAMP_TO_SCN = 1633,
  T_FUN_SYS_SCN_TO_TIMESTAMP = 1634,

  T_FUN_SYS_ST_LONGITUDE = 1635,
  T_FUN_SYS_ST_TRANSFORM = 1636,
  T_FUN_SYS_POINT = 1637,
  T_FUN_SYS_LINESTRING = 1638,
  T_FUN_SYS_MULTIPOINT = 1639,
  T_FUN_SYS_MULTILINESTRING = 1640,
  T_FUN_SYS_POLYGON = 1641,
  T_FUN_SYS_MULTIPOLYGON = 1642,
  T_FUN_SYS_GEOMCOLLECTION = 1643,
  T_FUN_SYS_ST_COVERS = 1644,
  T_FUN_SYS_PRIV_ST_BESTSRID = 1645,
  T_FUN_SYS_ST_ASTEXT = 1646,
  T_FUN_SYS_ST_BUFFER_STRATEGY = 1647,
  T_FUN_SYS_ST_BUFFER = 1648,
  T_FUN_SYS_SPATIAL_CELLID = 1649,
  T_FUN_SYS_SPATIAL_MBR = 1650,
  T_FUN_SYS_ST_GEOMFROMEWKB = 1651,
  T_FUN_SYS_ST_GEOMFROMWKB = 1652,
  T_FUN_SYS_ST_GEOMETRYFROMWKB = 1653,
  T_FUN_SYS_ST_GEOMFROMEWKT = 1654,
  T_FUN_SYS_PRIV_ST_ASEWKT = 1655,
  T_FUN_SYS_ST_SRID = 1656,
  T_FUN_SYS_ST_ASWKT = 1657,
  T_FUN_SYS_ST_DISTANCE = 1658,
  T_FUN_SYS_ST_GEOMETRYFROMTEXT = 1659,
  T_FUN_SYS_PRIV_ST_SETSRID = 1660,
  T_FUN_SYS_PRIV_ST_POINT = 1661,
  T_FUN_SYS_PRIV_ST_GEOGFROMTEXT = 1662,
  T_FUN_SYS_PRIV_ST_GEOGRAPHYFROMTEXT = 1663,
  T_FUN_SYS_ST_ISVALID = 1664,
  T_FUN_SYS_PRIV_ST_BUFFER = 1665,
  T_FUN_SYS_ST_ASWKB = 1666,
  T_FUN_SYS_PRIV_ST_ASEWKB = 1667,
  T_FUN_SYS_ST_ASBINARY = 1668,
  T_FUN_SYS_ST_DISTANCE_SPHERE = 1669,
  T_FUN_SYS_ST_DWITHIN = 1670,
  T_FUN_SYS_ST_WITHIN = 1671,
  T_FUN_SYS_ST_CONTAINS = 1672,
  T_FUN_SYS_PRIV_ST_TRANSFORM = 1673,
  T_FUN_SYS_ST_GEOMFROMTEXT = 1674,
  T_FUN_SYS_ST_INTERSECTION = 1675,
  T_FUN_SYS_ST_AREA = 1676,
  T_FUN_SYS_ST_INTERSECTS = 1677,
  T_FUN_SYS_ST_X = 1678,
  T_FUN_SYS_ST_Y = 1679,
  T_FUN_SYS_ST_LATITUDE = 1680,
  // gis expr should add above
  // please maintain is_geo_expr / is_mysql_geo_expr / is_priv_geo_expr if other gis expr added

  T_FUN_SYS_IS_JSON = 1681,
  T_FUN_SYS_JSON_EQUAL = 1682,
  T_FUN_SYS_JSON_QUERY = 1683,
  T_FUN_ORA_JSON_ARRAYAGG = 1684,
  T_FUN_ORA_JSON_OBJECTAGG = 1685,
  T_FUN_SYS_JSON_EXISTS = 1686,
  T_FUN_SYS_TREAT = 1687,
  T_NULLX_CLAUSE = 1688,   // null clause on json expr
  T_FUN_SYS_NLS_INITCAP = 1689,
  T_WEIGHT_STRING_LEVEL_PARAM = 1690, // `level 1-2` and `level 1,2,3` clause on json expr
  T_FUN_SYS_CURRENT_SCN = 1691,
  T_FUN_SYS_MAKEXML = 1692,
  T_FUN_SYS_XML_ELEMENT = 1693,
  T_FUN_SYS_XMLPARSE = 1694,
  T_FUN_ORA_XMLAGG = 1695,
  T_FUN_SYS_XML_ATTRIBUTES = 1696,
  T_FUN_SYS_XML_EXTRACTVALUE = 1697,
  T_FUN_SYS_XML_EXTRACT = 1698,
  T_FUN_SYS_XML_SERIALIZE = 1699,
  T_FUN_SYS_XMLCAST = 1700,
  T_FUN_SYS_XML_ATTRIBUTES_VALUES = 1701,
  T_FUN_SYS_UPDATE_XML = 1702,
  T_FUN_SYS_PRIV_MAKE_XML_BINARY = 1703,  // add only for xml dml rewrite
  T_FUN_SYS_JSON_OBJECT_WILD_STAR = 1704, // wild star in json object
  ///< @note add new oracle only function type before this line

  T_FUN_SYS_TABLET_AUTOINC_NEXTVAL = 1801, // add only for heap table
  T_FUN_SYS_GENERATOR = 1802,
  T_FUN_SYS_ZIPF = 1803,
  T_FUN_SYS_NORMAL = 1804,
  T_FUN_SYS_UNIFORM = 1805,
  T_FUN_SYS_RANDOM = 1806,
  T_FUN_SYS_RANDSTR = 1807,
  T_FUN_SYS_END = 2000,
  T_FUN_SYS_ALIGN_DATE4CMP = 2010,

  T_MAX_OP = 3000,

  //pseudo column, to mark the group iterator id
  T_PSEUDO_GROUP_ID = 3003,

  T_INNER_AGGR_CODE = 3004,
  T_PSEUDO_SORT_KEY = 3005,
  T_PSEUDO_CALC_PART_SORT_KEY = 3006,
  T_PSEUDO_ROLLUP_ID = 3007,
  T_PSEUDO_DUP_EXPR = 3008,
  T_PSEUDO_STMT_ID = 3009,
  T_PSEUDO_RANDOM = 3010,
  T_INNER_WF_AGGR_STAUTS = 3011,
  T_PSEUDO_ROW_TRANS_INFO_COLUMN = 3012, // trans_info, only for defensive check
  T_PSEUDO_GROUP_PARAM = 3040,
  T_PSEUDO_EXTERNAL_FILE_COL = 3041,
  T_WINDOW_FUNCTION = 3151,
  T_WIN_GENERALIZED_WINDOW,
  T_WIN_NEW_GENERALIZED_WINDOW,
  T_WIN_WINDOW,
  T_WIN_NAMED_WINDOWS,
  T_WIN_NAMED_WINDOW,
  T_WIN_BOUND,
  T_WIN_INTERVAL,
  T_WIN_FUN_ROW_NUMBER,
  T_WIN_FUN_RANK,
  T_WIN_FUN_DENSE_RANK,
  T_WIN_FUN_PERCENT_RANK,
  T_WIN_FUN_SUM,
  T_WIN_FUN_MAX,
  T_WIN_FUN_NTILE,
  T_WIN_FUN_NTH_VALUE,
  T_WIN_FUN_FIRST_VALUE,
  T_WIN_FUN_LAST_VALUE,
  T_WIN_FUN_CUME_DIST,
  T_WIN_FUN_LEAD,
  T_WIN_FUN_LAG,
  T_WIN_FUN_AVG,
  T_WIN_FUN_RATIO_TO_REPORT,
  T_TABLET_AUTOINC_NEXTVAL = 3266, // hidden_pk for heap table

  ///< @note values of the following symbols are insiginificant
  T_DEFAULT,
  T_CAST_ARGUMENT,
  T_CHAR_CHARSET,
  T_HINT,     // Hint message from rowkey
  T_IDENT,
  T_SIMPLE_IDENT,
  T_STAR,
  T_SYSTEM_VARIABLE,
  T_USER_VARIABLE_IDENTIFIER,
  T_LEFT_VALUE,//assignment

  /* Data type tags */
  T_TYPE_INTEGER,
  T_TYPE_FLOAT,
  T_TYPE_DOUBLE,
  T_TYPE_DECIMAL,
  T_TYPE_BOOLEAN,
  T_TYPE_YEAR,
  T_TYPE_DATE,
  T_TYPE_TIME,
  T_TYPE_DATETIME,
  T_TYPE_TIMESTAMP,
  T_TYPE_CHARACTER,
  T_TYPE_VARCHAR,
  T_TYPE_NUMBER,

  /* name field specificator */
  T_COLUMN_REF,
  T_RELATION_FACTOR,
  T_RELATION_FACTOR_IN_HINT,
  T_RELATION_FACTOR_IN_HINT_LIST,

  /* parse tree node tags */
  /* insert parse tree node type*/
  T_INSERT,
  T_INSERT_INTO_CLAUSE,
  T_VALUE_LIST,
  T_SINGLE_TABLE_INSERT,

  T_DELETE,
  T_SELECT,
  T_UPDATE,
  T_MERGE,
  T_REPLACE,
  T_EXPLAIN,
  T_LINK_NODE,
  T_ASSIGN_LIST,
  T_ASSIGN_ITEM,
  T_STMT_LIST,
  T_EXPR_LIST,
  T_WHEN_LIST,
  T_PROJECT_LIST,
  T_PROJECT_ITEM,
  T_FROM_LIST,
  T_TABLE_REFERENCES,
  T_DELETE_TABLE_NODE,
  T_SET_UNION,
  T_SET_INTERSECT,
  T_SET_EXCEPT,
  T_CONNECT_BY_CLAUSE,
  T_NOCYCLE,
  T_SIBLINGS,
  T_WHERE_CLAUSE,
  T_GROUPBY_CLAUSE,
  T_GROUPBY_LIST,
  T_GROUPBY_KEY,
  T_ROLLUP,
  T_LIMIT_CLAUSE,
  T_COMMA_LIMIT_CLAUSE,
  T_LIKE_CLAUSE,
  T_SEPARATOR_CLAUSE,
  T_INTO_CLAUSE,
  T_INTO_OUTFILE,
  T_INTO_DUMPFILE,
  T_INTO_VARIABLES,
  T_SORT_LIST,
  T_SORT_KEY,
  T_SORT_ASC,
  T_SORT_DESC,
  T_ROLLUP_KEY,
  T_ROLLUP_DELIMIT,
  T_ALL,
  T_ANY,
  T_DISTINCT,
  T_ORG,
  T_ALIAS,
  T_PROJECT_STRING,
  T_COLUMN_LIST,
  T_VALUE_VECTOR,
  T_JOINED_TABLE,
  T_JOIN_INNER,
  T_JOIN_FULL,
  T_JOIN_LEFT,
  T_JOIN_RIGHT,
  T_JOIN_CROSS,
  T_NATURAL_JOIN,
  T_STRAIGHT_JOIN,
  T_CASE,
  T_WHEN,
  T_CREATE_TABLE,
  T_CREATE_TABLE_LIKE,
  T_CREATE_VIEW,
  T_ALTER_VIEW,
  T_TABLE_ELEMENT_LIST,
  T_TABLE_OPTION_LIST,
  T_PRIMARY_KEY,
  T_SPLIT_KEY,
  T_COLUMN_DEFINITION,
  T_COLUMN_ATTRIBUTES,
  T_CONSTR_NOT_NULL,
  T_CONSTR_NULL,
  T_CONSTR_DEFAULT,
  T_CONSTR_ORIG_DEFAULT,
  T_CONSTR_AUTO_INCREMENT,
  T_CONSTR_PRIMARY_KEY,
  T_CONSTR_UNIQUE_KEY,
  T_CONSTR_SRID,
  T_CHECK_CONSTRAINT,
  T_RESPECT,
  T_FIRST,
  T_LAST,
  T_VIRTUAL_COLUMN,
  T_STORED_COLUMN,
  T_IF_NOT_EXISTS,
  T_IF_EXISTS,
  T_JOIN_INFO,
  T_EXPIRE_INFO,
  T_TABLET_MAX_SIZE,
  T_BLOCK_SIZE,
  T_TABLE_ID,
  T_DATA_TABLE_ID,
  T_INDEX_TABLE_ID,
  T_TABLET_ID,
  T_TENANT_TABLET,
  T_TENANT_LS_TABLET,
  T_VIRTUAL_COLUMN_ID,
  T_DATABASE_ID,
  T_REPLICA_NUM,
  T_TABLET_SIZE,
  T_LOCALITY,
  T_DUPLICATE_SCOPE,
  T_LOGONLY_REPLICA_NUM,
  T_TABLEGROUP,
  T_COMPRESSION,
  T_PROGRESSIVE_MERGE_NUM,
  T_COMMENT,
  T_COLUMN_ID,
  T_ON_UPDATE,
  T_USE_BLOOM_FILTER,
  T_CHARSET,
  T_COLLATION,
  T_INDEX_SCOPE,
  T_DROP_TABLE,
  T_TABLE_LIST,
  T_DROP_VIEW,
  T_VIEW_LIST,
  T_PARTITION_OPTION,
  T_HASH_PARTITION,
  T_KEY_PARTITION,
  T_RANGE_PARTITION,
  T_RANGE_COLUMNS_PARTITION,
  T_LIST_PARTITION,
  T_LIST_COLUMNS_PARTITION,
  T_VERTICAL_COLUMNS_PARTITION,
  T_AUX_COLUMN_LIST,
  T_ADDR_PARTITION,
  T_PARTITION_LIST,
  T_PARTITION_ELEMENT,
  T_PART_ID,
  T_CREATE_SEQUENCE,
  T_DROP_SEQUENCE,
  T_ALTER_SEQUENCE,
  T_SEQUENCE_OPTION_LIST,
  T_REMOTE_SEQUENCE,
  T_INCREMENT_BY,
  T_START_WITH,
  T_MAXVALUE,
  T_NOMAXVALUE,
  T_MINVALUE,
  T_NOMINVALUE,
  T_CYCLE,
  /*T_NOCYCLE, defined */
  T_ORDER,
  T_NOORDER,
  T_CACHE,
  T_NOCACHE,
  T_RESTART,
  T_SIGNED,
  T_UNSIGNED,
  T_ZEROFILL,
  T_USE_PARTITION,
  T_AUTO_INCREMENT,
  T_AUTO_INCREMENT_MODE,
  T_ENABLE_EXTENDED_ROWID,
  T_USING_HASH,
  T_USING_BTREE,
  T_WITH_CLAUSE_AS,
  T_WITH_CLAUSE_LIST,
  T_CYCLE_NODE,
  T_SEARCH_BREADTH_NODE,
  T_SEARCH_DEPTH_NODE,
  T_EXPR_WITH_ALIAS,
  T_TABLE_COLLECTION_EXPRESSION,
  T_DIAGNOSTICS,
  T_JSON_TABLE_EXPRESSION,
  T_JSON_TABLE_COLUMN,

  //pseudo_column
  T_PSEUDO_COLUMN,
  T_LEVEL,
  T_CONNECT_BY_ISCYCLE,
  T_CONNECT_BY_ISLEAF,
  T_CTE_SEARCH_COLUMN,
  T_CTE_CYCLE_COLUMN,

  T_RENAME_TABLE,
  T_RENAME_TABLE_ACTION,
  T_TRUNCATE_TABLE,
  T_ALTER_TABLE,
  T_ALTER_TABLE_OPTION,
  T_ALTER_INDEX_OPTION,
  T_ALTER_CHECK_CONSTRAINT_OPTION,
  T_ALTER_PARTITION_OPTION,
  T_ALTER_PARTITION_DROP,
  T_ALTER_PARTITION_ADD,
  T_ALTER_COLUMN_OPTION,
  T_ALTER_TABLEGROUP_OPTION,
  T_ALTER_TABLE_ACTION_LIST,

  T_COLUMN_ADD,
  T_COLUMN_ADD_BEFORE,
  T_COLUMN_ADD_AFTER,
  T_COLUMN_ADD_FIRST,
  T_TABLE_RENAME,
  T_COLUMN_DROP,
  T_COLUMN_ALTER,
  T_COLUMN_RENAME,
  T_COLUMN_MODIFY,
  T_COLUMN_CHANGE,
  T_INDEX_ADD,
  T_INDEX_DROP,
  T_INDEX_ALTER,
  T_INDEX_RENAME,
  T_VISIBLE,
  T_INVISIBLE,
  T_TABLEGROUP_DROP,
  T_ORDER_BY,
  T_SET_TABLE_COMMENT,
  T_SET_COLUMN_COMMENT,
  T_MULTI_LOCK_ROWNUM, // add only for multi_part_for_update

  T_CREATE_TABLEGROUP,
  T_DROP_TABLEGROUP,
  T_ALTER_TABLEGROUP,
  T_DEFAULT_TABLEGROUP,
  T_TEMPORARY,

  T_ALTER_SYSTEM,
  T_CHANGE_OBI,
  T_FORCE,
  T_USE,
  T_IGNORE,
  T_INDEX_HINT_LIST,
  T_INDEX_HINT_DEF,
  T_SET_MASTER,
  T_SET_SLAVE,
  T_SET_MASTER_SLAVE,
  T_SYTEM_ACTION_LIST,
  T_SYSTEM_ACTION,
  T_CLUSTER,
  T_SERVER_INFO,
  T_SERVER_INFO_LIST,
  T_SERVER_LIST,
  T_CLUSTER_V2,
  T_SERVER_ADDRESS,
  T_SWITCH_MASTER_LIST,
  T_SWITCH_MASTER,
  T_SIWTCH_ACTION,
  T_SERVER_ACTION,
  T_ZONE_ACTION,
  T_IP_PORT,

  T_SHOW_TABLES, //新增show类型请添加在T_SHOW_TABLES后面
  T_SHOW_DATABASES,
  T_SHOW_VARIABLES,
  T_SHOW_COLUMNS,
  T_SHOW_SCHEMA,
  T_SHOW_CREATE_DATABASE,
  T_SHOW_CREATE_TABLE,
  T_SHOW_CREATE_VIEW,
  T_SHOW_TABLE_STATUS,
  T_SHOW_PARAMETERS,
  T_SHOW_INDEXES,
  T_SHOW_PROCESSLIST,
  T_SHOW_SERVER_STATUS,
  T_SHOW_WARNINGS,
  T_SHOW_ERRORS,
  T_SHOW_CHARSET,
  T_SHOW_COLLATION,
  T_SHOW_TABLEGROUPS,
  T_SHOW_STATUS,
  T_SHOW_TENANT,
  T_SHOW_CREATE_TENANT,
  T_SHOW_TRACE,
  T_SHOW_ENGINES,
  T_SHOW_PRIVILEGES,
  T_SHOW_RECYCLEBIN,
  T_SHOW_CREATE_PROCEDURE,
  T_SHOW_CREATE_FUNCTION,
  T_SHOW_PROCEDURE_STATUS,
  T_SHOW_FUNCTION_STATUS,
  T_SHOW_CREATE_TABLEGROUP,
  T_SHOW_RESTORE_PREVIEW,
  T_SHOW_CREATE_TRIGGER,
  T_SHOW_QUERY_RESPONSE_TIME,
  T_SHOW_SEQUENCES,
  T_SHOW_GRANTS, //新增show类型请添加在T_SHOW_GRANTS前面

  T_SHOW_LIMIT,
  T_CREATE_USER,
  T_CREATE_USER_SPEC,
  T_DROP_USER,
  T_SET_PASSWORD,
  T_RENAME_USER,
  T_RENAME_INFO,
  T_LOCK_USER,
  T_GRANT,
  T_PRIVILEGES,
  T_PRIV_LEVEL,
  T_PRIV_TYPE,
  T_USERS,
  T_REVOKE,
  T_REVOKE_ALL,
  T_BEGIN,
  T_COMMIT,
  T_PREPARE,
  T_DEALLOCATE,
  T_EXECUTE,
  T_ARGUMENT_LIST,
  T_VARIABLE_SET,
  T_VAR_VAL,
  T_ROLLBACK,
  T_ANY_HOST_NAME,
  T_USER_WITH_HOST_NAME,

  T_INDEX_COLUMN_LIST,
  T_INDEX_USING_ALGORITHM,
  T_CREATE_INDEX,
  T_SORT_COLUMN_KEY,
  T_STORING,
  T_STORING_COLUMN_LIST,
  T_WITH_ROWID,
  T_PARSER_NAME,
  T_DROP_INDEX,

  //recycle related
  T_FLASHBACK_TENANT,
  T_FLASHBACK_DATABASE,
  T_FLASHBACK_TABLE_FROM_RECYCLEBIN,
  T_FLASHBACK_INDEX,
  T_PURGE_RECYCLEBIN,
  T_PURGE_TENANT,
  T_PURGE_DATABASE,
  T_PURGE_TABLE,
  T_PURGE_INDEX,

  T_HINT_OPTION_LIST,
  T_READ_CONSISTENCY,
  T_INDEX,
  T_FROZEN_VERSION,
  T_TOPK,
  T_CLIENT_VERSION,
  T_MYSQL_DRIVER,
  T_QUERY_TIMEOUT,
  T_DBLINK_INFO,
  T_LOG_LEVEL,
  T_LEADING,
  T_ORDERED,
  T_INDEX_HINT,
  T_NO_INDEX_HINT,
  T_FULL_HINT,
  T_USE_DAS_HINT,
  T_NO_USE_DAS_HINT,
  T_INDEX_SS_HINT,
  T_INDEX_SS_ASC_HINT,
  T_INDEX_SS_DESC_HINT,
  T_USE_MERGE,
  T_USE_HASH,
  T_NO_USE_HASH,
  T_USE_NL,
  T_USE_PLAN_CACHE,
  T_USE_HASH_AGGREGATE,
  T_NO_USE_HASH_AGGREGATE,
  T_GBY_PUSHDOWN,
  T_NO_GBY_PUSHDOWN,
  T_USE_HASH_DISTINCT,
  T_NO_USE_HASH_DISTINCT,
  T_DISTINCT_PUSHDOWN,
  T_NO_DISTINCT_PUSHDOWN,
  T_USE_HASH_SET,
  T_NO_USE_HASH_SET,
  T_NEG_SIGN, /* 用于支持hint里的负数 */
  T_USE_LATE_MATERIALIZATION,
  T_NO_USE_LATE_MATERIALIZATION,
  T_NO_REWRITE,
  T_TRACE_LOG,
  T_QB_NAME,
  T_QB_NAME_LIST,
  T_MAX_CONCURRENT,
  T_PARALLEL,
  T_TABLE_PARALLEL,
  T_NO_PARALLEL,
  T_MONITOR,
  T_PQ_DISTRIBUTE,
  T_PQ_DISTRIBUTE_WINDOW,
  T_WIN_FUNC_IDX_LIST,
  T_PQ_SET,
  T_DISTRIBUTE_BROADCAST,
  T_DISTRIBUTE_HASH,
  T_DISTRIBUTE_NONE,
  T_DISTRIBUTE_ALL,
  T_DISTRIBUTE_PARTITION,
  T_DISTRIBUTE_LOCAL,
  T_DISTRIBUTE_BC2HOST,
  T_DISTRIBUTE_RANDOM,
  T_DISTRIBUTE_RANGE,
  T_DISTRIBUTE_LIST,
  T_DISTRIBUTE_METHOD_LIST,
  T_PX_JOIN_FILTER,
  T_TRACING,
  T_DOP,
  T_STAT,
  T_GATHER_OPTIMIZER_STATISTICS,
  T_NO_GATHER_OPTIMIZER_STATISTICS,
  T_APPEND,
  T_DBMS_STATS,

  T_KILL,
  T_HELP,
  T_CANCEL,
  T_CANCEL_TASK,
  T_BOOTSTRAP,
  T_FLUSH_CACHE,
  T_FLUSH_KVCACHE,
  T_FLUSH_ILOGCACHE,
  T_ADMIN_SERVER,
  T_ADMIN_ZONE,
  T_FLASHBACK_READ_TX_UNCOMMITTED,
  T_CS_DISKMAINTAIN,
  T_DISK_OP_PARAM,
  T_CS_ADMIN_PARAMS,
  T_CREATE_TABLET,
  T_CHECK_TABLET,
  T_REPORT_REPLICA,
  T_IP_PORT_CLUSTER,
  T_RANGE,
  T_VERSION,
  T_IP_SOURCE,
  T_IP_DESTINATION,
  T_SWITCH_ROOTSERVER,
  T_SWITCH_UPDATESERVER,
  T_CLUSTER_MANAGER,
  T_CLUSTER_ID,
  T_FREEZE,
  T_DROP_MEMTABLE,
  T_CLEAR_MEMTABLE,
  T_DELAY,
  T_PRINT_ROOT_TABLE,
  T_ADD_UPDATESERVER,
  T_DELETE_UPDATESERVER,
  T_CHECK_ROOT_TABLE,
  T_CLEAR_ROOT_TABLE,
  T_REFRESH_SCHEMA,
  T_REFRESH_MEMORY_STAT,
  T_WASH_MEMORY_FRAGMENTATION,
  T_NAME_LIST,
  T_CREATE_DATABASE,
  T_DROP_DATABASE,
  T_ALTER_DATABASE,
  T_USE_DATABASE,
  T_DATABASE_OPTION_LIST,
  T_DATABASE_LIST,
  T_CREATE_TENANT,
  T_CREATE_STANDBY_TENANT,
  T_DROP_TENANT,
  T_MODIFY_TENANT,
  T_LOCK_TENANT,
  T_LOG_RESTORE_SOURCE,
  T_ZONE_LIST,
  T_RESOURCE_POOL_LIST,
  T_ZONE,
  T_TENANT_RESOURCE_POOL_LIST,
  T_TENANT_OPTION_LIST,
  T_PRIMARY_ZONE,
  T_READ_ONLY,
  T_STORAGE_FORMAT_VERSION,
  T_ENGINE,
  T_ON,
  T_OFF,

  T_CREATE_RESOURCE_UNIT,
  T_ALTER_RESOURCE_UNIT,
  T_DROP_RESOURCE_UNIT,
  T_RESOURCE_POOL_OPTION_LIST,
  T_UNIT,
  T_UNIT_NUM,
  T_UNIT_ID_LIST,

  T_CREATE_RESOURCE_POOL,
  T_DROP_RESOURCE_POOL,
  T_ALTER_RESOURCE_POOL,
  T_SPLIT_RESOURCE_POOL,
  T_RESOURCE_UNIT_OPTION_LIST,
  T_MAX_CPU,
  T_MEMORY_SIZE,
  T_MAX_IOPS,
  T_IOPS_WEIGHT,
  T_LOG_DISK_SIZE,
  T_MAX_SESSION_NUM,
  T_MIN_CPU,
  T_MIN_IOPS,
  T_BASIC,
  T_OUTLINE,
  T_EXTENDED,
  T_PARTITIONS,
  T_TRADITIONAL,
  T_FORMAT_JSON,
  T_EXTENDED_NOADDR,
  T_PLANREGRESS,

  T_SFU_INT,
  T_SFU_DECIMAL,
  T_SFU_DOUBLE,
  T_FOR_UPDATE,
  T_SKIP_LOCKED,
  T_ERR_LOG_CALUSE,
  T_INTO_ERR_LOG_TABLE,
  T_ERR_LOG_SIMPLE_EXPR,
  T_ERR_LOG_LIMIT,
  T_DEFAULT_INT,
  T_DEFAULT_NULL,
  T_LS,
  T_PARTITION_ID_SERVER,
  T_SERVER_TENANT,
  T_LS_SERVER_TENANT,
  T_ZONE_TENANT,
  T_SWITCH_REPLICA_ROLE,
  T_SWITCH_RS_ROLE,
  T_CREATE_TIMESTAMP,
  T_RECYCLE_REPLICA,
  T_MERGE_CONTROL,
  T_TENANT_NAME,
  T_CACHE_NAME,
  T_FILE_ID,
  T_TENANT_LIST,
  T_CHANGE_TENANT,
  T_SET_NAMES,
  T_SET_CHARSET,
  T_CLEAR_LOCATION_CACHE,
  T_RELOAD_UNIT,
  T_EMPTY,
  T_CONCAT_STRING,
  T_FOUND_ROWS,
  T_BINARY,
  T_TRANSACTION,
  T_TRANSACTION_CHARACTERISTICS,
  T_RELOAD_SERVER,
  T_RELOAD_ZONE,
  T_MIGRATE_UNIT,
  T_ADD_ARBITRATION_SERVICE,
  T_REMOVE_ARBITRATION_SERVICE,
  T_REPLACE_ARBITRATION_SERVICE,
  T_ENABLE_ARBITRATION_SERVICE,
  T_CLEAR_MERGE_ERROR,
  T_QEURY_EXPRESSION_LIST,
  T_UPGRADE_VIRTUAL_SCHEMA,
  T_RUN_JOB,
  T_EMPTY_QUERY,
  T_LOCK_TABLE,
  T_CREATE_OUTLINE,
  T_ALTER_OUTLINE,
  T_DROP_OUTLINE,
  T_ADMIN_UPGRADE_CMD,
  T_GATHER_PLAN_STATISTICS,
  T_TP_NAME,
  T_TP_NO,
  T_TP_COND,
  T_ACTION,
  T_ERROR,
  T_ERROR_CODE,
  T_SYTEM_SETTP_LIST,
  T_ALTER_SYSTEM_SETTP,
  T_ALTER_SYSTEM_DROP_TEMP_TABLE,
  T_ALTER_SYSTEM_REFRESH_TEMP_TABLE,
  T_ALTER_DISKGROUP_ADD_DISK,
  T_ALTER_DISKGROUP_DROP_DISK,
  T_OCCUR,
  T_TRIGGER_MODE,
  T_REFRESH_TIME_ZONE_INFO,
  T_REGION,
  T_SET_REGION_NETWORK_BANDWIDTH,
  T_SET_MERGE_LIST,
  T_INTO_VARS_LIST,
  T_INTO_FIELD_LIST,
  T_INTO_LINE_LIST,
  T_FIELD_TERMINATED_STR,
  T_OPTIONALLY_CLOSED_STR,
  T_CLOSED_STR,
  T_LINE_TERMINATED_STR,
  T_LINE_START_STR,
  T_CHANGE_LIST,
  T_REPLICA_TYPE,
  T_PCTFREE,
  T_SET_DISK_VALID,

  T_SQL_STATE,
  T_SQL_EXCEPTION,
  T_SQL_WARNING,
  T_SQL_NOT_FOUND,
  T_SP_EXCEPTION_OTHERS,

  //pl parse item type
  T_SP_PARAM,
  T_SP_PARAM_LIST,
  T_SP_NAME,
  T_SP_ACCESS_NAME,
  T_SP_CREATE,
  T_SP_ALTER,
  T_SP_COMPILE_CLAUSE,
  T_SP_EDITIONABLE_CLAUSE,
  T_SP_DROP,
  T_SP_SOURCE,
  T_SP_PROC_STMT_LIST,
  T_SQL_STMT,
  T_EXPR,
  T_SP_USING_LIST,
  T_SP_USING_PARAM,
  T_SP_EXECUTE_IMMEDIATE,
  T_SP_BLOCK_CONTENT,
  T_SP_LABELED_BLOCK,
  T_SP_DECL_LIST,
  T_SP_DECL,
  T_SP_DECL_COND,
  T_SP_INIT_PRAGMA,
  T_SP_INIT_PRAGMA_PARAM_LIST,
  T_SP_DECL_HANDLER,
  T_SP_DECL_IDENT_LIST,
  T_SP_DECL_DEFAULT,
  T_SP_DECL_CURSOR,
  T_SP_EXTEND,
  T_SP_DELETE,
  T_SP_DO,
  T_SP_IF,
  T_SP_ELSE,
  T_SP_CASE,
  T_SP_WHEN,
  T_SP_RETURN,
  T_SP_GOTO,
  T_SP_CPARAM,
  T_SP_CPARAM_LIST,
  T_SP_CALL_STMT,
  T_SP_INNER_CALL_STMT,
  T_SP_ANONYMOUS_BLOCK,
  T_SP_NULL,
  T_SP_PIPELINED,
  T_SP_PIPE_ROW,
  T_SP_LOOP,
  T_SP_WHILE,
  T_SP_REPEAT,
  T_SP_LABELED_CONTROL,
  T_SP_ITERATE,
  T_SP_LEAVE,
  T_SP_CONDITION,
  T_SP_HCOND_LIST,
  T_SF_CREATE,
  T_SF_ALTER,
  T_SF_DROP,
  T_SF_SOURCE,
  T_SF_AGGREGATE_BODY,
  T_SF_AGGREGATE_SOURCE,
  T_SP_SIGNAL,
  T_SP_RESIGNAL,
  T_SP_SIGNAL_INFO_LIST,
  T_SP_SIGNAL_INFO_ITEM,
  T_SP_REF_CURSOR_TYPE,
  T_RECORD_MEMBER,
  T_RECORD_MEMBER_LIST,
  T_SP_RECORD_TYPE,
  T_SP_COLLECTION_TYPE,
  T_SP_DECL_USER_TYPE,
  T_SP_NESTED_TABLE_TYPE,
  T_SP_ASSOC_ARRAY_TYPE,
  T_SP_VARRAY_TYPE,
  T_SP_PROC_OPEN,
  T_SP_PROC_FETCH,
  T_SP_PROC_CLOSE,
  T_SP_INTO_LIST,
  T_SP_OBJ_ACCESS_REF,
  T_SP_INVOKE,
  T_SP_ACCESSOR,
  T_SP_ACCESSOR_KIND,
  T_SP_ACCESSOR_LIST,
  T_SP_ACCESSIBLE_BY,
  T_SP_DETERMINISTIC,
  T_SP_PARALLEL_ENABLE,
  T_SP_SOURCE_LIST,
  T_SP_RELIES_ON,
  T_SP_RESULT_CACHE,
  T_SP_CLAUSE_LIST,
  T_SP_INTEGER_TYPE,
  T_SP_FOR_LOOP,
  T_SP_CURSOR_FOR_LOOP,
  T_SP_BOUND_CLAUSE,
  T_SP_INDICES_OF_CALUSE,
  T_SP_VALUES_OF_CALUSE,
  T_SP_FORALL,
  T_SP_TYPE,
  T_SP_ROWTYPE,
  T_SP_DBLINK_TYPE,
  T_SP_DECL_USER_SUBTYPE,
  T_SP_USER_SUBTYPE_RANGE,
  T_SP_USER_SUBTYPE_BASETYPE,
  T_SP_PRAGMA_INLINE,
  T_SP_PRAGMA_UDF,
  T_SP_PRAGMA_SERIALLY_REUSABLE,
  T_SP_PRAGMA_RESTRICT_REFERENCE,
  T_SP_PRAGMA_AUTONOMOUS_TRANSACTION,
  T_SP_PRAGMA_INTERFACE,

  T_SP_CURSOR_ISOPEN,
  T_SP_CURSOR_FOUND,
  T_SP_CURSOR_NOTFOUND,
  T_SP_CURSOR_ROWCOUNT,
  T_SP_CURSOR_ROWID,
  T_SP_CURSOR_BULK_ROWCOUNT,
  T_SP_CURSOR_BULK_EXCEPTIONS,
  T_SP_CURSOR_BULK_EXCEPTIONS_COUNT,
  T_SP_IMPLICIT_CURSOR_ATTR,
  T_SP_EXPLICIT_CURSOR_ATTR,

  // user define type parse item type
  T_SP_CREATE_TYPE,
  T_SP_DROP_TYPE,
  T_SP_OBJECT_DEF,
  T_SP_IS_OBJECT,
  T_SP_IS_UNDER_OBJECT,
  T_SP_SQLJ_OBJ_TYPE,
  T_SP_OBJ_FINAL,
  T_SP_OBJ_INISTANTIABLE,
  T_SP_OBJ_FINAL_INST_LIST,
  T_SP_OBJ_ATTR_LIST,
  T_SP_OBJ_ATTR_AND_ELEMENT_SPEC,
  T_SP_OBJ_ATTR_SPEC,
  T_SP_OBJ_SQLJ_TYPE_ATTR,
  T_SP_OBJ_ELEMENT_SPEC,
  T_SP_OBJ_INHERITANCE,
  T_SP_OBJ_RESTRICT,
  T_SP_ASSERT_ITEM,
  T_SP_ASSERT_ITEM_LIST,
  T_SP_OBJ_ELEM_SUBPROG_SPEC,
  T_SP_OBJ_SQLJ_FUNC_DECL,
  T_SP_OBJ_SQLJ_SIG,
  T_SP_OBJ_SELF_RESULT,
  T_SP_OBJ_VARIABLE_NAME,
  T_SP_OBJ_NAME,
  T_SP_OBJ_ELEM_CONSTRUCTOR,
  T_SP_OBJ_CONSTRUCT_PARAM,
  T_SP_OBJ_SELF_INOUT,
  T_SP_OBJ_CONSTR_PARAM,
  T_SP_OBJ_MAP_ORDER,
  T_SP_OBJ_CONSTR_IMPL,

  //pl package parse item type
  T_PACKAGE_CREATE,
  T_PACKAGE_CREATE_BODY,
  T_PACKAGE_BLOCK,
  T_PACKAGE_BODY_BLOCK,
  T_PACKAGE_STMTS,
  T_PACKAGE_BODY_STMTS,
  T_PACKAGE_ALTER,
  T_PACKAGE_DROP,
  T_SUB_FUNC_DECL,
  T_SUB_FUNC_DEF,
  T_SUB_PROC_DECL,
  T_SUB_PROC_DEF,
  T_PACKAGE_ALTER_OPTIONS,

  //event job parse item type
  T_EVENT_JOB_EVERY,
  T_EVENT_JOB_WITH_ON,
  T_EVENT_JOB_CREATE,
  T_EVENT_JOB_ALTER,
  T_EVENT_JOB_DROP,

  T_CLEAR_BALANCE_TASK,
  T_BALANCE_TASK_TYPE,
  T_CREATE_SYNONYM,
  T_DROP_SYNONYM,
  T_CREATE_FUNC,
  T_DROP_FUNC,
  T_PUBLIC,
  T_DLINK,
  T_IDC,
  T_STRING_LIST,
  T_ZONE_TYPE,
  T_SQL_ID,
  T_NAMESPACE,
  T_ALTER_TABLEGROUP_ACTION_LIST,
  T_TABLEGROUP_OPTION_LIST,
  T_RETURNING,
  T_SAMPLE_SCAN,
  T_EXPR_NUM,
  T_BASE,
  T_INCR,
  T_ALTER_PARTITION_PARTITIONED,
  T_ENCRYPTION,
  T_RANDOM,
  T_TABLEGROUP_ID,
  T_TABLEGROUP_BINDING,
  T_TABLEGROUP_SHARDING,
  T_MAX_USED_PART_ID,
  T_TENANT_ID,

  //load data
  T_LOAD_DATA,
  T_LOCAL,
  T_ESCAPED_STR,
  T_IGNORE_ROWS,
  T_LOAD_DATA_ERR_FILE,
  T_LOAD_DATA_REJECT_LIMIT,
  T_LOAD_DATA_BAD_FILE,

  // foreign key
  T_REFERENCE_OPTION_LIST,
  T_REFERENCE_OPTION,
  T_FOREIGN_KEY,
  T_RESTRICT,
  T_CASCADE,
  T_SET_NULL,
  T_NO_ACTION,
  T_SET_DEFAULT,
  T_ALTER_FOREIGN_KEY_OPTION,
  T_FOREIGN_KEY_DROP,
  T_FOREIGN_KEY_MATCH,
  T_FULL,
  T_SIMPLE,
  T_PARTIAL,
  T_CLUSTER_ROLE,
  T_USER_INFO,
  T_CLUSTER_NAME_ID,
  T_SWTICH_CLUSTER_ROLE,

  // partition manager
  T_ALTER_PARTITION_SPLIT,
  T_SPLIT_ACTION,
  T_ALTER_PARTITION_REORGANIZE,
  T_ALTER_PARTITION_TRUNCATE,
  T_ALTER_SUBPARTITION_ADD,
  T_ALTER_SUBPARTITION_DROP,
  T_ALTER_SUBPARTITION_TRUNCATE,
  T_ALTER_SUBPARTITION_RENAME,
  T_ALTER_PARTITION_RENAME,

  T_ANALYZE,
  T_ANALYZE_STATISTICS,
  T_ANALYZE_FOR_CLAUSE_LIST,
  T_ANALYZE_TABLE,
  T_ANALYZE_ALL_COLUMNS,
  T_ANALYZE_COLUMN_LIST,
  T_ANALYZE_SOME_COLUMNS,
  T_ANALYZE_COLUMN_INFO,
  T_ANALYZE_SAMPLE_INFO,
  T_MYSQL_UPDATE_HISTOGRAM,
  T_MYSQL_DROP_HISTOGRAM,
  T_ANALYZE_MYSQL_COLUMN_LIST,
  T_SWITCHOVER,
  T_SWITCHOVER_TO_PRIMARY,
  T_SWITCHOVER_TO_STANDBY,
  T_RECOVER,
  T_RECOVER_UNLIMITED,
  T_RECOVER_CANCEL,
  T_ALTER_SYSTEM_SET,
  T_ALTER_SYSTEM_SET_PARAMETER,
  T_ALTER_SESSION_SET,
  T_ALTER_SESSION_SET_PARAMETER_LIST,
  T_USING_INDEX,
  T_REFERENCES_CLAUSE,
  T_DROP_USER_LIST,
  T_CASCADE_CONSTRAINTS,
  T_PURGE,
  T_STORE_FORMAT,

  //split partition
  T_SPLIT_RANGE,
  T_SPLIT_LIST,
  T_OPTIMIZE_TABLE,
  T_OPTIMIZE_TENANT,
  T_OPTIMIZE_ALL,
  // xa transaction
  T_XA_START,
  T_XA_END,
  T_XA_PREPARE,
  T_XA_COMMIT,
  T_XA_ROLLBACK,
  //cluster mgr
  T_REMOVE_CLUSTER,
  T_ADD_CLUSTER,
  T_TABLE_FLASHBACK_QUERY_TIMESTAMP,
  T_TABLE_FLASHBACK_QUERY_SCN,
  T_TABLE_FLASHBACK_QUERY,
  T_FAILOVER_TO_PRIMARY,
  T_ENABLE_ROW_MOVEMENT,
  T_ORA_ROWSCN,

  T_TABLE_MODE,
  T_TABLE_CHECKSUM,
  T_DELAY_KEY_WRITE,
  T_AVG_ROW_LENGTH,
  T_RELOAD_GTS,
  T_ALTER_CONSTRAINT_OPTION,
  T_DROP_CONSTRAINT,
  T_CREATE_SAVEPOINT,
  T_ROLLBACK_SAVEPOINT,
  T_RELEASE_SAVEPOINT,
  T_CONSTRAINT_STATE,
  T_RELY_CONSTRAINT,
  T_NORELY_CONSTRAINT,
  T_ENABLE_CONSTRAINT,
  T_DISABLE_CONSTRAINT,
  T_VALIDATE_CONSTRAINT,
  T_NOVALIDATE_CONSTRAINT,
  T_RELATION_FACTOR_IN_USE_JOIN_HINT_LIST,
  T_NO_USE_MERGE,
  T_NO_USE_NL,
  T_BEGIN_OUTLINE_DATA,
  T_END_OUTLINE_DATA,
  T_OUTLINE_HINT,
  T_OPTIMIZER_FEATURES_ENABLE,
  T_OPT_PARAM_HINT,

  T_CREATE_ROLE,
  T_DROP_ROLE,
  T_ALTER_ROLE,
  T_SET_ROLE,
  T_SET_ROLE_PASSWORD,
  T_WITH_ADMIN_OPTION,
  T_SYSTEM_GRANT,
  T_GRANT_ROLE,
  T_SYSTEM_REVOKE,
  T_REVOKE_ROLE,

  //keystore
  T_CREATE_KEYSTORE,
  T_ALTER_KEYSTORE_PASSWORD,
  T_ALTER_KEYSTORE_SET_KEY,
  T_ALTER_KEYSTORE_CLOSE,
  T_ALTER_KEYSTORE_OPEN,

  T_SHOW_TRIGGERS,

  //tablespace
  T_CREATE_TABLESPACE,
  T_ENCRYPT_ALGORITHM,
  T_PERMANENT_TABLESPACE,
  T_DROP_TABLESPACE,
  T_TABLESPACE,
  //profile
  T_ALTER_USER_PROFILE,
  T_CREATE_PROFILE,
  T_ALTER_PROFILE,
  T_DROP_PROFILE,
  T_USER_PROFILE,
  T_PROFILE_PARAM_LIST,
  T_PROFILE_PAIR,
  T_PROFILE_UNLIMITED,
  T_PROFILE_DEFAULT,
  T_PCTUSED,
  T_INITRANS,
  T_MAXTRANS,
  T_STORAGE_OPTIONS,
  T_STORAGE_INITIAL,
  T_STORAGE_NEXT,
  T_STORAGE_MINEXTENTS,
  T_STORAGE_MAXEXTENTS,
  T_SIZE_OPTION,
  T_SIZE_INT,
  T_SIZE_UNLIMITED,
  T_MERGE_HINT,
  T_NO_MERGE_HINT,
  T_NO_EXPAND,
  T_USE_CONCAT,
  T_UNNEST,
  T_NO_UNNEST,
  T_INLINE,
  T_MATERIALIZE,
  T_PLACE_GROUP_BY,
  T_NO_PLACE_GROUP_BY,
  T_SEMI_TO_INNER,
  T_NO_SEMI_TO_INNER,
  T_REPLACE_CONST,
  T_NO_REPLACE_CONST,
  T_SIMPLIFY_ORDER_BY,
  T_NO_SIMPLIFY_ORDER_BY,
  T_SIMPLIFY_GROUP_BY,
  T_NO_SIMPLIFY_GROUP_BY,
  T_SIMPLIFY_DISTINCT,
  T_NO_SIMPLIFY_DISTINCT,
  T_SIMPLIFY_WINFUNC,
  T_NO_SIMPLIFY_WINFUNC,
  T_SIMPLIFY_EXPR,
  T_NO_SIMPLIFY_EXPR,
  T_SIMPLIFY_LIMIT,
  T_NO_SIMPLIFY_LIMIT,
  T_SIMPLIFY_SUBQUERY,
  T_NO_SIMPLIFY_SUBQUERY,
  T_FAST_MINMAX,
  T_NO_FAST_MINMAX,
  T_PROJECT_PRUNE,
  T_NO_PROJECT_PRUNE,
  T_SIMPLIFY_SET,
  T_NO_SIMPLIFY_SET,
  T_OUTER_TO_INNER,
  T_NO_OUTER_TO_INNER,
  T_COALESCE_SQ,
  T_NO_COALESCE_SQ,
  T_COUNT_TO_EXISTS,
  T_NO_COUNT_TO_EXISTS,
  T_LEFT_TO_ANTI,
  T_NO_LEFT_TO_ANTI,
  T_PUSH_LIMIT,
  T_NO_PUSH_LIMIT,
  T_ELIMINATE_JOIN,
  T_NO_ELIMINATE_JOIN,
  T_WIN_MAGIC,
  T_NO_WIN_MAGIC,
  T_PULLUP_EXPR,
  T_NO_PULLUP_EXPR,
  T_AGGR_FIRST_UNNEST,
  T_NO_AGGR_FIRST_UNNEST,
  T_JOIN_FIRST_UNNEST,
  T_NO_JOIN_FIRST_UNNEST,
  T_INTERVAL_LITERAL,
  //T_INTERVAL_YM_LITERAL,
  //T_INTERVAL_DS_LITERAL,

  // trigger parse item type
  T_TG_ALTER,
  T_TG_CREATE,
  T_TG_DROP,
  T_TG_SOURCE,
  T_TG_SIMPLE_DML,
  T_TG_COMPOUND_DML,
  T_TG_INSTEAD_DML,
  T_TG_SYSTEM,
  T_BEFORE,
  T_AFTER,
  T_INSTEAD,
  T_ENABLE,
  T_DISABLE,
  T_TP_STATEMENT,
  T_TP_EACH_ROW,
  T_TG_DML_EVENT_OPTION,
  T_TG_DML_EVENT_LIST,
  T_TG_DML_EVENT,
  T_TG_WHEN_CONDITION,
//  T_TG_SIMPLE_BODY,
//  T_TG_SIMPLE_DECLARE,
//  T_TG_EXECUTE_BLOCK,
  T_TG_COMPOUND_BODY,
  T_TG_TIMPING_POINT_SECTION_LIST,
  T_TG_TIMPING_POINT_SECTION,
  T_TG_COLUMN_LIST,
  T_TG_REF_OLD,
  T_TG_REF_NEW,
  T_TG_REF_PARENT,
  T_TG_REF_LIST,
  T_USE_NL_MATERIALIZATION,
  T_NO_USE_NL_MATERIALIZATION,
  T_FLASHBACK_TABLE_TO_TIMESTAMP,
  T_FLASHBACK_TABLE_TO_SCN,
  T_RELATION_FACTORS,

  //ssl
  T_TLS_OPTIONS,
  T_TLS_NONE,
  T_TLS_SSL,
  T_TLS_XFZN,//x509
  T_TLS_SPECIFIED,
  T_TLS_CIPHER,
  T_TLS_ISSUER,
  T_TLS_SUBJECT,
  T_ROLLUP_LIST,
  T_WITH_ROLLUP_CLAUSE,

  T_MODIFY_CONSTRAINT_OPTION,

  //security audit
  T_AUDIT,
  T_AUDIT_STMT,
  T_AUDIT_OBJECT,
  T_AUDIT_ALL,
  T_AUDIT_ALL_STMT,

  T_AUDIT_ALTER_SYSTEM,
  T_AUDIT_CLUSTER,
  T_AUDIT_CONTEXT,
  T_AUDIT_DBLINK,
  T_AUDIT_INDEX,
  T_AUDIT_MATERIALIZED_VIEW,
  T_AUDIT_NOT_EXIST,
  T_AUDIT_OUTLINE,
  T_AUDIT_PROCEDURE,
  T_AUDIT_PROFILE,
  T_AUDIT_PUBLIC_DBLINK,
  T_AUDIT_PUBLIC_SYNONYM,
  T_AUDIT_ROLE,
  T_AUDIT_SEQUENCE,
  T_AUDIT_SESSION,
  T_AUDIT_SYNONYM,
  T_AUDIT_SYSTEM_AUDIT,
  T_AUDIT_SYSTEM_GRANT,
  T_AUDIT_TABLE,
  T_AUDIT_TABLESPACE,
  T_AUDIT_TRIGGER,
  T_AUDIT_TYPE,
  T_AUDIT_USER,
  T_AUDIT_VIEW,

  T_AUDIT_ALTER_SEQUENCE,
  T_AUDIT_ALTER_TABLE,
  T_AUDIT_COMMENT_TABLE ,
  T_AUDIT_DELETE_TABLE,
  T_AUDIT_EXECUTE_PROCEDURE,
  T_AUDIT_GRANT_PROCEDURE,
  T_AUDIT_GRANT_SEQUENCE,
  T_AUDIT_GRANT_TABLE,
  T_AUDIT_GRANT_TYPE,
  T_AUDIT_INSERT_TABLE,
  T_AUDIT_SELECT_SEQUENCE,
  T_AUDIT_SELECT_TABLE,
  T_AUDIT_UPDATE_TABLE,

  T_AUDIT_ALTER,
  T_AUDIT_AUDIT,
  T_AUDIT_COMMENT,
  T_AUDIT_DELETE,
  T_AUDIT_EXECUTE,
  T_AUDIT_FLASHBACK,
  T_AUDIT_GRANT,
  T_AUDIT_INSERT,
  T_AUDIT_LOCK,
  T_AUDIT_RENAME,
  T_AUDIT_SELECT,
  T_AUDIT_UPDATE,
  T_AUDIT_DIRECTORY,

  T_ALTER_CLUSTER,
  T_CLUSTER_INFO,
  T_CONVERT_TO_STANDBY,
  T_MEMSTORE_PERCENT,
  T_GRANT_SYS_PRIV_ORACLE,
  T_ORACLE_SYS_PRIV_TYPE,
  T_DISCONNECT_CLUSTER,
  T_VERIFY,
  T_OBCONFIG_URL,
  T_ARCHIVE_LOG,
  T_BACKUP_DATABASE,
  T_RECOVER_TABLE,
  T_REMAP_TABLE,
  T_REMAP_TABLEGROUP,
  T_REMAP_TABLESPACE,
  T_BACKUP_MANAGE,
  T_BACKUP_CLEAN,
  T_DELETE_POLICY,
  T_BACKUP_KEY,
  T_RESTORE_TENANT_2,
  T_CANCEL_RESTORE,
  T_CANCEL_RECOVER_TABLE,
  T_GEN_ROWS,
  T_LOAD_BATCH_SIZE,
  T_DIRECT, // direct load data
  T_REMOTE_OSS,
  T_PHYSICAL_RESTORE_TENANT,
  T_RECOVER_TABLE_REMAP,
  T_PHYSICAL_RESTORE_UNTIL,
  T_REVOKE_SYSAUTH,

  // hint, for slave mapping
  T_PQ_MAP,
  T_ORA_PRIV_TYPE,
  T_ORA_ROLE_TYPE,

  T_ENABLE_PARALLEL_DML,
  T_DISABLE_PARALLEL_DML,
  T_USE_DISTRIBUTED_DML,
  T_NO_USE_DISTRIBUTED_DML,
  T_NO_QUERY_TRANSFORMATION,
  T_NO_COST_BASED_QUERY_TRANSFORMATION,

  T_CURSOR_SHARING_EXACT,

  T_NO_PX_JOIN_FILTER,
  T_PX_PART_JOIN_FILTER,
  T_NO_PX_PART_JOIN_FILTER,

  T_PRED_DEDUCE,
  T_NO_PRED_DEDUCE,
  T_PUSH_PRED_CTE,
  T_NO_PUSH_PRED_CTE,

  T_TRANS_PARAM,
  T_MERGE_RESOURCE_POOL,

  T_ALTER_TABLESPACE,
  T_TABLESPACE_OPTION_LIST,

  T_IS_TENANT_SYS_POOL,
  T_DUMP_MEMORY,
  T_FORCE_REFRESH_LOCATION_CACHE,
  T_PROFILE_VERIFY_FUNCTION_NAME,
  T_ADMIN_ROLLING_UPGRADE_CMD,
  T_ALTER_INDEX_OPTION_ORACLE,

  T_PIVOT,//check
  T_UNPIVOT,
  T_PIVOT_AGGR_LIST,
  T_PIVOT_AGGR,
  T_PIVOT_IN_LIST,
  T_PIVOT_IN,
  T_UNPIVOT_IN_LIST,
  T_UNPIVOT_IN,
  T_USE_SUBPARTITION,
  T_ROOTSERVICE_LIST,
  T_CLUSTER_OPTIONS,

  T_SP_CREATE_TYPE_BODY,
  T_SP_CREATE_TYPE_BODY_SRC,
  T_SP_CONTRUCTOR_DEF_IN_TYPE,
  T_SP_OBJECT_BODY_DEF,
  T_SP_CREATE_TYPE_SRC,
  T_SP_OBJ_ELEMENT_SPEC_LIST,
  T_FETCH_CLAUSE, //use to support fetch next rows only
  T_FETCH_TIES_CLAUSE, //use to support fetch next rows with tie
  T_DBLINK_NAME,
  T_CREATE_DBLINK,
  T_REVERSE_DBLINK,
  T_DROP_DBLINK,
  T_ALTER_DBLINK,
  T_LABEL_LIST,
  T_PRIMARY_ROOTSERVICE_LIST,
  T_ALTER_USER,
  T_ALTER_USER_DEFAULT_ROLE,
  T_DEFAULT_ROLE,
  T_REVERSE,
  T_AUTO,
  T_AUTO_PARTITION,

  // sql throttling
  T_ENABLE_SQL_THROTTLE,
  T_DISABLE_SQL_THROTTLE,
  T_RT,
  T_CPU,
  T_IO,
  T_NETWORK,
  T_LOGICAL_READS,
  T_QUEUE_TIME,
  T_SQL_THROTTLE_METRICS,
  T_BACKUP_SET_ENCRYPTION,
  T_BACKUP_SET_DECRYPTION,
  T_GROUPING_SETS_LIST,
  T_CUBE_LIST,
  T_MODIFY_READ_TRANSPORT,
  T_SET_PROTECT_MODE,
  T_INTACT_FAILOVER,
  T_RECOVERY_CONTROL,
  T_INDEX_ALTER_PARALLEL,

  T_CREATE_RESTORE_POINT,
  T_DROP_RESTORE_POINT,

  T_ADMIN_RUN_UPGRADE_JOB,
  T_ADMIN_STOP_UPGRADE_JOB,

  T_ALTER_USER_PRIMARY_ZONE,

  T_HASH_SUBPARTITION_LIST,
  T_RANGE_SUBPARTITION_LIST,
  T_LIST_SUBPARTITION_LIST,
  T_HASH_PARTITION_LIST,
  T_RANGE_PARTITION_LIST,
  T_LIST_PARTITION_LIST,

  T_FLUSH_DAG_WARNINGS,

  T_MULTI_INSERT,//used to support multi table insert
  T_INSERT_TABLE_LIST,//used to support multi table insert
  T_MULTI_TABLE_INSERT,//used to support multi table insert
  T_MULTI_CONDITION_INSERT,//used to support multi table insert
  T_CONDITIION_INSERT_LIST,//used to support multi table insert
  T_CONDITION_INSERT,//used to support multi table insert
  T_SINGLE_INSERT,//used to support multi table insert

  T_GENERATED_COLUMN,
  T_CONSTR_ALWAYS,
  T_IDENTITY_COLUMN,

  T_METHOD_OPT,
  T_METHOD_OPT_LIST,
  T_FOR_ALL,
  T_FOR_COLUMNS,
  T_FOR_COLUMN_ITEM,
  T_EXTENSION,
  T_FOR_COLUMN_LIST,
  T_SORTKEY,

  T_SP_OPAQUE_DEF,

  T_SP_PRE_STMTS,
  T_SP_PRE_IF,
  T_SP_PRE_ELSE,

  T_PLSQL_VARIABLE_IDENTIFIER,

  T_SP_ERROR,

  T_PRIMARY_KEY_DROP,
  T_PRIMARY_KEY_ALTER,
  T_BACKUP_BACKUPSET,
  T_BACKUP_ARCHIVELOG,
  T_COPY_ID,
  T_CREATE_DIRECTORY,
  T_DROP_DIRECTORY,
  T_BACKUP_BACKUPPIECE,
  T_ADD_RESTORE_SOURCE,
  T_CLEAR_RESTORE_SOURCE,

  T_PREVIEW,

  T_TG_NEST_OF_TABLE_COLUMN,
  T_CONVERT_TO_CHARACTER,
  T_USER_RESOURCE_OPTIONS,
  T_MAX_CONNECTIONS_PER_HOUR,
  T_MAX_USER_CONNECTIONS,
  T_MAX_QUERIES_PER_HOUR,
  T_MAX_UPDATES_PER_HOUR,
  T_HAVING,
  T_MODIFY_ALL_TRIGGERS,
  T_DML_EVENT_INSERTING,
  T_DML_EVENT_DELETING,
  T_DML_EVENT_UPDATING,
  T_ENFORCED_CONSTRAINT,
  T_NOENFORCED_CONSTRAINT,
  T_INTERVAL,
  T_SET_INTERVAL,
  T_ALTER_RESOURCE_TENANT,
  T_UNIT_GROUP_ID_LIST,
  T_CREATE_CONTEXT,
  T_DROP_CONTEXT,
  T_CHECKPOINT_SLOG,
  T_PRETTY,
  T_PRETTY_COLOR,
  T_CALIBRATION_INFO_LIST,
  T_REFRESH_IO_CALIBRATION,
  T_OB_DDL_SCHEMA_VERSION,
  T_TG_ORDER,
  T_ODBC_ESCAPE_SEQUENCES,
  T_SP_DATA_ACCESS,

  // column group
  T_COLUMN_GROUP,
  T_ALL_COLUMN_GROUP,
  T_SINGLE_COLUMN_GROUP,
  T_NORMAL_COLUMN_GROUP,
  T_TRACE_FORMAT,
  T_TG_ALTER_OPTIONS,

  //for external table
  T_EXTERNAL_FILE_LOCATION,
  T_EXTERNAL_FILE_FORMAT,
  T_EXTERNAL_FILE_FORMAT_TYPE,
  T_EXTERNAL,
  T_ALTER_REFRESH_EXTERNAL_TABLE,
  T_SKIP_HEADER,
  T_SKIP_BLANK_LINE,
  T_TRIM_SPACE,
  T_NULL_IF_EXETERNAL,
  T_EMPTY_FIELD_AS_NULL,
  T_EXTERNAL_FILE_PATTERN,

  T_ADMIN_STORAGE,// used to support oss storage for clog/sstable
  T_DYNAMIC_SAMPLING,
  T_TABLE_DYNAMIC_SAMPLING,
  T_PARTITION_HASH_ELEMENT,
  T_PARTITION_LIST_ELEMENT,
  T_PARTITION_RANGE_ELEMENT,

  T_CONSTR_LOB_CHUNK_SIZE,
  T_LOB_CHUNK_SIZE,

  T_ALTER_SYSTEM_KILL, // used to support kill session in oracle

  T_LOB_STORAGE_CLAUSE,
  T_TABLE_TTL,
  T_TTL_DEFINITION,
  T_TTL_EXPR,
  T_REMOVE_TTL,
  T_KV_ATTRIBUTES,
  T_VALUES_TABLE_EXPRESSION,//used to values statement
  T_VALUES_ROW_LIST,//used to values statement
  T_LOB_INROW_THRESHOLD,
  T_TRANSFER_PARTITION, // transfer tablet manually
  T_TRANSFER_PARTITION_TO_LS,
  T_PARTITION_INFO,
  T_XML_TABLE_EXPRESSION,
  T_CREATE_FMT_OUTLINE,
  T_ALTER_FMT_OUTLINE,
  T_DROP_FMT_OUTLINE,
  T_PRIV_OBJECT,
  T_MYSQL_ANALYZE,
  T_DECORRELATE,
  T_NO_DECORRELATE,
  T_DBLINK_UDF,
  T_COLUMN_ADD_WITH_LOB_PARAMS,

  //for materialized view
  T_MV_REFRESH_INFO,
  T_MV_REFRESH_ON_CLAUSE,
  T_MV_REFRESH_METHOD,
  T_MV_REFRESH_INTERVAL,
  T_MV_REFRESH_START_EXPR,

  // for materialized view log
  T_CREATE_MLOG,
  T_MLOG_WITH,
  T_MLOG_WITH_VALUES,
  T_MLOG_WITH_SPECIAL_COLUMN_LIST,
  T_MLOG_WITH_SPECIAL_COLUMN,
  T_MLOG_WITH_REFERENCE_COLUMN,
  T_MLOG_WITH_PRIMARY_KEY,
  T_MLOG_WITH_ROWID,
  T_MLOG_WITH_SEQUENCE,
  T_MLOG_NEW_VALUES,
  T_MLOG_INCLUDING_NEW_VALUES,
  T_MLOG_EXCLUDING_NEW_VALUES,
  T_MLOG_PURGE,
  T_MLOG_PURGE_IMMEDIATE,
  T_MLOG_PURGE_IMMEDIATE_SYNC,
  T_MLOG_PURGE_IMMEDIATE_ASYNC,
  T_MLOG_PURGE_START_NEXT,
  T_MLOG_PURGE_START_TIME_EXPR,
  T_DROP_MLOG,

  T_COL_SKIP_INDEX,
  T_COL_SKIP_INDEX_LIST,
  T_COL_SKIP_INDEX_MIN_MAX,
  T_COL_SKIP_INDEX_SUM,
  T_ALTER_SYSTEM_RESET,
  T_ALTER_SYSTEM_RESET_PARAMETER,

  //tenant clone
  T_CREATE_TENANT_SNAPSHOT,
  T_DROP_TENANT_SNAPSHOT,
  T_CLONE_TENANT,
  T_CANCEL_CLONE,

  // fulltext index
  T_FUN_MATCH_AGAINST,
  T_ROW_ITER_EXPR,
  T_FULLTEXT_COLUMN_LIST,
  T_MATCH_COLUMN_LIST,

  T_USE_COLUMN_STORE_HINT,
  T_NO_USE_COLUMN_STORE_HINT,
  T_REBUILD_COLUMN_STORE,
  T_COLUMN_GROUP_ADD,
  T_COLUMN_GROUP_DROP,
  T_ALTER_COLUMN_GROUP_OPTION,
  T_BLOCKING,
  T_PQ_SUBQUERY,
  T_FLUSH_PRIVILEGES,
  T_SCHEMA_ID,
  T_CANCEL_TRANSFER_PARTITION,
  T_CANCEL_BALANCE_JOB,
  T_AUTO_SPLIT_TABLET_SIZE,

  T_DATA_DISK_SIZE,
  T_ADD_LS_REPLICA,
  T_REMOVE_LS_REPLICA,
  T_MIGRATE_LS_REPLICA,
  T_MODIFY_LS_REPLICA_TYPE,
  T_MODIFY_LS_PAXOS_REPLICA_NUM,
  T_CANCEL_LS_REPLICA_TASK,
  T_COALESCE_AGGR,
  T_NO_COALESCE_AGGR,
  T_AUTO_INCREMENT_CACHE_SIZE,

  T_IGNORE_UNKNOWN_USER,
  T_SHOW_PROFILE,
  T_ALTER_TABLE_FORCE,
  T_MAX //Attention: add a new type before T_MAX
} ObItemType;

typedef enum ObCacheType
{
  CACHE_TYPE_INVALID = -1, //Attention: add a new type after CACHE_TYPE_INVALID
  CACHE_TYPE_ALL,
  CACHE_TYPE_COLUMN_STAT,
  CACHE_TYPE_BLOCK_INDEX,
  CACHE_TYPE_BLOCK,
  CACHE_TYPE_ROW,
  CACHE_TYPE_BLOOM_FILTER,
  CACHE_TYPE_PLAN,
  CACHE_TYPE_LOCATION,
  CACHE_TYPE_CLOG,
  CACHE_TYPE_ILOG,
  CACHE_TYPE_SCHEMA,
  CACHE_TYPE_BALANCE,
  CACHE_TYPE_SQL_AUDIT,
  CACHE_TYPE_PL_OBJ,
  CACHE_TYPE_PS_OBJ,
  CACHE_TYPE_LIB_CACHE,
  CACHE_TYPE_MAX //Attention: add a new type before CACHE_TYPE_MAX
} ObCacheType;

typedef enum ObContextType {
    ACCESSED_LOCALLY = 0,
    INITIALIZED_EXTERNALLY = 1,
    ACCESSED_GLOBALLY = 2,
    INITIALIZED_GLOBALLY = 3,
  }ObContextType;

#define IS_BOOL_OP(op) \
  (((op) >= T_OP_EQ && (op) <= T_OP_NOT_IN && (op) != T_OP_POW) \
    || ((op) == T_OP_EXISTS) \
    || ((op) == T_OP_NOT_EXISTS) \
    || ((op) == T_FUN_SYS_STRCMP) \
    || ((op) == T_FUN_SYS_JSON_VALID) \
    || ((op) == T_FUN_SYS_JSON_CONTAINS) \
    || ((op) == T_FUN_SYS_JSON_MEMBER_OF) \
    || ((op) == T_FUN_SYS_JSON_OVERLAPS) \
    || ((op) == T_FUN_SYS_JSON_CONTAINS) \
    || ((op) == T_FUN_SYS_JSON_CONTAINS_PATH) \
    || ((op) == T_FUN_SYS_JSON_EQUAL) \
    || ((op) == T_FUN_SYS_IS_JSON) \
    || ((op) == T_FUN_SYS_JSON_EXISTS) \
    || ((op) == T_BOOL) \
    || ((op) == T_OP_XOR) \
    || ((op) == T_FUN_SYS_IS_UUID) \
    || ((op) == T_FUN_SYS_ST_CONTAINS) \
    || ((op) == T_FUN_SYS_ST_WITHIN) \
    || ((op) == T_FUN_SYS_ST_DWITHIN) \
    || ((op) == T_FUN_SYS_ST_INTERSECTS) \
    || ((op) == T_FUN_SYS_ST_COVERS)) \

//in oracle mode, only lists exprs can accept bool(tinyint) param
#define ALLOW_BOOL_INPUT(op) \
  ((IS_BOOL_OP((op))) \
    || ((op) == T_FUN_COLUMN_CONV) \
    || ((op) == T_FUN_PL_COLLECTION_CONSTRUCT) \
    || ((op) == T_FUN_PL_INTEGER_CHECKER) \
    || ((op) == T_FUN_SYS_CAST) \
    || ((op) == T_FUN_SYS_LNNVL) \
    || ((op) == T_FUN_SYS_NVL) \
    || ((op) == T_FUN_UDF) \
    || ((op) == T_OP_ARG_CASE) \
    || ((op) == T_OP_CASE) \
    || ((op) == T_OP_OUTPUT_PACK) \
    || ((op) == T_FUN_SYS_JSON_OBJECT) \
    || ((op) == T_FUN_SYS_JSON_ARRAY) \
    || ((op) == T_OP_TO_OUTFILE_ROW)) \



#define IS_RANGE_CMP_OP(op) ((op) >= T_OP_LE && (op) <= T_OP_GT)
// we will extract query range from following OP expressions
// between and, in, is null will be converted to them
#define IS_BASIC_CMP_OP(op) (((op) >= T_OP_EQ && (op) <= T_OP_GT) || ((op) == T_OP_LIKE))
#define IS_STRICT_OP(op) ((IS_BASIC_CMP_OP(op) && (op) != T_OP_NSEQ) || ((op) == T_OP_NE))
#define IS_EXPR_OP(op) ((op) > T_MIN_OP && (op) < T_MAX_OP)
#define IS_CONST_LITERAL(op) (((op) > T_INVALID && (op) < T_MAX_CONST && (op) != T_QUESTIONMARK) || T_USER_VARIABLE_IDENTIFIER == op)
#define IS_DATATYPE_OP(op) (T_INVALID < (op) && (op) < T_MAX_CONST && T_EXTEND != (op) && T_QUESTIONMARK != (op))
#define IS_DATATYPE_OR_QUESTIONMARK_OP(op) (T_INVALID < (op) && (op) < T_MAX_CONST && T_EXTEND != (op))
#define IS_NUMBER_TC_OP(op) (T_NUMBER == (op) || T_UNUMBER == (op))
#define IS_STRING_TC_OP(op) (T_VARCHAR == (op) || T_CHAR == (op) || T_VARBINARY == (op) || T_BINARY == (op))
#define IS_SINGLE_VALUE_OP(op) (T_OP_EQ == (op) || T_OP_NSEQ == (op) || T_OP_IN == (op))
#define IS_CONST_TYPE(op) ((op) > T_INVALID && (op) < T_MAX_CONST)
#define IS_FUN_SYS_TYPE(op) (((op) >= T_FUN_SYS && (op) < T_FUN_SYS_END) \
                            || ((op) > T_MIN_OP && (op) <= T_OP_CONST_VAL) \
                            || T_OP_CONNECT_BY_ROOT == (op) \
                            || (lib::is_oracle_mode() && (op) == T_OP_BIT_AND))

#define IS_FUN_STYLE(op) (((op) >= T_FUN_SYS && (op) < T_FUN_SYS_END) \
    || ((op) >= T_FUN_MAX && (op) <= T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS_MERGE) \
    || T_OP_ABS == (op) \
    || T_OP_MOD == (op) \
    || T_OP_POW == (op) \
    || T_OP_CONV == (op) \
    || T_OP_CNN == (op) \
    || T_OP_SIGN == (op) \
    || T_OP_CONNECT_BY_ROOT == (op))

#define ITEM_TO_OBJ_TYPE(op) (static_cast<ObObjType>(op))

#define IS_COMPARISON_OP(op)                            \
  (((op) >= T_OP_EQ && (op) <= T_OP_NE)                 \
   || ((op) >= T_OP_SQ_EQ && (op) <= T_OP_SQ_NE)        \
   || ((op) == T_OP_IN) || ((op) == T_OP_NOT_IN))
#define IS_COMMON_COMPARISON_OP(op) ((op) >= T_OP_EQ && (op) <= T_OP_NE)
#define IS_SUBQUERY_COMPARISON_OP(op) ((op) >= T_OP_SQ_EQ && (op) <= T_OP_SQ_NE)
#define IS_ENUM_SET_OP(op) ((op) >= T_FUN_ENUM_TO_STR && (op) <= T_FUN_SET_TO_INNER_TYPE)

// special statements
#define IS_TRANSACTION_STMT(op) ((op) == T_BEGIN || (op) == T_COMMIT || (op) == T_ROLLBACK)
#define IS_PREPARABLE_STMT(op)  \
  ((op) == T_SELECT || (op) == T_DELETE || (op) == T_INSERT || (op) == T_MERGE || (op) == T_UPDATE \
   || (op) == T_BEGIN || (op) == T_COMMIT || (op) == T_ROLLBACK)

#define IS_DML_STMT(op)  \
  ((op) == T_SELECT || (op) == T_DELETE || (op) == T_INSERT || (op) == T_MERGE || (op) == T_UPDATE || (op) == T_MULTI_INSERT)
#define IS_SHOW_STMT(op) (((op) >= T_SHOW_TABLES && (op) <= T_SHOW_GRANTS) || (op) == T_SHOW_TRIGGERS)

#define EXPR_OP_NUM (T_MAX_OP-T_MIN_OP-1)
extern const char *get_type_name(int type);

#define IS_AGGR_FUN(op) (((op) >= T_FUN_MAX && (op) <= T_FUN_APPROX_COUNT_DISTINCT_SYNOPSIS_MERGE) ||\
                         ((op) >= T_FUN_CORR && (op) <= T_FUN_REGR_SXY) ||  \
                         ((op) >= T_FUN_GROUP_RANK && (op) <= T_FUN_GROUP_PERCENTILE_DISC) ||\
                         (op) == T_FUN_GROUPING || (op) == T_FUN_KEEP_WM_CONCAT ||\
                         (op) == T_FUN_WM_CONCAT || (op) == T_FUN_PL_AGG_UDF || \
                         (op) == T_FUN_TOP_FRE_HIST || (op) == T_FUN_HYBRID_HIST || \
                         (op) == T_FUN_AGG_UDF || (op) == T_FUN_GROUPING_ID || \
                         (op) == T_FUN_JSON_ARRAYAGG || (op) == T_FUN_JSON_OBJECTAGG ||\
                         (op) == T_FUN_ORA_JSON_ARRAYAGG || (op) == T_FUN_ORA_JSON_OBJECTAGG ||\
                         (op) == T_FUN_GROUP_ID || \
                         (op) == T_FUN_ORA_XMLAGG || \
                         ((op) >= T_FUN_SYS_BIT_AND && (op) <= T_FUN_SYS_BIT_XOR))
#define MAYBE_ROW_OP(op) ((op) >= T_OP_EQ && (op) <= T_OP_NE)
#define IS_PSEUDO_COLUMN_TYPE(op) \
  ((op) == T_LEVEL || (op) == T_CONNECT_BY_ISLEAF || (op) == T_CONNECT_BY_ISCYCLE || (op) == T_ORA_ROWSCN)

#define IS_LABEL_SE_POLICY_FUNC(op) \
  (T_FUN_LABEL_SE_POLICY_CREATE <= (op) && (op) <= T_FUN_LABEL_SE_LABEL_DROP)

#define IS_KEEP_AGGR_FUN(op) ((op) >= T_FUN_KEEP_MAX && (op) <= T_FUN_KEEP_STDDEV)


/**
 * @notice: 目前只支持IS_BASIC_CMP_OP这个宏里定义的op type，如果有在这之外的需求，请扩展这个接口的实现
 * */
inline ObItemType get_opposite_compare_type(ObItemType src_type)
{
  ObItemType ret_type = src_type;
  switch (src_type) {
    case T_OP_LT:
      ret_type = T_OP_GT;
      break;
    case T_OP_GT:
      ret_type = T_OP_LT;
      break;
    case T_OP_LE:
      ret_type = T_OP_GE;
      break;
    case T_OP_GE:
      ret_type = T_OP_LE;
      break;
    case T_OP_EXISTS:
      ret_type = T_OP_NOT_EXISTS;
      break;
    case T_OP_NOT_EXISTS:
      ret_type = T_OP_EXISTS;
      break;
    default:
      ret_type = src_type;
      break;
  }
  return ret_type;
}

#ifdef __cplusplus
}
#ifndef SQL_PARSER_COMPILATION
#include "lib/utility/ob_print_utils.h"
namespace oceanbase
{
namespace common
{
template<>
inline int databuff_print_obj(char *buf, const int64_t buf_len, int64_t &pos,
                              const ObItemType &obj)
{
  //ignore ret value on purpose;if failed, the string will be truncated
  return databuff_printf(buf, buf_len, pos, "\"%s\"", get_type_name(obj));
}

template<>
inline int databuff_print_key_obj(char *buf, const int64_t buf_len, int64_t &pos, const char *key,
                                  const bool with_comma, const ObItemType &obj)
{
  return databuff_printf(buf, buf_len, pos, WITH_COMMA("%s:\"%s\""), key, get_type_name(obj));
}
}  // namespace common
} // end namespace oceanbase
#endif // SQL_PARSER_COMPILATION
#endif //__cplusplus
#endif //OCEANBASE_SQL_OB_ITEM_TYPE_H_
