/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"reflect"
)


// PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPI service
type PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService service

type PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest struct {
	ctx context.Context
	ApiService *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService
	distroBasePath string
	deprecated *bool
	name *string
	namespace *string
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	fields *[]string
	excludeFields *[]string
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) Deprecated(deprecated bool) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.deprecated = &deprecated
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) Name(name string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.name = &name
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) Namespace(namespace string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.namespace = &namespace
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;namespace&#x60; - Namespace * &#x60;-namespace&#x60; - Namespace (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) Ordering(ordering []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) PulpHrefIn(pulpHrefIn []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) PulpIdIn(pulpIdIn []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// A list of fields to include in the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) Fields(fields []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) ExcludeFields(excludeFields []string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) Execute() ([]CollectionResponse, *http.Response, error) {
	return r.ApiService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListExecute(r)
}

/*
PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsList Method for PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsList

Unpaginated ViewSet for Collections.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param distroBasePath
 @return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest
*/
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsList(ctx context.Context, distroBasePath string) PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest {
	return PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest{
		ApiService: a,
		ctx: ctx,
		distroBasePath: distroBasePath,
	}
}

// Execute executes the request
//  @return []CollectionResponse
func (a *PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService) PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListExecute(r PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIPulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsListRequest) ([]CollectionResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  []CollectionResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "PulpAnsibleDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsAPIService.PulpAnsibleGalaxyDefaultApiV3PluginAnsibleContentCollectionsAllCollectionsList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp_ansible/galaxy/default/api/v3/plugin/ansible/content/{distro_base_path}/collections/all-collections/"
	localVarPath = strings.Replace(localVarPath, "{"+"distro_base_path"+"}", parameterValueToString(r.distroBasePath, "distroBasePath"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.deprecated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "deprecated", r.deprecated, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.namespace != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "namespace", r.namespace, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
