/*
Pulp 3 API

Fetch, Upload, Organize, and Distribute Software Packages

API version: v3
Contact: pulp-list@redhat.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package pulpclient

import (
	"bytes"
	"context"
	"io"
	"net/http"
	"net/url"
	"strings"
	"time"
	"reflect"
)


// RemotesRoleAPIService RemotesRoleAPI service
type RemotesRoleAPIService service

type RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
	nestedRole *NestedRole
}

func (r RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest) NestedRole(nestedRole NestedRole) RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleAddRoleExecute(r)
}

/*
RemotesAnsibleRoleAddRole Method for RemotesAnsibleRoleAddRole

Add a role for this object to users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleAddRole(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest {
	return RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleAddRoleExecute(r RemotesRoleAPIRemotesAnsibleRoleAddRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleAddRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}add_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleCreateRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemote *AnsibleRoleRemote
}

func (r RemotesRoleAPIRemotesAnsibleRoleCreateRequest) AnsibleRoleRemote(ansibleRoleRemote AnsibleRoleRemote) RemotesRoleAPIRemotesAnsibleRoleCreateRequest {
	r.ansibleRoleRemote = &ansibleRoleRemote
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleCreateRequest) Execute() (*AnsibleRoleRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleCreateExecute(r)
}

/*
RemotesAnsibleRoleCreate Create a role remote

ViewSet for Role Remotes.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesRoleAPIRemotesAnsibleRoleCreateRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleCreate(ctx context.Context) RemotesRoleAPIRemotesAnsibleRoleCreateRequest {
	return RemotesRoleAPIRemotesAnsibleRoleCreateRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return AnsibleRoleRemoteResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleCreateExecute(r RemotesRoleAPIRemotesAnsibleRoleCreateRequest) (*AnsibleRoleRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleRoleRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleCreate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/ansible/role/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRoleRemote == nil {
		return localVarReturnValue, nil, reportError("ansibleRoleRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRoleRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleDeleteRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
}

func (r RemotesRoleAPIRemotesAnsibleRoleDeleteRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleDeleteExecute(r)
}

/*
RemotesAnsibleRoleDelete Delete a role remote

Trigger an asynchronous delete task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRoleDeleteRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleDelete(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRoleDeleteRequest {
	return RemotesRoleAPIRemotesAnsibleRoleDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleDeleteExecute(r RemotesRoleAPIRemotesAnsibleRoleDeleteRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodDelete
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleDelete")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleListRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	limit *int32
	name *string
	nameContains *string
	nameIcontains *string
	nameIn *[]string
	nameStartswith *string
	offset *int32
	ordering *[]string
	pulpHrefIn *[]string
	pulpIdIn *[]string
	pulpLabelSelect *string
	pulpLastUpdated *time.Time
	pulpLastUpdatedGt *time.Time
	pulpLastUpdatedGte *time.Time
	pulpLastUpdatedLt *time.Time
	pulpLastUpdatedLte *time.Time
	pulpLastUpdatedRange *[]time.Time
	fields *[]string
	excludeFields *[]string
}

// Number of results to return per page.
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) Limit(limit int32) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.limit = &limit
	return r
}

// Filter results where name matches value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) Name(name string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.name = &name
	return r
}

// Filter results where name contains value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) NameContains(nameContains string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.nameContains = &nameContains
	return r
}

// Filter results where name contains value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) NameIcontains(nameIcontains string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.nameIcontains = &nameIcontains
	return r
}

// Filter results where name is in a comma-separated list of values
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) NameIn(nameIn []string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.nameIn = &nameIn
	return r
}

// Filter results where name starts with value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) NameStartswith(nameStartswith string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.nameStartswith = &nameStartswith
	return r
}

// The initial index from which to return the results.
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) Offset(offset int32) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.offset = &offset
	return r
}

// Ordering  * &#x60;pulp_id&#x60; - Pulp id * &#x60;-pulp_id&#x60; - Pulp id (descending) * &#x60;pulp_created&#x60; - Pulp created * &#x60;-pulp_created&#x60; - Pulp created (descending) * &#x60;pulp_last_updated&#x60; - Pulp last updated * &#x60;-pulp_last_updated&#x60; - Pulp last updated (descending) * &#x60;pulp_type&#x60; - Pulp type * &#x60;-pulp_type&#x60; - Pulp type (descending) * &#x60;name&#x60; - Name * &#x60;-name&#x60; - Name (descending) * &#x60;pulp_labels&#x60; - Pulp labels * &#x60;-pulp_labels&#x60; - Pulp labels (descending) * &#x60;url&#x60; - Url * &#x60;-url&#x60; - Url (descending) * &#x60;ca_cert&#x60; - Ca cert * &#x60;-ca_cert&#x60; - Ca cert (descending) * &#x60;client_cert&#x60; - Client cert * &#x60;-client_cert&#x60; - Client cert (descending) * &#x60;client_key&#x60; - Client key * &#x60;-client_key&#x60; - Client key (descending) * &#x60;tls_validation&#x60; - Tls validation * &#x60;-tls_validation&#x60; - Tls validation (descending) * &#x60;username&#x60; - Username * &#x60;-username&#x60; - Username (descending) * &#x60;password&#x60; - Password * &#x60;-password&#x60; - Password (descending) * &#x60;proxy_url&#x60; - Proxy url * &#x60;-proxy_url&#x60; - Proxy url (descending) * &#x60;proxy_username&#x60; - Proxy username * &#x60;-proxy_username&#x60; - Proxy username (descending) * &#x60;proxy_password&#x60; - Proxy password * &#x60;-proxy_password&#x60; - Proxy password (descending) * &#x60;download_concurrency&#x60; - Download concurrency * &#x60;-download_concurrency&#x60; - Download concurrency (descending) * &#x60;max_retries&#x60; - Max retries * &#x60;-max_retries&#x60; - Max retries (descending) * &#x60;policy&#x60; - Policy * &#x60;-policy&#x60; - Policy (descending) * &#x60;total_timeout&#x60; - Total timeout * &#x60;-total_timeout&#x60; - Total timeout (descending) * &#x60;connect_timeout&#x60; - Connect timeout * &#x60;-connect_timeout&#x60; - Connect timeout (descending) * &#x60;sock_connect_timeout&#x60; - Sock connect timeout * &#x60;-sock_connect_timeout&#x60; - Sock connect timeout (descending) * &#x60;sock_read_timeout&#x60; - Sock read timeout * &#x60;-sock_read_timeout&#x60; - Sock read timeout (descending) * &#x60;headers&#x60; - Headers * &#x60;-headers&#x60; - Headers (descending) * &#x60;rate_limit&#x60; - Rate limit * &#x60;-rate_limit&#x60; - Rate limit (descending) * &#x60;pk&#x60; - Pk * &#x60;-pk&#x60; - Pk (descending)
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) Ordering(ordering []string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.ordering = &ordering
	return r
}

// Multiple values may be separated by commas.
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpHrefIn(pulpHrefIn []string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpHrefIn = &pulpHrefIn
	return r
}

// Multiple values may be separated by commas.
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpIdIn(pulpIdIn []string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpIdIn = &pulpIdIn
	return r
}

// Filter labels by search string
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpLabelSelect(pulpLabelSelect string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpLabelSelect = &pulpLabelSelect
	return r
}

// Filter results where pulp_last_updated matches value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpLastUpdated(pulpLastUpdated time.Time) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpLastUpdated = &pulpLastUpdated
	return r
}

// Filter results where pulp_last_updated is greater than value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpLastUpdatedGt(pulpLastUpdatedGt time.Time) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpLastUpdatedGt = &pulpLastUpdatedGt
	return r
}

// Filter results where pulp_last_updated is greater than or equal to value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpLastUpdatedGte(pulpLastUpdatedGte time.Time) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpLastUpdatedGte = &pulpLastUpdatedGte
	return r
}

// Filter results where pulp_last_updated is less than value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpLastUpdatedLt(pulpLastUpdatedLt time.Time) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpLastUpdatedLt = &pulpLastUpdatedLt
	return r
}

// Filter results where pulp_last_updated is less than or equal to value
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpLastUpdatedLte(pulpLastUpdatedLte time.Time) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpLastUpdatedLte = &pulpLastUpdatedLte
	return r
}

// Filter results where pulp_last_updated is between two comma separated values
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) PulpLastUpdatedRange(pulpLastUpdatedRange []time.Time) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.pulpLastUpdatedRange = &pulpLastUpdatedRange
	return r
}

// A list of fields to include in the response.
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) Fields(fields []string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) ExcludeFields(excludeFields []string) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleListRequest) Execute() (*PaginatedansibleRoleRemoteResponseList, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleListExecute(r)
}

/*
RemotesAnsibleRoleList List role remotes

ViewSet for Role Remotes.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @return RemotesRoleAPIRemotesAnsibleRoleListRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleList(ctx context.Context) RemotesRoleAPIRemotesAnsibleRoleListRequest {
	return RemotesRoleAPIRemotesAnsibleRoleListRequest{
		ApiService: a,
		ctx: ctx,
	}
}

// Execute executes the request
//  @return PaginatedansibleRoleRemoteResponseList
func (a *RemotesRoleAPIService) RemotesAnsibleRoleListExecute(r RemotesRoleAPIRemotesAnsibleRoleListRequest) (*PaginatedansibleRoleRemoteResponseList, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *PaginatedansibleRoleRemoteResponseList
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleList")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/pulp/api/v3/remotes/ansible/role/"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.limit != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "limit", r.limit, "")
	}
	if r.name != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name", r.name, "")
	}
	if r.nameContains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__contains", r.nameContains, "")
	}
	if r.nameIcontains != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__icontains", r.nameIcontains, "")
	}
	if r.nameIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__in", r.nameIn, "csv")
	}
	if r.nameStartswith != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "name__startswith", r.nameStartswith, "")
	}
	if r.offset != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "offset", r.offset, "")
	}
	if r.ordering != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "ordering", r.ordering, "csv")
	}
	if r.pulpHrefIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_href__in", r.pulpHrefIn, "csv")
	}
	if r.pulpIdIn != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_id__in", r.pulpIdIn, "csv")
	}
	if r.pulpLabelSelect != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_label_select", r.pulpLabelSelect, "")
	}
	if r.pulpLastUpdated != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated", r.pulpLastUpdated, "")
	}
	if r.pulpLastUpdatedGt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gt", r.pulpLastUpdatedGt, "")
	}
	if r.pulpLastUpdatedGte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__gte", r.pulpLastUpdatedGte, "")
	}
	if r.pulpLastUpdatedLt != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lt", r.pulpLastUpdatedLt, "")
	}
	if r.pulpLastUpdatedLte != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__lte", r.pulpLastUpdatedLte, "")
	}
	if r.pulpLastUpdatedRange != nil {
		parameterAddToHeaderOrQuery(localVarQueryParams, "pulp_last_updated__range", r.pulpLastUpdatedRange, "csv")
	}
	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleListRolesRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesRoleAPIRemotesAnsibleRoleListRolesRequest) Fields(fields []string) RemotesRoleAPIRemotesAnsibleRoleListRolesRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesRoleAPIRemotesAnsibleRoleListRolesRequest) ExcludeFields(excludeFields []string) RemotesRoleAPIRemotesAnsibleRoleListRolesRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleListRolesRequest) Execute() (*ObjectRolesResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleListRolesExecute(r)
}

/*
RemotesAnsibleRoleListRoles Method for RemotesAnsibleRoleListRoles

List roles assigned to this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRoleListRolesRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleListRoles(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRoleListRolesRequest {
	return RemotesRoleAPIRemotesAnsibleRoleListRolesRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return ObjectRolesResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleListRolesExecute(r RemotesRoleAPIRemotesAnsibleRoleListRolesRequest) (*ObjectRolesResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *ObjectRolesResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleListRoles")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}list_roles/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest) Fields(fields []string) RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest) ExcludeFields(excludeFields []string) RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest) Execute() (*MyPermissionsResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleMyPermissionsExecute(r)
}

/*
RemotesAnsibleRoleMyPermissions Method for RemotesAnsibleRoleMyPermissions

List permissions available to the current user on this object.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleMyPermissions(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest {
	return RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return MyPermissionsResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleMyPermissionsExecute(r RemotesRoleAPIRemotesAnsibleRoleMyPermissionsRequest) (*MyPermissionsResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *MyPermissionsResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleMyPermissions")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}my_permissions/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
	patchedansibleRoleRemote *PatchedansibleRoleRemote
}

func (r RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest) PatchedansibleRoleRemote(patchedansibleRoleRemote PatchedansibleRoleRemote) RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest {
	r.patchedansibleRoleRemote = &patchedansibleRoleRemote
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRolePartialUpdateExecute(r)
}

/*
RemotesAnsibleRolePartialUpdate Update a role remote

Trigger an asynchronous partial update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRolePartialUpdate(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest {
	return RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRolePartialUpdateExecute(r RemotesRoleAPIRemotesAnsibleRolePartialUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPatch
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRolePartialUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.patchedansibleRoleRemote == nil {
		return localVarReturnValue, nil, reportError("patchedansibleRoleRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.patchedansibleRoleRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleReadRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
	fields *[]string
	excludeFields *[]string
}

// A list of fields to include in the response.
func (r RemotesRoleAPIRemotesAnsibleRoleReadRequest) Fields(fields []string) RemotesRoleAPIRemotesAnsibleRoleReadRequest {
	r.fields = &fields
	return r
}

// A list of fields to exclude from the response.
func (r RemotesRoleAPIRemotesAnsibleRoleReadRequest) ExcludeFields(excludeFields []string) RemotesRoleAPIRemotesAnsibleRoleReadRequest {
	r.excludeFields = &excludeFields
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleReadRequest) Execute() (*AnsibleRoleRemoteResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleReadExecute(r)
}

/*
RemotesAnsibleRoleRead Inspect a role remote

ViewSet for Role Remotes.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRoleReadRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleRead(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRoleReadRequest {
	return RemotesRoleAPIRemotesAnsibleRoleReadRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return AnsibleRoleRemoteResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleReadExecute(r RemotesRoleAPIRemotesAnsibleRoleReadRequest) (*AnsibleRoleRemoteResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodGet
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AnsibleRoleRemoteResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleRead")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}

	if r.fields != nil {
		t := *r.fields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "fields", t, "multi")
		}
	}
	if r.excludeFields != nil {
		t := *r.excludeFields
		if reflect.TypeOf(t).Kind() == reflect.Slice {
			s := reflect.ValueOf(t)
			for i := 0; i < s.Len(); i++ {
				parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", s.Index(i), "multi")
			}
		} else {
			parameterAddToHeaderOrQuery(localVarQueryParams, "exclude_fields", t, "multi")
		}
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
	nestedRole *NestedRole
}

func (r RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest) NestedRole(nestedRole NestedRole) RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest {
	r.nestedRole = &nestedRole
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest) Execute() (*NestedRoleResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleRemoveRoleExecute(r)
}

/*
RemotesAnsibleRoleRemoveRole Method for RemotesAnsibleRoleRemoveRole

Remove a role for this object from users/groups.

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleRemoveRole(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest {
	return RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return NestedRoleResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleRemoveRoleExecute(r RemotesRoleAPIRemotesAnsibleRoleRemoveRoleRequest) (*NestedRoleResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPost
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *NestedRoleResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleRemoveRole")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}remove_role/"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.nestedRole == nil {
		return localVarReturnValue, nil, reportError("nestedRole is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.nestedRole
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}

type RemotesRoleAPIRemotesAnsibleRoleUpdateRequest struct {
	ctx context.Context
	ApiService *RemotesRoleAPIService
	ansibleRoleRemoteHref string
	ansibleRoleRemote *AnsibleRoleRemote
}

func (r RemotesRoleAPIRemotesAnsibleRoleUpdateRequest) AnsibleRoleRemote(ansibleRoleRemote AnsibleRoleRemote) RemotesRoleAPIRemotesAnsibleRoleUpdateRequest {
	r.ansibleRoleRemote = &ansibleRoleRemote
	return r
}

func (r RemotesRoleAPIRemotesAnsibleRoleUpdateRequest) Execute() (*AsyncOperationResponse, *http.Response, error) {
	return r.ApiService.RemotesAnsibleRoleUpdateExecute(r)
}

/*
RemotesAnsibleRoleUpdate Update a role remote

Trigger an asynchronous update task

 @param ctx context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 @param ansibleRoleRemoteHref
 @return RemotesRoleAPIRemotesAnsibleRoleUpdateRequest
*/
func (a *RemotesRoleAPIService) RemotesAnsibleRoleUpdate(ctx context.Context, ansibleRoleRemoteHref string) RemotesRoleAPIRemotesAnsibleRoleUpdateRequest {
	return RemotesRoleAPIRemotesAnsibleRoleUpdateRequest{
		ApiService: a,
		ctx: ctx,
		ansibleRoleRemoteHref: ansibleRoleRemoteHref,
	}
}

// Execute executes the request
//  @return AsyncOperationResponse
func (a *RemotesRoleAPIService) RemotesAnsibleRoleUpdateExecute(r RemotesRoleAPIRemotesAnsibleRoleUpdateRequest) (*AsyncOperationResponse, *http.Response, error) {
	var (
		localVarHTTPMethod   = http.MethodPut
		localVarPostBody     interface{}
		formFiles            []formFile
		localVarReturnValue  *AsyncOperationResponse
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "RemotesRoleAPIService.RemotesAnsibleRoleUpdate")
	if err != nil {
		return localVarReturnValue, nil, &GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "{ansible_role_remote_href}"
	localVarPath = strings.Replace(localVarPath, "{"+"ansible_role_remote_href"+"}", parameterValueToString(r.ansibleRoleRemoteHref, "ansibleRoleRemoteHref"), -1)  // NOTE: paths aren't escaped because Pulp uses hrefs as path parameters

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := url.Values{}
	localVarFormParams := url.Values{}
	if r.ansibleRoleRemote == nil {
		return localVarReturnValue, nil, reportError("ansibleRoleRemote is required and must be specified")
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	// body params
	localVarPostBody = r.ansibleRoleRemote
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, formFiles)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)
	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarHTTPResponse.Body = io.NopCloser(bytes.NewBuffer(localVarBody))
	if err != nil {
		return localVarReturnValue, localVarHTTPResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := &GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarHTTPResponse, newErr
	}

	return localVarReturnValue, localVarHTTPResponse, nil
}
