/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.dogtagpki.acme.ACMEAccount;
import org.dogtagpki.acme.ACMEAccountOrders;
import org.dogtagpki.acme.ACMENonce;
import org.dogtagpki.acme.ACMEOrder;
import org.dogtagpki.acme.server.ACMEEngine;
import org.dogtagpki.acme.server.ACMEManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="acct/{id}/orders")
@ACMEManagedService
public class ACMEAccountOrdersService {
    public static Logger logger = LoggerFactory.getLogger(ACMEAccountOrdersService.class);
    @Context
    UriInfo uriInfo;

    @POST
    @Produces(value={"application/json"})
    public Response getAccountOrders(@PathParam(value="id") String accountID) throws Exception {
        logger.info("Retrieving orders for account " + accountID);
        ACMEEngine engine = ACMEEngine.getInstance();
        ACMEAccount account = engine.getAccount(accountID);
        Collection<ACMEOrder> orders = engine.getOrdersByAccount(account);
        ArrayList<URI> orderURLs = new ArrayList<URI>();
        for (ACMEOrder order : orders) {
            if ("invalid".equals(order.getStatus())) continue;
            URI orderURL = this.uriInfo.getBaseUriBuilder().path("order").path(order.getID()).build(new Object[0]);
            logger.info("- " + orderURL);
            orderURLs.add(orderURL);
        }
        ACMEAccountOrders accountOrders = new ACMEAccountOrders();
        accountOrders.setOrders(orderURLs);
        Response.ResponseBuilder builder = Response.ok();
        ACMENonce nonce = engine.createNonce();
        builder.header("Replay-Nonce", (Object)nonce.getID());
        URI indexURL = this.uriInfo.getBaseUriBuilder().path("directory").build(new Object[0]);
        builder.link(indexURL, "index");
        builder.entity((Object)accountOrders);
        return builder.build();
    }
}

